<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\ProductsStoresTransfers;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class StoresTransferReportApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');





        if (!empty($this->From_Store)) {

            if ($lang == 'ar') {
                $From_Store = $this->From_Store()->first()->Name;
            } else {
                $From_Store = $this->From_Store()->first()->NameEn;
            }

        } else {
            $From_Store = '';
        }

        if (!empty($this->To_Store)) {

            if ($lang == 'ar') {
                $To_Store = $this->To_Store()->first()->Name;
            } else {
                $To_Store = $this->To_Store()->first()->NameEn;
            }

        } else {
            $To_Store = '';
        }


        if ($lang == 'ar') {
            $user = $this->User()->first()->name;
        } else {
            $user = $this->User()->first()->nameEn;
        }


        if (!empty($this->Coin)) {

            if ($lang == 'ar') {
                $Coin = $this->Coin()->first()->Arabic_Name;
            } else {
                $Coin = $this->Coin()->first()->English_Name;
            }

        } else {
            $Coin = '';
        }


        if (!empty($this->Ship)) {

            if ($lang == 'ar') {
                $Ship = $this->Ship()->first()->Name;
            } else {
                $Ship = $this->Ship()->first()->NameEn;
            }

        } else {
            $Ship = '';
        }




                if (!empty($this->Delegate)) {

                    if ($lang == 'ar') {
                        $Delegate = $this->Delegate()->first()->Name;
                    } else {
                        $Delegate = $this->Delegate()->first()->NameEn;
                    }

                } else {
                    $Delegate = '';
                }



        if (!empty($this->Branch)) {

            if ($lang == 'ar') {
                $Branch = $this->Branch()->first()->Arabic_Name;
            } else {
                $Branch = $this->Branch()->first()->English_Name;
            }

        } else {
            $Branch = '';
        }

      if ($this->Status == 0){
          $status = trans('admin.Pending');
                                    }elseif ($this->Status == 1){
$status = trans('admin.Recived');
}elseif($this->Status == 2){
    $status=trans('admin.Refused');
                                                }elseif($this->Status == 3){
    $status=trans('admin.Edited');
                         }


        $data=[

            'Date'=>$this->Date
            ,'Code'=>$this->Code
            ,'Time'=>$this->Time
            ,'From_Store'=>$From_Store
            ,'To_Store'=>$To_Store
            ,'User'=>$user
            ,'Coin'=>$Coin
            ,'Shipping'=>$Ship
            ,'Note'=>$this->Note
            ,'Delegate'=>$Delegate
            ,'Branch'=>$Branch
            ,'Type'=>$status
            ,'details'=>$this->when(!empty($this->id), function () {

                $Qtys = ProductsStoresTransfers::where('ST_ID', $this->id)->get();
                $details=ProductsStoresTransfersApiResources::collection($Qtys);

                return $details;
            }),


        ];


        return $data ;


    }

}
