<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\Measuerments;
use App\Models\ProductMoves;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\Purchases;
use App\Models\StoresDefaultData;
use App\Services\Average;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class StoresMovesReportApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');





      if (!empty($this->Branch()->first()->Arabic_Name)) {
          if ($lang == 'ar') {
              $Branch = $this->Branch()->first()->Arabic_Name;
          } else {

              $Branch = $this->Branch()->first()->Arabic_Name;
          }
      } else {

          $Branch = '';
      }

      if (!empty($this->Store()->first()->Name)) {
          if ($lang == 'ar') {
              $Store = $this->Store()->first()->Name;
          } else {

              $Store = $this->Store()->first()->NameEn;
          }
      } else {

          $Store = '';
      }

      if (!empty($this->Safe()->first()->Name)) {
          if ($lang == 'ar') {
              $Safe = $this->Safe()->first()->Name;
          } else {

              $Safe = $this->Safe()->first()->NameEn;
          }
      } else {

          $Safe = '';
      }


        if ($lang == 'ar') {
            $type = $this->Type;
        } else {

            $type = $this->TypeEn;
        }



        if (!empty($this->Cost_Center()->first()->Arabic_Name)) {
            if ($lang == 'ar') {
                $Cost_Center = $this->Cost_Center()->first()->Arabic_Name;
            } else {

                $Cost_Center = $this->Cost_Center()->first()->English_Name;
            }
        } else {

            $Cost_Center = '';
        }

        if (!empty($this->User()->first()->name)) {
            if ($lang == 'ar') {
                $User = $this->User()->first()->name;
            } else {

                $User = $this->User()->first()->nameEn;
            }
        } else {

            $User = '';
        }



        if (!empty($this->Coin()->first()->Arabic_Name)) {
            if ($lang == 'ar') {
                $Coin = $this->Coin()->first()->Arabic_Name;
            } else {

                $Coin = $this->Coin()->first()->English_Name;
            }
        } else {

            $Coin = '';
        }









      if (!empty($this->Account()->first()->Name)) {
          if ($lang == 'ar') {
              $Account = $this->Account()->first()->Name;
          } else {

              $Account = $this->Account()->first()->NameEn;
          }
      } else {

          $Account = '';
      }


      if (!empty($this->Ship()->first()->Name)) {
          if ($lang == 'ar') {
              $Ship = $this->Ship()->first()->Name;
          } else {

              $Ship = $this->Ship()->first()->NameEn;
          }
      } else {

          $Ship = '';
      }




        $data = [

            'Date' => $this->Date
            , 'Code' => $this->Code
            , 'Time' => $this->Time
            , 'Branch' => $Branch
            , 'Store' => $Store
            , 'Safe' => $Safe
            , 'Type' => $type
            , 'Cost_Center' => $Cost_Center
            , 'User' => $User
            , 'Coin' => $Coin
            , 'Note' => $this->Note
            , 'Total_Qty' => $this->Total_Qty
            , 'Total_Price' => $this->Total_Price
            , 'Account' => $Account
            , 'Ship' => $Ship


        ];


        return $data;

    }

}
