<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\DefaultDataShowHide;
use App\Models\Measuerments;
use App\Models\ProductSales;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class StagnantItemsTwoFilterApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');
        $group = $request->get('group');
        $Store = $request->get('Store');
        $From = $request->get('From');
        $To = $request->get('To');
        $Max = $request->get('Max');
        $search = $request->get('search');


        $Qty=ProductsQty::where('Product',$this->Product)

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereIn('Store',$Store);

            })

            ->get()->sum('Qty');

        $units=ProductUnits::where('Product',$this->Product)->get();
        $rr=ProductUnits::where('Product',$this->Product)->where('Def',1)->first();


        $count=ProductSales::
        where('Product',$this->Product)
            ->where('Product_Code',$this->P_Code)
            ->whereBetween('Date', [$From,$To])
            ->count();

        if($count  <= $Max){
            if($group != ''){

                if($this->Product()->first()->Group == $group){
                    $ProdsCount+=1;


                    if($this->Product()->first()->P_Type == 'Completed' or $this->Product()->first()->P_Type == 'Raw' or $this->Product()->first()->P_Type == 'Industrial'){

                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$this->P_Ar_Name;


                        }else{
                            $PrrroName=$this->P_En_Name;


                        }


                        $data=[


                            'product_code'=>$rr->Barcode
                            ,'product_name'=>  $PrrroName
                            ,'unit'=>$rr->Unit()->first()->Name
                            ,'qty'=>$this->Qty
                            ,'count'=>$count


                        ];

return $data;



                    }elseif($this->Product()->first()->P_Type == 'Serial'){



                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$this->P_Ar_Name;


                        }else{
                            $PrrroName=$this->P_En_Name;


                        }



                        $data=[


                            'product_code'=>$this->P_Code
                            ,'product_name'=>  $PrrroName
                            ,'unit'=>$rr->Unit()->first()->Name
                            ,'qty'=>$this->Qty
                            ,'count'=>$count


                        ];

                        return $data;


                    }elseif($this->Product()->first()->P_Type == 'Single_Variable'){


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$this->P_Ar_Name;
                            $PrrroVName=$this->V1()->first()->Name;



                        }else{
                            $PrrroName=$this->P_En_Name;
                            $PrrroVName=$this->V1()->first()->NameEn;



                        }


                        $data=[


                            'product_code'=>$this->P_Code
                            ,'product_name'=>  $PrrroName . ($PrrroVName)
                            ,'unit'=>$rr->Unit()->first()->Name
                            ,'qty'=>$this->Qty
                            ,'count'=>$count


                        ];

                        return $data;


                    }elseif($this->Product()->first()->P_Type == 'Duble_Variable'){


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$this->P_Ar_Name;
                            $PrrroVName=$this->V1()->first()->Name;
                            $PrrroVVName=$this->V2()->first()->Name;


                        }else{
                            $PrrroName=$this->P_En_Name;
                            $PrrroVName=$this->V1()->first()->NameEn;
                            $PrrroVVName=$this->V2()->first()->NameEn;


                        }


                        $data=[


                            'product_code'=>$this->P_Code
                            ,'product_name'=>  $PrrroName . ($PrrroVName). ($PrrroVVName)
                            ,'unit'=>$rr->Unit()->first()->Name
                            ,'qty'=>$this->Qty
                            ,'count'=>$count


                        ];

                        return $data;

                    }




                }

            }else{

                if($this->Product()->first()->P_Type == 'Completed' or $this->Product()->first()->P_Type == 'Raw' or $this->Product()->first()->P_Type == 'Industrial'){

                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$this->P_Ar_Name;


                    }else{
                        $PrrroName=$this->P_En_Name;


                    }




                    $data=[


                        'product_code'=>$rr->Barcode
                        ,'product_name'=>  $PrrroName
                        ,'unit'=>$rr->Unit()->first()->Name
                        ,'qty'=>$this->Qty
                        ,'count'=>$count


                    ];

                    return $data;



                }elseif($this->Product()->first()->P_Type == 'Serial'){



                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$this->P_Ar_Name;


                    }else{
                        $PrrroName=$this->P_En_Name;


                    }



                    $data=[


                        'product_code'=>$this->P_Code
                        ,'product_name'=>  $PrrroName
                        ,'unit'=>$rr->Unit()->first()->Name
                        ,'qty'=>$this->Qty
                        ,'count'=>$count


                    ];

                    return $data;


                }elseif($this->Product()->first()->P_Type == 'Single_Variable'){


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$this->P_Ar_Name;
                        $PrrroVName=$this->V1()->first()->Name;



                    }else{
                        $PrrroName=$this->P_En_Name;
                        $PrrroVName=$this->V1()->first()->NameEn;



                    }


                    $data=[


                        'product_code'=>$this->P_Code
                        ,'product_name'=>  $PrrroName . ($PrrroVName)
                        ,'unit'=>$rr->Unit()->first()->Name
                        ,'qty'=>$this->Qty
                        ,'count'=>$count


                    ];

                    return $data;


                }elseif($this->Product()->first()->P_Type == 'Duble_Variable'){


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$this->P_Ar_Name;
                        $PrrroVName=$this->V1()->first()->Name;
                        $PrrroVVName=$this->V2()->first()->Name;


                    }else{
                        $PrrroName=$this->P_En_Name;
                        $PrrroVName=$this->V1()->first()->NameEn;
                        $PrrroVVName=$this->V2()->first()->NameEn;


                    }



                    $data=[


                        'product_code'=>$this->P_Code
                        ,'product_name'=>  $PrrroName . ($PrrroVName). ($PrrroVVName)
                        ,'unit'=>$rr->Unit()->first()->Name
                        ,'qty'=>$this->Qty
                        ,'count'=>$count


                    ];

                    return $data;

                }




            }

        }


    }

}
