<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\ProductSales;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class SalesProsBrandMoreDetailsApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        $From = $request->get('From');
        $To = $request->get('To');
        $Client = $request->get('Client');
        $Store = $request->get('Store');
        $Delegate = $request->get('Delegate');
        $Executor = $request->get('Executor');
        $Brand = $request->get('Brand');


        $Code=ProductUnits::where('Product',$this->id)->where('Def',1)->first();


        $SalesTotal=ProductSales::where('Product',$this->id)->whereBetween('Date',[$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client', $Client);
            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Sales','Store', $Store);
            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate', $Delegate);
            })


            ->when(!empty($Executor), function ($query) use ($Executor) {
                return $query->whereRelation('Sales','Executor', $Executor);
            })

            ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
            ->get()->sum('Total_Net');

        $SalesQty=ProductSales::where('Product',$this->id)->whereBetween('Date',[$From,$To])
            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client', $Client);
            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Sales','Store', $Store);
            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate', $Delegate);
            })


            ->when(!empty($Executor), function ($query) use ($Executor) {
                return $query->whereRelation('Sales','Executor', $Executor);
            })

            ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
            ->get()->sum('Qty');


        if($SalesQty != 0){

            if($this->P_Type == 'Serial'){


                if(app()->getLocale() == 'ar' ){
                    $xName=$this->P_Ar_Name;

                }else{
                    $xName=$this->P_En_Name;

                }


                $data=[

                    'Code'=>$Code->Barcode
                    ,'Name'=>$xName
                    ,'Price'=>$Code->Price
                    ,'Qty'=>$SalesQty
                    ,'Total'=>$SalesTotal
                    ,'details'=>$this->when(!empty($this->id), function () {

                        $Store = request('Store');
                        $det=ProductsQty::where('Product',$this->id)
                            ->when(!empty($Store), function ($query) use ($Store) {
                                return $query->where('Store', $Store);
                            })
                            ->distinct(['P_Code'])->get();

                        $details=DetSalesGroupApiResources::collection($det);

                        return $details;
                    }),

                ];

                return $data ;


            }elseif($this->P_Type == 'Single_Variable'){

                $thissQty=ProductsQty::where('Product',$this->id)
                    ->when(!empty($Store), function ($query) use ($Store) {
                        return $query->where('Store', $Store);
                    })
                    ->distinct(['P_Code'])->get();


                if(app()->getLocale() == 'ar' ){
                    $xName=$this->P_Ar_Name;

                }else{
                    $xName=$this->P_En_Name;

                }


                $data=[

                    'Code'=>$Code->Barcode
                    ,'Name'=>$xName
                    ,'Price'=>$Code->Price
                    ,'Qty'=>$SalesQty
                    ,'Total'=>$SalesTotal
                    ,'details'=>$this->when(!empty($this->id), function () {

                        $Store = request('Store');
                        $det=ProductsQty::where('Product',$this->id)
                            ->when(!empty($Store), function ($query) use ($Store) {
                                return $query->where('Store', $Store);
                            })
                            ->distinct(['P_Code'])->get();

                        $details=DetSalesGroupApiResources::collection($det);

                        return $details;
                    }),

                ];

                return $data ;



            }elseif($this->P_Type == 'Duble_Variable'){

                $thissQty=ProductsQty::where('Product',$this->id)
                    ->when(!empty($Store), function ($query) use ($Store) {
                        return $query->where('Store', $Store);
                    })
                    ->distinct(['P_Code'])->get();



            }else{

                if(app()->getLocale() == 'ar' ){
                    $xName=$this->P_Ar_Name;

                }else{
                    $xName=$this->P_En_Name;

                }



                $data=[

                    'Code'=>$Code->Barcode
                    ,'Name'=>$xName
                    ,'Price'=>$Code->Price
                    ,'Qty'=>$SalesQty
                    ,'Total'=>$SalesTotal


                ];

                return $data ;



            }

        }





    }

}
