<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\DefaultDataShowHide;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ProfitFilterSalesApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        if(!empty($this->Cost_Center)){
            if($lang == 'ar' ){
                $cost=$this->Cost_Center()->first()->Arabic_Name;
            }else{

                $cost=$this->Cost_Center()->first()->English_Name;
            }
        }else{

            $cost='';
        }

        if(!empty($this->Delegate)){

            if($lang == 'ar' ){
                $dele=$this->Delegate()->first()->Name;
            }else{

                $dele=$this->Delegate()->first()->NameEn;
            }

        }else{

            $dele='';
        }
        if(!empty($this->Executor)){


            if($lang == 'ar' ){
                $exee=$this->Executor()->first()->Name;
            }else{

                $exee=$this->Executor()->first()->NameEn;
            }

        }else{

            $exee='';
        }

        if($this->Sales()->first()->Payment_Method == 'Cash'){
            $payment=trans('admin.Cash');
        }elseif($this->Sales()->first()->Payment_Method == 'Later'){

            $payment= trans('admin.Later');
        }elseif($this->Sales()->first()->Payment_Method == 'Check'){

            $payment= trans('admin.Check');
        }else{
            $payment='';
        }

        $Def=DefaultDataShowHide::orderBy('id','desc')->first();

        if($Def->Code_Report == 1){
            $opo='';
        }else{

            $opo='no-print';

        }

        if($Def->Refrence_Number_Print == 1){
            $opoR='';
        }else{

            $opoR='no-print';

        }

        if($Def->Unit == 1){
            $opoU='';
        }else{

            $opoU='no-print';

        }





        if($lang == 'ar' ){
            $ProoName=$this->P_Ar_Name;

            if(!empty($this->V1)){
                $ProoVName=$this->V1()->first()->Name;
            }else{
                $ProoVName='';
            }


            if(!empty($this->V2)){
                $ProoVVName=$this->V2()->first()->Name;
            }else{
                $ProoVVName='';
            }
            $UniiName=$this->Unit()->first()->Name;

            $GropName=$this->Product()->first()->Group()->first()->Name;
            $CoinName=$this->Coin()->first()->Arabic_Name;
            $safeName=$this->Safe()->first()->Name;
            $storName=$this->Store()->first()->Name;
            $userName=$this->User()->first()->name;

        }else{
            $ProoName=$this->P_En_Name;

            if(!empty($this->V1)){
                $ProoVName=$this->V1()->first()->NameEn;
            }else{
                $ProoVName='';
            }


            if(!empty($this->V2)){
                $ProoVVName=$this->V2()->first()->NameEn;
            }else{
                $ProoVVName='';
            }


            $UniiName=$this->Unit()->first()->NameEn;

            $GropName=$this->Product()->first()->Group()->first()->NameEn;
            $CoinName=$this->Coin()->first()->English_Name;
            $safeName=$this->Safe()->first()->NameEn;
            $storName=$this->Store()->first()->NameEn;
            $userName=$this->User()->first()->nameEn;


        }



        $data=[

            'date'=>$this->Date
            ,'code'=>$this->Sales()->first()->Code
            ,'refernce_number'=>$this->Refernce_Number
            ,'product_code'=>$this->Product_Code
            ,'product_name'=>  $ProoName. ( $ProoVName . $ProoVVName )
            ,'unit'=>$UniiName
            ,'group'=>$GropName
            ,'price'=>$this->Price
            ,'qty'=>$this->Qty
            ,'total_net'=>$this->Total_Net
            ,'total_return'=> 0
            ,'delegate'=>$dele
            ,'executor'=>$exee
            ,'coin'=>$CoinName
            ,'cost'=>$cost
            ,'safe'=>$safeName
            ,'store'=>$storName
            ,'type'=>$this->Type
            ,'payment'=>$payment
            ,'user'=>$userName


        ];





        return $data ;
    }

}
