<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\Measuerments;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ProductOrderLimitApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $Search_Type = $request->get('Search_Type');

        if($Search_Type == 1){
            $units=ProductUnits::where('Product',$this->Product)->get();
            $rr=ProductUnits::where('Product',$this->Product)->where('Def',1)->first();

            $AllQty=ProductsQty::where('Product',$this->Product)->get()->sum('Qty');



            if($AllQty <= $this->Product()->first()->Minimum){
                if($group != ''){
                    if($this->Product()->first()->Group == $group){


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$this->P_Ar_Name;


                        }else{
                            $PrrroName=$this->P_En_Name;


                        }




                        $data=[

                            'Product_Code'=>$rr->Barcode
                            ,'Product_Name'=>$PrrroName
                            ,'Unit'=>$rr->Unit()->first()->Name
                            ,'Minimum'=>$this->Product()->first()->Minimum
                            ,'Qty'=>$AllQty



                        ];


                        return $data ;





                    }
                }else{

                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$this->P_Ar_Name;


                    }else{
                        $PrrroName=$this->P_En_Name;


                    }


                    $data=[

                        'Product_Code'=>$rr->Barcode
                        ,'Product_Name'=>$PrrroName
                        ,'Unit'=>$rr->Unit()->first()->Name
                        ,'Minimum'=>$this->Product()->first()->Minimum
                        ,'Qty'=>$AllQty



                    ];
                    return $data ;

                }
            }

        }else{

            $units=ProductUnits::where('Product',$this->Product)->get();
            $rr=ProductUnits::where('Product',$this->Product)->where('Def',1)->first();
            $pro=ProductsQty::where('Product',$this->Product)->where('Store',$store)->first();

            if($this->Qty <= $this->Product()->first()->Minimum){
                if($group != ''){
                    if($this->Product()->first()->Group == $group){


                        if($this->Product()->first()->P_Type == 'Completed' or $this->Product()->first()->P_Type == 'Raw' or $this->Product()->first()->P_Type == 'Industrial'){


                            if(app()->getLocale() == 'ar' ){
                                $PrrroName=$this->P_Ar_Name;


                            }else{
                                $PrrroName=$this->P_En_Name;


                            }


                            $data=[

                                'Product_Code'=>$rr->Barcode
                                ,'Product_Name'=>$PrrroName
                                ,'Unit'=>$rr->Unit()->first()->Name
                                ,'Minimum'=>$this->Product()->first()->Minimum
                                ,'Qty'=>$this->Qty



                            ];
                            return $data ;


                        }elseif($this->Product()->first()->P_Type == 'Serial'){


                            if(app()->getLocale() == 'ar' ){
                                $PrrroName=$this->P_Ar_Name;


                            }else{
                                $PrrroName=$this->P_En_Name;


                            }

                            $data=[

                                'Product_Code'=>$this->P_Code
                                ,'Product_Name'=>$PrrroName
                                ,'Unit'=>$rr->Unit()->first()->Name
                                ,'Minimum'=>$this->Product()->first()->Minimum
                                ,'Qty'=>$this->Qty



                            ];
                            return $data ;


                        }elseif($this->Product()->first()->P_Type == 'Single_Variable'){

                            if(app()->getLocale() == 'ar' ){
                                $PrrroName=$this->P_Ar_Name;
                                $PrrroVName=$this->V1()->first()->Name;

                            }else{
                                $PrrroName=$this->P_En_Name;
                                $PrrroVName=$this->V1()->first()->NameEn;

                            }

                            $data=[

                                'Product_Code'=>$this->P_Code
                                ,'Product_Name'=>$PrrroName . ($PrrroVName)
                                ,'Unit'=>$rr->Unit()->first()->Name
                                ,'Minimum'=>$this->Product()->first()->Minimum
                                ,'Qty'=>$this->Qty



                            ];
                            return $data ;


                        }elseif($this->Product()->first()->P_Type == 'Duble_Variable'){


                            if(app()->getLocale() == 'ar' ){
                                $PrrroName=$this->P_Ar_Name;
                                $PrrroVName=$this->V1()->first()->Name;
                                $PrrroVVName=$this->V2()->first()->Name;

                            }else{
                                $PrrroName=$this->P_En_Name;
                                $PrrroVName=$this->V1()->first()->NameEn;
                                $PrrroVVName=$this->V2()->first()->NameEn;

                            }

                            $data=[

                                'Product_Code'=>$this->P_Code
                                ,'Product_Name'=>$PrrroName . ($PrrroVName). ($PrrroVVName)
                                ,'Unit'=>$rr->Unit()->first()->Name
                                ,'Minimum'=>$this->Product()->first()->Minimum
                                ,'Qty'=>$this->Qty



                            ];
                            return $data ;

                        }


                    }

                }else{

                    if($this->Product()->first()->P_Type == 'Completed' or $this->Product()->first()->P_Type == 'Raw' or $this->Product()->first()->P_Type == 'Industrial'){


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$this->P_Ar_Name;


                        }else{
                            $PrrroName=$this->P_En_Name;


                        }

                        $data=[

                            'Product_Code'=>$rr->Barcode
                            ,'Product_Name'=>$PrrroName
                            ,'Unit'=>$rr->Unit()->first()->Name
                            ,'Minimum'=>$this->Product()->first()->Minimum
                            ,'Qty'=>$this->Qty



                        ];
                        return $data ;

                    }elseif($this->Product()->first()->P_Type == 'Serial'){


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$this->P_Ar_Name;


                        }else{
                            $PrrroName=$this->P_En_Name;


                        }

                        $data=[

                            'Product_Code'=>$this->P_Code
                            ,'Product_Name'=>$PrrroName
                            ,'Unit'=>$rr->Unit()->first()->Name
                            ,'Minimum'=>$this->Product()->first()->Minimum
                            ,'Qty'=>$this->Qty



                        ];
                        return $data ;

                    }elseif($this->Product()->first()->P_Type == 'Single_Variable'){

                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$this->P_Ar_Name;
                            $PrrroVName=$this->V1()->first()->Name;

                        }else{
                            $PrrroName=$this->P_En_Name;
                            $PrrroVName=$this->V1()->first()->NameEn;

                        }

                        $data=[

                            'Product_Code'=>$this->P_Code
                            ,'Product_Name'=>$PrrroName . ($PrrroVName)
                            ,'Unit'=>$rr->Unit()->first()->Name
                            ,'Minimum'=>$this->Product()->first()->Minimum
                            ,'Qty'=>$this->Qty



                        ];
                        return $data ;


                    }elseif($this->Product()->first()->P_Type == 'Duble_Variable'){


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$this->P_Ar_Name;
                            $PrrroVName=$this->V1()->first()->Name;
                            $PrrroVVName=$this->V2()->first()->Name;

                        }else{
                            $PrrroName=$this->P_En_Name;
                            $PrrroVName=$this->V1()->first()->NameEn;
                            $PrrroVVName=$this->V2()->first()->NameEn;

                        }

                        $data=[

                            'Product_Code'=>$this->P_Code
                            ,'Product_Name'=>$PrrroName . ($PrrroVName) . ($PrrroVVName)
                            ,'Unit'=>$rr->Unit()->first()->Name
                            ,'Minimum'=>$this->Product()->first()->Minimum
                            ,'Qty'=>$this->Qty



                        ];
                        return $data ;

                    }


                }
            }

        }







    }

}
