<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class InventorySerialApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');


        $AllQty = ProductsQty::where('Product', $this->Product)->get()->sum('Qty');




        if (!empty($this->Group)) {

            if($lang == 'ar'){
                $group=$this->Group()->first()->Name;
            }else{
                $group=$this->Group()->first()->NameEn;
            }

    }else{
            $group='';
        }

        if (!empty($this->Brand)) {

            if($lang == 'ar'){
                $brand=$this->Brand()->first()->Name;
            }else{
                $brand=$this->Brand()->first()->NameEn;
            }

    }else{
            $brand='';
        }



                $data=[

                    'Product_Name'=>$this->P_Ar_Name
                    ,'Product_Code'=>$this->Barcode
                    ,'Group'=>$group
                    ,'Brand'=>$brand
                    ,'Qty'=>$AllQty
                    ,'details'=>$this->when(!empty($this->id), function () {

                        $Qtys = ProductsQty::where('Product', $this->Product)->get();
        $details=SerialDetailsApiResources::collection($Qtys);

        return $details;
    }),

                ];






        return $data ;
    }

}
