<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\Measuerments;
use App\Models\ProductMoves;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\Purchases;
use App\Models\StoresDefaultData;
use App\Services\Average;
use App\Services\SalesService;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ExceptProfitsApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');
        $search = $request->get('search');
        $store = $request->get('Store');

        $service = new SalesService() ;
        $average=new Average();
        $units=ProductUnits::where('Product',$this->Product)->get();
        $rr=ProductUnits::where('Product',$this->Product)->where('Def',1)->first();



        $Average=$average->AverageCostGetUnit($this->Product,$rr->Barcode,$store,$rr->Unit);

        $Average=$average->AverageCostGetUnit($this->Product , $rr->Barcode,$store , $rr->Unit);

        $Cost=$Average;

        $priceO=$rr->Price * ($this->Qty / $rr->Rate);
        $priceT=$rr->Price_Two  * ($this->Qty / $rr->Rate);
        $priceTh=$rr->Price_Three * ($this->Qty / $rr->Rate);


        $profit1=$priceO - ($Cost * ($this->Qty / $rr->Rate));

        if($profit1 != 0){
            if($Cost == 0){
                $profitPrecent1=($profit1 * 100)  ;
            }else{
                $profitPrecent1=($profit1 * 100) / ($Cost * ($this->Qty / $rr->Rate)) ;
            }

        }else{
            $profitPrecent1=0 ;
        }

        if(!empty($priceT)){
            $profit2=$priceT - ($Cost * ($this->Qty / $rr->Rate));
            if($profit2 != 0){

                if($Cost == 0){
                    $profitPrecent2=($profit2 * 100)  ;
                }else{
                    $profitPrecent2=($profit2 * 100) / ($Cost * ($this->Qty / $rr->Rate)) ;
                }

            }else{
                $profitPrecent2=0 ;
            }

        }else{
            $profit2=0;
            $profitPrecent2=0;
        }
        if(!empty($priceTh)){
            $profit3=$priceTh - ($Cost * ($this->Qty / $rr->Rate));

            if($profit3 != 0){

                if($Cost == 0){
                    $profitPrecent3=($profit3 * 100)  ;
                }else{
                    $profitPrecent3=($profit3 * 100) / ($Cost * ($this->Qty / $rr->Rate)) ;
                }

            }else{
                $profitPrecent3=0 ;
            }

        }else{
            $profit3=0;
            $profitPrecent3=0;
        }



        $f=  ($rr->Price * ($this->Qty / $rr->Rate) )  - ($Average * ($this->Qty / $rr->Rate));
        $ff=   ($Average * ($this->Qty / $rr->Rate));
        $fff=  ($rr->Price * ($this->Qty / $rr->Rate) );

        if($this->Product()->first()->P_Type == 'Completed' or $this->Product()->first()->P_Type == 'Raw' or $this->Product()->first()->P_Type == 'Industrial'){


            if($lang == 'ar' ){
                $PrrroName=$this->P_Ar_Name;
                $StoreNemo=$this->Store()->first()->Name;

            }else{
                $PrrroName=$this->P_En_Name;
                $StoreNemo=$this->Store()->first()->NameEn;

            }

            $UNITS=$service->ProUnitsDataTwo($this->Product,$this->Store,$rr->Barcode);

            $data=[

                'product_code'=>$rr->Barcode
                ,'product_id'=>$this->Product
                ,'product_name'=>$PrrroName
                ,'unit'=>$rr->Unit()->first()->Name
                ,'units'=>$UNITS
                ,'price'=>$rr->Price
                ,'price_two'=>$rr->Price_Two
                ,'price_three'=>$rr->Price_Three
                ,'qty'=>$this->Qty / $rr->Rate
                ,'cost_price'=>$Average
                ,'total_cost_price'=>number_format((float)$Cost * ($this->Qty / $rr->Rate), 2, '.', '')
                ,'total_price_one'=>$priceO
                ,'total_price_two'=>$priceT
                ,'total_price_three'=>$priceTh
                ,'profit_one'=>$profit1
                ,'profit_two'=>$profit2
                ,'profit_three'=>$profit3




            ];

            return $data ;


        }elseif($this->Product()->first()->P_Type == 'Serial'){


            if($lang == 'ar' ){
                $PrrroName=$this->P_Ar_Name;
                $StoreNemo=$this->Store()->first()->Name;

            }else{
                $PrrroName=$this->P_En_Name;
                $StoreNemo=$this->Store()->first()->NameEn;

            }


            $UNITS=$service->ProUnitsDataTwo($this->Product,$this->Store,$this->P_Code);


            $data=[

                'product_code'=>$this->P_Code
                ,'product_id'=>$this->Product
                ,'product_name'=>$PrrroName
                ,'unit'=>$rr->Unit()->first()->Name
                ,'units'=>$UNITS
                ,'price'=>$rr->Price
                ,'price_two'=>$rr->Price_Two
                ,'price_three'=>$rr->Price_Three
                ,'qty'=>$this->Qty / $rr->Rate
                ,'cost_price'=>$Average
                ,'total_cost_price'=>number_format((float)$Cost * ($this->Qty / $rr->Rate), 2, '.', '')
                ,'total_price_one'=>$priceO
                ,'total_price_two'=>$priceT
                ,'total_price_three'=>$priceTh
                ,'profit_one'=>$profit1
                ,'profit_two'=>$profit2
                ,'profit_three'=>$profit3




            ];

            return $data ;


        }elseif($this->Product()->first()->P_Type == 'Single_Variable'){


            if($lang == 'ar' ){
                $PrrroName=$this->P_Ar_Name;
                $StoreNemo=$this->Store()->first()->Name;

            }else{
                $PrrroName=$this->P_En_Name;
                $StoreNemo=$this->Store()->first()->NameEn;

            }

            $UNITS=$service->ProUnitsDataTwo($this->Product,$this->Store,$this->P_Code);


            $data=[

                'product_code'=>$this->P_Code
                ,'product_id'=>$this->Product
                ,'product_name'=>$PrrroName . ($this->V_Name)
                ,'unit'=>$rr->Unit()->first()->Name
                ,'units'=>$UNITS
                ,'price'=>$rr->Price
                ,'price_two'=>$rr->Price_Two
                ,'price_three'=>$rr->Price_Three
                ,'qty'=>$this->Qty / $rr->Rate
                ,'cost_price'=>$Average
                ,'total_cost_price'=>number_format((float)$Cost * ($this->Qty / $rr->Rate), 2, '.', '')
                ,'total_price_one'=>$priceO
                ,'total_price_two'=>$priceT
                ,'total_price_three'=>$priceTh
                ,'profit_one'=>$profit1
                ,'profit_two'=>$profit2
                ,'profit_three'=>$profit3




            ];


            return $data ;



        }elseif($this->Product()->first()->P_Type == 'Duble_Variable'){


            if($lang == 'ar' ){
                $PrrroName=$this->P_Ar_Name;
                $StoreNemo=$this->Store()->first()->Name;

            }else{
                $PrrroName=$this->P_En_Name;
                $StoreNemo=$this->Store()->first()->NameEn;

            }



            $UNITS=$service->ProUnitsDataTwo($this->Product,$this->Store,$this->P_Code);


            $data=[

                'product_code'=>$this->P_Code
                ,'product_id'=>$this->Product
                ,'product_name'=>$PrrroName . ($this->V_Name). ($this->VV_Name)
                ,'unit'=>$rr->Unit()->first()->Name
                ,'units'=>$UNITS
                ,'price'=>$rr->Price
                ,'price_two'=>$rr->Price_Two
                ,'price_three'=>$rr->Price_Three
                ,'qty'=>$this->Qty / $rr->Rate
                ,'cost_price'=>$Average
                ,'total_cost_price'=>number_format((float)$Cost * ($this->Qty / $rr->Rate), 2, '.', '')
                ,'total_price_one'=>$priceO
                ,'total_price_two'=>$priceT
                ,'total_price_three'=>$priceTh
                ,'profit_one'=>$profit1
                ,'profit_two'=>$profit2
                ,'profit_three'=>$profit3




            ];


            return $data ;


        }









    }

}
