<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\GeneralDaily;
use App\Models\ItemsGroups;
use App\Models\ProductSales;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\ReciptVoucherDetails;
use App\Models\Sales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class DetailsGroupBrandSalesApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');
        $From = $request->get('From');
        $To = $request->get('To');



        $Newqty = ProductSales::
        where('Product', $this->Product)
            ->where('Product_Code', $this->Product_Code)
            ->whereRelation('Sales', function ($query) use ($From, $To) {
                return $query->whereBetween('Date', [$From, $To]);

            })
            ->get()->sum('Qty');

        $Newtot = ProductSales::
        where('Product', $this->Product)
            ->where('Product_Code', $this->Product_Code)
            ->whereRelation('Sales', function ($query) use ($From, $To) {
                return $query->whereBetween('Date', [$From, $To]);

            })
            ->get()->sum('Total_Net');



        $data=[

            'Code'=>$this->Product_Code
            ,'Name'=> $this->P_Ar_Name .  (  $this->V_Name ) .  ( $this->VV_Name)
            ,'Unit'=>$this->Unit()->first()->Name
            ,'Qty'=>$Newqty
            ,'Price'=>$this->Price
            ,'Total'=>$Newtot


        ];


        return $data ;







    }

}
