<?php

namespace App\Http\Resources\Reports\CRM;


use App\Models\CommentsClients;
use App\Models\Sales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use DateTime;
class CustomerfollowupReportsApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        $firstComment = CommentsClients::where('Customer', $this->id)->orderBy('Date')->first();
        $firstBill = Sales::where('Client', $this->Account)->oldest('Date')->first();
        if (!empty($firstComment)) {
            $firstComment = $firstComment->Date;
        } else {
            $firstComment = 0;
        }
        if (!empty($firstBill)) {
            $firstBill = $firstBill->Date;
        } else {
            $firstBill = 0;
        }


        $datetime1 = new DateTime($this->Date);
        if ($firstComment != 0) {
            $datetime2 = new DateTime($firstComment);
            $interval = $datetime1->diff($datetime2);
            $daysComment = $interval->format('%a');
        } else {
            $daysComment = 0;
        }

        if ($firstBill != 0) {
            $datetimeBill = new DateTime($firstBill);
            $intervalBill = $datetime1->diff($datetimeBill);
            $daysBill = $intervalBill->format('%a');
        } else {
            $daysBill = 0;
        }

        if (!empty($this->Operation_Date)) {
            $datetimeOp = new DateTime($this->Operating_Date);
            $intervalOp = $datetime1->diff($datetimeOp);
            $daysOp = $intervalOp->format('%a');
        } else {
            $daysOp = 0;
        }




    $data=[

            'Client'=>$this->Name
            ,'Addation_Date'=>$this->Date
            ,'Date_First_Comment'=>$firstComment
            ,'Date_First_Bill'=>$firstBill
            ,'Operation_Date'=>$this->Operating_Date
            ,'Dif_Days_Addation_Date_First_Comment'=>$daysComment
            ,'Dif_Days_Addation_Date_First_Bill'=>$daysBill
            ,'Dif_Days_Addation_Date_Operation_Date'=>$daysOp



        ];




        return $data ;
    }

}
