<?php

namespace App\Http\Resources\Reports\Accounting;


use App\Models\Customers;
use App\Models\Employess;
use App\Models\GeneralDaily;
use App\Models\PaymentVoucherDetails;
use App\Models\ReciptVoucherDetails;
use App\Models\ReturnPurch;
use App\Models\ReturnSales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use DateTime;

class VendorDebtsApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');


        if(!empty($this->Delegate()->first()->Name)){
            if(app()->getLocale() == 'ar' ){
                $dele=$this->Delegate()->first()->Name;
            }else{
                $dele=$this->Delegate()->first()->NameEn;
            }
        }else{

            $dele='';
        }
        $TotReturn=ReturnPurch::where('Purchase',$this->id)->get()->sum('Total_Return_Value');


        $TotReciptVoucher=PaymentVoucherDetails::where('Bill_Num',$this->Code)->get()->sum('Creditor');

        $fdate = $this->Date;
        $tdate = date('Y-m-d');
        $datetime1 = new DateTime($fdate);
        $datetime2 = new DateTime($tdate);
        $interval = $datetime1->diff($datetime2);
        $DifDays = $interval->format('%a');


        if(app()->getLocale() == 'ar' ){
            $StName=$this->Store()->first()->Name;
            $SafeName=$this->Safe()->first()->Name;
            $CliName=$this->Vendor()->first()->Name;


        }else{
            $StName=$this->Store()->first()->NameEn;
            $SafeName=$this->Safe()->first()->NameEn;
            $CliName=$this->Vendor()->first()->NameEn;

        }



        $data=[

            'date'=>$this->Date
            ,'code'=>$this->Code
            ,'later_due'=>$this->Later_Due
            ,'store'=>$StName
            ,'safe'=>$SafeName
            ,'account'=>$CliName
            ,'repayment_period'=>$this->Repayment_Period
            ,'delegate'=>$dele
            ,'total_net'=>$this->Total_Net
            ,'pay'=>$this->Pay
            ,'residual'=>$this->Total_Net - $this->Pay
            ,'total_return'=>$TotReturn
            ,'total_recipt_voucher'=>$TotReciptVoucher
            ,'residual_pay'=>$this->Total_Net - $TotReciptVoucher
            ,'days_count'=>$DifDays


        ];


        return $data ;
    }

}
