<?php

namespace App\Http\Resources\Reports\Accounting;


use App\Models\Employess;
use App\Models\GeneralDaily;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use DateTime;

class ClientVendorBalancesApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        $zero=$request->get('Zero');
        $from=$request->get('from');
        $to=$request->get('to');
        $DBBEFORE=0;
        $CRBEFORE=0;
        $DBTOTAL=0;
        $CRTOTAL=0;
        $DBBALANCE=0;
        $CRBALANCE=0;
        $apear=0;
        $DebBef =GeneralDaily::where('Account',$this->id)
            ->where('Date','<',$from)
            ->get()->sum('Debitor_Coin');


        $CredBef =GeneralDaily::where('Account',$this->id)
            ->where('Date','<',$from)
            ->get()->sum('Creditor_Coin');

        $TotalDeb =GeneralDaily::where('Account',$this->id)
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Debitor_Coin');


        $TotalCred =GeneralDaily::where('Account',$this->id)
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Creditor_Coin');


        $x=( $DebBef + $TotalDeb ) - ( $CredBef + $TotalCred ) ;


        if($x < 0){

            $y=0;
            $z=abs($x);
        }else{

            $y=$x;
            $z=0;

        }

        $DBBEFORE +=$DebBef;
        $CRBEFORE +=$CredBef;
        $DBTOTAL +=$TotalDeb;
        $CRTOTAL +=$TotalCred;
        $DBBALANCE +=$y;
        $CRBALANCE +=$z;



        if($zero == 1) {
            if($DebBef == 0  and $CredBef == 0 and $TotalDeb == 0  and $TotalCred == 0 and $y == 0  and $z == 0 ){
                $apear=1;
            }
        }

        if($apear == 0){

            if(app()->getLocale() == 'ar' ){
                $xName=$this->Name;

            }else{
                $xName=$this->NameEn;

            }

        $data=[

            'Account_Code'=>$this->Code
            ,'Account_Name'=>$xName
            ,'Debiator_Before'=>$DebBef
            ,'Creditor_Before'=>$CredBef
            ,'Total_Debitor'=>$TotalDeb
            ,'Total_Creditor'=>$TotalCred
            ,'Debitor_Balance'=>$y
            ,'Creditor_Balance'=>$z

        ];

        }


        return $data ;
    }

}
