<?php

namespace App\Http\Resources;


use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class PurchasesDefaultResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');


        if($lang ==  'ar') {
            $data = [


                'payment_method'=>$this->Payment_Method,
                'status'=>$this->Status,
                'safe_id'=>$this->Safe,
                'safe'=>$this->Safe()->first()->Name,
                'vendor_id'=>$this->Vendor,
                'vendor'=>$this->Vendor()->first()->Name,
                'delegate_id'=>$this->Delegate,
                'delegate'=>$this->Delegate()->first()->Name,
                'store_id'=>$this->Store,
                'store'=>$this->Store()->first()->Name,
                'coin_id'=>$this->Coin,
                'coin'=>$this->Coin()->first()->Arabic_Name,
                'discount'=>$this->Discount,


            ];
        }else{


            $data = [


                'payment_method'=>$this->Payment_Method,
                'status'=>$this->Status,
                'safe_id'=>$this->Safe,
                'safe'=>$this->Safe()->first()->NameEn,
                'vendor_id'=>$this->Vendor,
                'vendor'=>$this->Vendor()->first()->NameEn,
                'delegate_id'=>$this->Delegate,
                'delegate'=>$this->Delegate()->first()->NameEn,
                'store_id'=>$this->Store,
                'store'=>$this->Store()->first()->NameEn,
                'coin_id'=>$this->Coin,
                'coin'=>$this->Coin()->first()->English_Name,
                'discount'=>$this->Discount,



            ];
        }



        return $data ;
    }

}
