<?php

namespace App\Http\Resources\ECom;


use App\Models\Coins;
use App\Models\Customers;
use App\Models\Employess;
use App\Models\GeneralDaily;
use App\Models\ProductSalesOrder;
use App\Models\ReciptVoucherDetails;
use App\Models\ReturnSales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use DateTime;

class MyOrdersResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');




            if($this->Delivery_Status == 0){
                $status=  trans('admin.Pending');
            }elseif($this->Delivery_Status == 1){
                $status=   trans('admin.Processing');
            }elseif($this->Delivery_Status == 2){
                $status= trans('admin.Recived');
            }
            $SUBTOTAL=$this->Total_Price - ($this->CuponCode + $this->Shipping);



            foreach($details as $detail){

                if($lang == 'ar'){
                    $proName=$detail->P_Ar_Name;

                    if(!empty($detail->V1)){
                        $proVName=$detail->V1()->first()->Name;
                    }else{

                        $proVName='';
                    }


                    if(!empty($detail->V2)){
                        $proVVName=$detail->V2()->first()->Name;
                    }else{

                        $proVVName='';
                    }


                }else{

                    $proName=$detail->P_En_Name;

                    if(!empty($detail->V1)){
                        $proVName=$detail->V1()->first()->NameEn;
                    }else{

                        $proVName='';
                    }


                    if(!empty($detail->V2)){
                        $proVVName=$detail->V2()->first()->NameEn;
                    }else{

                        $proVVName='';
                    }


                }

                array_push($ArrayProducts,[
                    'image'=>URL::to($detail->Image),
                    'product_name'=>$proName . $proVName . $proVVName,
                    'qty'=>$detail->Qty,
                    'price'=>$detail->Price,
                    'total'=>$detail->Total,

                ]);

            }




            if($lang == 'ar'){
                $Gov=$this->Governrate()->first()->Arabic_Name;
                $Cit=$this->City()->first()->Arabic_Name;
                $Pla=$this->Place()->first()->Arabic_Name;
            }else{
                $Gov=$this->Governrate()->first()->English_Name;
                $Cit=$this->City()->first()->English_Name;
                $Pla=$this->Place()->first()->English_Name;
            }




        $data=[

            'code'=>$this->Code,
            'date'=>$this->Date,
            'status'=>$status,
            'sub_total'=>$SUBTOTAL,
            'cupon_code'=>$this->CuponCode,
            'shipping'=>$this->Shipping,
            'grand_total'=>$this->Total_Price,
            'governrate'=>$Gov,
            'city'=>$Cit,
            'place'=>$Pla,
            'name'=>$this->Name,
            'email'=>$this->Email,
            'phone'=>$this->Phone,
            'other_phone'=>$this->OtherPhone,
            'address_name'=>$this->Address_Name,
            'special_mark'=>$this->Special_MarkAdd,
            'street'=>$this->StreetAdd,
            'buliding'=>$this->BulidingAdd,
            'floor'=>$this->FloorAdd,
            'flat'=>$this->FlatAdd,
            'location'=>$this->LocationAdd,
            'address_details'=>$this->Address_DetailsAdd,
            'products'=>$this->when(!empty($this->id), function () {

                $details=ProductSalesOrder::where('SalesOrder',$this->id)->get();
                $CustomersAddresses=ProductsMyOrdersResources::collection($details);

                return $CustomersAddresses;
            }),


        ];



        return $data ;
    }

}
