<?php

namespace App\Http\Resources;


use App\Models\ProductUnits;
use App\Services\Average;
use App\Services\SalesService;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class CreditStoresResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');
        $average = new Average() ;
        $service = new SalesService() ;
        $store = $request->get('store');

        $units=ProductUnits::where('Product',$this->Product)->get();
        $rr=ProductUnits::where('Product',$this->Product)->where('Def',1)->first();
        $plow=ProductUnits::where('Product',$this->Product)->where('Rate',1)->first();

        $Average = $average->AverageCostGetUnit($this->Product,$rr->Barcode,$this->Store,$rr->Unit)  ;
        $Cost = $Average * ($this->Qty / $rr->Rate)  ;
        if($lang == 'ar'){

            $ProName=$this->P_Ar_Name;
            $UniName=$rr->Unit()->first()->Name;
            $ProVName='';
            $ProVVName='';
            $Barcode='';

        }else{

            $ProName=$this->P_En_Name;
            $UniName=$rr->Unit()->first()->NameEn;
            $ProVName='';
            $ProVVName='';
            $Barcode='';

        }


        if($this->Product()->first()->P_Type == 'Completed' or $this->Product()->first()->P_Type == 'Raw' or $this->Product()->first()->P_Type == 'Industrial'){

            $Barcode=$rr->Barcode;

        }elseif($this->Product()->first()->P_Type == 'Serial'){

            $Barcode=$this->P_Code;

        }elseif($this->Product()->first()->P_Type == 'Single_Variable'){

            $Barcode=$this->P_Code;
            if($lang == 'ar'){
                $ProVName=$this->V1()->first()->Name;
            }else{
                $ProVName=$this->V1()->first()->NameEn;
            }

        }elseif($this->Product()->first()->P_Type == 'Duble_Variable'){

            $Barcode=$this->P_Code;
            if($lang == 'ar'){
                $ProVName=$this->V1()->first()->Name;
                $ProVVName=$this->V2()->first()->Name;
            }else{
                $ProVName=$this->V1()->first()->NameEn;
                $ProVVName=$this->V2()->first()->NameEn;
            }
        }
        $UNITS=$service->ProUnitsDataTwo($this->Product,$this->Store,$Barcode);

        if($this->Store == $store) {
            $data = [

                'barcode' => $Barcode,
                'name' => $ProName,
                'v_name' => $ProVName,
                'vv_name' => $ProVVName,
                'unit_id' => $this->Unit,
                'unit' => $UniName,
                'units' => $UNITS,
                'qty' => $this->Qty / $rr->Rate,
                'price_one' => $rr->Price,
                'price_two' => $rr->Price_Two,
                'price_three' => $rr->Price_Three,


            ];



        }

        return $data;
    }

}
