<?php

namespace App\Http\Resources;


use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class AdminResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        $id_Prem=DB::table('roles')->where('name',$this->roles_name)->first();



        if($lang == 'ar'){
            $Roles=DB::table('admins')->where('admins.email',$this->email)

                ->leftJoin('roles', function ($join) {

                    $join->on('admins.roles_name', '=', 'roles.name');
                })

                ->leftJoin('role_has_permissions', function ($join) {

                    $join->on('roles.id', '=', 'role_has_permissions.role_id');
                })

                ->leftJoin('permissions', function ($join) {

                    $join->on('role_has_permissions.permission_id', '=', 'permissions.id');
                })


                ->select(
                    'permissions.name as page'
                )
                ->get();
        }else{

            $Roles=DB::table('admins')->where('admins.email',$this->email)

                ->leftJoin('roles', function ($join) {

                    $join->on('admins.roles_name', '=', 'roles.name');
                })

                ->leftJoin('role_has_permissions', function ($join) {

                    $join->on('roles.id', '=', 'role_has_permissions.role_id');
                })

                ->leftJoin('permissions', function ($join) {

                    $join->on('role_has_permissions.permission_id', '=', 'permissions.id');
                })


                ->select(
                    'permissions.nameEn as page'
                )
                ->get();

        }

        $PRem=array();
        foreach ($Roles as $index) {
            if($index->page != null) {
                array_push($PRem, $index->page);
            }
        }

        if(!empty($this->store()->first()->Name)){

            if($lang == 'ar'){
                $stoname=$this->store()->first()->Name;
            }else{

                $stoname=$this->store()->first()->NameEn;
            }
        }else{
            $stoname='';
        }
    if(!empty($this->safe()->first()->Name)){

            if($lang == 'ar'){
                $safeName=$this->safe()->first()->Name;
            }else{

                $safeName=$this->safe()->first()->NameEn;
            }
        }else{
            $safeName='';
        }



        if($lang == 'ar'){
            $NameO=$this->name;
        }else{

            $NameO=$this->nameEn;
        }



        $data=[

            'name'=>$NameO
            ,'phone'=>$this->phone
            ,'email'=>$this->email
            ,'package'=>$this->package
            ,'image'=>asset($this->image)
            ,'token'=>$this->token
            ,'premation_id'=>$id_Prem->id
            ,'premation_name'=>$this->roles_name
            ,'type'=>$this->type
            ,'emplyee_id'=>$this->emp
            ,'default_safe_id'=>$this->safe
            ,'default_safe_name'=>$safeName
            ,'default_store_name'=>$stoname
            ,'default_store_id'=>$this->store
            ,'premation_price_sale'=>$this->price_sale
            ,'premation_discount'=>$this->discount
            ,'premation_payment_method'=>$this->pos_pay
            ,'premation_date'=>$this->Date
            ,'premation_discount_on_bill'=>$this->bill_discount
            ,'executor_id'=>$this->executor
            ,'premation_cost_price_stores_transfers'=>$this->cost_price
            ,'premation_pos_stores'=>$this->pos_stores
            ,'premation_hold_bills'=>$this->pos_hold
            ,'premation_cash'=>$this->Cash
            ,'premation_later'=>$this->Later
            ,'premation_check'=>$this->Check
            ,'premation_installment'=>$this->Installment
            ,'premation_cash_visa'=>$this->Cash_Visa
            ,'premation_visa'=>$this->Visa_Network
            ,'premation_cash_collection'=>$this->Cash_Collection
            ,'premation_delivery'=>$this->Delivery
            ,'premation_price_one'=>$this->price_1
            ,'premation_price_two'=>$this->price_2
            ,'premation_price_three'=>$this->price_3
            ,'premation_installment_companies'=>$this->InstallmentCompanies
            ,'prmations_pages'=>$PRem


        ];




        return $data ;
    }

}
