<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class InventoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'Store'=>'required',
            'Coin'=>'required',
            'Account_Dificit'=>'required',
            'Account_Excess'=>'required',
            'Total_Dificit'=>'required',
            'Total_Excess'=>'required',
            'Total_Dificit_Price'=>'required',
            'Total_Excess_Price'=>'required',

        ];
    }



    public function messages()
    {
        return [
            'Store.required' => trans('admin.StoreRequired'),
            'Coin.required' => trans('admin.CoinRequired'),
            'Total_Dificit.required' => trans('admin.Total_DificitRequired'),
            'Total_Excess.required' => trans('admin.Total_ExcessRequired'),
            'Total_Dificit_Price.required' => trans('admin.Total_Dificit_PriceRequired'),
            'Total_Excess_Price.required' => trans('admin.Total_Excess_PriceRequired'),
            'Account_Dificit.required' => trans('admin.Account_DificitRequired'),
            'Account_Excess.required' => trans('admin.Account_ExcessRequired'),
        ];
    }


}
