<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class InsurancePaperRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
                   'Date'=>'required',
             'Coin'=>'required',
             'Draw'=>'required',
             'Account'=>'required',
             'Due_Date'=>'required',
             'Amount'=>'required',
        ];
    }
    
    
    
    public function messages()
{
    return [
              'Date.required' => trans('admin.DateRequired'),    
            'Coin.required' => trans('admin.CoinRequired'),    
            'Draw.required' => trans('admin.DrawRequired'),    
            'Cost_Center.required' => trans('admin.Cost_CenterRequired'),    
            'Account.required' => trans('admin.AccountRequired'),    
            'Check_Type.required' => trans('admin.Check_TypeRequired'),    
            'Bank.required' => trans('admin.BankRequired'),    
            'Check_Num.required' => trans('admin.Check_NumRequired'),    
            'Due_Date.required' => trans('admin.Due_DateRequired'),    
            'Amount.required' => trans('admin.AmountRequired'),    
    ];
}
    
    
}
