<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class EmpRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'Name'=>'required',
            'Emp_Type'=>'required',
            'Salary'=>'required',
            'Job'=>'required',
            'Department'=>'required',
            'Account'=>'required',
            'email'=>'email|unique:admins',
            'Image'=>'image|mimes:jpeg,png,jpg|max:2048',

        ];
    }


    public function messages()
    {
        return [
            'Emp_Type.required' => trans('admin.Emp_TypeRequired'),
            'Salary.required' => trans('admin.SalaryRequired'),
            'Job.required' => trans('admin.JobRequired'),
            'Department.required' => trans('admin.DepartmentRequired'),
            'Account.required' => trans('admin.AccountRequired'),
            'Account_Emp.required' => trans('admin.Account_EmpRequired'),
            'email.unique' =>trans('admin.emailUnique'),
        ];
    }


}
