<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Log;
use App\Models\AcccountingManual;
use App\Models\AccountsDefaultData;
use App\Models\Activites;
use App\Models\Admin;
use App\Models\AssemblyProducts;
use App\Models\Assets;
use App\Models\BarcodeSettings;
use App\Models\Campaigns;
use App\Models\ChatIssue;
use App\Models\City;
use App\Models\ClientStatus;
use App\Models\Coins;
use App\Models\CompanyData;
use App\Models\Consists;
use App\Models\CostCenter;
use App\Models\Countris;
use App\Models\CrmDefaultData;
use App\Models\CustomersGroup;
use App\Models\CustomPrint;
use App\Models\DefaultDataShowHide;
use App\Models\DesviceCases;
use App\Models\Employess;
use App\Models\EmpMail;
use App\Models\ExecuteJobOrder;
use App\Models\ExecutingReceiving;
use App\Models\ExportChecks;
use App\Models\GeneralDaily;
use App\Models\Governrate;
use App\Models\IncomChecks;
use App\Models\IncomManufacturingModel;
use App\Models\Installment;
use App\Models\InstallmentDates;
use App\Models\InsurancePaper;
use App\Models\Interviews;
use App\Models\Intro;
use App\Models\Inventory;
use App\Models\Issues;
use App\Models\ItemsGroups;
use App\Models\JobOrder;
use App\Models\Journalizing;
use App\Models\JournalizingDetails;
use App\Models\LoginSlider;
use App\Models\MaintainceDefaultData;
use App\Models\ManufactureCompany;
use App\Models\ManufacturingDefaultData;
use App\Models\ManufacturingHalls;
use App\Models\ManufacturingModel;
use App\Models\ManuStoreCount;
use App\Models\Measuerments;
use App\Models\Missions;
use App\Models\Modules;
use App\Models\ModuleSettingsNum;
use App\Models\Notifications;
use App\Models\OpeningEntries;
use App\Models\OpeningEntriesDetails;
use App\Models\OutcomManufacturingModel;
use App\Models\Packages;
use App\Models\PackPrem;
use App\Models\PaymentVoucher;
use App\Models\PaymentVoucherDetails;
use App\Models\Platforms;
use App\Models\ProductInventory;
use App\Models\ProductMoves;
use App\Models\ProductQuoteImage;
use App\Models\ProductSales;
use App\Models\ProductSalesOrder;
use App\Models\ProductSalesSubscribes;
use App\Models\ProductsConsists;
use App\Models\ProductSettlement;
use App\Models\ProductsPurchases;
use App\Models\ProductsPurchasesOrder;
use App\Models\ProductsQty;
use App\Models\ProductsQuote;
use App\Models\ProductsSecretariatExportGoods;
use App\Models\ProductsSecretariatImportGoods;
use App\Models\ProductsShortcomings;
use App\Models\ProductsStartPeriods;
use App\Models\ProductsStoresTransfers;
use App\Models\ProductTypeDefault;
use App\Models\ProductUnits;
use App\Models\Projects;
use App\Models\ProjectTeam;
use App\Models\Purchases;
use App\Models\PurchasesDefaultData;
use App\Models\PurchasesOrder;
use App\Models\QR;
use App\Models\Quote;
use App\Models\QuoteImage;
use App\Models\RabihEducation;
use App\Models\ReciptVoucher;
use App\Models\ReciptVoucherDetails;
use App\Models\RecivedSales;
use App\Models\RecivedSalesProducts;
use App\Models\ReportsSettings;
use App\Models\ReturnPurch;
use App\Models\ReturnSales;
use App\Models\ReturnSalesProducts;
use App\Models\ReturnWithoutBill;
use App\Models\SafeTransfers;
use App\Models\Sales;
use App\Models\SalesDefaultData;
use App\Models\SalesOrder;
use App\Models\SalesSubscribes;
use App\Models\SecretariatExportGoods;
use App\Models\SecretariatImportGoods;
use App\Models\SecretariatQty;
use App\Models\SecretariatStores;
use App\Models\Settlement;
use App\Models\Shifts;
use App\Models\ShippingDefault;
use App\Models\ShippingStatus;
use App\Models\ShippingType;
use App\Models\Shortcomings;
use App\Models\ShowPrintDefault;
use App\Models\StartPeriods;
use App\Models\StoreCountSales;
use App\Models\Stores;
use App\Models\StoresDefaultData;
use App\Models\StoresMoves;
use App\Models\StorsTransfers;
use App\Models\Taxes;
use App\Models\Tenant;
use App\Models\Transltor;
use App\Models\UsersMoves;
use Illuminate\Http\Request;
use Spatie\DbDumper\Databases\PostgreSql;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use File;
use DB;
use Str;
class SettingsController extends Controller
{


    function __construct()
    {


        $this->middleware('permission:الترجمه', ['only' => ['TranslatePage']]);
        $this->middleware('permission:البيانات الافتراضيه', ['only' => ['Default_DataPage','AddDefaultCompanyFirst','AddDefaultCompany','AddDefaultAccountsFirst','AddDefaultAccount','AddDefaultStoreFirst','AddDefaultStore','AddDefaultCrmFirst','AddDefaultCrm','AddDefaultPurchasesFirst','AddDefaultPurchases','AddDefaultSalesFirst','AddDefaultSales']]);
        $this->middleware('permission:حذف الحركات', ['only' => ['DeleteMoves']]);

    }

//Truncate
    public function Truncate(){


        Sales::truncate();
        SalesOrder::truncate();
        Quote::truncate();
        QuoteImage::truncate();
        Purchases::truncate();
        PurchasesOrder::truncate();
        GeneralDaily::truncate();
        Journalizing::truncate();
        ReciptVoucher::truncate();
        PaymentVoucher::truncate();
        OpeningEntries::truncate();
        Inventory::truncate();
        Settlement::truncate();
        StartPeriods::truncate();
        StorsTransfers::truncate();
        SafeTransfers::truncate();
        ReturnSales::truncate();
        ReturnPurch::truncate();
        ReturnWithoutBill::truncate();
        JobOrder::truncate();
        IncomChecks::truncate();
        ExportChecks::truncate();
        InsurancePaper::truncate();
        Assets::truncate();
        Consists::truncate();
        ExecuteJobOrder::truncate();
        SalesSubscribes::truncate();
        Shortcomings::truncate();


   /*
        ProductsQty::truncate();
        ProductsQuote::truncate();
        ProductSalesOrder::truncate();
        ProductSales::truncate();
        StoreCountSales::truncate();
        Installment::truncate();
        InstallmentDates::truncate();
        ProductMoves::truncate();
        JournalizingDetails::truncate();
        RecivedSales::truncate();
        RecivedSalesProducts::truncate();
        ReturnSalesProducts::truncate();
        ProductsPurchases::truncate();
        ProductsStartPeriods::truncate();
        ProductsStoresTransfers::truncate();
        Shifts::truncate();
        ProductQuoteImage::truncate();
        PaymentVoucherDetails::truncate();
        ReciptVoucherDetails::truncate();
        ProductSalesSubscribes::truncate();
        StoresMoves::truncate();
        ProductsStartPeriods::truncate();
        ProductInventory::truncate();
        ProductSettlement::truncate();
        ProductsStoresTransfers::truncate();
        ProductsPurchases::truncate();
        ProductSales::truncate();
        ProductsConsists::truncate();
        UsersMoves::truncate();
        ProductsPurchasesOrder::truncate();
        ProductsPurchases::truncate();
        ProductsShortcomings::truncate();
        ManufacturingModel::truncate();
        IncomManufacturingModel::truncate();
        OutcomManufacturingModel::truncate();
        ExecutingReceiving::truncate();
        ManuStoreCount::truncate();
        SecretariatStores::truncate();
        SecretariatQty::truncate();
        SecretariatImportGoods::truncate();
        ProductsSecretariatImportGoods::truncate();
        SecretariatExportGoods::truncate();
        ProductsSecretariatExportGoods::truncate();
        Interviews::truncate();
        Projects::truncate();
        ProjectTeam::truncate();
        Missions::truncate();
        OpeningEntriesDetails::truncate();

*/


        return back();
    }


    //AllNotifucations  =====================================================
    public function AllNotifucations(){

        if(auth()->guard('admin')->user()->emp == 0){
            $Notifications=Notifications::orderBy('id','desc')->paginate(30);
        }else{

            $Notifications=Notifications::orderBy('id','desc')->where('Emp',auth()->guard('admin')->user()->emp)->paginate(30);

        }

        return view('admin.Notifications',['Notifications'=>$Notifications]);
    }
    public function ReadAllNotifucations(){

   Notifications::where('Status',0)->update(['Status'=>1]);

        return back();

    }

    public function ReadNoti($id){
        Notifications::where('id',$id)->update(['Status'=>1]);
        return back();
    }

    public function UnReadNoti($id){
        Notifications::where('id',$id)->update(['Status'=>0]);
        return back();
    }

    public function DeletNoti($id){
        $del=Notifications::find($id);
        $del->delete();
        session()->flash('error',trans('admin.Deleted'));
        return back();
    }


//RABIH  =====================================================

    //Education
    public function RabihEducation(){

        if(auth()->guard('admin')->user()->email != 'Klar@test.com'){
            $Videos=RabihEducation::where('Package',auth()->guard('admin')->user()->package)->get();
        }else{
            $Videos=RabihEducation::get();
        }
        return view('admin.Settings.RabihEducation',['Videos'=>$Videos]);
    }

    public function AddRabihEdu(){

        try {
            DB::beginTransaction();

        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',
            'English_Name'=>'required',
            'Video'=>'required',
            'Package'=>'required',


        ],[


        ]);


        $data['Arabic_Name']=request('Arabic_Name');
        $data['English_Name']=request('English_Name');
        $data['Video']=request('Video');
        $data['Package']=request('Package');
        RabihEducation::create($data);


            DB::commit();
        session()->flash('success',trans('admin.NewAddAdmin'));
        return back();

        }catch(\Exception $ex){

            $MODEL=RabihEducation::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=RabihEducation::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditRabihEdu($id){


        try {
            DB::beginTransaction();

            $data= $this->validate(request(),[
            'Arabic_Name'=>'required',
            'English_Name'=>'required',
            'Video'=>'required',
            'Package'=>'required',


        ],[


        ]);


        $data['Arabic_Name']=request('Arabic_Name');
        $data['English_Name']=request('English_Name');
        $data['Video']=request('Video');
        $data['Package']=request('Package');


        RabihEducation::where('id',$id)->update($data);


            DB::commit();
        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=RabihEducation::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=RabihEducation::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteRabihEdu($id){

        try {
            DB::beginTransaction();

            $del=RabihEducation::find($id);
        $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){

            $MODEL=RabihEducation::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");


            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=RabihEducation::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    //IntroView  Rabih =======================
    public function IntroView(){

        $Intro=Intro::orderBy('id','desc')->first();
        return view('admin.Settings.IntroView',['Intro'=>$Intro]);
    }

    public function TermsView(){

        $Intro=Intro::orderBy('id','desc')->first();

        return view('admin.Settings.TermsView',[

            'Intro'=>$Intro
        ]);
    }


    //Chat Issues

    public function ReportIssue(){
        $Issues=Issues::orderBy('id','desc')->paginate(20);
        return view('admin.Settings.ReportIssue',['Issues'=>$Issues]);
    }

    public function CreateNewChat(){

        try {
            DB::beginTransaction();

            $user=Admin::find(auth()->guard('admin')->user()->id);


        $res=Issues::orderBy('id','desc')->first();

        if(!empty($res->Code)){

            $Code=$res->Code + 1 ;

        }else{

            $Code=1;

        }
        $ID = DB::table('issues')->insertGetId(
            array(


                'Code' => $Code,
                'Date' => date('Y-m-d'),
                'Time' => date('h-i A'),
                'Client' => $user->name,
                'Link' => URL::to('/'),
                'Status' => 0,



            )
        );


        $Issue=Issues::find($ID);
        $Chat=ChatIssue::where('Issue',$ID)->get();


        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://rabiherp.com/public/api/OpenNewIssueApi',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array('Code' => $Issue->Code,'Date' => $Issue->Date,'Time' => $Issue->Time,'Client' => $Issue->Client,'Link' => $Issue->Link),
            CURLOPT_HTTPHEADER => array(
                'lang: ar'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
            DB::commit();
        return back();


        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function ChatIssue($id){

        $user=Admin::find(auth()->guard('admin')->user()->id);
        $Issue=Issues::find($id);
        $Chat=ChatIssue::where('Issue',$id)->get();
        return view('admin.Settings.ChatIssue',get_defined_vars());
    }

    public function UploadChatImg(Request $request){

        try {
            DB::beginTransaction();
        $image=request()->file('Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AdminsImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }

        if(!empty($image_url)){

            $CHAT['Image']=$image_url;
            $CHAT['Name']=request('Name');
            $CHAT['Date']=date('Y-m-d');
            $CHAT['Time']=date('h-i A');
            $CHAT['Desc']=null;
            $CHAT['Issue']=request('Issue');
            $CHAT['Type']=1;

            ChatIssue::create($CHAT);


            $Iss=Issues::find(request('Issue'));

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://rabiherp.com/public/api/GetTextChatImage',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => array('Code' => $Iss->Code,'Name' => request('Name'),'Date' => date('Y-m-d'),'Time' => date('h-i A'),'Image' => $image_url),
                CURLOPT_HTTPHEADER => array(
                    'lang: ar'
                ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);






        }

            DB::commit();
        return back();


        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }

    function SendIssue(Request $request)
    {
        if($request->ajax())
        {
            $output = '';
            $msgr_input = $request->get('msgr_input');
            $Name = $request->get('Name');
            $Link = $request->get('Link');
            $Auto = $request->get('Auto');
            $Issue = $request->get('Issue');

            if($msgr_input != '' and $Name != '')
            {




                $CHAT['Name']=$Name;
                $CHAT['Date']=date('Y-m-d');
                $CHAT['Time']=date('h-i A');
                $CHAT['Desc']=$msgr_input;
                $CHAT['Issue']=$Issue;
                $CHAT['Type']=1;

                ChatIssue::create($CHAT);

                $Iss=Issues::find($Issue);

                $curl = curl_init();

                curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://rabiherp.com/public/api/GetTextChat',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => array('Code' => $Iss->Code,'Name' => $Name,'Date' => date('Y-m-d'),'Time' => date('h-i A'),'Desc' => $msgr_input),
                    CURLOPT_HTTPHEADER => array(
                        'lang: ar'
                    ),
                ));

                $response = curl_exec($curl);

                curl_close($curl);


                $ff=trans("admin.ThankUForContactUs");
                if($Auto == 1){

                    $x='none';

                }else{
                    $x='block';

                    $CHAT['Name']='Customer Service / خدمة العملاء ';
                    $CHAT['Date']=date('Y-m-d');
                    $CHAT['Time']=date('h-i A');
                    $CHAT['Desc']=$ff;
                    $CHAT['Image']=null;
                    $CHAT['Issue']=$Issue;
                    $CHAT['Type']=2;
                    $CHAT['Appear']=1;

                    ChatIssue::create($CHAT);


                }

                $output .= '

           <div class="chat-segment chat-segment-sent">
           <h2>'.$Name.' </h2>
                                                            <div class="chat-message">
                                                                <p>
                                                            '.$msgr_input.'
                                                                </p>

                                                            </div>
                                                            <div class="text-right fw-300 text-muted mt-1 fs-xs">
                                                               '.date('Y-m-d').'/'.date('h:i A').'
                                                            </div>
                                                        </div>

                                                                       <div class="chat-segment chat-segment-get" style="display:'.$x.'">
                                                                                <h2>Customer Service / خدمة العملاء </h2>
                                                            <div class="chat-message">
                                                                <h3>
                                                              '.$ff.'
                                                                </h3>



                                                            </div>
                                                            <div class="fw-300 text-muted mt-1 fs-xs">
                                                                   '.date('Y-m-d').'/'.date('h:i A').'
                                                            </div>
                                                        </div>


         ';



            }

            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    public function SolveIssue($id){

        try {
            DB::beginTransaction();
        Issues::where('id',$id)->update(['Status'=>1]);


        $Issue=Issues::find($id);

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://rabiherp.com/public/api/SolveIssueApi',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array('Code' => $Issue->Code),
            CURLOPT_HTTPHEADER => array(
                'lang: ar'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

            DB::commit();
        return back();

        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }

    function RefreshSendIssue(Request $request)
    {
        if($request->ajax())
        {
            $output = '';
            $Issue = $request->get('Issue');
            $x = 1;

            if($x == 1)
            {




                $Last=ChatIssue::where('Issue',$Issue)->where('Type',2)->orderBy('id','desc')->first();


                if($Last->Appear != 1){

                    if(!empty($Last->Image)){
                        $imgoo='<img src="'.$Last->Image.'" style="width:40%">';
                    }else{
                        $imgoo='';

                    }
                    $output .= '

                           <div class="chat-segment chat-segment-get">
                                                                                <h2> Customer Service / خدمة العملاء </h2>
                                                            <div class="chat-message">
                                                                <h3>
                                                              '.$Last->Desc.'
                                                                </h3>

                                                  '.$imgoo.'

                                                            </div>
                                                            <div class="fw-300 text-muted mt-1 fs-xs">
                                                                   '.$Last->Date.'/'.$Last->Time.'
                                                            </div>
                                                        </div>





         ';

                    ChatIssue::where('id',$Last->id)->update(['Appear'=>1]);

                }


            }

            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

//GetTextChat  (API)
    public function GetTextChat(){


        $iss=Issues::where('Code',request('Code'))->orderBy('id','desc')->first();
        $CHAT['Name']=request('Name');
        $CHAT['Date']=request('Date');
        $CHAT['Time']=request('Time');
        $CHAT['Desc']=request('Desc');
        $CHAT['Issue']=$iss->id;
        $CHAT['Type']=2;

        ChatIssue::create($CHAT);

        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
        ]);
    }
    public function GetTextChatImage(){


        $iss=Issues::where('Code',request('Code'))->orderBy('id','desc')->first();
        $CHAT['Name']=request('Name');
        $CHAT['Date']=request('Date');
        $CHAT['Time']=request('Time');
        $CHAT['Desc']=null;
        $CHAT['Image']='https://rabiherp.com/public/'.request('Image');
        $CHAT['Issue']=$iss->id;
        $CHAT['Type']=2;

        ChatIssue::create($CHAT);

        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
        ]);
    }

    //SolveIssueApi
    public function AdminSolveIssueApi(){

        $Issue=Issues::orderBy('id','desc')->where('Code',request('Code'))->where('Link',request('Link'))->first();

        Issues::where('id',$Issue->id)->update(['Status'=>1]);

        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
        ]);
    }



    //EmpMail  =====================================================
    public function EmpMail(){
        $items=EmpMail::where('Status',0)->paginate(20);
        $Emps=Employess::type()->get();

        return view('admin.Settings.EmpMail',get_defined_vars());
    }

    public function EmpMailInbox(){
        $items=EmpMail::where('Emp',auth()->guard('admin')->user()->emp)->where('Status',0)->paginate(20);
        $Emps=Employess::type()->get();
        return view('admin.Settings.EmpMailInbox',get_defined_vars());
    }

    public function AddEmpMail(){
        try {
            DB::beginTransaction();

        $data= $this->validate(request(),[
            'Emp'=>'required',
            'Message'=>'required',
        ],[
        ]);

        if(!empty(request('Emp'))){
            $Emp=request('Emp');

            for ($i=0; $i < count($Emp) ; $i++){

                $data['Emp']=$Emp[$i];
                $data['Message']=request('Message');
                $data['Status']=0;
                EmpMail::create($data);

            }


        }

            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();



        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteEmpMail($id){

        try {
            DB::beginTransaction();

            $del=EmpMail::find($id);
        $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function ReadMailInbox($id){

        EmpMail::where('id',$id)->update(['Status'=>1]);
        return back();

    }

    public function UnReadMailInbox($id){

        EmpMail::where('id',$id)->update(['Status'=>0]);
        return back();

    }


    //QR =====================================================
    public function QRPage(){
        $item=QR::orderBy('id','desc')->first();
        return view('admin.Settings.QR',['item'=>$item]);
    }

    public function QRUpdate(){

        $data['QR']=request('QR');
        QR::orderBy('id','desc')->update($data);
        session()->flash('success',trans('admin.Updated'));
        return back();

    }



    // = ======== . Backup  ==========

    public function BackupPage(){
        return view('admin.Settings.Backup');
    }

    public function GetBackup(){

        try {
            DB::beginTransaction();

            $def=CompanyData::orderBy('id','desc')->first();

            $backup_name = $def->Name.'-Rabih-' . date('c')  . '.sql';

            PostgreSql::create()
                ->setDbName(env('DB_DATABASE'))
                ->setUserName(env('DB_USERNAME'))
                ->setPassword(env('DB_PASSWORD'))
                ->dumpToFile($backup_name);

            DB::commit();

        session()->flash('success',trans('admin.Backup_success'));
        return back();

        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteBackup(){

        try {
            DB::beginTransaction();

            // Storage::delete(request('X'));
        File::delete(request('X'));
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }





    //DeleteMoves  =====================================================
    public function DeleteMoves(){

        return view('admin.Settings.DeleteMoves');
    }

    public function PostDeleteMoves(){

        try {
            DB::beginTransaction();


            if(request('All') == 1){

            Sales::truncate();
            SalesOrder::truncate();
            Quote::truncate();
            QuoteImage::truncate();
            Purchases::truncate();
            PurchasesOrder::truncate();
            GeneralDaily::truncate();
            Journalizing::truncate();
            ReciptVoucher::truncate();
            PaymentVoucher::truncate();
            OpeningEntries::truncate();
            Inventory::truncate();
            Settlement::truncate();
            StartPeriods::truncate();
            StorsTransfers::truncate();
            SafeTransfers::truncate();
            ReturnSales::truncate();
            ReturnPurch::truncate();
            ReturnWithoutBill::truncate();
            JobOrder::truncate();
            IncomChecks::truncate();
            ExportChecks::truncate();
            InsurancePaper::truncate();
            Assets::truncate();
            Consists::truncate();
            ExecuteJobOrder::truncate();
            SalesSubscribes::truncate();
            Shortcomings::truncate();
            ProductsQty::truncate();
            ProductsQuote::truncate();
            ProductSalesOrder::truncate();
            ProductSales::truncate();
            StoreCountSales::truncate();
            Installment::truncate();
            InstallmentDates::truncate();
            ProductMoves::truncate();
            JournalizingDetails::truncate();
            RecivedSales::truncate();
            RecivedSalesProducts::truncate();
            ReturnSalesProducts::truncate();
            ProductsPurchases::truncate();
            ProductsStartPeriods::truncate();
            ProductsStoresTransfers::truncate();
            Shifts::truncate();
            ProductQuoteImage::truncate();
            PaymentVoucherDetails::truncate();
            ReciptVoucherDetails::truncate();
            ProductSalesSubscribes::truncate();
            StoresMoves::truncate();
            ProductsStartPeriods::truncate();
            ProductInventory::truncate();
            ProductSettlement::truncate();
            ProductsStoresTransfers::truncate();
            ProductsPurchases::truncate();
            ProductSales::truncate();
            ProductsConsists::truncate();
            UsersMoves::truncate();
            ProductsPurchasesOrder::truncate();
            ProductsPurchases::truncate();
            ProductsShortcomings::truncate();
            ManufacturingModel::truncate();
            IncomManufacturingModel::truncate();
            OutcomManufacturingModel::truncate();
            ExecutingReceiving::truncate();
            ManuStoreCount::truncate();
            SecretariatStores::truncate();
            SecretariatQty::truncate();
            SecretariatImportGoods::truncate();
            ProductsSecretariatImportGoods::truncate();
            SecretariatExportGoods::truncate();
            ProductsSecretariatExportGoods::truncate();
            Interviews::truncate();
            Projects::truncate();
            ProjectTeam::truncate();
            Missions::truncate();
            OpeningEntriesDetails::truncate();
        }else{

            if(request('Sales') == 1){
                $items=Sales::all();

                foreach($items as $item){
                    $id=$item->id;
                    $del=Sales::find($id);

                    GeneralDaily::where('Code_Type',$del->Code)->where('Type','المبيعات')->delete();
                    Journalizing::where('Code_Type',$del->Code)->where('Type','المبيعات')->delete();
                    ProductMoves::where('Bill_Num',$del->Code)->where('Type','مبيعات')->delete();
                    StoresMoves::where('ID',$del->id)->where('Type','مبيعات')->delete();
                    $Products=ProductSales::where('Sales',$del->id)->where('Qty','!=',0)->get();
                    foreach($Products as $prod){

                        if($prod->Product()->first()->P_Type == 'Assembly'){

                            $Asembs=AssemblyProducts::where('p_id',$prod->Product)->get();

                            foreach($Asembs as $ass){

                                $Quantity =ProductsQty::
                                where('Store',$prod->Store)
                                    ->where('Product',$ass->Product)
                                    ->where('P_Code',$ass->P_Code)
                                    ->first();


                                if(empty($Quantity)){

                                    $Quantity =ProductsQty::
                                    where('Store',$prod->Store)
                                        ->where('Product',$ass->Product)
                                        ->where('PP_Code',$ass->P_Code)
                                        ->first();

                                    if(empty($Quantity)){

                                        $Quantity =ProductsQty::
                                        where('Store',$prod->Store)
                                            ->where('Product',$ass->Product)
                                            ->where('PPP_Code',$ass->P_Code)
                                            ->first();


                                        if(empty($Quantity)){

                                            $Quantity =ProductsQty::
                                            where('Store',$prod->Store)
                                                ->where('Product',$ass->Product)
                                                ->where('PPPP_Code',$ass->P_Code)
                                                ->first();

                                        }



                                    }






                                }

                                if(!empty($Quantity)){
                                    $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                                    $qq= $unit->Rate * ($prod->Qty * $ass->Qty) ;

                                    $newqty=abs($Quantity->Qty) -  $qq ;

                                    ProductsQty::where('id',$Quantity->id)->update(['Qty'=>abs($newqty)]);

                                }




                            }

                        }


                        if($prod->Product()->first()->P_Type != 'Service' or $prod->Product()->first()->P_Type != 'Assembly'){
                            $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                            $qq= $unit->Rate * $prod->Qty ;

                            $PR=ProductsQty::where('Product',$prod->Product)
                                ->where('P_Code',$prod->Product_Code)
                                ->where('Store',$prod->Store)
                                ->first();

                            if(empty($PR)){

                                $PR=ProductsQty::where('Product',$prod->Product)
                                    ->where('PP_Code',$prod->Product_Code)
                                    ->where('Store',$prod->Store)
                                    ->first();

                                if(empty($PR)){

                                    $PR=ProductsQty::where('Product',$prod->Product)
                                        ->where('PPP_Code',$prod->Product_Code)
                                        ->where('Store',$prod->Store)
                                        ->first();

                                    if(empty($PR)){

                                        $PR=ProductsQty::where('Product',$prod->Product)
                                            ->where('PPPP_Code',$prod->Product_Code)
                                            ->where('Store',$prod->Store)
                                            ->first();


                                    }



                                }


                            }


                            if(!empty($PR)){
                                $newqty=$PR->Qty + $qq ;

                                ProductsQty::where('id',$PR->id)->update(['Qty'=>$newqty]);
                            }
                        }
                    }

                    $del->delete();

                }

            }

            if(request('StartPeriod') == 1){
                $items=StartPeriods::all();

                foreach($items as $item){
                    $id=$item->id;
                    $del=StartPeriods::find($id);

                    GeneralDaily::where('Code_Type',$del->Code)->where('Type','اصناف بداية فترة')->delete();
                    Journalizing::where('Code_Type',$del->Code)->where('Type','اصناف بداية فترة')->delete();
                    ProductMoves::where('Bill_Num',$del->Code)->where('Type','بدايه فتره')->delete();
                    StoresMoves::where('ID',$del->id)->where('Type','بدايه فتره')->delete();


                    $Products=ProductsStartPeriods::where('SP_ID',$del->id)->get();

                    foreach($Products as $prod){

                        $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                        $qq= $unit->Rate * $prod->Qty ;

                        $PR=ProductsQty::where('Product',$prod->Product)
                            ->where('P_Code',$prod->Product_Code)
                            ->where('Store',$prod->Store)
                            ->first();

                        if(empty($PR)){

                            $PR=ProductsQty::where('Product',$prod->Product)
                                ->where('PP_Code',$prod->Product_Code)
                                ->where('Store',$prod->Store)
                                ->first();

                            if(empty($PR)){

                                $PR=ProductsQty::where('Product',$prod->Product)
                                    ->where('PPP_Code',$prod->Product_Code)
                                    ->where('Store',$prod->Store)
                                    ->first();

                                if(empty($PR)){

                                    $PR=ProductsQty::where('Product',$prod->Product)
                                        ->where('PPPP_Code',$prod->Product_Code)
                                        ->where('Store',$prod->Store)
                                        ->first();


                                }



                            }


                        }




                        $newqty=$PR->Qty - $qq ;

                        ProductsQty::where('id',$PR->id)->update(['Qty'=>$newqty]);

                    }


                    $del->delete();

                }
            }

            if(request('Purchases') == 1){
                $items=Purchases::all();

                foreach($items as $item){
                    $id=$item->id;
                    $del=Purchases::find($id);

                    GeneralDaily::where('Code_Type',$del->Code)->where('Type','المشتريات')->delete();
                    Journalizing::where('Code_Type',$del->Code)->where('Type','المشتريات')->delete();
                    ProductMoves::where('Bill_Num',$del->Code)->where('Type','مشتريات')->delete();
                    StoresMoves::where('ID',$del->id)->where('Type','مشتريات')->delete();

                    $Products=ProductsPurchases::where('Purchase',$del->id)->get();
                    foreach($Products as $prod){

                        $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                        $qq= $unit->Rate * $prod->Qty ;

                        $PR=ProductsQty::where('Product',$prod->Product)
                            ->where('P_Code',$prod->Product_Code)
                            ->where('Store',$prod->Store)
                            ->first();

                        if(empty($PR)){

                            $PR=ProductsQty::where('Product',$prod->Product)
                                ->where('PP_Code',$prod->Product_Code)
                                ->where('Store',$prod->Store)
                                ->first();

                            if(empty($PR)){

                                $PR=ProductsQty::where('Product',$prod->Product)
                                    ->where('PPP_Code',$prod->Product_Code)
                                    ->where('Store',$prod->Store)
                                    ->first();

                                if(empty($PR)){

                                    $PR=ProductsQty::where('Product',$prod->Product)
                                        ->where('PPPP_Code',$prod->Product_Code)
                                        ->where('Store',$prod->Store)
                                        ->first();


                                }



                            }


                        }




                        $newqty=$PR->Qty - $qq ;

                        ProductsQty::where('id',$PR->id)->update(['Qty'=>$newqty]);

                    }

                    $del->delete();

                }
            }

            if(request('StoresTransfer') == 1){
                $items=StorsTransfers::all();

                foreach($items as $item){

                    $id=$item->id;
                    $del=StorsTransfers::find($id);

                    GeneralDaily::where('Code_Type',$del->Code)->where('Type','تحويلات المخازن')->delete();
                    Journalizing::where('Code_Type',$del->Code)->where('Type','تحويلات المخازن')->delete();
                    ProductMoves::where('Bill_Num',$del->Code)->where('Type','تحويل مخازن')->delete();

                    StoresMoves::where('ID',$del->id)->where('Type','تحويلات مخازن من')->delete();
                    StoresMoves::where('ID',$del->id)->where('Type','تحويلات مخازن الي')->delete();
                    $Products=ProductsStoresTransfers::where('ST_ID',$del->id)->get();
                    foreach($Products as $prod){

                        $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                        $qq= $unit->Rate * $prod->Trans_Qty ;

                        $PR=ProductsQty::where('Product',$prod->Product)
                            ->where('P_Code',$prod->P_Code)
                            ->where('Store',$prod->To_Store)
                            ->first();

                        $newqty=$PR->Qty - $qq ;
                        ProductsQty::where('id',$PR->id)->update(['Qty'=>$newqty]);

                        $PR=ProductsQty::where('Product',$prod->Product)
                            ->where('P_Code',$prod->P_Code)
                            ->where('Store',$prod->ST_ID()->first()->From_Store)
                            ->first();

                        $newqty=$PR->Qty + $qq ;
                        ProductsQty::where('id',$PR->id)->update(['Qty'=>$newqty]);

                    }

                    $del->delete();

                }
            }

        }

            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }



    //Default_Data  =====================================================
    public function Default_DataPage(){
        $Accounts=AccountsDefaultData::orderBy('id','desc')->first();
        $Crms=CrmDefaultData::orderBy('id','desc')->first();
        $Stores=StoresDefaultData::orderBy('id','desc')->first();
        $Purchases=PurchasesDefaultData::orderBy('id','desc')->first();
        $Sales=SalesDefaultData::orderBy('id','desc')->first();
        $CustomPrint=CustomPrint::orderBy('id','desc')->first();
        $Companies=CompanyData::orderBy('id','desc')->first();
        $Print=ShowPrintDefault::orderBy('id','desc')->first();
        $ShowHide=DefaultDataShowHide::orderBy('id','desc')->first();
        $Maint=MaintainceDefaultData::orderBy('id','desc')->first();
        $Manu=ManufacturingDefaultData::orderBy('id','desc')->first();

        $CustomersGroup=CustomersGroup::all();
        $Coins=Coins::all();
        $Nationality=Countris::all();
        $CostCenters=CostCenter::all();
        $Units=Measuerments::all();
        $Taxes=Taxes::all();
        $ItemsGroups=ItemsGroups::all();
        $Storess=Stores::all();
        $ProductType=ProductTypeDefault::all();
        $Governrates=Governrate::all();
        $Cities=City::all();
        $Activites=Activites::all();
        $ClientStatus=ClientStatus::all();
        $Platforms=Platforms::all();
        $Campaigns=Campaigns::all();
        $Employess=Employess::where("EmpSort",1)->get();
        $Settings=BarcodeSettings::all();

        $Safes = AcccountingManual::
        where('Type',1)
            ->where('Parent',28)
            ->orWhere('Parent',29)
            ->get();

        $Vendors = AcccountingManual::
        where('Type',1)
            ->where('Parent',37)
            ->orWhere('Parent',24)
            ->get();

        $Employesss = Employess::
        where('Emp_Type','Buyer')
            ->where("EmpSort",1)
            ->get();

        $Employessss = Employess::
        where('Emp_Type','Saller')
            ->where("EmpSort",1)
            ->get();


        $Waiters = Employess::
        where('Emp_Type','Waiter')
            ->where("EmpSort",1)
            ->get();



        $Deliveries = Employess::
        where('Emp_Type','Delivery')
            ->where("EmpSort",1)
            ->get();

        $Companiesss=ManufactureCompany::all();
        $Cases=DesviceCases::all();
        $Engs = Employess::
        where('Emp_Type','Engineer')
            ->where("EmpSort",1)
            ->get();

        $ManufacturingHalls=ManufacturingHalls::all();

        $Shipping=ShippingDefault::orderBy('id','desc')->first();
        $Types=ShippingType::all();
        $Status=ShippingStatus::all();
        $vendors = AcccountingManual::
        where('Type',1)
            ->where('Parent',37)
            ->get();
        $clients = AcccountingManual::
        where('Type',1)
            ->where('Parent',24)
            ->get();


        return view('admin.Settings.Default_Data',get_defined_vars());
    }

    public function AddDefaultCompanyFirst(){

        $data['Name']=null;
        CompanyData::create($data);
        return back();

    }

    public function AddDefaultCompany(){

        $data= $this->validate(request(),[
            'Name'=>'required',
            'Logo'=>'image|mimes:jpeg,png,jpg|max:2048',
            'Icon'=>'image|mimes:jpeg,png,jpg|max:2048',
        ],[
            'Name.required' => trans('admin.nameRequired'),


        ]);

        $image=request()->file('Logo');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='LogoImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }


        if(!empty($image_url)){

            $data['Logo']=$image_url;

        }else{
            $data['Logo']=request('Logos');
        }


        $imagee=request()->file('Icon');
        if($imagee){
            $image_namee=Str::random(20);
            $exte=strtolower($imagee->getClientOriginalExtension());
            $image_full_namee=$image_namee .'.' . $exte ;
            $upload_pathe='IconImages/';
            $image_urle=$upload_pathe.$image_full_namee;
            $successe=$imagee->move($upload_pathe,$image_full_namee);
        }


        if(!empty($image_urle)){

            $data['Icon']=$image_urle;

        }else{
            $data['Icon']=request('Icons');
        }




        $imagex=request()->file('Seal');
        if($imagex){
            $image_namex=Str::random(20);
            $extx=strtolower($imagex->getClientOriginalExtension());
            $image_full_namex=$image_namex .'.' . $extx ;
            $upload_pathx='LogoImages/';
            $image_urlx=$upload_pathx.$image_full_namex;
            $successx=$imagex->move($upload_pathx,$image_full_namex);
        }


        if(!empty($image_urlx)){

            $data['Seal']=$image_urlx;

        }else{
            $data['Seal']=request('Seals');
        }


        $imagexs=request()->file('Logo_Store');
        if($imagexs){
            $image_namexs=Str::random(20);
            $extxs=strtolower($imagexs->getClientOriginalExtension());
            $image_full_namexs=$image_namexs .'.' . $extxs ;
            $upload_pathxs='LogoImages/';
            $image_urlxs=$upload_pathxs.$image_full_namexs;
            $successxs=$imagexs->move($upload_pathxs,$image_full_namexs);
        }


        if(!empty($image_urlxs)){

            $data['Logo_Store']=$image_urlxs;

        }else{
            $data['Logo_Store']=request('Logo_StoreS');
        }



        $imagexse=request()->file('Icon_Store');
        if($imagexse){
            $image_namexse=Str::random(20);
            $extxse=strtolower($imagexse->getClientOriginalExtension());
            $image_full_namexse=$image_namexse .'.' . $extxse ;
            $upload_pathxse='LogoImages/';
            $image_urlxse=$upload_pathxse.$image_full_namexse;
            $successxse=$imagexse->move($upload_pathxse,$image_full_namexse);
        }


        if(!empty($image_urlxse)){

            $data['Icon_Store']=$image_urlxse;

        }else{
            $data['Icon_Store']=request('Icon_StoreS');
        }






        $imagePDF=request()->file('PDF');
        if($imagePDF){
            $image_namePDF=Str::random(20);
            $extPDF=strtolower($imagePDF->getClientOriginalExtension());
            $image_full_namePDF=$image_namePDF .'.' . $extPDF ;
            $upload_pathPDF='LogoImages/';
            $image_urlPDF=$upload_pathPDF.$image_full_namePDF;
            $successPDF=$imagePDF->move($upload_pathPDF,$image_full_namePDF);
        }


        if(!empty($image_urlPDF)){

            $data['PDF']=$image_urlPDF;

        }else{
            $data['PDF']=request('PDFs');
        }


        $data['Name']=request('Name');
        $data['NameEn']=request('NameEn');
        $data['View']=request('View');
        $data['Phone1']=request('Phone1');
        $data['Phone2']=request('Phone2');
        $data['Phone3']=request('Phone3');
        $data['Phone4']=request('Phone4');
        $data['Address']=request('Address');
        $data['Commercial_Record']=request('Commercial_Record');
        $data['Tax_File_Number']=request('Tax_File_Number');
        $data['Print_Text']=request('Print_Text');
        $data['Print_Text_Footer']=request('Print_Text_Footer');
        $data['Print_Text_Footer_Sales']=request('Print_Text_Footer_Sales');
        $data['Name_Sales_Bill']=request('Name_Sales_Bill');
        $data['Name_Sales_Order_Bill']=request('Name_Sales_Order_Bill');
        $data['Print_Text_Footer_Quote']=request('Print_Text_Footer_Quote');
        $data['Name_Quote_Bill']=request('Name_Quote_Bill');
        $data['Print_Text_Footer_Secretariat']=request('Print_Text_Footer_Secretariat');
        $data['Tax_Registration_Number']=request('Tax_Registration_Number');
        $data['Tax_activity_code']=request('Tax_activity_code');
        $data['work_nature']=request('work_nature');
        $data['Governrate']=request('Governrate');
        $data['City']=request('City');
        $data['Place']=request('Place');
        $data['Nationality']=request('Nationality');
        $data['Buliding_Num']=request('Buliding_Num');
        $data['Street']=request('Street');
        $data['Postal_Code']=request('Postal_Code');
        $data['tax_magistrate']=request('tax_magistrate');
        $data['Client_ID']=request('Client_ID');
        $data['Serial_Client_ID']=request('Serial_Client_ID');
        $data['Print_Text_Footer_Manufacturing']=request('Print_Text_Footer_Manufacturing');
        $data['Version_Type']=request('Version_Type');
        $data['Computer_SN']=request('Computer_SN');
        $data['Invoice_Type']=request('Invoice_Type');
        $data['Floor']=request('Floor');
        $data['Room']=request('Room');
        $data['Landmark']=request('Landmark');
        $data['Add_Info']=request('Add_Info');
        $data['POS_Version']=request('POS_Version');
        $data['Path']=request('Path');
        $data['DB_Backup']=request('DB_Backup');
        $data['AddressEn']=request('AddressEn');
        $data['Print_Text_En']=request('Print_Text_En');
        $data['Print_Text_Footer_En']=request('Print_Text_Footer_En');
        $data['Print_Text_Footer_Manufacturing_En']=request('Print_Text_Footer_Manufacturing_En');
        $data['Print_Text_Footer_Sales_En']=request('Print_Text_Footer_Sales_En');
        $data['Print_Text_Footer_Quote_En']=request('Print_Text_Footer_Quote_En');
        $data['Print_Text_Footer_Secretariat_En']=request('Print_Text_Footer_Secretariat_En');
        $data['Name_Sales_Bill_En']=request('Name_Sales_Bill_En');
        $data['Name_Sales_Order_Bill_En']=request('Name_Sales_Order_Bill_En');
        $data['Name_Quote_Bill_En']=request('Name_Quote_Bill_En');
        $data['Location']=request('Location');
        $data['Email']=request('Email');
        $data['HomeMainScreen']=request('HomeMainScreen');
        $data['Bill_View']=request('Bill_View');
        $data['Font_Type']=request('Font_Type');
        $data['Welcome_Arabic_Word_App']=request('Welcome_Arabic_Word_App');
        $data['Welcome_English_Word_App']=request('Welcome_English_Word_App');


        CompanyData::orderBy('id','desc')->update($data);


        session()->flash('success',trans('admin.Updated'));
        return back();

    }

    public function AddDefaultAccountsFirst(){


        $data['Coin']=null;

        AccountsDefaultData::create($data);


        return back();

    }

    public function AddDefaultAccount(){

        $data= $this->validate(request(),[
            'Coin'=>'required',

        ],[
            'Coin.required' => trans('admin.CoinRequired'),


        ]);




        $data['Coin']=request('Coin');
        $data['Draw']=request('Draw');
        $data['Sure_Recipts']=request('Sure_Recipts');
        $data['Show_Group']=request('Show_Group');
        $data['Account_Balance']=request('Account_Balance');
        $data['Salary']=request('Salary');
        $data['Commission']=request('Commission');
        $data['Draw_Show']=request('Draw_Show');
        $data['Coin_Show']=request('Coin_Show');
        $data['Cost_Show']=request('Cost_Show');
        $data['Collect_Show']=request('Collect_Show');
        $data['Sales_Bill_Show']=request('Sales_Bill_Show');
        $data['Hide_Edit_Delete']=request('Hide_Edit_Delete');
        $data['Order_Number']=request('Order_Number');

        AccountsDefaultData::orderBy('id','desc')->update($data);


        session()->flash('success',trans('admin.Updated'));
        return back();

    }

    public function AddDefaultStoreFirst(){


        $data['Group']=null;

        StoresDefaultData::create($data);


        return back();

    }

    public function AddDefaultStore(){

        $data= $this->validate(request(),[
            'Group'=>'required',
            'Unit'=>'required',
            'Tax'=>'required',
            'Coin'=>'required',
            'Account_Excess'=>'required',
            'Account_Dificit'=>'required',
            'Store'=>'required',

        ],[



        ]);


        $data['Group']=request('Group');
        $data['Unit']=request('Unit');
        $data['Tax']=request('Tax');
        $data['Coin']=request('Coin');
        $data['Account_Excess']=request('Account_Excess');
        $data['Account_Dificit']=request('Account_Dificit');
        $data['Store']=request('Store');
        $data['Type']=request('Type');
        $data['Style']=request('Style');
        $data['Guide_Product_Cost']=request('Guide_Product_Cost');
        $data['Client_Store_Account']=request('Client_Store_Account');
        $data['StoresTarnsferPrice']=request('StoresTarnsferPrice');
        $data['Show_Ship']=request('Show_Ship');
        $data['StoresTarnsferHide']=request('StoresTarnsferHide');
        $data['CodeType']=request('CodeType');
        $data['ReturnStoresTransfer']=request('ReturnStoresTransfer');
        $data['Cost_Price']=request('Cost_Price');
        $data['Hide_Product']=request('Hide_Product');
        $data['StartPeriod_Show_Product']=request('StartPeriod_Show_Product');

        StoresDefaultData::orderBy('id','desc')->update($data);


        if(!empty(request('P_Type'))){
            ProductTypeDefault::truncate();
            $type=request('P_Type');

            for($i=0 ; $i < count($type) ; $i++){

                $tt['Type']=$type[$i];

                ProductTypeDefault::create($tt);
            }




        }

        if(!empty(request('Show'))){

            $Shows=request('Show');
            $comp=0;
            $pN=0;
            $pP=0;
            $coin=0;
            $unit=0;
            $group=0;
            $code=0;
            $logo=0;

            for($i=0 ; $i < count($Shows) ; $i++){

                if($Shows[$i] == 'CompanyName'){
                    $comp += 1 ;
                }else{
                    $comp += 0 ;

                }

                if($Shows[$i] == 'ProductName'){
                    $pN += 1 ;
                }else{
                    $pN += 0 ;

                }

                if($Shows[$i] == 'ProductPrice'){
                    $pP += 1 ;
                }else{

                    $pP += 0 ;
                }

                if($Shows[$i] == 'Coin'){
                    $coin += 1 ;
                }else{

                    $coin += 0 ;
                }

                if($Shows[$i] == 'Unit'){
                    $unit += 1 ;
                }else{

                    $unit += 0 ;
                }

                if($Shows[$i] == 'Group'){
                    $group += 1 ;
                }else{

                    $group += 0 ;
                }

                if($Shows[$i] == 'Code'){
                    $code += 1 ;
                }else{

                    $code += 0 ;
                }

                if($Shows[$i] == 'Logo'){
                    $logo += 1 ;
                }else{

                    $logo += 0 ;
                }


            }


            $ttt['CompanyName']=$comp;
            $ttt['ProductName']=$pN;
            $ttt['ProductPrice']=$pP;
            $ttt['Coin']=$coin;
            $ttt['Unit']=$unit;
            $ttt['Group']=$group;
            $ttt['Code']=$code;
            $ttt['Logo']=$logo;

            ShowPrintDefault::orderBy('id','desc')->update($ttt);



        }



        session()->flash('success',trans('admin.Updated'));
        return back();

    }

    public function AddDefaultCrmFirst(){


        $data['Price_Level']=null;

        CrmDefaultData::create($data);



        return back();

    }

    public function AddDefaultCrm(){

        $data= $this->validate(request(),[
            'Price_Level'=>'required',
            'Governrate'=>'required',
            'City'=>'required',
            'Responsible'=>'required',
            'Activity'=>'required',
            'Campagin'=>'required',
            'ClientStatus'=>'required',
            'Platforms'=>'required',

        ],[



        ]);


        $data['Price_Level']=request('Price_Level');
        $data['Governrate']=request('Governrate');
        $data['City']=request('City');
        $data['Responsible']=request('Responsible');
        $data['Activity']=request('Activity');
        $data['Campagin']=request('Campagin');
        $data['ClientStatus']=request('ClientStatus');
        $data['Platforms']=request('Platforms');
        $data['Client_Delegate']=request('Client_Delegate');
        $data['Nationality']=request('Nationality');
        $data['ClientGroup']=request('ClientGroup');

        CrmDefaultData::orderBy('id','desc')->update($data);


        session()->flash('success',trans('admin.Updated'));
        return back();

    }

    public function AddDefaultPurchasesFirst(){


        $data['Payment_Method']=null;

        PurchasesDefaultData::create($data);



        return back();

    }

    public function AddDefaultPurchases(){

        $data= $this->validate(request(),[
            'Payment_Method'=>'required',
            'Status'=>'required',
            'V_and_C'=>'required',
            'Safe'=>'required',
            'Vendor'=>'required',
            'Delegate'=>'required',
            'Store'=>'required',
            'Coin'=>'required',

        ],[



        ]);


        $data['Payment_Method']=request('Payment_Method');
        $data['Status']=request('Status');
        $data['V_and_C']=request('V_and_C');
        $data['Safe']=request('Safe');
        $data['Vendor']=request('Vendor');
        $data['Delegate']=request('Delegate');
        $data['Store']=request('Store');
        $data['Coin']=request('Coin');
        $data['Brand']=request('Brand');
        $data['Group']=request('Group');
        $data['English_Name']=request('English_Name');
        $data['Expire']=request('Expire');
        $data['Quality_Qty']=request('Quality_Qty');
        $data['Empp']=request('Empp');
        $data['Discount']=request('Discount');
        $data['Hide_Product']=request('Hide_Product');
        $data['Hide_Edit_Delete']=request('Hide_Edit_Delete');
        $data['Duplicate_Items']=request('Duplicate_Items');

        PurchasesDefaultData::orderBy('id','desc')->update($data);


        session()->flash('success',trans('admin.Updated'));
        return back();

    }

    public function AddDefaultSalesFirst(){


        $data['Payment_Method']=null;

        SalesDefaultData::create($data);



        return back();

    }

    public function AddDefaultSales(){

        $data= $this->validate(request(),[
            'Payment_Method'=>'required',
            'Status'=>'required',
            'V_and_C'=>'required',
            'Safe'=>'required',
            'Client'=>'required',
            'Delegate'=>'required',
            'Store'=>'required',
            'Coin'=>'required',

        ],[



        ]);


        $data['Payment_Method']=request('Payment_Method');
        $data['Status']=request('Status');
        $data['V_and_C']=request('V_and_C');
        $data['Mainus']=request('Mainus');
        $data['Price_Sale']=request('Price_Sale');
        $data['Safe']=request('Safe');
        $data['Client']=request('Client');
        $data['Delegate']=request('Delegate');
        $data['Store']=request('Store');
        $data['Coin']=request('Coin');
        $data['Brand']=request('Brand');
        $data['Group']=request('Group');
        $data['English_Name']=request('English_Name');
        $data['Expire']=request('Expire');
        $data['Draw']=request('Draw');
        $data['Empp']=request('Empp');
        $data['Discount']=request('Discount');
        $data['Shift_Pass']=request('Shift_Pass');
        $data['Delivery']=request('Delivery');
        $data['Execute_Precent']=request('Execute_Precent');
        $data['StoresQty']=request('StoresQty');
        $data['DelegateEmp']=request('DelegateEmp');
        $data['TaxType']=request('TaxType');
        $data['DiscountTaxShow']=request('DiscountTaxShow');
        $data['SalesOrderType']=request('SalesOrderType');
        $data['ECommercceSaleType']=request('ECommercceSaleType');
        $data['Kitchen_Order']=request('Kitchen_Order');
        $data['Waiter']=request('Waiter');
        $data['Hall_Service_Type']=request('Hall_Service_Type');
        $data['Hall_Service_Precent']=request('Hall_Service_Precent');
        $data['CountryResturantWebsite']=request('CountryResturantWebsite');
        $data['Bank']=request('Bank');
        $data['Country']=request('Country');
        $data['SalesLowCostPrice']=request('SalesLowCostPrice');
        $data['ShowJobOrders']=request('ShowJobOrders');
        $data['LimitSalesQty']=request('LimitSalesQty');
        $data['Total_Wight_Bill']=request('Total_Wight_Bill');
        $data['Duplicate_Items']=request('Duplicate_Items');
        $data['ExecuteEmp']=request('ExecuteEmp');
        $data['Hide_Product']=request('Hide_Product');
        $data['Choice_Collector_POS']=request('Choice_Collector_POS');
        $data['Hide_Discount_POS']=request('Hide_Discount_POS');
        $data['Hide_Edit_Delete']=request('Hide_Edit_Delete');
        $data['Daily_Clients']=request('Daily_Clients');
        $data['Location_Conditon']=request('Location_Conditon');
        $data['Show_Image_Print']=request('Show_Image_Print');

        SalesDefaultData::orderBy('id','desc')->update($data);


        session()->flash('success',trans('admin.Updated'));
        return back();

    }

    public function AddDefaultShowHideFirst(){


        $data['Coin']=null;

        DefaultDataShowHide::create($data);



        return back();

    }

    public function AddDefaultShowHide(){


        $data['Status']=request('Status');
        $data['Shipping_Company']=request('Shipping_Company');
        $data['Vendor_Date']=request('Vendor_Date');
        $data['Expire_Date']=request('Expire_Date');
        $data['Total_BF_Taxes']=request('Total_BF_Taxes');
        $data['Total_Taxes']=request('Total_Taxes');
        $data['Coin']=request('Coin');
        $data['Draw']=request('Draw');
        $data['Delegate_Sale']=request('Delegate_Sale');
        $data['Delegate_Purchase']=request('Delegate_Purchase');
        $data['Note']=request('Note');
        $data['Refrence_Number']=request('Refrence_Number');
        $data['Cost_Center']=request('Cost_Center');
        $data['Branch']=request('Branch');
        $data['Serial_Num']=request('Serial_Num');
        $data['Pass']=request('Pass');
        $data['Pattern_Image']=request('Pattern_Image');
        $data['Barcode_Print']=request('Barcode_Print');
        $data['Unit_Print']=request('Unit_Print');
        $data['Total_BF_Print']=request('Total_BF_Print');
        $data['Discount_Print']=request('Discount_Print');
        $data['Tax_Print']=request('Tax_Print');
        $data['A4']=request('A4');
        $data['A5']=request('A5');
        $data['CM8']=request('CM8');
        $data['Manufacturing_Model_Shortcomings']=request('Manufacturing_Model_Shortcomings');
        $data['Patch_Number']=request('Patch_Number');
        $data['Group_Brand']=request('Group_Brand');
        $data['Validity_Product']=request('Validity_Product');
        $data['Search_Typical']=request('Search_Typical');
        $data['Executor_Sale']=request('Executor_Sale');
        $data['Totuch_Screen']=request('Totuch_Screen');
        $data['Tax_POS']=request('Tax_POS');
        $data['TaxOnTotal']=request('TaxOnTotal');
        $data['TotalDiscountPrint']=request('TotalDiscountPrint');
        $data['TotalTaxPrint']=request('TotalTaxPrint');
        $data['ProductsNumber']=request('ProductsNumber');
        $data['TotalQtyPrint']=request('TotalQtyPrint');
        $data['Credit']=request('Credit');
        $data['Barcode']=request('Barcode');
        $data['Taknet']=request('Taknet');
        $data['Address']=request('Address');
        $data['Phone1']=request('Phone1');
        $data['Phone2']=request('Phone2');
        $data['Phone3']=request('Phone3');
        $data['Phone4']=request('Phone4');
        $data['Text']=request('Text');
        $data['Seal']=request('Seal');
        $data['Code_Report']=request('Code_Report');
        $data['Unit']=request('Unit');
        $data['Refrence_Number_Print']=request('Refrence_Number_Print');
        $data['Icon_Payment_Recipt']=request('Icon_Payment_Recipt');
        $data['SearchCode']=request('SearchCode');
        $data['TotalBfTax']=request('TotalBfTax');
        $data['AvQty']=request('AvQty');
        $data['Disc']=request('Disc');
        $data['Tax']=request('Tax');
        $data['Store']=request('Store');
        $data['client_delivery']=request('client_delivery');
        $data['TaxBill']=request('TaxBill');
        $data['Note_POS']=request('Note_POS');
        $data['Open_Drawer']=request('Open_Drawer');
        $data['Change_Way_Stores_Transfer']=request('Change_Way_Stores_Transfer');
        $data['POS_RecivedDate']=request('POS_RecivedDate');
        $data['POS_Qty']=request('POS_Qty');
        $data['POS_Barcode']=request('POS_Barcode');
        $data['Thickness_Print']=request('Thickness_Print');
        $data['Height_Print']=request('Height_Print');
        $data['Show_File_ReciptVoucher']=request('Show_File_ReciptVoucher');
        $data['Show_File_PaymentVoucher']=request('Show_File_PaymentVoucher');
        $data['Show_File_Sales']=request('Show_File_Sales');
        $data['Show_File_Purchases']=request('Show_File_Purchases');
        $data['Show_File_Checks']=request('Show_File_Checks');
        $data['Show_File_InsurancePaper']=request('Show_File_InsurancePaper');
        $data['Show_File_TransferStores']=request('Show_File_TransferStores');
        $data['Thickness']=request('Thickness');
        $data['Height']=request('Height');
        $data['Items_Guide_Store_Show']=request('Items_Guide_Store_Show');
        $data['Sales_Pro_Desc']=request('Sales_Pro_Desc');
        $data['Show_Barcode']=request('Show_Barcode');
        $data['Show_Net']=request('Show_Net');
        $data['Show_Unit']=request('Show_Unit');
        $data['Show_Total']=request('Show_Total');

        DefaultDataShowHide::orderBy('id','desc')->update($data);


        session()->flash('success',trans('admin.Updated'));
        return back();

    }

    public function AddDefaultMaintainceFirst(){


        $data['Coin']=null;

        MaintainceDefaultData::create($data);



        return back();

    }

    public function AddDefaultMaintaince(){


        $data['Company']=request('Company');
        $data['Device_Type']=request('Device_Type');
        $data['Device_Case']=request('Device_Case');
        $data['Coin']=request('Coin');
        $data['Cost_Center']=request('Cost_Center');
        $data['Draw']=request('Draw');
        $data['Client']=request('Client');
        $data['Sure']=request('Sure');
        $data['Eng']=request('Eng');
        $data['Recipient']=request('Recipient');
        $data['Store']=request('Store');

        MaintainceDefaultData::orderBy('id','desc')->update($data);


        session()->flash('success',trans('admin.Updated'));
        return back();

    }


    public function AddDefaultManufactureFirst(){


        $data['Coin']=null;

        ManufacturingDefaultData::create($data);



        return back();

    }

    public function AddDefaultManufacture(){


        $data['Coin']=request('Coin');
        $data['Draw']=request('Draw');
        $data['Hall']=request('Hall');
        $data['Manu_Type']=request('Manu_Type');
        $data['Executing_Qty']=request('Executing_Qty');

        ManufacturingDefaultData::orderBy('id','desc')->update($data);


        session()->flash('success',trans('admin.Updated'));
        return back();

    }

    public function AddDefaultShippingFirst(){


        $data['Delegate']=null;
        $data['Vendor']=null;
        $data['Client']=null;
        $data['Type']=null;
        $data['Status']=null;
        $data['Breakable']=null;
        $data['Coin']=null;

        ShippingDefault::create($data);



        return back();

    }

    public function AddDefaultShipping(){

        $data['Delegate']=request('Delegate');
        $data['Vendor']=request('Vendor');
        $data['Client']=request('Client');
        $data['Type']=request('Type');
        $data['Status']=request('Status');
        $data['Breakable']=request('Breakable');
        $data['Coin']=request('Coin');
        $data['Safe']=request('Safe');
        $data['Payment_Method']=request('Payment_Method');

        $data['Show_Coin']=request('Show_Coin');
        $data['Show_Draw']=request('Show_Draw');
        $data['Show_Safe']=request('Show_Safe');
        $data['Show_Code']=request('Show_Code');
        $data['Show_Weight']=request('Show_Weight');
        $data['Show_Width']=request('Show_Width');
        $data['Show_Length']=request('Show_Length');
        $data['Show_Height']=request('Show_Height');

        ShippingDefault::orderBy('id','desc')->update($data);


        session()->flash('success',trans('admin.Updated'));
        return back();

    }


    public function AddDefaultCustomPrintFirst(){


        $data['Sales_Print_Type']=null;
        $data['Sales_Bill_Code']=null;


        CustomPrint::create($data);



        return back();

    }

    public function AddDefaultCustomPrint(){

        $data['Sales_Print_Type']=request('Sales_Print_Type');
        $data['Sales_Bill_Code']=request('Sales_Bill_Code');
        $data['Sales_Date']=request('Sales_Date');
        $data['Sales_Coin']=request('Sales_Coin');
        $data['Sales_Draw']=request('Sales_Draw');
        $data['Sales_Payment_Method']=request('Sales_Payment_Method');
        $data['Sales_Status']=request('Sales_Status');
        $data['Sales_Executor']=request('Sales_Executor');
        $data['Sales_Refernce_Number']=request('Sales_Refernce_Number');
        $data['Sales_Safe']=request('Sales_Safe');
        $data['Sales_Client']=request('Sales_Client');
        $data['Sales_Delegate']=request('Sales_Delegate');
        $data['Sales_Store']=request('Sales_Store');
        $data['Sales_User']=request('Sales_User');
        $data['Sales_Cost_Center']=request('Sales_Cost_Center');
        $data['Sales_Notes']=request('Sales_Notes');
        $data['Sales_Pro_Code']=request('Sales_Pro_Code');
        $data['Sales_Pro_Name']=request('Sales_Pro_Name');
        $data['Sales_Pro_Unit']=request('Sales_Pro_Unit');
        $data['Sales_Pro_Qty']=request('Sales_Pro_Qty');
        $data['Sales_Pro_Price']=request('Sales_Pro_Price');
        $data['Sales_Pro_Discount']=request('Sales_Pro_Discount');
        $data['Sales_Pro_Total_Bf_Tax']=request('Sales_Pro_Total_Bf_Tax');
        $data['Sales_Pro_Total_Tax']=request('Sales_Pro_Total_Tax');
        $data['Sales_Pro_Total']=request('Sales_Pro_Total');
        $data['Sales_Pro_Store']=request('Sales_Pro_Store');
        $data['Sales_Pro_Desc']=request('Sales_Pro_Desc');
        $data['Sales_Pro_Exp_Date']=request('Sales_Pro_Exp_Date');
        $data['Sales_Pro_Weight']=request('Sales_Pro_Weight');
        $data['Sales_Pro_Patch_Number']=request('Sales_Pro_Patch_Number');
        $data['Sales_Product_Numbers']=request('Sales_Product_Numbers');
        $data['Sales_Total_Qty']=request('Sales_Total_Qty');
        $data['Sales_Total_Discount']=request('Sales_Total_Discount');
        $data['Sales_Total_Bf_Taxes']=request('Sales_Total_Bf_Taxes');
        $data['Sales_Total_Taxes']=request('Sales_Total_Taxes');
        $data['Sales_Total_Price']=request('Sales_Total_Price');
        $data['Sales_Paid']=request('Sales_Paid');
        $data['Sales_Residual']=request('Sales_Residual');
        $data['Sales_Taknet']=request('Sales_Taknet');
        $data['Sales_Credit']=request('Sales_Credit');
        $data['Sales_Barcode']=request('Sales_Barcode');
        $data['Sales_Text']=request('Sales_Text');
        $data['Sales_Seal']=request('Sales_Seal');
        $data['Purch_Print_Type']=request('Purch_Print_Type');
        $data['Purch_Bill_Code']=request('Purch_Bill_Code');
        $data['Purch_Date']=request('Purch_Date');
        $data['Purch_Vendor_Bill_Date']=request('Purch_Vendor_Bill_Date');
        $data['Purch_Coin']=request('Purch_Coin');
        $data['Purch_Draw']=request('Purch_Draw');
        $data['Purch_Payment_Method']=request('Purch_Payment_Method');
        $data['Purch_Status']=request('Purch_Status');
        $data['Purch_Refernce_Number']=request('Purch_Refernce_Number');
        $data['Purch_Safe']=request('Purch_Safe');
        $data['Purch_Vendor']=request('Purch_Vendor');
        $data['Purch_Delegate']=request('Purch_Delegate');
        $data['Purch_Store']=request('Purch_Store');
        $data['Purch_User']=request('Purch_User');
        $data['Purch_Cost_Center']=request('Purch_Cost_Center');
        $data['Purch_Notes']=request('Purch_Notes');
        $data['Purch_Pro_Code']=request('Purch_Pro_Code');
        $data['Purch_Pro_Name']=request('Purch_Pro_Name');
        $data['Purch_Pro_Unit']=request('Purch_Pro_Unit');
        $data['Purch_Pro_Qty']=request('Purch_Pro_Qty');
        $data['Purch_Pro_Price']=request('Purch_Pro_Price');
        $data['Purch_Pro_Discount']=request('Purch_Pro_Discount');
        $data['Purch_Pro_Total_Bf_Tax']=request('Purch_Pro_Total_Bf_Tax');
        $data['Purch_Pro_Total_Tax']=request('Purch_Pro_Total_Tax');
        $data['Purch_Pro_Total']=request('Purch_Pro_Total');
        $data['Purch_Pro_Store']=request('Purch_Pro_Store');
        $data['Purch_Pro_Exp_Date']=request('Purch_Pro_Exp_Date');
        $data['Purch_Product_Numbers']=request('Purch_Product_Numbers');
        $data['Purch_Total_Qty']=request('Purch_Total_Qty');
        $data['Purch_Total_Discount']=request('Purch_Total_Discount');
        $data['Purch_Total_Bf_Taxes']=request('Purch_Total_Bf_Taxes');
        $data['Purch_Total_Taxes']=request('Purch_Total_Taxes');
        $data['Purch_Total_Price']=request('Purch_Total_Price');
        $data['Purch_Paid']=request('Purch_Paid');
        $data['Purch_Residual']=request('Purch_Residual');
        $data['Purch_Taknet']=request('Purch_Taknet');
        $data['Purch_Credit']=request('Purch_Credit');
        $data['Purch_Barcode']=request('Purch_Barcode');
        $data['Purch_Text']=request('Purch_Text');
        $data['Purch_Seal']=request('Purch_Seal');
        $data['Sales_Total_Return']=request('Sales_Total_Return');
        $data['Sales_Resdiual']=request('Sales_Resdiual');
        $data['Sales_Client_Phone']=request('Sales_Client_Phone');
        $data['Sales_Client_Address']=request('Sales_Client_Address');
        $data['Sales_Pro_Total_Net']=request('Sales_Pro_Total_Net');
        $data['Purch_Pro_Total_Net']=request('Purch_Pro_Total_Net');


        CustomPrint::orderBy('id','desc')->update($data);


        session()->flash('success',trans('admin.Updated'));
        return back();

    }


    // ==   Modules Settings  ============================================
    public function Modules_SettingsPage(){
        $Packages=Packages::all();
        $Modules=Modules::orderBy('id','desc')->first();
        $ReportsSettings=ReportsSettings::orderBy('id','desc')->first();
        $ModulesNum=ModuleSettingsNum::orderBy('id','desc')->first();
        $intro=Intro::orderBy('id','desc')->first();
        $Intro=Intro::orderBy('id','desc')->first();
        $permission = Permission::orderBy('Main','asc')->get();

        $Educations=RabihEducation::all();

        return view('admin.Settings.ModulesSettings',get_defined_vars());
    }

    public function AddDefaultModulesFirst(){

        $data['Capital']=0;
        $data['Accounts']=0;
        $data['Stores']=0;
        $data['CRM']=0;
        $data['HR']=0;
        $data['Manufacturing']=0;
        $data['Maintenance']=0;
        $data['Secretariat']=0;
        $data['Petrol']=0;
        $data['Shipping']=0;
        $data['Resturant']=0;
        Modules::create($data);

        return back();

    }

    public function AddDefaultModules(){


        $data['Capital']=request('Capital');
        $data['Accounts']=request('Accounts');
        $data['Stores']=request('Stores');
        $data['CRM']=request('CRM');
        $data['HR']=request('HR');
        $data['Manufacturing']=request('Manufacturing');
        $data['Maintenance']=request('Maintenance');
        $data['Secretariat']=request('Secretariat');
        $data['Petrol']=request('Petrol');
        $data['ECommerce']=request('ECommerce');
        $data['Shipping']=request('Shipping');
        $data['Bill_Electronic']=request('Bill_Electronic');
        $data['Hotels']=request('Hotels');
        $data['Resturant']=request('Resturant');
        $data['Traning_Center']=request('Traning_Center');
        $data['Translate']=request('Translate');
        Modules::orderBy('id','desc')->update($data);


        session()->flash('success',trans('admin.Updated'));
        return back();

    }

    public function AddDefaultModulesNumFirst(){

        $data['Branch_Select']=null;
        $data['Branch_Num']=null;
        $data['Store_Select']=null;
        $data['Store_Num']=null;
        $data['Users_Select']=null;
        $data['Users_Num']=null;
        ModuleSettingsNum::create($data);
        return back();

    }

    public function AddDefaultModulesNum(){

        $data['Branch_Select']=request('Branch_Select');
        $data['Branch_Num']=request('Branch_Num');
        $data['Store_Select']=request('Store_Select');
        $data['Store_Num']=request('Store_Num');
        $data['Users_Select']=request('Users_Select');
        $data['Users_Num']=request('Users_Num');
        $data['System']=request('System');
        $data['Expire_Date']=request('Expire_Date');
        $data['Type']=request('Type');
        $data['Price']=request('Price');

        ModuleSettingsNum::orderBy('id','desc')->update($data);
        return back();

    }


    public function AddDefaultReportSettingsFirst(){

        $data['Product_Info']=null;

        ReportsSettings::create($data);
        return back();

    }


    public function AddDefaultReportSettings(){



        $data['Product_Info']=request('Product_Info');
        $data['Product_Order_Limit']=request('Product_Order_Limit');
        $data['ReportStartPeriodProducts']=request('ReportStartPeriodProducts');
        $data['SettlementsReports']=request('SettlementsReports');
        $data['StoresCost']=request('StoresCost');
        $data['StoresInventory']=request('StoresInventory');
        $data['Collection_Delegates']=request('Collection_Delegates');
        $data['Sales_Delegates']=request('Sales_Delegates');
        $data['StagnantItems']=request('StagnantItems');
        $data['ItemsMoves']=request('ItemsMoves');
        $data['StoresBalancesTwo']=request('StoresBalancesTwo');
        $data['NetPurchases']=request('NetPurchases');
        $data['NetSales']=request('NetSales');
        $data['ClientSales']=request('ClientSales');
        $data['ExecutorSales']=request('ExecutorSales');
        $data['InstallmentReport']=request('InstallmentReport');
        $data['ExpiredProucts']=request('ExpiredProucts');
        $data['StoresSalesDetails']=request('StoresSalesDetails');
        $data['TotalNetPurchases']=request('TotalNetPurchases');
        $data['TotalNetSales']=request('TotalNetSales');
        $data['Profits']=request('Profits');
        $data['Shifts']=request('Shifts');
        $data['Shifts_Details']=request('Shifts_Details');
        $data['DailyClosing']=request('DailyClosing');
        $data['Products']=request('Products');
        $data['DailyShifts']=request('DailyShifts');
        $data['ExpensesReport']=request('ExpensesReport');
        $data['DailyProducts']=request('DailyProducts');
        $data['EmployeeCommissionDiscounts']=request('EmployeeCommissionDiscounts');
        $data['VendorPricesReport']=request('VendorPricesReport');
        $data['DailyMoves']=request('DailyMoves');
        $data['GroupsSales']=request('GroupsSales');
        $data['VendorPurchases']=request('VendorPurchases');
        $data['ExceptProfits']=request('ExceptProfits');
        $data['DelegateSalesDetails']=request('DelegateSalesDetails');
        $data['CreditStores']=request('CreditStores');
        $data['ProductProfits']=request('ProductProfits');
        $data['ExceptProductProfits']=request('ExceptProductProfits');
        $data['SalesBills']=request('SalesBills');
        $data['PurchasesBills']=request('PurchasesBills');
        $data['StoresMovesReport']=request('StoresMovesReport');
        $data['StoresTransferReport']=request('StoresTransferReport');
        $data['SafesTransferReport']=request('SafesTransferReport');
        $data['CompareSalesPrice']=request('CompareSalesPrice');
        $data['ProductMoveDetails']=request('ProductMoveDetails');
        $data['MostSalesProducts']=request('MostSalesProducts');
        $data['ProfitSalesProduct']=request('ProfitSalesProduct');
        $data['ClientAccountStatement']=request('ClientAccountStatement');
        $data['ClientsStatement']=request('ClientsStatement');
        $data['VendorAccountStatement']=request('VendorAccountStatement');
        $data['VendorsStatement']=request('VendorsStatement');
        $data['EmpGoals']=request('EmpGoals');
        $data['InventorySerial']=request('InventorySerial');
        $data['TotalExpensesSafes']=request('TotalExpensesSafes');
        $data['SubIncomList']=request('SubIncomList');
        $data['ExpensesList']=request('ExpensesList');
        $data['StoresBalances']=request('StoresBalances');
        $data['StoresBalancesCat']=request('StoresBalancesCat');
        $data['ItemCost']=request('ItemCost');
        $data['StoresInventoryy']=request('StoresInventoryy');
        $data['DelegateSalesDetailss']=request('DelegateSalesDetailss');
        $data['ProfitDelegateSalesDetails']=request('ProfitDelegateSalesDetails');
        $data['InstallmentCompaniesSales']=request('InstallmentCompaniesSales');
        $data['StoresCosts']=request('StoresCosts');
        $data['DailyClosingDetails']=request('DailyClosingDetails');
        $data['SalesProsMoreDetails']=request('SalesProsMoreDetails');
        $data['StagnantItemss']=request('StagnantItemss');
        $data['SalesCustomersGroups']=request('SalesCustomersGroups');
        $data['BrandsSales']=request('BrandsSales');
        $data['Customer_Debts']=request('Customer_Debts');
        $data['Vendor_Debts']=request('Vendor_Debts');
        $data['MaintanceSalesReport']=request('MaintanceSalesReport');
        $data['Maintenance_Tune']=request('Maintenance_Tune');
        $data['ProfitGroupsReport']=request('ProfitGroupsReport');
        $data['IncomListReport']=request('IncomListReport');
        $data['AssemblyProQties']=request('AssemblyProQties');
        ReportsSettings::orderBy('id','desc')->update($data);

        return back();

    }


    public function AddDefaultPackagesSettings(){


        $ID = DB::table('packages')->insertGetId(
            array(


                'Arabic_Name' => request('Arabic_Name'),
                'English_Name' => request('English_Name'),



            )
        );



        $permission=request('permission');

        for($i=0 ; $i < count($permission) ; $i++){
            $de['package']=$ID;
            $de['premission']=$permission[$i];

            PackPrem::create($de);
        }





        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

    }

    public function AddDefaultIntroFirst(){

        $data['Arabic_About']=null;
        $data['English_About']=null;
        $data['Phone_1']=null;
        $data['Phone_2']=null;
        $data['Phone_3']=null;
        $data['Phone_4']=null;
        $data['Arabic_Terms']=null;
        $data['English_Terms']=null;
        $data['Arabic_Privacy']=null;
        $data['English_Privacy']=null;
        Intro::create($data);
        return back();

    }

    public function AddDefaultIntro(){

        $data['Arabic_About']=request('Arabic_About');
        $data['English_About']=request('English_About');
        $data['Phone_1']=request('Phone_1');
        $data['Phone_2']=request('Phone_2');
        $data['Phone_3']=request('Phone_3');
        $data['Phone_4']=request('Phone_4');
        $data['Arabic_Terms']=request('Arabic_Terms');
        $data['English_Terms']=request('English_Terms');
        $data['Arabic_Privacy']=request('Arabic_Privacy');
        $data['English_Privacy']=request('English_Privacy');


        Intro::orderBy('id','desc')->update($data);
        return back();

    }

    public function DeletePackage($id){

        $del=Packages::find($id);
        $del->delete();
        session()->flash('error',trans('admin.Deleted'));
        return back();

    }


    //Transltor  =======================================================
    public function TranslatePage(){
        $items=Transltor::paginate(500);
        return view('admin.Settings.Translate',['items'=>$items]);
    }

    public function AddTranslate(){


        $data= $this->validate(request(),[
            'Original_Name'=>'required',
            'New_Arabic_Name'=>'required',


        ],[


        ]);

        if(!empty(request('New_English_Name'))){
            $data['New_English_Name']=request('New_English_Name');
        }else{
            $data['New_English_Name']=request('New_Arabic_Name');

        }

        $data['Original_Name']=request('Original_Name');
        $data['New_Arabic_Name']=request('New_Arabic_Name');
        Transltor::create($data);

        session()->flash('success',trans('admin.NewAddAdmin'));
        return back();

    }

    public function EditTranslate($id){

        $data= $this->validate(request(),[
            'Original_Name'=>'required',
            'New_Arabic_Name'=>'required',


        ],[


        ]);

        $data['New_English_Name']=request('New_English_Name');
        $data['Original_Name']=request('Original_Name');
        $data['New_Arabic_Name']=request('New_Arabic_Name');
        Transltor::where('id',$id)->update($data);

        session()->flash('success',trans('admin.Updated'));
        return back();


    }

    public function DeleteTranslate($id){

        $del=Transltor::find($id);
        $del->delete();
        session()->flash('error',trans('admin.Deleted'));
        return back();

    }


    //LoginSlider  =======================================================
    public function LoginSlider(){
        $items=LoginSlider::all();
        return view('admin.Settings.LoginSlider',['items'=>$items]);
    }

    public function AddLoginSlider(){

        $data= $this->validate(request(),[
            'Image'=>'required|max:100000',
        ],[

            'Image.required' => trans('admin.ImageRequired'),

        ]);

        $image=request()->file('Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='WebsliderImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }

        $data['Image']=$image_url;
        LoginSlider::create($data);

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

    }

    public function EditLoginSlider($id){

        $data= $this->validate(request(),[

            'Image'=>'sometimes|nullable|max:100000',
        ],[

            'Image.required' => trans('admin.ImageRequired'),

        ]);
        $image=request()->file('Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='WebsliderImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }

        if(!empty($image_url)){
            $data['Image']=$image_url;
        }else{

            $data['Image']=request('Images');
        }

        LoginSlider::where('id',$id)->update($data);


        session()->flash('success',trans('admin.Updated'));
        return back();


    }

    public function DeleteLoginSlider($id){

        $del=LoginSlider::find($id);
        $del->delete();
        session()->flash('error',trans('admin.Deleted'));
        return back();

    }


    //Domain Regstration  =======================================================
    public function Domain_Regstration(){
        $items=Tenant::paginate(10);

        return view('admin.Settings.Tenants',['items'=>$items]);
    }

    public function AddDomain_Regstration(){

        $data= $this->validate(request(),[
            'name'=>'required',
            'domain'=>'required|unique:domains',
        ],[
            'domain.required' => trans('admin.domainRequired'),
            'domain.unique' =>trans('admin.domainUnique'),
        ]);

        //    'tenancy_db_username' => 'foo',
        //    'tenancy_db_password' => 'bar',
        $tenant3 =Tenant::create(['id' => request('name'),'tenancy_db_name' => request('name')]);

        $tenant3->domains()->create(['domain' => request('domain')]);
        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

    }

    public function DeleteDomain_Regstration($id){

        $del=Tenant::find($id);
        $del->delete();
        session()->flash('error',trans('admin.Deleted'));
        return back();

    }

    //Updates
    public function Updates(){

        return view('admin.Settings.Updates');

    }

    public function NewUpdateMigration(){

        Artisan::call('migrate', []);
        // Specific Tenant  '--tenants' => [$tenant->id]
        Artisan::call('tenants:migrate', [
            '--path' => [database_path('migrations/update')],
        ]);
        session()->flash('success',trans('admin.Updated'));
        return back();
    }

    public function NewUpdateSeeders(){
        Artisan::call('db:seed', [

        ]);
        // Specific Tenant  '--tenants' => [$tenant->id]
        Artisan::call('tenants:seed', [

            '--class' => 'DatabaseSeeder'
        ]);

        session()->flash('success',trans('admin.Updated'));
        return back();
    }


    //StoresQtyPage  =======================================================
    public function StoresQtyPage(){
        $Stores=Stores::all();

        return view('admin.Settings.StoresQty',['Stores'=>$Stores]);
    }


    function StoresQtyFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $store = $request->get('Store');

            if($search != '' and $store != '')
            {


                $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
                if($DefSHOW->Search_Typical ==  1){

                    $Prods=ProductsQty::
                    where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code',$search)
                        ->orWhere('PP_Code',$search)
                        ->orWhere('PPP_Code',$search)
                        ->orWhere('PPPP_Code',$search)
                        ->where('Store',$store)
                        ->get();


                }else{

                    $Prods=ProductsQty::
                    where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                        ->where('Store',$store)
                        ->get();


                }


            }elseif($search == '' and $store != ''){


                $Prods=ProductsQty::
                where('Store',$store)
                    ->get();


            }


            $total_row = $Prods->count();
            if($total_row > 0)
            {
                foreach($Prods as $rows){

                    if($rows->Store == $store){
                        $output .= '

       <tr>

       <td>
'.$rows->P_Code.'

       </td>

        <td>
        '.$rows->P_Ar_Name.' ('.$rows->V_Name.')  ('.$rows->VV_Name.')
        </td>


         <td>
            <form action="'.url('ChangeStroeQty').'" method="get">
        <div class="row">
     <div class="col-md-5">
     <label>Qty</label>
      <input type="text" name="Qty"  class="form-control Qun" value="'.$rows->Qty.'" >
      <input type="hidden" name="ID"   value="'.$rows->id.'" >
     </div>
         <div class="col-md-5">
             <label>Code</label>
    <input type="text" name="P_Code"  class="form-control Qun" value="'.$rows->P_Code.'" >
     </div>

         <div class="col-md-2">
           <button type="submit" class="btn btn-primary"><i class="fal fa-edit"></i></buuton>
           </div>
        </div>
     </form>

      <div class="row">
      <div class="col-md-12">
      <a class="btn btn-danger" href="DeleteStoreQty/'.$rows->Pro_Stores.'"><i class="fal fa-trash"></i></a>
      </div>
      </div>

       </td>




        </tr>

            ';

                    }
                }

            }else
            {
                $output = '
        <div class="col-md-3">لا يوجد صنف كهذا</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    public function ChangeStroeQty(){

        ProductsQty::where('id',request('ID'))->update(['Qty'=>request('Qty'),'P_Code'=>request('P_Code')]);
        session()->flash('success',trans('admin.Updated'));
        return back();
    }

    public function DeleteStoreQty($id){

        $del=ProductsStores::find($id);
        $del->delete();
        session()->flash('error',trans('admin.Deleted'));
        return back();

    }






}
