<?php

namespace App\Http\Controllers;

use App\Events\SalesEvent;
use App\Events\SalesOrderEvent;
use App\Http\Requests\ArRequest;
use App\Http\Requests\SalesRequest;
use App\Services\Average;
use App\Services\SalesService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\OutcomManufacturingModel;
use App\Models\UsersMoves;
use App\Models\Countris;
use App\Models\AcccountingManual;
use App\Models\Admin;
use App\Models\Governrate;
use App\Models\City;
use App\Models\Places;
use App\Models\Taxes;
use App\Models\Activites;
use App\Models\ClientStatus;
use App\Models\Platforms;
use App\Models\Campaigns;
use App\Models\Customers;
use App\Models\Vendors;
use App\Models\CustomersFiles;
use App\Models\Employess;
use App\Models\CustomersTickets;
use App\Models\Quote;
use App\Models\CostCenter;
use App\Models\Coins;
use App\Models\Stores;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\Measuerments;
use App\Models\ProductsQuote;
use App\Models\SalesOrder;
use App\Models\Sales;
use App\Models\ProductSalesOrder;
use App\Models\ProductSales;
use App\Models\StoreCountSales;
use App\Models\Installment;
use App\Models\InstallmentDates;
use App\Models\ProductMoves;
use App\Models\Journalizing;
use App\Models\JournalizingDetails;
use App\Models\GeneralDaily;
use App\Models\RecivedSales;
use App\Models\RecivedSalesProducts;
use App\Models\ReturnSales;
use App\Models\ReturnSalesProducts;
use App\Models\Products;
use App\Models\AssemblyProducts;
use App\Models\ChecksTypes;
use App\Models\IncomChecks;
use App\Models\ProductsPurchases;
use App\Models\SalesDefaultData;
use App\Models\MaintainceDefaultData;
use App\Models\ProductsStartPeriods;
use App\Models\CustomersGroup;
use App\Models\ProductsStoresTransfers;
use App\Models\Brands;
use App\Models\ItemsGroups;
use App\Models\Shifts;
use App\Models\QuoteImage;
use App\Models\ProductQuoteImage;
use App\Models\PurchasesDefaultData;
use App\Models\EmpPOSStores;
use App\Models\PaymentVoucher;
use App\Models\PaymentVoucherDetails;
use App\Models\ReciptVoucher;
use App\Models\ReciptVoucherDetails;
use App\Models\DefaultDataShowHide;
use App\Models\CrmDefaultData;
use App\Models\SalesSubscribes;
use App\Models\ProductSalesSubscribes;
use App\Models\Addressses;
use App\Models\InstallmentCompanies;
use App\Models\InstallmentCompaniesRatios;
use App\Models\StoresMoves;
use App\Models\Purchases;
use App\Models\SafesBanks;
use App\Models\PermissionToExchangeGoods;
use App\Models\ProductsPermissionToExchangeGoods;
use App\Models\StoreCount;
use App\Models\CompanyData;
use App\Models\CommentsClients;
use App\Models\ResturantTables;
use App\Models\AdditionalProducts;
use App\Models\ProNote;
use App\Models\VAPrice;
use App\Models\VAQty;
use App\Models\AVProCheckQty;
use App\Models\RemoveProductsHall;
use App\Models\MoreProductsHall;
use App\Models\ResturantSliders;
use App\Models\ResturantBlogs;
use App\Models\ResturantSocial;
use App\Models\ResturantPrivacy;
use App\Models\ResturantTerms;
use App\Models\ResturantCuponCode;
use App\Models\ResturantGallery;
use App\Models\ResturantReviews;
use App\Models\ResturantReservations;
use App\Models\ResturantStyle;
use App\Models\ResturantHome;
use App\Models\ResturantAbout;
use App\Models\ResturantVideoSection;
use App\Models\ResturantIndexStyleI;
use App\Models\ResturantIndexStyleII;
use App\Models\ResturantNavFootStyle;
use App\Models\ResturantSupPageStyle;
use App\Models\ResturantCartCheckStyle;
use App\Models\ResturantMenuStyle;
use App\Models\Event;
use App\Models\Notifications;
use App\Models\EmpRatio;
use App\Models\StoresDefaultData;
use App\Models\AccountsDefaultData;
use App\Models\FifoQty;
use Session;
use DB;
use Str;
use URL;
use Hash;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Cart;
use App\Traits\GeneralTrait;
class ResturantController extends Controller
{
    use GeneralTrait ;
    function __construct()
{

$this->middleware('permission:الطاولات', ['only' => ['InstallmentCompanies']]);
$this->middleware('permission:شاشة المطبخ', ['only' => ['KitchenScreen']]);
$this->middleware('permission:شاشة التسليمات', ['only' => ['RecivedScreen']]);
$this->middleware('permission:مبيعات المطعم', ['only' => ['ResturantSales']]);
$this->middleware('permission:سلايدر المطاعم', ['only' => ['RWebSlider']]);
$this->middleware('permission:هوم ٢ المطاعم', ['only' => ['ResturantHome']]);
$this->middleware('permission:من نحن المطاعم', ['only' => ['RAbout']]);
$this->middleware('permission:قسم الفيديو المطاعم', ['only' => ['VideoSection']]);
$this->middleware('permission:تواصل اجتماعي المطاعم', ['only' => ['RSocialMedia']]);
$this->middleware('permission:المقالات المطاعم', ['only' => ['RArticles']]);
$this->middleware('permission:سياسه الخصوصيه المطاعم', ['only' => ['RPolices']]);
$this->middleware('permission:شروط و احكام المطاعم', ['only' => ['RTerms']]);
$this->middleware('permission:كود خصم المطاعم', ['only' => ['RCouponCode']]);
$this->middleware('permission:الاستوديو المطاعم', ['only' => ['RGallery']]);
$this->middleware('permission:مراجعات المطاعم', ['only' => ['RReviews']]);
$this->middleware('permission:حجوزات المطاعم', ['only' => ['RReservations']]);



}



    //ResturantTables
    public function Tables(){
        $items=ResturantTables::get();
        return view('admin.Resturant.Tables',['items'=>$items]);
    }

    public function AddTables(ArRequest $request){
        try {
            DB::beginTransaction();

            $validated = $request->validated();

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }


            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
        $data['Place_Ar']=request('Place_Ar');
        if(!empty(request('Place_En'))){
            $data['Place_En']=request('Place_En');
        }else{
            $data['Place_En']=request('Place_Ar');

        }
        $data['Table_Number']=request('Table_Number');
        $data['Chairs_Num']=request('Chairs_Num');

        ResturantTables::create($data);


        $table=ResturantTables::orderBy('id','desc')->first();
        $dataa['QR']=URL::to('/ScanQR?Table='.$table->id);
        ResturantTables::where('id',$table->id)->update($dataa);


            $dataUser=[
                'screen_ar'=>'الطاولات',
                'screen_en'=>'Tables',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();


            session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=ResturantTables::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ResturantTables::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditTables($id,ArEnRequest $request){
        try {
            DB::beginTransaction();

            $validated = $request->validated();
        $data['Arabic_Name']=request('Arabic_Name');
        $data['English_Name']=request('English_Name');
        $data['Place_Ar']=request('Place_Ar');
        $data['Place_En']=request('Place_En');
        $data['Table_Number']=request('Table_Number');
        $data['Chairs_Num']=request('Chairs_Num');
        $data['QR']=URL::to('/ScanQR?Table='.$id);

        ResturantTables::where('id',$id)->update($data);


            $dataUser=[
                'screen_ar'=>'الطاولات',
                'screen_en'=>'Tables',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=ResturantTables::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ResturantTables::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteTables($id){
        try {
            DB::beginTransaction();
        $del=ResturantTables::find($id);

$salesTable=Sales::where('Table',$del->id)->get();
$salesOrderTable=SalesOrder::where('Table',$del->id)->get();

if(!empty($salesTable)){
    DB::rollBack();
    session()->flash('error',trans('admin.CantDeleteAnyItemHasTraffic'));
    return back();
}

if(!empty($salesOrderTable)){
    DB::rollBack();
    session()->flash('error',trans('admin.CantDeleteAnyItemHasTraffic'));
    return back();
}

            $dataUser=[
                'screen_ar'=>'الطاولات',
                'screen_en'=>'Tables',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserUpdateMoves($dataUser);
            $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();

    }catch(\Exception $ex){

$MODEL=ResturantTables::class;
DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
return back();

}catch(\Error $ex){


    $MODEL=ResturantTables::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}

    }

    public function ScanQR(){

        $x=request('Table');
        session()->put('TABLE_ID',$x);
        return redirect('/');

    }



    // Tables Ajax =========================
    public function AllTables() {

        $states=[];
        $Tables=ResturantTables::get();
        if(app()->getLocale() == 'ar' ){

            foreach($Tables as $table){

                $xx=SalesOrder::
                where('Table',$table->id)
                    ->where('ResturantOrderType','Hall')
                    ->where('RecivedOrder',0)
                    ->orderBy('id','desc')->first();

                if(empty($xx)){


                    $states +=[$table->id => $table->Arabic_Name];


                }

            }


        }else{

            foreach($Tables as $table){

                $xx=SalesOrder::
                where('Table',$table->id)
                    ->where('ResturantOrderType','Hall')
                    ->where('RecivedOrder',0)
                    ->orderBy('id','desc')->first();

                if(empty($xx)){


                    $states +=[$table->id => $table->English_Name];


                }

            }


        }
        return response()->json($states);

    }

    public function AllTablesJ($id) {


        $states=[];
        $Tables=ResturantTables::
        where('Arabic_Name','ILIKE', "%{$id}%")
            ->orWhere('English_Name','ILIKE', "%{$id}%")
            ->get();

        if(app()->getLocale() == 'ar' ){
            foreach($Tables as $table){

                $xx=SalesOrder::
                where('Table',$table->id)
                    ->where('ResturantOrderType','Hall')
                    ->where('RecivedOrder',0)
                    ->orderBy('id','desc')->first();

                if(empty($xx)){


                    $states +=[$table->id => $table->Arabic_Name];


                }

            }

        }else{

            foreach($Tables as $table){

                $xx=SalesOrder::
                where('Table',$table->id)
                    ->where('ResturantOrderType','Hall')
                    ->where('RecivedOrder',0)
                    ->orderBy('id','desc')->first();

                if(empty($xx)){


                    $states +=[$table->id => $table->English_Name];


                }

            }

        }

        return response()->json($states);

    }

    public function AddNewTableAjax(){


        if(!empty(request('TableName'))){
            $data['Arabic_Name']=request('TableName');
            $data['English_Name']=request('TableName');
            $data['Place_Ar']=request('TablePlace');
            $data['Place_En']=request('TablePlace');
            $data['Table_Number']=request('TableNumber');
            $data['Chairs_Num']=request('ChairsNum');
            ResturantTables::create($data);

            $table=ResturantTables::orderBy('id','desc')->first();
            $dataa['QR']=URL::to('/ScanQR?Table='.$table->id);
            ResturantTables::where('id',$table->id)->update($dataa);


            $dataUser=[
                'screen_ar'=>'الطاولات',
                'screen_en'=>'Tables',
                'explain_ar'=>request('TableName'),
                'explain_en'=>request('TableName'),
            ];
            $this->UserCreateMoves($dataUser);

            $states=['SUCEESS'=>'SUCEESS'];

        }
        return response()->json($states);

    }


    function AllReservedTables(Request $request)
    {

        if($request->ajax())
        {
            $output = '';

            $Tables=ResturantTables::get();

            $total_row = $Tables->count();
            if($total_row > 0)
            {

                foreach($Tables as $table){

                    $xx=SalesOrder::
                    where('Table',$table->id)
                        ->where('ResturantOrderType','Hall')
                        ->where('RecivedOrder',0)
                        ->orderBy('id','desc')->first();
                    if(!empty($xx)){

                        if(app()->getLocale() == 'ar' ){
                            $Nemo=$table->Arabic_Name;
                        }else{
                            $Nemo=$table->English_Name;

                        }



                        $output .= '



      <form class="col-md-4" action="'.url('HoldSaleHall').'" id="ORDERHOLD" method="get">
                <input type="hidden" name="OrderID" value="'.$xx->id.'">
                          <button type="submit" style="background: unset; border: unset; width: 100%" >

                          <table class="table table-bordered" style="background: #c59cc5;">
                             <tr>
                                  <td> '.trans('admin.Table').'</td>
                                  <td> '.$Nemo.' ('.$table->Table_Number.' )</td>

                              </tr>
                              <tr>
                                  <td> '.trans('admin.Bill_Num').'</td>
                                  <td> '.$xx->Code.'</td>

                              </tr>
                              <tr>
                                  <td>'.trans('admin.Date').'</td>
                                  <td>'.$xx->Date.'</td>

                              </tr>
                              <tr>
                                  <td>'.trans('admin.Total_Price').'</td>
                                  <td>'.$xx->Total_Price.'</td>

                              </tr>
                          </table>
                 </button>
</form>


            ';
                    }
                }

            }else
            {
                $output = '
        <div class="col-md-12"> '.trans('admin.No_Data_Find').' </div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    function MergeDataTables(Request $request)
    {

        if($request->ajax())
        {
            $output = '';

            $Tables=ResturantTables::get();

            $total_row = $Tables->count();
            if($total_row > 0)
            {


                $output .= '

               <form action="'.url('PostMerge').'" id="ORDERHOLD" method="get">
               <div class="row">
               ';

                foreach($Tables as $table){

                    $xx=SalesOrder::
                    where('Table',$table->id)
                        ->where('ResturantOrderType','Hall')
                        ->where('RecivedOrder',0)
                        ->orderBy('id','desc')->first();
                    if(!empty($xx)){

                        if(app()->getLocale() == 'ar' ){
                            $Nemo=$table->Arabic_Name;
                            $PlaceNemo=$table->Place_Ar;
                        }else{
                            $Nemo=$table->English_Name;
                            $PlaceNemo=$table->Place_En;

                        }



                        $output .= '


                    <div class="col-md-4">
                          <input type="checkbox" name="MergeTable[]" value="'.$xx->id.'" >


                          <table class="table table-bordered" style="background: #c59cc5;">
                             <tr>
                                  <td> '.trans('admin.Table').'</td>
                                  <td> '.$Nemo.'</td>

                              </tr>
                              <tr>
                                  <td> '.trans('admin.Table_Number').'</td>
                                  <td> '.$table->Table_Number.'</td>

                              </tr>
                              <tr>
                                  <td>'.trans('admin.Place').'</td>
                                  <td>'.$PlaceNemo.'</td>

                              </tr>
                              <tr>
                                  <td>'.trans('admin.Bill_Num').'</td>
                                  <td>'.$xx->Code.'</td>

                              </tr>
                          </table>

                        </div>

            ';
                    }
                }


                $output .= '


                   <div class="col-md-12 mb-2">
                   <label> '.trans('admin.MainTable').' </label>
                   <select class=="select2 form-control" name="MainTable" style="width: 100%;padding: 12px;text-align: center;">

            ';

                foreach($Tables as $table){

                    $xx=SalesOrder::
                    where('Table',$table->id)
                        ->where('ResturantOrderType','Hall')
                        ->where('RecivedOrder',0)
                        ->orderBy('id','desc')->first();
                    if(!empty($xx)){

                        if(app()->getLocale() == 'ar' ){
                            $Nemo=$table->Arabic_Name;

                        }else{
                            $Nemo=$table->English_Name;


                        }

                        $output .= '
        <option value="'.$table->id.'">   '.$Nemo.' </option>
                ';

                    }

                }
                $output .= '
                   </select>
                   </div>


                <div class="col-md-12">
           <button style="width="100%" type="submit" class="btn btn-primary"><i class="fal fa-plus"></i></button>
           </div>
           </div>
               </form>
               ';

            }else
            {
                $output = '
        <div class="col-md-12"> '.trans('admin.No_Data_Find').' </div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    function SeparatingDataTables(Request $request)
    {

        if($request->ajax())
        {
            $output = '';

            $Tables=ResturantTables::get();

            $total_row = $Tables->count();
            if($total_row > 0)
            {


                $output .= '

               <form action="'.url('PostSeparating').'" id="ORDERHOLD" method="get">
               <div class="row">
               ';

                foreach($Tables as $table){

                    $xx=SalesOrder::
                    where('Table',$table->id)
                        ->where('ResturantOrderType','Hall')
                        ->where('RecivedOrder',0)
                        ->orderBy('id','desc')->first();
                    if(!empty($xx)){

                        if(app()->getLocale() == 'ar' ){
                            $Nemo=$table->Arabic_Name;
                        }else{
                            $Nemo=$table->English_Name;
                        }

                        $Prodcts=ProductSalesOrder::where('SalesOrder',$xx->id)->get();

                        $output .= '


                    <div class="col-md-12">
                          <input type="radio" name="MergeTable" value="'.$xx->id.'" >
                  <h3>'.$Nemo.' ('.$table->Table_Number.')</h3>

                          <table class="table table-bordered" style="background: #c59cc5;">
                            <thead>
                             <tr>
                                <th>'.trans('admin.Actions').'</th>
                                <th>'.trans('admin.Product_Code').'</th>
                                <th>'.trans('admin.Name').'</th>
                                <th>'.trans('admin.Qty').'</th>
                                <th>'.trans('admin.Price').'</th>
                                <th>'.trans('admin.Total').'</th>
                            </tr>
                            </thead>
                               <tbody>
                        ';
                        foreach($Prodcts as $pro){
                            if(app()->getLocale() == 'ar' ){
                                $PrNemo=$pro->P_Ar_Name;
                            }else{
                                $PrNemo=$pro->P_En_Name;

                            }
                            $output .= '
                   <tr>
                   <td>   <input type="checkbox" name="ProID[]" value="'.$pro->id.'" ></td>
                   <td>   '.$pro->Product_Code.'</td>
                   <td>   '.$PrNemo.' '.$pro->V_Name.' '.$pro->VV_Name.'</td>
                        <td>   '.$pro->Qty.'</td>
                        <td>   '.$pro->Price.'</td>
                        <td>   '.$pro->Total.'</td>
                   </tr>
                   ';

                        }
                        $output .= '

                             </tbody>
                          </table>

                        </div>

            ';
                    }
                }


                $output .= '


                   <div class="col-md-12 mb-2">
                   <label> '.trans('admin.NewTable').' </label>
                   <select class=="select2 form-control" name="MainTable" style="width: 100%;padding: 12px;text-align: center;">

            ';

                foreach($Tables as $table){

                    $xx=SalesOrder::
                    where('Table',$table->id)
                        ->where('ResturantOrderType','Hall')
                        ->where('RecivedOrder',0)
                        ->orderBy('id','desc')->first();
                    if(empty($xx)){

                        if(app()->getLocale() == 'ar' ){
                            $Nemo=$table->Arabic_Name;

                        }else{
                            $Nemo=$table->English_Name;


                        }

                        $output .= '
        <option value="'.$table->id.'">   '.$Nemo.' </option>
                ';

                    }

                }
                $output .= '
                   </select>
                   </div>


                <div class="col-md-12">
           <button style="width="100%" type="submit" class="btn btn-primary"><i class="fal fa-plus"></i></button>
           </div>
           </div>
               </form>
               ';

            }else
            {
                $output = '
        <div class="col-md-12"> '.trans('admin.No_Data_Find').' </div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    function MovingDataTables(Request $request)
    {

        if($request->ajax())
        {
            $output = '';

            $Tables=ResturantTables::get();





            $total_row = $Tables->count();
            if($total_row > 0)
            {


                $output .= '

               <form action="'.url('PostMoving').'" id="ORDERHOLD" method="get">
               <div class="row">
               ';

                foreach($Tables as $table){

                    $xx=SalesOrder::
                    where('Table',$table->id)
                        ->where('ResturantOrderType','Hall')
                        ->where('RecivedOrder',0)
                        ->orderBy('id','desc')->first();
                    if(!empty($xx)){

                        if(app()->getLocale() == 'ar' ){
                            $Nemo=$table->Arabic_Name;
                            $PlaceNemo=$table->Place_Ar;
                        }else{
                            $Nemo=$table->English_Name;
                            $PlaceNemo=$table->Place_En;

                        }



                        $output .= '


                    <div class="col-md-4">
                          <input type="radio" name="MergeTable" value="'.$table->id.'" >


                          <table class="table table-bordered" style="background: #c59cc5;">
                             <tr>
                                  <td> '.trans('admin.Table').'</td>
                                  <td> '.$Nemo.'</td>

                              </tr>
                              <tr>
                                  <td> '.trans('admin.Table_Number').'</td>
                                  <td> '.$table->Table_Number.'</td>

                              </tr>
                              <tr>
                                  <td>'.trans('admin.Place').'</td>
                                  <td>'.$PlaceNemo.'</td>

                              </tr>
                              <tr>
                                  <td>'.trans('admin.Bill_Num').'</td>
                                  <td>'.$xx->Code.'</td>

                              </tr>
                          </table>

                        </div>

            ';
                    }
                }


                $output .= '


                   <div class="col-md-12 mb-2">
                   <label> '.trans('admin.MoveToTable').' </label>
                   <select class=="select2 form-control" name="MainTable" style="width: 100%;padding: 12px;text-align: center;">

            ';

                foreach($Tables as $table){

                    $xx=SalesOrder::
                    where('Table',$table->id)
                        ->where('ResturantOrderType','Hall')
                        ->where('RecivedOrder',0)
                        ->orderBy('id','desc')->first();
                    if(empty($xx)){

                        if(app()->getLocale() == 'ar' ){
                            $Nemo=$table->Arabic_Name;

                        }else{
                            $Nemo=$table->English_Name;


                        }

                        $output .= '
        <option value="'.$table->id.'">   '.$Nemo.' </option>
                ';

                    }

                }
                $output .= '
                   </select>
                   </div>


                <div class="col-md-12">
           <button style="width="100%" type="submit" class="btn btn-primary"><i class="fal fa-plus"></i></button>
           </div>
           </div>
               </form>
               ';

            }else
            {
                $output = '
        <div class="col-md-12"> '.trans('admin.No_Data_Find').' </div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    public function PostMerge(){

        try {
            DB::beginTransaction();

            $Orders=request('MergeTable');

        $xx=SalesOrder::
        where('Table',request('MainTable'))
            ->where('ResturantOrderType','Hall')
            ->where('RecivedOrder',0)
            ->orderBy('id','desc')->first();

        for($i=0 ; $i  < count($Orders) ; $i++ ){

            $SalesOrder=SalesOrder::find($Orders[$i]);

            if($SalesOrder->Table != request('MainTable')){

                $Prodcts=ProductSalesOrder::where('SalesOrder',$SalesOrder->id)->get();

                foreach($Prodcts  as $pro){
                    $uu['Product_Code']=$pro->Product_Code;
                    $uu['P_Ar_Name']=$pro->P_Ar_Name;
                    $uu['P_En_Name']=$pro->P_En_Name;
                    $uu['V_Name']=$pro->V_Name;
                    $uu['VV_Name']=$pro->VV_Name;
                    $uu['Original_Qty']=$pro->Original_Qty;
                    $uu['Qty']=$pro->Qty;
                    $uu['AvQty']=$pro->AvQty;
                    $uu['Price']=$pro->Price;
                    $uu['Discount']=$pro->Discount;
                    $uu['Tax']=$pro->Tax;
                    $uu['Total_Bf_Tax']=$pro->Total_Bf_Tax;
                    $uu['Total_Tax']=$pro->Total_Tax;
                    $uu['Total']=$pro->Total;
                    $uu['Store']=$pro->Store;
                    $uu['Product']=$pro->Product;
                    $uu['Unit']=$pro->Unit;
                    $uu['Exp_Date']=$pro->Exp_Date;
                    $uu['SalesOrder']=$xx->id;
                    $uu['V1']=$pro->V1;
                    $uu['V2']=$pro->V2;
                    $uu['SubVID']=$pro->SubVID;
                    $uu['TDiscount']=$pro->TDiscount;
                    $uu['Pro_Note']=$pro->Pro_Note;
                    ProductSalesOrder::create($uu);
                }



                $xxx=SalesOrder::
                where('Table',request('MainTable'))
                    ->where('ResturantOrderType','Hall')
                    ->where('RecivedOrder',0)
                    ->orderBy('id','desc')->first();
                $OldOne=SalesOrder::find($Orders[$i]);

                $Product_Numbers=$xxx->Product_Numbers + $OldOne->Product_Numbers;
                $Total_Qty=$xxx->Total_Qty + $OldOne->Total_Qty;
                $Total_Discount=$xxx->Total_Discount + $OldOne->Total_Discount;
                $Total_BF_Taxes=$xxx->Total_BF_Taxes + $OldOne->Total_BF_Taxes;
                $Total_Taxes=$xxx->Total_Taxes + $OldOne->Total_Taxes;
                $Total_Price=$xxx->Total_Price + $OldOne->Total_Price;
                $Pay=$xxx->Pay + $OldOne->Pay;

                SalesOrder::where('id',$xxx->id)->update([
                    'Product_Numbers'=>$Product_Numbers,
                    'Total_Qty'=>$Total_Qty,
                    'Total_Discount'=>$Total_Discount,
                    'Total_BF_Taxes'=>$Total_BF_Taxes,
                    'Total_Taxes'=>$Total_Taxes,
                    'Total_Price'=>$Total_Price,
                    'Pay'=>$Pay,

                ]);

                SalesOrder::where('id',$Orders[$i])->delete();

            }



        }
            DB::commit();
        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=ResturantTables::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ResturantTables::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function PostMoving(){
        try {
            DB::beginTransaction();
        $xx=SalesOrder::
        where('Table',request('MergeTable'))
            ->where('ResturantOrderType','Hall')
            ->where('RecivedOrder',0)
            ->orderBy('id','desc')->first();


        SalesOrder::where('id',$xx->id)->update(['Table'=>request('MainTable')]);
            DB::commit();
        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=ResturantTables::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ResturantTables::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function PostSeparating(){
        try {
            DB::beginTransaction();
        $xx=SalesOrder::find(request('MergeTable'));

        $ProID=request('ProID');


        $ID = DB::table('sales_orders')->insertGetId(
            array(


                'Date' => $xx->Date,
                'Draw' =>$xx->Draw,
                'Payment_Method' =>$xx->Payment_Method,
                'Status' => $xx->Status,
                'Refernce_Number' => $xx->Refernce_Number,
                'Note' => $xx->Note,
                'Product_Numbers' =>0,
                'Total_Qty' => 0,
                'Total_Discount' => 0,
                'Total_BF_Taxes' =>0,
                'Total_Taxes' => 0,
                'Total_Price' => 0,
                'Pay' => 0,
                'Safe' => $xx->Safe,
                'ToSales' => 0,
                'Client' => $xx->Client,
                'Delegate' => $xx->Delegate,
                'Executor' => $xx->Executor,
                'Store' =>  $xx->Store,
                'Coin' =>  $xx->Coin,
                'Cost_Center' => null,
                'presenter' =>$xx->presenter,
                'annual_interest' => $xx->annual_interest,
                'monthly_installment' => $xx->monthly_installment,
                'Years_Number' =>$xx->Years_Number,
                'total' => $xx->total,
                'Order_Type' => 'Resturant',

                'TakeawayStatus' => 0,
                'TakeawayTime' => null,
                'Witer' => $xx->Witer,
                'KitchenEnd' => $xx->KitchenEnd,
                'KitchenEndTime' => $xx->KitchenEndTime,
                'RecivedOrder' => 0,
                'RecivedOrderTime' => null,
                'Delivery_Status' =>0,
                'DeliveryTime' => null,
                'ResturantOrderType' => $xx->ResturantOrderType,
                'Table' => request('MainTable'),

                'Quote' => null,
                'Hold' => 1,
                'installment_Num' => $xx->installment_Num,
                'Date_First_installment' => $xx->Date_First_installment,
                'User' => auth()->guard('admin')->user()->id,

            )
        );


        $res=SalesOrder::where('id',$ID)->first();

        $Code=$res->Code;



        for($i=0 ; $i < count($ProID) ; $i++){
            $Prodct=ProductSalesOrder::find($ProID[$i]);

            $uu['Product_Code']=$Prodct->Product_Code;
            $uu['P_Ar_Name']=$Prodct->P_Ar_Name;
            $uu['P_En_Name']=$Prodct->P_En_Name;
            $uu['V_Name']=$Prodct->V_Name;
            $uu['VV_Name']=$Prodct->VV_Name;
            $uu['Original_Qty']=$Prodct->Original_Qty;
            $uu['Qty']=$Prodct->Qty;
            $uu['AvQty']=$Prodct->AvQty;
            $uu['Price']=$Prodct->Price;
            $uu['Discount']=$Prodct->Discount;
            $uu['Tax']=$Prodct->Tax;
            $uu['Total_Bf_Tax']=$Prodct->Total_Bf_Tax;
            $uu['Total_Tax']=$Prodct->Total_Tax;
            $uu['Total']=$Prodct->Total;
            $uu['Store']=$Prodct->Store;
            $uu['Product']=$Prodct->Product;
            $uu['Unit']=$Prodct->Unit;
            $uu['Exp_Date']=$Prodct->Exp_Date;
            $uu['SalesOrder']=$ID;
            $uu['V1']=$Prodct->V1;
            $uu['V2']=$Prodct->V2;
            $uu['SubVID']=$Prodct->SubVID;
            $uu['TDiscount']=$Prodct->TDiscount;
            $uu['Pro_Note']=$Prodct->Pro_Note;
            ProductSalesOrder::create($uu);

            $xxx=SalesOrder::find(request('MergeTable'));



            $Product_Numbers=$xxx->Product_Numbers - 1;
            $Total_Qty=$xxx->Total_Qty - $Prodct->Qty;
            $Total_Discount=$xxx->Total_Discount - $Prodct->Discount;
            $Total_BF_Taxes=$xxx->Total_BF_Taxes - $Prodct->Total_Bf_Tax;
            $Total_Taxes=$xxx->Total_Taxes - $Prodct->Total_Tax;
            $Total_Price=$xxx->Total_Price - $Prodct->Total;
            $Pay=null;

            SalesOrder::where('id',$xxx->id)->update([
                'Product_Numbers'=>$Product_Numbers,
                'Total_Qty'=>$Total_Qty,
                'Total_Discount'=>$Total_Discount,
                'Total_BF_Taxes'=>$Total_BF_Taxes,
                'Total_Taxes'=>$Total_Taxes,
                'Total_Price'=>$Total_Price,
                'Pay'=>$Pay,

            ]);





            $xxxM=SalesOrder::find($ID);


            $Product_NumbersM=$xxxM->Product_Numbers + 1;
            $Total_QtyM=$xxxM->Total_Qty + $Prodct->Qty;
            $Total_DiscountM=$xxxM->Total_Discount + $Prodct->Discount;
            $Total_BF_TaxesM=$xxxM->Total_BF_Taxes + $Prodct->Total_Bf_Tax;
            $Total_TaxesM=$xxxM->Total_Taxes + $Prodct->Total_Tax;
            $Total_PriceM=$xxxM->Total_Price + $Prodct->Total;
            $PayM=null;

            SalesOrder::where('id',$xxxM->id)->update([
                'Product_Numbers'=>$Product_Numbers,
                'Total_Qty'=>$Total_Qty,
                'Total_Discount'=>$Total_Discount,
                'Total_BF_Taxes'=>$Total_BF_Taxes,
                'Total_Taxes'=>$Total_Taxes,
                'Total_Price'=>$Total_Price,
                'Pay'=>$Pay,

            ]);





            ProductSalesOrder::where('id',$ProID[$i])->delete();

        }

            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=ResturantTables::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ResturantTables::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //================= Products Filter =====================
    function SalesProductsResturantFilter(Request $request,SalesService $service)
    {
        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $store = $request->get('store');
            $client = $request->get('client');
            $Brand='';
            $Group='';
            $Qut=0;
            if($search != '' and $store != '')
            {


                $Prods=$this->FilterSalesProductQty($search,$store,$Brand,$Group);
                $data=$this->FilterSalesProductResturant($search,$Brand,$Group);
                $count= $this->FilterSalesProductQtyCount($search,$store,$Brand,$Group);
                $Get=$this->FilterSalesProductQtyGet($search,$store,$Brand,$Group);

            }

            $total_row = $Prods->count();
            $total_row2 = $data->count();
            $total_row3 = $total_row + $total_row2;
            if($total_row3 > 0)
            {



                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);

                foreach($Prods as $rows){


                    if(is_numeric($search)){

                        $rr = ProductUnits::where('Product', $rows->Product)->where('Barcode', $search)->first();
                    }else {
                        $rr = ProductUnits::where('Product', $rows->Product)->where('Def', 1)->first();
                    }

                    $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                    $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();

                    if(!empty($rows->Product()->first()->Weight)){
                        $weigh=$rows->Product()->first()->Weight;
                    }else{
                        $weigh=0;
                    }

                    if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                        $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                    }else{
                        $maxSa=0;
                    }

                    if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                        $Higher=$rows->Product()->first()->Group()->first()->Discount;
                    }else{

                        $Higher=0;
                    }

                    if(!empty($rows->Product()->first()->Brand)){

                        $branddX=$rows->Product()->first()->Brand;
                        if(app()->getLocale() == 'ar' ){
                            $brandd=$rows->Product()->first()->Brand()->first()->Name;

                        }else{
                            $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                        }

                    }else{

                        $brandd="";
                        $branddX="";

                    }


                    if($showw->Group_Brand == 1){

                        if(app()->getLocale() == 'ar' ){
                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                        }else{

                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                        }
                    }else{
                        $ShowGrBr='';
                    }


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $UniiName=$rr->Unit()->first()->Name;
                        $StoreNemo=$st->Name;

                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $UniiName=$rr->Unit()->first()->NameEn;
                        $StoreNemo=$st->NameEn;

                    }



                    if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){
                        $type=1;
                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;
                    }elseif($rows->Product()->first()->P_Type == 'Serial'){
                        $type=2;
                        $v_name='';
                        $vv_name='';
                        $serial=1;
                        $p_code= $rows->P_Code;
                    }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                        if(app()->getLocale() == 'ar' ){
                            $PrrroVName=$rows->V1()->first()->Name;

                        }else{
                            $PrrroVName=$rows->V1()->first()->NameEn;

                        }

                        $type=3;
                        $v_name=$PrrroVName;
                        $vv_name='';
                        $serial=0;
                        $p_code= $rows->P_Code;
                    }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                        if(app()->getLocale() == 'ar' ){
                            $PrrroVName=$rows->V1()->first()->Name;
                            $PrrroVVName=$rows->V2()->first()->Name;
                        }else{
                            $PrrroVName=$rows->V1()->first()->NameEn;
                            $PrrroVVName=$rows->V2()->first()->NameEn;
                        }

                        $type=4;
                        $v_name=$PrrroVName;
                        $vv_name=$PrrroVVName;
                        $serial=0;
                        $p_code= $rows->P_Code;
                    }

                    $Filter=[

                        'client'=>$client,
                        'store'=>$store,
                        'product'=>$rows->Product,
                        'id'=>$rows->id,
                        'name_ar'=>$rows->P_Ar_Name,
                        'name_en'=>$rows->P_En_Name,
                        'v1'=>$rows->V1,
                        'v2'=>$rows->V2,
                        'type'=>$type,
                        'PrrroName'=>$PrrroName,
                        'UniiName'=>$UniiName,
                        'StoreNemo'=>$StoreNemo,
                        'weigh'=>$weigh,
                        'maxSa'=>$maxSa,
                        'P_Code'=>$p_code,
                        'qty'=>$rows->Qty / $rr->Rate,
                        'Original'=>$rows->Original,
                        'Patch_Number'=>$rows->Patch_Number,
                        'brandd'=>$brandd,
                        'ShowGrBr'=>$ShowGrBr,
                        'Higher'=>$Higher,
                        'v_name'=>$v_name,
                        'vv_name'=>$vv_name,
                        'serial'=>$serial,
                        'Exp_Date'=>$rows->Exp_Date,
                        'pro_store'=>$rows->Store,
                        'AdditionsCount'=>$AdditionsCount,
                        'search'=>$search,
                    ];

                    $output .=$service->ItemsFilterResturant($Filter);




                }

                foreach($data as $rows){

                    if(is_numeric($search)){

                        $ser_x=1;
                        $ser_y=0;

                    }else{


                        $ser_x=1;
                        $ser_y=1;


                    }



                    if($rows->Def == $ser_x or $rows->Def == $ser_y){

                        if(is_numeric($search)){

                            $rr = ProductUnits::where('Product', $rows->Product)->where('Barcode', $search)->first();
                        }else {
                            $rr = ProductUnits::where('Product', $rows->Product)->where('Def', 1)->first();
                        }

                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();

                        if(!empty($rows->Product()->first()->Weight)){
                            $weigh=$rows->Product()->first()->Weight;
                        }else{
                            $weigh=0;
                        }

                        if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                            $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                        }else{
                            $maxSa=0;
                        }

                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $branddX=$rows->Product()->first()->Brand;
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;

                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        }else{

                            $brandd="";
                            $branddX="";

                        }

                        if($showw->Group_Brand == 1){

                            if(app()->getLocale() == 'ar' ){
                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                            }else{

                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                            }
                        }else{
                            $ShowGrBr='';
                        }


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;
                            $UniiName=$rr->Unit()->first()->Name;
                            $StoreNemo=$st->Name;

                        }else{
                            $PrrroName=$rows->P_En_Name;
                            $UniiName=$rr->Unit()->first()->NameEn;
                            $StoreNemo=$st->NameEn;

                        }

                        if($rows->Product()->first()->P_Type == 'Assembly'){

                            $type=1;
                            $avv=0;

                            $cost=$service->AssemblyCost($rows->Product,$store);
                            $qty=$service->AssemblyQty($rows->Product,$store);

                        }elseif($rows->Product()->first()->P_Type == 'Variable_Aggregate'){

                            $type=3;
                            $avv=1;
                            $cost=0;
                            $qty=1000;
                        }elseif($rows->Product()->first()->P_Type == 'Service'){

                            $type=2;
                            $avv=0;
                            $cost=0;
                            $qty=1000;
                        }

                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;



                        if($rows->Product()->first()->P_Type == 'Assembly' or $rows->Product()->first()->P_Type == 'Service' or $rows->Product()->first()->P_Type == 'Variable_Aggregate'){
                            $Filter=[

                                'client'=>$client,
                                'store'=>$store,
                                'id'=>$rows->id,
                                'product'=>$rows->Product,
                                'name_ar'=>$rows->P_Ar_Name,
                                'name_en'=>$rows->P_En_Name,
                                'v1'=>$rows->V1,
                                'v2'=>$rows->V2,
                                'type'=>$type,
                                'PrrroName'=>$PrrroName,
                                'UniiName'=>$UniiName,
                                'StoreNemo'=>$StoreNemo,
                                'weigh'=>$weigh,
                                'maxSa'=>$maxSa,
                                'P_Code'=>$p_code,
                                'qty'=>$qty,
                                'Original'=>$rows->Original,
                                'Patch_Number'=>$rows->Patch_Number,
                                'brandd'=>$brandd,
                                'ShowGrBr'=>$ShowGrBr,
                                'Higher'=>$Higher,
                                'v_name'=>$v_name,
                                'vv_name'=>$vv_name,
                                'serial'=>$serial,
                                'Exp_Date'=>$rows->Exp_Date,
                                'cost'=>$cost,
                                'AdditionsCount'=>$AdditionsCount,
                                'AV'=>$avv,
                                'search'=>$search,

                            ];

                            $output .=$service->ItemsFilterTwoResturant($Filter);
                        }



                    }
                }

            }else
            {
                $output = '
        <div class="col-md-12">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
                'count'  => $count,
                'Get'  => $Get,
            );
            echo json_encode($data);
        }
    }

    function SalesProductsResturantSearchCodeFilter(Request $request,SalesService $service)
    {
        if($request->ajax())
        {
            $output = '';
            $search = $request->get('search');
            $store = $request->get('store');
            $client = $request->get('client');
            $Brand='';
            $Group='';
            $Qut=0;
            if($search != '' and $store != '')
            {


                $Prods=$this->FilterSalesProductQtySearchCode($search,$store,$Brand,$Group);
                $data=$this->FilterSalesProductSearchCodeResturant($search,$Brand,$Group);
                $count= $this->FilterSalesProductQtyCountSearchCode($search,$store,$Brand,$Group);
                $Get=$this->FilterSalesProductQtyGetSearchCode($search,$store,$Brand,$Group);

            }

            $total_row = $Prods->count();
            $total_row2 = $data->count();
            $total_row3 = $total_row + $total_row2;
            if($total_row3 > 0)
            {



                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);

                foreach($Prods as $rows){


                    $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                    $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();


                    $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();



                    if(!empty($rows->Product()->first()->Weight)){
                        $weigh=$rows->Product()->first()->Weight;
                    }else{
                        $weigh=0;
                    }

                    if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                        $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                    }else{
                        $maxSa=0;
                    }

                    if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                        $Higher=$rows->Product()->first()->Group()->first()->Discount;
                    }else{

                        $Higher=0;
                    }

                    if(!empty($rows->Product()->first()->Brand)){

                        $branddX=$rows->Product()->first()->Brand;
                        if(app()->getLocale() == 'ar' ){
                            $brandd=$rows->Product()->first()->Brand()->first()->Name;

                        }else{
                            $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                        }

                    }else{

                        $brandd="";
                        $branddX="";

                    }


                    if($showw->Group_Brand == 1){

                        if(app()->getLocale() == 'ar' ){
                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                        }else{

                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                        }
                    }else{
                        $ShowGrBr='';
                    }


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $UniiName=$rr->Unit()->first()->Name;
                        $StoreNemo=$st->Name;

                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $UniiName=$rr->Unit()->first()->NameEn;
                        $StoreNemo=$st->NameEn;

                    }



                    if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){
                        $type=1;
                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;
                    }elseif($rows->Product()->first()->P_Type == 'Serial'){
                        $type=2;
                        $v_name='';
                        $vv_name='';
                        $serial=1;
                        $p_code= $rows->P_Code;
                    }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                        if(app()->getLocale() == 'ar' ){
                            $PrrroVName=$rows->V1()->first()->Name;

                        }else{
                            $PrrroVName=$rows->V1()->first()->NameEn;

                        }

                        $type=3;
                        $v_name=$PrrroVName;
                        $vv_name='';
                        $serial=0;
                        $p_code= $rows->P_Code;
                    }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                        if(app()->getLocale() == 'ar' ){
                            $PrrroVName=$rows->V1()->first()->Name;
                            $PrrroVVName=$rows->V2()->first()->Name;
                        }else{
                            $PrrroVName=$rows->V1()->first()->NameEn;
                            $PrrroVVName=$rows->V2()->first()->NameEn;
                        }

                        $type=4;
                        $v_name=$PrrroVName;
                        $vv_name=$PrrroVVName;
                        $serial=0;
                        $p_code= $rows->P_Code;
                    }

                    $Filter=[

                        'client'=>$client,
                        'store'=>$store,
                        'product'=>$rows->Product,
                        'id'=>$rows->id,
                        'name_ar'=>$rows->P_Ar_Name,
                        'name_en'=>$rows->P_En_Name,
                        'v1'=>$rows->V1,
                        'v2'=>$rows->V2,
                        'type'=>$type,
                        'PrrroName'=>$PrrroName,
                        'UniiName'=>$UniiName,
                        'StoreNemo'=>$StoreNemo,
                        'weigh'=>$weigh,
                        'maxSa'=>$maxSa,
                        'P_Code'=>$p_code,
                        'qty'=>$rows->Qty / $rr->Rate,
                        'Original'=>$rows->Original,
                        'Patch_Number'=>$rows->Patch_Number,
                        'brandd'=>$brandd,
                        'ShowGrBr'=>$ShowGrBr,
                        'Higher'=>$Higher,
                        'v_name'=>$v_name,
                        'vv_name'=>$vv_name,
                        'serial'=>$serial,
                        'Exp_Date'=>$rows->Exp_Date,
                        'pro_store'=>$rows->Store,
                        'AdditionsCount'=>$AdditionsCount,


                    ];

                    $output .=$service->ItemsFilterResturant($Filter);




                }

                foreach($data as $rows){
                    if(is_numeric($search)){

                        $ser_x=1;
                        $ser_y=0;

                    }else{


                        $ser_x=1;
                        $ser_y=1;


                    }



                    if($rows->Def == $ser_x or $rows->Def == $ser_y){


                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();

                        if(!empty($rows->Product()->first()->Weight)){
                            $weigh=$rows->Product()->first()->Weight;
                        }else{
                            $weigh=0;
                        }

                        if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                            $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                        }else{
                            $maxSa=0;
                        }

                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $branddX=$rows->Product()->first()->Brand;
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;

                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        }else{

                            $brandd="";
                            $branddX="";

                        }

                        if($showw->Group_Brand == 1){

                            if(app()->getLocale() == 'ar' ){
                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                            }else{

                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                            }
                        }else{
                            $ShowGrBr='';
                        }


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;
                            $UniiName=$rr->Unit()->first()->Name;
                            $StoreNemo=$st->Name;

                        }else{
                            $PrrroName=$rows->P_En_Name;
                            $UniiName=$rr->Unit()->first()->NameEn;
                            $StoreNemo=$st->NameEn;

                        }

                        if($rows->Product()->first()->P_Type == 'Assembly'){

                            $type=1;
$avv=0;
                            $cost=$service->AssemblyCost($rows->Product,$store);
                            $qty=$service->AssemblyQty($rows->Product,$store);

                        }elseif($rows->Product()->first()->P_Type == 'Variable_Aggregate'){

                            $type=2;
                            $avv=1;
                            $cost=0;
                            $qty=1000;
                        }elseif($rows->Product()->first()->P_Type == 'Service'){

                            $type=2;
                            $avv=0;
                            $cost=0;
                            $qty=1000;
                        }

                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;



                        if($rows->Product()->first()->P_Type == 'Assembly' or $rows->Product()->first()->P_Type == 'Service' or $rows->Product()->first()->P_Type == 'Variable_Aggregate'){
                            $Filter=[

                                'client'=>$client,
                                'store'=>$store,
                                'id'=>$rows->id,
                                'product'=>$rows->Product,
                                'name_ar'=>$rows->P_Ar_Name,
                                'name_en'=>$rows->P_En_Name,
                                'v1'=>$rows->V1,
                                'v2'=>$rows->V2,
                                'type'=>$type,
                                'PrrroName'=>$PrrroName,
                                'UniiName'=>$UniiName,
                                'StoreNemo'=>$StoreNemo,
                                'weigh'=>$weigh,
                                'maxSa'=>$maxSa,
                                'P_Code'=>$p_code,
                                'qty'=>$qty,
                                'Original'=>$rows->Original,
                                'Patch_Number'=>$rows->Patch_Number,
                                'brandd'=>$brandd,
                                'ShowGrBr'=>$ShowGrBr,
                                'Higher'=>$Higher,
                                'v_name'=>$v_name,
                                'vv_name'=>$vv_name,
                                'serial'=>$serial,
                                'Exp_Date'=>$rows->Exp_Date,
                                'cost'=>$cost,
                                'AdditionsCount'=>$AdditionsCount,
                                'AV'=>$avv,

                            ];

                            $output .=$service->ItemsFilterTwoResturant($Filter);
                        }



                    }
                }

            }else
            {
                $output = '
        <div class="col-md-12">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
                'count'  => $count,
                'Get'  => $Get,
            );
            echo json_encode($data);
        }
    }

    function GroupResturantFilter(Request $request,SalesService $service)
    {


        if($request->ajax())
        {
            $output = '';
            $group = $request->get('group');
            $store = $request->get('store');
            $client = $request->get('client');
            if($group != '')
            {


                $Prods=$this->FilterSalesProductQtyGroup($group,$store);
                $data=$this->FilterSalesProductGroupResturant($group);



            }

            $total_row = $Prods->count();
            $total_row2 = $data->count();
            $total_row3 = $total_row +  $total_row2 ;
            if($total_row3 > 0)
            {

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);
                foreach($Prods as $rows){


                    $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                    $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                    $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();

                    if(!empty($rows->Product()->first()->Weight)){
                        $weigh=$rows->Product()->first()->Weight;
                    }else{
                        $weigh=0;
                    }

                    if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                        $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                    }else{
                        $maxSa=0;
                    }

                    if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                        $Higher=$rows->Product()->first()->Group()->first()->Discount;
                    }else{

                        $Higher=0;
                    }

                    if(!empty($rows->Product()->first()->Brand)){

                        $branddX=$rows->Product()->first()->Brand;
                        if(app()->getLocale() == 'ar' ){
                            $brandd=$rows->Product()->first()->Brand()->first()->Name;

                        }else{
                            $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                        }

                    }else{

                        $brandd="";
                        $branddX="";

                    }


                    if($showw->Group_Brand == 1){

                        if(app()->getLocale() == 'ar' ){
                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                        }else{

                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                        }
                    }else{
                        $ShowGrBr='';
                    }


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $UniiName=$rr->Unit()->first()->Name;
                        $StoreNemo=$st->Name;

                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $UniiName=$rr->Unit()->first()->NameEn;
                        $StoreNemo=$st->NameEn;

                    }



                    if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){
                        $type=1;
                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;
                    }elseif($rows->Product()->first()->P_Type == 'Serial'){
                        $type=2;
                        $v_name='';
                        $vv_name='';
                        $serial=1;
                        $p_code= $rows->P_Code;
                    }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                        if(app()->getLocale() == 'ar' ){
                            $PrrroVName=$rows->V1()->first()->Name;

                        }else{
                            $PrrroVName=$rows->V1()->first()->NameEn;

                        }

                        $type=3;
                        $v_name=$PrrroVName;
                        $vv_name='';
                        $serial=0;
                        $p_code= $rows->P_Code;
                    }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                        if(app()->getLocale() == 'ar' ){
                            $PrrroVName=$rows->V1()->first()->Name;
                            $PrrroVVName=$rows->V2()->first()->Name;
                        }else{
                            $PrrroVName=$rows->V1()->first()->NameEn;
                            $PrrroVVName=$rows->V2()->first()->NameEn;
                        }

                        $type=4;
                        $v_name=$PrrroVName;
                        $vv_name=$PrrroVVName;
                        $serial=0;
                        $p_code= $rows->P_Code;
                    }


                    if(!empty($rows->Product()->first()->Image)){
                        $img='<img src="'.URL::to($rows->Product()->first()->Image).'" alt="">';
                    }else{

                        $img='<img src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                    }





                    if($rows->Product()->first()->Group == $group){
                        $Filter=[

                            'client'=>$client,
                            'store'=>$store,
                            'product'=>$rows->Product,
                            'id'=>$rows->id,
                            'name_ar'=>$rows->P_Ar_Name,
                            'name_en'=>$rows->P_En_Name,
                            'v1'=>$rows->V1,
                            'v2'=>$rows->V2,
                            'type'=>$type,
                            'PrrroName'=>$PrrroName,
                            'UniiName'=>$UniiName,
                            'StoreNemo'=>$StoreNemo,
                            'weigh'=>$weigh,
                            'maxSa'=>$maxSa,
                            'P_Code'=>$p_code,
                            'qty'=>$rows->Qty / $rr->Rate,
                            'Original'=>$rows->Original,
                            'Patch_Number'=>$rows->Patch_Number,
                            'brandd'=>$brandd,
                            'ShowGrBr'=>$ShowGrBr,
                            'Higher'=>$Higher,
                            'v_name'=>$v_name,
                            'vv_name'=>$vv_name,
                            'serial'=>$serial,
                            'Exp_Date'=>$rows->Exp_Date,
                            'pro_store'=>$rows->Store,
                            'img'=>$img,
                            'AdditionsCount'=>$AdditionsCount,


                        ];

                        $output .=$service->ItemsFilterResturantCat($Filter);



                    }
                }

                foreach($data as $rows){


                    $ser_x=1;
                    $ser_y=1;




                    if($rows->Def == $ser_x or $rows->Def == $ser_y){


                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();

                        if(!empty($rows->Product()->first()->Weight)){
                            $weigh=$rows->Product()->first()->Weight;
                        }else{
                            $weigh=0;
                        }

                        if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                            $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                        }else{
                            $maxSa=0;
                        }

                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $branddX=$rows->Product()->first()->Brand;
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;

                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        }else{

                            $brandd="";
                            $branddX="";

                        }

                        if($showw->Group_Brand == 1){

                            if(app()->getLocale() == 'ar' ){
                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                            }else{

                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                            }
                        }else{
                            $ShowGrBr='';
                        }


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;
                            $UniiName=$rr->Unit()->first()->Name;
                            $StoreNemo=$st->Name;

                        }else{
                            $PrrroName=$rows->P_En_Name;
                            $UniiName=$rr->Unit()->first()->NameEn;
                            $StoreNemo=$st->NameEn;

                        }

                        if($rows->Product()->first()->P_Type == 'Assembly'){

                            $type=1;
                            $avv=0;
                            $cost=$service->AssemblyCost($rows->Product,$store);
                            $qty=$service->AssemblyQty($rows->Product,$store);

                        }elseif($rows->Product()->first()->P_Type == 'Variable_Aggregate'){

                            $type=3;
                            $avv=1;
                            $cost=0;
                            $qty=1000;
                        }elseif($rows->Product()->first()->P_Type == 'Service'){

                            $type=2;
                            $avv=0;
                            $cost=0;
                            $qty=1000;
                        }

                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;



                        if(!empty($rows->Product()->first()->Image)){
                            $img='<img src="'.URL::to($rows->Product()->first()->Image).'" alt="">';
                        }else{

                            $img='<img src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                        }



                        if($rows->Product()->first()->P_Type == 'Assembly' or $rows->Product()->first()->P_Type == 'Service' or $rows->Product()->first()->P_Type == 'Variable_Aggregate'){


                            if($rows->Product()->first()->Group == $group){
                                $Filter=[

                                    'client'=>$client,
                                    'store'=>$store,
                                    'id'=>$rows->id,
                                    'product'=>$rows->Product,
                                    'name_ar'=>$rows->P_Ar_Name,
                                    'name_en'=>$rows->P_En_Name,
                                    'v1'=>$rows->V1,
                                    'v2'=>$rows->V2,
                                    'type'=>$type,
                                    'PrrroName'=>$PrrroName,
                                    'UniiName'=>$UniiName,
                                    'StoreNemo'=>$StoreNemo,
                                    'weigh'=>$weigh,
                                    'maxSa'=>$maxSa,
                                    'P_Code'=>$p_code,
                                    'qty'=>$qty,
                                    'Original'=>$rows->Original,
                                    'Patch_Number'=>$rows->Patch_Number,
                                    'brandd'=>$brandd,
                                    'ShowGrBr'=>$ShowGrBr,
                                    'Higher'=>$Higher,
                                    'v_name'=>$v_name,
                                    'vv_name'=>$vv_name,
                                    'serial'=>$serial,
                                    'Exp_Date'=>$rows->Exp_Date,
                                    'cost'=>$cost,
                                    'img'=>$img,
                                    'AdditionsCount'=>$AdditionsCount,
                                    'AV'=>$avv,

                                ];

                                $output .=$service->ItemsFilterTwoResturantCat($Filter);
                            }
                        }


                    }
                }




            }else
            {
                $output = '
        <div class="col-md-12">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    function BrandsResturantFilter(Request $request,SalesService $service)
    {


        if($request->ajax())
        {
            $output = '';
            $group = $request->get('group');
            $store = $request->get('store');
            $client = $request->get('client');
            if($group != '')
            {


                $Prods=$this->FilterSalesProductQtyBrand($group,$store);
                $data=$this->FilterSalesProductBrandResturant($group);



            }

            $total_row = $Prods->count();
            $total_row2 = $data->count();
            $total_row3 = $total_row +  $total_row2 ;
            if($total_row3 > 0)
            {

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);
                foreach($Prods as $rows){


                    $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                    $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                    $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();

                    if(!empty($rows->Product()->first()->Weight)){
                        $weigh=$rows->Product()->first()->Weight;
                    }else{
                        $weigh=0;
                    }

                    if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                        $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                    }else{
                        $maxSa=0;
                    }

                    if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                        $Higher=$rows->Product()->first()->Group()->first()->Discount;
                    }else{

                        $Higher=0;
                    }

                    if(!empty($rows->Product()->first()->Brand)){

                        $branddX=$rows->Product()->first()->Brand;
                        if(app()->getLocale() == 'ar' ){
                            $brandd=$rows->Product()->first()->Brand()->first()->Name;

                        }else{
                            $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                        }

                    }else{

                        $brandd="";
                        $branddX="";

                    }


                    if($showw->Group_Brand == 1){

                        if(app()->getLocale() == 'ar' ){
                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                        }else{

                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                        }
                    }else{
                        $ShowGrBr='';
                    }


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $UniiName=$rr->Unit()->first()->Name;
                        $StoreNemo=$st->Name;

                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $UniiName=$rr->Unit()->first()->NameEn;
                        $StoreNemo=$st->NameEn;

                    }



                    if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){
                        $type=1;
                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;
                    }elseif($rows->Product()->first()->P_Type == 'Serial'){
                        $type=2;
                        $v_name='';
                        $vv_name='';
                        $serial=1;
                        $p_code= $rows->P_Code;
                    }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                        if(app()->getLocale() == 'ar' ){
                            $PrrroVName=$rows->V1()->first()->Name;

                        }else{
                            $PrrroVName=$rows->V1()->first()->NameEn;

                        }

                        $type=3;
                        $v_name=$PrrroVName;
                        $vv_name='';
                        $serial=0;
                        $p_code= $rows->P_Code;
                    }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                        if(app()->getLocale() == 'ar' ){
                            $PrrroVName=$rows->V1()->first()->Name;
                            $PrrroVVName=$rows->V2()->first()->Name;
                        }else{
                            $PrrroVName=$rows->V1()->first()->NameEn;
                            $PrrroVVName=$rows->V2()->first()->NameEn;
                        }

                        $type=4;
                        $v_name=$PrrroVName;
                        $vv_name=$PrrroVVName;
                        $serial=0;
                        $p_code= $rows->P_Code;
                    }


                    if(!empty($rows->Product()->first()->Image)){
                        $img='<img src="'.URL::to($rows->Product()->first()->Image).'" alt="">';
                    }else{

                        $img='<img src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                    }





                    if($rows->Product()->first()->Brand == $group){
                        $Filter=[

                            'client'=>$client,
                            'store'=>$store,
                            'product'=>$rows->Product,
                            'id'=>$rows->id,
                            'name_ar'=>$rows->P_Ar_Name,
                            'name_en'=>$rows->P_En_Name,
                            'v1'=>$rows->V1,
                            'v2'=>$rows->V2,
                            'type'=>$type,
                            'PrrroName'=>$PrrroName,
                            'UniiName'=>$UniiName,
                            'StoreNemo'=>$StoreNemo,
                            'weigh'=>$weigh,
                            'maxSa'=>$maxSa,
                            'P_Code'=>$p_code,
                            'qty'=>$rows->Qty / $rr->Rate,
                            'Original'=>$rows->Original,
                            'Patch_Number'=>$rows->Patch_Number,
                            'brandd'=>$brandd,
                            'ShowGrBr'=>$ShowGrBr,
                            'Higher'=>$Higher,
                            'v_name'=>$v_name,
                            'vv_name'=>$vv_name,
                            'serial'=>$serial,
                            'Exp_Date'=>$rows->Exp_Date,
                            'pro_store'=>$rows->Store,
                            'img'=>$img,
                            'AdditionsCount'=>$AdditionsCount,


                        ];

                        $output .=$service->ItemsFilterResturantCat($Filter);



                    }
                }

                foreach($data as $rows){


                    $ser_x=1;
                    $ser_y=1;





                    if($rows->Def == $ser_x or $rows->Def == $ser_y){


                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();

                        if(!empty($rows->Product()->first()->Weight)){
                            $weigh=$rows->Product()->first()->Weight;
                        }else{
                            $weigh=0;
                        }

                        if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                            $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                        }else{
                            $maxSa=0;
                        }

                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $branddX=$rows->Product()->first()->Brand;
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;

                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        }else{

                            $brandd="";
                            $branddX="";

                        }

                        if($showw->Group_Brand == 1){

                            if(app()->getLocale() == 'ar' ){
                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                            }else{

                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                            }
                        }else{
                            $ShowGrBr='';
                        }


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;
                            $UniiName=$rr->Unit()->first()->Name;
                            $StoreNemo=$st->Name;

                        }else{
                            $PrrroName=$rows->P_En_Name;
                            $UniiName=$rr->Unit()->first()->NameEn;
                            $StoreNemo=$st->NameEn;

                        }

                        if($rows->Product()->first()->P_Type == 'Assembly'){

                            $type=1;
                            $avv=0;
                            $cost=$service->AssemblyCost($rows->Product,$store);
                            $qty=$service->AssemblyQty($rows->Product,$store);

                        }elseif($rows->Product()->first()->P_Type == 'Variable_Aggregate'){

                            $type=3;
                            $avv=1;
                            $cost=0;
                            $qty=1000;
                        }elseif($rows->Product()->first()->P_Type == 'Service'){

                            $type=2;
                            $avv=0;
                            $cost=0;
                            $qty=1000;
                        }

                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;



                        if(!empty($rows->Product()->first()->Image)){
                            $img='<img src="'.URL::to($rows->Product()->first()->Image).'" alt="">';
                        }else{

                            $img='<img src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                        }



                        if($rows->Product()->first()->P_Type == 'Assembly' or $rows->Product()->first()->P_Type == 'Service' or $rows->Product()->first()->P_Type == 'Variable_Aggregate'){


                            if($rows->Product()->first()->Brand == $group){
                                $Filter=[

                                    'client'=>$client,
                                    'store'=>$store,
                                    'id'=>$rows->id,
                                    'product'=>$rows->Product,
                                    'name_ar'=>$rows->P_Ar_Name,
                                    'name_en'=>$rows->P_En_Name,
                                    'v1'=>$rows->V1,
                                    'v2'=>$rows->V2,
                                    'type'=>$type,
                                    'PrrroName'=>$PrrroName,
                                    'UniiName'=>$UniiName,
                                    'StoreNemo'=>$StoreNemo,
                                    'weigh'=>$weigh,
                                    'maxSa'=>$maxSa,
                                    'P_Code'=>$p_code,
                                    'qty'=>$qty,
                                    'Original'=>$rows->Original,
                                    'Patch_Number'=>$rows->Patch_Number,
                                    'brandd'=>$brandd,
                                    'ShowGrBr'=>$ShowGrBr,
                                    'Higher'=>$Higher,
                                    'v_name'=>$v_name,
                                    'vv_name'=>$vv_name,
                                    'serial'=>$serial,
                                    'Exp_Date'=>$rows->Exp_Date,
                                    'cost'=>$cost,
                                    'img'=>$img,
                                    'AdditionsCount'=>$AdditionsCount,
                                    'AV'=>$avv,

                                ];

                                $output .=$service->ItemsFilterTwoResturantCat($Filter);
                            }
                        }


                    }
                }




            }else
            {
                $output = '
        <div class="col-md-12">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    function AllProsResturantFilter(Request $request,SalesService $service)
    {


        if($request->ajax())
        {
            $output = '';

            $store = $request->get('store');
            $client = $request->get('client');


            $Prods=$this->FilterSalesProductQtyAll($store);
            $data=$this->FilterSalesProductAllResturant();




            $total_row = $Prods->count();
            $total_row2 = $data->count();
            $total_row3 = $total_row +  $total_row2 ;
            if($total_row3 > 0)
            {

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                $showw=DefaultDataShowHide::orderBy('id','desc')->first();
                $st = Stores::find($store);
                foreach($Prods as $rows){


                    $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                    $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                    $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();


                    if(!empty($rows->Product()->first()->Weight)){
                        $weigh=$rows->Product()->first()->Weight;
                    }else{
                        $weigh=0;
                    }

                    if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                        $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                    }else{
                        $maxSa=0;
                    }

                    if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                        $Higher=$rows->Product()->first()->Group()->first()->Discount;
                    }else{

                        $Higher=0;
                    }

                    if(!empty($rows->Product()->first()->Brand)){

                        $branddX=$rows->Product()->first()->Brand;
                        if(app()->getLocale() == 'ar' ){
                            $brandd=$rows->Product()->first()->Brand()->first()->Name;

                        }else{
                            $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                        }

                    }else{

                        $brandd="";
                        $branddX="";

                    }


                    if($showw->Group_Brand == 1){

                        if(app()->getLocale() == 'ar' ){
                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                        }else{

                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                        }
                    }else{
                        $ShowGrBr='';
                    }


                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$rows->P_Ar_Name;
                        $UniiName=$rr->Unit()->first()->Name;
                        $StoreNemo=$st->Name;

                    }else{
                        $PrrroName=$rows->P_En_Name;
                        $UniiName=$rr->Unit()->first()->NameEn;
                        $StoreNemo=$st->NameEn;

                    }



                    if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){
                        $type=1;
                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;
                    }elseif($rows->Product()->first()->P_Type == 'Serial'){
                        $type=2;
                        $v_name='';
                        $vv_name='';
                        $serial=1;
                        $p_code= $rows->P_Code;
                    }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                        if(app()->getLocale() == 'ar' ){
                            $PrrroVName=$rows->V1()->first()->Name;

                        }else{
                            $PrrroVName=$rows->V1()->first()->NameEn;

                        }

                        $type=3;
                        $v_name=$PrrroVName;
                        $vv_name='';
                        $serial=0;
                        $p_code= $rows->P_Code;
                    }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){


                        if(app()->getLocale() == 'ar' ){
                            $PrrroVName=$rows->V1()->first()->Name;
                            $PrrroVVName=$rows->V2()->first()->Name;
                        }else{
                            $PrrroVName=$rows->V1()->first()->NameEn;
                            $PrrroVVName=$rows->V2()->first()->NameEn;
                        }

                        $type=4;
                        $v_name=$PrrroVName;
                        $vv_name=$PrrroVVName;
                        $serial=0;
                        $p_code= $rows->P_Code;
                    }


                    if(!empty($rows->Product()->first()->Image)){
                        $img='<img src="'.URL::to($rows->Product()->first()->Image).'" alt="">';
                    }else{

                        $img='<img src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                    }






                    $Filter=[

                        'client'=>$client,
                        'store'=>$store,
                        'product'=>$rows->Product,
                        'id'=>$rows->id,
                        'name_ar'=>$rows->P_Ar_Name,
                        'name_en'=>$rows->P_En_Name,
                        'v1'=>$rows->V1,
                        'v2'=>$rows->V2,
                        'type'=>$type,
                        'PrrroName'=>$PrrroName,
                        'UniiName'=>$UniiName,
                        'StoreNemo'=>$StoreNemo,
                        'weigh'=>$weigh,
                        'maxSa'=>$maxSa,
                        'P_Code'=>$p_code,
                        'qty'=>$rows->Qty / $rr->Rate,
                        'Original'=>$rows->Original,
                        'Patch_Number'=>$rows->Patch_Number,
                        'brandd'=>$brandd,
                        'ShowGrBr'=>$ShowGrBr,
                        'Higher'=>$Higher,
                        'v_name'=>$v_name,
                        'vv_name'=>$vv_name,
                        'serial'=>$serial,
                        'Exp_Date'=>$rows->Exp_Date,
                        'pro_store'=>$rows->Store,
                        'img'=>$img,
                        'AdditionsCount'=>$AdditionsCount,

                    ];

                    $output .=$service->ItemsFilterResturantCat($Filter);




                }

                foreach($data as $rows){

                    $ser_x=1;
                    $ser_y=1;





                    if($rows->Def == $ser_x or $rows->Def == $ser_y){


                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                        $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();


                        if(!empty($rows->Product()->first()->Weight)){
                            $weigh=$rows->Product()->first()->Weight;
                        }else{
                            $weigh=0;
                        }

                        if(!empty($rows->Product()->first()->Maximum_Sales_Qty)){
                            $maxSa=$rows->Product()->first()->Maximum_Sales_Qty;
                        }else{
                            $maxSa=0;
                        }

                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $branddX=$rows->Product()->first()->Brand;
                            if(app()->getLocale() == 'ar' ){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;

                            }else{
                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }

                        }else{

                            $brandd="";
                            $branddX="";

                        }

                        if($showw->Group_Brand == 1){

                            if(app()->getLocale() == 'ar' ){
                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.') ';
                            }else{

                                $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.') ';
                            }
                        }else{
                            $ShowGrBr='';
                        }


                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->P_Ar_Name;
                            $UniiName=$rr->Unit()->first()->Name;
                            $StoreNemo=$st->Name;

                        }else{
                            $PrrroName=$rows->P_En_Name;
                            $UniiName=$rr->Unit()->first()->NameEn;
                            $StoreNemo=$st->NameEn;

                        }

                        if($rows->Product()->first()->P_Type == 'Assembly'){

                            $type=1;
$avv=0;
                            $cost=$service->AssemblyCost($rows->Product,$store);
                            $qty=$service->AssemblyQty($rows->Product,$store);

                        }elseif($rows->Product()->first()->P_Type == 'Variable_Aggregate'){

                            $type=3;
                            $avv=1;
                            $cost=0;
                            $qty=1000;
                        }elseif($rows->Product()->first()->P_Type == 'Service'){

                            $type=2;
                            $avv=0;
                            $cost=0;
                            $qty=1000;
                        }

                        $v_name='';
                        $vv_name='';
                        $serial=0;
                        $p_code=$rr->Barcode;



                        if(!empty($rows->Product()->first()->Image)){
                            $img='<img src="'.URL::to($rows->Product()->first()->Image).'" alt="">';
                        }else{

                            $img='<img src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                        }



                        if($rows->Product()->first()->P_Type == 'Assembly' or $rows->Product()->first()->P_Type == 'Service' or $rows->Product()->first()->P_Type == 'Variable_Aggregate'){



                            $Filter=[

                                'client'=>$client,
                                'store'=>$store,
                                'id'=>$rows->id,
                                'product'=>$rows->Product,
                                'name_ar'=>$rows->P_Ar_Name,
                                'name_en'=>$rows->P_En_Name,
                                'v1'=>$rows->V1,
                                'v2'=>$rows->V2,
                                'type'=>$type,
                                'PrrroName'=>$PrrroName,
                                'UniiName'=>$UniiName,
                                'StoreNemo'=>$StoreNemo,
                                'weigh'=>$weigh,
                                'maxSa'=>$maxSa,
                                'P_Code'=>$p_code,
                                'qty'=>$qty,
                                'Original'=>$rows->Original,
                                'Patch_Number'=>$rows->Patch_Number,
                                'brandd'=>$brandd,
                                'ShowGrBr'=>$ShowGrBr,
                                'Higher'=>$Higher,
                                'v_name'=>$v_name,
                                'vv_name'=>$vv_name,
                                'serial'=>$serial,
                                'Exp_Date'=>$rows->Exp_Date,
                                'cost'=>$cost,
                                'img'=>$img,
                                'AdditionsCount'=>$AdditionsCount,
                                'AV'=>$avv,

                            ];

                            $output .=$service->ItemsFilterTwoResturantCat($Filter);
                        }



                    }

                }




            }else
            {
                $output = '
        <div class="col-md-12">'.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    function SalesHoldBillsResturantFilter(Request $request)
    {

        if($request->ajax())
        {
            $output = '';
            $search = $request->get('searchHold');

            if($search != '')
            {

                    $Prods=SalesOrder::where('Code',$search)->resturantholdtype()->get();

            }

            $total_row = $Prods->count();
            if($total_row > 0)
            {

                foreach($Prods as $rows){



                    $output .= '


          <form class="col-md-6" action="'.url('HoldSaleResturant').'" id="ORDERHOLD" method="get">
                <input type="hidden" name="OrderID" value="'.$rows->id.'">
                          <button type="submit" style="background: unset; border: unset; width: 100%" >
                          <table class="table table-bordered" style="background: #c59cc5;">
                              <tr>
                                  <td> '.trans('admin.Code').'</td>
                                  <td> '.$rows->Code.'</td>

                              </tr>
                              <tr>
                                  <td>'.trans('admin.Date').'</td>
                                  <td>'.$rows->Date.'</td>

                              </tr>
                              <tr>
                                  <td>'.trans('admin.Total_Price').'</td>
                                  <td>'.$rows->Total_Price.'</td>

                              </tr>
                          </table>
                 </button>
</form>


            ';
                }

            }else
            {
                $output = '
        <div class="col-md-12"> '.trans('admin.No_Data_Find').' </div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    function AdditonsProsFilter(Request $request,Average $average,SalesService $service)
    {


        if($request->ajax())
        {
            $output = '';
            $Pro = $request->get('Pro');
            $store = $request->get('store');
            $client = $request->get('client');
            if($Pro != '')
            {


                $Prods=AdditionalProducts::where('Product',$Pro)->get();


            }

            $total_row = $Prods->count();
            $total_row3 = $total_row ;
            if($total_row3 > 0)
            {

                $Def=SalesDefaultData::orderBy('id','desc')->first();
                if($Def->Price_Sale == 0){
                    $show='disabled';
                }else{

                    $show='';
                }

                foreach($Prods as $rows){
                    $show=DefaultDataShowHide::orderBy('id','desc')->first();
                    $rr=ProductUnits::where('Product',$rows->Additional_Product)->where('Def',1)->first();
                    $plow=ProductUnits::where('Product',$rows->Additional_Product)->where('Rate',1)->first();
                    $AdditionsCount=AdditionalProducts::where('Product',$rows->Additional_Product)->count();
                    $proUni=ProductUnits::where('Product',$rows->Additional_Product)->first();

                    $AvQty=$this->ProAvQties($store,$rows->Additional_Product,$proUni->Barcode);
                    $COSTpr=$average->AverageCostGetUnit($rr->Product,$rr->Barcode,$store,$rr->Unit);

                    $Stores=Stores::all();
                    $units=ProductUnits::where('Product',$rows->Additional_Product)->get();
                    $rr=ProductUnits::where('Product',$rows->Additional_Product)->where('Def',1)->first();
                    $x = ProductsQty::where("Unit",$rr->Unit)->where('Product',$rows->Additional_Product)->first();

                    $Cli=Customers::where('Account',$client)->first();

                    $pr=$service->PriceLevel($client,$rr);

                    if(!empty($Cli)){

                        if(!empty($Cli->Group)){
                            $nwD=CustomersGroup::find($Cli->Group);

                            if(!empty($nwD->Discount)){

                                if($nwD->Discount == 0){

                                    if(!empty($ItemsGroupsDiscount)){

                                        if(!empty($ItemsGroupsDiscount->Discount)){
                                            $DES=$ItemsGroupsDiscount->Discount;
                                        }else{
                                            $DES=0;
                                        }

                                    }else{

                                        $DES=0;
                                    }

                                }else{
                                    $DES= $nwD->Discount ;
                                }


                            }else{


                                if(!empty($ItemsGroupsDiscount)){

                                    if(!empty($ItemsGroupsDiscount->Discount)){
                                        $DES=$ItemsGroupsDiscount->Discount;
                                    }else{
                                        $DES=0;
                                    }

                                }else{

                                    $DES=0;
                                }


                            }


                        }else{

                            if(!empty($ItemsGroupsDiscount)){

                                if(!empty($ItemsGroupsDiscount->Discount)){
                                    $DES=$ItemsGroupsDiscount->Discount;
                                }else{
                                    $DES=0;
                                }

                            }else{

                                $DES=0;
                            }

                        }

                    }else{

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }

                    $Higher=$DES;


                    if(!empty($rows->Additional_Product()->first()->Brand)){

                        $brandd=$rows->Additional_Product()->first()->Brand()->first()->Name;
                    }else{

                        $brandd="";

                    }

                    $st=Stores::find($store);

                    if(!empty($rows->Additional_Product()->first()->Image)){
                        $img='<img src="'.URL::to($rows->Product()->first()->Image).'" alt="">';
                    }else{

                        $img='<img src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                    }

                    if($rows->Additional_Product()->first()->P_Type == 'Additions'){

                        if($rows->Additional_Product()->first()->Status == 0){


                            if(app()->getLocale() == 'ar' ){
                                $PrrroName=$rows->Additional_Product()->first()->P_Ar_Name;
                                $UniiName=$rr->Unit()->first()->Name;


                            }else{
                                $PrrroName=$rows->Additional_Product()->first()->P_En_Name;
                                $UniiName=$rr->Unit()->first()->NameEn;


                            }


                            if($AvQty->Qty  != 0){
                                $output .= '

          <div class="col-md-4" onclick="Fun('.$rows->id.')">
                        <div class="item-details">
                                            '.$img.'
                                            <p>'.$PrrroName.'</p>
                                            <span>'.$pr.'</span>

         <input type="hidden"  id="Row'.$rows->id.'">
         <input type="hidden"  id="P_Ar_Name'.$rows->id.'" value="'.$rows->Additional_Product()->first()->P_Ar_Name.'">
        <input type="hidden"  id="P_En_Name'.$rows->id.'" value="'.$rows->Additional_Product()->first()->P_En_Name.'">
        <input type="hidden"  id="Product'.$rows->id.'" value="'.$rows->Additional_Product.'">
        <input type="hidden"  id="VOne'.$rows->id.'" value="'.$rows->V1.'">
        <input type="hidden"  id="VTwo'.$rows->id.'" value="'.$rows->V2.'">
        <input type="hidden"  id="V_Name'.$rows->id.'" value="">
        <input type="hidden"  id="VV_Name'.$rows->id.'" value="">
        <input type="hidden" id="CodePurch'.$rows->id.'" class="form-control" value="'.$rr->Barcode.'"  disabled>
        <input type="hidden" id="UnitPurchName'.$rows->id.'" value="'.$UniiName.'">
        <input type="hidden" id="UnitPurch'.$rows->id.'" value="'.$rr->Unit.'">
        <input type="hidden" id="TaxRate'.$rows->id.'" value="'.$rows->Additional_Product()->first()->Tax()->first()->Rate.'">
        <input type="hidden" id="TaxType'.$rows->id.'" value="'.$rows->Additional_Product()->first()->Tax()->first()->Type.'">
        <input type="hidden" id="PurchTax'.$rows->id.'" value="'.$rows->Additional_Product()->first()->Tax.'">
         <input type="hidden"  id="AvQty'.$rows->id.'" value="'.$AvQty->Qty.'">
         <input type="hidden"  id="Qty'.$rows->id.'" value="1">
         <input type="hidden"  id="Price'.$rows->id.'" value="'.$pr.'">
         <input type="hidden"  id="Discount'.$rows->id.'" value="'.$DES.'">
                   <input type="hidden" id="TDiscPro'.$rows->id.'"   class="form-control" value="'.$DES.'" >
         <input type="hidden" id="TotalBFTax'.$rows->id.'"  value="'.$pr.'" >
         <input type="hidden" id="Tax'.$rows->id.'"   value="0" >
         <input type="hidden" id="Total'.$rows->id.'"   value="'.$pr.'" >
        <input type="hidden" id="StorePurchName'.$rows->id.'"  value="'.$st->id.'" >
        <input type="hidden" id="ExpDate'.$rows->id.'" >
            <input type="hidden" id="serial'.$rows->id.'" value="0" >
               <input type="hidden" id="AV'.$rows->id.'" value="0" >
          <input type="hidden"  id="HighDisc'.$rows->id.'" value="'.$Higher.'">
          <input type="hidden"  id="AdditionsCount'.$rows->id.'" value="'.$AdditionsCount.'">
          <input type="hidden" id="CostPrice'.$rows->id.'"  value="'.$COSTpr.'" >
                 <input type="hidden" id="weight'.$rows->id.'"  value="" >
             <input type="hidden" id="maxSales'.$rows->id.'"  value="" >
         <input type="hidden" id="UnitDefault' . $rows->id . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $rows->id. '" value="' . $rr->Barcode . '">
         <input type="hidden" id="StoreDefault' . $rows->id. '" value="' . $store . '">
              <input type="hidden" id="UnitRato'.$rows->id.'"  value="'.$rr->Rate.'" >
             <input type="hidden" class="form-control" id="SalesProDesc' . $rows->id . '">
                                         </div>
                                    </div>


            ';
                            }
                        }

                    }



                }
            }else
            {
                $output = '
        <div class="col-md-12">'.trans('admin.No_Data_Find').'</div>
       ';
            }

            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    function NoteProsFilter(Request $request)
    {


        if($request->ajax())
        {
            $output = '';
            $r=request('r');
            $ProNote=ProNote::all();

            $total_row = $ProNote->count();
            if($total_row > 0)
            {

                foreach($ProNote as $note){

                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$note->Arabic_Name;
                    }else{
                        $PrrroName=$note->English_Name;
                    }



                    $output .= '<div class="col-md-4"  onclick="AddNoteToInp('.$r.','.$note->id.')">
       <div class="item-details">


               <p>'.$PrrroName.'</p>
               <input type="hidden" id="NoteTo'.$note->id.'" value="'.$PrrroName.'">
           </div>
           </div>';
                }

            }else
            {
                $output = '
        <div class="col-md-12">'.trans('admin.No_Data_Find').'</div>
       ';
            }

            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


    public function AddNewNoteAjax(Request $request){


        $Arabic_Name = $request->get('arName');
        $English_Name = $request->get('enName');



        $PRODUCTSS['Arabic_Name']=$Arabic_Name;
        $PRODUCTSS['English_Name']=$English_Name;



        ProNote::create($PRODUCTSS);


        $states=['SUCEESS'=>'SUCEESS'];
        return response()->json($states);

    }


    function CheckEmailPasstoDelete(Request $request)
    {
        if($request->ajax())
        {
            $Email = $request->get('email');
            $Pass = $request->get('pass');
            $ProID = $request->get('ProID');

            $admin=Admin::where('email',$Email)->first();

            if(!empty($admin)){

                if (Hash::check($Pass, $admin->password)) {

                    $result=1;


                    $Pro=ProductSalesOrder::find($ProID);


                    $uuu['Product_Code']=$Pro->Product_Code;
                    $uuu['P_Ar_Name']=$Pro->P_Ar_Name;
                    $uuu['P_En_Name']=$Pro->P_En_Name;
                    $uuu['V_Name']=$Pro->V_Name;
                    $uuu['VV_Name']=$Pro->VV_Name;
                    $uuu['Qty']=$Pro->Qty;
                    $uuu['AvQty']=$Pro->AvQty;
                    $uuu['Price']=$Pro->Price;
                    $uuu['Discount']=$Pro->Discount;
                    $uuu['Tax']=$Pro->Tax;
                    $uuu['Total_Bf_Tax']=$Pro->Total_Bf_Tax;
                    $uuu['Total_Tax']=$Pro->Total_Tax;
                    $uuu['Total']=$Pro->Total;
                    $uuu['Store']=$Pro->Store;
                    $uuu['Product']=$Pro->Product;
                    $uuu['Unit']=$Pro->Unit;
                    $uuu['Exp_Date']=$Pro->Exp_Date;
                    $uuu['SalesOrder']=$Pro->SalesOrder;
                    $uuu['V1']=$Pro->V1;
                    $uuu['V2']=$Pro->V2;
                    $uuu['SubVID']=$Pro->SubVID;
                    $uuu['Pro_Note']=$Pro->Pro_Note;
                    $uuu['KitchenEnd']=0;
                    RemoveProductsHall::create($uuu);


                    ProductSalesOrder::where('id',$ProID)->delete();



                }else{

                    $result=0;
                }


            }else{

                $result=0;

            }


            $data = array(
                'result'  => $result,
            );
            echo json_encode($data);
        }
    }

// ===  Virable Aggerate Avalible Qty ========
    function AVFilter(Request $request,Average $average)
    {


        if($request->ajax())
        {
            $output = '';
            $r=request('r');
            $pro=request('pro');
            $store=request('store');

            $ProNote=VAPrice::where('Product',$pro)->get();

            $total_row = $ProNote->count();
            if($total_row > 0)
            {



                foreach($ProNote as $pro){

                    $Available=0;
                    $COSTpr=0;
                    $yes=0;
                    $kmya=0;

                    $rr=ProductUnits::where('Product',$pro->Product)->where('Def',1)->first();
                    $AdditionsCount=AdditionalProducts::where('Product',$pro->Product)->count();
                    $st=Stores::find($store);
                    if(app()->getLocale() == 'ar' ){
                        $PrrroName=$pro->Product()->first()->P_Ar_Name;
                        $PrrroNameV=$pro->SubV()->first()->Name;
                        $UniiName=$rr->Unit()->first()->Name;
                    }else{
                        $PrrroName=$pro->Product()->first()->P_En_Name;
                        $PrrroNameV=$pro->SubV()->first()->NameEn;
                        $UniiName=$rr->Unit()->first()->NameEn;
                    }

                    $QTYs=VAQty::
                    where('Product',$pro->Product)
                        ->where('SubV',$pro->SubV)
                        ->get();


                    foreach($QTYs as $qty){

                        $AvQty=$this->ProAvQties($store,$qty->ProductID,$qty->VAProductID()->first()->Product_Code);
                        $QTYsSum=VAQty::
                        where('Product',$pro->Product)
                        ->where('ProductID',$qty->ProductID)
                            ->where('SubV',$qty->SubV)
                            ->get()->sum('Qty');

                        if($AvQty->Qty < $QTYsSum){

                            $Available +=0;
                            $yes +=1;
                            $kmya =0;
                        }else{

                            $Available +=$AvQty->Qty/$QTYsSum;

                            $AvailableTwo =$AvQty->Qty/$QTYsSum;

                            if($kmya == null) {
                                $kmya = $AvailableTwo;
                            }else{
                                if($kmya > $AvailableTwo) {

                                    $kmya=$AvailableTwo;
                                }

                            }

                            $yes +=0;
                        }


                        $rr=ProductUnits::where('Product',$qty->ProductID)->where('Def',1)->first();
                        $COSTpr +=$average->AverageCostGetUnit($qty->ProductID,$rr->Barcode,$store,$rr->Unit) * $qty->Qty;
                    }



                    if($yes == 0){



                        $output .= '<div class="col-md-12" onclick="AddAV('.$pro->id.')"  >
       <div class="item-details row">

 <div class="col-md-4">'.trans('admin.Name').' : '.$PrrroName.'</div>
 <div class="col-md-4">'.trans('admin.Virable').' : '.$PrrroNameV.'</div>
 <div class="col-md-4">'.trans('admin.Price').' : '.$pro->Price.'</div>

      <input type="hidden"  id="Row'.$pro->id.'">
         <input type="hidden"  id="SubVID'.$pro->id.'" value="'.$pro->SubV.'">
         <input type="hidden"  id="SubV'.$pro->id.'" value="'.$PrrroNameV.'">
         <input type="hidden"  id="P_Ar_Name'.$pro->id.'" value="'.$pro->Product()->first()->P_Ar_Name.'">
        <input type="hidden"  id="P_En_Name'.$pro->id.'" value="'.$pro->Product()->first()->P_En_Name.'">
        <input type="hidden"  id="Product'.$pro->id.'" value="'.$pro->Product.'">
        <input type="hidden"  id="VOne'.$pro->id.'" value="">
        <input type="hidden"  id="VTwo'.$pro->id.'" value="">
        <input type="hidden"  id="V_Name'.$pro->id.'" value="">
        <input type="hidden"  id="VV_Name'.$pro->id.'" value="">
        <input type="hidden" id="CodePurch'.$pro->id.'" class="form-control" value="'.$rr->Barcode.'"  disabled>
        <input type="hidden" id="UnitPurchName'.$pro->id.'" value="'.$UniiName.'">
        <input type="hidden" id="UnitPurch'.$pro->id.'" value="'.$rr->Unit.'">
        <input type="hidden" id="TaxRate'.$pro->id.'" value="'.$pro->Product()->first()->Tax()->first()->Rate.'">
        <input type="hidden" id="TaxType'.$pro->id.'" value="'.$pro->Product()->first()->Tax()->first()->Type.'">
        <input type="hidden" id="PurchTax'.$pro->id.'" value="'.$pro->Product()->first()->Tax.'">
         <input type="hidden"  id="AvQty'.$pro->id.'" value="'.$kmya.'">

         <input type="hidden"  id="Qty'.$pro->id.'" value="1">
         <input type="hidden"  id="Price'.$pro->id.'" value="'.$pro->Price.'">
         <input type="hidden"  id="Discount'.$pro->id.'" value="0">
                   <input type="hidden" id="TDiscPro'.$pro->id.'"   class="form-control" value="0" >
         <input type="hidden" id="TotalBFTax'.$pro->id.'"  value="'.$pro->Price.'" >
         <input type="hidden" id="Tax'.$pro->id.'"   value="0" >
         <input type="hidden" id="Total'.$pro->id.'"   value="'.$pro->Price.'" >
        <input type="hidden" id="StorePurchName'.$pro->id.'"  value="'.$st->id.'" >
        <input type="hidden" id="ExpDate'.$pro->id.'" >
            <input type="hidden" id="serial'.$pro->id.'" value="0" >
               <input type="hidden" id="AV'.$pro->id.'" value="0" >
          <input type="hidden"  id="HighDisc'.$pro->id.'" value="0">
          <input type="hidden"  id="AdditionsCount'.$pro->id.'" value="'.$AdditionsCount.'">
          <input type="hidden" id="CostPrice'.$pro->id.'"  value="'.$COSTpr.'" >

';


                    }

                    $output .= '
           </div>
           </div>';
                }

            }else
            {
                $output = '
        <div class="col-md-12">'.trans('admin.No_Data_Find').'</div>
       ';
            }

            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    function CheckQtyAVFilter(Request $request)
    {


        if($request->ajax())
        {
            $product = $request->get('product');
            $proCode = $request->get('proCode');
            $store = $request->get('store');
            $RequiredQty = $request->get('Qty');
            $OldQty = $request->get('OldQty');
            $SubVVID = $request->get('SubVVID');

            $QTYs=VAQty::
            where('Product',$product)
                ->where('SubV',$SubVVID)
                ->get();

            $Available=0;
            $yes=0;
            $kmya=null;
            foreach($QTYs as $qty){

                $AvQty=$this->ProAvQties($store,$qty->ProductID,$qty->VAProductID()->first()->Product_Code);
                $QTYsSum=VAQty::
                where('Product',$qty->Product)
                    ->where('ProductID',$qty->ProductID)
                    ->where('SubV',$qty->SubV)
                    ->get()->sum('Qty');

                if($AvQty->Qty < ($QTYsSum * $RequiredQty)){

                    $Available +=0;
                    $yes +=1;
                    $kmya =0;
                }else{

                    $Available +=$AvQty->Qty/($QTYsSum * $RequiredQty);

                    $AvailableTwo =$AvQty->Qty/($QTYsSum * $RequiredQty);

                    if($kmya == null) {
                        $kmya = $AvailableTwo;
                    }else{
                        if($kmya > $AvailableTwo) {

                            $kmya=$AvailableTwo;
                        }

                    }

                    $yes +=0;
                }


            }



            if($yes == 0){

                $result=1;
            }else{
                $result=0;

            }



            $data = array(
                'value'  => $result,
            );
            echo json_encode($data);
        }
    }



    //Mlaghy  da khas blw f sanfen tagne3y mt6gher y7mlo nfs sanf fbys2l 3n el kmya f el etnen  w tab3n m3dla hna ghalt
    function NewAddAVFilter(Request $request)
    {


        if($request->ajax())
        {
            $product = $request->get('Product');
            $Qty = $request->get('Qty');
            $SubVVID = $request->get('SubVID');
            $store = $request->get('store');

            $QTYs=VAQty::
            where('Product',$product)
                ->where('SubV',$SubVVID)
                ->get();



            foreach($QTYs as $qty){


                $AvQty=$this->ProAvQties($store,$qty->ProductID,$qty->VAProductID()->first()->Product_Code);
                $AVA=AVProCheckQty::where('Product',$qty->ProductID)->first();

                if(empty($AVA)){


                    $data['Product']=$qty->ProductID;
                    $data['AvQty']=$AvQty->Qty;
                    $data['Qty']=$Qty;
                    $data['RequestQty']=$qty->Qty;
                    $data['OriginalProduct']=$qty->Product;
                    $data['NewRequestQty']=$qty->Qty;
                    AVProCheckQty::create($data);


                }else{

                    if($AVA->OriginalProduct != $qty->Product){

                        $data['Product']=$qty->ProductID;
                        $data['AvQty']=$AvQty->Qty;
                        $data['Qty']=$Qty;
                        $data['RequestQty']=$qty->Qty;
                        $data['OriginalProduct']=$qty->Product;
                        $data['NewRequestQty']=$qty->Qty;
                        AVProCheckQty::create($data);


                    }else{

                        $data['Qty']=$Qty;
                        $data['NewRequestQty']=$Qty * $AVA->RequestQty;
                        AVProCheckQty::where('id',$AVA->id)->update($data);
                    }
                }

            }

        }

        echo json_encode($store);
    }


    function DeleteCheckQtyAVFilter(Request $request)
    {


        if($request->ajax())
        {
            $product = $request->get('product');
            $proCode = $request->get('proCode');
            $store = $request->get('store');
            $Qty = $request->get('Qty');
            $OldQty = $request->get('OldQty');
            $SubVVID = $request->get('SubVVID');


            AVProCheckQty::where('OriginalProduct',$product)->delete();


            $data="SUCCESS";
            echo json_encode($data);
        }
    }

//==================================================================

    //ResturantSales
    public function ResturantSales(){

        $Default=CompanyData::orderBy('id','desc')->first();
        $Employess = Employess::where('Emp_Type','Saller')->type()->lazy();
        $Code=$this->ReturnCode(Sales::class);
        $CodeUser=$this->ReturnCode(Customers::class);
        $SHIFTCODE=$this->ReturnCode(Shifts::class);
        $HoldCode=$this->ReturnCode(SalesOrder::class);
        $HoldSales=SalesOrder::resturantholdtype()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Banks = AcccountingManual::where('Type',1)->where('Parent',29)->lazy();
        $Resturant=1;
        $TAXESS=Taxes::all();
        $Taxes=Taxes::all();
        $InstallmentCompanies=InstallmentCompanies::all();
        $ChecksTypes=ChecksTypes::all();
        $Brands=Brands::all();
        $Governrates=Governrate::all();
        $ItemsGroups=ItemsGroups::all();
        $shift=Shifts::orderBy('id','desc')->where('Emp',auth()->guard('admin')->user()->emp)->first();
        $Def=SalesDefaultData::orderBy('id','desc')->first();
        if(auth()->guard('admin')->user()->pos_stores == 0){
            $Stores=Stores::type()->get();
        }else{
            $Stores=EmpPOSStores::where('Emp',auth()->guard('admin')->user()->emp)->get();
        }
        $Deliveries = Employess::where('Emp_Type','Delivery')->type()->lazy();
        $Waiters = Employess::where('Emp_Type','Waiter')->type()->lazy();

        if(empty($shift)){
            return view('admin.Sales.OpenShift',get_defined_vars());
        }elseif($shift->Close == 1){
            return view('admin.Sales.OpenShift',get_defined_vars());
        }else{
            AVProCheckQty::truncate();
            return view('admin.Resturant.ResturantSales',get_defined_vars());
        }


    }

    public function ResturantSalesSechdule(){

        $items=Sales::latest('id')->where('Status',1)->where('Sale_Type','Resturant')
            ->type()->where('Payment_Method','!=','Delivery')->paginate(10);
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Employess = Employess::type()->delegate()->get();
        $Clients = AcccountingManual::where('Type',1)->accountsalestype()->lazy();
        $Users = Admin::all();


        return view('admin.Resturant.ResturantSalesSechdule',get_defined_vars());
    }

    public function ResturantSalesHoldSechdule(){

        $items=SalesOrder::latest('id')
            ->where('Order_Type','Resturant')
            ->where('ToSales','!=',1)->type()->where('Payment_Method','!=','Delivery')->where('Hold',1)->paginate(10);
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Stores=Stores::type()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Employess = Employess::type()->delegate()->get();
        $Clients = AcccountingManual::where('Type',1)->accountsalestype()->lazy();
        $Users = Admin::all();
        return view('admin.Resturant.ResturantSalesHoldSechdule',get_defined_vars());
    }

    public function PostResturantOrder(SalesRequest $request,SalesService $service){

        try {
            DB::beginTransaction();

            $validated = $request->validated();



            if(request('Hold') == 0){


                $Sale_Type='Resturant';

                //Service Create New Bill
                $ID=$service->CreateNewSalesBill($request->all(),$Sale_Type);


                //Event New Bill


                $result=SalesEvent::dispatch($request->all(),$ID,$Sale_Type);


                if($result[0] == 5){
                    DB::rollBack();
                    session()->flash('error',trans('admin.Not_Enough_Qty'));
                    return back();
                }




                $dataUser=[
                    'screen_ar'=>'المبيعات',
                    'screen_en'=>'Sales',
                    'explain_ar'=>request('Code'),
                    'explain_en'=>request('Code'),
                ];
                $this->UserCreateMoves($dataUser);

                DB::commit();

                session()->flash('success',trans('admin.Added_Successfully'));

                if(request('SP') == 0){
                    return back();
                }elseif(request('SP') == 1){
                    return redirect('SalesPrint/'.$ID);
                }elseif(request('SP') == 2){
                    return redirect('SalesPrint8/'.$ID);
                }

            }else{


                $Sale_Type='Resturant';


                $ID=$service->CreateNewSalesOrder($request->all(),$Sale_Type);

                //Event New Bill

                $result=SalesOrderEvent::dispatch($request->all(),$ID,$Sale_Type);


                if($result[0] == 5){
                    DB::rollBack();
                    session()->flash('error',trans('admin.Not_Enough_Qty'));
                    return back();
                }



                $dataUser=[
                    'screen_ar'=>'امر بيع',
                    'screen_en'=>'Sales Order',
                    'explain_ar'=>request('Code_Order'),
                    'explain_en'=>request('Code_Order'),
                ];
                $this->UserCreateMoves($dataUser);


                DB::commit();
                session()->flash('success',trans('admin.Added_Successfully'));

                if(request('SP') == 0){
                    return back(); }elseif(request('SP') == 1){
                    return redirect('SalesOrderPrint/'.$ID);
                }elseif(request('SP') == 2){
                    return redirect('SalesOrderPrint/'.$ID);
                }

            }




        }catch(\Exception $ex){

            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }



    }


    //HoldSaleHall
    public function HoldSaleHall(){

        $Default=CompanyData::orderBy('id','desc')->first();
        $Employess = Employess::where('Emp_Type','Saller')->type()->lazy();
        $Code=$this->ReturnCode(Sales::class);
        $CodeUser=$this->ReturnCode(Customers::class);
        $SHIFTCODE=$this->ReturnCode(Shifts::class);
        $HoldCode=$this->ReturnCode(SalesOrder::class);
        $HoldSales=SalesOrder::resturantholdtype()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Banks = AcccountingManual::where('Type',1)->where('Parent',29)->lazy();
        $Resturant=1;
        $TAXESS=Taxes::all();
        $Taxes=Taxes::all();
        $InstallmentCompanies=InstallmentCompanies::all();
        $ChecksTypes=ChecksTypes::all();
        $Brands=Brands::all();
        $Governrates=Governrate::all();
        $ItemsGroups=ItemsGroups::all();
        $shift=Shifts::orderBy('id','desc')->where('Emp',auth()->guard('admin')->user()->emp)->first();
        $Def=SalesDefaultData::orderBy('id','desc')->first();
        if(auth()->guard('admin')->user()->pos_stores == 0){
            $Stores=Stores::type()->get();
        }else{
            $Stores=EmpPOSStores::where('Emp',auth()->guard('admin')->user()->emp)->get();
        }
        $Deliveries = Employess::where('Emp_Type','Delivery')->type()->lazy();
        $Waiters = Employess::where('Emp_Type','Waiter')->type()->lazy();

        if(empty($shift)){

            return view('admin.Sales.OpenShift',get_defined_vars());


        }elseif($shift->Close == 1){
            return view('admin.Sales.OpenShift',get_defined_vars());
        }else{


            $item=SalesOrder::find(request('OrderID'));
            $details=ProductSalesOrder::where('SalesOrder',$item->id)->get();


            return view('admin.Resturant.HoldSaleHall',get_defined_vars());




        }


    }

    public function PostResturantHoldHall(SalesRequest $request,SalesService $service){

        try {
            DB::beginTransaction();

            $validated = $request->validated();

            if(request('Payment_Method') == 'Cash'){

            if(!empty(request('Pay'))){

                $paid = request('Pay') ;

            }else{

                $paid = request('Total_Price') ;
            }



        }elseif(request('Payment_Method') == 'Later'){

            $paid = request('Pay') ;

        }elseif(request('Payment_Method') == 'Installment'){

            $paid = request('Pay') ;

        }elseif(request('Payment_Method') == 'Check'){

            $paid = request('Total_Price') ;

        }elseif(request('Payment_Method') == 'Cash_Visa'){

            $paid = request('Total_Price') ;

        }elseif(request('Payment_Method') == 'Cash_Collection'){

            $paid = request('Cash_Collection') ;

        }elseif(request('Payment_Method') == 'Delivery'){

            $paid = request('Pay') ;

        }elseif(request('Payment_Method') == 'InstallmentCompanies'){

            $paid = request('Total_Price') ;

        }



        if(request('Payment_Method') == 'Later'){
            $col=0;
        }else{
            $col=1;
        }

        $ID=request('ID');


        $data['Draw'] = request('Draw');
        $data['Payment_Method'] = request('Payment_Method');
        $data['Status'] = request('Status');
        $data['Refernce_Number'] = request('Refernce_Number');
        $data['Note'] = request('Note');
        $data['Product_Numbers'] = request('Product_Numbers');
        $data['Total_Qty'] = request('Total_Qty');
        $data['Total_Discount'] = request('Total_Discount') + request('DiscountBill');
        $data['Total_BF_Taxes'] = request('Total_BF_Taxes');
        $data['Total_Taxes'] = request('Total_Taxes');
        $data['Total_Price'] = request('Total_Price');
        $data['DiscountBill'] = request('DiscountBill');
        $data['Pay'] = $paid;
        $data['Safe'] = request('Safe');
        $data['ToSales'] = 0;
        $data['Client'] = request('Client');
        $data['Delegate'] = request('Delegate');
        $data['Executor'] = request('Executor');
        $data['Store'] = request('Store');
        $data['Coin'] = request('Coin');
        $data['Cost_Center'] = null;
        $data['presenter'] = request('presenter');
        $data['annual_interest'] = request('annual_interest');
        $data['monthly_installment'] = request('monthly_installment');
        $data['Years_Number'] = request('Years_Number');
        $data['total'] = request('total');
        $data['Order_Type'] = 'Resturant';
        $data['Witer'] = request('Waiter');
        $data['ResturantOrderType'] = request('ResturantOrderType');
        $data['Table'] = request('Table');
        $data['Quote'] = null;
        $data['Hold'] = 1;
        $data['installment_Num'] = request('installment_Num');
        $data['Date_First_installment'] = request('Date_First_installment');
        $data['User'] = auth()->guard('admin')->user()->id;

        SalesOrder::where('id',$ID)->update($data);

        $Code=request('Code');



        if(!empty(request('Unit'))){

            ProductSalesOrder::where('SalesOrder',$ID)->delete();


            $P_Ar_Name=request('P_Ar_Name');
            $P_En_Name=request('P_En_Name');
            $Unit=request('Unit');
            $P_Code=request('P_Code');
            $Qty=request('Qty');
            $AvQty=request('AvQty');
            $Price=request('Price');
            $Discount=request('Discount');
            $TotalBFTax=request('TotalBFTax');
            $TotalTax=request('TotalTax');
            $PurchTax=request('PurchTax');
            $Total=request('Total');
            $StorePurch=request('StorePurch');
            $Exp_Date=request('Exp_Date');
            $Product=request('Product');
            $VOne=request('VOne');
            $VTwo=request('VTwo');
            $V_Name=request('V_Name');
            $VV_Name=request('VV_Name');
            $Exp_Date=request('Exp_Date');
            $TDiscount=request('TDiscPro');
            $Pro_Note=request('Pro_Note');
            $SubVID=request('SubVID');
            $MorePro=request('MorePro');
            $CostPrice=request('CostPrice');
            $TotCostNew=request('TotCostNew');
            $Total_Net=request('Total_Net');

            for($i=0 ; $i < count($Unit) ; $i++){


                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['V_Name']=$V_Name[$i];
                $uu['VV_Name']=$VV_Name[$i];
                $uu['Original_Qty']=$Qty[$i];
                $uu['Qty']=$Qty[$i];
                $uu['AvQty']=$AvQty[$i];
                $uu['Price']=$Price[$i];
                $uu['Discount']=$Discount[$i];
                $uu['Tax']=$PurchTax[$i];
                $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                $uu['Total_Tax']=$TotalTax[$i];
                $uu['Total']=$Total[$i];
                $uu['Store']=$StorePurch[$i];
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['Exp_Date']=$Exp_Date[$i];
                $uu['SalesOrder']=$ID;
                $uu['V1']=$VOne[$i];
                $uu['V2']=$VTwo[$i];
                $uu['SubVID']=$SubVID[$i];
                $uu['TDiscount']=$TDiscount[$i];
                $uu['Pro_Note']=$Pro_Note[$i];
                $uu['CostPrice']=$CostPrice[$i];
                $uu['TotCostNew']=$TotCostNew[$i];
                $uu['Total_Net']=$Total_Net[$i];
                ProductSalesOrder::create($uu);


                if($MorePro[$i] == 1){

                    $uuu['Product_Code']=$P_Code[$i];
                    $uuu['P_Ar_Name']=$P_Ar_Name[$i];
                    $uuu['P_En_Name']=$P_En_Name[$i];
                    $uuu['V_Name']=$V_Name[$i];
                    $uuu['VV_Name']=$VV_Name[$i];
                    $uuu['Qty']=$Qty[$i];
                    $uuu['AvQty']=$AvQty[$i];
                    $uuu['Price']=$Price[$i];
                    $uuu['Discount']=$Discount[$i];
                    $uuu['Tax']=$PurchTax[$i];
                    $uuu['Total_Bf_Tax']=$TotalBFTax[$i];
                    $uuu['Total_Tax']=$TotalTax[$i];
                    $uuu['Total']=$Total[$i];
                    $uuu['Store']=$StorePurch[$i];
                    $uuu['Product']=$Product[$i];
                    $uuu['Unit']=$Unit[$i];
                    $uuu['Exp_Date']=$Exp_Date[$i];
                    $uuu['SalesOrder']=$ID;
                    $uuu['V1']=$VOne[$i];
                    $uuu['V2']=$VTwo[$i];
                    $uuu['SubVID']=$SubVID[$i];
                    $uuu['Pro_Note']=$Pro_Note[$i];
                    $uuu['KitchenEnd']=0;
                    MoreProductsHall::create($uuu);

                }




            }


        }

            $dataUser=[
                'screen_ar'=>'امر بيع',
                'screen_en'=>'Sales Order',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));

        if(request('SP') == 0){  return redirect('ResturantSales'); }elseif(request('SP') == 1){  return redirect('SalesOrderPrint/'.$ID); }elseif(request('SP') == 2){  return redirect('SalesOrderPrint/'.$ID); }

        }catch(\Exception $ex){

            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }



    }


    //HoldSaleResturant
    public function HoldSaleResturant(){

        $Default=CompanyData::orderBy('id','desc')->first();
        $Employess = Employess::where('Emp_Type','Saller')->type()->lazy();
        $Code=$this->ReturnCode(Sales::class);
        $CodeUser=$this->ReturnCode(Customers::class);
        $SHIFTCODE=$this->ReturnCode(Shifts::class);
        $HoldCode=$this->ReturnCode(SalesOrder::class);
        $HoldSales=SalesOrder::resturantholdtype()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Banks = AcccountingManual::where('Type',1)->where('Parent',29)->lazy();
        $Resturant=1;
        $TAXESS=Taxes::all();
        $Taxes=Taxes::all();
        $InstallmentCompanies=InstallmentCompanies::all();
        $ChecksTypes=ChecksTypes::all();
        $Brands=Brands::all();
        $Governrates=Governrate::all();
        $ItemsGroups=ItemsGroups::all();
        $shift=Shifts::orderBy('id','desc')->where('Emp',auth()->guard('admin')->user()->emp)->first();
        $Def=SalesDefaultData::orderBy('id','desc')->first();
        if(auth()->guard('admin')->user()->pos_stores == 0){
            $Stores=Stores::type()->get();
        }else{
            $Stores=EmpPOSStores::where('Emp',auth()->guard('admin')->user()->emp)->get();
        }
        $Deliveries = Employess::where('Emp_Type','Delivery')->type()->lazy();
        $Waiters = Employess::where('Emp_Type','Waiter')->type()->lazy();



        if(empty($shift)){

            return view('admin.Sales.OpenShift',get_defined_vars());


        }elseif($shift->Close == 1){
            return view('admin.Sales.OpenShift',get_defined_vars());
        }else{



            $item=SalesOrder::find(request('OrderID'));
            $details=ProductSalesOrder::where('SalesOrder',$item->id)->get();
            return view('admin.Resturant.HoldSaleResturant',get_defined_vars());




        }


    }

    public function PostResturantHold(SalesRequest $request,SalesService $service){


        try {
            DB::beginTransaction();

            $validated = $request->validated();


            $id=request('ID');

            if(request('Hold') == 0){


                $Sale_Type='Resturant';

                //Service Create New Bill
                $ID=$service->CreateNewSalesBill($request->all(),$Sale_Type);


                //Event New Bill
                $result=SalesEvent::dispatch($request->all(),$ID,$Sale_Type);


                if($result[0] == 5){
                    DB::rollBack();
                    session()->flash('error',trans('admin.Not_Enough_Qty'));
                    return back();
                }




                $dataUser=[
                    'screen_ar'=>'المبيعات',
                    'screen_en'=>'Sales',
                    'explain_ar'=>request('Code'),
                    'explain_en'=>request('Code'),
                ];
                $this->UserCreateMoves($dataUser);


                SalesOrder::where('id',request("ID"))->update(['ToSales'=>1,'Hold'=>0]);
                DB::commit();

                session()->flash('success',trans('admin.Added_Successfully'));

                if(request('SP') == 0){
                    return redirect('POS');
                }elseif(request('SP') == 1){
                    return redirect('SalesPrint/'.$ID);
                }elseif(request('SP') == 2){
                    return redirect('SalesPrint8/'.$ID);
                }

            }else{


                $del=SalesOrder::find($id);

                SalesOrder::where('id',$id)->update(['Edit'=>1,'Edit_New_Code'=>request('Code_Order')]);
                Event::where('Type_Code',$del->Code)->where('Type','امر البيع')->delete();
                Notifications::where('Type_Code',$del->Code)->where('Type','امر بيع')->delete();

                if($del->Hold_Qty == 1){


                    $service->RemoveHoldQties($id);


                }

                $Sale_Type='Resturant';


                $ID=$service->CreateNewSalesOrder($request->all(),$Sale_Type);

                //Event New Bill

                $result=SalesOrderEvent::dispatch($request->all(),$ID,$Sale_Type);


                if($result[0] == 5){
                    DB::rollBack();
                    session()->flash('error',trans('admin.Not_Enough_Qty'));
                    return back();
                }




                $dataUser=[
                    'screen_ar'=>'امر بيع',
                    'screen_en'=>'Sales Order',
                    'explain_ar'=>request('Code_Order'),
                    'explain_en'=>request('Code_Order'),
                ];
                $this->UserCreateMoves($dataUser);


                DB::commit();
                session()->flash('success',trans('admin.Added_Successfully'));

                if(request('SP') == 0){
                    return redirect('ResturantSales');
                }elseif(request('SP') == 1){
                    return redirect('SalesOrderPrint/'.$ID);
                }elseif(request('SP') == 2){
                    return redirect('SalesOrderPrint/'.$ID);
                }



            }




        }catch(\Exception $ex){

            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }





    }


    //Edit Sales Resturant
    public function ESBillResturant($id){

        $Default=CompanyData::orderBy('id','desc')->first();
        $Employess = Employess::where('Emp_Type','Saller')->type()->lazy();
        $Code=$this->ReturnCode(Sales::class);
        $CodeUser=$this->ReturnCode(Customers::class);
        $SHIFTCODE=$this->ReturnCode(Shifts::class);
        $HoldCode=$this->ReturnCode(SalesOrder::class);
        $HoldSales=SalesOrder::resturantholdtype()->get();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Banks = AcccountingManual::where('Type',1)->where('Parent',29)->lazy();
        $Resturant=1;
        $TAXESS=Taxes::all();
        $Taxes=Taxes::all();
        $InstallmentCompanies=InstallmentCompanies::all();
        $ChecksTypes=ChecksTypes::all();
        $Brands=Brands::all();
        $Governrates=Governrate::all();
        $ItemsGroups=ItemsGroups::all();
        $shift=Shifts::orderBy('id','desc')->where('Emp',auth()->guard('admin')->user()->emp)->first();
        $Def=SalesDefaultData::orderBy('id','desc')->first();
        if(auth()->guard('admin')->user()->pos_stores == 0){
            $Stores=Stores::type()->get();
        }else{
            $Stores=EmpPOSStores::where('Emp',auth()->guard('admin')->user()->emp)->get();
        }
        $Deliveries = Employess::where('Emp_Type','Delivery')->type()->lazy();
        $Waiters = Employess::where('Emp_Type','Waiter')->type()->lazy();


        $item=Sales::find($id);
        $details=ProductSales::where('Sales',$item->id)->get();


            return view('admin.Resturant.ESBillResturant',get_defined_vars());

    }


    public function PostEditResturant(SalesRequest $request,SalesService $service){


        try {
            DB::beginTransaction();


            $id=request('ID');
            $del=Sales::find($id);
            Sales::where('id',$id)->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);

            $Returns=ReturnSales::where('Sales',$del->id)->get();
            if(!empty($Returns)){

                foreach($Returns as $return){
                    GeneralDaily::where('Code_Type',$return->Code)->where('Type','مرتجع مبيعات')->delete();
                    Journalizing::where('Code_Type',$return->Code)->where('Type','مرتجع مبيعات')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
                    StoresMoves::where('ID',$return->id)->where('Type','مرتجع مبيعات')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
                    ReturnPurch::where('id',$return->id)->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
                }
            }

            Notifications::where('Type_Code',$del->Code)->where('Type','المبيعات')->delete();
            Event::where('Type_Code',$del->Code)->where('Type','المبيعات')->delete();
            GeneralDaily::where('Code_Type',$del->Code)->where('Type','المبيعات')->delete();
            GeneralDaily::where('Code_Type',$del->Code)->where('Type','استحقاق عمولة')->delete();
            Journalizing::where('Code_Type',$del->Code)->where('Type','استحقاق عمولة')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
            Journalizing::where('Code_Type',$del->Code)->where('Type','المبيعات')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
            StoresMoves::where('ID',$del->id)->where('Type','مبيعات')->update(['Edit'=>1,'Edit_New_Code'=>request('Code')]);
            Installment::where('Sales',$del->id)->delete();


            //Service

            $service->RemoveQties($id,0,request('Code'));



            $Sale_Type='Resturant';

            //Service Create New Bill
            $ID=$service->CreateNewSalesBill($request->all(),$Sale_Type);



            //Event New Bill

            $result=SalesEvent::dispatch($request->all(),$ID,$Sale_Type);


            if($result[0] == 5){
                DB::rollBack();
                session()->flash('error',trans('admin.Not_Enough_Qty'));
                return back();
            }


            $dataUser=[
                'screen_ar'=>'المبيعات',
                'screen_en'=>'Sales',
                'explain_ar'=>request('Old_Code'),
                'explain_en'=>request('Old_Code'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return redirect('ResturantSalesSechdule');


        }catch(\Exception $ex){

            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }




    }



    public function DeleteSalesBillResturant($id,SalesService $service){


        try {
            DB::beginTransaction();

            $del=Sales::find($id);
            Sales::where('id',$id)->update(['Delete'=>1]);

            $Returns=ReturnSales::where('Sales',$del->id)->get();
            if(!empty($Returns)){

                foreach($Returns as $return){
                    GeneralDaily::where('Code_Type',$return->Code)->where('Type','مرتجع مبيعات')->delete();
                    Journalizing::where('Code_Type',$return->Code)->where('Type','مرتجع مبيعات')->update(['Delete'=>1]);
                    StoresMoves::where('ID',$return->id)->where('Type','مرتجع مبيعات')->update(['Delete'=>1]);
                    ReturnPurch::where('id',$return->id)->update(['Delete'=>1]);
                }
            }

            Notifications::where('Type_Code',$del->Code)->where('Type','المبيعات')->delete();
            Event::where('Type_Code',$del->Code)->where('Type','المبيعات')->delete();
            GeneralDaily::where('Code_Type',$del->Code)->where('Type','المبيعات')->delete();
            GeneralDaily::where('Code_Type',$del->Code)->where('Type','استحقاق عمولة')->delete();
            Journalizing::where('Code_Type',$del->Code)->where('Type','استحقاق عمولة')->update(['Delete'=>1]);
            Journalizing::where('Code_Type',$del->Code)->where('Type','المبيعات')->update(['Delete'=>1]);
            StoresMoves::where('ID',$del->id)->where('Type','مبيعات')->update(['Delete'=>1]);
            Installment::where('Sales',$del->id)->delete();


            //Service

            $service->RemoveQties($id,1,0);
            $service->RemoveShiftsTotal($id);


            $dataUser=[
                'screen_ar'=>'المبيعات',
                'screen_en'=>'Sales',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);


            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();



        }catch(\Exception $ex){

            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }




    }




    // ==================== Kitchen Screen ======
    public function KitchenScreen(){

        $Hall=SalesOrder::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Hall'])
            ->where('Status',1)
            ->where('KitchenEnd',0)
            ->where('RecivedOrder',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->count();

        $Delivery=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Delivery'])
            ->where('Status',1)
            ->where('KitchenEnd',0)
            ->where('RecivedOrder',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->count();


        $Takeaway=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Takeaway'])
            ->where('Status',1)
            ->where('KitchenEnd',0)
            ->where('RecivedOrder',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->count();


        $Halls=SalesOrder::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Hall'])
            ->where('Status',1)
            ->where('KitchenEnd',0)
            ->where('RecivedOrder',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->paginate(50);

        $HallsMore=MoreProductsHall::where('KitchenEnd',0)->distinct(['SalesOrder'])->get();
        $HallsRemove=RemoveProductsHall::where('KitchenEnd',0)->distinct(['SalesOrder'])->get();
        $HallsMoreCount=MoreProductsHall::distinct(['SalesOrder'])->where('KitchenEnd',0)->count();
        $HallsRemoveCount=RemoveProductsHall::distinct(['SalesOrder'])->where('KitchenEnd',0)->count();



        $Deliverys=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Delivery'])
            ->where('Status',1)
            ->where('KitchenEnd',0)
            ->where('RecivedOrder',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->paginate(50);


        $Takeaways=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Takeaway'])
            ->where('Status',1)
            ->where('KitchenEnd',0)
            ->where('RecivedOrder',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->paginate(50);

        return view('admin.Resturant.KitchenScreen',get_defined_vars());
    }

    public function EndKitchenOrder($id){

        try {
            DB::beginTransaction();

            Sales::where('id',$id)->update(['KitchenEnd'=>1,'KitchenEndTime'=>date("h:i:s a", time())]);

            DB::commit();
        session()->flash('sucess',trans('admin.Ended'));
        return back();
        }catch(\Exception $ex){

            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function PrintKitchen($id){

        $item=Sales::find($id);

        return view('admin.Resturant.PrintKitchen',[
            'item'=>$item,

        ]);
    }

    public function EndKitchenOrderHall($id){

        try {
            DB::beginTransaction();
        SalesOrder::where('id',$id)->update(['KitchenEnd'=>1,'KitchenEndTime'=>date("h:i:s a", time())]);

            DB::commit();
        session()->flash('sucess',trans('admin.Ended'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    public function PrintKitchenHall($id){

        $item=SalesOrder::find($id);

        return view('admin.Resturant.PrintKitchenHall',[
            'item'=>$item,

        ]);
    }

    public function EndKitchenOrderHallMore($id){

        try {
            DB::beginTransaction();

        MoreProductsHall::where('SalesOrder',$id)->update(['KitchenEnd'=>1]);
            DB::commit();
        session()->flash('sucess',trans('admin.Ended'));
        return back();

    }catch(\Exception $ex){

$MODEL=Sales::class;
DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
return back();

}catch(\Error $ex){


    $MODEL=Sales::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}

    }


    public function EndKitchenOrderHallRemove($id){

        try {
            DB::beginTransaction();
        RemoveProductsHall::where('SalesOrder',$id)->update(['KitchenEnd'=>1]);

            DB::commit();
        session()->flash('sucess',trans('admin.Ended'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    public function PrintKitchenHallMore($id){

        $item=MoreProductsHall::where('SalesOrder',$id)->distinct(['SalesOrder'])->first();

        return view('admin.Resturant.PrintKitchenHallMore',[
            'item'=>$item,

        ]);
    }


    public function PrintKitchenHallRemove($id){

        $item=RemoveProductsHall::where('SalesOrder',$id)->distinct(['SalesOrder'])->first();

        return view('admin.Resturant.PrintKitchenHallRemove',[
            'item'=>$item,

        ]);
    }



    // ============================ Recived Screen ======
    public function RecivedScreen(){

        $Hall=SalesOrder::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Hall'])
            ->where('Status',1)
            ->where('KitchenEnd',1)
            ->where('RecivedOrder',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->count();

        $Delivery=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Delivery'])
            ->where('Status',1)
            ->where('KitchenEnd',1)
            ->where('RecivedOrder',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->count();


        $Takeaway=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Takeaway'])
            ->where('Status',1)
            ->where('KitchenEnd',1)
            ->where('RecivedOrder',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->count();


        $Halls=SalesOrder::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Hall'])
            ->where('Status',1)
            ->where('KitchenEnd',1)
            ->where('RecivedOrder',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->paginate(50);

        $Deliverys=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Delivery'])
            ->where('Status',1)
            ->where('KitchenEnd',1)
            ->where('RecivedOrder',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->paginate(50);


        $Takeaways=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Takeaway'])
            ->where('Status',1)
            ->where('KitchenEnd',1)
            ->where('RecivedOrder',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->paginate(50);

        return view('admin.Resturant.RecivedScreen',[
            'Hall'=>$Hall,
            'Delivery'=>$Delivery,
            'Takeaway'=>$Takeaway,
            'Halls'=>$Halls,
            'Deliverys'=>$Deliverys,
            'Takeaways'=>$Takeaways,
        ]);
    }

    public function EndRecivedOrder($id){

        try {
            DB::beginTransaction();
        Sales::where('id',$id)->update(['RecivedOrder'=>1,'RecivedOrderTime'=>date("h:i:s a", time())]);

            DB::commit();
        session()->flash('sucess',trans('admin.Ended'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }


    public function PrintRecived($id){

        $item=Sales::find($id);

        return view('admin.Resturant.PrintRecived',[
            'item'=>$item,

        ]);
    }


    public function PrintRecivedHall($id){

        $item=SalesOrder::find($id);

        return view('admin.Resturant.PrintRecivedHall',[
            'item'=>$item,

        ]);
    }

    public function EndRecivedOrderHall($id){

        $Default=CompanyData::orderBy('id','desc')->first();
        $Employess = Employess::where('Emp_Type','Saller')->type()->lazy();
        $HoldSales=SalesOrder::resturantholdtype()->get();
        $TAXESS=Taxes::all();
        $Taxes=Taxes::all();
        $Code=$this->ReturnCode(Sales::class);
        $CodeUser=$this->ReturnCode(Customers::class);
        $ChecksTypes=ChecksTypes::all();
        $Brands=Brands::all();
        $Governrates=Governrate::all();
        $ItemsGroups=ItemsGroups::all();
        $shift=Shifts::orderBy('id','desc')->where('Emp',auth()->guard('admin')->user()->emp)->first();
        $SHIFTCODE=$this->ReturnCode(Shifts::class);
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Banks = AcccountingManual::where('Type',1)->where('Parent',29)->lazy();
        $Def=SalesDefaultData::orderBy('id','desc')->first();
        if(auth()->guard('admin')->user()->pos_stores == 0){
            $Stores=Stores::type()->get();
        }else{
            $Stores=EmpPOSStores::where('Emp',auth()->guard('admin')->user()->emp)->get();
        }
        $Deliveries = Employess::where('Emp_Type','Delivery')->type()->lazy();
        $Waiters = Employess::where('Emp_Type','Waiter')->type()->lazy();
        $HoldCode=$this->ReturnCode(SalesOrder::class);
        $InstallmentCompanies=InstallmentCompanies::all();
        $Resturant=1;
        $item=SalesOrder::find($id);
        $details=ProductSalesOrder::where('SalesOrder',$item->id)->get();

        if(empty($shift)){
            return view('admin.Sales.OpenShift',get_defined_vars());

        }elseif($shift->Close == 1){
            return view('admin.Sales.OpenShift',get_defined_vars());
        }else{

            return view('admin.Resturant.RecivedSaleResturantHall',get_defined_vars());

        }


    }

//PostEndRecivedOrderHall
    public function PostEndRecivedOrderHall(SalesRequest $request,SalesService $service){

        try {
            DB::beginTransaction();

            $validated = $request->validated();



            if(request('Hold') == 0){


                SalesOrder::where('id',request('ID'))->update(['RecivedOrder'=>1,'RecivedOrderTime'=>date("h:i:s a", time())]);
                $Or=SalesOrder::find(request('ID'));



                $Sale_Type='Resturant';

                //Service Create New Bill
                $ID=$service->CreateNewSalesBill($request->all(),$Sale_Type);


                //Event New Bill


                $result=SalesEvent::dispatch($request->all(),$ID,$Sale_Type);


                if($result[0] == 5){
                    DB::rollBack();
                    session()->flash('error',trans('admin.Not_Enough_Qty'));
                    return back();
                }




                $dataUser=[
                    'screen_ar'=>'المبيعات',
                    'screen_en'=>'Sales',
                    'explain_ar'=>request('Code'),
                    'explain_en'=>request('Code'),
                ];
                $this->UserCreateMoves($dataUser);

                DB::commit();

                session()->flash('success',trans('admin.Added_Successfully'));


                    if(request('SP') == 0){  return redirect('ResturantSales'); }elseif(request('SP') == 1){  return redirect('SalesPrintHall/'.$ID); }elseif(request('SP') == 2){  return redirect('SalesPrintHall8/'.$ID); }


            }





        }catch(\Exception $ex){

            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Sales::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }





    }

    public function SalesPrintHall($id){

        $item=Sales::find($id);

        return view('admin.Resturant.SalesPrintHall',[
            'item'=>$item,

        ]);
    }

    public function SalesPrintHall8($id){

        $item=Sales::find($id);

        return view('admin.Resturant.SalesPrintHall8',[
            'item'=>$item,

        ]);
    }


//================  View Admin    ========================================================================================================================

    //======  Webslider =======
    public function RWebSlider(){
        $items=ResturantSliders::all();
        return view('admin.Resturant.Webslider',['items'=>$items]);
    }

    public function AddRWebSlider(){

        $data= $this->validate(request(),[
            'Arabic_Title'=>'required',
            'Arabic_Desc'=>'required',
            'English_Desc'=>'required',
            'Image'=>'required|max:100000',
        ],[
            'Arabic_Title.required' => trans('admin.Arabic_TitleRequired'),
            'English_Title.required' => trans('admin.English_TitleRequired'),
            'Image.required' => trans('admin.ImageRequired'),

        ]);

        $image=request()->file('Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='WebsliderImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }


        $data['Image']=$image_url;
        $data['Arabic_Title']=request('Arabic_Title');
        $data['Type']=request('Type');
        $data['Status']=1;
        $data['Arabic_Desc']=request('Arabic_Desc');
        $data['English_Desc']=request('English_Desc');
        if(!empty(request('English_Title'))){
            $data['English_Title']=request('English_Title');
        }else{
            $data['English_Title']=request('Arabic_Title');
        }

        ResturantSliders::create($data);



        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

    }

    public function EditRWebSlider($id){

        $data= $this->validate(request(),[
            'Arabic_Title'=>'required',
            'Image'=>'sometimes|nullable|max:100000',
        ],[
            'Arabic_Title.required' => trans('admin.Arabic_TitleRequired'),
            'English_Title.required' => trans('admin.English_TitleRequired'),
            'Image.required' => trans('admin.ImageRequired'),

        ]);



        $image=request()->file('Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='WebsliderImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }

        if(!empty($image_url)){
            $data['Image']=$image_url;
        }else{

            $data['Image']=request('Images');
        }

        $data['Status']=request('Status');
        $data['Arabic_Desc']=request('Arabic_Desc');
        $data['English_Desc']=request('English_Desc');
        $data['Arabic_Title']=request('Arabic_Title');
        $data['Type']=request('Type');
        if(!empty(request('English_Title'))){
            $data['English_Title']=request('English_Title');
        }else{
            $data['English_Title']=request('Arabic_Title');
        }

        ResturantSliders::where('id',$id)->update($data);



        session()->flash('success',trans('admin.Updated'));
        return back();


    }

    public function DeleteRWebSlider($id){

        $del=ResturantSliders::find($id);



        $del->delete();
        session()->flash('error',trans('admin.Deleted'));
        return back();

    }

    public function UnActiveRSlider($id){

        ResturantSliders::where('id',$id)->update(['Status'=>0]);
        session()->flash('error',trans('admin.UnActived'));
        return back();

    }

    public function ActiveRSlider($id){

        ResturantSliders::where('id',$id)->update(['Status'=>1]);
        session()->flash('success',trans('admin.Actived'));
        return back();

    }


    // ==== Social Media ==
    public function RSocialMedia(){

        $item=ResturantSocial::orderBy('id','desc')->first();
        return view('admin.Resturant.SocialMedia',["item"=>$item]);

    }

    public function RSocialMediaUpdate($id){

        $data['Facebook'] = request('Facebook');
        $data['Twitter'] = request('Twitter');
        $data['Instagram'] = request('Instagram');
        $data['Youtube'] = request('Youtube');
        $data['Snapchat'] = request('Snapchat');
        $data['Whatsapp'] = request('Whatsapp');
        $data['Google_Plus'] = request('Google_Plus');
        $data['LinkedIn'] = request('LinkedIn');
        $data['Pinterest'] = request('Pinterest');
        $data['Telegram'] = request('Telegram');
        $data['iOS'] = request('iOS');
        $data['Android'] = request('Android');


        ResturantSocial::OrderBy('id','desc')->update($data);
        session()->flash('success',trans('admin.Updated'));
        return back();



    }

    //======  Articles =======
    public function RArticles(){
        $items=ResturantBlogs::all();
        return view('admin.Resturant.Articles',['items'=>$items]);
    }

    public function AddRArticles(){

        $data= $this->validate(request(),[
            'Sub_Image'=>'required',
            'Arabic_Title'=>'required',
            'English_Title'=>'required',
            'Arabic_Desc'=>'required',
            'English_Desc'=>'required',
            'Date'=>'required',
            'Image'=>'required|max:100000',
        ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
            'Arabic_Title.required' => trans('admin.Arabic_TitleRequired'),
            'English_Title.required' => trans('admin.English_TitleRequired'),
            'Image.required' => trans('admin.ImageRequired'),
            'Sub_Image.required' => trans('admin.ImageRequired'),

        ]);

        $image=request()->file('Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='ArticlesImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }

        $data['Image']=$image_url;


        $imagee=request()->file('Sub_Image');
        if($imagee){
            $image_namee=Str::random(20);
            $exte=strtolower($imagee->getClientOriginalExtension());
            $image_full_namee=$image_namee .'.' . $exte ;
            $upload_pathe='ArticlesImages/';
            $image_urle=$upload_pathe.$image_full_namee;
            $successe=$imagee->move($upload_pathe,$image_full_namee);
        }

        $data['Sub_Image']=$image_urle;
        $data['Arabic_Title']=request('Arabic_Title');
        $data['English_Title']=request('English_Title');
        $data['Arabic_Desc']=request('Arabic_Desc');
        $data['English_Desc']=request('English_Desc');
        $data['Date']=request('Date');


        ResturantBlogs::create($data);



        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

    }

    public function EditRArticles($id){

        $data= $this->validate(request(),[
            'Sub_Image'=>'sometimes|nullable|max:100000',
            'Arabic_Title'=>'required',
            'English_Title'=>'required',
            'Arabic_Desc'=>'required',
            'English_Desc'=>'required',
            'Date'=>'required',
            'Image'=>'sometimes|nullable|max:100000',
        ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
            'Arabic_Title.required' => trans('admin.Arabic_TitleRequired'),
            'English_Title.required' => trans('admin.English_TitleRequired'),
            'Image.required' => trans('admin.ImageRequired'),
            'Sub_Image.required' => trans('admin.ImageRequired'),

        ]);

        $image=request()->file('Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='WebsliderImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }

        if(!empty($image_url)){
            $data['Image']=$image_url;
        }else{

            $data['Image']=request('Images');
        }


        $imagee=request()->file('Sub_Image');
        if($imagee){
            $image_namee=Str::random(20);
            $exte=strtolower($imagee->getClientOriginalExtension());
            $image_full_namee=$image_namee .'.' . $exte ;
            $upload_pathe='ArticlesImages/';
            $image_urle=$upload_pathe.$image_full_namee;
            $successe=$imagee->move($upload_pathe,$image_full_namee);
        }

        if(!empty($image_urle)){
            $data['Sub_Image']=$image_urle;
        }else{

            $data['Sub_Image']=request('Sub_Images');
        }


        $data['Arabic_Title']=request('Arabic_Title');
        $data['English_Title']=request('English_Title');
        $data['Arabic_Desc']=request('Arabic_Desc');
        $data['English_Desc']=request('English_Desc');
        $data['Date']=request('Date');

        ResturantBlogs::where('id',$id)->update($data);




        session()->flash('success',trans('admin.Updated'));
        return back();


    }

    public function DeleteRArticles($id){

        $del=ResturantBlogs::find($id);



        $del->delete();
        session()->flash('error',trans('admin.Deleted'));
        return back();

    }

    //======   Terms =======
    public function RTerms(){
        $item=ResturantTerms::orderBy('id','desc')->first();
        return view('admin.Resturant.Terms',['item'=>$item]);
    }

    public function UpdateRTerms($id){

        $data= $this->validate(request(),[
            'Arabic_Desc'=>'required',
            'English_Desc'=>'required',
        ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
        ]);

        $data['Arabic_Desc']=request('Arabic_Desc');
        $data['English_Desc']=request('English_Desc');

        ResturantTerms::where('id',$id)->update($data);



        session()->flash('success',trans('admin.Updated'));
        return back();


    }


    //======   Polices =======
    public function RPolices(){
        $item=ResturantPrivacy::orderBy('id','desc')->first();
        return view('admin.Resturant.Polices',['item'=>$item]);
    }

    public function UpdateRPolices($id){

        $data= $this->validate(request(),[
            'Arabic_Desc'=>'required',
            'English_Desc'=>'required',
        ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
        ]);

        $data['Arabic_Desc']=request('Arabic_Desc');
        $data['English_Desc']=request('English_Desc');

        ResturantPrivacy::where('id',$id)->update($data);



        session()->flash('success',trans('admin.Updated'));
        return back();


    }



    //Coupon Code

    public function  RCouponCode(){
        $items=ResturantCuponCode::all();
        return view('admin.Resturant.CouponCode',["items"=>$items]);
    }

    public function AddRCouponCode(){

        $data= $this->validate(request(),[
            'Amount'=>'required',
            'Num'=>'required',
            'Expire'=>'required',
            'Code'=>'required|unique:coupon_codes',


        ],[
            'Code.required' =>trans('admin.CodeRequired'),
            'Amount.required' =>trans('admin.AmountRequired'),
            'Num.required' =>trans('admin.NumRequired'),
            'Expire.required' =>trans('admin.ExpireRequired'),

        ]);

        $data['Code']=request('Code');
        $data['Amount']=request('Amount');
        $data['Status']=0;
        $data['Used']=0;
        $data['Num']=request('Num');
        $data['Expire']=request('Expire');


        ResturantCuponCode::create($data);

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();
    }

    public function EditRCouponCode($id){
        $data= $this->validate(request(),[
            'Code'=>'required|unique:coupon_codes,Code,'.$id,
            'Amount'=>'required',
            'Num'=>'required',
            'Expire'=>'required',

        ],[
            'Code.required' =>trans('admin.CodeRequired'),
            'Amount.required' =>trans('admin.AmountRequired'),
            'Num.required' =>trans('admin.NumRequired'),
            'Expire.required' =>trans('admin.ExpireRequired'),

        ]);

        $data['Code']=request('Code');
        $data['Amount']=request('Amount');
        $data['Status']=request('Status');
        $data['Num']=request('Num');
        $data['Expire']=request('Expire');


        ResturantCuponCode::where('id',$id)->update($data);
        session()->flash('success',trans('admin.Updated'));
        return back();

    }

    public function DeleteRCouponCode($id){

        $del=ResturantCuponCode::find($id);
        $del->delete();
        session()->flash('error',trans('admin.Deleted'));
        return back();

    }


    //Gallery
    public function RGallery(){
        $items=ResturantGallery::paginate(20);
        return view('admin.Resturant.Gallery',['items'=>$items]);
    }

    public function AddRGallery(){

        $data= $this->validate(request(),[

            'Image'=>'required|max:100000',
        ],[

            'Image.required' => trans('admin.ImageRequired'),

        ]);

        $image=request()->file('Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='WebsliderImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }


        $data['Image']=$image_url;

        ResturantGallery::create($data);



        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

    }

    public function EditRGallery($id){

        $data= $this->validate(request(),[

            'Image'=>'sometimes|nullable|max:100000',
        ],[

            'Image.required' => trans('admin.ImageRequired'),

        ]);



        $image=request()->file('Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='WebsliderImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }

        if(!empty($image_url)){
            $data['Image']=$image_url;
        }else{

            $data['Image']=request('Images');
        }


        ResturantGallery::where('id',$id)->update($data);



        session()->flash('success',trans('admin.Updated'));
        return back();


    }

    public function DeleteRGallery($id){

        $del=ResturantGallery::find($id);



        $del->delete();
        session()->flash('error',trans('admin.Deleted'));
        return back();

    }



    //======  Reviews =======
    public function RReviews(){
        $items=ResturantReviews::paginate(20);
        return view('admin.Resturant.Reviews',['items'=>$items]);
    }

    public function AddRReviews(){

        $data= $this->validate(request(),[

            'Arabic_Name'=>'required',
            'English_Name'=>'required',
            'Arabic_Desc'=>'required',
            'English_Desc'=>'required',

            'Image'=>'required|max:100000',
        ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
            'Arabic_Name.required' => trans('admin.Arabic_TitleRequired'),
            'English_Name.required' => trans('admin.English_TitleRequired'),
            'Image.required' => trans('admin.ImageRequired'),



        ]);

        $image=request()->file('Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='ArticlesImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }

        $data['Image']=$image_url;



        $data['Arabic_Name']=request('Arabic_Name');
        $data['English_Name']=request('English_Name');
        $data['Arabic_Desc']=request('Arabic_Desc');
        $data['English_Desc']=request('English_Desc');



        ResturantReviews::create($data);



        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

    }

    public function EditRReviews($id){

        $data= $this->validate(request(),[

            'Arabic_Name'=>'required',
            'English_Name'=>'required',
            'Arabic_Desc'=>'required',
            'English_Desc'=>'required',

            'Image'=>'sometimes|nullable|max:100000',
        ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
            'Arabic_Name.required' => trans('admin.Arabic_TitleRequired'),
            'English_Name.required' => trans('admin.English_TitleRequired'),
            'Image.required' => trans('admin.ImageRequired'),


        ]);

        $image=request()->file('Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='WebsliderImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }

        if(!empty($image_url)){
            $data['Image']=$image_url;
        }else{

            $data['Image']=request('Images');
        }




        $data['Arabic_Name']=request('Arabic_Name');
        $data['English_Name']=request('English_Name');
        $data['Arabic_Desc']=request('Arabic_Desc');
        $data['English_Desc']=request('English_Desc');


        ResturantReviews::where('id',$id)->update($data);




        session()->flash('success',trans('admin.Updated'));
        return back();


    }

    public function DeleteRReviews($id){

        $del=ResturantReviews::find($id);



        $del->delete();
        session()->flash('error',trans('admin.Deleted'));
        return back();

    }



//Resrvations
    public function RReservations(){
        $items=ResturantReservations::orderBy('id','desc')->paginate(20);
        return view('admin.Resturant.Reservations',['items'=>$items]);
    }

    public function DeleteRReservations($id){

        $del=ResturantReservations::find($id);



        $del->delete();
        session()->flash('error',trans('admin.Deleted'));
        return back();

    }

    public function AddRReservations(){

        $data= $this->validate(request(),[

            'Name'=>'required',
            'Phone'=>'required',
            'Persons'=>'required',
            'Date'=>'required',
            'Time'=>'required',
        ],[

        ]);



        $data['Name']=request('Name');
        $data['Phone']=request('Phone');
        $data['Persons']=request('Persons');
        $data['Date']=request('Date');
        $data['Time']=request('Time');
        $data['Message']=request('Message');
        $data['Approve']=0;

        ResturantReservations::create($data);



        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

    }


    public function UnApproveResrvations($id){

        ResturantReservations::where('id',$id)->update(['Approve'=>0]);
        session()->flash('error',trans('admin.UnApprove'));
        return back();

    }

    public function ApproveResrvations($id){

        ResturantReservations::where('id',$id)->update(['Approve'=>1]);
        session()->flash('success',trans('admin.Approved'));
        return back();

    }



    //======  About =======
    public function RAbout(){
        $item=ResturantAbout::orderBy('id','desc')->first();
        return view('admin.Resturant.About',['item'=>$item]);
    }

    public function UpdateRAbout($id){

        $data= $this->validate(request(),[
            'Arabic_Desc'=>'required',
            'English_Desc'=>'required',
            'Arabic_Title'=>'required',
            'English_Title'=>'required',
            'Image_1'=>'sometimes|nullable|max:100000',
            'Image_2'=>'sometimes|nullable|max:100000',
            'Title_Image'=>'sometimes|nullable|max:100000',

        ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
            'Arabic_Title.required' => trans('admin.Arabic_TitleRequired'),
            'English_Title.required' => trans('admin.English_TitleRequired'),
            'Image_1.required' => trans('admin.ImageRequired'),
            'Image_2.required' => trans('admin.ImageRequired'),
            'Title_Image.required' => trans('admin.ImageRequired'),


        ]);


        $image=request()->file('Image_1');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AboutImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }
        if(!empty($image_url)){
            $data['Image_1']=$image_url;
        }else{

            $data['Image_1']=request('Images_1');
        }


        $imagex=request()->file('Image_2');
        if($imagex){
            $image_namex=Str::random(20);
            $extx=strtolower($imagex->getClientOriginalExtension());
            $image_full_namex=$image_namex .'.' . $extx ;
            $upload_pathx='AboutImages/';
            $image_urlx=$upload_pathx.$image_full_namex;
            $successx=$imagex->move($upload_pathx,$image_full_namex);
        }
        if(!empty($image_urlx)){
            $data['Image_2']=$image_urlx;
        }else{

            $data['Image_2']=request('Images_2');
        }

        $imagexe=request()->file('Title_Image');
        if($imagexe){
            $image_namexe=Str::random(20);
            $extxe=strtolower($imagexe->getClientOriginalExtension());
            $image_full_namexe=$image_namexe .'.' . $extxe ;
            $upload_pathxe='AboutImages/';
            $image_urlxe=$upload_pathxe.$image_full_namexe;
            $successxe=$imagexe->move($upload_pathxe,$image_full_namexe);
        }
        if(!empty($image_urlxe)){
            $data['Title_Image']=$image_urlxe;
        }else{

            $data['Title_Image']=request('Title_Images');
        }

        $data['Arabic_Desc']=request('Arabic_Desc');
        $data['English_Desc']=request('English_Desc');
        $data['Arabic_Title']=request('Arabic_Title');
        $data['English_Title']=request('English_Title');


        ResturantAbout::where('id',$id)->update($data);

        session()->flash('success',trans('admin.Updated'));
        return back();


    }


    //======  Home 2 =======
    public function ResturantHome(){
        $item=ResturantHome::orderBy('id','desc')->first();
        return view('admin.Resturant.Home2',['item'=>$item]);
    }

    public function UpdateResturantHome($id){

        $data= $this->validate(request(),[
            'Arabic_Title'=>'required',
            'English_Title'=>'required',
            'Image_1'=>'sometimes|nullable|max:100000',
            'Image_2'=>'sometimes|nullable|max:100000',
            'Image_3'=>'sometimes|nullable|max:100000',
            'Image_4'=>'sometimes|nullable|max:100000',
            'Title_Image'=>'sometimes|nullable|max:100000',

        ],[

            'Arabic_Title.required' => trans('admin.Arabic_TitleRequired'),
            'English_Title.required' => trans('admin.English_TitleRequired'),
            'Image_1.required' => trans('admin.ImageRequired'),
            'Image_2.required' => trans('admin.ImageRequired'),
            'Image_3.required' => trans('admin.ImageRequired'),
            'Image_4.required' => trans('admin.ImageRequired'),
            'Title_Image.required' => trans('admin.ImageRequired'),


        ]);


        $image=request()->file('Image_1');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AboutImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }
        if(!empty($image_url)){
            $data['Image_1']=$image_url;
        }else{

            $data['Image_1']=request('Images_1');
        }


        $imagex=request()->file('Image_2');
        if($imagex){
            $image_namex=Str::random(20);
            $extx=strtolower($imagex->getClientOriginalExtension());
            $image_full_namex=$image_namex .'.' . $extx ;
            $upload_pathx='AboutImages/';
            $image_urlx=$upload_pathx.$image_full_namex;
            $successx=$imagex->move($upload_pathx,$image_full_namex);
        }
        if(!empty($image_urlx)){
            $data['Image_2']=$image_urlx;
        }else{

            $data['Image_2']=request('Images_2');
        }

        $imagexe=request()->file('Title_Image');
        if($imagexe){
            $image_namexe=Str::random(20);
            $extxe=strtolower($imagexe->getClientOriginalExtension());
            $image_full_namexe=$image_namexe .'.' . $extxe ;
            $upload_pathxe='AboutImages/';
            $image_urlxe=$upload_pathxe.$image_full_namexe;
            $successxe=$imagexe->move($upload_pathxe,$image_full_namexe);
        }
        if(!empty($image_urlxe)){
            $data['Title_Image']=$image_urlxe;
        }else{

            $data['Title_Image']=request('Title_Images');
        }




        $imagexI=request()->file('Image_3');
        if($imagexI){
            $image_namexI=Str::random(20);
            $extxI=strtolower($imagexI->getClientOriginalExtension());
            $image_full_namexI=$image_namexI .'.' . $extxI ;
            $upload_pathxI='AboutImages/';
            $image_urlxI=$upload_pathxI.$image_full_namexI;
            $successxI=$imagexI->move($upload_pathxI,$image_full_namexI);
        }
        if(!empty($image_urlxI)){
            $data['Image_3']=$image_urlxI;
        }else{

            $data['Image_3']=request('Images_3');
        }



        $imagexII=request()->file('Image_4');
        if($imagexII){
            $image_namexII=Str::random(20);
            $extxII=strtolower($imagexII->getClientOriginalExtension());
            $image_full_namexII=$image_namexII .'.' . $extxII ;
            $upload_pathxII='AboutImages/';
            $image_urlxII=$upload_pathxII.$image_full_namexII;
            $successxI=$imagexII->move($upload_pathxII,$image_full_namexII);
        }
        if(!empty($image_urlxII)){
            $data['Image_4']=$image_urlxII;
        }else{

            $data['Image_4']=request('Images_4');
        }



        $data['Arabic_Title']=request('Arabic_Title');
        $data['English_Title']=request('English_Title');
        $data['Arabic_Sub_Title']=request('Arabic_Sub_Title');
        $data['English_Sub_Title']=request('English_Sub_Title');
        $data['Year']=request('Year');


        ResturantHome::where('id',$id)->update($data);

        session()->flash('success',trans('admin.Updated'));
        return back();


    }


    //======  Video Section =======
    public function VideoSection(){
        $item=ResturantVideoSection::orderBy('id','desc')->first();
        return view('admin.Resturant.VideoSection',['item'=>$item]);
    }

    public function UpdateVideoSection($id){


        $image=request()->file('Image_1');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AboutImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }
        if(!empty($image_url)){
            $data['Image_1']=$image_url;
        }else{

            $data['Image_1']=request('Images_1');
        }


        $imagex=request()->file('Image_2');
        if($imagex){
            $image_namex=Str::random(20);
            $extx=strtolower($imagex->getClientOriginalExtension());
            $image_full_namex=$image_namex .'.' . $extx ;
            $upload_pathx='AboutImages/';
            $image_urlx=$upload_pathx.$image_full_namex;
            $successx=$imagex->move($upload_pathx,$image_full_namex);
        }
        if(!empty($image_urlx)){
            $data['Image_2']=$image_urlx;
        }else{

            $data['Image_2']=request('Images_2');
        }

        $imagexe=request()->file('Title_Image');
        if($imagexe){
            $image_namexe=Str::random(20);
            $extxe=strtolower($imagexe->getClientOriginalExtension());
            $image_full_namexe=$image_namexe .'.' . $extxe ;
            $upload_pathxe='AboutImages/';
            $image_urlxe=$upload_pathxe.$image_full_namexe;
            $successxe=$imagexe->move($upload_pathxe,$image_full_namexe);
        }
        if(!empty($image_urlxe)){
            $data['Title_Image']=$image_urlxe;
        }else{

            $data['Title_Image']=request('Title_Images');
        }




        $imagexI=request()->file('Image_3');
        if($imagexI){
            $image_namexI=Str::random(20);
            $extxI=strtolower($imagexI->getClientOriginalExtension());
            $image_full_namexI=$image_namexI .'.' . $extxI ;
            $upload_pathxI='AboutImages/';
            $image_urlxI=$upload_pathxI.$image_full_namexI;
            $successxI=$imagexI->move($upload_pathxI,$image_full_namexI);
        }
        if(!empty($image_urlxI)){
            $data['Image_3']=$image_urlxI;
        }else{

            $data['Image_3']=request('Images_3');
        }



        $imagexII=request()->file('Image_4');
        if($imagexII){
            $image_namexII=Str::random(20);
            $extxII=strtolower($imagexII->getClientOriginalExtension());
            $image_full_namexII=$image_namexII .'.' . $extxII ;
            $upload_pathxII='AboutImages/';
            $image_urlxII=$upload_pathxII.$image_full_namexII;
            $successxI=$imagexII->move($upload_pathxII,$image_full_namexII);
        }
        if(!empty($image_urlxII)){
            $data['Image_4']=$image_urlxII;
        }else{

            $data['Image_4']=request('Images_4');
        }





        $imagexeBG=request()->file('BG_Image');
        if($imagexeBG){
            $image_namexeBG=Str::random(20);
            $extxeBG=strtolower($imagexeBG->getClientOriginalExtension());
            $image_full_namexeBG=$image_namexeBG .'.' . $extxeBG ;
            $upload_pathxeBG='AboutImages/';
            $image_urlxeBG=$upload_pathxeBG.$image_full_namexeBG;
            $successxeBG=$imagexeBG->move($upload_pathxeBG,$image_full_namexeBG);
        }
        if(!empty($image_urlxeBG)){
            $data['BG_Image']=$image_urlxeBG;
        }else{

            $data['BG_Image']=request('BG_Images');
        }



        $imagexeIcon=request()->file('Icon');
        if($imagexeIcon){
            $image_namexeIcon=Str::random(20);
            $extxeIcon=strtolower($imagexeIcon->getClientOriginalExtension());
            $image_full_namexeIcon=$image_namexeIcon .'.' . $extxeIcon ;
            $upload_pathxeIcon='AboutImages/';
            $image_urlxeIcon=$upload_pathxeIcon.$image_full_namexeIcon;
            $successxeIcon=$imagexeIcon->move($upload_pathxeIcon,$image_full_namexeIcon);
        }
        if(!empty($image_urlxeIcon)){
            $data['Icon']=$image_urlxeIcon;
        }else{

            $data['Icon']=request('Icons');
        }






        $data['Video_Link']=request('Video_Link');
        $data['Number_1']=request('Number_1');
        $data['Number_2']=request('Number_2');
        $data['Number_3']=request('Number_3');
        $data['Number_4']=request('Number_4');
        $data['Arabic_Title_1']=request('Arabic_Title_1');
        $data['Arabic_Title_2']=request('Arabic_Title_2');
        $data['Arabic_Title_3']=request('Arabic_Title_3');
        $data['Arabic_Title_4']=request('Arabic_Title_4');
        $data['English_Title_1']=request('English_Title_1');
        $data['English_Title_2']=request('English_Title_2');
        $data['English_Title_3']=request('English_Title_3');
        $data['English_Title_4']=request('English_Title_4');


        ResturantVideoSection::where('id',$id)->update($data);

        session()->flash('success',trans('admin.Updated'));
        return back();


    }

    //ResturantStyle
    public function ResturantStyle(){
        $item=ResturantStyle::orderBy('id','desc')->first();
        $IndexI=ResturantIndexStyleI::orderBy('id','desc')->first();
        $IndexII=ResturantIndexStyleII::orderBy('id','desc')->first();
        $NavFoot=ResturantNavFootStyle::orderBy('id','desc')->first();
        $SupPage=ResturantSupPageStyle::orderBy('id','desc')->first();
        $CartCheck=ResturantCartCheckStyle::orderBy('id','desc')->first();
        $Menu=ResturantMenuStyle::orderBy('id','desc')->first();
        return view('admin.Resturant.ResturantStyle',[
            'item'=>$item,
            'IndexI'=>$IndexI,
            'IndexII'=>$IndexII,
            'NavFoot'=>$NavFoot,
            'SupPage'=>$SupPage,
            'CartCheck'=>$CartCheck,
            'Menu'=>$Menu,

        ]);
    }

    public function UpdateResturantStyle($id){




        $image=request()->file('Body_BG_Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AboutImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }
        if(!empty($image_url)){
            $data['Body_BG_Image']=$image_url;
        }else{

            $data['Body_BG_Image']=request('Body_BG_Images');
        }

        $data['Font']=request('Font');
        $data['Home']=request('Home');
        $data['Menu']=request('Menu');
        $data['PDF']=request('PDF');
        $data['Cart']=request('Cart');
        $data['Blogs']=request('Blogs');
        $data['Gallery']=request('Gallery');
        $data['Terms']=request('Terms');
        $data['Privacy']=request('Privacy');
        $data['Reviews']=request('Reviews');
        $data['Reservations']=request('Reservations');

        $data['Body_BG_Type']=request('Body_BG_Type');
        $data['Body_BG_Color']=request('Body_BG_Color');
        $data['Body_Title_Color']=request('Body_Title_Color');
        $data['Pagination_BG_Color']=request('Pagination_BG_Color');
        $data['Pagination_Txt_Color']=request('Pagination_Txt_Color');
        $data['Pagination_Active_BG_Color']=request('Pagination_Active_BG_Color');
        $data['Pagination_Active_Txt_Color']=request('Pagination_Active_Txt_Color');
        $data['Modal_BG_Color']=request('Modal_BG_Color');
        $data['Modal_Txt_Color']=request('Modal_Txt_Color');
        $data['Modal_Button_BG_Color']=request('Modal_Button_BG_Color');
        $data['Modal_Button_Txt_Color']=request('Modal_Button_Txt_Color');
        $data['Preloader_Circle_1_Color']=request('Preloader_Circle_1_Color');
        $data['Preloader_Circle_2_Color']=request('Preloader_Circle_2_Color');
        $data['Preloader_Circle_3_Color']=request('Preloader_Circle_3_Color');
        $data['Form_Box_BG']=request('Form_Box_BG');
        $data['Form_Box_Border_Color']=request('Form_Box_Border_Color');
        $data['Form_Txt_Color']=request('Form_Txt_Color');
        $data['Form_Txt_Hover_Color']=request('Form_Txt_Hover_Color');
        $data['Form_Input_BG']=request('Form_Input_BG');
        $data['Form_Input_Txt_Color']=request('Form_Input_Txt_Color');
        $data['Form_Btn_BG']=request('Form_Btn_BG');
        $data['Form_Btn_Txt_Color']=request('Form_Btn_Txt_Color');



        ResturantStyle::where('id',$id)->update($data);

        session()->flash('success',trans('admin.Updated'));
        return back();


    }

    public function UpdateResturantStyleIndexI($id){




        $image=request()->file('Home_2_Image_1');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AboutImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }
        if(!empty($image_url)){
            $data['Home_2_Image_1']=$image_url;
        }else{

            $data['Home_2_Image_1']=request('Home_2_Images_1');
        }




        $image2=request()->file('Home_2_Image_2');
        if($image2){
            $image_name2=Str::random(20);
            $ext2=strtolower($image2->getClientOriginalExtension());
            $image_full_name2=$image_name2 .'.' . $ext2 ;
            $upload_path2='AboutImages/';
            $image_url2=$upload_path2.$image_full_name2;
            $success2=$image2->move($upload_path2,$image_full_name2);
        }
        if(!empty($image_url2)){
            $data['Home_2_Image_2']=$image_url2;
        }else{

            $data['Home_2_Image_2']=request('Home_2_Images_2');
        }



        $image3=request()->file('Home_2_Image_Arrow');
        if($image3){
            $image_name3=Str::random(20);
            $ext3=strtolower($image3->getClientOriginalExtension());
            $image_full_name3=$image_name3 .'.' . $ext3 ;
            $upload_path3='AboutImages/';
            $image_url3=$upload_path3.$image_full_name3;
            $success3=$image3->move($upload_path3,$image_full_name3);
        }
        if(!empty($image_url3)){
            $data['Home_2_Image_Arrow']=$image_url3;
        }else{

            $data['Home_2_Image_Arrow']=request('Home_2_Images_Arrow');
        }



        $image4=request()->file('Video_Section_Body_BG_Image');
        if($image4){
            $image_name4=Str::random(20);
            $ext4=strtolower($image4->getClientOriginalExtension());
            $image_full_name4=$image_name4 .'.' . $ext4 ;
            $upload_path4='AboutImages/';
            $image_url4=$upload_path4.$image_full_name4;
            $success4=$image4->move($upload_path4,$image_full_name4);
        }
        if(!empty($image_url4)){
            $data['Video_Section_Body_BG_Image']=$image_url4;
        }else{

            $data['Video_Section_Body_BG_Image']=request('Video_Section_Body_BG_Images');
        }




        $image5=request()->file('Video_Section_Image_1');
        if($image5){
            $image_name5=Str::random(20);
            $ext5=strtolower($image5->getClientOriginalExtension());
            $image_full_name5=$image_name5 .'.' . $ext5 ;
            $upload_path5='AboutImages/';
            $image_url5=$upload_path5.$image_full_name5;
            $success5=$image5->move($upload_path5,$image_full_name5);
        }
        if(!empty($image_url5)){
            $data['Video_Section_Image_1']=$image_url5;
        }else{

            $data['Video_Section_Image_1']=request('Video_Section_Images_1');
        }




        $image6=request()->file('Video_Section_Image_2');
        if($image6){
            $image_name6=Str::random(20);
            $ext6=strtolower($image6->getClientOriginalExtension());
            $image_full_name6=$image_name6 .'.' . $ext6 ;
            $upload_path6='AboutImages/';
            $image_url6=$upload_path6.$image_full_name6;
            $success6=$image6->move($upload_path6,$image_full_name6);
        }
        if(!empty($image_url6)){
            $data['Video_Section_Image_2']=$image_url6;
        }else{

            $data['Video_Section_Image_2']=request('Video_Section_Images_2');
        }




        $image7=request()->file('Menu_Index_Body_BG_Image');
        if($image7){
            $image_name7=Str::random(20);
            $ext7=strtolower($image7->getClientOriginalExtension());
            $image_full_name7=$image_name7 .'.' . $ext7 ;
            $upload_path7='AboutImages/';
            $image_url7=$upload_path7.$image_full_name7;
            $success7=$image7->move($upload_path7,$image_full_name7);
        }
        if(!empty($image_url7)){
            $data['Menu_Index_Body_BG_Image']=$image_url7;
        }else{

            $data['Menu_Index_Body_BG_Image']=request('Menu_Index_Body_BG_Images');
        }



        $image8=request()->file('Icon_Image');
        if($image8){
            $image_name8=Str::random(20);
            $ext8=strtolower($image8->getClientOriginalExtension());
            $image_full_name8=$image_name8 .'.' . $ext8 ;
            $upload_path8='AboutImages/';
            $image_url8=$upload_path8.$image_full_name8;
            $success8=$image8->move($upload_path8,$image_full_name8);
        }
        if(!empty($image_url8)){
            $data['Icon_Image']=$image_url8;
        }else{

            $data['Icon_Image']=request('Icon_Images');
        }





        $data['Home_1_Nxt_Prev_Color']=request('Home_1_Nxt_Prev_Color');
        $data['Home_1_Nxt_Prev_BG']=request('Home_1_Nxt_Prev_BG');
        $data['Home_1_Nxt_Prev_Border']=request('Home_1_Nxt_Prev_Border');
        $data['Home_2_Number_BG']=request('Home_2_Number_BG');
        $data['Home_2_Image_Border']=request('Home_2_Image_Border');
        $data['Home_2_Number_Color']=request('Home_2_Number_Color');
        $data['Category_Bar_BG']=request('Category_Bar_BG');
        $data['Category_Bar_Color']=request('Category_Bar_Color');
        $data['Video_Section_Body_BG_Type']=request('Video_Section_Body_BG_Type');
        $data['Video_Section_Body_BG_Color']=request('Video_Section_Body_BG_Color');
        $data['Menu_Index_Body_BG_Type']=request('Menu_Index_Body_BG_Type');
        $data['Menu_Index_Body_BG_Color']=request('Menu_Index_Body_BG_Color');
        $data['Menu_Index_Txt_Color']=request('Menu_Index_Txt_Color');
        $data['Menu_Index_Txt_Hover_Color']=request('Menu_Index_Txt_Hover_Color');
        $data['Menu_Index_Btn_BG']=request('Menu_Index_Btn_BG');
        $data['Menu_Index_Btn_Txt_Color']=request('Menu_Index_Btn_Txt_Color');

        ResturantIndexStyleI::where('id',$id)->update($data);

        session()->flash('success',trans('admin.Updated'));
        return back();


    }

    public function UpdateResturantStyleIndexII($id){




        $image=request()->file('About_Body_BG_Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AboutImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }
        if(!empty($image_url)){
            $data['About_Body_BG_Image']=$image_url;
        }else{

            $data['About_Body_BG_Image']=request('About_Body_BG_Images');
        }




        $image2=request()->file('Reviews_Image_1');
        if($image2){
            $image_name2=Str::random(20);
            $ext2=strtolower($image2->getClientOriginalExtension());
            $image_full_name2=$image_name2 .'.' . $ext2 ;
            $upload_path2='AboutImages/';
            $image_url2=$upload_path2.$image_full_name2;
            $success2=$image2->move($upload_path2,$image_full_name2);
        }
        if(!empty($image_url2)){
            $data['Reviews_Image_1']=$image_url2;
        }else{

            $data['Reviews_Image_1']=request('Reviews_Images_1');
        }



        $image3=request()->file('Reviews_Image_2');
        if($image3){
            $image_name3=Str::random(20);
            $ext3=strtolower($image3->getClientOriginalExtension());
            $image_full_name3=$image_name3 .'.' . $ext3 ;
            $upload_path3='AboutImages/';
            $image_url3=$upload_path3.$image_full_name3;
            $success3=$image3->move($upload_path3,$image_full_name3);
        }
        if(!empty($image_url3)){
            $data['Reviews_Image_2']=$image_url3;
        }else{

            $data['Reviews_Image_2']=request('Reviews_Images_2');
        }



        $image4=request()->file('Reviews_Body_BG_Image');
        if($image4){
            $image_name4=Str::random(20);
            $ext4=strtolower($image4->getClientOriginalExtension());
            $image_full_name4=$image_name4 .'.' . $ext4 ;
            $upload_path4='AboutImages/';
            $image_url4=$upload_path4.$image_full_name4;
            $success4=$image4->move($upload_path4,$image_full_name4);
        }
        if(!empty($image_url4)){
            $data['Reviews_Body_BG_Image']=$image_url4;
        }else{

            $data['Reviews_Body_BG_Image']=request('Reviews_Body_BG_Images');
        }




        $image5=request()->file('Reservations_Body_BG_Image');
        if($image5){
            $image_name5=Str::random(20);
            $ext5=strtolower($image5->getClientOriginalExtension());
            $image_full_name5=$image_name5 .'.' . $ext5 ;
            $upload_path5='AboutImages/';
            $image_url5=$upload_path5.$image_full_name5;
            $success5=$image5->move($upload_path5,$image_full_name5);
        }
        if(!empty($image_url5)){
            $data['Reservations_Body_BG_Image']=$image_url5;
        }else{

            $data['Reservations_Body_BG_Image']=request('Reservations_Body_BG_Images');
        }




        $image6=request()->file('Blogs_Home_Body_BG_Image');
        if($image6){
            $image_name6=Str::random(20);
            $ext6=strtolower($image6->getClientOriginalExtension());
            $image_full_name6=$image_name6 .'.' . $ext6 ;
            $upload_path6='AboutImages/';
            $image_url6=$upload_path6.$image_full_name6;
            $success6=$image6->move($upload_path6,$image_full_name6);
        }
        if(!empty($image_url6)){
            $data['Blogs_Home_Body_BG_Image']=$image_url6;
        }else{

            $data['Blogs_Home_Body_BG_Image']=request('Blogs_Home_Body_BG_Images');
        }




        $data['About_Body_BG_Type']=request('About_Body_BG_Type');
        $data['About_Body_BG_Color']=request('About_Body_BG_Color');
        $data['About_Txt_Color']=request('About_Txt_Color');
        $data['Gallery_Border_Color']=request('Gallery_Border_Color');
        $data['Reviews_Nxt_Prev_Color']=request('Reviews_Nxt_Prev_Color');
        $data['Reviews_Nxt_Prev_BG']=request('Reviews_Nxt_Prev_BG');
        $data['Reviews_Nxt_Prev_Border']=request('Reviews_Nxt_Prev_Border');
        $data['Reviews_Txt_Color']=request('Reviews_Txt_Color');
        $data['Reviews_Body_BG_Type']=request('Reviews_Body_BG_Type');
        $data['Reviews_Body_BG_Color']=request('Reviews_Body_BG_Color');
        $data['Reservations_Body_BG_Type']=request('Reservations_Body_BG_Type');
        $data['Reservations_Body_BG_Color']=request('Reservations_Body_BG_Color');
        $data['Reservations_Box_BG']=request('Reservations_Box_BG');
        $data['Reservations_Input_BG']=request('Reservations_Input_BG');
        $data['Reservations_Input_Color']=request('Reservations_Input_Color');
        $data['Reservations_Btn_Color']=request('Reservations_Btn_Color');
        $data['Reservations_Btn_BG']=request('Reservations_Btn_BG');
        $data['Blogs_Home_Body_BG_Type']=request('Blogs_Home_Body_BG_Type');
        $data['Blogs_Home_Body_BG_Color']=request('Blogs_Home_Body_BG_Color');
        $data['Blogs_Home_Box_BG_Color']=request('Blogs_Home_Box_BG_Color');
        $data['Blogs_Home_Box_Border_Color']=request('Blogs_Home_Box_Border_Color');
        $data['Blogs_Home_Txt_Color']=request('Blogs_Home_Txt_Color');
        $data['Blogs_Home_Txt_Hover_Color']=request('Blogs_Home_Txt_Hover_Color');
        $data['Blogs_Home_Btn_BG']=request('Blogs_Home_Btn_BG');
        $data['Blogs_Home_Btn_Color']=request('Blogs_Home_Btn_Color');

        ResturantIndexStyleII::where('id',$id)->update($data);

        session()->flash('success',trans('admin.Updated'));
        return back();


    }

    public function UpdateResturantStyleNavbar($id){




        $image=request()->file('Footer_BG_Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AboutImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }
        if(!empty($image_url)){
            $data['Footer_BG_Image']=$image_url;
        }else{

            $data['Footer_BG_Image']=request('Footer_BG_Images');
        }



        $data['Navbar_BG']=request('Navbar_BG');
        $data['Navbar_Txt_Color']=request('Navbar_Txt_Color');
        $data['Navbar_Txt_Hover_Color']=request('Navbar_Txt_Hover_Color');
        $data['Navbar_Btn_BG']=request('Navbar_Btn_BG');
        $data['Navbar_Btn_Color']=request('Navbar_Btn_Color');
        $data['Navbar_Sub_Menu_BG']=request('Navbar_Sub_Menu_BG');
        $data['Navbar_Sub_Menu_Color']=request('Navbar_Sub_Menu_Color');
        $data['Footer_BG_Type']=request('Footer_BG_Type');
        $data['Footer_BG_Color']=request('Footer_BG_Color');
        $data['Footer_Title_Color']=request('Footer_Title_Color');
        $data['Footer_Txt_Color']=request('Footer_Txt_Color');
        $data['Footer_Social_Color']=request('Footer_Social_Color');
        $data['Footer_Social_Hover_Color']=request('Footer_Social_Hover_Color');
        $data['Footer_CopyRight_Color']=request('Footer_CopyRight_Color');
        $data['Footer_CopyRight_Company_Color']=request('Footer_CopyRight_Company_Color');

        ResturantNavFootStyle::where('id',$id)->update($data);

        session()->flash('success',trans('admin.Updated'));
        return back();


    }


    public function UpdateResturantStyleSupPage($id){




        $image=request()->file('Blogs_BG_Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AboutImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }
        if(!empty($image_url)){
            $data['Blogs_BG_Image']=$image_url;
        }else{

            $data['Blogs_BG_Image']=request('Blogs_BG_Images');
        }




        $image2=request()->file('Blogs_Top_Image');
        if($image2){
            $image_name2=Str::random(20);
            $ext2=strtolower($image2->getClientOriginalExtension());
            $image_full_name2=$image_name2 .'.' . $ext2 ;
            $upload_path2='AboutImages/';
            $image_url2=$upload_path2.$image_full_name2;
            $success2=$image2->move($upload_path2,$image_full_name2);
        }
        if(!empty($image_url2)){
            $data['Blogs_Top_Image']=$image_url2;
        }else{

            $data['Blogs_Top_Image']=request('Blogs_Top_Images');
        }



        $image3=request()->file('Reviews_Top_Image');
        if($image3){
            $image_name3=Str::random(20);
            $ext3=strtolower($image3->getClientOriginalExtension());
            $image_full_name3=$image_name3 .'.' . $ext3 ;
            $upload_path3='AboutImages/';
            $image_url3=$upload_path3.$image_full_name3;
            $success3=$image3->move($upload_path3,$image_full_name3);
        }
        if(!empty($image_url3)){
            $data['Reviews_Top_Image']=$image_url3;
        }else{

            $data['Reviews_Top_Image']=request('Reviews_Top_Images');
        }



        $image4=request()->file('Reviews_BG_Image');
        if($image4){
            $image_name4=Str::random(20);
            $ext4=strtolower($image4->getClientOriginalExtension());
            $image_full_name4=$image_name4 .'.' . $ext4 ;
            $upload_path4='AboutImages/';
            $image_url4=$upload_path4.$image_full_name4;
            $success4=$image4->move($upload_path4,$image_full_name4);
        }
        if(!empty($image_url4)){
            $data['Reviews_BG_Image']=$image_url4;
        }else{

            $data['Reviews_BG_Image']=request('Reviews_BG_Images');
        }




        $image5=request()->file('Gallery_Top_Image');
        if($image5){
            $image_name5=Str::random(20);
            $ext5=strtolower($image5->getClientOriginalExtension());
            $image_full_name5=$image_name5 .'.' . $ext5 ;
            $upload_path5='AboutImages/';
            $image_url5=$upload_path5.$image_full_name5;
            $success5=$image5->move($upload_path5,$image_full_name5);
        }
        if(!empty($image_url5)){
            $data['Gallery_Top_Image']=$image_url5;
        }else{

            $data['Gallery_Top_Image']=request('Gallery_Top_Images');
        }




        $image6=request()->file('Gallery__BG_Image');
        if($image6){
            $image_name6=Str::random(20);
            $ext6=strtolower($image6->getClientOriginalExtension());
            $image_full_name6=$image_name6 .'.' . $ext6 ;
            $upload_path6='AboutImages/';
            $image_url6=$upload_path6.$image_full_name6;
            $success6=$image6->move($upload_path6,$image_full_name6);
        }
        if(!empty($image_url6)){
            $data['Gallery__BG_Image']=$image_url6;
        }else{

            $data['Gallery__BG_Image']=request('Gallery__BG_Images');
        }




        $image7=request()->file('Terms_Privacy_Top_Image');
        if($image7){
            $image_name7=Str::random(20);
            $ext7=strtolower($image7->getClientOriginalExtension());
            $image_full_name7=$image_name7 .'.' . $ext7 ;
            $upload_path7='AboutImages/';
            $image_url7=$upload_path7.$image_full_name7;
            $success7=$image7->move($upload_path7,$image_full_name7);
        }
        if(!empty($image_url7)){
            $data['Terms_Privacy_Top_Image']=$image_url7;
        }else{

            $data['Terms_Privacy_Top_Image']=request('Terms_Privacy_Top_Images');
        }


        $data['Blogs_BG_Type']=request('Blogs_BG_Type');
        $data['Blogs_BG_Color']=request('Blogs_BG_Color');
        $data['Blogs_Title_Color']=request('Blogs_Title_Color');
        $data['Blogs_Box_BG']=request('Blogs_Box_BG');
        $data['Blogs_Box_Border']=request('Blogs_Box_Border');
        $data['Blogs_Box_Txt_Color']=request('Blogs_Box_Txt_Color');
        $data['Blogs_Box_Txt_Hover_Color']=request('Blogs_Box_Txt_Hover_Color');
        $data['Blogs_Btn_Color']=request('Blogs_Btn_Color');
        $data['Blogs_Btn_BG']=request('Blogs_Btn_BG');
        $data['Blogs_Details_Box_BG']=request('Blogs_Details_Box_BG');
        $data['Blogs_Details_Box_Border']=request('Blogs_Details_Box_Border');
        $data['Blogs_Details_Box_Txt_Color']=request('Blogs_Details_Box_Txt_Color');
        $data['Reviews_Title_Color']=request('Reviews_Title_Color');
        $data['Reviews_BG_Type']=request('Reviews_BG_Type');
        $data['Reviews_BG_Color']=request('Reviews_BG_Color');
        $data['Reviews_Box_BG']=request('Reviews_Box_BG');
        $data['Reviews_Box_Border']=request('Reviews_Box_Border');
        $data['Reviews_Icon_Color']=request('Reviews_Icon_Color');
        $data['Gallery_Title_Color']=request('Gallery_Title_Color');
        $data['Gallery__BG_Type']=request('Gallery__BG_Type');
        $data['Gallery__BG_Color']=request('Gallery__BG_Color');
        $data['Terms_Privacy_Title_Color']=request('Terms_Privacy_Title_Color');
        $data['Terms_Privacy_Box_BG']=request('Terms_Privacy_Box_BG');
        $data['Terms_Privacy_Box_Border']=request('Terms_Privacy_Box_Border');

        ResturantSupPageStyle::where('id',$id)->update($data);

        session()->flash('success',trans('admin.Updated'));
        return back();


    }


    public function UpdateResturantStyleCart($id){




        $image=request()->file('Cart_BG_Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AboutImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }
        if(!empty($image_url)){
            $data['Cart_BG_Image']=$image_url;
        }else{

            $data['Cart_BG_Image']=request('Cart_BG_Images');
        }




        $image2=request()->file('Cart_Top_Image');
        if($image2){
            $image_name2=Str::random(20);
            $ext2=strtolower($image2->getClientOriginalExtension());
            $image_full_name2=$image_name2 .'.' . $ext2 ;
            $upload_path2='AboutImages/';
            $image_url2=$upload_path2.$image_full_name2;
            $success2=$image2->move($upload_path2,$image_full_name2);
        }
        if(!empty($image_url2)){
            $data['Cart_Top_Image']=$image_url2;
        }else{

            $data['Cart_Top_Image']=request('Cart_Top_Images');
        }



        $image3=request()->file('Checkout_Image');
        if($image3){
            $image_name3=Str::random(20);
            $ext3=strtolower($image3->getClientOriginalExtension());
            $image_full_name3=$image_name3 .'.' . $ext3 ;
            $upload_path3='AboutImages/';
            $image_url3=$upload_path3.$image_full_name3;
            $success3=$image3->move($upload_path3,$image_full_name3);
        }
        if(!empty($image_url3)){
            $data['Checkout_Image']=$image_url3;
        }else{

            $data['Checkout_Image']=request('Checkout_Images');
        }



        $image4=request()->file('Checkout_BG_Image');
        if($image4){
            $image_name4=Str::random(20);
            $ext4=strtolower($image4->getClientOriginalExtension());
            $image_full_name4=$image_name4 .'.' . $ext4 ;
            $upload_path4='AboutImages/';
            $image_url4=$upload_path4.$image_full_name4;
            $success4=$image4->move($upload_path4,$image_full_name4);
        }
        if(!empty($image_url4)){
            $data['Checkout_BG_Image']=$image_url4;
        }else{

            $data['Checkout_BG_Image']=request('Checkout_BG_Images');
        }




        $image5=request()->file('MyAccount_BG_Image');
        if($image5){
            $image_name5=Str::random(20);
            $ext5=strtolower($image5->getClientOriginalExtension());
            $image_full_name5=$image_name5 .'.' . $ext5 ;
            $upload_path5='AboutImages/';
            $image_url5=$upload_path5.$image_full_name5;
            $success5=$image5->move($upload_path5,$image_full_name5);
        }
        if(!empty($image_url5)){
            $data['MyAccount_BG_Image']=$image_url5;
        }else{

            $data['MyAccount_BG_Image']=request('MyAccount_BG_Images');
        }


        $data['Cart_BG_Type']=request('Cart_BG_Type');
        $data['Cart_BG_Color']=request('Cart_BG_Color');
        $data['Cart_Title_Color']=request('Cart_Title_Color');
        $data['Cart_Txt_Color']=request('Cart_Txt_Color');
        $data['Cart_Box_BG']=request('Cart_Box_BG');
        $data['Cart_Box_Border']=request('Cart_Box_Border');
        $data['Cart_Table_Color']=request('Cart_Table_Color');
        $data['Cart_Table_BG']=request('Cart_Table_BG');
        $data['Cart_Btn_BG']=request('Cart_Btn_BG');
        $data['Cart_Btn_Color']=request('Cart_Btn_Color');
        $data['Checkout_Title_Color']=request('Checkout_Title_Color');
        $data['Checkout_BG_Type']=request('Checkout_BG_Type');
        $data['Checkout_BG_Color']=request('Checkout_BG_Color');
        $data['Checkout_Box_BG']=request('Checkout_Box_BG');
        $data['Checkout_Box_Border']=request('Checkout_Box_Border');
        $data['Checkout_Input_BG']=request('Checkout_Input_BG');
        $data['Checkout_Input_Color']=request('Checkout_Input_Color');
        $data['Checkout_Btn_Color']=request('Checkout_Btn_Color');
        $data['Checkout_Btn_BG']=request('Checkout_Btn_BG');
        $data['Checkout_Txt_Color']=request('Checkout_Txt_Color');
        $data['Checkout_Txt_Hover_Color']=request('Checkout_Txt_Hover_Color');
        $data['Checkout_Price_Color']=request('Checkout_Price_Color');
        $data['MyAccount_BG_Type']=request('MyAccount_BG_Type');
        $data['MyAccount_BG_Color']=request('MyAccount_BG_Color');
        $data['MyAccount_Box_BG']=request('MyAccount_Box_BG');
        $data['MyAccount_Box_Border']=request('MyAccount_Box_Border');
        $data['MyAccount_Table_BG']=request('MyAccount_Table_BG');
        $data['MyAccount_Table_Color']=request('MyAccount_Table_Color');
        $data['MyAccount_Table_Head_BG']=request('MyAccount_Table_Head_BG');
        $data['MyAccount_Table_Head_Color']=request('MyAccount_Table_Head_Color');
        $data['MyAccount_Txt_Color']=request('MyAccount_Txt_Color');
        $data['MyAccount_Btn_BG']=request('MyAccount_Btn_BG');
        $data['MyAccount_Btn_Color']=request('MyAccount_Btn_Color');
        $data['MyAccount_Input_BG']=request('MyAccount_Input_BG');
        $data['MyAccount_Input_Color']=request('MyAccount_Input_Color');
        $data['Collapse_Border']=request('Collapse_Border');
        $data['Collapse_BG']=request('Collapse_BG');
        $data['Collapse_Color']=request('Collapse_Color');

        ResturantCartCheckStyle::where('id',$id)->update($data);

        session()->flash('success',trans('admin.Updated'));
        return back();


    }


    public function UpdateResturantStyleMenu($id){



        $image=request()->file('Menu_1_BG_Image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AboutImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }
        if(!empty($image_url)){
            $data['Menu_1_BG_Image']=$image_url;
        }else{

            $data['Menu_1_BG_Image']=request('Menu_1_BG_Images');
        }




        $image2=request()->file('Menu_1_Image');
        if($image2){
            $image_name2=Str::random(20);
            $ext2=strtolower($image2->getClientOriginalExtension());
            $image_full_name2=$image_name2 .'.' . $ext2 ;
            $upload_path2='AboutImages/';
            $image_url2=$upload_path2.$image_full_name2;
            $success2=$image2->move($upload_path2,$image_full_name2);
        }
        if(!empty($image_url2)){
            $data['Menu_1_Image']=$image_url2;
        }else{

            $data['Menu_1_Image']=request('Menu_1_Images');
        }



        $image3=request()->file('Menu_1_Icon_Image');
        if($image3){
            $image_name3=Str::random(20);
            $ext3=strtolower($image3->getClientOriginalExtension());
            $image_full_name3=$image_name3 .'.' . $ext3 ;
            $upload_path3='AboutImages/';
            $image_url3=$upload_path3.$image_full_name3;
            $success3=$image3->move($upload_path3,$image_full_name3);
        }
        if(!empty($image_url3)){
            $data['Menu_1_Icon_Image']=$image_url3;
        }else{

            $data['Menu_1_Icon_Image']=request('Menu_1_Icon_Images');
        }



        $image4=request()->file('Menu_2_BG_Image');
        if($image4){
            $image_name4=Str::random(20);
            $ext4=strtolower($image4->getClientOriginalExtension());
            $image_full_name4=$image_name4 .'.' . $ext4 ;
            $upload_path4='AboutImages/';
            $image_url4=$upload_path4.$image_full_name4;
            $success4=$image4->move($upload_path4,$image_full_name4);
        }
        if(!empty($image_url4)){
            $data['Menu_2_BG_Image']=$image_url4;
        }else{

            $data['Menu_2_BG_Image']=request('Menu_2_BG_Images');
        }




        $image5=request()->file('Menu_3_BG_Image');
        if($image5){
            $image_name5=Str::random(20);
            $ext5=strtolower($image5->getClientOriginalExtension());
            $image_full_name5=$image_name5 .'.' . $ext5 ;
            $upload_path5='AboutImages/';
            $image_url5=$upload_path5.$image_full_name5;
            $success5=$image5->move($upload_path5,$image_full_name5);
        }
        if(!empty($image_url5)){
            $data['Menu_3_BG_Image']=$image_url5;
        }else{

            $data['Menu_3_BG_Image']=request('Menu_3_BG_Images');
        }




        $image6=request()->file('Menu_3_Image');
        if($image6){
            $image_name6=Str::random(20);
            $ext6=strtolower($image6->getClientOriginalExtension());
            $image_full_name6=$image_name6 .'.' . $ext6 ;
            $upload_path6='AboutImages/';
            $image_url6=$upload_path6.$image_full_name6;
            $success6=$image6->move($upload_path6,$image_full_name6);
        }
        if(!empty($image_url6)){
            $data['Menu_3_Image']=$image_url6;
        }else{

            $data['Menu_3_Image']=request('Menu_3_Images');
        }




        $image7=request()->file('Menu_3_Icon_Image');
        if($image7){
            $image_name7=Str::random(20);
            $ext7=strtolower($image6->getClientOriginalExtension());
            $image_full_name7=$image_name7 .'.' . $ext7 ;
            $upload_path7='AboutImages/';
            $image_url7=$upload_path7.$image_full_name7;
            $success7=$image7->move($upload_path7,$image_full_name7);
        }
        if(!empty($image_url7)){
            $data['Menu_3_Icon_Image']=$image_url7;
        }else{

            $data['Menu_3_Icon_Image']=request('Menu_3_Icon_Images');
        }


        $data['Menu_1_BG_Type']=request('Menu_1_BG_Type');
        $data['Menu_1_BG_Color']=request('Menu_1_BG_Color');
        $data['Menu_1_Title']=request('Menu_1_Title');
        $data['Menu_1_Bar_BG']=request('Menu_1_Bar_BG');
        $data['Menu_1_Bar_Color']=request('Menu_1_Bar_Color');
        $data['Menu_1_Btn_BG']=request('Menu_1_Btn_BG');
        $data['Menu_1_Btn_Color']=request('Menu_1_Btn_Color');
        $data['Menu_1_Icon_Color']=request('Menu_1_Icon_Color');
        $data['Menu_1_Icon_Hover_Color']=request('Menu_1_Icon_Hover_Color');
        $data['Menu_1_Icon_Active_Color']=request('Menu_1_Icon_Active_Color');
        $data['Menu_1_Price_Color']=request('Menu_1_Price_Color');
        $data['Menu_1_Offer_Price_Color']=request('Menu_1_Offer_Price_Color');
        $data['Menu_2_Gallery_Border']=request('Menu_2_Gallery_Border');
        $data['Menu_2_BG_Type']=request('Menu_2_BG_Type');
        $data['Menu_2_BG_Color']=request('Menu_2_BG_Color');
        $data['Menu_2_Title']=request('Menu_2_Title');
        $data['Menu_2_Category_Color']=request('Menu_2_Category_Color');
        $data['Menu_2_Category_Hover_Color']=request('Menu_2_Category_Hover_Color');
        $data['Menu_2_Category_Active_Color']=request('Menu_2_Category_Active_Color');
        $data['Menu_2_Lines_Color']=request('Menu_2_Lines_Color');
        $data['Menu_2_Btn_BG']=request('Menu_2_Btn_BG');
        $data['Menu_2_Btn_Color']=request('Menu_2_Btn_Color');
        $data['Menu_2_Name_BG']=request('Menu_2_Name_BG');
        $data['Menu_2_Name_Color']=request('Menu_2_Name_Color');
        $data['Menu_2_Icon_Color']=request('Menu_2_Icon_Color');
        $data['Menu_2_Icon_Hover_Color']=request('Menu_2_Icon_Hover_Color');
        $data['Menu_2_Icon_Active_Color']=request('Menu_2_Icon_Active_Color');
        $data['Menu_2_Price_Color']=request('Menu_2_Price_Color');
        $data['Menu_2_Offer_Price_Color']=request('Menu_2_Offer_Price_Color');
        $data['Menu_3_BG_Type']=request('Menu_3_BG_Type');
        $data['Menu_3_BG_Color']=request('Menu_3_BG_Color');
        $data['Menu_3_Title']=request('Menu_3_Title');
        $data['Menu_3_Category_Color']=request('Menu_3_Category_Color');
        $data['Menu_3_Category_Hover_Color']=request('Menu_3_Category_Hover_Color');
        $data['Menu_3_Category_Active_Color']=request('Menu_3_Category_Active_Color');
        $data['Menu_3_Box_BG']=request('Menu_3_Box_BG');
        $data['Menu_3_Box_Color']=request('Menu_3_Box_Color');
        $data['Menu_3_Btn_BG']=request('Menu_3_Btn_BG');
        $data['Menu_3_Btn_Color']=request('Menu_3_Btn_Color');
        $data['Menu_3_Icon_Color']=request('Menu_3_Icon_Color');
        $data['Menu_3_Icon_Hover_Color']=request('Menu_3_Icon_Hover_Color');
        $data['Menu_3_Icon_Active_Color']=request('Menu_3_Icon_Active_Color');
        $data['Menu_3_Price_Color']=request('Menu_3_Price_Color');
        $data['Menu_3_Offer_Price_Color']=request('Menu_3_Offer_Price_Color');

        ResturantMenuStyle::where('id',$id)->update($data);

        session()->flash('success',trans('admin.Updated'));
        return back();


    }



//================  View Site   ========================================================================================================================

        public function ResturantView(){

            $def=CompanyData::orderBy('id','desc')->first();
            $style=ResturantStyle::orderBy('id','desc')->first();
            $Home=ResturantHome::orderBy('id','desc')->first();


            $Sliders=ResturantSliders::where('Status',1)->get();
            $blogs=ResturantBlogs::orderBy('id','desc')->take(3)->get();

                $Reviews=ResturantReviews::take(9)->get();
                $Gallery=ResturantGallery::take(16)->get();

                $About=ResturantAbout::orderBy('id','desc')->first();
                $Video=ResturantVideoSection::orderBy('id','desc')->first();

$Groups=ItemsGroups::whereIn('Store_Show',[1,3])->where('Parent',0)->get();

         return view('resturant-view.home',get_defined_vars());
    }


// BlogsResturantSite
            public function BlogsResturantSite(){
            $blogs=ResturantBlogs::paginate(12);
         return view('resturant-view.Blogs',get_defined_vars());
    }

//BlogsResturantSiteDetails
           public function BlogsResturantSiteDetails($id){
            $blog=ResturantBlogs::find($id);
         return view('resturant-view.BlogsDetails',get_defined_vars());
    }

//ReviewsResturantSite
         public function ReviewsResturantSite(){

           $Reviews=ResturantReviews::paginate(12);


         return view('resturant-view.Reviews',get_defined_vars());
    }

//GalleryResturantSite
         public function GalleryResturantSite(){

           $Gallery=ResturantGallery::paginate(12);


         return view('resturant-view.Gallery',get_defined_vars());
    }

//TermsResturantSite
      public function TermsResturantSite(){

          $item=ResturantTerms::orderBy('id','desc')->first();


         return view('resturant-view.Terms',get_defined_vars());
    }
//PrivacyResturantSite
          public function PrivacyResturantSite(){

          $item=ResturantPrivacy::orderBy('id','desc')->first();


         return view('resturant-view.Privacy',get_defined_vars());
    }


//    MenuSite
           public function MenuSite(){


            $style=ResturantStyle::orderBy('id','desc')->first();
                    $Gallery=ResturantGallery::take(16)->get();
$Groups=ItemsGroups::whereIn('Store_Show',[1,3])->where('Parent',0)->get();
$Last=ItemsGroups::orderBy('id','desc')->first();

         return view('resturant-view.Menu',get_defined_vars());
    }

//MenuFilter
            public function MenuFilter($id){


            $style=ResturantStyle::orderBy('id','desc')->first();
                    $Gallery=ResturantGallery::take(16)->get();
$Groups=ItemsGroups::whereIn('Store_Show',[1,3])->where('Parent',0)->where('id',$id)->get();
$Last=ItemsGroups::orderBy('id','desc')->where('id',$id)->first();

         return view('resturant-view.MenuFilter',get_defined_vars());

    }

//CartResturantSite
        public function CartResturantSite(){
     $Carts=Cart::content();
         $x=0;
         return view('resturant-view.Cart',get_defined_vars());
    }

        public function DeleteCartResturant($id){


          $Contents=Cart::content();
  foreach($Contents as $con){

            if($con->rowId == $id){

             $pro=Products::find($con->id);

                     if($pro->P_Type == 'Variable_Aggregate'){

        VAPrice::where('id',$con->options->VPriceID)->update(['Added'=>0]);
            }else{

            Products::where('id',$con->id)->update(['Added'=>0]);
            }


            }

        }



          Cart::update($id,0);
           return back();
     }

    public function UpdateCartResturant(){

         $qty=request('qty');
         $rowId=request('RowID');
       for($i=0; $i < count($rowId) ; $i++){

           Cart::update($rowId[$i],$qty[$i]);

       }

         return back();

     }

     public function UpdateCuponCodeResturant(){

         try {
             DB::beginTransaction();


             $i=ResturantCuponCode::where('Code',request('code'))->first();

         if(!empty($i->id)){

            if($i->Status == 1){
                DB::rollBack();
            session()->flash('error',trans('admin.Code_Expired'));
             return back();

            }elseif($i->Expire < date('Y-m-d')){
                DB::rollBack();
              session()->flash('error',trans('admin.Code_Expired'));
             return back();

            }else{


                    if(request('code') != NULL){

                $y=$i->Used + 1 ;

                if($y == $i->Num){

                    $Status=1;
                }else{

                    $Status=0;
                }
             ResturantCuponCode::where('id',$i->id)->update(['Used'=>$y,'Status'=>$Status]);

          }


             $x=$i->Amount;
           session()->flash('success',trans('admin.Correct_Code'));

        $Carts=Cart::content();

                DB::commit();
      return view('resturant-view.Cart',[
             'Carts'=>$Carts,
             'x'=>$x,

         ]);


            }


         }else{
             DB::rollBack();
              session()->flash('error',trans('admin.Wrong_Code'));
             return back();

         }

         }catch(\Exception $ex){


             DB::rollBack();
             Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             DB::rollBack();
             Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

     }

    //AddCartAjax
    function AddCartResturant(Request $request)
    {
        if($request->ajax())
        {
            $output = '';
            $Product = $request->get('Product');
            $SUbV = $request->get('SUbV');
            $VPriceID = $request->get('VPriceID');
            $Price = $request->get('Price');

            $pro=Products::find($Product);
            $proCC=ProductUnits::where('Product',$Product)->where('Def',1)->first();
            $proV=VAPrice::find($VPriceID);

            if($pro->P_Type == 'Variable_Aggregate'){

                $Name= app()->getLocale() == 'ar' ?$pro->P_Ar_Name :$pro->P_En_Name ;
                $Image= $pro->Image ;
                $TypeName= app()->getLocale() == 'ar' ?$proV->SubV()->first()->Name :$proV->SubV()->first()->NameEn ;
            }else{

                $Name= app()->getLocale() == 'ar' ?$pro->P_Ar_Name :$pro->P_En_Name ;
                $Image= $pro->Image ;
                $TypeName='';

            }

            Cart::add(['id' =>$pro->id,'name' =>$pro->P_Ar_Name, 'qty' => 1, 'price' =>$Price, 'weight' => 0 ,'tax'=>0, 'options' => ['image' => $Image,'typeName'=>$TypeName ,'type'=>$pro->P_Type,'VPriceID'=>$VPriceID,'other_name'=>$pro->P_En_Name,'code'=>$proCC->Barcode] ]);

            if($pro->P_Type == 'Variable_Aggregate'){

                VAPrice::where('id',$VPriceID)->update(['Added'=>1]);
            }else{

                Products::where('id',$Product)->update(['Added'=>1]);
            }

            $Numb=Cart::content()->count();
            $data = array(
                'Count'  => $Numb,
            );
            echo json_encode($data);
        }
    }

    function RemoveCartResturant(Request $request)
    {
        if($request->ajax())
        {
            $output = '';
            $Product = $request->get('Product');
            $SUbV = $request->get('SUbV');
            $VPriceID = $request->get('VPriceID');



            $pro=Products::find($Product);

            $Contents=Cart::content();

            if($pro->P_Type == 'Variable_Aggregate'){

                foreach($Contents as $con){

                    if($con->id == $Product and $con->options->VPriceID == $VPriceID){

                        Cart::update($con->rowId,0);
                    }

                }


            }else{

                foreach($Contents as $con){

                    if($con->id == $Product){

                        Cart::update($con->rowId,0);
                    }

                }
            }



            $Numb=Cart::content()->count();

            if($pro->P_Type == 'Variable_Aggregate'){

                VAPrice::where('id',$VPriceID)->update(['Added'=>0]);
            }else{

                Products::where('id',$Product)->update(['Added'=>0]);
            }

            $data = array(

                'Count'  => $Numb,

            );
            echo json_encode($data);
        }
    }



    //CheckoutResturantSite
    public function CheckoutResturantSite(){
   $x=session()->get('CODE');

        $Def=SalesDefaultData::orderBy('id','desc')->first();
$coin=Coins::find($Def->CountryResturantWebsite);
    $Country=Countris::where('Coin',$coin->id)->orderBy('id','desc')->first();

    $Governrates=Governrate::where('Country',$Country->id)->get();
    $Tables=ResturantTables::get();

       if(!empty(auth()->guard('client')->user()->id)){
    $Addresses=Addressses::where('Customer',auth()->guard('client')->user()->id)->get();
          }else{
             $Addresses='';
          }
         return view('resturant-view.Checkout',get_defined_vars());
    }

        //LoginResturantSite
     public function LoginResturantSite(){
         return view('resturant-view.Login');
    }


    public function PostRegisterResturant(){
        try {
            DB::beginTransaction();

        $data= $this->validate(request(),[
             'Name'=>'required',
             'email'=>'required|email|unique:customers',
             'Phone'=>'required|unique:customers',
             'password'=>'required|min:6',

               ],[
            'Name.required' => trans('admin.nameRequired'),
            'email.required' => trans('admin.emailRequired'),
            'email.email' =>trans('admin.emailEmail'),
            'email.unique' =>trans('admin.emailUnique'),
            'password.required' =>trans('admin.passwordRequired'),
            'password.min' => trans('admin.passwordmin_6'),


         ]);

            $Acc=$this->CreateAccount(request('Name'),request('Name') ,24 ,null);


            $data['Date']=date('Y-m-d');
        $data['Name']=request('Name');
        $data['NameEn']=request('Name');
        $data['Price_Level']=1;
        $data['Phone']=request('Phone');
        $data['email']=request('email');
        $data['password']=bcrypt(request('password'));
        $data['country']=request('country');
    $data['Account']=$Acc;
     Customers::create($data);
            DB::commit();
             session()->flash('success',trans('admin.Registerd_Successfully'));
             return back();

        }catch(\Exception $ex){

            $MODEL=Customers::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Customers::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

       public function PostLoginResturantSite(){

           try {
               DB::beginTransaction();

       if(auth()->guard('client')->attempt(['email'=>request('Email'),'password'=>request('Password')])){
           DB::commit();
          return redirect('/');

       }else{
           DB::rollBack();
          session()->flash('error',trans('admin.incorrect_information_login'));
       	 return back();
       }

           }catch(\Exception $ex){

               $MODEL=Customers::class;
               DB::rollBack();
               Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

               session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
               return back();

           }catch(\Error $ex){


               $MODEL=Customers::class;
               DB::rollBack();
               Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

               session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
               return back();

           }


    }

         public function LogoutResturantSite(){
            Cart::destroy();
    auth()->guard('client')->logout();

            Session::forget('TABLE_ID');

	     return redirect('/');

 }

     public function ForgotResturantSite(){
         return view('resturant-view.Forget');
    }

     public function PostForgoResturanttSite(){

         try {
             DB::beginTransaction();
         $admin = Customers::where('email',request('Email'))->first();
               if(!empty($admin)){


                   $code=rand(10,10000);
                   Customers::where('id',$admin->id)->update(['code'=>$code]);

                 Mail::to($admin->Email)->send(new UserResetPassword(['data'=>$admin]));
                   DB::commit();
                   session()->flash('success',trans('admin.Reset_Password'));
                    return view('resturant-view.VerifyCode',['admin'=>$admin]);

               }else{
                   DB::rollBack();
                session()->flash('success',trans('admin.WrongEmail'));
  return back();

               }
         }catch(\Exception $ex){

             $MODEL=Customers::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=Customers::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }



        }

  public function PostResturantCodeSite(){

      try {
          DB::beginTransaction();
         $admin = Customers::where('id',request('user'))->first();
               if($admin->code == request('code')){

                   Customers::where('id',$admin->id)->update(['code'=>null]);
                   DB::commit();
                    return view('resturant-view.ResetPassword',['admin'=>$admin]);

               }else{
                   DB::rollBack();
                session()->flash('error',trans('admin.WrongCode'));
                return view('resturant-view.VerifyCode',['admin'=>$admin]);

               }

      }catch(\Exception $ex){

          $MODEL=Customers::class;
          DB::rollBack();
          Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

          session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
          return back();

      }catch(\Error $ex){


          $MODEL=Customers::class;
          DB::rollBack();
          Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

          session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
          return back();

      }



  }

     public function PostResturantResetPassword(){

         try {
             DB::beginTransaction();
        $data= $this->validate(request(),[

             'Password'=>'required|min:6|same:confirm',

               ],[

            'Password.required' =>trans('admin.passwordRequired'),
            'Password.min' => trans('admin.passwordmin_6'),
            'Password.same' => trans('admin.passwordsame'),

         ]);


         $data['password']=bcrypt(request('Password'));

         Customers::where('id',request('user'))->update($data);

          if(auth()->guard('client')->attempt(['email'=>request('Email'),'password'=>request('Password')])){
              DB::commit();
          return redirect('/');

       }
         }catch(\Exception $ex){

             $MODEL=Customers::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=Customers::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }



     }


    //My Account
  public function MyAccountResturantSite(){
         $User=Customers::find(auth()->guard('client')->user()->id);
      $Addresses=Addressses::where('Customer',auth()->guard('client')->user()->id)->get();
      $Countris=Countris::all();
      $Governrates=Governrate::where('Country',auth()->guard('client')->user()->country)->get();
      $Orders=SalesOrder::where('Client',auth()->guard('client')->user()->Account)->paginate(9);
         return view('resturant-view.MyAccount',get_defined_vars());
    }

     public function UpdateAccountResturant(){
         try {
             DB::beginTransaction();
        $data= $this->validate(request(),[
             'Name'=>'required',
              'email'=>'required|email|unique:customers,email,'.auth()->guard('client')->user()->id,
             'Phone'=>'required|unique:customers,Phone,'.auth()->guard('client')->user()->id,

               ],[
            'Name.required' => trans('admin.nameRequired'),
            'country.required' => trans('admin.countryRequired'),
            'email.required' => trans('admin.emailRequired'),
            'email.email' =>trans('admin.emailEmail'),
            'email.unique' =>trans('admin.emailUnique'),

         ]);


         $data['Name']=request('Name');
         $data['NameEn']=request('Name');
       $data['Phone']=request('Phone');
    $data['email']=request('email');
    $data['country']=request('country');

         Customers::where('id',auth()->guard('client')->user()->id)->update($data);
  DB::commit();
             session()->flash('success',trans('admin.Updated'));
             return back();
     }catch(\Exception $ex){

$MODEL=Customers::class;
DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
return back();

}catch(\Error $ex){


    $MODEL=Customers::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}



    }

     public function UpdatePasswordResturant(){
         try {
             DB::beginTransaction();
        $data= $this->validate(request(),[

             'password'=>'required|min:6|same:Confirm_Password',

               ],[

            'password.required' =>trans('admin.passwordRequired'),
            'password.min' => trans('admin.passwordmin_6'),
            'password.same' => trans('admin.passwordsame'),

         ]);

         $user= Customers::find(auth()->guard('client')->user()->id);



             if (Hash::check(request('CurrentPassword'), $user->password)) {

                       $data['password']=bcrypt(request('password'));

                Customers::where('id',auth()->guard('client')->user()->id)->update($data);
                 DB::commit();
                       session()->flash('success',trans('admin.Updated'));
             return back();

             }else{
                 DB::rollBack();
                         session()->flash('error',trans('admin.CurrentPassWrong'));
             return back();
             }



}catch(\Exception $ex){

    $MODEL=Customers::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}catch(\Error $ex){


    $MODEL=Customers::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}




    }


     public function EditMyAddressResturant(){

         try {
             DB::beginTransaction();

            $Addr['Address_Name']=request('Address_Name');
            $Addr['Street']=request('StreetAdd');
            $Addr['Special_Mark']=request('Special_MarkAdd');
            $Addr['Buliding']=request('BulidingAdd');
            $Addr['Floor']=request('FloorAdd');
            $Addr['Flat']=request('FlatAdd');
            $Addr['Details']=request('Address_DetailsAdd');
            $Addr['Location']=request('LocationAdd');
            $Addr['Governrate']=request('GovernrateAdd');
            $Addr['City']=request('CityAdd');
            $Addr['Place']=request('PlaceAdd');


           Addressses::where('id',request('ID'))->update($Addr);
      DB::commit();
             session()->flash('success',trans('admin.Updated'));
             return back();
}catch(\Exception $ex){

    $MODEL=Customers::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}catch(\Error $ex){


    $MODEL=Customers::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}



    }
     public function UpdateAddressResturant(){
         try {
             DB::beginTransaction();


            Addressses::where('Customer',auth()->guard('client')->user()->id)->delete();

            $Addr['Address_Name']=request('Address_Name');
            $Addr['Street']=request('StreetAdd');
            $Addr['Special_Mark']=request('Special_MarkAdd');
            $Addr['Buliding']=request('BulidingAdd');
            $Addr['Floor']=request('FloorAdd');
            $Addr['Flat']=request('FlatAdd');
            $Addr['Details']=request('Address_DetailsAdd');
            $Addr['Location']=request('LocationAdd');
            $Addr['Governrate']=request('GovernrateAdd');
            $Addr['City']=request('CityAdd');
            $Addr['Place']=request('PlaceAdd');
            $Addr['Customer']=auth()->guard('client')->user()->id;

           Addressses::create($Addr);
      DB::commit();
             session()->flash('success',trans('admin.Updated'));
             return back();
}catch(\Exception $ex){

    $MODEL=Customers::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}catch(\Error $ex){


    $MODEL=Customers::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}



    }


    public function DeleteMyAddressResturant($id){
        try {
            DB::beginTransaction();
            $del=Addressses::find($id);
            $del->delete();
                  DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
}catch(\Exception $ex){

    $MODEL=Customers::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}catch(\Error $ex){


    $MODEL=Customers::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}



}


//Place Order
    public function PlaceOrderResturant(Average $average){


        try {
            DB::beginTransaction();

            $Carts=Cart::content();

            $DEEF=SalesDefaultData::latest('id')->first();
            $Def=SalesDefaultData::latest('id')->first();
            $coin=Coins::find($Def->CountryResturantWebsite);
            $Country=Countris::where('Coin',$coin->id)->latest('id')->first();
            if(!empty(auth()->guard('client')->user()->id)){
            $Client=AcccountingManual::where('id',auth()->guard('client')->user()->Account)->first()->id;
        }else{
            $Client=$DEEF->Client;
        }
        $TotQty=0;
        foreach($Carts as $cart){
            $TotQty += $cart->qty ;
        }

        $ID = DB::table('sales_orders')->insertGetId(
            array(
                'Date' => date('Y-m-d'),
                'Draw' => $Country->Coin()->first()->Draw,
                'Payment_Method' =>request('Payment_Method'),
                'Status' =>1,
                'Refernce_Number' => null,
                'Note' => null,
                'Product_Numbers' => Cart::content()->count(),
                'Total_Qty' => $TotQty,
                'Total_Discount' => 0,
                'Total_BF_Taxes' => request('Total_Price'),
                'Total_Taxes' => 0,
                'Total_Price' => request('Total_Price'),
                'Pay' => request('Total_Price'),
                'CuponCode' => request('CuponCode'),
                'Shipping' => request('Shipping'),
                'Order_Type' => 2,
                'Name' => request('Name'),
                'Email' => request('Email'),
                'Phone' => request('Phone'),
                'OtherPhone' => request('OtherPhone'),
                'Address_Name' => request('Address_Name'),
                'Special_MarkAdd' => request('Special_MarkAdd'),
                'StreetAdd' => request('StreetAdd'),
                'BulidingAdd' => request('BulidingAdd'),
                'FloorAdd' => request('FloorAdd'),
                'FlatAdd' => request('FlatAdd'),
                'Governrate' => request('Governrate'),
                'City' => request('City'),
                'Place' => request('Place'),
                'LocationAdd' => request('LocationAdd'),
                'Address_DetailsAdd' => request('Address_DetailsAdd'),
                'Safe' => $Country->Safe,
                'Later_Due' => null,
                'Sale_Date' => null,
                'ToSales' => 0,
                'Client' => $Client,
                'Delegate' =>null,
                'Executor' =>null,
                'Store' => $Country->Store,
                'Coin' => $Country->Coin,
                'Cost_Center' =>null,
                'presenter' => null,
                'annual_interest' =>null,
                'monthly_installment' => null,
                'Years_Number' =>null,
                'total' => null,
                'Quote' => null,
                'installment_Num' => null,
                'Date_First_installment' => null,
                'User' => 1,
                'Time' => date("h:i:s a", time()),
                'Delegate_Recived' =>0,
                'Delegate_Recived_Time' =>null,
                'To_Sales_Time' =>null,
                'Cancel_Order' =>0,
                'Cancel_Order_Time' =>null,
                'Hold_Qty' =>0,
                'TakeawayStatus' => 0,
                'TakeawayTime' => null,
                'Witer' => null,
                'KitchenEnd' => 0,
                'KitchenEndTime' => null,
                'RecivedOrder' => 0,
                'RecivedOrderTime' => null,
                'Delivery_Status' =>0,
                'DeliveryTime' => null,
                'ResturantOrderType' => request('Order_Type'),
                'Table' => request('Table'),
                'Total_Wight_Bill' =>0,
                'Edit' => 0,
                'Delete' => 0,
                'Edit_New_Code' => 0,
                'Current_Credit' =>0,
                'Total_Net' => request('Total_Price'),
                'Residual' => 0,
                'ProfitPrecent' =>0,
                'Total_Cost' =>0 ,
                'InstallCompany' =>null,
                'ContractNumber' => null,
                'PayFees' => null,
                'ServiceFee' => null,
                'CompanyPrecent' => null,
                'DiscountBill' => 0,
                'File' => null,
                'Hold' =>1,
                'Branch' => null,
                'CustomerGroup' => null,
                'Ship' =>null ,
                'Check_Type' =>null,
                'Due_Date' =>null ,
                'TaxBill' =>null ,
                'TaxOnTotal' =>null ,
                'TaxOnTotalType' =>null ,
                'ProfitTax' =>null ,
                'TaxCode' => null,
                'Check_Number' =>null ,
                'Client_Address' => null,
                'Delivery' => null,
                'Shift_Code' =>null,


            )
        );







        $CodeT=SalesOrder::findOrFail($ID)->Code;

        $notii['Date']=date('Y-m-d');
        $notii['Status']=0;
        $notii['Noti_Ar_Name']='طلب مبيعات مطعم';
        $notii['Noti_En_Name']='Resturant Online Order';
        $notii['Type']='طلب مبيعات مطعم';
        $notii['TypeEn']='Resturant Online Order';
        $notii['Type_Code']=$CodeT;
        $notii['Emp']= null;
        $notii['Client']=$Client;
        $notii['Product']=null;
        $notii['Store']=$Country->Store;
        $notii['Safe']=$Country->Safe;
        Notifications::create($notii);

        notify()->success(trans('admin.Online_Order'));

        foreach($Carts as $cart){
            $proCC=ProductUnits::where('Product',$cart->id)->where('Def',1)->first();
            $pp=ProductUnits::where('Product',$cart->id)->where('Unit',$proCC->Unit)->first();
            $plow=ProductUnits::where('Product',$cart->id)->where('Rate',1)->first();
            $rr = ProductUnits::where("Unit",$proCC->Unit)->where('Product',$cart->id)->first();
            $SS=Stores::find($Country->Store);
            $PSS=Products::find($cart->id);
            $prooooo=Products::find($cart->id);
            $costPrice=$average->AverageCostGetUnit($cart->id,$cart->options->code,$Country->Store,$proCC->Unit);

            $ii=VAPrice::find($cart->options->VPriceID);

            VAPrice::where('id',$cart->options->VPriceID)->update(['Added'=>0]);

            if(!empty($ii)){
                $VV=$ii->SubV;
            }else{

                $VV='';
            }


            Products::where('id',$cart->id)->update(['Added'=>0]);

            $uu['Product_Code']=$cart->options->code;
            $uu['P_Ar_Name']=$cart->name;
            $uu['P_En_Name']=$cart->options->other_name;
            $uu['V_Name']=null;
            $uu['VV_Name']=null;
            $uu['Original_Qty']=$cart->qty;
            $uu['Qty']=$cart->qty;
            $uu['AvQty']=0;
            $uu['Price']=$cart->price;
            $uu['Discount']=0;
            $uu['Tax']=1;
            $uu['Total_Bf_Tax']=$cart->total;
            $uu['Total_Tax']=0;
            $uu['Total']=$cart->total;
            $uu['Store']=$Country->Store;
            $uu['Product']=$cart->id;
            $uu['Unit']=$proCC->Unit;
            $uu['Exp_Date']=null;
            $uu['SalesOrder']=$ID;
            $uu['V1']=null;
            $uu['V2']=null;
            $uu['Patch_Number']=null;
            $uu['SubVID']=$VV;

            $uu['TDiscount']=0;
            $uu['Total_Net']=$cart->price * $cart->qty ;
            $uu['SalesProDesc']=null;
            $uu['SmallCode']=$plow->Barcode;
            $uu['weight']=0;
            $uu['Total_Wight']=0;
            $uu['SmallQty']=$cart->qty * $pp->Rate;
            $uu['UnitRate']=$pp->Rate;
            $uu['Date']=date('Y-m-d');
            $uu['Branch']=$SS->Branch;
            $uu['Group']=$PSS->Group;
            $uu['Brand']=$PSS->Brand;
            $uu['CostPrice']=$costPrice;
            $uu['TotCostNew']=$costPrice * $cart->qty;

            ProductSalesOrder::create($uu);



        }

        Cart::destroy();
            DB::commit();
        session()->flash('success',trans('admin.Order_Successfully'));
        return redirect('/');

        }catch(\Exception $ex){

            $MODEL=SalesOrder::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=SalesOrder::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }





}
