<?php

namespace App\Http\Controllers;

use App\Models\AcccountingManual;
use App\Models\Addressses;
use App\Models\Admin;
use App\Models\AssemblyProducts;
use App\Models\Coins;
use App\Models\CompanyData;
use App\Models\Countris;
use App\Models\CouponCode;
use App\Models\Customers;
use App\Models\CustomersGroup;
use App\Models\DefaultDataShowHide;
use App\Models\Employess;
use App\Models\GeneralDaily;
use App\Models\IncomChecks;
use App\Models\InstallmentCompanies;
use App\Models\InstallmentDates;
use App\Models\Journalizing;
use App\Models\JournalizingDetails;
use App\Models\MoreProductsHall;
use App\Models\Notifications;
use App\Models\OutcomManufacturingModel;
use App\Models\ProductMoves;
use App\Models\Products;
use App\Models\ProductSales;
use App\Models\ProductSalesOrder;
use App\Models\ProductsPurchases;
use App\Models\ProductsQty;
use App\Models\ProductsStartPeriods;
use App\Models\ProductsStoresTransfers;
use App\Models\ProductUnits;
use App\Models\ReciptVoucher;
use App\Models\ReciptVoucherDetails;
use App\Models\RemoveProductsHall;
use App\Models\ResturantAbout;
use App\Models\ResturantBlogs;
use App\Models\ResturantCuponCode;
use App\Models\ResturantGallery;
use App\Models\ResturantHome;
use App\Models\ResturantPrivacy;
use App\Models\ResturantReservations;
use App\Models\ResturantReviews;
use App\Models\ResturantSliders;
use App\Models\ResturantSocial;
use App\Models\ResturantStyle;
use App\Models\ResturantTables;
use App\Models\ResturantTerms;
use App\Models\ResturantVideoSection;
use App\Models\Sales;
use App\Models\SalesDefaultData;
use App\Models\SalesOrder;
use App\Models\Shifts;
use App\Models\StoreCountSales;
use App\Models\Stores;
use App\Models\StoresMoves;
use App\Models\Taxes;
use App\Models\UsersMoves;
use App\Models\VAPrice;
use App\Models\Vendors;
use Illuminate\Http\Request;

class ResturantAppController extends Controller
{


    public function __construct(Request $request) {

        $header =!empty( $request->header('lang')) ? $request->header('lang') : "ar";
        app()->setLocale($header);

    }





    //========================= Resturant ==============================================================



//Resturant Slider
    public function ResturantSlider(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();

        $types=ResturantSliders::where('Status',1)->where('Type',1)->get();



        if($lang == 'ar'){


            foreach($types as $ty){

                array_push($Array,[
                    'title'=>$ty->Arabic_Title,
                    'desc'=>$ty->Arabic_Desc,
                    'image'=>URL::to($ty->Image),

                ]);

            }

        }else{



            foreach($types as $ty){

                array_push($Array,[
                    'title'=>$ty->English_Title,
                    'desc'=>$ty->English_Desc,
                    'image'=>URL::to($ty->Image),

                ]);

            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }

//Resturant About
    public function ResturantAbout(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();


        $item=ResturantAbout::orderBy('id','desc')->first();




        if($lang == 'ar'){



            array_push($Array,[
                'image_1'=>URL::to($item->Image_1),
                'image_2'=>URL::to($item->Image_2),
                'title'=>$item->Arabic_Title,
                'desc'=>$item->Arabic_Desc,


            ]);




        }else{

            array_push($Array,[
                'image_1'=>URL::to($item->Image_1),
                'image_2'=>URL::to($item->Image_2),
                'title'=>$item->English_Title,
                'desc'=>$item->English_Desc,


            ]);


        }




        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array[0],

        ]);


    }

//ResturantHomeTwo
    public function ResturantHomeTwo(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();


        $item=ResturantHome::orderBy('id','desc')->first();


        if($lang == 'ar'){



            array_push($Array,[
                'image_1'=>URL::to($item->Image_1),
                'image_2'=>URL::to($item->Image_2),
                'image_3'=>URL::to($item->Image_3),
                'image_4'=>URL::to($item->Image_4),
                'title'=>$item->Arabic_Title,
                'sup_title'=>$item->Arabic_Sub_Title,
                'year'=>$item->Year,


            ]);




        }else{

            array_push($Array,[
                'image_1'=>URL::to($item->Image_1),
                'image_2'=>URL::to($item->Image_2),
                'image_3'=>URL::to($item->Image_3),
                'image_4'=>URL::to($item->Image_4),
                'title'=>$item->English_Title,
                'sup_title'=>$item->English_Sub_Title,
                'year'=>$item->Year,


            ]);


        }




        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array[0],

        ]);


    }

//ResturantVideo
    public function ResturantVideo(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();


        $item=ResturantVideoSection::orderBy('id','desc')->first();


        if($lang == 'ar'){



            array_push($Array,[
                'image_1'=>URL::to($item->Image_1),
                'image_2'=>URL::to($item->Image_2),
                'image_3'=>URL::to($item->Image_3),
                'image_4'=>URL::to($item->Image_4),
                'title_image'=>URL::to($item->Title_Image),
                'icon'=>URL::to($item->Icon),
                'background'=>URL::to($item->BG_Image),
                'video_link'=>$item->Video_Link,
                'number_1'=>$item->Number_1,
                'title_1'=>$item->Arabic_Title_1,
                'number_2'=>$item->Number_2,
                'title_2'=>$item->Arabic_Title_2,
                'number_3'=>$item->Number_3,
                'title_3'=>$item->Arabic_Title_3,
                'number_4'=>$item->Number_4,
                'title_4'=>$item->Arabic_Title_4,



            ]);




        }else{

            array_push($Array,[
                'image_1'=>URL::to($item->Image_1),
                'image_2'=>URL::to($item->Image_2),
                'image_3'=>URL::to($item->Image_3),
                'image_4'=>URL::to($item->Image_4),
                'title_image'=>URL::to($item->Title_Image),
                'icon'=>URL::to($item->Icon),
                'background'=>URL::to($item->BG_Image),
                'video_link'=>$item->Video_Link,
                'number_1'=>$item->Number_1,
                'title_1'=>$item->English_Title_1,
                'number_2'=>$item->Number_2,
                'title_2'=>$item->English_Title_2,
                'number_3'=>$item->Number_3,
                'title_3'=>$item->English_Title_3,
                'number_4'=>$item->Number_4,
                'title_4'=>$item->English_Title_4,




            ]);


        }




        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array[0],

        ]);


    }

//Resturant Gallery
    public function ResturantGallery(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();

        $types=ResturantGallery::get();



        if($lang == 'ar'){


            foreach($types as $ty){

                array_push($Array,[

                    'image'=>URL::to($ty->Image),

                ]);

            }

        }else{



            foreach($types as $ty){

                array_push($Array,[

                    'image'=>URL::to($ty->Image),

                ]);

            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }


    //Resturant Reviews
    public function ResturantReviews(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();

        $types=ResturantReviews::get();



        if($lang == 'ar'){


            foreach($types as $ty){

                array_push($Array,[

                    'image'=>URL::to($ty->Image),
                    'name'=>$ty->Arabic_Name,
                    'desc'=>strip_tags($ty->Arabic_Desc),

                ]);

            }

        }else{



            foreach($types as $ty){

                array_push($Array,[

                    'image'=>URL::to($ty->Image),
                    'name'=>$ty->English_Name,
                    'desc'=>strip_tags($ty->English_Desc),

                ]);

            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }



//Resturant Blogs
    public function ResturantBlogs(Request $request){

        $lang = $request->header('lang', '');


        $Array=array();


        $items=ResturantBlogs::all();

        if($lang == 'ar'){


            foreach($items as $item){
                array_push($Array,[
                    'id'=>$item->id,
                    'image'=>URL::to($item->Sub_Image),
                    'date'=>$item->Date,
                    'title'=>$item->Arabic_Title,
                    'desc'=>strip_tags($item->Arabic_Desc),

                ]);
            }



        }else{



            foreach($items as $item){
                array_push($Array,[
                    'id'=>$item->id,
                    'image'=>URL::to($item->Sub_Image),
                    'date'=>$item->Date,
                    'title'=>$item->English_Title,
                    'desc'=>strip_tags($item->English_Desc),

                ]);
            }



        }






        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);


    }

    //Resturant Blogs Details
    public function ResturantBlogsDet(Request $request){

        $lang = $request->header('lang', '');

        $Array=array();


        $item=ResturantBlogs::find(request('article_id'));

        if($lang == 'ar'){


            array_push($Array,[
                'image'=>URL::to($item->Image),
                'date'=>$item->Date,
                'title'=>$item->Arabic_Title,
                'desc'=>strip_tags($item->Arabic_Desc),

            ]);




        }else{




            array_push($Array,[
                'image'=>URL::to($item->Image),
                'date'=>$item->Date,
                'title'=>$item->English_Title,
                'desc'=>strip_tags($item->English_Desc),

            ]);




        }






        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);


    }


//ResturantSocial
    public function ResturantSocial(Request $request){

        $lang = $request->header('lang', '');


        $Array=array();


        $item=ResturantSocial::orderBy('id','desc')->first();



        array_push($Array,[
            'facebook'=>$item->Facebook,
            'twitter'=>$item->Twitter,
            'instagram'=>$item->Instagram,
            'youtube'=>$item->Youtube,
            'snapchat'=>$item->Snapchat,
            'whatsapp'=>$item->Whatsapp,
            'google_plus'=>$item->Google_Plus,
            'linked_in'=>$item->LinkedIn,
            'pinterest'=>$item->Pinterest,
            'telegram'=>$item->Telegram,
            'ios'=>$item->iOS,
            'android'=>$item->Android,

        ]);

        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array[0],

        ]);

    }

    //Terms
    public function ResturantTerms(Request $request){

        $lang = $request->header('lang', '');

        $Array=array();


        $item=ResturantTerms::orderBy('id','desc')->first();

        if($lang == 'ar'){



            array_push($Array,[
                'terms'=>strip_tags($item->Arabic_Desc),

            ]);




        }else{





            array_push($Array,[
                'terms'=>strip_tags($item->English_Desc),

            ]);




        }






        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);


    }

//Polices
    public function ResturantPrivacy(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();


        $item=ResturantPrivacy::orderBy('id','desc')->first();

        if($lang == 'ar'){



            array_push($Array,[
                'policy'=>strip_tags($item->Arabic_Desc),

            ]);




        }else{





            array_push($Array,[
                'policy'=>strip_tags($item->English_Desc),

            ]);




        }






        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);


    }


    //Cupon Check

    public function ResturantCuponsCheck(Request $request){


        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Customers::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if(!empty($admin)){


            $i=ResturantCuponCode::where('Code',request('code'))->first();

            if(!empty($i->id)){

                if($i->Status == 1){

                    return response()->json([
                        'status'=>400,
                        'message'=>trans('admin.Code_Expired'),
                    ]);

                }elseif($i->Expire < date('Y-m-d')){


                    return response()->json([
                        'status'=>400,
                        'message'=>trans('admin.Code_Expired'),
                    ]);

                }else{


                    if(request('code') != NULL){

                        $y=$i->Used + 1 ;

                        if($y == $i->Num){

                            $Status=1;
                        }else{

                            $Status=0;
                        }
                        CouponCode::where('id',$i->id)->update(['Used'=>$y,'Status'=>$Status]);

                    }


                    return response()->json([
                        'status'=>200,
                        'message'=>trans('admin.Correct_Code'),
                        'data'=>$x,
                    ]);

                }


            }else{


                return response()->json([
                    'status'=>400,
                    'message'=>trans('admin.Wrong_Code'),
                ]);


            }












        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }



    //ResturantCompanyData
    public function ResturantCompanyData(Request $request){

        $item=CompanyData::orderBy('id','desc')->first();

        $Array=array();

        if($request->header('lang') == 'ar'){


            array_push($Array,[

                'company_name'=>$item->Name,
                'phone_1'=>$item->Phone1,
                'phone_2'=>$item->Phone2,
                'phone_3'=>$item->Phone3,
                'phone_4'=>$item->Phone4,
                'address'=>$item->Address,
                'logo'=>URL::to($item->Logo_Store),
                'icon'=>URL::to($item->Icon_Store),
                'pdf'=>URL::to($item->PDF),
                'email'=>$item->Email,
                'welcome_word'=>$item->Welcome_Arabic_Word_App,


            ]);


        }else{

            array_push($Array,[

                'company_name'=>$item->NameEn,
                'phone_1'=>$item->Phone1,
                'phone_2'=>$item->Phone2,
                'phone_3'=>$item->Phone3,
                'phone_4'=>$item->Phone4,
                'address'=>$item->AddressEn,
                'logo'=>URL::to($item->Logo_Store),
                'icon'=>URL::to($item->Icon_Store),
                'pdf'=>URL::to($item->PDF),
                'email'=>$item->Email,
                'welcome_word'=>$item->Welcome_English_Word_App,


            ]);

        }





        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);



    }



    //ResturantGroups
    public function ResturantGroups(Request $request){



        $groups=DB::table('items_groups')
            ->whereIn('Store_Show',[1,3])
            ->get();

        $Array=array();

        $lang = $request->header('lang', '');



        foreach($groups as $grop){

            if($lang == 'ar'){
                array_push($Array,[
                    'id'=>$grop->id,
                    'name'=>$grop->Name,
                    'image'=>URL::to($grop->Image),


                ]);

            }else{

                array_push($Array,[
                    'id'=>$grop->id,
                    'name'=>$grop->NameEn,
                    'image'=>URL::to($grop->Image),


                ]);
            }



        }



        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);


    }

//ResturantBranches
    public function ResturantBranches(Request $request){

        $groups=DB::table('brands')
            ->whereIn('Store_Show',[1,3])
            ->get();

        $Array=array();
        $lang = $request->header('lang', '');

        foreach($groups as $grop){

            if($lang == 'ar'){
                array_push($Array,[
                    'id'=>$grop->id,
                    'name'=>$grop->Name,
                    'image'=>URL::to($grop->Image),



                ]);
            }else{

                array_push($Array,[
                    'id'=>$grop->id,
                    'name'=>$grop->NameEn,
                    'image'=>URL::to($grop->Image),



                ]);

            }



        }



        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);



    }


//Resturant Tables
    public function ResturantTables(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();

        $types=ResturantTables::get();



        if($lang == 'ar'){


            foreach($types as $ty){

                array_push($Array,[
                    'name'=>$ty->Arabic_Name,
                    'place'=>$ty->Place_Ar,
                    'chairs_number'=>$ty->Chairs_Num,
                    'table_number'=>$ty->Table_Number,
                ]);

            }

        }else{


            foreach($types as $ty){

                array_push($Array,[
                    'name'=>$ty->English_Name,
                    'place'=>$ty->Place_En,
                    'chairs_number'=>$ty->Chairs_Num,
                    'table_number'=>$ty->Table_Number,

                ]);

            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }


    //ResturantUse
    public function ResturantUse(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();


        $item=ResturantStyle::orderBy('id','desc')->first();


        if($lang == 'ar'){



            array_push($Array,[
                'home'=>$item->Home,
                'menu'=>$item->Menu,
                'pdf'=>$item->PDF,
                'cart'=>$item->Cart,
                'blogs'=>$item->Blogs,
                'gallery'=>$item->Gallery,
                'terms'=>$item->Terms,
                'privacy'=>$item->Privacy,
                'reviews'=>$item->Reviews,
                'reservations'=>$item->Reservations,


            ]);




        }else{

            array_push($Array,[
                'home'=>$item->Home,
                'menu'=>$item->Menu,
                'pdf'=>$item->PDF,
                'cart'=>$item->Cart,
                'blogs'=>$item->Blogs,
                'gallery'=>$item->Gallery,
                'terms'=>$item->Terms,
                'privacy'=>$item->Privacy,
                'reviews'=>$item->Reviews,
                'reservations'=>$item->Reservations,


            ]);


        }




        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array[0],

        ]);


    }

    //ResturantReservations


    public function ResturantReservations(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();

        $types=ResturantReservations::orderBy('id','desc')->get();



        if($lang == 'ar'){


            foreach($types as $ty){

                array_push($Array,[
                    'name'=>$ty->Name,
                    'phone'=>$ty->Phone,
                    'persons'=>$ty->Persons,
                    'date'=>$ty->Date,
                    'time'=>$ty->Time,
                    'message'=>$ty->Message,
                ]);

            }

        }else{


            foreach($types as $ty){

                array_push($Array,[
                    'name'=>$ty->Name,
                    'phone'=>$ty->Phone,
                    'persons'=>$ty->Persons,
                    'date'=>$ty->Date,
                    'time'=>$ty->Time,
                    'message'=>$ty->Message,

                ]);

            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }



    //ResturantAddReservations

    public function ResturantAddReservations(Request $request){



        $lang = $request->header('lang', '');

        $data['Name']=request('name');
        $data['Phone']=request('phone');
        $data['Persons']=request('persons');
        $data['Date']=request('date');
        $data['Time']=request('time');
        $data['Message']=request('message');
        $data['Approve']=0;

        ResturantReservations::create($data);


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
        ]);









    }



    //ResturantProducts

    public function ResturantProducts(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();
        $ArrayV=array();
        $Products=Products::whereIn('Store_Show',[1,3])
            ->whereIn('P_Type',['Completed','Variable_Aggregate'])
            ->orderBy('id','desc')->get();





        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $coin=Coins::find($Def->CountryResturantWebsite);

        $Country=Countris::where('Coin',$coin->id)->orderBy('id','desc')->first();


        if($lang == 'ar'){







            foreach($Products as $pro){


                if($pro->P_Type == 'Variable_Aggregate'){

                    $ProVira=VAPrice::where('Product',$pro->id)->get();

                    foreach($ProVira as $vv){

                        if(!empty($vv->Offer_Price) and $vv->Offer_Price != 0){
                            $vPrice=$vv->Offer_Price;
                        }else{
                            $vPrice=$vv->Price;
                        }


                        array_push($ArrayV,[

                            'v_name'=>$vv->SubV()->first()->Name,
                            'v_id'=>$vv->id,
                            'sub_v_id'=>$vv->SubV,
                            'v_price'=>$vPrice,



                        ]);


                    }


                }




                $Price=ProductUnits::where('Product',$pro->id)->where('Def',1)->first();


                if($pro->Offer == 1){
                    $price=round($Price->Price / $Country->Coin()->first()->Draw) ;
                    $offer_price=round($pro->OfferPrice / $Country->Coin()->first()->Draw);
                }else{

                    $price=round($Price->Price / $Country->Coin()->first()->Draw);
                    $offer_price=0;

                }


                array_push($Array,[
                    'image_1'=>URL::to($pro->Image),
                    'image_2'=>URL::to($pro->Image2),
                    'name'=>$pro->P_Ar_Name,
                    'symbol'=>$Country->Coin()->first()->Symbol,
                    'offer_price'=>$offer_price,
                    'price'=>$price,
                    'rate'=>$pro->rate,
                    'id'=>$pro->id,
                    'type'=>$pro->P_Type,
                    'virables'=>$ArrayV,


                ]);

            }

        }else{


            foreach($Products as $pro){



                if($pro->P_Type == 'Variable_Aggregate'){

                    $ProVira=VAPrice::where('Product',$pro->id)->get();

                    foreach($ProVira as $vv){

                        if(!empty($vv->Offer_Price) and $vv->Offer_Price != 0){
                            $vPrice=$vv->Offer_Price;
                        }else{
                            $vPrice=$vv->Price;
                        }


                        array_push($ArrayV,[

                            'v_name'=>$vv->SubV()->first()->NameEn,
                            'v_id'=>$vv->id,
                            'sub_v_id'=>$vv->SubV,
                            'v_price'=>$vPrice,



                        ]);


                    }


                }





                $Price=ProductUnits::where('Product',$pro->id)->where('Def',1)->first();


                if($pro->Offer == 1){
                    $price=round($Price->Price / $Country->Coin()->first()->Draw) ;
                    $offer_price=round($pro->OfferPrice / $Country->Coin()->first()->Draw);
                }else{

                    $price=round($Price->Price / $Country->Coin()->first()->Draw);
                    $offer_price=0;

                }


                array_push($Array,[
                    'image_1'=>URL::to($pro->Image),
                    'image_2'=>URL::to($pro->Image2),
                    'name'=>$pro->P_En_Name,
                    'symbol'=>$Country->Coin()->first()->Symbol,
                    'offer_price'=>$offer_price,
                    'price'=>$price,
                    'rate'=>$pro->rate,
                    'id'=>$pro->id,
                    'type'=>$pro->P_Type,
                    'virables'=>$ArrayV,

                ]);

            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);


    }




    //PlaceOrder
    public function ResturantPlaceOrder(Request $request){


        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Customers::where('token',$x)->first();
        $lang = $request->header('lang', '');
        if(!empty($admin)){

            $Client=AcccountingManual::where('id',$admin->Account)->first();


            $Def=SalesDefaultData::orderBy('id','desc')->first();
            $coin=Coins::find($Def->CountryResturantWebsite);

            $Country=Countris::where('Coin',$coin->id)->orderBy('id','desc')->first();
            $DEEF=SalesDefaultData::orderBy('id','desc')->first();

            $ID = DB::table('sales_orders')->insertGetId(
                array(
                    'Date' => date('Y-m-d'),
                    'Draw' => $Country->Coin()->first()->Draw,
                    'Payment_Method' => 'Later',
                    'Status' => 1,
                    'Refernce_Number' => null,
                    'Note' => null,
                    'Product_Numbers' => request('product_numbers'),
                    'Total_Qty' => request('total_qty'),
                    'Total_Discount' => 0,
                    'Total_BF_Taxes' => request('total_price'),
                    'Total_Taxes' => 0,
                    'Total_Price' => request('total_price'),
                    'Pay' => request('total_price'),
                    'CuponCode' => request('cupon_code'),
                    'Shipping' => request('shipping'),
                    'Delivery_Status' => 0,
                    'Order_Type' => 1,
                    'Name' => request('name'),
                    'Email' => request('email'),
                    'Phone' => request('phone'),
                    'OtherPhone' => request('other_phone'),
                    'Address_Name' => request('address_name'),
                    'Special_MarkAdd' => request('special_mark'),
                    'StreetAdd' => request('street'),
                    'BulidingAdd' => request('buliding'),
                    'FloorAdd' => request('floor'),
                    'FlatAdd' => request('flat'),
                    'Governrate' => request('governrate'),
                    'City' => request('city'),
                    'Place' => request('place'),
                    'LocationAdd' => request('location'),
                    'Address_DetailsAdd' => request('address_details'),
                    'Safe' => $Country->Safe,
                    'Later_Due' => null,
                    'Sale_Date' => null,
                    'ToSales' => 0,
                    'Client' => $Client->id,
                    'Delegate' =>null,
                    'Executor' =>null,
                    'Store' => $Country->Store,
                    'Coin' => $Country->Coin,
                    'Cost_Center' =>null,
                    'presenter' => null,
                    'annual_interest' =>null,
                    'monthly_installment' => null,
                    'Years_Number' =>null,
                    'total' => null,
                    'Quote' => null,
                    'installment_Num' => null,
                    'Date_First_installment' => null,
                    'User' => 1,
                    'Time' => date("h:i:s a", time()),
                    'Delegate_Recived' =>0,
                    'Delegate_Recived_Time' =>null,
                    'To_Sales_Time' =>null,
                    'Cancel_Order' =>0,
                    'Cancel_Order_Time' =>null,
                    'Hold_Qty' =>0,
                    'TakeawayStatus' => 0,
                    'TakeawayTime' => null,
                    'Witer' => null,
                    'KitchenEnd' => 0,
                    'KitchenEndTime' => null,
                    'RecivedOrder' => 0,
                    'RecivedOrderTime' => null,
                    'Delivery_Status' =>0,
                    'DeliveryTime' => null,
                    'ResturantOrderType' => request('order_type'),
                    'Table' => request('table'),

                )
            );


            $c= DB::select("SELECT last_value FROM sales_orders_arr_seq");
            $f=array_shift($c);
            $z=end($f);

            $CodeT=$z;


            $notii['Date']=date('Y-m-d');
            $notii['Status']=0;
            $notii['Noti_Ar_Name']='طلب مبيعات مطعم';
            $notii['Noti_En_Name']='Resturant Online Order';
            $notii['Type']='طلب مبيعات مطعم';
            $notii['TypeEn']='Resturant Online Order';
            $notii['Type_Code']=$CodeT;
            $notii['Emp']= null;
            $notii['Client']=$Client->id;
            $notii['Product']=null;
            $notii['Store']=$Country->Store;
            $notii['Safe']=$Country->Safe;
            Notifications::create($notii);

            notify()->success(trans('admin.Online_Order'));





            $P_Code=request('product_code');
            $qty=request('qty');
            $AvQty=request('av_qty');
            $price=request('price');
            $total=request('total');
            $Product=request('product_id');
            $VID=request('v_id');

            for($i=0 ; $i < count($P_Code) ; $i++){

                $QTY=ProductsQty::
                where('Product',$Product[$i])
                    ->where('Store',$Country->Store)
                    ->where('P_Code',$P_Code[$i])
                    ->first();


                if(empty($QTY)){

                    $QTY=ProductsQty::
                    where('Product',$Product[$i])
                        ->where('Store',$Country->Store)
                        ->where('PP_Code',$P_Code[$i])
                        ->first();

                    if(empty($QTY)){
                        $QTY=ProductsQty::
                        where('Product',$Product[$i])
                            ->where('Store',$Country->Store)
                            ->where('PPP_Code',$P_Code[$i])
                            ->first();

                        if(empty($QTY)){
                            $QTY=ProductsQty::
                            where('Product',$Product[$i])
                                ->where('Store',$Country->Store)
                                ->where('PPPP_Code',$P_Code[$i])
                                ->first();

                        }


                    }


                }



                $ii=VAPrice::find($VID[$i]);


                if(!empty($ii)){
                    $VV=$ii->SubV;
                }else{

                    $VV='';
                }



                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$QTY->P_Ar_Name;
                $uu['P_En_Name']=$QTY->P_En_Name;
                $uu['V_Name']=$QTY->V_Name;
                $uu['VV_Name']=$QTY->VV_Name;
                $uu['Original_Qty']=$qty[$i];
                $uu['Qty']=$qty[$i];
                $uu['AvQty']=0;
                $uu['Price']=$price[$i];
                $uu['Discount']=0;
                $uu['Tax']=1;
                $uu['Total_Bf_Tax']=$total[$i];
                $uu['Total_Tax']=0;
                $uu['Total']=$total[$i];
                $uu['Store']=$Country->Store;
                $uu['Product']=$Product[$i];
                $uu['Unit']=$QTY->Unit;
                $uu['Exp_Date']=null;
                $uu['SalesOrder']=$ID;
                $uu['V1']=null;
                $uu['V2']=null;
                $uu['Patch_Number']=null;
                $uu['SubVID']=$VV;
                ProductSalesOrder::create($uu);




            }

            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
            ]);
        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }








    }



    //  ==== . Resturant POS ============



    //SerachProductFilter
    public function SerachResturantProductFilter(Request $request){


        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');
        if(!empty($admin)){

            $Array=array();

            $search = $request->get('search');
            $store = $request->get('store_id');
            $client = $request->get('client_id');


            $Prods=ProductsQty::
            where('P_Ar_Name','ILIKE', "%{$search}%")
                ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                ->orWhere('V_Name','ILIKE', "%{$search}%")
                ->orWhere('VV_Name','ILIKE', "%{$search}%")
                ->orWhere('P_Code','ILIKE', "%{$search}%")
                ->orWhere('PP_Code','ILIKE', "%{$search}%")
                ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                ->get();

            $Assembls=Products::
            where('P_Ar_Name','ILIKE', "%{$search}%")
                ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                ->get();

            $data =ProductUnits::
            where('Barcode', $search)
                ->get();




            foreach($Prods as $rows){

                $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                $purchs=ProductsPurchases::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total_Bf_Tax');
                $countPurchs=ProductsPurchases::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');
                $storesTransfer=ProductsStoresTransfers::where('Product',$rows->Product)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');
                $storesTransferCount=ProductsStoresTransfers::where('Product',$rows->Product)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallTrans_Qty');
                $purchsStart=ProductsStartPeriods::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');
                $countStart=ProductsStartPeriods::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');
                $OUTCOME=OutcomManufacturingModel::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Cost');
                $countOUTCOME=OutcomManufacturingModel::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');
                $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();

                if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME)){

                    $Collect=$purchs + $storesTransfer + $purchsStart + $OUTCOME ;
                    $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;

                    if($CollectCount != 0){
                        $ty= $Collect /  $CollectCount ;

                        $COSTpr=number_format((float)abs($ty), 2, '.', '') * $rr->Rate;



                    }else{

                        $COSTpr=$Collect * $rr->Rate;
                    }

                }else{
                    $COSTpr=$rr->Price;

                }




                $Ser=ProductSalesOrder::where('Product',$rows->Product)->where('Product_Code',$rows->P_Code)->first();

                if($rows->Qty > 0){
                    if($rows->Store == $store){

                        $Stores=Stores::all();

                        $units=ProductUnits::where('Product',$rows->Product)->get();
                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $x = ProductsQty::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();

                        $Cli=Customers::where('Account',$client)->first();

                        if(!empty($Cli)){

                            if($Cli->Price_Level == 1){

                                $pr= $rr->Price ;

                            }elseif($Cli->Price_Level == 2){

                                if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                    $pr= $rr->Price_Two ;

                                }else{

                                    $pr= $rr->Price ;

                                }

                            }elseif($Cli->Price_Level == 3){

                                if(!empty($rr->Price_Three) and $rr->Price_Three != 0 ){

                                    $pr= $rr->Price_Three ;

                                }else{

                                    $pr= $rr->Price ;

                                }

                            }

                        }else{


                            $Vend=Vendors::where('Account',$client)->first();

                            if(!empty($Vend)){
                                if($Vend->Price_Level == 1){

                                    $pr= $rr->Price ;

                                }elseif($Vend->Price_Level == 2){

                                    if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                        $pr= $rr->Price_Two ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }elseif($Vend->Price_Level == 3){

                                    if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                        $pr= $rr->Price_Three ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }
                            }else{


                                $EMPO=Employess::where('Account_Emp',$client)->first();
                                if(!empty($EMPO)){
                                    if($EMPO->Price_Level == 1){

                                        $pr= $rr->Price ;

                                    }elseif($EMPO->Price_Level == 2){

                                        if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                            $pr= $rr->Price_Two ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }elseif($EMPO->Price_Level == 3){

                                        if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                            $pr= $rr->Price_Three ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }
                                }else{

                                    $pr=$rr->Price;
                                }

                            }


                        }

                        if($rows->Original != null){

                            $pr=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            if($lang == 'ar'){
                                $brandd=$rows->Product()->first()->Brand()->first()->Name;
                            }else{

                                $brandd=$rows->Product()->first()->Brand()->first()->NameEn;
                            }
                        }else{

                            $brandd="";

                        }

                        $st=Stores::find($store);

                        $show=DefaultDataShowHide::orderBy('id','desc')->first();
                        if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){

                            if($rows->Product()->first()->Status == 0){

                                if($show->Group_Brand == 1){

                                    if($lang == 'ar'){
                                        $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                    }else{
                                        $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->NameEn.')';

                                    }
                                }else{
                                    $ShowGrBr='';
                                }

                                if(!empty($Cli)){

                                    if(!empty($Cli->Group)){
                                        $nwD=CustomersGroup::find($Cli->Group);

                                        $DES= $nwD->Discount ;

                                    }else{
                                        $DES=0;

                                    }

                                }else{
                                    $DES=0;
                                }

                                if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                    $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                }else{

                                    $Higher=0;
                                }

                                if($lang == 'ar'){
                                    $UName=$rr->Unit()->first()->Name;
                                    $SName=$st->Name;

                                }else{

                                    $UName=$rr->Unit()->first()->NameEn;
                                    $SName=$st->NameEn;
                                }

                                array_push($Array,[
                                    'product_ar_name'=>$rows->P_Ar_Name,
                                    'product_en_name'=>$rows->P_En_Name,
                                    'product_id'=>$rows->Product,
                                    'virable_one_id'=>$rows->V1,
                                    'virable_two_id'=>$rows->V2,
                                    'virable_one_name'=>'',
                                    'virable_two_name'=>'',
                                    'product_code'=>$rr->Barcode,
                                    'unit_name'=>$UName,
                                    'unit_id'=>$rr->Unit,
                                    'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                    'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                    'tax_id'=>$rows->Product()->first()->Tax,
                                    'avalible_qty'=>$rows->Qty / $rr->Rate,
                                    'qty'=>1,
                                    'price'=>$pr,
                                    'discount'=>$DES,
                                    'total_discount_pro'=>$DES,
                                    'total_before_tax'=>$pr,
                                    'tax_value'=>0,
                                    'total'=>$pr,
                                    'store_id'=>$st->id,
                                    'store_name'=>$SName,
                                    'ExpDate'=>'',
                                    'serial'=>0,
                                    'high_disc'=>$Higher,
                                    'cost_price'=>$COSTpr,
                                    'additions_count'=>$AdditionsCount,

                                ]);

                            }

                        }elseif($rows->Product()->first()->P_Type == 'Serial'){
                            if(empty($Ser)){

                                if($rows->Product()->first()->Status == 0){

                                    if($show->Group_Brand == 1){

                                        $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                    }else{
                                        $ShowGrBr='';
                                    }

                                    if(!empty($Cli)){

                                        if(!empty($Cli->Group)){
                                            $nwD=CustomersGroup::find($Cli->Group);

                                            $DES= $nwD->Discount ;

                                        }else{
                                            $DES=0;

                                        }

                                    }else{
                                        $DES=0;
                                    }

                                    if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                        $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                    }else{

                                        $Higher=0;
                                    }


                                    if($lang == 'ar'){
                                        $UName=$rr->Unit()->first()->Name;
                                        $SName=$st->Name;

                                    }else{

                                        $UName=$rr->Unit()->first()->NameEn;
                                        $SName=$st->NameEn;
                                    }


                                    array_push($Array,[
                                        'product_ar_name'=>$rows->P_Ar_Name,
                                        'product_en_name'=>$rows->P_En_Name,
                                        'product_id'=>$rows->Product,
                                        'virable_one_id'=>$rows->V1,
                                        'virable_two_id'=>$rows->V2,
                                        'virable_one_name'=>'',
                                        'virable_two_name'=>'',
                                        'product_code'=>$rr->Barcode,
                                        'unit_name'=>$UName,
                                        'unit_id'=>$rr->Unit,
                                        'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                        'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                        'tax_id'=>$rows->Product()->first()->Tax,
                                        'avalible_qty'=>$rows->Qty / $rr->Rate,
                                        'qty'=>1,
                                        'price'=>$pr,
                                        'discount'=>$DES,
                                        'total_discount_pro'=>$DES,
                                        'total_before_tax'=>$pr,
                                        'tax_value'=>0,
                                        'total'=>$pr,
                                        'store_id'=>$st->id,
                                        'store_name'=>$SName,
                                        'ExpDate'=>'',
                                        'serial'=>1,
                                        'high_disc'=>$Higher,
                                        'cost_price'=>$COSTpr,
                                        'additions_count'=>$AdditionsCount,

                                    ]);


                                }

                            }
                        }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                            if($rows->Product()->first()->Status == 0){

                                if($show->Group_Brand == 1){

                                    $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                }else{
                                    $ShowGrBr='';
                                }

                                if(!empty($Cli)){

                                    if(!empty($Cli->Group)){
                                        $nwD=CustomersGroup::find($Cli->Group);

                                        $DES= $nwD->Discount ;

                                    }else{
                                        $DES=0;

                                    }

                                }else{
                                    $DES=0;
                                }

                                if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                    $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                }else{

                                    $Higher=0;
                                }




                                if($lang == 'ar'){
                                    $UName=$rr->Unit()->first()->Name;
                                    $SName=$st->Name;

                                }else{

                                    $UName=$rr->Unit()->first()->NameEn;
                                    $SName=$st->NameEn;
                                }
                                array_push($Array,[
                                    'product_ar_name'=>$rows->P_Ar_Name,
                                    'product_en_name'=>$rows->P_En_Name,
                                    'product_id'=>$rows->Product,
                                    'virable_one_id'=>$rows->V1,
                                    'virable_two_id'=>$rows->V2,
                                    'virable_one_name'=>$rows->V1()->first()->Name,
                                    'virable_two_name'=>'',
                                    'product_code'=>$rr->Barcode,
                                    'unit_name'=>$UName,
                                    'unit_id'=>$rr->Unit,
                                    'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                    'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                    'tax_id'=>$rows->Product()->first()->Tax,
                                    'avalible_qty'=>$rows->Qty / $rr->Rate,
                                    'qty'=>1,
                                    'price'=>$pr,
                                    'discount'=>$DES,
                                    'total_discount_pro'=>$DES,
                                    'total_before_tax'=>$pr,
                                    'tax_value'=>0,
                                    'total'=>$pr,
                                    'store_id'=>$st->id,
                                    'store_name'=>$SName,
                                    'ExpDate'=>'',
                                    'serial'=>0,
                                    'high_disc'=>$Higher,
                                    'additions_count'=>$AdditionsCount,

                                ]);


                            }

                        }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){

                            if($rows->Product()->first()->Status == 0){

                                if($show->Group_Brand == 1){

                                    $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                }else{
                                    $ShowGrBr='';
                                }

                                if(!empty($Cli)){

                                    if(!empty($Cli->Group)){
                                        $nwD=CustomersGroup::find($Cli->Group);

                                        $DES= $nwD->Discount ;

                                    }else{
                                        $DES=0;

                                    }

                                }else{
                                    $DES=0;
                                }

                                if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                    $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                }else{

                                    $Higher=0;
                                }


                                if($lang == 'ar'){
                                    $UName=$rr->Unit()->first()->Name;
                                    $SName=$st->Name;

                                }else{

                                    $UName=$rr->Unit()->first()->NameEn;
                                    $SName=$st->NameEn;
                                }

                                array_push($Array,[
                                    'product_ar_name'=>$rows->P_Ar_Name,
                                    'product_en_name'=>$rows->P_En_Name,
                                    'product_id'=>$rows->Product,
                                    'virable_one_id'=>$rows->V1,
                                    'virable_two_id'=>$rows->V2,
                                    'virable_one_name'=>$rows->V1()->first()->Name,
                                    'virable_two_name'=>$rows->V2()->first()->Name,
                                    'product_code'=>$rr->Barcode,
                                    'unit_name'=>$UName,
                                    'unit_id'=>$rr->Unit,
                                    'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                    'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                    'tax_id'=>$rows->Product()->first()->Tax,
                                    'avalible_qty'=>$rows->Qty / $rr->Rate,
                                    'qty'=>1,
                                    'price'=>$pr,
                                    'discount'=>$DES,
                                    'total_discount_pro'=>$DES,
                                    'total_before_tax'=>$pr,
                                    'tax_value'=>0,
                                    'total'=>$pr,
                                    'store_id'=>$st->id,
                                    'store_name'=>$SName,
                                    'ExpDate'=>'',
                                    'serial'=>0,
                                    'high_disc'=>$Higher,
                                    'cost_price'=>$COSTpr,
                                    'additions_count'=>$AdditionsCount,

                                ]);


                            }

                        }
                    }
                }
            }

            foreach($Assembls as $rows){

                $rr=ProductUnits::where('Product',$rows->id)->where('Def',1)->first();
                $plow=ProductUnits::where('Product',$rows->id)->where('Rate',1)->first();
                $purchs=ProductsPurchases::where('Product',$rows->id)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total_Bf_Tax');
                $countPurchs=ProductsPurchases::where('Product',$rows->id)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');

                $AdditionsCount=AdditionalProducts::where('Product',$rows->id)->count();
                $storesTransfer=ProductsStoresTransfers::where('Product',$rows->id)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');

                $storesTransferCount=ProductsStoresTransfers::where('Product',$rows->id)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallTrans_Qty');

                $purchsStart=ProductsStartPeriods::where('Product',$rows->id)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');
                $countStart=ProductsStartPeriods::where('Product',$rows->id)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');

                $OUTCOME=OutcomManufacturingModel::where('Product',$rows->id)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Cost');

                $countOUTCOME=OutcomManufacturingModel::where('Product',$rows->id)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');

                $x = ProductsQty::where("Unit",$rr->Unit)
                    ->where('P_Code',$rr->Barcode)
                    ->orWhere('PP_Code',$rr->Barcode)
                    ->orWhere('PPP_Code',$rr->Barcode)
                    ->orWhere('PPPP_Code',$rr->Barcode)
                    ->orWhere('Product',$rows->id)->first();
                if(!empty($x)){

                    if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME)){

                        $Collect=$purchs + $storesTransfer + $purchsStart + $OUTCOME ;
                        $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;

                        if($CollectCount != 0){
                            $ty= $Collect /  $CollectCount ;

                            $COSTpr=number_format((float)abs($ty), 2, '.', '') * $rr->Rate;



                        }else{

                            $COSTpr=$Collect * $rr->Rate;
                        }

                    }else{
                        $COSTpr=$x->Price;

                    }



                }else{
                    $COSTpr=$rr->Price;
                }



                $show=DefaultDataShowHide::orderBy('id','desc')->first();
                $Stores=Stores::all();
                if($rows->P_Type == 'Assembly' or $rows->P_Type == 'Service'){

                    if($rows->P_Type == 'Assembly'){

                        $Assembly=AssemblyProducts::where('p_id',$rows->id)->get();
                        $AssemblyCountt=AssemblyProducts::where('p_id',$rows->id)->count();

                        foreach($Assembly as $ass){

                            if($ass->Product()->first()->P_Type != 'Service'){
                                $Quantity =ProductsQty::
                                where('Store',$store)
                                    ->where('Product',$ass->Product)
                                    ->where('P_Code',$ass->P_Code)
                                    ->first();

                                if(empty($Quantity)){

                                    $Quantity =ProductsQty::
                                    where('Store',$store)
                                        ->where('Product',$ass->Product)
                                        ->where('PP_Code',$ass->P_Code)
                                        ->first();

                                    if(empty($Quantity)){

                                        $Quantity =ProductsQty::
                                        where('Store',$store)
                                            ->where('Product',$ass->Product)
                                            ->where('PPP_Code',$ass->P_Code)
                                            ->first();


                                        if(empty($Quantity)){

                                            $Quantity =ProductsQty::
                                            where('Store',$store)
                                                ->where('Product',$ass->Product)
                                                ->where('PPPP_Code',$ass->P_Code)
                                                ->first();

                                        }

                                    }

                                }

                                $Qut=0;

                                if(!empty($Quantity)){

                                    if($Quantity->Qty >=  $ass->Qty){

                                        $Qut +=1;
                                    }else{

                                        $Qut +=0;

                                    }

                                }else{

                                    $Qut +=0;

                                }

                            }else{

                                $Qut +=1;
                            }

                        }

                        if($AssemblyCountt == $Qut){


                            if($rows->Status == 0){

                                $units=ProductUnits::where('Product',$rows->id)->get();
                                $rr=ProductUnits::where('Product',$rows->id)->where('Def',1)->first();
                                $Cli=Customers::where('Account',$client)->first();

                                if(!empty($Cli)){

                                    if($Cli->Price_Level == 1){

                                        $pr= $rr->Price ;

                                    }elseif($Cli->Price_Level == 2){

                                        if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                            $pr= $rr->Price_Two ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }elseif($Cli->Price_Level == 3){

                                        if(!empty($rr->Price_Three) and $rr->Price_Three != 0 ){

                                            $pr= $rr->Price_Three ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }

                                }else{


                                    $Vend=Vendors::where('Account',$client)->first();

                                    if(!empty($Vend)){
                                        if($Vend->Price_Level == 1){

                                            $pr= $rr->Price ;

                                        }elseif($Vend->Price_Level == 2){

                                            if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                                $pr= $rr->Price_Two ;

                                            }else{

                                                $pr= $rr->Price ;

                                            }

                                        }elseif($Vend->Price_Level == 3){

                                            if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                                $pr= $rr->Price_Three ;

                                            }else{

                                                $pr= $rr->Price ;

                                            }

                                        }
                                    }else{


                                        $EMPO=Employess::where('Account_Emp',$client)->first();
                                        if(!empty($EMPO)){
                                            if($EMPO->Price_Level == 1){

                                                $pr= $rr->Price ;

                                            }elseif($EMPO->Price_Level == 2){

                                                if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                                    $pr= $rr->Price_Two ;

                                                }else{

                                                    $pr= $rr->Price ;

                                                }

                                            }elseif($EMPO->Price_Level == 3){

                                                if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                                    $pr= $rr->Price_Three ;

                                                }else{

                                                    $pr= $rr->Price ;

                                                }

                                            }
                                        }else{

                                            $pr=$rr->Price;
                                        }

                                    }


                                }

                                if($rows->Original != null){

                                    $pr=0;
                                }

                                if(!empty($rows->Brand)){

                                    $brandd=$rows->Brand()->first()->Name;
                                }else{

                                    $brandd="";

                                }

                                $st=Stores::find($store);
                                if($show->Group_Brand == 1){

                                    $ShowGrBr= '('.$brandd.') ('.$rows->Group()->first()->Name.') ';
                                }else{
                                    $ShowGrBr='';
                                }

                                if(!empty($Cli)){

                                    if(!empty($Cli->Group)){
                                        $nwD=CustomersGroup::find($Cli->Group);

                                        $DES= $nwD->Discount ;

                                    }else{
                                        $DES=0;

                                    }

                                }else{
                                    $DES=0;
                                }

                                if(!empty($rows->Group()->first()->Discount)){
                                    $Higher=$rows->Group()->first()->Discount;
                                }else{

                                    $Higher=0;
                                }

                                if($lang == 'ar'){
                                    $UName=$rr->Unit()->first()->Name;
                                    $SName=$st->Name;

                                }else{

                                    $UName=$rr->Unit()->first()->NameEn;
                                    $SName=$st->NameEn;
                                }

                                array_push($Array,[
                                    'product_ar_name'=>$rows->P_Ar_Name,
                                    'product_en_name'=>$rows->P_En_Name,
                                    'product_id'=>$rows->id,
                                    'virable_one_id'=>'',
                                    'virable_two_id'=>'',
                                    'virable_one_name'=>'',
                                    'virable_two_name'=>'',
                                    'product_code'=>$rr->Barcode,
                                    'unit_name'=>$UName,
                                    'unit_id'=>$rr->Unit,
                                    'tax_rate'=>$rows->Tax()->first()->Rate,
                                    'tax_type'=>$rows->Tax()->first()->Type,
                                    'tax_id'=>$rows->Tax,
                                    'avalible_qty'=>1000,
                                    'qty'=>1,
                                    'price'=>$pr,
                                    'discount'=>$DES,
                                    'total_discount_pro'=>$DES,
                                    'total_before_tax'=>$pr,
                                    'tax_value'=>0,
                                    'total'=>$pr,
                                    'store_id'=>$st->id,
                                    'store_name'=>$SName,
                                    'ExpDate'=>'',
                                    'serial'=>0,
                                    'high_disc'=>$Higher,
                                    'cost_price'=>$COSTpr,
                                    'additions_count'=>$AdditionsCount,

                                ]);




                            }

                        }

                    }else{

                        if($rows->Status == 0){

                            $units=ProductUnits::where('Product',$rows->id)->get();
                            $rr=ProductUnits::where('Product',$rows->id)->where('Def',1)->first();
                            $Cli=Customers::where('Account',$client)->first();

                            if(!empty($Cli)){

                                if($Cli->Price_Level == 1){

                                    $pr= $rr->Price ;

                                }elseif($Cli->Price_Level == 2){

                                    if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                        $pr= $rr->Price_Two ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }elseif($Cli->Price_Level == 3){

                                    if(!empty($rr->Price_Three) and $rr->Price_Three != 0 ){

                                        $pr= $rr->Price_Three ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }

                            }else{


                                $Vend=Vendors::where('Account',$client)->first();

                                if(!empty($Vend)){
                                    if($Vend->Price_Level == 1){

                                        $pr= $rr->Price ;

                                    }elseif($Vend->Price_Level == 2){

                                        if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                            $pr= $rr->Price_Two ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }elseif($Vend->Price_Level == 3){

                                        if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                            $pr= $rr->Price_Three ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }
                                }else{


                                    $EMPO=Employess::where('Account_Emp',$client)->first();
                                    if(!empty($EMPO)){
                                        if($EMPO->Price_Level == 1){

                                            $pr= $rr->Price ;

                                        }elseif($EMPO->Price_Level == 2){

                                            if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                                $pr= $rr->Price_Two ;

                                            }else{

                                                $pr= $rr->Price ;

                                            }

                                        }elseif($EMPO->Price_Level == 3){

                                            if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                                $pr= $rr->Price_Three ;

                                            }else{

                                                $pr= $rr->Price ;

                                            }

                                        }
                                    }else{

                                        $pr=$rr->Price;
                                    }

                                }


                            }

                            if($rows->Original != null){

                                $pr=0;
                            }

                            if(!empty($rows->Brand)){

                                $brandd=$rows->Brand()->first()->Name;
                            }else{

                                $brandd="";

                            }

                            $st=Stores::find($store);
                            if($show->Group_Brand == 1){

                                $ShowGrBr= '('.$brandd.') ('.$rows->Group()->first()->Name.') ';
                            }else{
                                $ShowGrBr='';
                            }

                            if(!empty($Cli)){

                                if(!empty($Cli->Group)){
                                    $nwD=CustomersGroup::find($Cli->Group);

                                    $DES= $nwD->Discount ;

                                }else{
                                    $DES=0;

                                }

                            }else{
                                $DES=0;
                            }

                            if(!empty($rows->Group()->first()->Discount)){
                                $Higher=$rows->Group()->first()->Discount;
                            }else{

                                $Higher=0;
                            }


                            if($lang == 'ar'){
                                $UName=$rr->Unit()->first()->Name;
                                $SName=$st->Name;

                            }else{

                                $UName=$rr->Unit()->first()->NameEn;
                                $SName=$st->NameEn;
                            }

                            array_push($Array,[
                                'product_ar_name'=>$rows->P_Ar_Name,
                                'product_en_name'=>$rows->P_En_Name,
                                'product_id'=>$rows->id,
                                'virable_one_id'=>'',
                                'virable_two_id'=>'',
                                'virable_one_name'=>'',
                                'virable_two_name'=>'',
                                'product_code'=>$rr->Barcode,
                                'unit_name'=>$UName,
                                'unit_id'=>$rr->Unit,
                                'tax_rate'=>$rows->Tax()->first()->Rate,
                                'tax_type'=>$rows->Tax()->first()->Type,
                                'tax_id'=>$rows->Tax,
                                'avalible_qty'=>1000,
                                'qty'=>1,
                                'price'=>$pr,
                                'discount'=>$DES,
                                'total_discount_pro'=>$DES,
                                'total_before_tax'=>$pr,
                                'tax_value'=>0,
                                'total'=>$pr,
                                'store_id'=>$st->id,
                                'store_name'=>$SName,
                                'ExpDate'=>'',
                                'serial'=>0,
                                'high_disc'=>$Higher,
                                'cost_price'=>$COSTpr,
                                'additions_count'=>$AdditionsCount,

                            ]);


                        }

                    }



                }elseif($rows->P_Type == 'Variable_Aggregate'){


                    if($rows->Status == 0){

                        $units=ProductUnits::where('Product',$rows->id)->get();
                        $rr=ProductUnits::where('Product',$rows->id)->where('Def',1)->first();
                        $Cli=Customers::where('Account',$client)->first();

                        if(!empty($Cli)){

                            if($Cli->Price_Level == 1){

                                $pr= $rr->Price ;

                            }elseif($Cli->Price_Level == 2){

                                if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                    $pr= $rr->Price_Two ;

                                }else{

                                    $pr= $rr->Price ;

                                }

                            }elseif($Cli->Price_Level == 3){

                                if(!empty($rr->Price_Three) and $rr->Price_Three != 0 ){

                                    $pr= $rr->Price_Three ;

                                }else{

                                    $pr= $rr->Price ;

                                }

                            }

                        }else{


                            $Vend=Vendors::where('Account',$client)->first();

                            if(!empty($Vend)){
                                if($Vend->Price_Level == 1){

                                    $pr= $rr->Price ;

                                }elseif($Vend->Price_Level == 2){

                                    if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                        $pr= $rr->Price_Two ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }elseif($Vend->Price_Level == 3){

                                    if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                        $pr= $rr->Price_Three ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }
                            }else{


                                $EMPO=Employess::where('Account_Emp',$client)->first();
                                if(!empty($EMPO)){
                                    if($EMPO->Price_Level == 1){

                                        $pr= $rr->Price ;

                                    }elseif($EMPO->Price_Level == 2){

                                        if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                            $pr= $rr->Price_Two ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }elseif($EMPO->Price_Level == 3){

                                        if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                            $pr= $rr->Price_Three ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }
                                }else{

                                    $pr=$rr->Price;
                                }

                            }


                        }

                        if($rows->Original != null){

                            $pr=0;
                        }

                        if(!empty($rows->Brand)){

                            $brandd=$rows->Brand()->first()->Name;
                        }else{

                            $brandd="";

                        }

                        $st=Stores::find($store);
                        if($show->Group_Brand == 1){

                            $ShowGrBr= '('.$brandd.') ('.$rows->Group()->first()->Name.') ';
                        }else{
                            $ShowGrBr='';
                        }

                        if(!empty($Cli)){

                            if(!empty($Cli->Group)){
                                $nwD=CustomersGroup::find($Cli->Group);

                                $DES= $nwD->Discount ;

                            }else{
                                $DES=0;

                            }

                        }else{
                            $DES=0;
                        }

                        if(!empty($rows->Group()->first()->Discount)){
                            $Higher=$rows->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }


                        if($lang == 'ar'){
                            $UName=$rr->Unit()->first()->Name;
                            $SName=$st->Name;

                        }else{

                            $UName=$rr->Unit()->first()->NameEn;
                            $SName=$st->NameEn;
                        }



                        array_push($Array,[
                            'product_ar_name'=>$rows->P_Ar_Name,
                            'product_en_name'=>$rows->P_En_Name,
                            'product_id'=>$rows->id,
                            'virable_one_id'=>'',
                            'virable_two_id'=>'',
                            'virable_one_name'=>'',
                            'virable_two_name'=>'',
                            'product_code'=>$rr->Barcode,
                            'unit_name'=>$UName,
                            'unit_id'=>$rr->Unit,
                            'tax_rate'=>$rows->Tax()->first()->Rate,
                            'tax_type'=>$rows->Tax()->first()->Type,
                            'tax_id'=>$rows->Tax,
                            'avalible_qty'=>1000,
                            'qty'=>1,
                            'price'=>$pr,
                            'discount'=>$DES,
                            'total_discount_pro'=>$DES,
                            'total_before_tax'=>$pr,
                            'tax_value'=>0,
                            'total'=>$pr,
                            'store_id'=>$st->id,
                            'store_name'=>$SName,
                            'ExpDate'=>'',
                            'serial'=>0,
                            'high_disc'=>$Higher,
                            'cost_price'=>0,
                            'additions_count'=>$AdditionsCount,

                        ]);


                    }




                }

            }

            foreach($data as $rows){

                $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                $purchs=ProductsPurchases::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total_Bf_Tax');
                $countPurchs=ProductsPurchases::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');

                $AdditionsCount=AdditionalProducts::where('Product',$rows->Product)->count();
                $storesTransfer=ProductsStoresTransfers::where('Product',$rows->Product)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');

                $storesTransferCount=ProductsStoresTransfers::where('Product',$rows->Product)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallTrans_Qty');

                $purchsStart=ProductsStartPeriods::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');
                $countStart=ProductsStartPeriods::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');

                $OUTCOME=OutcomManufacturingModel::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Cost');

                $countOUTCOME=OutcomManufacturingModel::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');

                $x = ProductsQty::where("Unit",$rr->Unit)
                    ->where('P_Code',$rr->Barcode)
                    ->orWhere('PP_Code',$rr->Barcode)
                    ->orWhere('PPP_Code',$rr->Barcode)
                    ->orWhere('PPPP_Code',$rr->Barcode)
                    ->orWhere('Product',$rows->id)->first();
                if(!empty($x)){

                    if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME)){

                        $Collect=$purchs + $storesTransfer + $purchsStart + $OUTCOME ;
                        $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;

                        if($CollectCount != 0){
                            $ty= $Collect /  $CollectCount ;

                            $COSTpr=number_format((float)abs($ty), 2, '.', '') * $rr->Rate;



                        }else{

                            $COSTpr=$Collect * $rr->Rate;
                        }

                    }else{
                        $COSTpr=$x->Price;

                    }



                }else{
                    $COSTpr=$rr->Price;
                }


                $show=DefaultDataShowHide::orderBy('id','desc')->first();
                $Stores=Stores::all();
                if($rows->Product()->first()->P_Type == 'Assembly'  or $rows->Product()->first()->P_Type == 'Service'){

                    if($rows->Product()->first()->Status == 0){

                        $units=ProductUnits::where('Product',$rows->Product)->get();
                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();

                        $Cli=Customers::where('Account',$client)->first();

                        if(!empty($Cli)){

                            if($Cli->Price_Level == 1){

                                $pr= $rr->Price ;

                            }elseif($Cli->Price_Level == 2){

                                if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                    $pr= $rr->Price_Two ;

                                }else{

                                    $pr= $rr->Price ;

                                }

                            }elseif($Cli->Price_Level == 3){

                                if(!empty($rr->Price_Three) and $rr->Price_Three != 0 ){

                                    $pr= $rr->Price_Three ;

                                }else{

                                    $pr= $rr->Price ;

                                }

                            }

                        }else{


                            $Vend=Vendors::where('Account',$client)->first();

                            if(!empty($Vend)){
                                if($Vend->Price_Level == 1){

                                    $pr= $rr->Price ;

                                }elseif($Vend->Price_Level == 2){

                                    if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                        $pr= $rr->Price_Two ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }elseif($Vend->Price_Level == 3){

                                    if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                        $pr= $rr->Price_Three ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }
                            }else{


                                $EMPO=Employess::where('Account_Emp',$client)->first();
                                if(!empty($EMPO)){
                                    if($EMPO->Price_Level == 1){

                                        $pr= $rr->Price ;

                                    }elseif($EMPO->Price_Level == 2){

                                        if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                            $pr= $rr->Price_Two ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }elseif($EMPO->Price_Level == 3){

                                        if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                            $pr= $rr->Price_Three ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }
                                }else{

                                    $pr=$rr->Price;
                                }

                            }


                        }

                        if($rows->Original != null){

                            $pr=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $brandd=$rows->Product()->first()->Brand()->first()->Name;
                        }else{

                            $brandd="";

                        }


                        $st=Stores::find($store);
                        if($show->Group_Brand == 1){

                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                        }else{
                            $ShowGrBr='';
                        }


                        if(!empty($Cli)){

                            if(!empty($Cli->Group)){
                                $nwD=CustomersGroup::find($Cli->Group);

                                $DES= $nwD->Discount ;

                            }else{
                                $DES=0;

                            }

                        }else{
                            $DES=0;
                        }

                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }


                        if($lang == 'ar'){
                            $UName=$rr->Unit()->first()->Name;
                            $SName=$st->Name;

                        }else{

                            $UName=$rr->Unit()->first()->NameEn;
                            $SName=$st->NameEn;
                        }

                        array_push($Array,[
                            'product_ar_name'=>$rows->P_Ar_Name,
                            'product_en_name'=>$rows->P_En_Name,
                            'product_id'=>$rows->Product,
                            'virable_one_id'=>'',
                            'virable_two_id'=>'',
                            'virable_one_name'=>'',
                            'virable_two_name'=>'',
                            'product_code'=>$rr->Barcode,
                            'unit_name'=>$UName,
                            'unit_id'=>$rr->Unit,
                            'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                            'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                            'tax_id'=>$rows->Product()->first()->Tax,
                            'avalible_qty'=>1000,
                            'qty'=>1,
                            'price'=>$pr,
                            'discount'=>$DES,
                            'total_discount_pro'=>$DES,
                            'total_before_tax'=>$pr,
                            'tax_value'=>0,
                            'total'=>$pr,
                            'store_id'=>$st->id,
                            'store_name'=>$SName,
                            'ExpDate'=>'',
                            'serial'=>0,
                            'high_disc'=>$Higher,
                            'cost_price'=>$COSTpr,
                            'additions_count'=>$AdditionsCount,

                        ]);


                    }

                }elseif($rows->Product()->first()->P_Type == 'Variable_Aggregate'){

                    if($rows->Product()->first()->Status == 0){

                        $units=ProductUnits::where('Product',$rows->Product)->get();
                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();

                        $Cli=Customers::where('Account',$client)->first();

                        if(!empty($Cli)){

                            if($Cli->Price_Level == 1){

                                $pr= $rr->Price ;

                            }elseif($Cli->Price_Level == 2){

                                if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                    $pr= $rr->Price_Two ;

                                }else{

                                    $pr= $rr->Price ;

                                }

                            }elseif($Cli->Price_Level == 3){

                                if(!empty($rr->Price_Three) and $rr->Price_Three != 0 ){

                                    $pr= $rr->Price_Three ;

                                }else{

                                    $pr= $rr->Price ;

                                }

                            }

                        }else{


                            $Vend=Vendors::where('Account',$client)->first();

                            if(!empty($Vend)){
                                if($Vend->Price_Level == 1){

                                    $pr= $rr->Price ;

                                }elseif($Vend->Price_Level == 2){

                                    if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                        $pr= $rr->Price_Two ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }elseif($Vend->Price_Level == 3){

                                    if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                        $pr= $rr->Price_Three ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }
                            }else{


                                $EMPO=Employess::where('Account_Emp',$client)->first();
                                if(!empty($EMPO)){
                                    if($EMPO->Price_Level == 1){

                                        $pr= $rr->Price ;

                                    }elseif($EMPO->Price_Level == 2){

                                        if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                            $pr= $rr->Price_Two ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }elseif($EMPO->Price_Level == 3){

                                        if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                            $pr= $rr->Price_Three ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }
                                }else{

                                    $pr=$rr->Price;
                                }

                            }


                        }

                        if($rows->Original != null){

                            $pr=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $brandd=$rows->Product()->first()->Brand()->first()->Name;
                        }else{

                            $brandd="";

                        }


                        $st=Stores::find($store);
                        if($show->Group_Brand == 1){

                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                        }else{
                            $ShowGrBr='';
                        }


                        if(!empty($Cli)){

                            if(!empty($Cli->Group)){
                                $nwD=CustomersGroup::find($Cli->Group);

                                $DES= $nwD->Discount ;

                            }else{
                                $DES=0;

                            }

                        }else{
                            $DES=0;
                        }

                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                        }else{

                            $Higher=0;
                        }


                        if($lang == 'ar'){
                            $UName=$rr->Unit()->first()->Name;
                            $SName=$st->Name;

                        }else{

                            $UName=$rr->Unit()->first()->NameEn;
                            $SName=$st->NameEn;
                        }

                        array_push($Array,[
                            'product_ar_name'=>$rows->P_Ar_Name,
                            'product_en_name'=>$rows->P_En_Name,
                            'product_id'=>$rows->Product,
                            'virable_one_id'=>'',
                            'virable_two_id'=>'',
                            'virable_one_name'=>'',
                            'virable_two_name'=>'',
                            'product_code'=>$rr->Barcode,
                            'unit_name'=>$UName,
                            'unit_id'=>$rr->Unit,
                            'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                            'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                            'tax_id'=>$rows->Product()->first()->Tax,
                            'avalible_qty'=>1000,
                            'qty'=>1,
                            'price'=>$pr,
                            'discount'=>$DES,
                            'total_discount_pro'=>$DES,
                            'total_before_tax'=>$pr,
                            'tax_value'=>0,
                            'total'=>$pr,
                            'store_id'=>$st->id,
                            'store_name'=>$SName,
                            'ExpDate'=>'',
                            'serial'=>0,
                            'high_disc'=>$Higher,
                            'cost_price'=>$COSTpr,
                            'additions_count'=>$AdditionsCount,

                        ]);


                    }


                }

            }



            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


    //SerachProductGroupFilter
    public function SerachResturantProductGroupFilter(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');
        if(!empty($admin)){

            $Array=array();

            $group = $request->get('group');
            $store = $request->get('store_id');
            $client = $request->get('client_id');

            $Prods=ProductsQty::


            join('products', function ($join) {

                $join->on('products_qties.Product', '=', 'products.id');
            })

                ->where('products.Group',$group)

                ->get();



            foreach($Prods as $rows){

                $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                $purchs=ProductsPurchases::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total_Bf_Tax');
                $countPurchs=ProductsPurchases::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');
                $storesTransfer=ProductsStoresTransfers::where('Product',$rows->Product)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');
                $storesTransferCount=ProductsStoresTransfers::where('Product',$rows->Product)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallTrans_Qty');
                $purchsStart=ProductsStartPeriods::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');
                $countStart=ProductsStartPeriods::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');
                $OUTCOME=OutcomManufacturingModel::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Cost');
                $countOUTCOME=OutcomManufacturingModel::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');


                if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME)){

                    $Collect=$purchs + $storesTransfer + $purchsStart + $OUTCOME ;
                    $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;

                    if($CollectCount != 0){
                        $ty= $Collect /  $CollectCount ;

                        $COSTpr=number_format((float)abs($ty), 2, '.', '') * $rr->Rate;



                    }else{

                        $COSTpr=$Collect * $rr->Rate;
                    }

                }else{
                    $COSTpr=$rr->Price;

                }




                $Ser=ProductSalesOrder::where('Product',$rows->Product)->where('Product_Code',$rows->P_Code)->first();

                if($rows->Qty > 0){
                    if($rows->Store == $store){
                        if($rows->Product()->first()->Group  == $group){
                            $Stores=Stores::all();

                            $units=ProductUnits::where('Product',$rows->Product)->get();
                            $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                            $x = ProductsQty::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();

                            $Cli=Customers::where('Account',$client)->first();

                            if(!empty($Cli)){

                                if($Cli->Price_Level == 1){

                                    $pr= $rr->Price ;

                                }elseif($Cli->Price_Level == 2){

                                    if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                        $pr= $rr->Price_Two ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }elseif($Cli->Price_Level == 3){

                                    if(!empty($rr->Price_Three) and $rr->Price_Three != 0 ){

                                        $pr= $rr->Price_Three ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }

                            }else{


                                $Vend=Vendors::where('Account',$client)->first();

                                if(!empty($Vend)){
                                    if($Vend->Price_Level == 1){

                                        $pr= $rr->Price ;

                                    }elseif($Vend->Price_Level == 2){

                                        if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                            $pr= $rr->Price_Two ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }elseif($Vend->Price_Level == 3){

                                        if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                            $pr= $rr->Price_Three ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }
                                }else{


                                    $EMPO=Employess::where('Account_Emp',$client)->first();
                                    if(!empty($EMPO)){
                                        if($EMPO->Price_Level == 1){

                                            $pr= $rr->Price ;

                                        }elseif($EMPO->Price_Level == 2){

                                            if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                                $pr= $rr->Price_Two ;

                                            }else{

                                                $pr= $rr->Price ;

                                            }

                                        }elseif($EMPO->Price_Level == 3){

                                            if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                                $pr= $rr->Price_Three ;

                                            }else{

                                                $pr= $rr->Price ;

                                            }

                                        }
                                    }else{

                                        $pr=$rr->Price;
                                    }

                                }


                            }

                            if($rows->Original != null){

                                $pr=0;
                            }

                            if(!empty($rows->Product()->first()->Brand)){

                                $brandd=$rows->Product()->first()->Brand()->first()->Name;
                            }else{

                                $brandd="";

                            }

                            $st=Stores::find($store);

                            $show=DefaultDataShowHide::orderBy('id','desc')->first();
                            if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){

                                if($rows->Product()->first()->Status == 0){

                                    if($show->Group_Brand == 1){

                                        $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                    }else{
                                        $ShowGrBr='';
                                    }

                                    if(!empty($Cli)){

                                        if(!empty($Cli->Group)){
                                            $nwD=CustomersGroup::find($Cli->Group);

                                            $DES= $nwD->Discount ;

                                        }else{
                                            $DES=0;

                                        }

                                    }else{
                                        $DES=0;
                                    }

                                    if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                        $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                    }else{

                                        $Higher=0;
                                    }

                                    if(!empty($rows->Product()->first()->Image)){
                                        $img=URL::to($rows->Product()->first()->Image);
                                    }else{

                                        $img=URL::to('Admin/img/demo/gallery/5.jpg');
                                    }


                                    if($lang == 'ar'){
                                        $UName=$rr->Unit()->first()->Name;
                                        $SName=$st->Name;

                                    }else{

                                        $UName=$rr->Unit()->first()->NameEn;
                                        $SName=$st->NameEn;
                                    }


                                    array_push($Array,[
                                        'product_image'=>$img,
                                        'product_ar_name'=>$rows->P_Ar_Name,
                                        'product_en_name'=>$rows->P_En_Name,
                                        'product_id'=>$rows->Product,
                                        'virable_one_id'=>$rows->V1,
                                        'virable_two_id'=>$rows->V2,
                                        'virable_one_name'=>'',
                                        'virable_two_name'=>'',
                                        'product_code'=>$rr->Barcode,
                                        'unit_name'=>$UName,
                                        'unit_id'=>$rr->Unit,
                                        'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                        'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                        'tax_id'=>$rows->Product()->first()->Tax,
                                        'avalible_qty'=>$rows->Qty / $rr->Rate,
                                        'qty'=>1,
                                        'price'=>$pr,
                                        'discount'=>$DES,
                                        'total_discount_pro'=>$DES,
                                        'total_before_tax'=>$pr,
                                        'tax_value'=>0,
                                        'total'=>$pr,
                                        'store_id'=>$st->id,
                                        'store_name'=>$SName,
                                        'ExpDate'=>'',
                                        'serial'=>0,
                                        'high_disc'=>$Higher,
                                        'cost_price'=>$COSTpr,

                                    ]);

                                }

                            }elseif($rows->Product()->first()->P_Type == 'Serial'){
                                if(empty($Ser)){

                                    if($rows->Product()->first()->Status == 0){

                                        if($show->Group_Brand == 1){

                                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                        }else{
                                            $ShowGrBr='';
                                        }

                                        if(!empty($Cli)){

                                            if(!empty($Cli->Group)){
                                                $nwD=CustomersGroup::find($Cli->Group);

                                                $DES= $nwD->Discount ;

                                            }else{
                                                $DES=0;

                                            }

                                        }else{
                                            $DES=0;
                                        }

                                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                        }else{

                                            $Higher=0;
                                        }

                                        if(!empty($rows->Product()->first()->Image)){
                                            $img=URL::to($rows->Product()->first()->Image);
                                        }else{

                                            $img=URL::to('Admin/img/demo/gallery/5.jpg');
                                        }



                                        if($lang == 'ar'){
                                            $UName=$rr->Unit()->first()->Name;
                                            $SName=$st->Name;

                                        }else{

                                            $UName=$rr->Unit()->first()->NameEn;
                                            $SName=$st->NameEn;
                                        }
                                        array_push($Array,[
                                            'product_image'=>$img,
                                            'product_ar_name'=>$rows->P_Ar_Name,
                                            'product_en_name'=>$rows->P_En_Name,
                                            'product_id'=>$rows->Product,
                                            'virable_one_id'=>$rows->V1,
                                            'virable_two_id'=>$rows->V2,
                                            'virable_one_name'=>'',
                                            'virable_two_name'=>'',
                                            'product_code'=>$rr->Barcode,
                                            'unit_name'=>$UName,
                                            'unit_id'=>$rr->Unit,
                                            'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                            'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                            'tax_id'=>$rows->Product()->first()->Tax,
                                            'avalible_qty'=>$rows->Qty / $rr->Rate,
                                            'qty'=>1,
                                            'price'=>$pr,
                                            'discount'=>$DES,
                                            'total_discount_pro'=>$DES,
                                            'total_before_tax'=>$pr,
                                            'tax_value'=>0,
                                            'total'=>$pr,
                                            'store_id'=>$st->id,
                                            'store_name'=>$SName,
                                            'ExpDate'=>'',
                                            'serial'=>1,
                                            'high_disc'=>$Higher,
                                            'cost_price'=>$COSTpr,

                                        ]);


                                    }

                                }
                            }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                                if($rows->Product()->first()->Status == 0){

                                    if($show->Group_Brand == 1){

                                        $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                    }else{
                                        $ShowGrBr='';
                                    }

                                    if(!empty($Cli)){

                                        if(!empty($Cli->Group)){
                                            $nwD=CustomersGroup::find($Cli->Group);

                                            $DES= $nwD->Discount ;

                                        }else{
                                            $DES=0;

                                        }

                                    }else{
                                        $DES=0;
                                    }

                                    if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                        $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                    }else{

                                        $Higher=0;
                                    }

                                    if(!empty($rows->Product()->first()->Image)){
                                        $img=URL::to($rows->Product()->first()->Image);
                                    }else{

                                        $img=URL::to('Admin/img/demo/gallery/5.jpg');
                                    }


                                    if($lang == 'ar'){
                                        $UName=$rr->Unit()->first()->Name;
                                        $SName=$st->Name;

                                    }else{

                                        $UName=$rr->Unit()->first()->NameEn;
                                        $SName=$st->NameEn;
                                    }

                                    array_push($Array,[
                                        'product_image'=>$img,
                                        'product_ar_name'=>$rows->P_Ar_Name,
                                        'product_en_name'=>$rows->P_En_Name,
                                        'product_id'=>$rows->Product,
                                        'virable_one_id'=>$rows->V1,
                                        'virable_two_id'=>$rows->V2,
                                        'virable_one_name'=>$rows->V1()->first()->Name,
                                        'virable_two_name'=>'',
                                        'product_code'=>$rr->Barcode,
                                        'unit_name'=>$UName,
                                        'unit_id'=>$rr->Unit,
                                        'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                        'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                        'tax_id'=>$rows->Product()->first()->Tax,
                                        'avalible_qty'=>$rows->Qty / $rr->Rate,
                                        'qty'=>1,
                                        'price'=>$pr,
                                        'discount'=>$DES,
                                        'total_discount_pro'=>$DES,
                                        'total_before_tax'=>$pr,
                                        'tax_value'=>0,
                                        'total'=>$pr,
                                        'store_id'=>$st->id,
                                        'store_name'=>$SName,
                                        'ExpDate'=>'',
                                        'serial'=>0,
                                        'high_disc'=>$Higher,
                                        'cost_price'=>$COSTpr,

                                    ]);


                                }

                            }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){

                                if($rows->Product()->first()->Status == 0){

                                    if($show->Group_Brand == 1){

                                        $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                    }else{
                                        $ShowGrBr='';
                                    }

                                    if(!empty($Cli)){

                                        if(!empty($Cli->Group)){
                                            $nwD=CustomersGroup::find($Cli->Group);

                                            $DES= $nwD->Discount ;

                                        }else{
                                            $DES=0;

                                        }

                                    }else{
                                        $DES=0;
                                    }

                                    if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                        $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                    }else{

                                        $Higher=0;
                                    }

                                    if(!empty($rows->Product()->first()->Image)){
                                        $img=URL::to($rows->Product()->first()->Image);
                                    }else{

                                        $img=URL::to('Admin/img/demo/gallery/5.jpg');
                                    }


                                    if($lang == 'ar'){
                                        $UName=$rr->Unit()->first()->Name;
                                        $SName=$st->Name;

                                    }else{

                                        $UName=$rr->Unit()->first()->NameEn;
                                        $SName=$st->NameEn;
                                    }

                                    array_push($Array,[
                                        'product_image'=>$img,
                                        'product_ar_name'=>$rows->P_Ar_Name,
                                        'product_en_name'=>$rows->P_En_Name,
                                        'product_id'=>$rows->Product,
                                        'virable_one_id'=>$rows->V1,
                                        'virable_two_id'=>$rows->V2,
                                        'virable_one_name'=>$rows->V1()->first()->Name,
                                        'virable_two_name'=>$rows->V2()->first()->Name,
                                        'product_code'=>$rr->Barcode,
                                        'unit_name'=>$UName,
                                        'unit_id'=>$rr->Unit,
                                        'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                        'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                        'tax_id'=>$rows->Product()->first()->Tax,
                                        'avalible_qty'=>$rows->Qty / $rr->Rate,
                                        'qty'=>1,
                                        'price'=>$pr,
                                        'discount'=>$DES,
                                        'total_discount_pro'=>$DES,
                                        'total_before_tax'=>$pr,
                                        'tax_value'=>0,
                                        'total'=>$pr,
                                        'store_id'=>$st->id,
                                        'store_name'=>$SName,
                                        'ExpDate'=>'',
                                        'serial'=>0,
                                        'high_disc'=>$Higher,
                                        'cost_price'=>$COSTpr,

                                    ]);


                                }

                            }
                        }
                    }
                }
            }



            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //SerachProductBrandFilter
    public function SerachResturantProductBrandFilter(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');
        if(!empty($admin)){

            $Array=array();

            $group = $request->get('brand');
            $store = $request->get('store_id');
            $client = $request->get('client_id');

            $Prods=ProductsQty::


            join('products', function ($join) {

                $join->on('products_qties.Product', '=', 'products.id');
            })

                ->where('products.Brand',$group)

                ->get();



            foreach($Prods as $rows){

                $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                $purchs=ProductsPurchases::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total_Bf_Tax');
                $countPurchs=ProductsPurchases::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');
                $storesTransfer=ProductsStoresTransfers::where('Product',$rows->Product)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');
                $storesTransferCount=ProductsStoresTransfers::where('Product',$rows->Product)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallTrans_Qty');
                $purchsStart=ProductsStartPeriods::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');
                $countStart=ProductsStartPeriods::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');
                $OUTCOME=OutcomManufacturingModel::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Cost');
                $countOUTCOME=OutcomManufacturingModel::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');


                if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME)){

                    $Collect=$purchs + $storesTransfer + $purchsStart + $OUTCOME ;
                    $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;

                    if($CollectCount != 0){
                        $ty= $Collect /  $CollectCount ;

                        $COSTpr=number_format((float)abs($ty), 2, '.', '') * $rr->Rate;



                    }else{

                        $COSTpr=$Collect * $rr->Rate;
                    }

                }else{
                    $COSTpr=$rr->Price;

                }




                $Ser=ProductSalesOrder::where('Product',$rows->Product)->where('Product_Code',$rows->P_Code)->first();

                if($rows->Qty > 0){
                    if($rows->Store == $store){
                        if($rows->Product()->first()->Brand  == $group){
                            $Stores=Stores::all();

                            $units=ProductUnits::where('Product',$rows->Product)->get();
                            $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                            $x = ProductsQty::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();

                            $Cli=Customers::where('Account',$client)->first();

                            if(!empty($Cli)){

                                if($Cli->Price_Level == 1){

                                    $pr= $rr->Price ;

                                }elseif($Cli->Price_Level == 2){

                                    if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                        $pr= $rr->Price_Two ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }elseif($Cli->Price_Level == 3){

                                    if(!empty($rr->Price_Three) and $rr->Price_Three != 0 ){

                                        $pr= $rr->Price_Three ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }

                            }else{


                                $Vend=Vendors::where('Account',$client)->first();

                                if(!empty($Vend)){
                                    if($Vend->Price_Level == 1){

                                        $pr= $rr->Price ;

                                    }elseif($Vend->Price_Level == 2){

                                        if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                            $pr= $rr->Price_Two ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }elseif($Vend->Price_Level == 3){

                                        if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                            $pr= $rr->Price_Three ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }
                                }else{


                                    $EMPO=Employess::where('Account_Emp',$client)->first();
                                    if(!empty($EMPO)){
                                        if($EMPO->Price_Level == 1){

                                            $pr= $rr->Price ;

                                        }elseif($EMPO->Price_Level == 2){

                                            if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                                $pr= $rr->Price_Two ;

                                            }else{

                                                $pr= $rr->Price ;

                                            }

                                        }elseif($EMPO->Price_Level == 3){

                                            if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                                $pr= $rr->Price_Three ;

                                            }else{

                                                $pr= $rr->Price ;

                                            }

                                        }
                                    }else{

                                        $pr=$rr->Price;
                                    }

                                }


                            }

                            if($rows->Original != null){

                                $pr=0;
                            }

                            if(!empty($rows->Product()->first()->Brand)){

                                $brandd=$rows->Product()->first()->Brand()->first()->Name;
                            }else{

                                $brandd="";

                            }

                            $st=Stores::find($store);

                            $show=DefaultDataShowHide::orderBy('id','desc')->first();
                            if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){

                                if($rows->Product()->first()->Status == 0){

                                    if($show->Group_Brand == 1){

                                        $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                    }else{
                                        $ShowGrBr='';
                                    }

                                    if(!empty($Cli)){

                                        if(!empty($Cli->Group)){
                                            $nwD=CustomersGroup::find($Cli->Group);

                                            $DES= $nwD->Discount ;

                                        }else{
                                            $DES=0;

                                        }

                                    }else{
                                        $DES=0;
                                    }

                                    if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                        $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                    }else{

                                        $Higher=0;
                                    }

                                    if(!empty($rows->Product()->first()->Image)){
                                        $img=URL::to($rows->Product()->first()->Image);
                                    }else{

                                        $img=URL::to('Admin/img/demo/gallery/5.jpg');
                                    }



                                    if($lang == 'ar'){
                                        $UName=$rr->Unit()->first()->Name;
                                        $SName=$st->Name;

                                    }else{

                                        $UName=$rr->Unit()->first()->NameEn;
                                        $SName=$st->NameEn;
                                    }
                                    array_push($Array,[
                                        'product_image'=>$img,
                                        'product_ar_name'=>$rows->P_Ar_Name,
                                        'product_en_name'=>$rows->P_En_Name,
                                        'product_id'=>$rows->Product,
                                        'virable_one_id'=>$rows->V1,
                                        'virable_two_id'=>$rows->V2,
                                        'virable_one_name'=>'',
                                        'virable_two_name'=>'',
                                        'product_code'=>$rr->Barcode,
                                        'unit_name'=>$UName,
                                        'unit_id'=>$rr->Unit,
                                        'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                        'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                        'tax_id'=>$rows->Product()->first()->Tax,
                                        'avalible_qty'=>$rows->Qty / $rr->Rate,
                                        'qty'=>1,
                                        'price'=>$pr,
                                        'discount'=>$DES,
                                        'total_discount_pro'=>$DES,
                                        'total_before_tax'=>$pr,
                                        'tax_value'=>0,
                                        'total'=>$pr,
                                        'store_id'=>$st->id,
                                        'store_name'=>$SName,
                                        'ExpDate'=>'',
                                        'serial'=>0,
                                        'high_disc'=>$Higher,
                                        'cost_price'=>$COSTpr,

                                    ]);

                                }

                            }elseif($rows->Product()->first()->P_Type == 'Serial'){
                                if(empty($Ser)){

                                    if($rows->Product()->first()->Status == 0){

                                        if($show->Group_Brand == 1){

                                            $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                        }else{
                                            $ShowGrBr='';
                                        }

                                        if(!empty($Cli)){

                                            if(!empty($Cli->Group)){
                                                $nwD=CustomersGroup::find($Cli->Group);

                                                $DES= $nwD->Discount ;

                                            }else{
                                                $DES=0;

                                            }

                                        }else{
                                            $DES=0;
                                        }

                                        if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                            $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                        }else{

                                            $Higher=0;
                                        }

                                        if(!empty($rows->Product()->first()->Image)){
                                            $img=URL::to($rows->Product()->first()->Image);
                                        }else{

                                            $img=URL::to('Admin/img/demo/gallery/5.jpg');
                                        }


                                        if($lang == 'ar'){
                                            $UName=$rr->Unit()->first()->Name;
                                            $SName=$st->Name;

                                        }else{

                                            $UName=$rr->Unit()->first()->NameEn;
                                            $SName=$st->NameEn;
                                        }
                                        array_push($Array,[
                                            'product_image'=>$img,
                                            'product_ar_name'=>$rows->P_Ar_Name,
                                            'product_en_name'=>$rows->P_En_Name,
                                            'product_id'=>$rows->Product,
                                            'virable_one_id'=>$rows->V1,
                                            'virable_two_id'=>$rows->V2,
                                            'virable_one_name'=>'',
                                            'virable_two_name'=>'',
                                            'product_code'=>$rr->Barcode,
                                            'unit_name'=>$UName,
                                            'unit_id'=>$rr->Unit,
                                            'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                            'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                            'tax_id'=>$rows->Product()->first()->Tax,
                                            'avalible_qty'=>$rows->Qty / $rr->Rate,
                                            'qty'=>1,
                                            'price'=>$pr,
                                            'discount'=>$DES,
                                            'total_discount_pro'=>$DES,
                                            'total_before_tax'=>$pr,
                                            'tax_value'=>0,
                                            'total'=>$pr,
                                            'store_id'=>$st->id,
                                            'store_name'=>$SName,
                                            'ExpDate'=>'',
                                            'serial'=>0,
                                            'high_disc'=>$Higher,
                                            'cost_price'=>$COSTpr,

                                        ]);


                                    }

                                }
                            }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                                if($rows->Product()->first()->Status == 0){

                                    if($show->Group_Brand == 1){

                                        $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                    }else{
                                        $ShowGrBr='';
                                    }

                                    if(!empty($Cli)){

                                        if(!empty($Cli->Group)){
                                            $nwD=CustomersGroup::find($Cli->Group);

                                            $DES= $nwD->Discount ;

                                        }else{
                                            $DES=0;

                                        }

                                    }else{
                                        $DES=0;
                                    }

                                    if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                        $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                    }else{

                                        $Higher=0;
                                    }

                                    if(!empty($rows->Product()->first()->Image)){
                                        $img=URL::to($rows->Product()->first()->Image);
                                    }else{

                                        $img=URL::to('Admin/img/demo/gallery/5.jpg');
                                    }


                                    if($lang == 'ar'){
                                        $UName=$rr->Unit()->first()->Name;
                                        $SName=$st->Name;

                                    }else{

                                        $UName=$rr->Unit()->first()->NameEn;
                                        $SName=$st->NameEn;
                                    }
                                    array_push($Array,[
                                        'product_image'=>$img,
                                        'product_ar_name'=>$rows->P_Ar_Name,
                                        'product_en_name'=>$rows->P_En_Name,
                                        'product_id'=>$rows->Product,
                                        'virable_one_id'=>$rows->V1,
                                        'virable_two_id'=>$rows->V2,
                                        'virable_one_name'=>'',
                                        'virable_two_name'=>'',
                                        'product_code'=>$rr->Barcode,
                                        'unit_name'=>$UName,
                                        'unit_id'=>$rr->Unit,
                                        'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                        'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                        'tax_id'=>$rows->Product()->first()->Tax,
                                        'avalible_qty'=>$rows->Qty / $rr->Rate,
                                        'qty'=>1,
                                        'price'=>$pr,
                                        'discount'=>$DES,
                                        'total_discount_pro'=>$DES,
                                        'total_before_tax'=>$pr,
                                        'tax_value'=>0,
                                        'total'=>$pr,
                                        'store_id'=>$st->id,
                                        'store_name'=>$SName,
                                        'ExpDate'=>'',
                                        'serial'=>0,
                                        'high_disc'=>$Higher,
                                        'cost_price'=>$COSTpr,

                                    ]);



                                }

                            }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){

                                if($rows->Product()->first()->Status == 0){

                                    if($show->Group_Brand == 1){

                                        $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                    }else{
                                        $ShowGrBr='';
                                    }

                                    if(!empty($Cli)){

                                        if(!empty($Cli->Group)){
                                            $nwD=CustomersGroup::find($Cli->Group);

                                            $DES= $nwD->Discount ;

                                        }else{
                                            $DES=0;

                                        }

                                    }else{
                                        $DES=0;
                                    }

                                    if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                        $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                    }else{

                                        $Higher=0;
                                    }

                                    if(!empty($rows->Product()->first()->Image)){
                                        $img=URL::to($rows->Product()->first()->Image);
                                    }else{

                                        $img=URL::to('Admin/img/demo/gallery/5.jpg');
                                    }


                                    if($lang == 'ar'){
                                        $UName=$rr->Unit()->first()->Name;
                                        $SName=$st->Name;

                                    }else{

                                        $UName=$rr->Unit()->first()->NameEn;
                                        $SName=$st->NameEn;
                                    }
                                    array_push($Array,[
                                        'product_image'=>$img,
                                        'product_ar_name'=>$rows->P_Ar_Name,
                                        'product_en_name'=>$rows->P_En_Name,
                                        'product_id'=>$rows->Product,
                                        'virable_one_id'=>$rows->V1,
                                        'virable_two_id'=>$rows->V2,
                                        'virable_one_name'=>'',
                                        'virable_two_name'=>'',
                                        'product_code'=>$rr->Barcode,
                                        'unit_name'=>$UName,
                                        'unit_id'=>$rr->Unit,
                                        'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                        'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                        'tax_id'=>$rows->Product()->first()->Tax,
                                        'avalible_qty'=>$rows->Qty / $rr->Rate,
                                        'qty'=>1,
                                        'price'=>$pr,
                                        'discount'=>$DES,
                                        'total_discount_pro'=>$DES,
                                        'total_before_tax'=>$pr,
                                        'tax_value'=>0,
                                        'total'=>$pr,
                                        'store_id'=>$st->id,
                                        'store_name'=>$SName,
                                        'ExpDate'=>'',
                                        'serial'=>0,
                                        'high_disc'=>$Higher,
                                        'cost_price'=>$COSTpr,

                                    ]);


                                }

                            }
                        }
                    }
                }
            }



            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //SerachAllProductFilter
    public function SerachResturantAllProductFilter(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');
        if(!empty($admin)){

            $Array=array();


            $store = $request->get('store_id');
            $client = $request->get('client_id');

            $Prods=ProductsQty::where('Store',$store)->get();



            foreach($Prods as $rows){

                $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                $plow=ProductUnits::where('Product',$rows->Product)->where('Rate',1)->first();
                $purchs=ProductsPurchases::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total_Bf_Tax');
                $countPurchs=ProductsPurchases::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');
                $storesTransfer=ProductsStoresTransfers::where('Product',$rows->Product)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');
                $storesTransferCount=ProductsStoresTransfers::where('Product',$rows->Product)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallTrans_Qty');
                $purchsStart=ProductsStartPeriods::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');
                $countStart=ProductsStartPeriods::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');
                $OUTCOME=OutcomManufacturingModel::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Cost');
                $countOUTCOME=OutcomManufacturingModel::where('Product',$rows->Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');


                if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME)){

                    $Collect=$purchs + $storesTransfer + $purchsStart + $OUTCOME ;
                    $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;

                    if($CollectCount != 0){
                        $ty= $Collect /  $CollectCount ;

                        $COSTpr=number_format((float)abs($ty), 2, '.', '') * $rr->Rate;



                    }else{

                        $COSTpr=$Collect * $rr->Rate;
                    }

                }else{
                    $COSTpr=$rr->Price;

                }




                $Ser=ProductSalesOrder::where('Product',$rows->Product)->where('Product_Code',$rows->P_Code)->first();

                if($rows->Qty > 0){
                    if($rows->Store == $store){

                        $Stores=Stores::all();

                        $units=ProductUnits::where('Product',$rows->Product)->get();
                        $rr=ProductUnits::where('Product',$rows->Product)->where('Def',1)->first();
                        $x = ProductsQty::where("Unit",$rr->Unit)->where('Product',$rows->Product)->first();

                        $Cli=Customers::where('Account',$client)->first();

                        if(!empty($Cli)){

                            if($Cli->Price_Level == 1){

                                $pr= $rr->Price ;

                            }elseif($Cli->Price_Level == 2){

                                if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                    $pr= $rr->Price_Two ;

                                }else{

                                    $pr= $rr->Price ;

                                }

                            }elseif($Cli->Price_Level == 3){

                                if(!empty($rr->Price_Three) and $rr->Price_Three != 0 ){

                                    $pr= $rr->Price_Three ;

                                }else{

                                    $pr= $rr->Price ;

                                }

                            }

                        }else{


                            $Vend=Vendors::where('Account',$client)->first();

                            if(!empty($Vend)){
                                if($Vend->Price_Level == 1){

                                    $pr= $rr->Price ;

                                }elseif($Vend->Price_Level == 2){

                                    if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                        $pr= $rr->Price_Two ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }elseif($Vend->Price_Level == 3){

                                    if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                        $pr= $rr->Price_Three ;

                                    }else{

                                        $pr= $rr->Price ;

                                    }

                                }
                            }else{


                                $EMPO=Employess::where('Account_Emp',$client)->first();
                                if(!empty($EMPO)){
                                    if($EMPO->Price_Level == 1){

                                        $pr= $rr->Price ;

                                    }elseif($EMPO->Price_Level == 2){

                                        if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                            $pr= $rr->Price_Two ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }elseif($EMPO->Price_Level == 3){

                                        if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                            $pr= $rr->Price_Three ;

                                        }else{

                                            $pr= $rr->Price ;

                                        }

                                    }
                                }else{

                                    $pr=$rr->Price;
                                }

                            }


                        }

                        if($rows->Original != null){

                            $pr=0;
                        }

                        if(!empty($rows->Product()->first()->Brand)){

                            $brandd=$rows->Product()->first()->Brand()->first()->Name;
                        }else{

                            $brandd="";

                        }

                        $st=Stores::find($store);

                        $show=DefaultDataShowHide::orderBy('id','desc')->first();
                        if($rows->Product()->first()->P_Type == 'Completed' or $rows->Product()->first()->P_Type == 'Raw' or $rows->Product()->first()->P_Type == 'Industrial' or $rows->Product()->first()->P_Type == 'Additions'){

                            if($rows->Product()->first()->Status == 0){

                                if($show->Group_Brand == 1){

                                    $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                }else{
                                    $ShowGrBr='';
                                }

                                if(!empty($Cli)){

                                    if(!empty($Cli->Group)){
                                        $nwD=CustomersGroup::find($Cli->Group);

                                        $DES= $nwD->Discount ;

                                    }else{
                                        $DES=0;

                                    }

                                }else{
                                    $DES=0;
                                }

                                if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                    $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                }else{

                                    $Higher=0;
                                }

                                if(!empty($rows->Product()->first()->Image)){
                                    $img=URL::to($rows->Product()->first()->Image);
                                }else{

                                    $img=URL::to('Admin/img/demo/gallery/5.jpg');
                                }



                                if($lang == 'ar'){
                                    $UName=$rr->Unit()->first()->Name;
                                    $SName=$st->Name;

                                }else{

                                    $UName=$rr->Unit()->first()->NameEn;
                                    $SName=$st->NameEn;
                                }

                                array_push($Array,[
                                    'product_image'=>$img,
                                    'product_ar_name'=>$rows->P_Ar_Name,
                                    'product_en_name'=>$rows->P_En_Name,
                                    'product_id'=>$rows->Product,
                                    'virable_one_id'=>$rows->V1,
                                    'virable_two_id'=>$rows->V2,
                                    'virable_one_name'=>'',
                                    'virable_two_name'=>'',
                                    'product_code'=>$rr->Barcode,
                                    'unit_name'=>$UName,
                                    'unit_id'=>$rr->Unit,
                                    'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                    'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                    'tax_id'=>$rows->Product()->first()->Tax,
                                    'avalible_qty'=>$rows->Qty / $rr->Rate,
                                    'qty'=>1,
                                    'price'=>$pr,
                                    'discount'=>$DES,
                                    'total_discount_pro'=>$DES,
                                    'total_before_tax'=>$pr,
                                    'tax_value'=>0,
                                    'total'=>$pr,
                                    'store_id'=>$st->id,
                                    'store_name'=>$SName,
                                    'ExpDate'=>'',
                                    'serial'=>0,
                                    'high_disc'=>$Higher,
                                    'cost_price'=>$COSTpr,

                                ]);

                            }

                        }elseif($rows->Product()->first()->P_Type == 'Serial'){
                            if(empty($Ser)){

                                if($rows->Product()->first()->Status == 0){

                                    if($show->Group_Brand == 1){

                                        $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                    }else{
                                        $ShowGrBr='';
                                    }

                                    if(!empty($Cli)){

                                        if(!empty($Cli->Group)){
                                            $nwD=CustomersGroup::find($Cli->Group);

                                            $DES= $nwD->Discount ;

                                        }else{
                                            $DES=0;

                                        }

                                    }else{
                                        $DES=0;
                                    }

                                    if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                        $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                    }else{

                                        $Higher=0;
                                    }

                                    if(!empty($rows->Product()->first()->Image)){
                                        $img=URL::to($rows->Product()->first()->Image);
                                    }else{

                                        $img=URL::to('Admin/img/demo/gallery/5.jpg');
                                    }


                                    if($lang == 'ar'){
                                        $UName=$rr->Unit()->first()->Name;
                                        $SName=$st->Name;

                                    }else{

                                        $UName=$rr->Unit()->first()->NameEn;
                                        $SName=$st->NameEn;
                                    }

                                    array_push($Array,[
                                        'product_image'=>$img,
                                        'product_ar_name'=>$rows->P_Ar_Name,
                                        'product_en_name'=>$rows->P_En_Name,
                                        'product_id'=>$rows->Product,
                                        'virable_one_id'=>$rows->V1,
                                        'virable_two_id'=>$rows->V2,
                                        'virable_one_name'=>'',
                                        'virable_two_name'=>'',
                                        'product_code'=>$rr->Barcode,
                                        'unit_name'=>$UName,
                                        'unit_id'=>$rr->Unit,
                                        'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                        'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                        'tax_id'=>$rows->Product()->first()->Tax,
                                        'avalible_qty'=>$rows->Qty / $rr->Rate,
                                        'qty'=>1,
                                        'price'=>$pr,
                                        'discount'=>$DES,
                                        'total_discount_pro'=>$DES,
                                        'total_before_tax'=>$pr,
                                        'tax_value'=>0,
                                        'total'=>$pr,
                                        'store_id'=>$st->id,
                                        'store_name'=>$SName,
                                        'ExpDate'=>'',
                                        'serial'=>0,
                                        'high_disc'=>$Higher,
                                        'cost_price'=>$COSTpr,

                                    ]);



                                }

                            }
                        }elseif($rows->Product()->first()->P_Type == 'Single_Variable'){

                            if($rows->Product()->first()->Status == 0){

                                if($show->Group_Brand == 1){

                                    $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                }else{
                                    $ShowGrBr='';
                                }

                                if(!empty($Cli)){

                                    if(!empty($Cli->Group)){
                                        $nwD=CustomersGroup::find($Cli->Group);

                                        $DES= $nwD->Discount ;

                                    }else{
                                        $DES=0;

                                    }

                                }else{
                                    $DES=0;
                                }

                                if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                    $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                }else{

                                    $Higher=0;
                                }

                                if(!empty($rows->Product()->first()->Image)){
                                    $img=URL::to($rows->Product()->first()->Image);
                                }else{

                                    $img=URL::to('Admin/img/demo/gallery/5.jpg');
                                }


                                if($lang == 'ar'){
                                    $UName=$rr->Unit()->first()->Name;
                                    $SName=$st->Name;

                                }else{

                                    $UName=$rr->Unit()->first()->NameEn;
                                    $SName=$st->NameEn;
                                }

                                array_push($Array,[
                                    'product_image'=>$img,
                                    'product_ar_name'=>$rows->P_Ar_Name,
                                    'product_en_name'=>$rows->P_En_Name,
                                    'product_id'=>$rows->Product,
                                    'virable_one_id'=>$rows->V1,
                                    'virable_two_id'=>$rows->V2,
                                    'virable_one_name'=>'',
                                    'virable_two_name'=>'',
                                    'product_code'=>$rr->Barcode,
                                    'unit_name'=>$UName,
                                    'unit_id'=>$rr->Unit,
                                    'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                    'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                    'tax_id'=>$rows->Product()->first()->Tax,
                                    'avalible_qty'=>$rows->Qty / $rr->Rate,
                                    'qty'=>1,
                                    'price'=>$pr,
                                    'discount'=>$DES,
                                    'total_discount_pro'=>$DES,
                                    'total_before_tax'=>$pr,
                                    'tax_value'=>0,
                                    'total'=>$pr,
                                    'store_id'=>$st->id,
                                    'store_name'=>$SName,
                                    'ExpDate'=>'',
                                    'serial'=>0,
                                    'high_disc'=>$Higher,
                                    'cost_price'=>$COSTpr,

                                ]);


                            }

                        }elseif($rows->Product()->first()->P_Type == 'Duble_Variable'){

                            if($rows->Product()->first()->Status == 0){

                                if($show->Group_Brand == 1){

                                    $ShowGrBr= '('.$brandd.') ('.$rows->Product()->first()->Group()->first()->Name.')';
                                }else{
                                    $ShowGrBr='';
                                }

                                if(!empty($Cli)){

                                    if(!empty($Cli->Group)){
                                        $nwD=CustomersGroup::find($Cli->Group);

                                        $DES= $nwD->Discount ;

                                    }else{
                                        $DES=0;

                                    }

                                }else{
                                    $DES=0;
                                }

                                if(!empty($rows->Product()->first()->Group()->first()->Discount)){
                                    $Higher=$rows->Product()->first()->Group()->first()->Discount;
                                }else{

                                    $Higher=0;
                                }

                                if(!empty($rows->Product()->first()->Image)){
                                    $img=URL::to($rows->Product()->first()->Image);
                                }else{

                                    $img=URL::to('Admin/img/demo/gallery/5.jpg');
                                }


                                if($lang == 'ar'){
                                    $UName=$rr->Unit()->first()->Name;
                                    $SName=$st->Name;

                                }else{

                                    $UName=$rr->Unit()->first()->NameEn;
                                    $SName=$st->NameEn;
                                }

                                array_push($Array,[
                                    'product_image'=>$img,
                                    'product_ar_name'=>$rows->P_Ar_Name,
                                    'product_en_name'=>$rows->P_En_Name,
                                    'product_id'=>$rows->Product,
                                    'virable_one_id'=>$rows->V1,
                                    'virable_two_id'=>$rows->V2,
                                    'virable_one_name'=>'',
                                    'virable_two_name'=>'',
                                    'product_code'=>$rr->Barcode,
                                    'unit_name'=>$UName,
                                    'unit_id'=>$rr->Unit,
                                    'tax_rate'=>$rows->Product()->first()->Tax()->first()->Rate,
                                    'tax_type'=>$rows->Product()->first()->Tax()->first()->Type,
                                    'tax_id'=>$rows->Product()->first()->Tax,
                                    'avalible_qty'=>$rows->Qty / $rr->Rate,
                                    'qty'=>1,
                                    'price'=>$pr,
                                    'discount'=>$DES,
                                    'total_discount_pro'=>$DES,
                                    'total_before_tax'=>$pr,
                                    'tax_value'=>0,
                                    'total'=>$pr,
                                    'store_id'=>$st->id,
                                    'store_name'=>$SName,
                                    'ExpDate'=>'',
                                    'serial'=>0,
                                    'high_disc'=>$Higher,
                                    'cost_price'=>$COSTpr,

                                ]);


                            }

                        }

                    }
                }
            }



            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }



    //ResturantAdditionsProducts
    public function ResturantAdditionsProducts(Request $request){


        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');
        if(!empty($admin)){

            $Array=array();



            $Pro = $request->get('product_id');
            $store = $request->get('store_id');
            $client = $request->get('client_id');
            $Prods=AdditionalProducts::where('Product',$Pro)->get();


            foreach($Prods as $rows){

                $show=DefaultDataShowHide::orderBy('id','desc')->first();
                $rr=ProductUnits::where('Product',$rows->Additional_Product)->where('Def',1)->first();
                $plow=ProductUnits::where('Product',$rows->Additional_Product)->where('Rate',1)->first();
                $purchs=ProductsPurchases::where('Product',$rows->Additional_Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total_Bf_Tax');
                $countPurchs=ProductsPurchases::where('Product',$rows->Additional_Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');
                $AdditionsCount=AdditionalProducts::where('Product',$rows->Additional_Product)->count();


                $proUni=ProductUnits::where('Product',$rows->Additional_Product)->first();



                $AvQty=ProductsQty::
                where('Product',$rows->Additional_Product)
                    ->where('Store',$store)
                    ->where('P_Code',$proUni->Barcode)
                    ->first();

                if(empty($AvQty)){

                    $AvQty=ProductsQty::
                    where('Product',$rows->Additional_Product)
                        ->where('Store',$store)
                        ->where('PP_Code',$proUni->Barcode)
                        ->first();

                    if(empty($AvQty)){

                        $AvQty=ProductsQty::
                        where('Product',$rows->Additional_Product)
                            ->where('Store',$store)
                            ->where('PPP_Code',$proUni->Barcode)
                            ->first();


                        if(empty($AvQty)){

                            $AvQty=ProductsQty::
                            where('Product',$rows->Additional_Product)
                                ->where('Store',$store)
                                ->where('PPPP_Code',$proUni->Barcode)
                                ->first();

                        }



                    }


                }





                $storesTransfer=ProductsStoresTransfers::where('Product',$rows->Additional_Product)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');

                $storesTransferCount=ProductsStoresTransfers::where('Product',$rows->Additional_Product)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallTrans_Qty');

                $purchsStart=ProductsStartPeriods::where('Product',$rows->Additional_Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');
                $countStart=ProductsStartPeriods::where('Product',$rows->Additional_Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');

                $OUTCOME=OutcomManufacturingModel::where('Product',$rows->Additional_Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Cost');

                $countOUTCOME=OutcomManufacturingModel::where('Product',$rows->Additional_Product)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');

                $x = ProductsQty::where("Unit",$rr->Unit)
                    ->where('P_Code',$rr->Barcode)
                    ->orWhere('PP_Code',$rr->Barcode)
                    ->orWhere('PPP_Code',$rr->Barcode)
                    ->orWhere('PPPP_Code',$rr->Barcode)
                    ->orWhere('Product',$rows->id)->first();
                if(!empty($x)){

                    if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME)){

                        $Collect=$purchs + $storesTransfer + $purchsStart + $OUTCOME ;
                        $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;

                        if($CollectCount != 0){
                            $ty= $Collect /  $CollectCount ;

                            $COSTpr=number_format((float)abs($ty), 2, '.', '') * $rr->Rate;



                        }else{

                            $COSTpr=$Collect * $rr->Rate;
                        }

                    }else{
                        $COSTpr=$x->Price;

                    }



                }else{
                    $COSTpr=$rr->Price;
                }


                $Stores=Stores::all();
                $units=ProductUnits::where('Product',$rows->Additional_Product)->get();
                $rr=ProductUnits::where('Product',$rows->Additional_Product)->where('Def',1)->first();
                $x = ProductsQty::where("Unit",$rr->Unit)->where('Product',$rows->Additional_Product)->first();

                $Cli=Customers::where('Account',$client)->first();

                if(!empty($Cli)){

                    if($Cli->Price_Level == 1){

                        $pr= $rr->Price ;

                    }elseif($Cli->Price_Level == 2){

                        if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                            $pr= $rr->Price_Two ;

                        }else{

                            $pr= $rr->Price ;

                        }

                    }elseif($Cli->Price_Level == 3){

                        if(!empty($rr->Price_Three) and $rr->Price_Three != 0 ){

                            $pr= $rr->Price_Three ;

                        }else{

                            $pr= $rr->Price ;

                        }

                    }

                }else{


                    $Vend=Vendors::where('Account',$client)->first();

                    if(!empty($Vend)){
                        if($Vend->Price_Level == 1){

                            $pr= $rr->Price ;

                        }elseif($Vend->Price_Level == 2){

                            if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                $pr= $rr->Price_Two ;

                            }else{

                                $pr= $rr->Price ;

                            }

                        }elseif($Vend->Price_Level == 3){

                            if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                $pr= $rr->Price_Three ;

                            }else{

                                $pr= $rr->Price ;

                            }

                        }
                    }else{


                        $EMPO=Employess::where('Account_Emp',$client)->first();
                        if(!empty($EMPO)){
                            if($EMPO->Price_Level == 1){

                                $pr= $rr->Price ;

                            }elseif($EMPO->Price_Level == 2){

                                if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                                    $pr= $rr->Price_Two ;

                                }else{

                                    $pr= $rr->Price ;

                                }

                            }elseif($EMPO->Price_Level == 3){

                                if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                                    $pr= $rr->Price_Three ;

                                }else{

                                    $pr= $rr->Price ;

                                }

                            }
                        }else{

                            $pr=$rr->Price;
                        }

                    }


                }
                if(!empty($Cli)){

                    if(!empty($Cli->Group)){
                        $nwD=CustomersGroup::find($Cli->Group);

                        $DES= $nwD->Discount ;

                    }else{
                        $DES=0;

                    }

                }else{
                    $DES=0;
                }

                if(!empty($rows->Additional_Product()->first()->Group()->first()->Discount)){
                    $Higher=$rows->Additional_Product()->first()->Group()->first()->Discount;
                }else{

                    $Higher=0;
                }



                if(!empty($rows->Additional_Product()->first()->Brand)){

                    $brandd=$rows->Additional_Product()->first()->Brand()->first()->Name;
                }else{

                    $brandd="";

                }

                $st=Stores::find($store);

                if(!empty($rows->Additional_Product()->first()->Image)){
                    $img='<img src="'.URL::to($rows->Product()->first()->Image).'" alt="">';
                }else{

                    $img='<img src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                }

                if($rows->Additional_Product()->first()->P_Type == 'Additions'){

                    if($rows->Additional_Product()->first()->Status == 0){

                        $st=Stores::find($store);

                        if(app()->getLocale() == 'ar' ){
                            $PrrroName=$rows->Additional_Product()->first()->P_Ar_Name;
                            $UniiName=$rr->Unit()->first()->Name;

                            $SName=$st->Name;

                        }else{
                            $PrrroName=$rows->Additional_Product()->first()->P_En_Name;
                            $UniiName=$rr->Unit()->first()->NameEn;
                            $SName=$st->NameEn;

                        }


                        if($AvQty->Qty  != 0){



                            array_push($Array,[
                                'product_ar_name'=>$rows->Additional_Product()->first()->P_Ar_Name,
                                'product_en_name'=>$rows->Additional_Product()->first()->P_En_Name,
                                'product_id'=>$rows->Additional_Product,
                                'virable_one_id'=>$rows->V1,
                                'virable_two_id'=>$rows->V2,
                                'virable_one_name'=>'',
                                'virable_two_name'=>'',
                                'product_code'=>$rr->Barcode,
                                'unit_name'=>$UName,
                                'unit_id'=>$rr->Unit,
                                'tax_rate'=>$rows->Additional_Product()->first()->Tax()->first()->Rate,
                                'tax_type'=>$rows->Additional_Product()->first()->Tax()->first()->Type,
                                'tax_id'=>$rows->Additional_Product()->first()->Tax,
                                'avalible_qty'=>$AvQty->Qty,
                                'qty'=>1,
                                'price'=>$pr,
                                'discount'=>$DES,
                                'total_discount_pro'=>$DES,
                                'total_before_tax'=>$pr,
                                'tax_value'=>0,
                                'total'=>$pr,
                                'store_id'=>$st->id,
                                'store_name'=>$SName,
                                'ExpDate'=>'',
                                'serial'=>0,
                                'high_disc'=>$Higher,
                                'cost_price'=>$COSTpr,
                                'additions_count'=>$AdditionsCount,

                            ]);


                        }




                    }
                }
            }




            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


    //ResturantVAssemblyQtyFilter
    public function ResturantVAssemblyQtyFilter(Request $request){


        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');
        if(!empty($admin)){

            $Array=array();



            $pro=request('product_id');
            $store=request('store_id');
            $ProNote=VAPrice::where('Product',$pro)->get();


            foreach($ProNote as $pro){

                $rr=ProductUnits::where('Product',$pro->Product)->where('Def',1)->first();
                $AdditionsCount=AdditionalProducts::where('Product',$pro->Product)->count();
                $st=Stores::find($store);
                if(app()->getLocale() == 'ar' ){
                    $PrrroName=$pro->Product()->first()->P_Ar_Name;
                    $PrrroNameV=$pro->SubV()->first()->Name;
                    $UniiName=$rr->Unit()->first()->Name;
                }else{
                    $PrrroName=$pro->Product()->first()->P_En_Name;
                    $PrrroNameV=$pro->SubV()->first()->NameEn;
                    $UniiName=$rr->Unit()->first()->NameEn;
                }

                $QTYs=VAQty::
                where('Product',$pro->Product)
                    ->where('SubV',$pro->SubV)
                    ->get();

                $QTYsCount=VAQty::
                where('Product',$pro->Product)
                    ->where('SubV',$pro->SubV)
                    ->count();



                foreach($QTYs as $qty){

                    $AvQty=ProductsQty::
                    where('Product',$qty->ProductID)
                        ->where('Store',$store)
                        ->where('P_Code',$qty->VAProductID()->first()->Product_Code)
                        ->first();



                    if(empty($AvQty)){

                        $AvQty=ProductsQty::
                        where('Product',$qty->ProductID)
                            ->where('Store',$store)
                            ->where('PP_Code',$qty->VAProductID()->first()->Product_Code)
                            ->first();

                        if(empty($AvQty)){

                            $AvQty=ProductsQty::
                            where('Product',$qty->ProductID)
                                ->where('Store',$store)
                                ->where('PPP_Code',$qty->VAProductID()->first()->Product_Code)
                                ->first();


                            if(empty($AvQty)){

                                $AvQty=ProductsQty::
                                where('Product',$qty->ProductID)
                                    ->where('Store',$store)
                                    ->where('PPPP_Code',$qty->VAProductID()->first()->Product_Code)
                                    ->first();

                            }



                        }


                    }

                    if(!empty($AvQty)){

                        if($AvQty->Qty >= $qty->Qty){
                            $Avalible+=1;

                        }else{
                            $Avalible+=0;
                        }
                    }else{
                        $Avalible +=0;

                    }


                    $rr=ProductUnits::where('Product',$qty->ProductID)->where('Def',1)->first();
                    $plow=ProductUnits::where('Product',$qty->ProductID)->where('Rate',1)->first();
                    $purchs=ProductsPurchases::where('Product',$qty->ProductID)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total_Bf_Tax');
                    $countPurchs=ProductsPurchases::where('Product',$qty->ProductID)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');
                    $AdditionsCount=AdditionalProducts::where('Product',$qty->ProductID)->count();

                    $storesTransfer=ProductsStoresTransfers::where('Product',$qty->ProductID)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');

                    $storesTransferCount=ProductsStoresTransfers::where('Product',$qty->ProductID)->where('To_Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallTrans_Qty');

                    $purchsStart=ProductsStartPeriods::where('Product',$qty->ProductID)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Total');
                    $countStart=ProductsStartPeriods::where('Product',$qty->ProductID)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');

                    $OUTCOME=OutcomManufacturingModel::where('Product',$qty->ProductID)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('Cost');

                    $countOUTCOME=OutcomManufacturingModel::where('Product',$qty->ProductID)->where('Store',$store)->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');

                    if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME)){

                        $Collect=$purchs + $storesTransfer + $purchsStart + $OUTCOME ;
                        $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;

                        if($CollectCount != 0){
                            $ty= $Collect /  $CollectCount ;

                            $COSTpr +=number_format((float)abs($ty), 2, '.', '') * $rr->Rate;



                        }else{

                            $COSTpr +=$Collect * $rr->Rate;
                        }

                    }else{
                        $COSTpr +=$rr->Price;

                    }




                }

                $st=Stores::find($store);
                $SName=$st->Name;
                if($QTYsCount == $Avalible){

                    array_push($Array,[
                        'subV_id'=>$pro->SubV,
                        'subV_name'=>$PrrroNameV,
                        'product_ar_name'=>$pro->Product()->first()->P_Ar_Name,
                        'product_en_name'=>$pro->Product()->first()->P_En_Name,
                        'product_id'=>$pro->Product,
                        'virable_one_id'=>'',
                        'virable_two_id'=>'',
                        'virable_one_name'=>'',
                        'virable_two_name'=>'',
                        'product_code'=>$rr->Barcode,
                        'unit_name'=>$UName,
                        'unit_id'=>$rr->Unit,
                        'tax_rate'=>$pro->Product()->first()->Tax()->first()->Rate,
                        'tax_type'=>$pro->Product()->first()->Tax()->first()->Type,
                        'tax_id'=>$pro->Product()->first()->Tax,
                        'avalible_qty'=>1,
                        'qty'=>1,
                        'price'=>$pro->Price,
                        'discount'=>0,
                        'total_discount_pro'=>0,
                        'total_before_tax'=>$pro->Price,
                        'tax_value'=>0,
                        'total'=>$pro->Price,
                        'store_id'=>$st->id,
                        'store_name'=>$SName,
                        'ExpDate'=>'',
                        'serial'=>0,
                        'high_disc'=>0,
                        'cost_price'=>$COSTpr,
                        'additions_count'=>$AdditionsCount,

                    ]);


                }




            }




            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


    //ResturantWaiters
    public function ResturantWaiters(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();


        $types = Employess::
        where('Emp_Type','Waiter')
            ->where("EmpSort",1)->where('Active',1)
            ->get();


        if($lang == 'ar'){


            foreach($types as $ty){

                array_push($Array,[
                    'id'=>$ty->id,
                    'name'=>$ty->Name,
                ]);

            }

        }else{


            foreach($types as $ty){

                array_push($Array,[
                    'id'=>$ty->id,
                    'name'=>$ty->NameEn,

                ]);

            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }



    //ResturantReservedTables
    public function ResturantReservedTables(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();


        $Tables=ResturantTables::get();



        foreach($Tables as $table){


            $xx=SalesOrder::
            where('Table',$table->id)
                ->where('ResturantOrderType','Hall')
                ->where('RecivedOrder',0)
                ->orderBy('id','desc')->first();
            if(!empty($xx)){

                if(app()->getLocale() == 'ar' ){
                    $Nemo=$table->Arabic_Name;
                }else{
                    $Nemo=$table->English_Name;

                }



                array_push($Array,[
                    'id'=>$xx->id,
                    'table'=>$table->Table_Number,
                    'bill_number'=>$xx->Code,
                    'date'=>$xx->Date,
                    'total_price'=>$xx->Total_Price,
                ]);

            }

        }



        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }


    //ResturantAVTables
    public function ResturantAVTables(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();



        $Tables=ResturantTables::get();


        if($lang == 'ar'){


            foreach($Tables as $table){

                $xx=SalesOrder::
                where('Table',$table->id)
                    ->where('ResturantOrderType','Hall')
                    ->where('RecivedOrder',0)
                    ->orderBy('id','desc')->first();

                if(empty($xx)){
                    array_push($Array,[
                        'id'=>$table->id,
                        'name'=>$table->Arabic_Name,


                    ]);

                }

            }

        }else{


            foreach($Tables as $table){

                $xx=SalesOrder::
                where('Table',$table->id)
                    ->where('ResturantOrderType','Hall')
                    ->where('RecivedOrder',0)
                    ->orderBy('id','desc')->first();

                if(empty($xx)){
                    array_push($Array,[
                        'id'=>$table->id,
                        'name'=>$table->English_Name,


                    ]);

                }

            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }



//ResturantAddNewTable

    public function ResturantAddNewTable(Request $request){

        $lang = $request->header('lang', '');


        $Array=array();

        $data['Arabic_Name']=request('TableName');
        $data['English_Name']=request('TableName');
        $data['Place_Ar']=request('TablePlace');
        $data['Place_En']=request('TablePlace');
        $data['Table_Number']=request('TableNumber');
        $data['Chairs_Num']=request('ChairsNum');


        ResturantTables::create($data);




        $table=ResturantTables::orderBy('id','desc')->first();

        $dataa['QR']=URL::to('/ScanQR?Table='.$table->id);

        ResturantTables::where('id',$table->id)->update($dataa);


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),


        ]);

    }




    //AllTablesReservedHall
    public function AllTablesReservedHall(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();



        $Tables=ResturantTables::get();


        if($lang == 'ar'){


            foreach($Tables as $table){

                $xx=SalesOrder::
                where('Table',$table->id)
                    ->where('ResturantOrderType','Hall')
                    ->where('RecivedOrder',0)
                    ->orderBy('id','desc')->first();

                if(!empty($xx)){
                    array_push($Array,[
                        'table_id'=>$table->id,
                        'name'=>$table->Arabic_Name,
                        'order_id'=>$xx->id,


                    ]);

                }

            }

        }else{


            foreach($Tables as $table){

                $xx=SalesOrder::
                where('Table',$table->id)
                    ->where('ResturantOrderType','Hall')
                    ->where('RecivedOrder',0)
                    ->orderBy('id','desc')->first();

                if(!empty($xx)){
                    array_push($Array,[
                        'table_id'=>$table->id,
                        'name'=>$table->English_Name,
                        'order_id'=>$xx->id,


                    ]);

                }

            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }


    //PostMergTablesApi

    public function PostMergTablesApi(Request $request){

        $lang = $request->header('lang', '');


        $Orders=request('order_id');

        $xx=SalesOrder::
        where('Table',request('table_id'))
            ->where('ResturantOrderType','Hall')
            ->where('RecivedOrder',0)
            ->orderBy('id','desc')->first();

        for($i=0 ; $i  < count($Orders) ; $i++ ){

            $SalesOrder=SalesOrder::find($Orders[$i]);

            if($SalesOrder->Table != request('MainTable')){

                $Prodcts=ProductSalesOrder::where('SalesOrder',$SalesOrder->id)->get();

                foreach($Prodcts  as $pro){
                    $uu['Product_Code']=$pro->Product_Code;
                    $uu['P_Ar_Name']=$pro->P_Ar_Name;
                    $uu['P_En_Name']=$pro->P_En_Name;
                    $uu['V_Name']=$pro->V_Name;
                    $uu['VV_Name']=$pro->VV_Name;
                    $uu['Original_Qty']=$pro->Original_Qty;
                    $uu['Qty']=$pro->Qty;
                    $uu['AvQty']=$pro->AvQty;
                    $uu['Price']=$pro->Price;
                    $uu['Discount']=$pro->Discount;
                    $uu['Tax']=$pro->Tax;
                    $uu['Total_Bf_Tax']=$pro->Total_Bf_Tax;
                    $uu['Total_Tax']=$pro->Total_Tax;
                    $uu['Total']=$pro->Total;
                    $uu['Store']=$pro->Store;
                    $uu['Product']=$pro->Product;
                    $uu['Unit']=$pro->Unit;
                    $uu['Exp_Date']=$pro->Exp_Date;
                    $uu['SalesOrder']=$xx->id;
                    $uu['V1']=$pro->V1;
                    $uu['V2']=$pro->V2;
                    $uu['SubVID']=$pro->SubVID;
                    $uu['TDiscount']=$pro->TDiscount;
                    $uu['Pro_Note']=$pro->Pro_Note;
                    ProductSalesOrder::create($uu);
                }



                $xxx=SalesOrder::
                where('Table',request('table_id'))
                    ->where('ResturantOrderType','Hall')
                    ->where('RecivedOrder',0)
                    ->orderBy('id','desc')->first();
                $OldOne=SalesOrder::find($Orders[$i]);

                $Product_Numbers=$xxx->Product_Numbers + $OldOne->Product_Numbers;
                $Total_Qty=$xxx->Total_Qty + $OldOne->Total_Qty;
                $Total_Discount=$xxx->Total_Discount + $OldOne->Total_Discount;
                $Total_BF_Taxes=$xxx->Total_BF_Taxes + $OldOne->Total_BF_Taxes;
                $Total_Taxes=$xxx->Total_Taxes + $OldOne->Total_Taxes;
                $Total_Price=$xxx->Total_Price + $OldOne->Total_Price;
                $Pay=$xxx->Pay + $OldOne->Pay;

                SalesOrder::where('id',$xxx->id)->update([
                    'Product_Numbers'=>$Product_Numbers,
                    'Total_Qty'=>$Total_Qty,
                    'Total_Discount'=>$Total_Discount,
                    'Total_BF_Taxes'=>$Total_BF_Taxes,
                    'Total_Taxes'=>$Total_Taxes,
                    'Total_Price'=>$Total_Price,
                    'Pay'=>$Pay,

                ]);

                SalesOrder::where('id',$Orders[$i])->delete();

            }



        }




        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),


        ]);

    }


    //PostMovingApi

    public function PostMovingApi(Request $request){

        $lang = $request->header('lang', '');


        $xx=SalesOrder::
        where('Table',request('table_id'))
            ->where('ResturantOrderType','Hall')
            ->where('RecivedOrder',0)
            ->orderBy('id','desc')->first();


        SalesOrder::where('id',$xx->id)->update(['Table'=>request('MainTable')]);


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),


        ]);

    }




    //SeparatingDataTablesApi
    public function SeparatingDataTablesApi(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();
        $ArrayPros=array();



        $Tables=ResturantTables::get();


        if($lang == 'ar'){


            foreach($Tables as $table){

                $xx=SalesOrder::
                where('Table',$table->id)
                    ->where('ResturantOrderType','Hall')
                    ->where('RecivedOrder',0)
                    ->orderBy('id','desc')->first();

                if(!empty($xx)){

                    $Prodcts=ProductSalesOrder::where('SalesOrder',$xx->id)->get();


                    foreach($Prodcts as $pro){
                        array_push($ArrayPros,[
                            'pro_id'=>$pro->id,
                            'product_code'=>$pro->Product_Code,
                            'product_name'=>$pro->P_Ar_Name,
                            'qty'=>$pro->Qty,
                            'price'=>$pro->Price,
                            'total'=>$pro->Total,


                        ]);
                    }


                    array_push($Array,[
                        'table_id'=>$table->id,
                        'name'=>$table->Arabic_Name,
                        'order_id'=>$xx->id,
                        'products'=>$ArrayPros,


                    ]);

                }

            }

        }else{


            foreach($Tables as $table){

                $xx=SalesOrder::
                where('Table',$table->id)
                    ->where('ResturantOrderType','Hall')
                    ->where('RecivedOrder',0)
                    ->orderBy('id','desc')->first();

                if(!empty($xx)){


                    $Prodcts=ProductSalesOrder::where('SalesOrder',$xx->id)->get();


                    foreach($Prodcts as $pro){
                        array_push($ArrayPros,[
                            'pro_id'=>$pro->id,
                            'product_code'=>$pro->Product_Code,
                            'product_name'=>$pro->P_En_Name,
                            'qty'=>$pro->Qty,
                            'price'=>$pro->Price,
                            'total'=>$pro->Total,


                        ]);
                    }





                    array_push($Array,[
                        'table_id'=>$table->id,
                        'name'=>$table->English_Name,
                        'order_id'=>$xx->id,
                        'products'=>$ArrayPros,

                    ]);

                }

            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }


    //PostSeparatingApi

    public function PostSeparatingApi(Request $request){

        $lang = $request->header('lang', '');


        $xx=SalesOrder::find(request('order_id'));

        $ProID=request('pro_id');


        $ID = DB::table('sales_orders')->insertGetId(
            array(


                'Date' => $xx->Date,
                'Draw' =>$xx->Draw,
                'Payment_Method' =>$xx->Payment_Method,
                'Status' => $xx->Status,
                'Refernce_Number' => $xx->Refernce_Number,
                'Note' => $xx->Note,
                'Product_Numbers' =>0,
                'Total_Qty' => 0,
                'Total_Discount' => 0,
                'Total_BF_Taxes' =>0,
                'Total_Taxes' => 0,
                'Total_Price' => 0,
                'Pay' => 0,
                'Safe' => $xx->Safe,
                'ToSales' => 0,
                'Client' => $xx->Client,
                'Delegate' => $xx->Delegate,
                'Executor' => $xx->Executor,
                'Store' =>  $xx->Store,
                'Coin' =>  $xx->Coin,
                'Cost_Center' => null,
                'presenter' =>$xx->presenter,
                'annual_interest' => $xx->annual_interest,
                'monthly_installment' => $xx->monthly_installment,
                'Years_Number' =>$xx->Years_Number,
                'total' => $xx->total,
                'Order_Type' => 'Resturant',

                'TakeawayStatus' => 0,
                'TakeawayTime' => null,
                'Witer' => $xx->Witer,
                'KitchenEnd' => $xx->KitchenEnd,
                'KitchenEndTime' => $xx->KitchenEndTime,
                'RecivedOrder' => 0,
                'RecivedOrderTime' => null,
                'Delivery_Status' =>0,
                'DeliveryTime' => null,
                'ResturantOrderType' => $xx->ResturantOrderType,
                'Table' => request('MainTable'),

                'Quote' => null,
                'Hold' => 1,
                'installment_Num' => $xx->installment_Num,
                'Date_First_installment' => $xx->Date_First_installment,
                'User' => auth()->guard('admin')->user()->id,

            )
        );


        $res=SalesOrder::where('id',$ID)->first();

        $Code=$res->Code;



        for($i=0 ; $i < count($ProID) ; $i++){
            $Prodct=ProductSalesOrder::find($ProID[$i]);

            $uu['Product_Code']=$Prodct->Product_Code;
            $uu['P_Ar_Name']=$Prodct->P_Ar_Name;
            $uu['P_En_Name']=$Prodct->P_En_Name;
            $uu['V_Name']=$Prodct->V_Name;
            $uu['VV_Name']=$Prodct->VV_Name;
            $uu['Original_Qty']=$Prodct->Original_Qty;
            $uu['Qty']=$Prodct->Qty;
            $uu['AvQty']=$Prodct->AvQty;
            $uu['Price']=$Prodct->Price;
            $uu['Discount']=$Prodct->Discount;
            $uu['Tax']=$Prodct->Tax;
            $uu['Total_Bf_Tax']=$Prodct->Total_Bf_Tax;
            $uu['Total_Tax']=$Prodct->Total_Tax;
            $uu['Total']=$Prodct->Total;
            $uu['Store']=$Prodct->Store;
            $uu['Product']=$Prodct->Product;
            $uu['Unit']=$Prodct->Unit;
            $uu['Exp_Date']=$Prodct->Exp_Date;
            $uu['SalesOrder']=$ID;
            $uu['V1']=$Prodct->V1;
            $uu['V2']=$Prodct->V2;
            $uu['SubVID']=$Prodct->SubVID;
            $uu['TDiscount']=$Prodct->TDiscount;
            $uu['Pro_Note']=$Prodct->Pro_Note;
            ProductSalesOrder::create($uu);

            $xxx=SalesOrder::find(request('order_id'));



            $Product_Numbers=$xxx->Product_Numbers - 1;
            $Total_Qty=$xxx->Total_Qty - $Prodct->Qty;
            $Total_Discount=$xxx->Total_Discount - $Prodct->Discount;
            $Total_BF_Taxes=$xxx->Total_BF_Taxes - $Prodct->Total_Bf_Tax;
            $Total_Taxes=$xxx->Total_Taxes - $Prodct->Total_Tax;
            $Total_Price=$xxx->Total_Price - $Prodct->Total;
            $Pay=null;

            SalesOrder::where('id',$xxx->id)->update([
                'Product_Numbers'=>$Product_Numbers,
                'Total_Qty'=>$Total_Qty,
                'Total_Discount'=>$Total_Discount,
                'Total_BF_Taxes'=>$Total_BF_Taxes,
                'Total_Taxes'=>$Total_Taxes,
                'Total_Price'=>$Total_Price,
                'Pay'=>$Pay,

            ]);





            $xxxM=SalesOrder::find($ID);


            $Product_NumbersM=$xxxM->Product_Numbers + 1;
            $Total_QtyM=$xxxM->Total_Qty + $Prodct->Qty;
            $Total_DiscountM=$xxxM->Total_Discount + $Prodct->Discount;
            $Total_BF_TaxesM=$xxxM->Total_BF_Taxes + $Prodct->Total_Bf_Tax;
            $Total_TaxesM=$xxxM->Total_Taxes + $Prodct->Total_Tax;
            $Total_PriceM=$xxxM->Total_Price + $Prodct->Total;
            $PayM=null;

            SalesOrder::where('id',$xxxM->id)->update([
                'Product_Numbers'=>$Product_Numbers,
                'Total_Qty'=>$Total_Qty,
                'Total_Discount'=>$Total_Discount,
                'Total_BF_Taxes'=>$Total_BF_Taxes,
                'Total_Taxes'=>$Total_Taxes,
                'Total_Price'=>$Total_Price,
                'Pay'=>$Pay,

            ]);





            ProductSalesOrder::where('id',$ProID[$i])->delete();

        }





        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),


        ]);

    }




    //More Product in Hall Bill
    public function AddProHallOrder(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();


        if(!empty($admin)){

            if(request('Payment_Method') == 'Cash'){

                if(!empty(request('Pay'))){

                    $paid = request('Pay') ;

                }else{

                    $paid = request('Total_Price') ;
                }



            }elseif(request('Payment_Method') == 'Later'){

                $paid = request('Pay') ;

            }elseif(request('Payment_Method') == 'Installment'){

                $paid = request('Pay') ;

            }elseif(request('Payment_Method') == 'Check'){

                $paid = request('Total_Price') ;

            }elseif(request('Payment_Method') == 'Cash_Visa'){

                $paid = request('Total_Price') ;

            }elseif(request('Payment_Method') == 'Cash_Collection'){

                $paid = request('Cash_Collection') ;

            }elseif(request('Payment_Method') == 'Delivery'){

                $paid = request('Pay') ;

            }elseif(request('Payment_Method') == 'InstallmentCompanies'){

                $paid = request('Total_Price') ;

            }

            if(request('Payment_Method') == 'Later'){
                $col=0;
            }else{
                $col=1;
            }



            $ID = DB::table('sales_orders')->insertGetId(
                array(


                    'Date' => request('Date'),
                    'Draw' => request('Draw'),
                    'Payment_Method' => request('Payment_Method'),
                    'Status' => request('Status'),
                    'Refernce_Number' => request('Refernce_Number'),
                    'Note' => request('Note'),
                    'Product_Numbers' => request('Product_Numbers'),
                    'Total_Qty' => request('Total_Qty'),
                    'Total_Discount' => request('Total_Discount') + request('DiscountBill'),
                    'Total_BF_Taxes' => request('Total_BF_Taxes'),
                    'Total_Taxes' => request('Total_Taxes'),
                    'Total_Price' => request('Total_Price'),
                    'Pay' => $paid,
                    'Safe' => request('Safe'),
                    'ToSales' => 0,
                    'Client' => request('Client'),
                    'Delegate' => request('Delegate'),
                    'Executor' => request('Executor'),
                    'Store' => request('Store'),
                    'Coin' => request('Coin'),
                    'Cost_Center' => null,
                    'presenter' => request('presenter'),
                    'annual_interest' => request('annual_interest'),
                    'monthly_installment' => request('monthly_installment'),
                    'Years_Number' => request('Years_Number'),
                    'total' => request('total'),
                    'Quote' => null,
                    'Hold' => 1,
                    'installment_Num' => request('installment_Num'),
                    'Date_First_installment' => request('Date_First_installment'),
                    'User' => $admin->id,

                )
            );


            $res=SalesOrder::where('id',$ID)->first();

            $Code=$res->Code;


            if(!empty(request('Unit'))){

                $P_Ar_Name=request('P_Ar_Name');
                $P_En_Name=request('P_En_Name');
                $Unit=request('Unit');
                $P_Code=request('P_Code');
                $Qty=request('Qty');
                $AvQty=request('AvQty');
                $Price=request('Price');
                $Discount=request('Discount');
                $TotalBFTax=request('TotalBFTax');
                $TotalTax=request('TotalTax');
                $PurchTax=request('PurchTax');
                $Total=request('Total');
                $StorePurch=request('StorePurch');
                $Exp_Date=request('Exp_Date');
                $Product=request('Product');
                $VOne=request('VOne');
                $VTwo=request('VTwo');
                $V_Name=request('V_Name');
                $VV_Name=request('VV_Name');
                $Exp_Date=request('Exp_Date');
                $TDiscount=request('TDiscPro');

                $MorePro=request('MorePro');
                for($i=0 ; $i < count($Unit) ; $i++){

                    $uu['Product_Code']=$P_Code[$i];
                    $uu['P_Ar_Name']=$P_Ar_Name[$i];
                    $uu['P_En_Name']=$P_En_Name[$i];
                    $uu['V_Name']=$V_Name[$i];
                    $uu['VV_Name']=$VV_Name[$i];
                    $uu['Original_Qty']=$Qty[$i];
                    $uu['Qty']=$Qty[$i];
                    $uu['AvQty']=$AvQty[$i];
                    $uu['Price']=$Price[$i];
                    $uu['Discount']=$Discount[$i];
                    $uu['Tax']=$PurchTax[$i];
                    $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                    $uu['Total_Tax']=$TotalTax[$i];
                    $uu['Total']=$Total[$i];
                    $uu['Store']=$StorePurch[$i];
                    $uu['Product']=$Product[$i];
                    $uu['Unit']=$Unit[$i];
                    $uu['Exp_Date']=$Exp_Date[$i];
                    $uu['SalesOrder']=$ID;
                    $uu['V1']=$VOne[$i];
                    $uu['V2']=$VTwo[$i];
                    $uu['TDiscount']=$TDiscount[$i];
                    ProductSalesOrder::create($uu);


                    if($MorePro[$i] == 1){

                        $uuu['Product_Code']=$P_Code[$i];
                        $uuu['P_Ar_Name']=$P_Ar_Name[$i];
                        $uuu['P_En_Name']=$P_En_Name[$i];
                        $uuu['V_Name']=$V_Name[$i];
                        $uuu['VV_Name']=$VV_Name[$i];
                        $uuu['Qty']=$Qty[$i];
                        $uuu['AvQty']=$AvQty[$i];
                        $uuu['Price']=$Price[$i];
                        $uuu['Discount']=$Discount[$i];
                        $uuu['Tax']=$PurchTax[$i];
                        $uuu['Total_Bf_Tax']=$TotalBFTax[$i];
                        $uuu['Total_Tax']=$TotalTax[$i];
                        $uuu['Total']=$Total[$i];
                        $uuu['Store']=$StorePurch[$i];
                        $uuu['Product']=$Product[$i];
                        $uuu['Unit']=$Unit[$i];
                        $uuu['Exp_Date']=$Exp_Date[$i];
                        $uuu['SalesOrder']=$ID;
                        $uuu['V1']=$VOne[$i];
                        $uuu['V2']=$VTwo[$i];
                        $uuu['SubVID']=$SubVID[$i];
                        $uuu['Pro_Note']=$Pro_Note[$i];
                        $uuu['KitchenEnd']=0;
                        MoreProductsHall::create($uuu);

                    }


                }


            }


            $dataUser['User']=$admin->id;
            $dataUser['Date']=date('Y-m-d');
            $dataUser['Time']=date("h:i:s a", time());
            $dataUser['Screen']='نقاط البيع تطبيق';
            $dataUser['ScreenEn']='POS App';
            $dataUser['Type']='فاتوره معلقه';
            $dataUser['TypeEn']='Hold Bill';
            $dataUser['Explain']=$Code;
            $dataUser['ExplainEn']=$Code;
            UsersMoves::create($dataUser);

            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Added_Successfully'),


            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


    //DeleteProHallOrder

    public function DeleteProHallOrder(Request $request){

        $lang = $request->header('lang', '');


        $Email = $request->get('email');
        $Pass = $request->get('pass');
        $ProID = $request->get('product_details_id');

        $admin=Admin::where('email',$Email)->first();

        if(!empty($admin)){

            if (Hash::check($Pass, $admin->password)) {


                $Pro=ProductSalesOrder::find($ProID);


                $uuu['Product_Code']=$Pro->Product_Code;
                $uuu['P_Ar_Name']=$Pro->P_Ar_Name;
                $uuu['P_En_Name']=$Pro->P_En_Name;
                $uuu['V_Name']=$Pro->V_Name;
                $uuu['VV_Name']=$Pro->VV_Name;
                $uuu['Qty']=$Pro->Qty;
                $uuu['AvQty']=$Pro->AvQty;
                $uuu['Price']=$Pro->Price;
                $uuu['Discount']=$Pro->Discount;
                $uuu['Tax']=$Pro->Tax;
                $uuu['Total_Bf_Tax']=$Pro->Total_Bf_Tax;
                $uuu['Total_Tax']=$Pro->Total_Tax;
                $uuu['Total']=$Pro->Total;
                $uuu['Store']=$Pro->Store;
                $uuu['Product']=$Pro->Product;
                $uuu['Unit']=$Pro->Unit;
                $uuu['Exp_Date']=$Pro->Exp_Date;
                $uuu['SalesOrder']=$Pro->SalesOrder;
                $uuu['V1']=$Pro->V1;
                $uuu['V2']=$Pro->V2;
                $uuu['SubVID']=$Pro->SubVID;
                $uuu['Pro_Note']=$Pro->Pro_Note;
                $uuu['KitchenEnd']=0;
                RemoveProductsHall::create($uuu);


                ProductSalesOrder::where('id',$ProID)->delete();


                return response()->json([
                    'status'=>200,
                    'message'=>trans('admin.Success'),


                ]);


            }else{

                return response()->json([
                    'status'=>402,
                    'message'=>trans('admin.Fail'),


                ]);
            }


        }else{

            return response()->json([
                'status'=>402,
                'message'=>trans('admin.Fail'),


            ]);

        }






    }





    //AddSalesBill
    public function AddSalesBillResturant(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();


        if(!empty($admin)){

            if(request('Payment_Method') == 'Cash'){

                if(!empty(request('Pay'))){

                    $paid = request('Pay') ;

                }else{

                    $paid = request('Total_Price') ;
                }



            }elseif(request('Payment_Method') == 'Later'){

                $paid = request('Pay') ;

            }elseif(request('Payment_Method') == 'Installment'){

                $paid = request('Pay') ;

            }elseif(request('Payment_Method') == 'Check'){

                $paid = request('Total_Price') ;

            }elseif(request('Payment_Method') == 'Cash_Visa'){

                $paid = request('Total_Price') ;

            }elseif(request('Payment_Method') == 'Cash_Collection'){

                $paid = request('Cash_Collection') ;

            }elseif(request('Payment_Method') == 'Delivery'){

                $paid = request('Pay') ;

            }elseif(request('Payment_Method') == 'InstallmentCompanies'){

                $paid = request('Total_Price') ;

            }

            if(request('Payment_Method') == 'Later'){
                $col=0;
            }else{
                $col=1;
            }


            if(request('Payment_Method') == 'Later'){
                $col=0;
            }else{
                $col=1;
            }


            $branch=Stores::find(request('Store'));
            $custG=Customers::where('Account',request('Client'))->orderBy('id','desc')->first();

            if(!empty($branch)){
                $BRAAA=$branch->Branch;
            }else{
                $BRAAA=null;
            }


            if(!empty($custG)){
                $CUSTGROP=$custG->Group;
            }else{
                $CUSTGROP=null;
            }

            $Hold=0;

            $discTaxx=request('Total_Price') * (1/100) ;

            $ID = DB::table('sales')->insertGetId(
                array(


                    'Date' => request('Date'),
                    'Draw' => request('Draw'),
                    'Payment_Method' => request('Payment_Method'),
                    'Status' => request('Status'),
                    'DiscountTax' => $discTaxx,
                    'Later_Collection' => $col,
                    'Time' => date("h:i:s a", time()),
                    'Branch' => $BRAAA,
                    'CustomerGroup' => $CUSTGROP,
                    'Refernce_Number' => request('Refernce_Number'),
                    'Note' => request('Note'),
                    'Product_Numbers' => request('Product_Numbers'),
                    'Total_Qty' => request('Total_Qty'),
                    'Total_Discount' => request('Total_Discount') + request('DiscountBill'),
                    'Total_BF_Taxes' => request('Total_BF_Taxes'),
                    'Total_Taxes' => request('Total_Taxes'),
                    'Total_Price' => request('Total_Price'),
                    'Pay' => $paid,
                    'Safe' => request('Safe'),
                    'Client' => request('Client'),
                    'Delegate' => request('Delegate'),
                    'Executor' => request('Executor'),
                    'Store' => request('Store'),
                    'Coin' => request('Coin'),
                    'Cost_Center' => null,
                    'presenter' => request('presenter'),
                    'annual_interest' => request('annual_interest'),
                    'monthly_installment' => request('monthly_installment'),
                    'Years_Number' => request('Years_Number'),
                    'total' => request('total'),
                    'Quote' => null,
                    'Ship' => null,
                    'Check_Type' => request('Check_Type'),
                    'Client_Address' => request('Client_Address'),
                    'Delivery' => request('Delivery'),
                    'Delivery_Status' =>0,
                    'Due_Date' => request('Due_Date'),
                    'Check_Number' => request('Check_Number'),
                    'Cash' => request('Cash'),
                    'Visa' => request('Visa'),
                    'Sale_Type' => 'POS',
                    'Hold' => 0,
                    'Total_Cost' => request('Total_Cost'),
                    'TaxOnTotal' => request('TaxOnTotal'),
                    'TaxOnTotalType' => request('TaxOnTotalType'),
                    'ProfitTax' => request('ProfitTax'),
                    'Shift_Code' => request('Shift_Code'),
                    'InstallCompany' => request('InstallCompany'),
                    'ContractNumber' => request('ContractNumber'),
                    'PayFees' => request('PayFees'),
                    'ServiceFee' => request('ServiceFee'),
                    'CompanyPrecent' => request('CompanyPrecent'),
                    'SalesOrder' => null,
                    'installment_Num' => request('installment_Num'),
                    'ProfitPrecent' => request('ProfitPrecent'),
                    'Date_First_installment' => request('Date_First_installment'),
                    'User' => $admin->id,
                    'emp' => $admin->emp,

                    'TakeawayStatus' => 0,
                    'TakeawayTime' => null,
                    'Witer' => request('Waiter'),
                    'KitchenEnd' => 0,
                    'KitchenEndTime' => null,
                    'RecivedOrder' => 0,
                    'RecivedOrderTime' => null,
                    'Delivery_Status' =>0,
                    'DeliveryTime' => null,
                    'ResturantOrderType' => request('ResturantOrderType'),
                    'Table' => request('Table'),


                )
            );


            $rest=Sales::where('id',$ID)->first();
            $sel=Sales::where('Store',$rest->Store)->count();


            $Sor=Stores::find(request('Store'));
            $SorBil= $Sor->Letter . '' .  $sel ;
            Sales::where('id',$ID)->update(['Store_Code'=>$SorBil]);


            $CodeT=$rest->Code  ;
            $CodeS=$rest->Code  ;


            $c= DB::select("SELECT last_value FROM sales_arr_seq");
            $f=array_shift($c);
            $z=end($f);
            $CodeT=$z;
            $CodeS=$z;

            if(!empty(request('Unit'))){

                StoreCountSales::truncate();
                $P_Ar_Name=request('P_Ar_Name');
                $P_En_Name=request('P_En_Name');
                $Unit=request('Unit');
                $P_Code=request('P_Code');
                $Qty=request('Qty');
                $AvQty=request('AvQty');
                $Price=request('Price');
                $Discount=request('Discount');
                $TotalBFTax=request('TotalBFTax');
                $TotalTax=request('TotalTax');
                $PurchTax=request('PurchTax');
                $Total=request('Total');
                $StorePurch=request('StorePurch');
                $Exp_Date=request('Exp_Date');
                $Product=request('Product');
                $VOne=request('VOne');
                $VTwo=request('VTwo');
                $V_Name=request('V_Name');
                $VV_Name=request('VV_Name');
                $Exp_Date=request('Exp_Date');

                $TDiscount=request('TDiscPro');


                $CostPrice=request('CostPrice');

                for($i=0 ; $i < count($Unit) ; $i++){

                    $pp=ProductUnits::where('Product',$Product[$i])->where('Unit',$Unit[$i])->first();
                    $plow=ProductUnits::where('Product',$Product[$i])->where('Rate',1)->first();

                    $uu['Product_Code']=$P_Code[$i];
                    $uu['P_Ar_Name']=$P_Ar_Name[$i];
                    $uu['P_En_Name']=$P_En_Name[$i];
                    $uu['V_Name']=$V_Name[$i];
                    $uu['VV_Name']=$VV_Name[$i];
                    $uu['Original_Qty']=$Qty[$i];
                    $uu['Qty']=$Qty[$i];
                    $uu['AvQty']=$AvQty[$i];
                    $uu['Price']=$Price[$i];
                    $uu['Discount']=$Discount[$i];
                    $uu['Tax']=$PurchTax[$i];
                    $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                    $uu['Total_Tax']=$TotalTax[$i];
                    $uu['Total']=$Total[$i];
                    $uu['Store']=$StorePurch[$i];
                    $uu['Product']=$Product[$i];
                    $uu['Unit']=$Unit[$i];
                    $uu['Exp_Date']=$Exp_Date[$i];
                    $uu['Sales']=$ID;
                    $uu['V1']=$VOne[$i];
                    $uu['V2']=$VTwo[$i];
                    $uu['TDiscount']=$TDiscount[$i];
                    $uu['Date']=request('Date');
                    $uu['Code']=$CodeT;
                    $uu['Refernce_Number']=null;
                    $uu['Safe']=request('Safe');
                    $uu['Client']=request('Client');
                    $uu['Executor']=request('Executor');
                    $uu['Delegate']=request('Delegate');
                    $uu['Coin']=request('Coin');
                    $uu['Ship']=null;
                    $uu['User']=$admin->id;
                    $uu['Cost_Center']=null;
                    $uu['Type']='مبيعات';
                    $uu['CostPrice']=$CostPrice[$i];
                    $SS=Stores::find($StorePurch[$i]);
                    $PSS=Products::find($Product[$i]);
                    $uu['Branch']=$SS->Branch;
                    $uu['Group']=$PSS->Group;
                    $uu['Brand']=$PSS->Brand;
                    $uu['CustomerGroup']=$CUSTGROP;
                    $uu['Status']=request('Status');
                    $uu['Payment_Method']=request('Payment_Method');

                    $Aomla=Coins::find(request('Coin'));
                    $dreba=Taxes::find($PurchTax[$i]);

                    $uu['CoinCode']=$Aomla->Code;

                    if($Aomla->Code == 'EGP'){
                        $uu['CoinRate']=0.00;
                        $uu['CoinPrice']=0.00;
                        $uu['AmountEGP']=$Price[$i];

                    }else{

                        $uu['CoinRate']=$Aomla->Draw;
                        $uu['CoinPrice']=$Price[$i];
                        $uu['AmountEGP']=$Aomla->Draw * $Price[$i];
                    }

                    $uu['SalesTotal']=$Price[$i] * $Qty[$i] ;
                    $uu['DiscountAmount']=$Discount[$i] * $Qty[$i] ;
                    $uu['NetTotal']=($Price[$i] * $Qty[$i])  - ($Discount[$i] * $Qty[$i]) ;
                    $NET=($Price[$i] * $Qty[$i])  - ($Discount[$i] * $Qty[$i]);


                    if(!empty($dreba)){
                        $TAM=($dreba->Rate / 100 ) * $NET ;
                        $uu['TaxType']=$dreba->CodeTax ;
                        $uu['TaxSubType']=$dreba->SubType ;
                        $uu['TaxRate']=$dreba->Rate ;
                        $uu['TaxAmount']=($dreba->Rate / 100 ) * $NET ;
                        $uu['TotalBill']=$NET + $TAM ;
                    }



                    ProductSales::create($uu);

                    $prooooo=Products::find($Product[$i]);
                    if(request('Status') == 1){

                        if($prooooo->P_Type == 'Assembly'){

                            $Asembs=AssemblyProducts::where('p_id',$Product[$i])->get();

                            foreach($Asembs as $ass){

                                $Quantity =ProductsQty::
                                where('Store',$StorePurch[$i])
                                    ->where('Product',$ass->Product)
                                    ->where('P_Code',$ass->P_Code)
                                    ->first();



                                if(empty($Quantity)){

                                    $Quantity =ProductsQty::
                                    where('Store',$StorePurch[$i])
                                        ->where('Product',$ass->Product)
                                        ->where('PP_Code',$ass->P_Code)
                                        ->first();

                                    if(empty($Quantity)){

                                        $Quantity =ProductsQty::
                                        where('Store',$StorePurch[$i])
                                            ->where('Product',$ass->Product)
                                            ->where('PPP_Code',$ass->P_Code)
                                            ->first();


                                        if(empty($Quantity)){

                                            $Quantity =ProductsQty::
                                            where('Store',$StorePurch[$i])
                                                ->where('Product',$ass->Product)
                                                ->where('PPPP_Code',$ass->P_Code)
                                                ->first();

                                        }



                                    }






                                }





                                if(!empty($Quantity)){

                                    $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();

                                    $qq= $unit->Rate * ($Qty[$i] * $ass->Qty) ;

                                    $newqty=$Quantity->Qty -  $qq ;


                                    $prooooo=Products::find($Product[$i]);

                                    $plow=ProductUnits::where('Product',$ass->Product)->where('Rate',1)->first();
                                    $pp=ProductUnits::where('Product',$ass->Product)->where('Unit',$ass->Unit)->first();

                                    $purchs=ProductsPurchases::where('Product',$ass->Product)->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('Total_Bf_Tax');

                                    $countPurchs=ProductsPurchases::where('Product',$ass->Product)->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('SmallQty');


                                    $storesTransfer=ProductsStoresTransfers::where('Product',$ass->Product)->where('SmallCode',$plow->Barcode)->where('To_Store',$StorePurch[$i])->get()->sum('Total');

                                    $storesTransferCount=ProductsStoresTransfers::where('Product',$ass->Product)->where('SmallCode',$plow->Barcode)->where('To_Store',$StorePurch[$i])->get()->sum('SmallTrans_Qty');

                                    $purchsStart=ProductsStartPeriods::where('Product',$ass->Product)->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('Total');

                                    $countStart=ProductsStartPeriods::where('Product',$ass->Product)->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('SmallQty');

                                    $OUTCOME=OutcomManufacturingModel::where('Product',$ass->Product)->where('Store',$StorePurch[$i])->where('SmallCode',$plow->Barcode)->get()->sum('Cost');

                                    $countOUTCOME=OutcomManufacturingModel::where('Product',$ass->Product)->where('Store',$StorePurch[$i])->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');


                                    $Collect=$purchs + $purchsStart + $storesTransfer + $OUTCOME;
                                    $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;

                                    if($CollectCount != 0){
                                        $ty= $Collect /  $CollectCount ;
                                    }else{

                                        $ty= $Collect;
                                    }


                                    if($ty != 0){
                                        $in=0;
                                        $out=$qq * $ty ;
                                        $current=$newqty * $ty ;
                                    }else{

                                        $in=0;
                                        $out=$qq * 1;
                                        $current=$newqty * 1;

                                    }
                                    $cur=$newqty * $ty ;
                                    ProductsQty::where('id',$Quantity->id)->update(['Qty'=>$newqty,'Price'=>$ty , 'TotalCost'=>$cur]);

                                    $move['Date']=date('Y-m-d');
                                    $move['Type']='مبيعات';
                                    $move['TypeEn']='Sales';
                                    $move['Bill_Num']=request('Code');
                                    $move['Incom']=0;
                                    $move['Outcom']=$qq;
                                    $move['Current']=abs($newqty);
                                    $move['CostIn']=number_format((float)abs($in), 2, '.', '');
                                    $move['CostOut']=number_format((float)abs($out), 2, '.', '');
                                    $move['CostCurrent']=number_format((float)abs($current), 2, '.', '');
                                    $move['P_Ar_Name']=$P_Ar_Name[$i];
                                    $move['P_En_Name']=$P_En_Name[$i];
                                    $move['P_Code']=$P_Code[$i];
                                    $move['Unit']=$Unit[$i];
                                    $move['QTY']=$Qty[$i];
                                    $move['Group']=$prooooo->Group;
                                    $move['Store']=$StorePurch[$i];
                                    $move['Product']=$Product[$i];
                                    $move['V1']=$VOne[$i];
                                    $move['V2']=$VTwo[$i];
                                    $move['User']=$admin->id;
                                    $Sro=Stores::find($StorePurch[$i]);
                                    $move['Brand']=$prooooo->Brand;
                                    $move['Safe']=request('Safe');
                                    $move['Branch']=$Sro->Branch;
                                    $move['SalePrice']=$Price[$i];
                                    $move['ProductPrice']=$pp->Price;
                                    $move['Delegate']=request('Delegate');
                                    $move['Payment_Method']=request('Payment_Method');
                                    ProductMoves::create($move);


                                }

                            }

                        }elseif($prooooo->P_Type == 'Service'){

                        }else{

                            $Quantity =ProductsQty::
                            where('Store',$StorePurch[$i])
                                ->where('Product',$Product[$i])
                                ->where('P_Code',$P_Code[$i])
                                ->first();

                            if(empty($Quantity)){

                                $Quantity =ProductsQty::
                                where('Store',$StorePurch[$i])
                                    ->where('Product',$Product[$i])
                                    ->where('PP_Code',$P_Code[$i])
                                    ->first();

                                if(empty($Quantity)){

                                    $Quantity =ProductsQty::
                                    where('Store',$StorePurch[$i])
                                        ->where('Product',$Product[$i])
                                        ->where('PPP_Code',$P_Code[$i])
                                        ->first();


                                    if(empty($Quantity)){

                                        $Quantity =ProductsQty::
                                        where('Store',$StorePurch[$i])
                                            ->where('Product',$Product[$i])
                                            ->where('PPPP_Code',$P_Code[$i])
                                            ->first();

                                    }
                                }
                            }


                            if(!empty($Quantity)){
                                $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();

                                $qq= $unit->Rate * $Qty[$i] ;

                                $newqty=$Quantity->Qty -  $qq ;


                                $prooooo=Products::find($Product[$i]);

                                $plow=ProductUnits::where('Product',$Product[$i])->where('Rate',1)->first();
                                $pp=ProductUnits::where('Product',$Product[$i])->where('Unit',$Unit[$i])->first();

                                $purchs=ProductsPurchases::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('Total_Bf_Tax');
                                $countPurchs=ProductsPurchases::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('SmallQty');

                                $purchsStart=ProductsStartPeriods::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('Total');

                                $countStart=ProductsStartPeriods::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('SmallQty');
                                $storesTransfer=ProductsStoresTransfers::where('Product',$Product[$i])->where('SmallCode',$P_Code[$i])->where('To_Store',$StorePurch[$i])->get()->sum('Total');

                                $storesTransferCount=ProductsStoresTransfers::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('To_Store',$StorePurch[$i])->get()->sum('SmallTrans_Qty');


                                $OUTCOME=OutcomManufacturingModel::where('Product',$Product[$i])->where('Store',$StorePurch[$i])->where('SmallCode',$plow->Barcode)->get()->sum('Cost');

                                $countOUTCOME=OutcomManufacturingModel::where('Product',$Product[$i])->where('Store',$StorePurch[$i])->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');


                                $Collect=$purchs + $purchsStart + $storesTransfer + $OUTCOME;
                                $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;

                                if($CollectCount != 0){
                                    $ty= $Collect /  $CollectCount ;
                                }else{

                                    $ty= $Collect;
                                }



                                if($ty != 0){
                                    $in=0;
                                    $out=$qq * $ty ;
                                    $current=$newqty * $ty ;
                                }else{

                                    $in=0;
                                    $out=$qq * 1;
                                    $current=$newqty * 1;

                                }
                                $cur=$newqty * $ty ;
                                ProductsQty::where('id',$Quantity->id)->update(['Qty'=>$newqty,'Price'=>$ty , 'TotalCost'=>$cur]);
                                $move['Date']=date('Y-m-d');
                                $move['Type']='مبيعات';
                                $move['TypeEn']='Sales';
                                $move['Bill_Num']=request('Code');
                                $move['Incom']=0;
                                $move['Outcom']=$qq;
                                $move['Current']=abs($newqty);
                                $move['CostIn']=number_format((float)abs($in), 2, '.', '');
                                $move['CostOut']=number_format((float)abs($out), 2, '.', '');
                                $move['CostCurrent']=number_format((float)abs($current), 2, '.', '');
                                $move['P_Ar_Name']=$P_Ar_Name[$i];
                                $move['P_En_Name']=$P_En_Name[$i];
                                $move['P_Code']=$P_Code[$i];
                                $move['Unit']=$Unit[$i];
                                $move['QTY']=$Qty[$i];

                                $move['Group']=$prooooo->Group;
                                $move['Store']=$StorePurch[$i];
                                $move['Product']=$Product[$i];
                                $move['V1']=$VOne[$i];
                                $move['V2']=$VTwo[$i];
                                $move['User']=$admin->id;
                                $Sro=Stores::find($StorePurch[$i]);
                                $move['Brand']=$prooooo->Brand;
                                $move['Safe']=request('Safe');
                                $move['Branch']=$Sro->Branch;
                                $move['SalePrice']=$Price[$i];
                                $move['ProductPrice']=$pp->Price;
                                $move['Delegate']=request('Delegate');
                                $move['Payment_Method']=request('Payment_Method');
                                ProductMoves::create($move);


                            }

                        }

                    }

                    $plow=ProductUnits::where('Product',$Product[$i])->where('Rate',1)->first();
                    $pp=ProductUnits::where('Product',$Product[$i])->where('Unit',$Unit[$i])->first();

                    $purchs=ProductsPurchases::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('Total_Bf_Tax');
                    $countPurchs=ProductsPurchases::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('SmallQty');

                    $purchsStart=ProductsStartPeriods::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('Total');

                    $countStart=ProductsStartPeriods::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('SmallQty');
                    $storesTransfer=ProductsStoresTransfers::where('Product',$Product[$i])->where('SmallCode',$P_Code[$i])->where('To_Store',$StorePurch[$i])->get()->sum('Total');

                    $storesTransferCount=ProductsStoresTransfers::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('To_Store',$StorePurch[$i])->get()->sum('SmallTrans_Qty');


                    $OUTCOME=OutcomManufacturingModel::where('Product',$Product[$i])->where('Store',$StorePurch[$i])->where('SmallCode',$plow->Barcode)->get()->sum('Cost');

                    $countOUTCOME=OutcomManufacturingModel::where('Product',$Product[$i])->where('Store',$StorePurch[$i])->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');

                    $Collect=$purchs + $purchsStart + $storesTransfer + $OUTCOME;
                    $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;





                    if(!empty($V_Name[$i]) and !empty($VV_Name[$i]))  {
                        $rows=ProductsQty::
                        where('P_Ar_Name',$P_Ar_Name[$i])
                            ->where('P_En_Name',$P_En_Name[$i])
                            ->where('V_Name',$V_Name[$i])
                            ->where('VV_Name',$VV_Name[$i])
                            ->where('P_Code', $P_Code[$i])
                            ->where('Store',$StorePurch[$i])
                            ->first();
                    }elseif(!empty($V_Name[$i]) and empty($VV_Name[$i])){
                        $rows=ProductsQty::
                        where('P_Ar_Name',$P_Ar_Name[$i])
                            ->where('P_En_Name',$P_En_Name[$i])
                            ->where('V_Name',$V_Name[$i])
                            ->where('P_Code', $P_Code[$i])
                            ->where('Store',$StorePurch[$i])
                            ->first();

                    }elseif(empty($V_Name[$i]) and empty($VV_Name[$i])){
                        $rows=ProductsQty::
                        where('P_Ar_Name',$P_Ar_Name[$i])
                            ->where('P_En_Name',$P_En_Name[$i])
                            ->where('P_Code', $P_Code[$i])
                            ->where('Store',$StorePurch[$i])
                            ->first();


                    }

                    $Coste=0;



                    $ppro =ProductsQty::
                    where('Store',$StorePurch[$i])
                        ->where('Product',$Product[$i])
                        ->where('P_Code',$P_Code[$i])
                        ->first();

                    if(empty($ppro)){

                        $ppro =ProductsQty::
                        where('Store',$StorePurch[$i])
                            ->where('Product',$Product[$i])
                            ->where('PP_Code',$P_Code[$i])
                            ->first();

                        if(empty($ppro)){

                            $ppro =ProductsQty::
                            where('Store',$StorePurch[$i])
                                ->where('Product',$Product[$i])
                                ->where('PPP_Code',$P_Code[$i])
                                ->first();


                            if(empty($ppro)){

                                $ppro =ProductsQty::
                                where('Store',$StorePurch[$i])
                                    ->where('Product',$Product[$i])
                                    ->where('PPPP_Code',$P_Code[$i])
                                    ->first();

                            }
                        }
                    }





                    if($prooooo->P_Type != 'Service'){
                        if(!empty($ppro->Original)){

                            if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME) ){




                                if($CollectCount != 0){
                                    $Averagee =$Collect /  $CollectCount;
                                    $Coste += abs($Averagee) * $Qty[$i] ;
                                }else{

                                    if($ppro->Original == null){

                                        $Averagee =$Price[$i] ;
                                        $Coste += $Averagee * $Qty[$i] ;
                                    }else{
                                        $Averagee =0 ;
                                        $Coste += $Averagee * $Qty[$i] ;

                                    }
                                }

                            }else{

                                if($ppro->Original == null){

                                    $Averagee =$Price[$i] ;
                                    $Coste += $Averagee * $Qty[$i] ;
                                }else{
                                    $Averagee =0 ;
                                    $Coste += $Averagee * $Qty[$i] ;

                                }



                            }

                            if($prooooo->P_Type != 'Service'){
                                if(request('Status') == 1){

                                    $Mkhazns=StoreCountSales::all();

                                    if(count($Mkhazns) == 0){

                                        if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME) ){

                                            if($CollectCount != 0){
                                                $Average =$Collect /  $CollectCount;
                                                $Cost = abs($Average) * $Qty[$i] ;

                                            }else{


                                                if($ppro->Original == null){

                                                    $Average = $Price[$i] ;
                                                    $Cost = $Average * $Qty[$i] ;
                                                }else{
                                                    $Average = 0 ;
                                                    $Cost = $Average * $Qty[$i] ;

                                                }




                                            }

                                            $s['Total']=$Cost;
                                        }else{

                                            if($ppro->Original == null){

                                                $Average = $Price[$i] ;
                                                $Cost = $Average * $Qty[$i] ;
                                            }else{
                                                $Average = 0 ;
                                                $Cost = $Average * $Qty[$i] ;

                                            }

                                            $s['Total']=$Cost;
                                        }


                                        $s['Store']=$StorePurch[$i];
                                        $s['Tax']=$PurchTax[$i];
                                        StoreCountSales::create($s);

                                    }else{


                                        $m=StoreCountSales::where('Store',$StorePurch[$i])->first();

                                        if(!empty($m)){

                                            if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME) ){

                                                if($CollectCount != 0){
                                                    $Average =$Collect /  $CollectCount;
                                                    $Cost = abs($Average) * $Qty[$i] ;

                                                }else{

                                                    if($ppro->Original == null){

                                                        $Average = $Price[$i] ;
                                                        $Cost = $Average * $Qty[$i] ;
                                                    }else{
                                                        $Average = 0 ;
                                                        $Cost = $Average * $Qty[$i] ;

                                                    }

                                                }
                                                $newTot=$m->Total + $Cost ;
                                            }else{

                                                if($ppro->Original == null){

                                                    $Average = $Price[$i] ;
                                                    $Cost = $Average * $Qty[$i] ;
                                                }else{
                                                    $Average = 0 ;
                                                    $Cost = $Average * $Qty[$i] ;

                                                }

                                                $newTot=$m->Total + $Cost ;
                                            }


                                            StoreCountSales::where('id',$m->id)->update(['Total'=>$newTot]);

                                        }else{

                                            if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME) ){

                                                if($CollectCount != 0){
                                                    $Average =$Collect /  $CollectCount;
                                                    $Cost = abs($Average) * $Qty[$i] ;

                                                }else{

                                                    if($ppro->Original == null){

                                                        $Average = $Price[$i] ;
                                                        $Cost = $Average * $Qty[$i] ;
                                                    }else{
                                                        $Average = 0 ;
                                                        $Cost = $Average * $Qty[$i] ;

                                                    }

                                                }
                                                $s['Total']=$Cost;
                                            }else{

                                                if($ppro->Original == null){

                                                    $Average = $Price[$i] ;
                                                    $Cost = $Average * $Qty[$i] ;
                                                }else{
                                                    $Average = 0 ;
                                                    $Cost = $Average * $Qty[$i] ;

                                                }

                                                $s['Total']=$Cost;
                                            }
                                            $s['Store']=$StorePurch[$i];
                                            $s['Tax']=$PurchTax[$i];
                                            StoreCountSales::create($s);

                                        }

                                    }

                                }
                            }else{

                                $Mkhazns=StoreCountSales::all();
                                if(count($Mkhazns) == 0){

                                    $s['Total']=0;
                                    $s['Store']=$StorePurch[$i];
                                    $s['Tax']=$PurchTax[$i];
                                    StoreCountSales::create($s);

                                }else{
                                    $m=StoreCountSales::where('Store',$StorePurch[$i])->first();

                                    if(!empty($m)){

                                        $newTot=$m->Total + 0 ;
                                        StoreCountSales::where('id',$m->id)->update(['Total'=>$newTot]);

                                    }else{

                                        $s['Total']=0;
                                        $s['Store']=$StorePurch[$i];
                                        $s['Tax']=$PurchTax[$i];
                                        StoreCountSales::create($s);


                                    }

                                }



                            }
                        }else{

                            $Mkhazns=StoreCountSales::all();
                            if(count($Mkhazns) == 0){

                                $s['Total']=0;
                                $s['Store']=$StorePurch[$i];
                                $s['Tax']=$PurchTax[$i];
                                StoreCountSales::create($s);

                            }else{
                                $m=StoreCountSales::where('Store',$StorePurch[$i])->first();

                                if(!empty($m)){

                                    $newTot=$m->Total + 0 ;
                                    StoreCountSales::where('id',$m->id)->update(['Total'=>$newTot]);

                                }else{

                                    $s['Total']=0;
                                    $s['Store']=$StorePurch[$i];
                                    $s['Tax']=$PurchTax[$i];
                                    StoreCountSales::create($s);


                                }

                            }



                        }


                    }else{


                        $Mkhazns=StoreCountSales::all();
                        if(count($Mkhazns) == 0){

                            $s['Total']=0;
                            $s['Store']=$StorePurch[$i];
                            $s['Tax']=$PurchTax[$i];
                            StoreCountSales::create($s);

                        }else{
                            $m=StoreCountSales::where('Store',$StorePurch[$i])->first();

                            if(!empty($m)){

                                $newTot=$m->Total + 0 ;
                                StoreCountSales::where('id',$m->id)->update(['Total'=>$newTot]);

                            }else{

                                $s['Total']=0;
                                $s['Store']=$StorePurch[$i];
                                $s['Tax']=$PurchTax[$i];
                                StoreCountSales::create($s);


                            }

                        }


                    }

                }
            }

            if($Hold == 0){

                $SHIFT=Shifts::where('Code',request('Shift_Code'))->first();
                $RESIDUAL=( request('DiscountBill') + request('Total_Discount') ) ;


                if(request('Payment_Method') == 'Cash'){

                    $cash=request('Total_Price') + request('Total_Taxes') - $RESIDUAL;
                    $visa=0;
                    $later=0;
                }elseif(request('Payment_Method') == 'Later'){
                    $cash=0;
                    $visa=0;
                    $later=$paid + request('Total_Taxes') - $RESIDUAL;
                }elseif(request('Payment_Method') == 'Installment'){
                    $cash=0;
                    $visa=0;
                    $later=$paid + request('Total_Taxes') - $RESIDUAL;

                }elseif(request('Payment_Method') == 'Check'){

                    $cash=0;
                    $visa=0;
                    $later=$paid + request('Total_Taxes') - $RESIDUAL;
                }elseif(request('Payment_Method') == 'Cash_Visa'){
                    $cash=request('Cash') + request('Total_Taxes') - $RESIDUAL;
                    $visa=request('Visa');
                    $later=0;

                }elseif(request('Payment_Method') == 'Cash_Collection'){
                    $cash=request('Total_Price') + request('Total_Taxes') - $RESIDUAL;
                    $visa=0;
                    $later=0;

                }elseif(request('Payment_Method') == 'Delivery'){
                    $cash=0;
                    $visa=0;
                    $later=$paid + request('Total_Taxes') - $RESIDUAL;

                }elseif(request('Payment_Method') == 'InstallmentCompanies'){

                    $cash=request('Total_Price') + request('Total_Taxes') - $RESIDUAL;
                    $visa=0;
                    $later=0;
                }


                $tt=$visa + $cash + $later ;

                $shoft['Total_Cash']=$SHIFT->Total_Cash + $cash;
                $shoft['Total_Later']=$SHIFT->Total_Later + $later;
                $shoft['Total_Visa']=$SHIFT->Total_Visa + $visa;
                $shoft['Total']=$SHIFT->Total +  $tt ;


                Shifts::where('id',$SHIFT->id)->update($shoft);

            }

            if($Hold == 0){

                if(request('Payment_Method') == 'Cash'){

                    if(request('DiscountBill') != 0 or request('Total_Discount') != 0){
                        $RESIDUAL=( request('DiscountBill') + request('Total_Discount') ) ;
                        $RESIDUALSSSS= request('Total_Price') - ( request('DiscountBill') + request('Total_Discount') ) ;

                        if(request('Total_Taxes') != 0){



                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Pay') + $RESIDUAL;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Pay') + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Pay') + $RESIDUAL);
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Pay');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Pay');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Pay');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Total_Price'));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=(request('Pay') + $RESIDUAL);
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=(request('Pay') + $RESIDUAL);
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Pay') + $RESIDUAL);
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }


                        }else{



                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );


                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=(request('Pay') + $RESIDUAL);
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=(request('Pay') + $RESIDUAL);
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Pay') + $RESIDUAL);
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Pay');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Pay');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Pay'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price');
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=(request('Pay') + $RESIDUAL);
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=(request('Pay') + $RESIDUAL);
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Pay') + $RESIDUAL);
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }

                    }else{

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price') + request('Total_Taxes'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price') + request('Total_Taxes'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (round(request('Total_Price')));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price') + request('Total_Taxes'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }

                        }else{

                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }

                    }

                }elseif(request('Payment_Method') == 'Later' or request('Payment_Method') == 'Installment'){

                    if(request('DiscountBill') == 0 or request('Total_Discount') != 0){

                        if(request('Total_Taxes') != 0){

                            if(request('Status') == 1){
                                $NewMkhazns=StoreCountSales::all();


                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => $paid,
                                        'Total_Creditor' => $paid,
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);




                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( round(request('Total_Price')));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                                if($paid != 0 or $paid > 0){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price') + request('Total_Taxes'));
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }else{

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=(request('Total_Price') + request('Total_Taxes')) - $RESIDUAL;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=(request('Total_Price') + request('Total_Taxes')) - $RESIDUAL;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * round((request('Total_Price') + request('Total_Taxes')) - $RESIDUAL);
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);
                                }

                                $RESIDUAL=request('DiscountBill') + request('Total_Discount') ;


                                if($paid != 0 or $paid > 0){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$paid + $RESIDUAL;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$paid + $RESIDUAL;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * ($paid + $RESIDUAL);
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$paid;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Safe');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$paid;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $paid;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Safe');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$RESIDUAL;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=50;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$RESIDUAL;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=50;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }else{


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$RESIDUAL;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=50;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$RESIDUAL;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=50;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }




                            }

                        }else{

                            if(request('Status') == 1){
                                $NewMkhazns=StoreCountSales::all();
                                $RESIDUAL=request('DiscountBill') + request('Total_Discount') ;

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => $paid,
                                        'Total_Creditor' => $paid,
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);




                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                if($paid != 0 or $paid > 0){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('Total_Price');
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('Total_Price');
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price'));
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }else{

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('Total_Price') - $RESIDUAL;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('Total_Price') -$RESIDUAL ;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price') - $RESIDUAL);
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);
                                }

                                if($paid != 0 or $paid > 0){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=($paid + $RESIDUAL);
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=($paid + $RESIDUAL);
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * ($paid + $RESIDUAL);
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=abs($paid);
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Safe');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=abs($paid);
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * abs($paid);
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Safe');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$RESIDUAL;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=50;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$RESIDUAL;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=50;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }else{



                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$RESIDUAL;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=50;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$RESIDUAL;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=50;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);
                                }




                            }

                        }

                    }else{

                        $RESIDUAL= ( request('DiscountBill') + request('Total_Discount') ) ;
                        $RESIDUALSSSS= request('Total_Price') - ( request('DiscountBill') + request('Total_Discount') ) ;


                        if(request('Total_Taxes') != 0){

                            if(request('Status') == 1){
                                $NewMkhazns=StoreCountSales::all();


                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => $paid,
                                        'Total_Creditor' => $paid,
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);




                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (round(request('Total_Price')));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                if($paid != 0 or $paid > 0){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=abs($paid);
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=abs($paid);
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * abs($paid);
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=abs($paid);
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Safe');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=abs($paid);
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * abs($paid);
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Safe');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }




                            }
                        }else{

                            if(request('Status') == 1){
                                $NewMkhazns=StoreCountSales::all();


                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => $paid,
                                        'Total_Creditor' => $paid,
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);




                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUALSSSS;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUALSSSS;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUALSSSS;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                if($paid != 0 or $paid > 0){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=abs($paid);
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=abs($paid);
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * abs($paid);
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=abs($paid);
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Safe');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=abs($paid);
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * abs($paid);
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Safe');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }




                            }
                        }
                    }


                }elseif(request('Payment_Method') == 'Check'){
                    $RESIDUAL= ( request('DiscountBill') + request('Total_Discount') ) ;

                    if(request('DiscountBill') == 0 or request('Total_Discount') != 0){

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $ress=IncomChecks::orderBy('id','desc')->first();

                                if(!empty($ress->Code)){

                                    $Codee=$ress->Code + 1 ;
                                }else{
                                    $Codee=1;

                                }


                                $checkk['Code'] =$Codee;
                                $checkk['Date'] = request('Date');
                                $checkk['Draw'] = request('Draw');
                                $checkk['Note'] = request('Note');
                                $checkk['Check_Num'] = request('Check_Number');
                                $checkk['Due_Date'] = request('Due_Date');
                                $checkk['Amount'] = request('Total_Price');
                                $checkk['Status'] =0;
                                $checkk['Reason'] =null;
                                $checkk['Check_Type'] = request('Check_Type');
                                $checkk['Coin'] = request('Coin');
                                $checkk['Cost_Center'] = request('Cost_Center');
                                $checkk['Account'] = request('Client');
                                $checkk['Bank'] = request('Safe');
                                $checkk['Arrest_Account'] =35;
                                $checkk['Bene_Account'] =null;
                                $checkk['User'] =$admin->id;

                                IncomChecks::create($checkk);




                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price') + request('Total_Taxes'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=(request('Total_Price') + (request('Total_Taxes') - $RESIDUAL));
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=35;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=(request('Total_Price') + (request('Total_Taxes') - $RESIDUAL));
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Total_Price') + (request('Total_Taxes') - $RESIDUAL));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=35;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (round(request('Total_Price')));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }




                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price') + request('Total_Taxes'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }

                        }else{
                            if(request('Status') == 1){

                                $ress=IncomChecks::orderBy('id','desc')->first();

                                if(!empty($ress->Code)){

                                    $Codee=$ress->Code + 1 ;
                                }else{
                                    $Codee=1;

                                }


                                $checkk['Code'] =$Codee;
                                $checkk['Date'] = request('Date');
                                $checkk['Draw'] = request('Draw');
                                $checkk['Note'] = request('Note');
                                $checkk['Check_Num'] = request('Check_Number');
                                $checkk['Due_Date'] = request('Due_Date');
                                $checkk['Amount'] = request('Total_Price');
                                $checkk['Status'] =0;
                                $checkk['Reason'] =null;
                                $checkk['Check_Type'] = request('Check_Type');
                                $checkk['Coin'] = request('Coin');
                                $checkk['Cost_Center'] = request('Cost_Center');
                                $checkk['Account'] = request('Client');
                                $checkk['Bank'] = request('Safe');
                                $checkk['Arrest_Account'] =35;
                                $checkk['Bene_Account'] =null;
                                $checkk['User'] =$admin->id;

                                IncomChecks::create($checkk);




                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') - $RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=35;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') - $RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price') - $RESIDUAL);
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=35;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }

                    }else{

                        $RESIDUAL= ( request('DiscountBill') + request('Total_Discount') ) ;
                        $RESIDUALSSSS= round(request('Total_Price')) - ( request('DiscountBill') + request('Total_Discount') ) ;
                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $ress=IncomChecks::orderBy('id','desc')->first();

                                if(!empty($ress->Code)){

                                    $Codee=$ress->Code + 1 ;
                                }else{
                                    $Codee=1;

                                }


                                $checkk['Code'] =$Codee;
                                $checkk['Date'] = request('Date');
                                $checkk['Draw'] = request('Draw');
                                $checkk['Note'] = request('Note');
                                $checkk['Check_Num'] = request('Check_Number');
                                $checkk['Due_Date'] = request('Due_Date');
                                $checkk['Amount'] = request('Total_Price');
                                $checkk['Status'] =0;
                                $checkk['Reason'] =null;
                                $checkk['Check_Type'] = request('Check_Type');
                                $checkk['Coin'] = request('Coin');
                                $checkk['Cost_Center'] = request('Cost_Center');
                                $checkk['Account'] = request('Client');
                                $checkk['Bank'] = request('Safe');
                                $checkk['Arrest_Account'] =35;
                                $checkk['Bene_Account'] =null;
                                $checkk['User'] =$admin->id;

                                IncomChecks::create($checkk);




                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=35;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=35;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') - request('Total_Taxes');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') - request('Total_Taxes');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Total_Price') - request('Total_Taxes') );
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUALSSSS;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUALSSSS;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUALSSSS;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }

                        }else{

                            if(request('Status') == 1){

                                $ress=IncomChecks::orderBy('id','desc')->first();

                                if(!empty($ress->Code)){

                                    $Codee=$ress->Code + 1 ;
                                }else{
                                    $Codee=1;

                                }


                                $checkk['Code'] =$Codee;
                                $checkk['Date'] = request('Date');
                                $checkk['Draw'] = request('Draw');
                                $checkk['Note'] = request('Note');
                                $checkk['Check_Num'] = request('Check_Number');
                                $checkk['Due_Date'] = request('Due_Date');
                                $checkk['Amount'] = request('Total_Price');
                                $checkk['Status'] =0;
                                $checkk['Reason'] =null;
                                $checkk['Check_Type'] = request('Check_Type');
                                $checkk['Coin'] = request('Coin');
                                $checkk['Cost_Center'] = request('Cost_Center');
                                $checkk['Account'] = request('Client');
                                $checkk['Bank'] = request('Safe');
                                $checkk['Arrest_Account'] =35;
                                $checkk['Bene_Account'] =null;
                                $checkk['User'] =$admin->id;

                                IncomChecks::create($checkk);




                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=35;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=35;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price');
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUALSSSS;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUALSSSS;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUALSSSS;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);





                            }

                        }
                    }

                }elseif(request('Payment_Method') == 'Cash_Visa'){


                    if(request('DiscountBill') != 0 or request('Total_Discount') != 0){
                        $RESIDUAL=( request('DiscountBill') + request('Total_Discount') ) ;
                        $RESIDUALSSSS= request('Total_Price') - ( request('DiscountBill') + request('Total_Discount') ) ;

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Cash') + request('Visa') + $RESIDUAL;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Cash') + request('Visa') + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Cash') + request('Visa') + $RESIDUAL);
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Cash');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Cash');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Cash');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Visa');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('SafeVisa');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Visa');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Visa');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('SafeVisa');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( request('Total_Price') );
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=(request('Cash') + request('Visa') + $RESIDUAL);
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=(request('Cash') + request('Visa') + $RESIDUAL);
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Cash') + request('Visa') + $RESIDUAL);
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }else{
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Cash') + request('Visa') + $RESIDUAL;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Cash') + request('Visa') + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Cash') + request('Visa') + $RESIDUAL);
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Cash');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Cash');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Cash');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Visa');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('SafeVisa');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Visa');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Visa');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('SafeVisa');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price');
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }



                    }else{

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Cash') + request('Visa');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Cash') + request('Visa');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Cash') + request('Visa'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Cash');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Cash');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Cash');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Visa');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('SafeVisa');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Visa');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Visa');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('SafeVisa');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( request('Total_Price'));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=(request('Cash') + request('Visa'));
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=(request('Cash') + request('Visa'));
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Cash') + request('Visa'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }else{
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Cash') + request('Visa');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Cash') + request('Visa');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Cash') + request('Visa'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Cash');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Cash');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Cash');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Visa');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('SafeVisa');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Visa');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Visa');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('SafeVisa');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price');
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }

                    }
                }elseif(request('Payment_Method') == 'Cash_Collection'){

                    if(request('DiscountBill') != 0 or request('Total_Discount') != 0){
                        $RESIDUAL=( request('DiscountBill') + request('Total_Discount') ) ;
                        $RESIDUALSSSS= request('Total_Price') - ( request('DiscountBill') + request('Total_Discount') ) ;

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') + $RESIDUAL;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Total_Price') + $RESIDUAL);
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( request('Total_Price') );
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + $RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + $RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Total_Price') + $RESIDUAL);
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }

                        }else{
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') + $RESIDUAL;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Total_Price') + $RESIDUAL);
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') + $RESIDUAL;
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( request('Total_Price') + $RESIDUAL );
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + $RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + $RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Total_Price') + $RESIDUAL);
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }

                    }else{

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Total_Price') + request('Total_Taxes') );
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Total_Price') + request('Total_Taxes'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( request('Total_Price') );
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Total_Price') + request('Total_Taxes'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }

                        }else{
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price');
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price');
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }

                    }

                }elseif(request('Payment_Method') == 'Delivery'){


                    $DELEVERYY=Employess::find(request('Delivery'));

                    $Address=Addressses::find(request('Client_Address'));
                    $acc=AcccountingManual::where('Name','تحصيل دليفري')->first();

                    if(request('DiscountBill') != 0 or request('Total_Discount') != 0){
                        $RESIDUAL=( request('DiscountBill') + request('Total_Discount') ) ;
                        $RESIDUALSSSS= request('Total_Price') - ( request('DiscountBill') + request('Total_Discount') ) ;

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();


                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => $paid,
                                        'Total_Creditor' => $paid,
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){


                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);




                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=(request('Total_Price') + $Address->Place()->first()->Ship_Price) + request('Total_Taxes') + $RESIDUAL ;
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=(request('Total_Price') + $Address->Place()->first()->Ship_Price) + request('Total_Taxes')  + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( (request('Total_Price') + $Address->Place()->first()->Ship_Price) + request('Total_Taxes')  + $RESIDUAL);
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$Address->Place()->first()->Ship_Price;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$acc->id;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$Address->Place()->first()->Ship_Price;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $Address->Place()->first()->Ship_Price;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=$acc->id;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=( (request('Total_Price') + $Address->Place()->first()->Ship_Price));
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=( (request('Total_Price') + $Address->Place()->first()->Ship_Price));
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( (request('Total_Price') + $Address->Place()->first()->Ship_Price));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){


                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$Address->Place()->first()->Ship_Price;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$acc->id;
                                $PRODUCTSS['Statement']=null;



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=( (request('Total_Price') + $Address->Place()->first()->Ship_Price) + request('Total_Taxes'));
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$DELEVERYY->Covenant;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=( (request('Total_Price') + $Address->Place()->first()->Ship_Price) + request('Total_Taxes'));
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * ( (request('Total_Price') + $Address->Place()->first()->Ship_Price) + request('Total_Taxes'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=$DELEVERYY->Covenant;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                            }
                        }else{
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();


                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => $paid,
                                        'Total_Creditor' => $paid,
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){


                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);




                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=(request('Total_Price') + $Address->Place()->first()->Ship_Price) + $RESIDUAL ;
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=(request('Total_Price') + $Address->Place()->first()->Ship_Price)   + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( (request('Total_Price') + $Address->Place()->first()->Ship_Price)  + $RESIDUAL);
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$Address->Place()->first()->Ship_Price;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$acc->id;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$Address->Place()->first()->Ship_Price;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $Address->Place()->first()->Ship_Price;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=$acc->id;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=( (request('Total_Price') + $Address->Place()->first()->Ship_Price));
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=( (request('Total_Price') + $Address->Place()->first()->Ship_Price));
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( (request('Total_Price') + $Address->Place()->first()->Ship_Price));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$Address->Place()->first()->Ship_Price;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$acc->id;
                                $PRODUCTSS['Statement']=null;



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=( (request('Total_Price') + $Address->Place()->first()->Ship_Price));
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$DELEVERYY->Covenant;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=( (request('Total_Price') + $Address->Place()->first()->Ship_Price));
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * ( (request('Total_Price') + $Address->Place()->first()->Ship_Price));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=$DELEVERYY->Covenant;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                            }
                        }

                    }else{

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();


                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => $paid,
                                        'Total_Creditor' => $paid,
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){


                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);




                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=(request('Total_Price') + $Address->Place()->first()->Ship_Price) + request('Total_Taxes') ;
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=(request('Total_Price') + $Address->Place()->first()->Ship_Price) + request('Total_Taxes') ;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( (request('Total_Price') + $Address->Place()->first()->Ship_Price) + request('Total_Taxes') );
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$Address->Place()->first()->Ship_Price;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$acc->id;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$Address->Place()->first()->Ship_Price;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $Address->Place()->first()->Ship_Price;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=$acc->id;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=( (request('Total_Price') + $Address->Place()->first()->Ship_Price));
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=( (request('Total_Price') + $Address->Place()->first()->Ship_Price));
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( (request('Total_Price') + $Address->Place()->first()->Ship_Price));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){


                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$Address->Place()->first()->Ship_Price;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$acc->id;
                                $PRODUCTSS['Statement']=null;



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=( (request('Total_Price') + $Address->Place()->first()->Ship_Price) + request('Total_Taxes'));
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$DELEVERYY->Covenant;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=( (request('Total_Price') + $Address->Place()->first()->Ship_Price) + request('Total_Taxes'));
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * ( (request('Total_Price') + $Address->Place()->first()->Ship_Price) + request('Total_Taxes'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=$DELEVERYY->Covenant;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                            }
                        }else{
                            if(request('Status') == 1){
                                $NewMkhazns=StoreCountSales::all();


                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => $paid,
                                        'Total_Creditor' => $paid,
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);




                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price')+ $Address->Place()->first()->Ship_Price;
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + $Address->Place()->first()->Ship_Price;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price') + $Address->Place()->first()->Ship_Price;
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$Address->Place()->first()->Ship_Price;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$acc->id;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$Address->Place()->first()->Ship_Price;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $Address->Place()->first()->Ship_Price;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=$acc->id;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') + $Address->Place()->first()->Ship_Price;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + $Address->Place()->first()->Ship_Price;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price') + $Address->Place()->first()->Ship_Price;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + $Address->Place()->first()->Ship_Price;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$DELEVERYY->Covenant;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + $Address->Place()->first()->Ship_Price;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price') + $Address->Place()->first()->Ship_Price;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=$DELEVERYY->Covenant;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                            }
                        }
                    }

                }elseif(request('Payment_Method') == 'InstallmentCompanies'){

                    $comp=InstallmentCompanies::find(request('InstallCompany'));
                    if(request('DiscountBill') != 0 or request('Total_Discount') != 0){
                        $RESIDUAL=( request('DiscountBill') + request('Total_Discount') ) ;
                        $RESIDUALSSSS= request('Total_Price') - ( request('DiscountBill') + request('Total_Discount') ) ;

                        if(request('Total_Taxes') != 0){

                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                if(request('PayFees') == 'Yes'){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Price') ;
                                    $PRODUCTSS['Account']=48;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Price') ;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Price') ;
                                    $Gen['Account']=48;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Account']=895;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Account']=895;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);
                                }else{

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Price');
                                    $PRODUCTSS['Account']=48;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Price') ;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * (request('Total_Price'));
                                    $Gen['Account']=48;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;


                                    GeneralDaily::create($Gen);


                                }



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=(request('Total_Price') + request('Total_Taxes') + request('ServiceFee') + request('CompanyPrecent')) - ( $RESIDUAL + request('ServiceFee') + request('CompanyPrecent') ) - request('CompanyPrecent');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$comp->NakdyaAccount;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=(request('Total_Price') + request('Total_Taxes') + request('ServiceFee') + request('CompanyPrecent')) - ( $RESIDUAL + request('ServiceFee') + request('CompanyPrecent') ) - request('CompanyPrecent');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Total_Price') + request('Total_Taxes') + request('ServiceFee') + request('CompanyPrecent')) - ( $RESIDUAL + request('ServiceFee') + request('CompanyPrecent') ) - request('CompanyPrecent');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=$comp->NakdyaAccount;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                if(request('PayFees') == 'Yes'){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);
                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('CompanyPrecent');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$comp->Account;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('CompanyPrecent');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('CompanyPrecent');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']= $comp->Account;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                if(request('PayFees') == 'Yes'){

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Safe');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Safe');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $comp=InstallmentCompanies::find(request('InstallCompany'));
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                            }


                        }else{

                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                if(request('PayFees') == 'Yes'){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Price');
                                    $PRODUCTSS['Account']=48;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Price');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Price') ;
                                    $Gen['Account']=48;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Account']=895;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Account']=895;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }else{

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Price');
                                    $PRODUCTSS['Account']=48;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Price') ;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * (request('Total_Price'));
                                    $Gen['Account']=48;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=(request('Total_Price')  + request('ServiceFee') + request('CompanyPrecent')) - ( $RESIDUAL + request('ServiceFee') + request('CompanyPrecent') ) - request('CompanyPrecent');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$comp->NakdyaAccount;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=(request('Total_Price')  + request('ServiceFee') + request('CompanyPrecent')) - ( $RESIDUAL + request('ServiceFee') + request('CompanyPrecent') ) - request('CompanyPrecent');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Total_Price')  + request('ServiceFee') + request('CompanyPrecent')) - ( $RESIDUAL + request('ServiceFee') + request('CompanyPrecent') ) - request('CompanyPrecent');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=$comp->NakdyaAccount;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                if(request('PayFees') == 'Yes'){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);
                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('CompanyPrecent');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$comp->Account;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('CompanyPrecent');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('CompanyPrecent');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']= $comp->Account;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                if(request('PayFees') == 'Yes'){

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Safe');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Safe');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $comp=InstallmentCompanies::find(request('InstallCompany'));
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                            }

                        }

                    }else{

                        if(request('Total_Taxes') != 0){

                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                if(request('PayFees') == 'Yes'){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Price');
                                    $PRODUCTSS['Account']=48;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Price');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Price') ;
                                    $Gen['Account']=48;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Account']=895;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Account']=895;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }else{

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Price');
                                    $PRODUCTSS['Account']=48;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Price') ;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * (request('Total_Price'));
                                    $Gen['Account']=48;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }




                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=(request('Total_Price') + request('Total_Taxes') + request('ServiceFee') + request('CompanyPrecent')) - (  request('ServiceFee') + request('CompanyPrecent') ) - request('CompanyPrecent');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$comp->NakdyaAccount;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=(request('Total_Price') + request('Total_Taxes') + request('ServiceFee') + request('CompanyPrecent')) - ( request('ServiceFee') + request('CompanyPrecent') ) - request('CompanyPrecent');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Total_Price') + request('Total_Taxes') + request('ServiceFee') + request('CompanyPrecent')) - (  request('ServiceFee') + request('CompanyPrecent') ) - request('CompanyPrecent');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=$comp->NakdyaAccount;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                if(request('PayFees') == 'Yes'){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);
                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('CompanyPrecent');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$comp->Account;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('CompanyPrecent');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('CompanyPrecent');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']= $comp->Account;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                if(request('PayFees') == 'Yes'){

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Safe');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Safe');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $comp=InstallmentCompanies::find(request('InstallCompany'));
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                            }

                        }else{

                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }


                                if(request('PayFees') == 'Yes'){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Price');
                                    $PRODUCTSS['Account']=48;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Price');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Price');
                                    $Gen['Account']=48;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Account']=895;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Account']=895;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }else{

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Price');
                                    $PRODUCTSS['Account']=48;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Price');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                    $Gen['Account']=48;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);



                                }
                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') - request('CompanyPrecent');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$comp->NakdyaAccount;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') - request('CompanyPrecent');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price') - request('CompanyPrecent'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=$comp->NakdyaAccount;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                if(request('PayFees') == 'Yes'){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);
                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('CompanyPrecent');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=$comp->Account;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('CompanyPrecent');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('CompanyPrecent');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']= $comp->Account;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                if(request('PayFees') == 'Yes'){

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Safe');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Safe');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $comp=InstallmentCompanies::find(request('InstallCompany'));
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('ServiceFee') + request('CompanyPrecent');
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                            }
                        }

                    }




                }

            }

            if($Hold == 0){
                if(request('TaxOnTotal') == 'Yes'){


                    $to=(request('Total_Price') + request('ProfitTax') + request('Total_Taxes'))  - $RESIDUAL;
                    if(request('Pay') == $to){
                        $PRODUCTSS['Joun_ID']=$JunID;
                        $PRODUCTSS['Debitor']=0;
                        $PRODUCTSS['Creditor']=request('ProfitTax');
                        $PRODUCTSS['Account']=request('Client');
                        $PRODUCTSS['Statement']=null;


                        JournalizingDetails::create($PRODUCTSS);

                        $Gen['Code']=$Code;
                        $Gen['Code_Type']=$CodeT;
                        $Gen['Date']=request('Date');
                        $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                        $Gen['Debitor']=0;
                        $Gen['Creditor']=request('ProfitTax');
                        $Gen['Statement']=null;
                        $Gen['Draw']=request('Draw');
                        $Gen['Debitor_Coin']= request('Draw') * 0;
                        $Gen['Creditor_Coin']=request('Draw') * request('ProfitTax');
                        $Gen['Account']=request('Client');
                        $Gen['Coin']= request('Coin');
                        $Gen['Cost_Center']=request('Cost_Center');
                        $Gen['userr']= $admin->id;

                        GeneralDaily::create($Gen);


                        $PRODUCTSS['Joun_ID']=$JunID;
                        $PRODUCTSS['Debitor']=request('ProfitTax');
                        $PRODUCTSS['Creditor']=0;
                        $PRODUCTSS['Account']=request('Safe');
                        $PRODUCTSS['Statement']=null;


                        JournalizingDetails::create($PRODUCTSS);

                        $Gen['Code']=$Code;
                        $Gen['Code_Type']=$CodeT;
                        $Gen['Date']=request('Date');
                        $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                        $Gen['Debitor']=request('ProfitTax');
                        $Gen['Creditor']=0;
                        $Gen['Statement']=null;
                        $Gen['Draw']=request('Draw');
                        $Gen['Debitor_Coin']= request('Draw') * request('ProfitTax');
                        $Gen['Creditor_Coin']=request('Draw') * 0;
                        $Gen['Account']=request('Safe');
                        $Gen['Coin']= request('Coin');
                        $Gen['Cost_Center']=request('Cost_Center');
                        $Gen['userr']= $admin->id;

                        GeneralDaily::create($Gen);
                    }

                    $TTax=Taxes::find(request('TaxOnTotalType'));

                    $PRODUCTSS['Joun_ID']=$JunID;
                    $PRODUCTSS['Debitor']=0;
                    $PRODUCTSS['Creditor']=request('ProfitTax');
                    $PRODUCTSS['Account']=$TTax->Account;
                    $PRODUCTSS['Statement']=null;


                    JournalizingDetails::create($PRODUCTSS);

                    $Gen['Code']=$Code;
                    $Gen['Code_Type']=$CodeT;
                    $Gen['Date']=request('Date');
                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                    $Gen['Debitor']=0;
                    $Gen['Creditor']=request('ProfitTax');
                    $Gen['Statement']=null;
                    $Gen['Draw']=request('Draw');
                    $Gen['Debitor_Coin']= request('Draw') * 0;
                    $Gen['Creditor_Coin']=request('Draw') * request('ProfitTax');
                    $Gen['Account']=$TTax->Account;
                    $Gen['Coin']= request('Coin');
                    $Gen['Cost_Center']=request('Cost_Center');
                    $Gen['userr']= $admin->id;

                    GeneralDaily::create($Gen);

                    $PRODUCTSS['Joun_ID']=$JunID;
                    $PRODUCTSS['Debitor']=request('ProfitTax');
                    $PRODUCTSS['Creditor']=0;
                    $PRODUCTSS['Account']=request('Client');
                    $PRODUCTSS['Statement']=null;


                    JournalizingDetails::create($PRODUCTSS);

                    $Gen['Code']=$Code;
                    $Gen['Code_Type']=$CodeT;
                    $Gen['Date']=request('Date');
                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                    $Gen['Debitor']=request('ProfitTax');
                    $Gen['Creditor']=0;
                    $Gen['Statement']=null;
                    $Gen['Draw']=request('Draw');
                    $Gen['Debitor_Coin']= request('Draw') * request('ProfitTax');
                    $Gen['Creditor_Coin']=request('Draw') * 0;
                    $Gen['Account']=request('Client');
                    $Gen['Coin']= request('Coin');
                    $Gen['Cost_Center']=request('Cost_Center');
                    $Gen['userr']= $admin->id;

                    GeneralDaily::create($Gen);


                }


            }


            if($Hold == 0){
                if(request('Payment_Method') == 'Installment'){


                    $installmentsID = DB::table('installments')->insertGetId(
                        array(

                            'presenter' => request('presenter'),
                            'annual_interest' => request('annual_interest'),
                            'monthly_installment' => request('monthly_installment'),
                            'Years_Number' => request('Years_Number'),
                            'total' => request('total'),
                            'installment_Num' => request('installment_Num'),
                            'Date_First_installment' => request('Date_First_installment'),
                            'Residual' => request('total') - request('presenter'),
                            'Status' => 0,
                            'Client' => request('Client'),
                            'Sales' => $ID,


                        )
                    );

                    $resd= request('total') - request('presenter') ;
                    $Precent= request('annual_interest') / 100 ;

                    $resdPrecent= $resd * $Precent ;

                    $resdYears = $resdPrecent * request('Years_Number') ;

                    $resdTotal= $resd + $resdYears ;

                    $monthly = request('Years_Number') * 12 ;

                    $valueMonth = $resdTotal / $monthly ;

                    $date=request('Date_First_installment');
                    for($i=0 ; $i < $monthly ; $i++){

                        $inst['Date']=$date;
                        $inst['Value']=$valueMonth;
                        $inst['Status']=0;
                        $inst['Client']=request('Client');
                        $inst['Install']=$installmentsID;
                        InstallmentDates::create($inst);
                        $date = date('Y-m-d',strtotime('+30 days',strtotime($date))) ;


                    }
                }
            }



            if(request('Hold') == 0){
                if(request('Payment_Method') == 'Cash_Collection'){
                    if($paid > request('Total_Price')){

                        $RESIDUAL=( request('DiscountBill') + request('Total_Discount') ) ;
                        $THEDIF=$paid - ((request('Total_Price') + request('Total_Taxes')) - $RESIDUAL) ;

                        $res=ReciptVoucher::orderBy('id','desc')->first();

                        if(!empty($res->Code)){

                            $CodeRecipt=$res->Code + 1 ;
                        }else{
                            $CodeRecipt=1;

                        }

                        $IDD = DB::table('recipt_vouchers')->insertGetId(

                            array(

                                'Code' => $CodeRecipt,
                                'Date' => request('Date'),
                                'Draw' => request('Draw'),
                                'Coin' => request('Coin'),
                                'Safe' => request('Safe'),
                                'Cost_Center' => null,
                                'Total_Creditor' => $THEDIF,
                                'Note' => null,

                            )
                        );
                        $PRODUCTS['RV_ID']=$IDD;
                        $PRODUCTS['Creditor']=$THEDIF;
                        $PRODUCTS['Account']=request('Client');
                        $PRODUCTS['Statement']=null;


                        ReciptVoucherDetails::create($PRODUCTS);


                        $res=Journalizing::orderBy('id','desc')->first();

                        if(!empty($res->Code)){

                            $Code=$res->Code + 1 ;
                        }else{
                            $Code=1;

                        }

                        $ID = DB::table('journalizings')->insertGetId(

                            array(

                                'Code' => $Code,
                                'Type' => 'سند قبض',
                                'TypeEn' => 'Receipt Voucher',
                                'Code_Type' => $CodeRecipt,
                                'Date' => request('Date'),
                                'Draw' => request('Draw'),
                                'Coin' => request('Coin'),
                                'Cost_Center' => null,
                                'Total_Debaitor' => $THEDIF,
                                'Total_Creditor' => $THEDIF,
                                'Note' => null,

                            )
                        );



                        $PRODUCTSS['Joun_ID']=$ID;
                        $PRODUCTSS['Debitor']=0;
                        $PRODUCTSS['Creditor']=$THEDIF;
                        $PRODUCTSS['Account']=request('Client');
                        $PRODUCTSS['Statement']=null;


                        JournalizingDetails::create($PRODUCTSS);

                        $Gen['Code']=$Code;
                        $Gen['Code_Type']=$CodeRecipt;
                        $Gen['Date']=request('Date');
                        $Gen['Type']='سند قبض';
                        $Gen['TypeEn']='Receipt Voucher';
                        $Gen['Debitor']=0;
                        $Gen['Creditor']=$THEDIF;
                        $Gen['Statement']=null;
                        $Gen['Draw']=request('Draw');
                        $Gen['Debitor_Coin']= request('Draw') * 0;
                        $Gen['Creditor_Coin']=request('Draw') * $THEDIF;
                        $Gen['Account']=request('Client');
                        $Gen['Coin']= request('Coin');
                        $Gen['Cost_Center']= null;
                        $Gen['userr']= auth()->guard('admin')->user()->id;

                        GeneralDaily::create($Gen);



                        $PRODUCTSSS['Joun_ID']=$ID;
                        $PRODUCTSSS['Debitor']=$THEDIF;
                        $PRODUCTSSS['Creditor']=0;
                        $PRODUCTSSS['Account']=request('Safe');
                        $PRODUCTSSS['Statement']=null;
                        JournalizingDetails::create($PRODUCTSSS);

                        $Genn['Code']=$Code;
                        $Genn['Code_Type']=$CodeRecipt;
                        $Genn['Date']=request('Date');
                        $Genn['Type']='سند قبض';
                        $Genn['TypeEn']='Receipt Voucher';
                        $Genn['Debitor']=$THEDIF;
                        $Genn['Creditor']=0;
                        $Genn['Statement']=null;
                        $Genn['Draw']=request('Draw');
                        $Genn['Debitor_Coin']= request('Draw') * $THEDIF;
                        $Genn['Creditor_Coin']=request('Draw') * 0;
                        $Genn['Account']=request('Safe');
                        $Genn['Coin']= request('Coin');
                        $Genn['Cost_Center']= null;
                        $Genn['userr']= auth()->guard('admin')->user()->id;

                        GeneralDaily::create($Genn);

                    }
                }
            }

            if(request('Hold') == 0){
                $store=Stores::find(request('Store'));
                $totpri=(request('Total_Taxes') +  request('Total_Price') + request('ProfitTax')) -  (request('Total_Discount') + request('DiscountBill'));

                $dataStMove['Date']=request('Date');
                $dataStMove['Code']=$CodeT;
                $dataStMove['Time']=date("h:i:s a", time());
                $dataStMove['Branch']=$store->Branch;
                $dataStMove['Store']=request('Store');
                $dataStMove['Safe']=request('Safe');
                $dataStMove['Type']='مبيعات';
                $dataStMove['TypeEn']='Sales';
                $dataStMove['Cost_Center']=request('Cost_Center');
                $dataStMove['User']=$admin->id;
                $dataStMove['Coin']=request('Coin');
                $dataStMove['Note']=request('Note');
                $dataStMove['Total_Qty']=request('Total_Qty');
                $dataStMove['Total_Price']=$totpri;
                $dataStMove['Account']=request('Client');
                $dataStMove['Ship']=request('Ship');
                $dataStMove['ID']=$ID;
                StoresMoves::create($dataStMove);
            }


            $dataUser['User']=$admin->id;
            $dataUser['Date']=date('Y-m-d');
            $dataUser['Time']=date("h:i:s a", time());
            $dataUser['Screen']='نقاط البيع تطبيق';
            $dataUser['ScreenEn']='POS App';
            $dataUser['Type']='اضافه جديده';
            $dataUser['TypeEn']='New Add';
            $dataUser['Explain']=$CodeT;
            $dataUser['ExplainEn']=$CodeT;
            UsersMoves::create($dataUser);


            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Added_Successfully'),
            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }



//KitchenHallBills
    public function KitchenHallBills(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();
        $ArrayPros=array();


        $Halls=SalesOrder::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Hall'])
            ->where('Status',1)
            ->where('KitchenEnd',0)
            ->where('RecivedOrder',0)
            ->get();


        if($lang == 'ar'){


            foreach($Halls as $hall){



                $details=ProductSalesOrder::orderBy('id','asc')->where('SalesOrder',$hall->id)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_Ar_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->Name,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->id,
                    'code'=>$hall->Code,
                    'date'=>$hall->Date,
                    'time'=>$hall->Time,
                    'table'=>$hall->Table()->first()->Arabic_Name,
                    'waiter'=>$hall->Witer()->first()->Name,
                    'products'=>$ArrayPros,

                ]);





            }

        }else{


            foreach($Halls as $hall){



                $details=ProductSalesOrder::orderBy('id','asc')->where('SalesOrder',$hall->id)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_En_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->NameEn,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->id,
                    'code'=>$hall->Code,
                    'date'=>$hall->Date,
                    'time'=>$hall->Time,
                    'table'=>$hall->Table()->first()->English_Name,
                    'waiter'=>$hall->Witer()->first()->NameEn,
                    'products'=>$ArrayPros,

                ]);



            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }

//KitchenDeliveryBills
    public function KitchenDeliveryBills(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();
        $ArrayPros=array();


        $Halls=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Delivery'])
            ->where('Status',1)
            ->where('KitchenEnd',0)
            ->where('RecivedOrder',0)
            ->get();


        if($lang == 'ar'){


            foreach($Halls as $hall){



                $details=ProductSales::orderBy('id','asc')->where('Sales',$hall->id)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_Ar_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->Name,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->id,
                    'code'=>$hall->Code,
                    'date'=>$hall->Date,
                    'time'=>$hall->Time,
                    'delivery'=>$hall->Delivery()->first()->Name,
                    'products'=>$ArrayPros,

                ]);






            }

        }else{


            foreach($Halls as $hall){



                $details=ProductSales::orderBy('id','asc')->where('Sales',$hall->id)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_En_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->NameEn,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->id,
                    'code'=>$hall->Code,
                    'date'=>$hall->Date,
                    'time'=>$hall->Time,
                    'delivery'=>$hall->Delivery()->first()->NameEn,
                    'products'=>$ArrayPros,

                ]);



            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }

//KitchenTakeawayBills
    public function KitchenTakeawayBills(Request $request){

        $lang = $request->header('lang', '');


        $Array=array();
        $ArrayPros=array();


        $Halls=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Takeaway'])
            ->where('Status',1)
            ->where('KitchenEnd',0)
            ->where('RecivedOrder',0)
            ->get();


        if($lang == 'ar'){


            foreach($Halls as $hall){



                $details=ProductSales::orderBy('id','asc')->where('Sales',$hall->id)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_Ar_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->Name,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->id,
                    'code'=>$hall->Code,
                    'date'=>$hall->Date,
                    'time'=>$hall->Time,
                    'products'=>$ArrayPros,

                ]);






            }

        }else{


            foreach($Halls as $hall){



                $details=ProductSales::orderBy('id','asc')->where('Sales',$hall->id)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_En_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->NameEn,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->id,
                    'code'=>$hall->Code,
                    'date'=>$hall->Date,
                    'time'=>$hall->Time,
                    'products'=>$ArrayPros,

                ]);



            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }

//KitchenHallMoreBills
    public function KitchenHallMoreBills(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();
        $ArrayPros=array();



        $Halls=MoreProductsHall::where('KitchenEnd',0)->distinct(['SalesOrder'])->get();




        if($lang == 'ar'){


            foreach($Halls as $hall){



                $details=MoreProductsHall::orderBy('id','asc')->where('SalesOrder',$hall->SalesOrder)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_Ar_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->Name,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->SalesOrder,
                    'code'=>$hall->SalesOrder()->first()->Code,
                    'date'=>$hall->SalesOrder()->first()->Date,
                    'time'=>$hall->SalesOrder()->first()->Time,
                    'table'=>$hall->SalesOrder()->first()->Table()->first()->Arabic_Name,
                    'waiter'=>$hall->SalesOrder()->first()->Witer()->first()->Name,
                    'products'=>$ArrayPros,

                ]);





            }

        }else{


            foreach($Halls as $hall){



                $details=MoreProductsHall::orderBy('id','asc')->where('SalesOrder',$hall->SalesOrder)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_En_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->NameEn,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->SalesOrder,
                    'code'=>$hall->SalesOrder()->first()->Code,
                    'date'=>$hall->SalesOrder()->first()->Date,
                    'time'=>$hall->SalesOrder()->first()->Time,
                    'table'=>$hall->SalesOrder()->first()->Table()->first()->English_Name,
                    'waiter'=>$hall->SalesOrder()->first()->Witer()->first()->NameEn,
                    'products'=>$ArrayPros,

                ]);



            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }

//KitchenHallRemoveBills
    public function KitchenHallRemoveBills(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();
        $ArrayPros=array();



        $Halls=RemoveProductsHall::where('KitchenEnd',0)->distinct(['SalesOrder'])->get();




        if($lang == 'ar'){


            foreach($Halls as $hall){



                $details=RemoveProductsHall::orderBy('id','asc')->where('SalesOrder',$hall->SalesOrder)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_Ar_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->Name,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->SalesOrder,
                    'code'=>$hall->SalesOrder()->first()->Code,
                    'date'=>$hall->SalesOrder()->first()->Date,
                    'time'=>$hall->SalesOrder()->first()->Time,
                    'table'=>$hall->SalesOrder()->first()->Table()->first()->Arabic_Name,
                    'waiter'=>$hall->SalesOrder()->first()->Witer()->first()->Name,
                    'products'=>$ArrayPros,

                ]);





            }

        }else{


            foreach($Halls as $hall){



                $details=RemoveProductsHall::orderBy('id','asc')->where('SalesOrder',$hall->SalesOrder)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_En_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->NameEn,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->SalesOrder,
                    'code'=>$hall->SalesOrder()->first()->Code,
                    'date'=>$hall->SalesOrder()->first()->Date,
                    'time'=>$hall->SalesOrder()->first()->Time,
                    'table'=>$hall->SalesOrder()->first()->Table()->first()->English_Name,
                    'waiter'=>$hall->SalesOrder()->first()->Witer()->first()->NameEn,
                    'products'=>$ArrayPros,

                ]);



            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }





//    EndKitchenOrderTakeDeliv
    public function EndKitchenOrderTakeDeliv(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();


        if(!empty($admin)){

            Sales::where('id',request('order_id'))->update(['KitchenEnd'=>1,'KitchenEndTime'=>date("h:i:s a", time())]);


            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Ended'),


            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


//EndKitchenOrderHallApi
    public function EndKitchenOrderHallApi(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();


        if(!empty($admin)){


            SalesOrder::where('id',request('order_id'))->update(['KitchenEnd'=>1,'KitchenEndTime'=>date("h:i:s a", time())]);

            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Ended'),


            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

//EndKitchenOrderHallMoreApi

    public function EndKitchenOrderHallMoreApi(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();


        if(!empty($admin)){


            MoreProductsHall::where('SalesOrder',request('order_id'))->update(['KitchenEnd'=>1]);
            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Ended'),


            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

//EndKitchenOrderHallRemoveApi

    public function EndKitchenOrderHallRemoveApi(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();


        if(!empty($admin)){

            RemoveProductsHall::where('SalesOrder',request('order_id'))->update(['KitchenEnd'=>1]);
            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Ended'),


            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }




    //Recived

//RecivedHallBills
    public function RecivedHallBills(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();
        $ArrayPros=array();


        $Halls=SalesOrder::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Hall'])
            ->where('Status',1)
            ->where('KitchenEnd',1)
            ->where('RecivedOrder',0)
            ->get();


        if($lang == 'ar'){


            foreach($Halls as $hall){



                $details=ProductSalesOrder::orderBy('id','asc')->where('SalesOrder',$hall->id)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_Ar_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->Name,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->id,
                    'code'=>$hall->Code,
                    'date'=>$hall->Date,
                    'time'=>$hall->Time,
                    'table'=>$hall->Table()->first()->Arabic_Name,
                    'waiter'=>$hall->Witer()->first()->Name,
                    'products'=>$ArrayPros,

                ]);





            }

        }else{


            foreach($Halls as $hall){



                $details=ProductSalesOrder::orderBy('id','asc')->where('SalesOrder',$hall->id)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_En_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->NameEn,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->id,
                    'code'=>$hall->Code,
                    'date'=>$hall->Date,
                    'time'=>$hall->Time,
                    'table'=>$hall->Table()->first()->English_Name,
                    'waiter'=>$hall->Witer()->first()->NameEn,
                    'products'=>$ArrayPros,

                ]);



            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }

//RecivedDeliveryBills
    public function RecivedDeliveryBills(Request $request){


        $lang = $request->header('lang', '');


        $Array=array();
        $ArrayPros=array();


        $Halls=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Delivery'])
            ->where('Status',1)
            ->where('KitchenEnd',1)
            ->where('RecivedOrder',0)
            ->get();


        if($lang == 'ar'){


            foreach($Halls as $hall){



                $details=ProductSales::orderBy('id','asc')->where('Sales',$hall->id)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_Ar_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->Name,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->id,
                    'code'=>$hall->Code,
                    'date'=>$hall->Date,
                    'time'=>$hall->Time,
                    'delivery'=>$hall->Delivery()->first()->Name,
                    'products'=>$ArrayPros,

                ]);






            }

        }else{


            foreach($Halls as $hall){



                $details=ProductSales::orderBy('id','asc')->where('Sales',$hall->id)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_En_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->NameEn,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->id,
                    'code'=>$hall->Code,
                    'date'=>$hall->Date,
                    'time'=>$hall->Time,
                    'delivery'=>$hall->Delivery()->first()->NameEn,
                    'products'=>$ArrayPros,

                ]);



            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }

//RecivedTakeawayBills
    public function RecivedTakeawayBills(Request $request){

        $lang = $request->header('lang', '');


        $Array=array();
        $ArrayPros=array();


        $Halls=Sales::orderBy('id','desc')
            ->whereIn('ResturantOrderType',['Takeaway'])
            ->where('Status',1)
            ->where('KitchenEnd',1)
            ->where('RecivedOrder',0)
            ->get();


        if($lang == 'ar'){


            foreach($Halls as $hall){



                $details=ProductSales::orderBy('id','asc')->where('Sales',$hall->id)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_Ar_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->Name,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->id,
                    'code'=>$hall->Code,
                    'date'=>$hall->Date,
                    'time'=>$hall->Time,
                    'products'=>$ArrayPros,

                ]);






            }

        }else{


            foreach($Halls as $hall){



                $details=ProductSales::orderBy('id','asc')->where('Sales',$hall->id)->get();

                foreach($details as $det){
                    array_push($ArrayPros,[
                        'pro_name'=>$det->Product()->first()->P_En_Name,
                        'pro_qty'=>$det->Qty,
                        'pro_unit'=>$det->Unit()->first()->NameEn,
                        'pro_note'=>$det->Pro_Note,


                    ]);
                }


                array_push($Array,[
                    'id'=>$hall->id,
                    'code'=>$hall->Code,
                    'date'=>$hall->Date,
                    'time'=>$hall->Time,
                    'products'=>$ArrayPros,

                ]);



            }


        }


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,

        ]);

    }


    //    EndRecivedOrderTakeDeliv
    public function EndRecivedOrderTakeDeliv(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();


        if(!empty($admin)){

            Sales::where('id',request('order_id'))->update(['RecivedOrder'=>1,'RecivedOrderTime'=>date("h:i:s a", time())]);

            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Ended'),


            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }



    public function ResturantMyOrder(Request $request){


        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Customers::where('token',$x)->first();
        $lang = $request->header('lang', '');
        if(!empty($admin)){


            $Orders=SalesOrder::where('Order_Type',2)->orderBy('id','desc')->where('Client',$admin->Account)->get();


            $Array=array();


            foreach($Orders as $ord){
                $ArrayProducts=array();
                $details=ProductSalesOrder::where('SalesOrder',$ord->id)->get();

                if($ord->Delivery_Status == 0){
                    $status=  trans('admin.Pending');
                }elseif($ord->Delivery_Status == 1){
                    $status=   trans('admin.Processing');
                }elseif($ord->Delivery_Status == 2){
                    $status= trans('admin.Recived');
                }
                $SUBTOTAL=$ord->Total_Price - ($ord->CuponCode + $ord->Shipping);



                foreach($details as $detail){

                    if($lang == 'ar'){
                        $proName=$detail->P_Ar_Name;

                        if(!empty($detail->V1)){
                            $proVName=$detail->V1()->first()->Name;
                        }else{

                            $proVName='';
                        }


                        if(!empty($detail->V2)){
                            $proVVName=$detail->V2()->first()->Name;
                        }else{

                            $proVVName='';
                        }


                    }else{

                        $proName=$detail->P_En_Name;

                        if(!empty($detail->V1)){
                            $proVName=$detail->V1()->first()->NameEn;
                        }else{

                            $proVName='';
                        }


                        if(!empty($detail->V2)){
                            $proVVName=$detail->V2()->first()->NameEn;
                        }else{

                            $proVVName='';
                        }


                    }

                    array_push($ArrayProducts,[
                        'image'=>URL::to($detail->Image),
                        'product_name'=>$proName . $proVName . $proVVName,
                        'qty'=>$detail->Qty,
                        'price'=>$detail->Price,
                        'total'=>$detail->Total,

                    ]);

                }




                if($lang == 'ar'){
                    $Gov=$ord->Governrate()->first()->Arabic_Name;
                    $Cit=$ord->City()->first()->Arabic_Name;
                    $Pla=$ord->Place()->first()->Arabic_Name;
                }else{
                    $Gov=$ord->Governrate()->first()->English_Name;
                    $Cit=$ord->City()->first()->English_Name;
                    $Pla=$ord->Place()->first()->English_Name;
                }


                array_push($Array,[
                    'code'=>$ord->Code,
                    'date'=>$ord->Date,
                    'status'=>$status,
                    'sub_total'=>$SUBTOTAL,
                    'cupon_code'=>$ord->CuponCode,
                    'shipping'=>$ord->Shipping,
                    'grand_total'=>$ord->Total_Price,
                    'governrate'=>$Gov,
                    'city'=>$Cit,
                    'place'=>$Pla,
                    'name'=>$ord->Name,
                    'email'=>$ord->Email,
                    'phone'=>$ord->Phone,
                    'other_phone'=>$ord->OtherPhone,
                    'address_name'=>$ord->Address_Name,
                    'special_mark'=>$ord->Special_MarkAdd,
                    'street'=>$ord->StreetAdd,
                    'buliding'=>$ord->BulidingAdd,
                    'floor'=>$ord->FloorAdd,
                    'flat'=>$ord->FlatAdd,
                    'location'=>$ord->LocationAdd,
                    'address_details'=>$ord->Address_DetailsAdd,
                    'products'=>$ArrayProducts,

                ]);

            }



            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,
            ]);

        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }


    }




    //End Hall
    public function PostEndRecivedOrderHallApi(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();


        if(!empty($admin)){

            if(request('Payment_Method') == 'Cash'){

                if(!empty(request('Pay'))){

                    $paid = request('Pay') ;

                }else{

                    $paid = request('Total_Price') ;
                }



            }elseif(request('Payment_Method') == 'Later'){

                $paid = request('Pay') ;

            }elseif(request('Payment_Method') == 'Installment'){

                $paid = request('Pay') ;

            }elseif(request('Payment_Method') == 'Check'){

                $paid = request('Total_Price') ;

            }elseif(request('Payment_Method') == 'Cash_Visa'){

                $paid = request('Total_Price') ;

            }elseif(request('Payment_Method') == 'Cash_Collection'){

                $paid = request('Cash_Collection') ;

            }elseif(request('Payment_Method') == 'Delivery'){

                $paid = request('Pay') ;

            }elseif(request('Payment_Method') == 'InstallmentCompanies'){

                $paid = request('Total_Price') ;

            }

            if(request('Payment_Method') == 'Later'){
                $col=0;
            }else{
                $col=1;
            }


            if(request('Payment_Method') == 'Later'){
                $col=0;
            }else{
                $col=1;
            }


            $branch=Stores::find(request('Store'));
            $custG=Customers::where('Account',request('Client'))->orderBy('id','desc')->first();

            if(!empty($branch)){
                $BRAAA=$branch->Branch;
            }else{
                $BRAAA=null;
            }


            if(!empty($custG)){
                $CUSTGROP=$custG->Group;
            }else{
                $CUSTGROP=null;
            }

            $Hold=0;

            $discTaxx=request('Total_Price') * (1/100) ;




            SalesOrder::where('id',request('order_id'))->update(['RecivedOrder'=>1,'RecivedOrderTime'=>date("h:i:s a", time())]);
            $Or=SalesOrder::find(request('order_id'));



            $ID = DB::table('sales')->insertGetId(
                array(


                    'Date' => request('Date'),
                    'Draw' => request('Draw'),
                    'Payment_Method' => request('Payment_Method'),
                    'Status' => request('Status'),
                    'DiscountTax' => $discTaxx,
                    'Later_Collection' => $col,
                    'Time' => date("h:i:s a", time()),
                    'Branch' => $BRAAA,
                    'CustomerGroup' => $CUSTGROP,
                    'Refernce_Number' => request('Refernce_Number'),
                    'Note' => request('Note'),
                    'Product_Numbers' => request('Product_Numbers'),
                    'Total_Qty' => request('Total_Qty'),
                    'Total_Discount' => request('Total_Discount') + request('DiscountBill'),
                    'Total_BF_Taxes' => request('Total_BF_Taxes'),
                    'Total_Taxes' => request('Total_Taxes'),
                    'Total_Price' => request('Total_Price'),
                    'Pay' => $paid,
                    'Safe' => request('Safe'),
                    'Client' => request('Client'),
                    'Delegate' => request('Delegate'),
                    'Executor' => request('Executor'),
                    'Store' => request('Store'),
                    'Coin' => request('Coin'),
                    'Cost_Center' => null,
                    'presenter' => request('presenter'),
                    'annual_interest' => request('annual_interest'),
                    'monthly_installment' => request('monthly_installment'),
                    'Years_Number' => request('Years_Number'),
                    'total' => request('total'),
                    'Quote' => null,
                    'Ship' => null,
                    'Check_Type' => request('Check_Type'),
                    'Client_Address' => request('Client_Address'),
                    'Delivery' => request('Delivery'),
                    'Delivery_Status' =>0,
                    'Due_Date' => request('Due_Date'),
                    'Check_Number' => request('Check_Number'),
                    'Cash' => request('Cash'),
                    'Visa' => request('Visa'),
                    'Sale_Type' => 'POS',
                    'Hold' => 0,
                    'Total_Cost' => request('Total_Cost'),
                    'TaxOnTotal' => request('TaxOnTotal'),
                    'TaxOnTotalType' => request('TaxOnTotalType'),
                    'ProfitTax' => request('ProfitTax'),
                    'Shift_Code' => request('Shift_Code'),
                    'InstallCompany' => request('InstallCompany'),
                    'ContractNumber' => request('ContractNumber'),
                    'PayFees' => request('PayFees'),
                    'ServiceFee' => request('ServiceFee'),
                    'CompanyPrecent' => request('CompanyPrecent'),
                    'SalesOrder' => null,
                    'installment_Num' => request('installment_Num'),
                    'ProfitPrecent' => request('ProfitPrecent'),
                    'Date_First_installment' => request('Date_First_installment'),
                    'User' => $admin->id,
                    'emp' => $admin->emp,

                    'TakeawayStatus' => 0,
                    'TakeawayTime' => null,
                    'Witer' => request('Waiter'),
                    'KitchenEnd' => $Or->KitchenEnd,
                    'KitchenEndTime' => $Or->KitchenEndTime,
                    'RecivedOrder' => $Or->RecivedOrder,
                    'RecivedOrderTime' => $Or->RecivedOrderTime,
                    'Delivery_Status' =>0,
                    'DeliveryTime' => null,
                    'ResturantOrderType' => request('ResturantOrderType'),
                    'Table' => request('Table'),



                )
            );


            $rest=Sales::where('id',$ID)->first();
            $sel=Sales::where('Store',$rest->Store)->count();


            $Sor=Stores::find(request('Store'));
            $SorBil= $Sor->Letter . '' .  $sel ;
            Sales::where('id',$ID)->update(['Store_Code'=>$SorBil]);


            $CodeT=$rest->Code  ;
            $CodeS=$rest->Code  ;


            $c= DB::select("SELECT last_value FROM sales_arr_seq");
            $f=array_shift($c);
            $z=end($f);
            $CodeT=$z;
            $CodeS=$z;

            if(!empty(request('Unit'))){

                StoreCountSales::truncate();
                $P_Ar_Name=request('P_Ar_Name');
                $P_En_Name=request('P_En_Name');
                $Unit=request('Unit');
                $P_Code=request('P_Code');
                $Qty=request('Qty');
                $AvQty=request('AvQty');
                $Price=request('Price');
                $Discount=request('Discount');
                $TotalBFTax=request('TotalBFTax');
                $TotalTax=request('TotalTax');
                $PurchTax=request('PurchTax');
                $Total=request('Total');
                $StorePurch=request('StorePurch');
                $Exp_Date=request('Exp_Date');
                $Product=request('Product');
                $VOne=request('VOne');
                $VTwo=request('VTwo');
                $V_Name=request('V_Name');
                $VV_Name=request('VV_Name');
                $Exp_Date=request('Exp_Date');

                $TDiscount=request('TDiscPro');


                $CostPrice=request('CostPrice');

                for($i=0 ; $i < count($Unit) ; $i++){

                    $pp=ProductUnits::where('Product',$Product[$i])->where('Unit',$Unit[$i])->first();
                    $plow=ProductUnits::where('Product',$Product[$i])->where('Rate',1)->first();

                    $uu['Product_Code']=$P_Code[$i];
                    $uu['P_Ar_Name']=$P_Ar_Name[$i];
                    $uu['P_En_Name']=$P_En_Name[$i];
                    $uu['V_Name']=$V_Name[$i];
                    $uu['VV_Name']=$VV_Name[$i];
                    $uu['Original_Qty']=$Qty[$i];
                    $uu['Qty']=$Qty[$i];
                    $uu['AvQty']=$AvQty[$i];
                    $uu['Price']=$Price[$i];
                    $uu['Discount']=$Discount[$i];
                    $uu['Tax']=$PurchTax[$i];
                    $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                    $uu['Total_Tax']=$TotalTax[$i];
                    $uu['Total']=$Total[$i];
                    $uu['Store']=$StorePurch[$i];
                    $uu['Product']=$Product[$i];
                    $uu['Unit']=$Unit[$i];
                    $uu['Exp_Date']=$Exp_Date[$i];
                    $uu['Sales']=$ID;
                    $uu['V1']=$VOne[$i];
                    $uu['V2']=$VTwo[$i];
                    $uu['TDiscount']=$TDiscount[$i];
                    $uu['Date']=request('Date');
                    $uu['Code']=$CodeT;
                    $uu['Refernce_Number']=null;
                    $uu['Safe']=request('Safe');
                    $uu['Client']=request('Client');
                    $uu['Executor']=request('Executor');
                    $uu['Delegate']=request('Delegate');
                    $uu['Coin']=request('Coin');
                    $uu['Ship']=null;
                    $uu['User']=$admin->id;
                    $uu['Cost_Center']=null;
                    $uu['Type']='مبيعات';
                    $uu['CostPrice']=$CostPrice[$i];
                    $SS=Stores::find($StorePurch[$i]);
                    $PSS=Products::find($Product[$i]);
                    $uu['Branch']=$SS->Branch;
                    $uu['Group']=$PSS->Group;
                    $uu['Brand']=$PSS->Brand;
                    $uu['CustomerGroup']=$CUSTGROP;
                    $uu['Status']=request('Status');
                    $uu['Payment_Method']=request('Payment_Method');

                    $Aomla=Coins::find(request('Coin'));
                    $dreba=Taxes::find($PurchTax[$i]);

                    $uu['CoinCode']=$Aomla->Code;

                    if($Aomla->Code == 'EGP'){
                        $uu['CoinRate']=0.00;
                        $uu['CoinPrice']=0.00;
                        $uu['AmountEGP']=$Price[$i];

                    }else{

                        $uu['CoinRate']=$Aomla->Draw;
                        $uu['CoinPrice']=$Price[$i];
                        $uu['AmountEGP']=$Aomla->Draw * $Price[$i];
                    }

                    $uu['SalesTotal']=$Price[$i] * $Qty[$i] ;
                    $uu['DiscountAmount']=$Discount[$i] * $Qty[$i] ;
                    $uu['NetTotal']=($Price[$i] * $Qty[$i])  - ($Discount[$i] * $Qty[$i]) ;
                    $NET=($Price[$i] * $Qty[$i])  - ($Discount[$i] * $Qty[$i]);


                    if(!empty($dreba)){
                        $TAM=($dreba->Rate / 100 ) * $NET ;
                        $uu['TaxType']=$dreba->CodeTax ;
                        $uu['TaxSubType']=$dreba->SubType ;
                        $uu['TaxRate']=$dreba->Rate ;
                        $uu['TaxAmount']=($dreba->Rate / 100 ) * $NET ;
                        $uu['TotalBill']=$NET + $TAM ;
                    }



                    ProductSales::create($uu);

                    $prooooo=Products::find($Product[$i]);
                    if(request('Status') == 1){

                        if($prooooo->P_Type == 'Assembly'){

                            $Asembs=AssemblyProducts::where('p_id',$Product[$i])->get();

                            foreach($Asembs as $ass){

                                $Quantity =ProductsQty::
                                where('Store',$StorePurch[$i])
                                    ->where('Product',$ass->Product)
                                    ->where('P_Code',$ass->P_Code)
                                    ->first();



                                if(empty($Quantity)){

                                    $Quantity =ProductsQty::
                                    where('Store',$StorePurch[$i])
                                        ->where('Product',$ass->Product)
                                        ->where('PP_Code',$ass->P_Code)
                                        ->first();

                                    if(empty($Quantity)){

                                        $Quantity =ProductsQty::
                                        where('Store',$StorePurch[$i])
                                            ->where('Product',$ass->Product)
                                            ->where('PPP_Code',$ass->P_Code)
                                            ->first();


                                        if(empty($Quantity)){

                                            $Quantity =ProductsQty::
                                            where('Store',$StorePurch[$i])
                                                ->where('Product',$ass->Product)
                                                ->where('PPPP_Code',$ass->P_Code)
                                                ->first();

                                        }



                                    }






                                }





                                if(!empty($Quantity)){

                                    $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();

                                    $qq= $unit->Rate * ($Qty[$i] * $ass->Qty) ;

                                    $newqty=$Quantity->Qty -  $qq ;


                                    $prooooo=Products::find($Product[$i]);

                                    $plow=ProductUnits::where('Product',$ass->Product)->where('Rate',1)->first();
                                    $pp=ProductUnits::where('Product',$ass->Product)->where('Unit',$ass->Unit)->first();

                                    $purchs=ProductsPurchases::where('Product',$ass->Product)->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('Total_Bf_Tax');

                                    $countPurchs=ProductsPurchases::where('Product',$ass->Product)->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('SmallQty');


                                    $storesTransfer=ProductsStoresTransfers::where('Product',$ass->Product)->where('SmallCode',$plow->Barcode)->where('To_Store',$StorePurch[$i])->get()->sum('Total');

                                    $storesTransferCount=ProductsStoresTransfers::where('Product',$ass->Product)->where('SmallCode',$plow->Barcode)->where('To_Store',$StorePurch[$i])->get()->sum('SmallTrans_Qty');

                                    $purchsStart=ProductsStartPeriods::where('Product',$ass->Product)->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('Total');

                                    $countStart=ProductsStartPeriods::where('Product',$ass->Product)->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('SmallQty');

                                    $OUTCOME=OutcomManufacturingModel::where('Product',$ass->Product)->where('Store',$StorePurch[$i])->where('SmallCode',$plow->Barcode)->get()->sum('Cost');

                                    $countOUTCOME=OutcomManufacturingModel::where('Product',$ass->Product)->where('Store',$StorePurch[$i])->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');


                                    $Collect=$purchs + $purchsStart + $storesTransfer + $OUTCOME;
                                    $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;

                                    if($CollectCount != 0){
                                        $ty= $Collect /  $CollectCount ;
                                    }else{

                                        $ty= $Collect;
                                    }


                                    if($ty != 0){
                                        $in=0;
                                        $out=$qq * $ty ;
                                        $current=$newqty * $ty ;
                                    }else{

                                        $in=0;
                                        $out=$qq * 1;
                                        $current=$newqty * 1;

                                    }
                                    $cur=$newqty * $ty ;
                                    ProductsQty::where('id',$Quantity->id)->update(['Qty'=>$newqty,'Price'=>$ty , 'TotalCost'=>$cur]);

                                    $move['Date']=date('Y-m-d');
                                    $move['Type']='مبيعات';
                                    $move['TypeEn']='Sales';
                                    $move['Bill_Num']=request('Code');
                                    $move['Incom']=0;
                                    $move['Outcom']=$qq;
                                    $move['Current']=abs($newqty);
                                    $move['CostIn']=number_format((float)abs($in), 2, '.', '');
                                    $move['CostOut']=number_format((float)abs($out), 2, '.', '');
                                    $move['CostCurrent']=number_format((float)abs($current), 2, '.', '');
                                    $move['P_Ar_Name']=$P_Ar_Name[$i];
                                    $move['P_En_Name']=$P_En_Name[$i];
                                    $move['P_Code']=$P_Code[$i];
                                    $move['Unit']=$Unit[$i];
                                    $move['QTY']=$Qty[$i];
                                    $move['Group']=$prooooo->Group;
                                    $move['Store']=$StorePurch[$i];
                                    $move['Product']=$Product[$i];
                                    $move['V1']=$VOne[$i];
                                    $move['V2']=$VTwo[$i];
                                    $move['User']=$admin->id;
                                    $Sro=Stores::find($StorePurch[$i]);
                                    $move['Brand']=$prooooo->Brand;
                                    $move['Safe']=request('Safe');
                                    $move['Branch']=$Sro->Branch;
                                    $move['SalePrice']=$Price[$i];
                                    $move['ProductPrice']=$pp->Price;
                                    $move['Delegate']=request('Delegate');
                                    $move['Payment_Method']=request('Payment_Method');
                                    ProductMoves::create($move);


                                }

                            }

                        }elseif($prooooo->P_Type == 'Service'){

                        }else{

                            $Quantity =ProductsQty::
                            where('Store',$StorePurch[$i])
                                ->where('Product',$Product[$i])
                                ->where('P_Code',$P_Code[$i])
                                ->first();

                            if(empty($Quantity)){

                                $Quantity =ProductsQty::
                                where('Store',$StorePurch[$i])
                                    ->where('Product',$Product[$i])
                                    ->where('PP_Code',$P_Code[$i])
                                    ->first();

                                if(empty($Quantity)){

                                    $Quantity =ProductsQty::
                                    where('Store',$StorePurch[$i])
                                        ->where('Product',$Product[$i])
                                        ->where('PPP_Code',$P_Code[$i])
                                        ->first();


                                    if(empty($Quantity)){

                                        $Quantity =ProductsQty::
                                        where('Store',$StorePurch[$i])
                                            ->where('Product',$Product[$i])
                                            ->where('PPPP_Code',$P_Code[$i])
                                            ->first();

                                    }
                                }
                            }


                            if(!empty($Quantity)){
                                $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();

                                $qq= $unit->Rate * $Qty[$i] ;

                                $newqty=$Quantity->Qty -  $qq ;


                                $prooooo=Products::find($Product[$i]);

                                $plow=ProductUnits::where('Product',$Product[$i])->where('Rate',1)->first();
                                $pp=ProductUnits::where('Product',$Product[$i])->where('Unit',$Unit[$i])->first();

                                $purchs=ProductsPurchases::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('Total_Bf_Tax');
                                $countPurchs=ProductsPurchases::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('SmallQty');

                                $purchsStart=ProductsStartPeriods::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('Total');

                                $countStart=ProductsStartPeriods::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('SmallQty');
                                $storesTransfer=ProductsStoresTransfers::where('Product',$Product[$i])->where('SmallCode',$P_Code[$i])->where('To_Store',$StorePurch[$i])->get()->sum('Total');

                                $storesTransferCount=ProductsStoresTransfers::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('To_Store',$StorePurch[$i])->get()->sum('SmallTrans_Qty');


                                $OUTCOME=OutcomManufacturingModel::where('Product',$Product[$i])->where('Store',$StorePurch[$i])->where('SmallCode',$plow->Barcode)->get()->sum('Cost');

                                $countOUTCOME=OutcomManufacturingModel::where('Product',$Product[$i])->where('Store',$StorePurch[$i])->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');


                                $Collect=$purchs + $purchsStart + $storesTransfer + $OUTCOME;
                                $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;

                                if($CollectCount != 0){
                                    $ty= $Collect /  $CollectCount ;
                                }else{

                                    $ty= $Collect;
                                }



                                if($ty != 0){
                                    $in=0;
                                    $out=$qq * $ty ;
                                    $current=$newqty * $ty ;
                                }else{

                                    $in=0;
                                    $out=$qq * 1;
                                    $current=$newqty * 1;

                                }
                                $cur=$newqty * $ty ;
                                ProductsQty::where('id',$Quantity->id)->update(['Qty'=>$newqty,'Price'=>$ty , 'TotalCost'=>$cur]);
                                $move['Date']=date('Y-m-d');
                                $move['Type']='مبيعات';
                                $move['TypeEn']='Sales';
                                $move['Bill_Num']=request('Code');
                                $move['Incom']=0;
                                $move['Outcom']=$qq;
                                $move['Current']=abs($newqty);
                                $move['CostIn']=number_format((float)abs($in), 2, '.', '');
                                $move['CostOut']=number_format((float)abs($out), 2, '.', '');
                                $move['CostCurrent']=number_format((float)abs($current), 2, '.', '');
                                $move['P_Ar_Name']=$P_Ar_Name[$i];
                                $move['P_En_Name']=$P_En_Name[$i];
                                $move['P_Code']=$P_Code[$i];
                                $move['Unit']=$Unit[$i];
                                $move['QTY']=$Qty[$i];

                                $move['Group']=$prooooo->Group;
                                $move['Store']=$StorePurch[$i];
                                $move['Product']=$Product[$i];
                                $move['V1']=$VOne[$i];
                                $move['V2']=$VTwo[$i];
                                $move['User']=$admin->id;
                                $Sro=Stores::find($StorePurch[$i]);
                                $move['Brand']=$prooooo->Brand;
                                $move['Safe']=request('Safe');
                                $move['Branch']=$Sro->Branch;
                                $move['SalePrice']=$Price[$i];
                                $move['ProductPrice']=$pp->Price;
                                $move['Delegate']=request('Delegate');
                                $move['Payment_Method']=request('Payment_Method');
                                ProductMoves::create($move);


                            }

                        }

                    }

                    $plow=ProductUnits::where('Product',$Product[$i])->where('Rate',1)->first();
                    $pp=ProductUnits::where('Product',$Product[$i])->where('Unit',$Unit[$i])->first();

                    $purchs=ProductsPurchases::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('Total_Bf_Tax');
                    $countPurchs=ProductsPurchases::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('SmallQty');

                    $purchsStart=ProductsStartPeriods::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('Total');

                    $countStart=ProductsStartPeriods::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('Store',$StorePurch[$i])->get()->sum('SmallQty');
                    $storesTransfer=ProductsStoresTransfers::where('Product',$Product[$i])->where('SmallCode',$P_Code[$i])->where('To_Store',$StorePurch[$i])->get()->sum('Total');

                    $storesTransferCount=ProductsStoresTransfers::where('Product',$Product[$i])->where('SmallCode',$plow->Barcode)->where('To_Store',$StorePurch[$i])->get()->sum('SmallTrans_Qty');


                    $OUTCOME=OutcomManufacturingModel::where('Product',$Product[$i])->where('Store',$StorePurch[$i])->where('SmallCode',$plow->Barcode)->get()->sum('Cost');

                    $countOUTCOME=OutcomManufacturingModel::where('Product',$Product[$i])->where('Store',$StorePurch[$i])->where('SmallCode',$plow->Barcode)->get()->sum('SmallQty');

                    $Collect=$purchs + $purchsStart + $storesTransfer + $OUTCOME;
                    $CollectCount=$countPurchs + $countStart + $storesTransferCount + $countOUTCOME ;





                    if(!empty($V_Name[$i]) and !empty($VV_Name[$i]))  {
                        $rows=ProductsQty::
                        where('P_Ar_Name',$P_Ar_Name[$i])
                            ->where('P_En_Name',$P_En_Name[$i])
                            ->where('V_Name',$V_Name[$i])
                            ->where('VV_Name',$VV_Name[$i])
                            ->where('P_Code', $P_Code[$i])
                            ->where('Store',$StorePurch[$i])
                            ->first();
                    }elseif(!empty($V_Name[$i]) and empty($VV_Name[$i])){
                        $rows=ProductsQty::
                        where('P_Ar_Name',$P_Ar_Name[$i])
                            ->where('P_En_Name',$P_En_Name[$i])
                            ->where('V_Name',$V_Name[$i])
                            ->where('P_Code', $P_Code[$i])
                            ->where('Store',$StorePurch[$i])
                            ->first();

                    }elseif(empty($V_Name[$i]) and empty($VV_Name[$i])){
                        $rows=ProductsQty::
                        where('P_Ar_Name',$P_Ar_Name[$i])
                            ->where('P_En_Name',$P_En_Name[$i])
                            ->where('P_Code', $P_Code[$i])
                            ->where('Store',$StorePurch[$i])
                            ->first();


                    }

                    $Coste=0;



                    $ppro =ProductsQty::
                    where('Store',$StorePurch[$i])
                        ->where('Product',$Product[$i])
                        ->where('P_Code',$P_Code[$i])
                        ->first();

                    if(empty($ppro)){

                        $ppro =ProductsQty::
                        where('Store',$StorePurch[$i])
                            ->where('Product',$Product[$i])
                            ->where('PP_Code',$P_Code[$i])
                            ->first();

                        if(empty($ppro)){

                            $ppro =ProductsQty::
                            where('Store',$StorePurch[$i])
                                ->where('Product',$Product[$i])
                                ->where('PPP_Code',$P_Code[$i])
                                ->first();


                            if(empty($ppro)){

                                $ppro =ProductsQty::
                                where('Store',$StorePurch[$i])
                                    ->where('Product',$Product[$i])
                                    ->where('PPPP_Code',$P_Code[$i])
                                    ->first();

                            }
                        }
                    }





                    if($prooooo->P_Type != 'Service'){
                        if(!empty($ppro->Original)){

                            if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME) ){




                                if($CollectCount != 0){
                                    $Averagee =$Collect /  $CollectCount;
                                    $Coste += abs($Averagee) * $Qty[$i] ;
                                }else{

                                    if($ppro->Original == null){

                                        $Averagee =$Price[$i] ;
                                        $Coste += $Averagee * $Qty[$i] ;
                                    }else{
                                        $Averagee =0 ;
                                        $Coste += $Averagee * $Qty[$i] ;

                                    }
                                }

                            }else{

                                if($ppro->Original == null){

                                    $Averagee =$Price[$i] ;
                                    $Coste += $Averagee * $Qty[$i] ;
                                }else{
                                    $Averagee =0 ;
                                    $Coste += $Averagee * $Qty[$i] ;

                                }



                            }

                            if($prooooo->P_Type != 'Service'){
                                if(request('Status') == 1){

                                    $Mkhazns=StoreCountSales::all();

                                    if(count($Mkhazns) == 0){

                                        if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME) ){

                                            if($CollectCount != 0){
                                                $Average =$Collect /  $CollectCount;
                                                $Cost = abs($Average) * $Qty[$i] ;

                                            }else{


                                                if($ppro->Original == null){

                                                    $Average = $Price[$i] ;
                                                    $Cost = $Average * $Qty[$i] ;
                                                }else{
                                                    $Average = 0 ;
                                                    $Cost = $Average * $Qty[$i] ;

                                                }




                                            }

                                            $s['Total']=$Cost;
                                        }else{

                                            if($ppro->Original == null){

                                                $Average = $Price[$i] ;
                                                $Cost = $Average * $Qty[$i] ;
                                            }else{
                                                $Average = 0 ;
                                                $Cost = $Average * $Qty[$i] ;

                                            }

                                            $s['Total']=$Cost;
                                        }


                                        $s['Store']=$StorePurch[$i];
                                        $s['Tax']=$PurchTax[$i];
                                        StoreCountSales::create($s);

                                    }else{


                                        $m=StoreCountSales::where('Store',$StorePurch[$i])->first();

                                        if(!empty($m)){

                                            if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME) ){

                                                if($CollectCount != 0){
                                                    $Average =$Collect /  $CollectCount;
                                                    $Cost = abs($Average) * $Qty[$i] ;

                                                }else{

                                                    if($ppro->Original == null){

                                                        $Average = $Price[$i] ;
                                                        $Cost = $Average * $Qty[$i] ;
                                                    }else{
                                                        $Average = 0 ;
                                                        $Cost = $Average * $Qty[$i] ;

                                                    }

                                                }
                                                $newTot=$m->Total + $Cost ;
                                            }else{

                                                if($ppro->Original == null){

                                                    $Average = $Price[$i] ;
                                                    $Cost = $Average * $Qty[$i] ;
                                                }else{
                                                    $Average = 0 ;
                                                    $Cost = $Average * $Qty[$i] ;

                                                }

                                                $newTot=$m->Total + $Cost ;
                                            }


                                            StoreCountSales::where('id',$m->id)->update(['Total'=>$newTot]);

                                        }else{

                                            if(!empty($purchs) or !empty($purchsStart) or !empty($storesTransfer) or !empty($OUTCOME) ){

                                                if($CollectCount != 0){
                                                    $Average =$Collect /  $CollectCount;
                                                    $Cost = abs($Average) * $Qty[$i] ;

                                                }else{

                                                    if($ppro->Original == null){

                                                        $Average = $Price[$i] ;
                                                        $Cost = $Average * $Qty[$i] ;
                                                    }else{
                                                        $Average = 0 ;
                                                        $Cost = $Average * $Qty[$i] ;

                                                    }

                                                }
                                                $s['Total']=$Cost;
                                            }else{

                                                if($ppro->Original == null){

                                                    $Average = $Price[$i] ;
                                                    $Cost = $Average * $Qty[$i] ;
                                                }else{
                                                    $Average = 0 ;
                                                    $Cost = $Average * $Qty[$i] ;

                                                }

                                                $s['Total']=$Cost;
                                            }
                                            $s['Store']=$StorePurch[$i];
                                            $s['Tax']=$PurchTax[$i];
                                            StoreCountSales::create($s);

                                        }

                                    }

                                }
                            }else{

                                $Mkhazns=StoreCountSales::all();
                                if(count($Mkhazns) == 0){

                                    $s['Total']=0;
                                    $s['Store']=$StorePurch[$i];
                                    $s['Tax']=$PurchTax[$i];
                                    StoreCountSales::create($s);

                                }else{
                                    $m=StoreCountSales::where('Store',$StorePurch[$i])->first();

                                    if(!empty($m)){

                                        $newTot=$m->Total + 0 ;
                                        StoreCountSales::where('id',$m->id)->update(['Total'=>$newTot]);

                                    }else{

                                        $s['Total']=0;
                                        $s['Store']=$StorePurch[$i];
                                        $s['Tax']=$PurchTax[$i];
                                        StoreCountSales::create($s);


                                    }

                                }



                            }
                        }else{

                            $Mkhazns=StoreCountSales::all();
                            if(count($Mkhazns) == 0){

                                $s['Total']=0;
                                $s['Store']=$StorePurch[$i];
                                $s['Tax']=$PurchTax[$i];
                                StoreCountSales::create($s);

                            }else{
                                $m=StoreCountSales::where('Store',$StorePurch[$i])->first();

                                if(!empty($m)){

                                    $newTot=$m->Total + 0 ;
                                    StoreCountSales::where('id',$m->id)->update(['Total'=>$newTot]);

                                }else{

                                    $s['Total']=0;
                                    $s['Store']=$StorePurch[$i];
                                    $s['Tax']=$PurchTax[$i];
                                    StoreCountSales::create($s);


                                }

                            }



                        }


                    }else{


                        $Mkhazns=StoreCountSales::all();
                        if(count($Mkhazns) == 0){

                            $s['Total']=0;
                            $s['Store']=$StorePurch[$i];
                            $s['Tax']=$PurchTax[$i];
                            StoreCountSales::create($s);

                        }else{
                            $m=StoreCountSales::where('Store',$StorePurch[$i])->first();

                            if(!empty($m)){

                                $newTot=$m->Total + 0 ;
                                StoreCountSales::where('id',$m->id)->update(['Total'=>$newTot]);

                            }else{

                                $s['Total']=0;
                                $s['Store']=$StorePurch[$i];
                                $s['Tax']=$PurchTax[$i];
                                StoreCountSales::create($s);


                            }

                        }


                    }

                }
            }

            if($Hold == 0){

                $SHIFT=Shifts::where('Code',request('Shift_Code'))->first();
                $RESIDUAL=( request('DiscountBill') + request('Total_Discount') ) ;


                if(request('Payment_Method') == 'Cash'){

                    $cash=request('Total_Price') + request('Total_Taxes') - $RESIDUAL;
                    $visa=0;
                    $later=0;
                }elseif(request('Payment_Method') == 'Later'){
                    $cash=0;
                    $visa=0;
                    $later=$paid + request('Total_Taxes') - $RESIDUAL;
                }elseif(request('Payment_Method') == 'Installment'){
                    $cash=0;
                    $visa=0;
                    $later=$paid + request('Total_Taxes') - $RESIDUAL;

                }elseif(request('Payment_Method') == 'Check'){

                    $cash=0;
                    $visa=0;
                    $later=$paid + request('Total_Taxes') - $RESIDUAL;
                }elseif(request('Payment_Method') == 'Cash_Visa'){
                    $cash=request('Cash') + request('Total_Taxes') - $RESIDUAL;
                    $visa=request('Visa');
                    $later=0;

                }elseif(request('Payment_Method') == 'Cash_Collection'){
                    $cash=request('Total_Price') + request('Total_Taxes') - $RESIDUAL;
                    $visa=0;
                    $later=0;

                }elseif(request('Payment_Method') == 'Delivery'){
                    $cash=0;
                    $visa=0;
                    $later=$paid + request('Total_Taxes') - $RESIDUAL;

                }elseif(request('Payment_Method') == 'InstallmentCompanies'){

                    $cash=request('Total_Price') + request('Total_Taxes') - $RESIDUAL;
                    $visa=0;
                    $later=0;
                }


                $tt=$visa + $cash + $later ;

                $shoft['Total_Cash']=$SHIFT->Total_Cash + $cash;
                $shoft['Total_Later']=$SHIFT->Total_Later + $later;
                $shoft['Total_Visa']=$SHIFT->Total_Visa + $visa;
                $shoft['Total']=$SHIFT->Total +  $tt ;


                Shifts::where('id',$SHIFT->id)->update($shoft);

            }

            if($Hold == 0){

                if(request('Payment_Method') == 'Cash'){

                    if(request('DiscountBill') != 0 or request('Total_Discount') != 0){
                        $RESIDUAL=( request('DiscountBill') + request('Total_Discount') ) ;
                        $RESIDUALSSSS= request('Total_Price') - ( request('DiscountBill') + request('Total_Discount') ) ;

                        if(request('Total_Taxes') != 0){



                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Pay') + $RESIDUAL;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Pay') + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Pay') + $RESIDUAL);
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Pay');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Pay');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Pay');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Total_Price'));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=(request('Pay') + $RESIDUAL);
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=(request('Pay') + $RESIDUAL);
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Pay') + $RESIDUAL);
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }


                        }else{



                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );


                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=(request('Pay') + $RESIDUAL);
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=(request('Pay') + $RESIDUAL);
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Pay') + $RESIDUAL);
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Pay');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Pay');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Pay'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price');
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=(request('Pay') + $RESIDUAL);
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=(request('Pay') + $RESIDUAL);
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Pay') + $RESIDUAL);
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }

                    }else{

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price') + request('Total_Taxes'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price') + request('Total_Taxes'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (round(request('Total_Price')));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price') + request('Total_Taxes'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }

                        }else{

                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }

                    }

                }elseif(request('Payment_Method') == 'Later' or request('Payment_Method') == 'Installment'){

                    if(request('DiscountBill') == 0 or request('Total_Discount') != 0){

                        if(request('Total_Taxes') != 0){

                            if(request('Status') == 1){
                                $NewMkhazns=StoreCountSales::all();


                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => $paid,
                                        'Total_Creditor' => $paid,
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);




                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( round(request('Total_Price')));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                                if($paid != 0 or $paid > 0){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price') + request('Total_Taxes'));
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }else{

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=(request('Total_Price') + request('Total_Taxes')) - $RESIDUAL;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=(request('Total_Price') + request('Total_Taxes')) - $RESIDUAL;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * round((request('Total_Price') + request('Total_Taxes')) - $RESIDUAL);
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);
                                }

                                $RESIDUAL=request('DiscountBill') + request('Total_Discount') ;


                                if($paid != 0 or $paid > 0){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$paid + $RESIDUAL;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$paid + $RESIDUAL;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * ($paid + $RESIDUAL);
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$paid;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Safe');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$paid;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $paid;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Safe');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$RESIDUAL;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=50;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$RESIDUAL;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=50;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }else{


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$RESIDUAL;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=50;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$RESIDUAL;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=50;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }




                            }

                        }else{

                            if(request('Status') == 1){
                                $NewMkhazns=StoreCountSales::all();
                                $RESIDUAL=request('DiscountBill') + request('Total_Discount') ;

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => $paid,
                                        'Total_Creditor' => $paid,
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);




                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                if($paid != 0 or $paid > 0){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('Total_Price');
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('Total_Price');
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price'));
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }else{

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=request('Total_Price') - $RESIDUAL;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=request('Total_Price') -$RESIDUAL ;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price') - $RESIDUAL);
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);
                                }

                                if($paid != 0 or $paid > 0){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=($paid + $RESIDUAL);
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=($paid + $RESIDUAL);
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * ($paid + $RESIDUAL);
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=abs($paid);
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Safe');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=abs($paid);
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * abs($paid);
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Safe');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$RESIDUAL;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=50;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$RESIDUAL;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=50;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }else{



                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$RESIDUAL;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=50;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$RESIDUAL;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=50;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);
                                }




                            }

                        }

                    }else{

                        $RESIDUAL= ( request('DiscountBill') + request('Total_Discount') ) ;
                        $RESIDUALSSSS= request('Total_Price') - ( request('DiscountBill') + request('Total_Discount') ) ;


                        if(request('Total_Taxes') != 0){

                            if(request('Status') == 1){
                                $NewMkhazns=StoreCountSales::all();


                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => $paid,
                                        'Total_Creditor' => $paid,
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);




                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (round(request('Total_Price')));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                if($paid != 0 or $paid > 0){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=abs($paid);
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=abs($paid);
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * abs($paid);
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=abs($paid);
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Safe');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=abs($paid);
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * abs($paid);
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Safe');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }




                            }
                        }else{

                            if(request('Status') == 1){
                                $NewMkhazns=StoreCountSales::all();


                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => $paid,
                                        'Total_Creditor' => $paid,
                                        'Note' => request('Note'),

                                    )
                                );



                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);




                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUALSSSS;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUALSSSS;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUALSSSS;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                if($paid != 0 or $paid > 0){
                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=abs($paid);
                                    $PRODUCTSS['Account']=request('Client');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=abs($paid);
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * abs($paid);
                                    $Gen['Account']=request('Client');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=abs($paid);
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=request('Safe');
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=abs($paid);
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * abs($paid);
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=request('Safe');
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }




                            }
                        }
                    }


                }elseif(request('Payment_Method') == 'Check'){
                    $RESIDUAL= ( request('DiscountBill') + request('Total_Discount') ) ;

                    if(request('DiscountBill') == 0 or request('Total_Discount') != 0){

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $ress=IncomChecks::orderBy('id','desc')->first();

                                if(!empty($ress->Code)){

                                    $Codee=$ress->Code + 1 ;
                                }else{
                                    $Codee=1;

                                }


                                $checkk['Code'] =$Codee;
                                $checkk['Date'] = request('Date');
                                $checkk['Draw'] = request('Draw');
                                $checkk['Note'] = request('Note');
                                $checkk['Check_Num'] = request('Check_Number');
                                $checkk['Due_Date'] = request('Due_Date');
                                $checkk['Amount'] = request('Total_Price');
                                $checkk['Status'] =0;
                                $checkk['Reason'] =null;
                                $checkk['Check_Type'] = request('Check_Type');
                                $checkk['Coin'] = request('Coin');
                                $checkk['Cost_Center'] = request('Cost_Center');
                                $checkk['Account'] = request('Client');
                                $checkk['Bank'] = request('Safe');
                                $checkk['Arrest_Account'] =35;
                                $checkk['Bene_Account'] =null;
                                $checkk['User'] =$admin->id;

                                IncomChecks::create($checkk);




                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price') + request('Total_Taxes'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=(request('Total_Price') + (request('Total_Taxes') - $RESIDUAL));
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=35;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=(request('Total_Price') + (request('Total_Taxes') - $RESIDUAL));
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Total_Price') + (request('Total_Taxes') - $RESIDUAL));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=35;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (round(request('Total_Price')));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }




                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price') + request('Total_Taxes'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }

                        }else{
                            if(request('Status') == 1){

                                $ress=IncomChecks::orderBy('id','desc')->first();

                                if(!empty($ress->Code)){

                                    $Codee=$ress->Code + 1 ;
                                }else{
                                    $Codee=1;

                                }


                                $checkk['Code'] =$Codee;
                                $checkk['Date'] = request('Date');
                                $checkk['Draw'] = request('Draw');
                                $checkk['Note'] = request('Note');
                                $checkk['Check_Num'] = request('Check_Number');
                                $checkk['Due_Date'] = request('Due_Date');
                                $checkk['Amount'] = request('Total_Price');
                                $checkk['Status'] =0;
                                $checkk['Reason'] =null;
                                $checkk['Check_Type'] = request('Check_Type');
                                $checkk['Coin'] = request('Coin');
                                $checkk['Cost_Center'] = request('Cost_Center');
                                $checkk['Account'] = request('Client');
                                $checkk['Bank'] = request('Safe');
                                $checkk['Arrest_Account'] =35;
                                $checkk['Bene_Account'] =null;
                                $checkk['User'] =$admin->id;

                                IncomChecks::create($checkk);




                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') - $RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=35;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') - $RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price') - $RESIDUAL);
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=35;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }

                    }else{

                        $RESIDUAL= ( request('DiscountBill') + request('Total_Discount') ) ;
                        $RESIDUALSSSS= round(request('Total_Price')) - ( request('DiscountBill') + request('Total_Discount') ) ;
                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $ress=IncomChecks::orderBy('id','desc')->first();

                                if(!empty($ress->Code)){

                                    $Codee=$ress->Code + 1 ;
                                }else{
                                    $Codee=1;

                                }


                                $checkk['Code'] =$Codee;
                                $checkk['Date'] = request('Date');
                                $checkk['Draw'] = request('Draw');
                                $checkk['Note'] = request('Note');
                                $checkk['Check_Num'] = request('Check_Number');
                                $checkk['Due_Date'] = request('Due_Date');
                                $checkk['Amount'] = request('Total_Price');
                                $checkk['Status'] =0;
                                $checkk['Reason'] =null;
                                $checkk['Check_Type'] = request('Check_Type');
                                $checkk['Coin'] = request('Coin');
                                $checkk['Cost_Center'] = request('Cost_Center');
                                $checkk['Account'] = request('Client');
                                $checkk['Bank'] = request('Safe');
                                $checkk['Arrest_Account'] =35;
                                $checkk['Bene_Account'] =null;
                                $checkk['User'] =$admin->id;

                                IncomChecks::create($checkk);




                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=35;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=35;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') - request('Total_Taxes');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') - request('Total_Taxes');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Total_Price') - request('Total_Taxes') );
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUALSSSS;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUALSSSS;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUALSSSS;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }

                        }else{

                            if(request('Status') == 1){

                                $ress=IncomChecks::orderBy('id','desc')->first();

                                if(!empty($ress->Code)){

                                    $Codee=$ress->Code + 1 ;
                                }else{
                                    $Codee=1;

                                }


                                $checkk['Code'] =$Codee;
                                $checkk['Date'] = request('Date');
                                $checkk['Draw'] = request('Draw');
                                $checkk['Note'] = request('Note');
                                $checkk['Check_Num'] = request('Check_Number');
                                $checkk['Due_Date'] = request('Due_Date');
                                $checkk['Amount'] = request('Total_Price');
                                $checkk['Status'] =0;
                                $checkk['Reason'] =null;
                                $checkk['Check_Type'] = request('Check_Type');
                                $checkk['Coin'] = request('Coin');
                                $checkk['Cost_Center'] = request('Cost_Center');
                                $checkk['Account'] = request('Client');
                                $checkk['Bank'] = request('Safe');
                                $checkk['Arrest_Account'] =35;
                                $checkk['Bene_Account'] =null;
                                $checkk['User'] =$admin->id;

                                IncomChecks::create($checkk);




                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * round(request('Total_Price'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=35;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * round(request('Total_Price'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=35;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price');
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUALSSSS;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUALSSSS;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUALSSSS;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);





                            }

                        }
                    }

                }elseif(request('Payment_Method') == 'Cash_Visa'){


                    if(request('DiscountBill') != 0 or request('Total_Discount') != 0){
                        $RESIDUAL=( request('DiscountBill') + request('Total_Discount') ) ;
                        $RESIDUALSSSS= request('Total_Price') - ( request('DiscountBill') + request('Total_Discount') ) ;

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Cash') + request('Visa') + $RESIDUAL;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Cash') + request('Visa') + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Cash') + request('Visa') + $RESIDUAL);
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Cash');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Cash');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Cash');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Visa');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('SafeVisa');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Visa');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Visa');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('SafeVisa');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( request('Total_Price') );
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=(request('Cash') + request('Visa') + $RESIDUAL);
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=(request('Cash') + request('Visa') + $RESIDUAL);
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Cash') + request('Visa') + $RESIDUAL);
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }else{
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Cash') + request('Visa') + $RESIDUAL;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Cash') + request('Visa') + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Cash') + request('Visa') + $RESIDUAL);
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Cash');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Cash');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Cash');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Visa');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('SafeVisa');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Visa');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Visa');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('SafeVisa');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);



                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price');
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }



                    }else{

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Cash') + request('Visa');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Cash') + request('Visa');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Cash') + request('Visa'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Cash');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Cash');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Cash');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Visa');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('SafeVisa');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Visa');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Visa');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('SafeVisa');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( request('Total_Price'));
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=(request('Cash') + request('Visa'));
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=(request('Cash') + request('Visa'));
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Cash') + request('Visa'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }else{
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Cash') + request('Visa');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Cash') + request('Visa');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Cash') + request('Visa'));
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Cash');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Cash');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Cash');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Visa');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('SafeVisa');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Visa');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Visa');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('SafeVisa');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price');
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }

                    }
                }elseif(request('Payment_Method') == 'Cash_Collection'){

                    if(request('DiscountBill') != 0 or request('Total_Discount') != 0){
                        $RESIDUAL=( request('DiscountBill') + request('Total_Discount') ) ;
                        $RESIDUALSSSS= request('Total_Price') - ( request('DiscountBill') + request('Total_Discount') ) ;

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') + $RESIDUAL;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Total_Price') + $RESIDUAL);
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( request('Total_Price') );
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + $RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + $RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Total_Price') + $RESIDUAL);
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }

                        }else{
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') + $RESIDUAL;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Total_Price') + $RESIDUAL);
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=$RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=50;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=$RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * $RESIDUAL;
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=50;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') + $RESIDUAL;
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + $RESIDUAL;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( request('Total_Price') + $RESIDUAL );
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + $RESIDUAL;
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + $RESIDUAL;
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Total_Price') + $RESIDUAL);
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }

                    }else{

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * (request('Total_Price') + request('Total_Taxes') );
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Total_Price') + request('Total_Taxes'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * ( request('Total_Price') );
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                foreach($NewMkhazns as $new){

                                    $TTax=Taxes::find($new->Tax);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=request('Total_Taxes');
                                    $PRODUCTSS['Account']=$TTax->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=request('Total_Taxes');
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * request('Total_Taxes');
                                    $Gen['Account']=$TTax->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price') + request('Total_Taxes');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * (request('Total_Price') + request('Total_Taxes'));
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }

                        }else{
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();

                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
                                        'Coin' => request('Coin'),
                                        'Cost_Center' => request('Cost_Center'),
                                        'Total_Debaitor' => request('Total_Price'),
                                        'Total_Creditor' => request('Total_Price'),
                                        'Note' => request('Note'),

                                    )
                                );

                                foreach($NewMkhazns as $new){

                                    $store=Stores::find($new->Store);

                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=0;
                                    $PRODUCTSS['Creditor']=$new->Total;
                                    $PRODUCTSS['Account']=$store->Account;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=0;
                                    $Gen['Creditor']=$new->Total;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * 0;
                                    $Gen['Creditor_Coin']=request('Draw') * $new->Total;
                                    $Gen['Account']=$store->Account;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']=request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);


                                    $PRODUCTSS['Joun_ID']=$JunID;
                                    $PRODUCTSS['Debitor']=$new->Total;
                                    $PRODUCTSS['Creditor']=0;
                                    $PRODUCTSS['Account']=52;
                                    $PRODUCTSS['Statement']=null;


                                    JournalizingDetails::create($PRODUCTSS);

                                    $Gen['Code']=$Code;
                                    $Gen['Code_Type']=$CodeT;
                                    $Gen['Date']=request('Date');
                                    $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                    $Gen['Debitor']=$new->Total;
                                    $Gen['Creditor']=0;
                                    $Gen['Statement']=null;
                                    $Gen['Draw']=request('Draw');
                                    $Gen['Debitor_Coin']= request('Draw') * $new->Total;
                                    $Gen['Creditor_Coin']=request('Draw') * 0;
                                    $Gen['Account']=52;
                                    $Gen['Coin']= request('Coin');
                                    $Gen['Cost_Center']= request('Cost_Center');
                                    $Gen['userr']= $admin->id;

                                    GeneralDaily::create($Gen);

                                }

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price');
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Safe');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Safe');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);

                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=0;
                                $PRODUCTSS['Creditor']=request('Total_Price');
                                $PRODUCTSS['Account']=48;
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=0;
                                $Gen['Creditor']=request('Total_Price');
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * 0;
                                $Gen['Creditor_Coin']=request('Draw') * request('Total_Price');
                                $Gen['Account']=48;
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']=request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);


                                $PRODUCTSS['Joun_ID']=$JunID;
                                $PRODUCTSS['Debitor']=request('Total_Price');
                                $PRODUCTSS['Creditor']=0;
                                $PRODUCTSS['Account']=request('Client');
                                $PRODUCTSS['Statement']=null;


                                JournalizingDetails::create($PRODUCTSS);

                                $Gen['Code']=$Code;
                                $Gen['Code_Type']=$CodeT;
                                $Gen['Date']=request('Date');
                                $Gen['Type']='المبيعات';         $Gen['TypeEn']='Sales';
                                $Gen['Debitor']=request('Total_Price');
                                $Gen['Creditor']=0;
                                $Gen['Statement']=null;
                                $Gen['Draw']=request('Draw');
                                $Gen['Debitor_Coin']= request('Draw') * request('Total_Price');
                                $Gen['Creditor_Coin']=request('Draw') * 0;
                                $Gen['Account']=request('Client');
                                $Gen['Coin']= request('Coin');
                                $Gen['Cost_Center']= request('Cost_Center');
                                $Gen['userr']= $admin->id;

                                GeneralDaily::create($Gen);




                            }
                        }

                    }

                }elseif(request('Payment_Method') == 'Delivery'){


                    $DELEVERYY=Employess::find(request('Delivery'));

                    $Address=Addressses::find(request('Client_Address'));
                    $acc=AcccountingManual::where('Name','تحصيل دليفري')->first();

                    if(request('DiscountBill') != 0 or request('Total_Discount') != 0){
                        $RESIDUAL=( request('DiscountBill') + request('Total_Discount') ) ;
                        $RESIDUALSSSS= request('Total_Price') - ( request('DiscountBill') + request('Total_Discount') ) ;

                        if(request('Total_Taxes') != 0){
                            if(request('Status') == 1){

                                $NewMkhazns=StoreCountSales::all();


                                $res=Journalizing::orderBy('id','desc')->first();

                                if(!empty($res->Code)){

                                    $Code=$res->Code + 1 ;
                                }else{
                                    $Code=1;

                                }

                                $JunID = DB::table('journalizings')->insertGetId(

                                    array(

                                        'Code' => $Code,
                                        'Type' => 'المبيعات',             'TypeEn' => 'Sales',
                                        'Code_Type' => $CodeT,
                                        'Date' => request('Date'),
                                        'Draw' => request('Draw'),
     