<?php

namespace App\Http\Controllers;

use App\Http\Resources\EditDeleteBillReportApiResources;
use App\Http\Resources\Reports\Accounting\AccountBalancesFilterApiResources;
use App\Http\Resources\Reports\Accounting\ChecksReportsApiResources;
use App\Http\Resources\Reports\Accounting\ClientDetailsStatementApiResources;
use App\Http\Resources\Reports\Accounting\ClientVendorBalancesApiResources;
use App\Http\Resources\Reports\Accounting\ClientVendorDebtsApiResources;
use App\Http\Resources\Reports\Accounting\ClientVendorStatementApiResources;
use App\Http\Resources\Reports\Accounting\CustomerDebtRestructuringFilterApiResources;
use App\Http\Resources\Reports\Accounting\ExpensesListFilterApiResources;
use App\Http\Resources\Reports\Accounting\ExpensesReportFilterApiResources;
use App\Http\Resources\Reports\Accounting\Fixed_Assets_ReportFilterApiResources;
use App\Http\Resources\Reports\Accounting\GeneralDailyApiResources;
use App\Http\Resources\Reports\Accounting\IncomListReportFilterApiResources;
use App\Http\Resources\Reports\Accounting\InstallmentReportApiResources;
use App\Http\Resources\Reports\Accounting\InsurancePaperReportFilterApiResources;
use App\Http\Resources\Reports\Accounting\SafesBalancesApiResources;
use App\Http\Resources\Reports\Accounting\SafesTransferReportFilterApiResources;
use App\Http\Resources\Reports\Accounting\TotalExpensesSafesFilterApiResources;
use App\Http\Resources\Reports\Accounting\TrialBalanceFilterApiiResources;
use App\Http\Resources\Reports\Accounting\VendorDebtRestructuringFilterApiResources;
use App\Http\Resources\Reports\Accounting\VendorDebtsApiResources;
use App\Http\Resources\Reports\Accounting\VendorDetailsStatementApiResources;
use App\Http\Resources\Reports\Accounting\VouchersClientStatementDetailsApiResources;
use App\Http\Resources\Reports\CRM\CommentsReportsApiApiResources;
use App\Http\Resources\Reports\CRM\CustomerfollowupReportsApiResources;
use App\Http\Resources\Reports\CRM\CustomerPeriodReportsApiResources;
use App\Http\Resources\Reports\CRM\DelegateVistsReportApiResources;
use App\Http\Resources\Reports\EmpLocationsResources;
use App\Http\Resources\Reports\HR\AttendenceValueReportResources;
use App\Http\Resources\Reports\HR\EmpGoalsApiResources;
use App\Http\Resources\Reports\HR\EmpSalariesApiResources;
use App\Http\Resources\Reports\HR\SalaryPayedApiResources;
use App\Http\Resources\Reports\SupplyChain\AssemblyProQtiesFilterApiResources;
use App\Http\Resources\Reports\SupplyChain\BrandSalesApiResources;
use App\Http\Resources\Reports\SupplyChain\ClientSalesApiResources;
use App\Http\Resources\Reports\SupplyChain\Collection_DelegatesApiResources;
use App\Http\Resources\Reports\SupplyChain\CompareSalesPriceApiResources;
use App\Http\Resources\Reports\SupplyChain\DailyProductsApiResources;
use App\Http\Resources\Reports\SupplyChain\DailyShiftsDetailsApiResources;
use App\Http\Resources\Reports\SupplyChain\DailyShiftsDetailsShiftApiResources;
use App\Http\Resources\Reports\SupplyChain\DelegateSalesDetailsApiResources;
use App\Http\Resources\Reports\SupplyChain\ExceptProductProfitsApiResources;
use App\Http\Resources\Reports\SupplyChain\ExceptProfitsApiResources;
use App\Http\Resources\Reports\SupplyChain\ExpiredProuctsApiResources;
use App\Http\Resources\Reports\SupplyChain\GroupsSalesApiResources;
use App\Http\Resources\Reports\SupplyChain\HoldQtiesReportApiResources;
use App\Http\Resources\Reports\SupplyChain\InventorySerialApiResources;
use App\Http\Resources\Reports\SupplyChain\ItemsMovesApiResources;
use App\Http\Resources\Reports\SupplyChain\MostSalesProductsApiResources;
use App\Http\Resources\Reports\SupplyChain\NetPurchasesFilterApiResources;
use App\Http\Resources\Reports\SupplyChain\NetSalesFilterApiResources;
use App\Http\Resources\Reports\SupplyChain\NewDelegateSalesDetailssApiResources;
use App\Http\Resources\Reports\SupplyChain\ProductOrderLimitApiResources;
use App\Http\Resources\Reports\SupplyChain\ProductProfitsNewApiResources;
use App\Http\Resources\Reports\SupplyChain\ProductSalesGroupsReportApiResources;
use App\Http\Resources\Reports\SupplyChain\ProfitDelegateSalesDetailsApiResources;
use App\Http\Resources\Reports\SupplyChain\ProfitFilterPurchasesApiResources;
use App\Http\Resources\Reports\SupplyChain\ProfitFilterReturnPurchasesApiResources;
use App\Http\Resources\Reports\SupplyChain\ProfitFilterReturnSalesApiResources;
use App\Http\Resources\Reports\SupplyChain\ProfitFilterSalesApiResources;
use App\Http\Resources\Reports\SupplyChain\ProfitSalesProductFilterApiResources;
use App\Http\Resources\Reports\SupplyChain\PurchasesBillsApiResources;
use App\Http\Resources\Reports\SupplyChain\ReportStartPeriodApiResources;
use App\Http\Resources\Reports\SupplyChain\ReturnWithoutBillReportApiResources;
use App\Http\Resources\Reports\SupplyChain\SalesBillsApiResources;
use App\Http\Resources\Reports\SupplyChain\SalesCustomersGroupsFilterApiResources;
use App\Http\Resources\Reports\SupplyChain\SalesProsBrandMoreDetailsApiResources;
use App\Http\Resources\Reports\SupplyChain\SalesProsGroupMoreDetailsApiResources;
use App\Http\Resources\Reports\SupplyChain\SettlementsReportsApiResources;
use App\Http\Resources\Reports\SupplyChain\ShiftsDetailsReportPaymentApiResources;
use App\Http\Resources\Reports\SupplyChain\ShiftsDetailsReportReciptApiResources;
use App\Http\Resources\Reports\SupplyChain\ShiftsDetailsReportSalesApiResources;
use App\Http\Resources\Reports\SupplyChain\ShiftsReportApiResources;
use App\Http\Resources\Reports\SupplyChain\StagnantItemsTwoFilterApiResources;
use App\Http\Resources\Reports\SupplyChain\StoresBalancesApiResources;
use App\Http\Resources\Reports\SupplyChain\StoresMovesReportApiResources;
use App\Http\Resources\Reports\SupplyChain\StoresSalesDetailsApiResources;
use App\Http\Resources\Reports\SupplyChain\StoresTransferReportApiResources;
use App\Http\Resources\Reports\SupplyChain\TotalNetPurchasesApiResources;
use App\Http\Resources\Reports\SupplyChain\TotalNetSalesApiResources;
use App\Http\Resources\Reports\SupplyChain\VendorPricesReportApiResources;
use App\Http\Resources\Reports\SupplyChain\VendorPurchasesApiResources;
use App\Http\Resources\Reports\UserLogApiResources;
use App\Http\Resources\StoresCostResources;
use App\Models\AcccountingManual;
use App\Models\Admin;
use App\Models\AllowencesEmp;
use App\Models\Assets;
use App\Models\Borrowa;
use App\Models\Brands;
use App\Models\ChecksTypes;
use App\Models\ClientAccountStatementColumnSechdule;
use App\Models\CommentsClients;
use App\Models\CompanyData;
use App\Models\ComparePricesColumnsSechdule;
use App\Models\Customers;
use App\Models\CustomersGroup;
use App\Models\Deduction;
use App\Models\DepartureEmp;
use App\Models\DiscountsEmp;
use App\Models\EmpInstallmentDetails;
use App\Models\Employess;
use App\Models\EmpRatio;
use App\Models\EmpsProducationPoint;
use App\Models\EmpsProducationQuantity;
use App\Models\Entitlement;
use App\Models\Event;
use App\Models\ExchangeCommissions;
use App\Models\ExpireDateQty;
use App\Models\ExportChecks;
use App\Models\GeneralDaily;
use App\Models\Governrate;
use App\Models\Holidays;
use App\Models\IncomChecks;
use App\Models\InstallCompaniesSalesBillsColumnsSechdule;
use App\Models\InstallmentDates;
use App\Models\InsurancePaper;
use App\Models\ItemsGroups;
use App\Models\ItineraryVisit;
use App\Models\Loan;
use App\Models\PaymentVoucher;
use App\Models\PaymentVoucherDetails;
use App\Models\PaySalary;
use App\Models\ProductMaintaincBill;
use App\Models\ProductMoves;
use App\Models\Products;
use App\Models\ProductSales;
use App\Models\ProductSettlement;
use App\Models\ProductsPurchases;
use App\Models\ProductsQty;
use App\Models\ProductsStartPeriods;
use App\Models\ProductUnits;
use App\Models\Purchases;
use App\Models\ReciptMaintaince;
use App\Models\ReciptVoucher;
use App\Models\ReciptVoucherDetails;
use App\Models\RegOverTime;
use App\Models\ReturnMaintainceBill;
use App\Models\ReturnPurch;
use App\Models\ReturnPurchProducts;
use App\Models\ReturnSales;
use App\Models\ReturnSalesProducts;
use App\Models\ReturnStorsTransfer;
use App\Models\ReturnWithoutBill;
use App\Models\SafeTransfers;
use App\Models\Sales;
use App\Models\SalesBillsColumnsSechdule;
use App\Models\SalesPetrol;
use App\Models\Settlement;
use App\Models\Shifts;
use App\Models\Stores;
use App\Models\StoresMoves;
use App\Models\StorsTransfers;
use App\Models\Ticket;
use App\Models\TicketProducts;
use App\Models\UsersMoves;
use App\Models\VendorAccountStatementColumnSechdule;
use Illuminate\Http\Request;

use App\Http\Resources\UserResources;
use App\Mail\AdminResetPasswordApi;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use App\Traits\GeneralTrait;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Spatie\DbDumper\Databases\PostgreSql;
use Str;
use File;
use DB;

use App\Http\Resources\Reports\AdminOwnerResources;
use App\Http\Resources\Reports\TotalReportResources;
use App\Http\Resources\Reports\CalendarEventResources;

use App\Http\Resources\Reports\HR\AttendenceAndDepartureReportResources;

class OwnerReportApiController extends Controller
{
    use GeneralTrait;

    public function __construct(Request $request) {

        $header =!empty( $request->header('lang')) ? $request->header('lang') : "ar";
        app()->setLocale($header);

    }


//Auth =======================================================================

    //Login
    public function OwnerLoginApi(Request $request){

        try {

            $rules = [
                "email" => "required",
                "password" => "required"

            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $code = $this->returnCodeAccordingToInput($validator);
                return $this->returnValidationError($code, $validator);
            }



            $rememberme = request('rememberme') == 1?true:false;

            if(auth()->guard('admin')->attempt(['email'=>request('email'),'password'=>request('password')],$rememberme)){

                $ad=Admin::where('email',request('email'))->first();

                if($ad->emp != 0){

                    return $this->returnError(trans('admin.This_Acc_Not_Correct_For_Admins'));
                }




                $dataUser=[
                    'screen_ar'=>'تسجيل دخول التطبيق',
                    'screen_en'=>'Login App',
                    'type_ar'=>'تسجيل الدخول',
                    'type_en'=>'Login',
                    'explain_ar'=>request('email'),
                    'explain_en'=>request('email'),
                ];
                $this->UserCustomMoves($dataUser);

                $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                $charactersLength = strlen($characters);
                $randomString = '';
                for ($i = 0; $i < 100 ; $i++) {
                    $randomString .= $characters[rand(0, $charactersLength - 1)];
                }

                $ad=Admin::where('email',request('email'))->first();
                Admin::where('id',$ad->id)->update(['token'=>$randomString]);


                $Admin=Admin::where('email',request('email'))->first();
                $data=AdminOwnerResources::make($Admin);


                return $this->returnData('data', $data);



            }else{

                return $this->returnError(trans('admin.incorrect_information_login'));

            }


        } catch (\Exception $ex) {

            return $this->returnError($ex->getMessage());

        }catch (\Error $ex) {

            return $this->returnError($ex->getMessage());
        }

    }


    //TokenCheck
    public function OwnerTokenCheck(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $Admin=Admin::where('token',$x)->first();
        $data=AdminOwnerResources::make($Admin);

        return $this->returnData('data', $data);
    }


    //Forget Password
    public function Ownerforgotpasswordapi(){
        $admin = Admin::where('email',request('email'))->first();
        if(!empty($admin)){



            if($admin->emp != 0){

                return $this->returnError(trans('admin.This_Acc_Not_Correct_For_Admins'));
            }


            $code=rand(10,10000);
            Admin::where('id',$admin->id)->update(['code'=>$code]);

            Mail::to($admin->email)->send(new AdminResetPasswordApi(['data'=>$admin,'code'=>$code]));


            return $this->returnData('data', ['code'=> $code,'email'=>$admin->email]);



        }else{



            return $this->returnError(trans('admin.WrongEmail'));


        }


    }

    //VerifyCode
    public function OwnerVerifyCode(){
        $admin = Admin::where('email',request('email'))->first();

        if($admin->code == request('code')){



            return $this->returnSuccessMessage(trans('admin.Code_Success'));



        }else{

            return $this->returnError(trans('admin.WrongCode'));
        }


    }

    //ResetPasswordApi
    public function OwnerResetPasswordApi(){


        $admin = Admin::where('email',request('email'))->first();

        Admin::where('id',$admin->id)->update(
            [
                'password'=>bcrypt(request('new_password')),
                'code'=>null
            ]
        );

        return $this->returnSuccessMessage(trans('admin.success_reset'));



    }

    //LogoutApi
    public function OwnerLogoutApi(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();

        Admin::where('id',$admin->id)->update(['token'=>null]);

        return $this->returnSuccessMessage(trans('admin.LogoutSuccess'));


    }

    //UpdateAdminProfile
    public function OwnerUpdateAdminProfile(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();


        $data['phone']=request('phone');
        $data['name']=request('name');

        Admin::where('id',$admin->id)->update($data);

        if(request()->has('old_password')){

            if (Hash::check(request('old_password'), $admin->password)) {
                $data['password']  =bcrypt(request('new_password'));
                Admin::where('id',$admin->id)->update($data);

                return $this->returnSuccessMessage(trans('admin.Updated'));

            }else{



                return $this->returnError(trans('admin.OldPasswordNotCorrect'));

            }
        }

        return $this->returnSuccessMessage(trans('admin.Updated'));


    }


//==========================================================================================

    //Backup
    public function BackUpDB(){

        try {

            $def=CompanyData::orderBy('id','desc')->first();

            $backup_name = $def->Name.'-Rabih-' . date('c')  . '.sql';

            PostgreSql::create()
                ->setDbName(env('DB_DATABASE'))
                ->setUserName(env('DB_USERNAME'))
                ->setPassword(env('DB_PASSWORD'))
                ->dumpToFile($backup_name);

            $Xs = File::files(public_path());
            $backup='';

            foreach($Xs as $x) {
                $needle = "public/";
                $newString = strstr($x, $needle);
                $lastWord = str_replace('public/', '', $newString);

                $lasrString = strstr($lastWord, '.');

                if($lasrString == '.sql') {

                    $backup=asset($lastWord);
                }


            }
            return $this->returnData('data',$backup,trans('admin.Backup_success'));

        } catch (\Exception $ex) {

            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());

        }catch (\Error $ex) {
            DB::rollback();
            return $this->returnError($ex->getMessage().' '.$ex->getLine());
        }


    }


    //CalendarEventApi
    public function CalendarEventApi(Request $request){

        $Months=date("Y-m-d", strtotime("-3 Months"));
        $events = Event::where('End_Date','>=',$Months)->get();
        $data=CalendarEventResources::collection($events);
        return $this->returnData('data', $data);


    }

//EmpLocationsApi
    public function EmpLocationsApi(Request $request){

        $Users=Admin::where('hidden',0)->where('emp','!=',0)->get();
        $data=EmpLocationsResources::collection($Users);
        return $this->returnData('data', $data);


    }



//============================================================================================

//========================================= Reports ===================================================


//Totals
    public function TotalsReportApi(Request $request){

$comp=CompanyData::latest('id')->first();
        $data=TotalReportResources::make($comp);
        return $this->returnData('data', $data);


    }


    // ==============================   HR  ===========================

    //Attendence And Departure Report
    public function AttendenceAndDepartureReportApi(Request $request){

        $from = $request->get('from');
        $to = $request->get('to');
        $emp = $request->get('emp');

        $items =DepartureEmp::whereBetween('Date', [$from, $to])
            ->when(!empty($emp), function ($query) use ($emp) {
                return $query->where('Emp',$emp);

            })
            ->paginate(50);

        $data=AttendenceAndDepartureReportResources::collection($items);

        $x=[
'status'=>200,
'msg'=>trans('admin.Success'),
];
return $data->additional($x) ;



    }

    //Attendence Value Report
    public function AttendenceValueReportApi(Request $request){

        $from = $request->get('from');
        $to = $request->get('to');
        $emp = $request->get('emp');

        $items =Employess::

        when(!empty($emp), function ($query) use ($emp) {
            return $query->where('id',$emp);

        })


            ->paginate(50);


        $data=AttendenceValueReportResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];
        return $data->additional($x) ;



    }

    //Pay Salary Report Api
    public function PaySalaryReportApi(Request $request){


        $Month= $request->get('month');
        $Emp = $request->get('emp');

        $Sal=Employess::find($Emp);
        $x = Borrowa::where("Month",$Month)->where('Emp',$Emp)->get()->sum('Amount');
        $pp = EmpsProducationPoint::where("Month",$Month)->where('Emp',$Emp)->get()->sum('Point');
        $point=0;
        $newpp=0;

        $HoursValue=$Sal->Salary / $Sal->Hours_Numbers ;
        $Qties=EmpsProducationQuantity::where('Emp',$Emp)->get();

        foreach($Qties as $qty){

            if($qty->FromQ <= $pp){
                if($qty->ToQ <= $pp){
                    $newpp=$pp - $qty->ToQ ;
                    $point+=$qty->ValueQ * ($pp - $newpp);

                }

                if($qty->ToQ >= $pp){
                    if($newpp != 0){
                        $point+=$qty->ValueQ * $newpp;
                    }else{

                        $point+=$qty->ValueQ * $pp;
                    }
                }

            }

        }
        $PaySalary = PaySalary::where("Month",$Month)->where('Emp',$Emp)->first();

        $month=$Month.'01';

        $SETT=Settlement::
        where('Date','>=',$month)
            ->where('Account_Dificit',$Sal->Account)->get()->sum('Total_Dificit_Price');

        $saleslater=Sales::
        where('Status',1)
            ->where('Date','>=',$month)
            ->where('Delegate',$Emp)
            ->where('Payment_Method','Later')
            ->where('Later_Collection',0)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()
            ->sum('Total_Net');



        $LATER= $saleslater  ;


        $s=0;
        $xx=0;
        $xxx=0;


        $sales=Sales::
        where('Status',1)
            ->where('Delegate',$Emp)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get();

        $Ex=Sales::
        where('Status',1)
            ->where('Executor',$Emp)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get();


        $Ratios=EmpRatio::where('Emp',$Emp)->get();

        foreach($sales as $sel){

            $date=$sel->Date;
            $time=strtotime($date);
            $month=date("Y-m",$time);

            if($month == $Month){
                $s += $sel->Total_Net;
            }

        }

        foreach($Ex as $ex){

            $date=$ex->Date;

            $time=strtotime($date);
            $month=date("Y-m",$time);

            if($month == $Month){
                $xx += $ex->Total_Net;
            }

        }


        $PS  = $s  * ($Sal->Precentage_of_Sales / 100) ;
        $PEX = $xx   *  ($Sal->Precentage_of_Execution / 100) ;

        $DED=Deduction::where('Month',$Month)->where('Emp',$Emp)->get()->sum('Amount') ;
        $ENTIT=Entitlement::where('Month',$Month)->where('Emp',$Emp)->get()->sum('Amount') ;

        $EmpDets=EmpInstallmentDetails::where('Emp',$Emp)->get() ;

        foreach($EmpDets as $emD){

            $date=$emD->Date;

            $time=strtotime($date);
            $month=date("Y-m",$time);

            if($month == $Month){
                $xxx += $emD->Value;
            }

        }

        $OVER=RegOverTime::where('Month',$Month)->where('Emp',$Emp)->get()->sum('Amount') ;
        $Attendence=DepartureEmp::where('Month',$Month)->where('Emp',$Emp)->get()->sum('Hours_Number') ;
        $DiscountLate=DepartureEmp::where('Month',$Month)->where('Emp',$Emp)->get()->sum('Disc_Late') ;
        $DiscountDeparture=DepartureEmp::where('Month',$Month)->where('Emp',$Emp)->get()->sum('Disc_Early') ;


        $HourCost=$Sal->Salary / $Sal->Hours_Numbers ;

        $disc= $Attendence * $HourCost ;
        $discT= $Sal->Salary - $disc ;

        $Holidays=Holidays::where('Month',$Month)->where('Emp',$Emp)->where('Discount',1)->get()->sum('Num_of_Days') ;

        $WorkDay =  $Sal->Hours_Numbers / 30 ;
        $HoliDiscount = ($HourCost * $WorkDay) * $Holidays ;


        if(!empty($PaySalary)){

            $New = 1 ;

        }else{

            $New = 0 ;
        }



        $Allowances=AllowencesEmp::where('Emp',$Emp)->get()->sum('AmountAllow');
        $Discounts=DiscountsEmp::where('Emp',$Emp)->get()->sum('AmountDiscount');
        $FinValue= ( $Attendence * $HoursValue)  - ( $DiscountLate + $DiscountDeparture );

        $Array=array();


        array_push($Array,[
            "Total" => $x ,
            'Salary' => $Sal->Salary ,
            'Sales' => $PS,
            'Executes' =>$PEX ,
            'Deduction' =>$DED ,
            'Entitlement' =>$ENTIT ,
            'Loan' =>$xxx ,
            'Overtime' =>$OVER ,
            'Hours_Work' =>$Sal->Hours_Numbers ,
            'Attendance' =>$Attendence  ,
            'Attendance_Discount' =>$discT ,
            'Holidays' =>$Holidays  ,
            'Holidays_Disccount' =>$HoliDiscount,
            'Settlement'=>$SETT,
            'Later'=>$LATER,
            'Allowances'=>$Allowances,
            'Discounts'=>$Discounts,
            'Points'=>$point,
            'Discount_Late'=>$DiscountLate,
            'Discount_Departure'=>$DiscountDeparture ,
            'Hours_Value' =>$HoursValue,
            'Fin_Value'=>$FinValue

        ]);



        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,


        ]);



    }

    //Salary Payed Api
    public function SalaryPayedApi(Request $request){

        $month = $request->get('month');

        $emp = $request->get('emp');




        $items=PaySalary::where('Month', $month)


            ->when(!empty($emp), function ($query) use ($emp) {
                return $query->where('Emp',$emp);

            })


            ->paginate(30);


        $data=SalaryPayedApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];
        return $data->additional($x) ;



    }

//EmpSalariesApi
    public function EmpSalariesApi(Request $request){


        $items=Employess::where('EmpSort',1)->where('Active',1)->whereNotIn('id',[31,32,33,34])->paginate(50);

        //Salries
        $EmpSalaries=Employess::where('EmpSort',1)->where('Active',1)
            ->whereNotIn('id',[31,32,33,34])
            ->get()->Sum('Salary');

        //Emp Count
        $EmpCount=Employess::where('EmpSort',1)->where('Active',1)
            ->whereNotIn('id',[31,32,33,34])
            ->count();

        $data=EmpSalariesApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_slaries'=>$EmpSalaries,
            'emp_count'=>$EmpCount,
        ];
        return $data->additional($x) ;



    }

//EmpGoalsApi
    public function EmpGoalsApi(Request $request){


        $emp=session()->get('emp');

        $items=Employess::orderBy('id','asc')
            ->where('EmpSort',1)
            ->where('Active',1)
            ->when(!empty($emp), function ($query) use ($emp) {
                return $query->whereIn('id', $emp);
            })
            ->paginate(20);

        $data=EmpGoalsApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];
        return $data->additional($x) ;



    }

//EmployeeCommissionDiscountsApi
    public function EmployeeCommissionDiscountsApi(Request $request){


        $Emp=session()->get('emp');

        $EXX=ExchangeCommissions::where('Emp',$Emp)->get()->sum('Amount');
        $returns=ReturnMaintainceBill::where('Eng',$Emp)->get();

        $co=0;
        $s=0;
        $e=0;
        $sR=0;
        $totalcost=0;
        $ReturnCount=0;

        foreach($returns as $ret){

            $i= $ret->Cost_Precent / 100 ;
            $ii= $i *  $ret->Total_Cost ;
            $co += $ii ;

        }

        $sales=Sales::
        where('Status',1)

            ->when(!empty($Emp), function ($query) use ($Emp) {
                return $query->where('Delegate',$Emp);

            })


            ->where('Delete',0)
            ->where('Edit',0)
            ->get()->sum('Total_Net');

        $salesCount=Sales::
        where('Status',1)
            ->where('Delete',0)
            ->where('Edit',0)
            ->when(!empty($Emp), function ($query) use ($Emp) {
                return $query->where('Delegate',$Emp);

            })

            ->count();

        $ReturnCount=ReturnSales::whereRelation('Sales',$Emp)->count();


        $Executors=ProductSales::whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)->whereRelation('Sales','Executor',$Emp)->get()->sum('Total_Net');

        $totalcost=ProductSales::whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)->whereRelation('Sales','Executor',$Emp)->get()->sum('TotCostNew');
        $Name=Employess::find($Emp);

        $diff= $Executors   - $totalcost ;

        $Ratios=EmpRatio::where('Emp',$Emp)->get();

        $Recipts=ReciptVoucher::where('Delete',null)->where('Edit',null)->where('Status',1)->where('Collector',$Emp)->get()->sum('Total_Creditor');



        foreach($Ratios as $r){

            if($r->Typee == 2){

                if($r->From  <=  $diff  and $r->To  >=  $diff ){

                    $z=$r->Rate  / 100 ;
                    $zz= $z *  $diff ;
                    $e += $zz;

                }else{

                    $e+=0;

                }


            }

            if($r->Typee == 3){

                if($r->From  <=  $Recipts  and $r->To  >=  $Recipts ){


                    $xR=$r->Rate  / 100 ;
                    $xxR= $xR *  $Recipts ;
                    $sR+=$xxR;

                }else{

                    $sR+=0;

                }


            }


        }



        $result = ( $s + $e )  -  $co ;

if(!empty($Name)) {
    $neame = $Name->Name;
    $type = $Name->Emp_Type;

}else{
    $neame='';
    $type='';
}


        $Array=array();


        array_push($Array,[
            "Name" => $neame ,
            'Type' => $type,
            'Precentage_of_Sales' => number_format((float)abs($s), 2, '.', ''),
            'Precentage_of_Execution' =>number_format((float)abs($e), 2, '.', '') ,
            'Total_Exchange_Commision' =>number_format((float)abs($EXX), 2, '.', '') ,
            'Total_Commision' =>number_format((float)abs($result), 2, '.', '') ,
            'Sales_Bill_Nums' =>number_format((float)abs($salesCount), 2, '.', '') ,
            'Return_Sales_Bill_Nums' =>number_format((float)abs($ReturnCount), 2, '.', '') ,
            'Collection' =>number_format((float)abs($sR), 2, '.', '') ,

        ]);



        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'data'=>$Array,


        ]);





    }


    //========================================================================


    //================================ CRM ========================================

//Customerـfollowـup_ReportsApi
    public function Customerـfollowـup_ReportsApi(Request $request){

        $Governrate=request('Governrate');
        $City=request('City');
        $Place=request('Place');
        $Group=request('Group');
        $Activity=request('Activity');

        $items=Customers::whereBetween('Date',[request('From'),request('To')])

            ->when(!empty(request('Operation_Date')), function ($query) {
                $query->where('Operating_Date', request('Operation_Date'));
            })
            ->when(!empty(request('Customer')), function ($query) {
                $query->where('id', request('Customer'));
            })

            ->when(!empty($Place), function ($query) use ($Place) {
                $query->where('Place',$Place);
            })

            ->when(!empty($City), function ($query) use ($City) {
                $query->where('City',$City);
            })

            ->when(!empty($Governrate), function ($query) use ($Governrate) {
                $query->where('Governrate',$Governrate);
            })

            ->when(!empty($Group), function ($query) use ($Group) {
                $query->where('Group',$Group);
            })

            ->when(!empty($Activity), function ($query) use ($Activity) {
                $query->where('Activity',$Activity);
            })

            ->latest('id')
            ->paginate(20);

        $data=CustomerfollowupReportsApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];
        return $data->additional($x) ;



    }

//CustomerPeriodReportsApi
    public function CustomerPeriodReportsApi(Request $request){

        $CustmersCount=Customers::whereBetween('Date',[request('From'),request('To')])->count();
        $CommentsCount=CommentsClients::whereBetween('Date',[request('From'),request('To')])->count();
        $SalesCount=Sales::whereBetween('Date',[request('From'),request('To')])->count();
        $SalesTotal=Sales::whereBetween('Date',[request('From'),request('To')])->get()->sum('Total_Net');
        $Governrates=Governrate::all();
        $From=request('From');
        $To=request('To');

        $data=CustomerPeriodReportsApiResources::collection($Governrates);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'CustmersCount'=>$CustmersCount,
            'CommentsCount'=>$CommentsCount,
            'SalesCount'=>$SalesCount,
            'SalesTotal'=>$SalesTotal,
        ];
        return $data->additional($x) ;



    }

//CommentsReportsApi
    public function CommentsReportsApi(Request $request){

        $Date=request('Date');
        $Client=request('Client');
        $Governrate=request('Governrate');
        $City=request('City');
        $Place=request('Place');
        $Group=request('Group');
        $Activity=request('Activity');

        $Clients=Customers::
        when(!empty($Client), function ($query) use ($Client){
            $query->where('id', $Client);
        })

            ->when(!empty($Place), function ($query) use ($Place) {
                $query->where('Place',$Place);
            })

            ->when(!empty($City), function ($query) use ($City) {
                $query->where('City',$City);
            })

            ->when(!empty($Governrate), function ($query) use ($Governrate) {
                $query->where('Governrate',$Governrate);
            })

            ->when(!empty($Group), function ($query) use ($Group) {
                $query->where('Group',$Group);
            })

            ->when(!empty($Activity), function ($query) use ($Activity) {
                $query->where('Activity',$Activity);
            })

            ->paginate(20);



        $data=CommentsReportsApiApiResources::collection($Clients);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];
        return $data->additional($x) ;



    }

//DelegateVistsReportApi
    public function DelegateVistsReportApi(Request $request){

        $from = $request->get('from');
        $to = $request->get('to');
        $Delegate = $request->get('Delegate');
        $Client = $request->get('Client');


        $Prods=ItineraryVisit::whereBetween('Date',[$from,$to])

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Emp', $Delegate);
            })

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereIn('Client', $Client);
            })


            ->paginate(10);


        $data=DelegateVistsReportApiResources::collection($Prods);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];
        return $data->additional($x) ;



    }

//=====================================================================

//=============================  Accounting  ========================================

//GeneralDailyApi
    public function GeneralDailyApi(Request $request){

        $from = $request->get('From');
        $to = $request->get('To');
        $coin = $request->get('Coin');
        $account = $request->get('Account');
        $type = $request->get('Type');
        $cost = $request->get('Cost_Center');
        $user = $request->get('User');

        $items =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->paginate(50);

        $Numbers =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->count();


        $TotalD =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Debitor_Coin');


        $TotalC =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Creditor_Coin');

        $TotalAllD =GeneralDaily::

            when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Debitor_Coin');


        $TotalAllC =GeneralDaily::

            when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Creditor_Coin');


        $credit_period=$TotalD -  $TotalC ;
$credit=$TotalAllD -  $TotalAllC ;

$fname=AcccountingManual::find($account);
if(!empty($fname)){
    $account_name=$fname->Name;
}else{
    $account_name='';
}

        $data=GeneralDailyApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_debitor'=>$TotalD,
            'total_creditor'=>$TotalC,
            'from'=>$from,
            'to'=>$to,
            'account'=>$account_name,
            'credit_period'=>$credit_period,
            'credit'=>$credit,
        ];
        return $data->additional($x) ;



    }

//LedgerFilterApi
    public function LedgerFilterApi(Request $request){

        $from = $request->get('From');
        $to = $request->get('To');
        $coin = $request->get('Coin');
        $account = $request->get('Account');
        $type = $request->get('Type');
        $cost = $request->get('Cost_Center');
        $user = $request->get('User');

        $items =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->paginate(50);

        $Numbers =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->count();


        $TotalD =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Debitor_Coin');


        $TotalC =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Creditor_Coin');

        $TotalAllD =GeneralDaily::

        when(!empty($coin), function ($query) use ($coin) {
            return $query->where('Coin',$coin);

        })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Debitor_Coin');


        $TotalAllC =GeneralDaily::

        when(!empty($coin), function ($query) use ($coin) {
            return $query->where('Coin',$coin);

        })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Creditor_Coin');

        $totalN=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })

            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })

            ->get()->count();


        $credit_period=$TotalD -  $TotalC ;
        $credit=$TotalAllD -  $TotalAllC ;

        $fname=AcccountingManual::find($account);
        if(!empty($fname)){
            $account_name=$fname->Name;
        }else{
            $account_name='';
        }

        $data=GeneralDailyApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_debitor'=>$TotalD,
            'total_creditor'=>$TotalC,
            'count'=>$totalN,
            'from'=>$from,
            'to'=>$to,
            'account'=>$account_name,
            'credit_period'=>$credit_period,
            'credit'=>$credit,
        ];
        return $data->additional($x) ;



    }

//SafeBankStatementFilterApi
    public function SafeBankStatementFilterApi(Request $request){

        $from = $request->get('From');
        $to = $request->get('To');
        $coin = $request->get('Coin');
        $account = $request->get('Account');
        $type = $request->get('Type');
        $cost = $request->get('Cost_Center');
        $user = $request->get('User');

        $items =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->paginate(50);

        $Numbers =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->count();


        $TotalD =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Debitor_Coin');


        $TotalC =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Creditor_Coin');

        $TotalAllD =GeneralDaily::

        when(!empty($coin), function ($query) use ($coin) {
            return $query->where('Coin',$coin);

        })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Debitor_Coin');


        $TotalAllC =GeneralDaily::

        when(!empty($coin), function ($query) use ($coin) {
            return $query->where('Coin',$coin);

        })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Creditor_Coin');

        $totalN=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })

            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })

            ->get()->count();


        $credit_period=$TotalD -  $TotalC ;
        $credit=$TotalAllD -  $TotalAllC ;

        $fname=AcccountingManual::find($account);
        if(!empty($fname)){
            $account_name=$fname->Name;
        }else{
            $account_name='';
        }

        $data=GeneralDailyApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_debitor'=>$TotalD,
            'total_creditor'=>$TotalC,
            'count'=>$totalN,
            'from'=>$from,
            'to'=>$to,
            'account'=>$account_name,
            'credit_period'=>$credit_period,
            'credit'=>$credit,
        ];
        return $data->additional($x) ;



    }

//VendorAccountStatementFilterApi
    public function VendorAccountStatementFilterApi(Request $request){

        $from = $request->get('From');
        $to = $request->get('To');
        $coin = $request->get('Coin');
        $account = $request->get('Account');
        $type = $request->get('Type');
        $cost = $request->get('Cost_Center');
        $user = $request->get('User');

        $items =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->paginate(50);

        $Numbers =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->count();


        $TotalD =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Debitor_Coin');


        $TotalC =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Creditor_Coin');

        $TotalAllD =GeneralDaily::

        when(!empty($coin), function ($query) use ($coin) {
            return $query->where('Coin',$coin);

        })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Debitor_Coin');


        $TotalAllC =GeneralDaily::

        when(!empty($coin), function ($query) use ($coin) {
            return $query->where('Coin',$coin);

        })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Creditor_Coin');

        $totalN=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })

            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })

            ->get()->count();


        $credit_period=$TotalD -  $TotalC ;
        $credit=$TotalAllD -  $TotalAllC ;

        $fname=AcccountingManual::find($account);
        if(!empty($fname)){
            $account_name=$fname->Name;
        }else{
            $account_name='';
        }

        $data=GeneralDailyApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_debitor'=>$TotalD,
            'total_creditor'=>$TotalC,
            'count'=>$totalN,
            'from'=>$from,
            'to'=>$to,
            'account'=>$account_name,
            'credit_period'=>$credit_period,
            'credit'=>$credit,
        ];
        return $data->additional($x) ;



    }

//CustomerAccountStatementFilterApi
    public function CustomerAccountStatementFilterApi(Request $request){

        $from = $request->get('From');
        $to = $request->get('To');
        $coin = $request->get('Coin');
        $account = $request->get('Account');
        $type = $request->get('Type');
        $cost = $request->get('Cost_Center');
        $user = $request->get('User');

        $items =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->paginate(50);

        $Numbers =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->count();


        $TotalD =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Debitor_Coin');


        $TotalC =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Creditor_Coin');

        $TotalAllD =GeneralDaily::

        when(!empty($coin), function ($query) use ($coin) {
            return $query->where('Coin',$coin);

        })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Debitor_Coin');


        $TotalAllC =GeneralDaily::

        when(!empty($coin), function ($query) use ($coin) {
            return $query->where('Coin',$coin);

        })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Creditor_Coin');

        $totalN=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })

            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })

            ->get()->count();


        $credit_period=$TotalD -  $TotalC ;
        $credit=$TotalAllD -  $TotalAllC ;

        $fname=AcccountingManual::find($account);
        if(!empty($fname)){
            $account_name=$fname->Name;
        }else{
            $account_name='';
        }

        $data=GeneralDailyApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_debitor'=>$TotalD,
            'total_creditor'=>$TotalC,
            'count'=>$totalN,
            'from'=>$from,
            'to'=>$to,
            'account'=>$account_name,
            'credit_period'=>$credit_period,
            'credit'=>$credit,
        ];
        return $data->additional($x) ;



    }

//Cost_Centers_ReportFilterApi
    public function Cost_Centers_ReportFilterApi(Request $request){

        $from = $request->get('From');
        $to = $request->get('To');
        $coin = $request->get('Coin');
        $account = $request->get('Account');
        $type = $request->get('Type');
        $cost = $request->get('Cost_Center');
        $user = $request->get('User');

        $items =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->paginate(50);

        $Numbers =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->count();


        $TotalD =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Debitor_Coin');


        $TotalC =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Creditor_Coin');

        $TotalAllD =GeneralDaily::

        when(!empty($coin), function ($query) use ($coin) {
            return $query->where('Coin',$coin);

        })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Debitor_Coin');


        $TotalAllC =GeneralDaily::

        when(!empty($coin), function ($query) use ($coin) {
            return $query->where('Coin',$coin);

        })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Creditor_Coin');

        $totalN=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })

            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })

            ->get()->count();


        $credit_period=$TotalD -  $TotalC ;
        $credit=$TotalAllD -  $TotalAllC ;

        $fname=AcccountingManual::find($account);
        if(!empty($fname)){
            $account_name=$fname->Name;
        }else{
            $account_name='';
        }

        $data=GeneralDailyApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_debitor'=>$TotalD,
            'total_creditor'=>$TotalC,
            'count'=>$totalN,
            'from'=>$from,
            'to'=>$to,
            'account'=>$account_name,
            'credit_period'=>$credit_period,
            'credit'=>$credit,
        ];
        return $data->additional($x) ;



    }


    //ClientAccountStatementDetailsFilterApi
    public function ClientAccountStatementDetailsFilterApi(Request $request){

        $from=$request->get('from');
        $to=$request->get('to');
        $cost_Center=$request->get('cost_Center');
        $coin=$request->get('coin');
        $client=$request->get('client');
        $payment_Method=$request->get('payment_Method');
        $types=$request->get('types');



        $items=Sales::whereBetween('Date',[$from,$to])

            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })


            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })

            ->when(!empty($client), function ($query) use ($client) {
                return $query->where('Client', $client);
            })


            ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                return $query->whereIn('Payment_Method', $payment_Method);
            })

            ->paginate(10);


        $sales=0;
        $sandQabd=0;
        $sandSarf=0;
        $WaslAmana=0;
        $Shekat=0;

        $account=$client;

        if(!empty(request('Type'))){
            $ty=request('Type');

            if(!empty($ty[0])){
                if($ty[0] == 3){
                    $sandSarf=1;
                }elseif($ty[0] == 1){
                    $sales=1;

                }elseif($ty[0] == 2){

                    $sandQabd=1;
                }elseif($ty[0] == 4){

                    $WaslAmana=1;
                }elseif($ty[0] == 5){

                    $Shekat=1;
                }


            }

            if(!empty($ty[1])){
                if($ty[1] == 3){
                    $sandSarf=1;
                }elseif($ty[1] == 1){
                    $sales=1;

                }elseif($ty[1] == 2){

                    $sandQabd=1;
                }elseif($ty[1] == 4){

                    $WaslAmana=1;
                }elseif($ty[1] == 5){

                    $Shekat=1;
                }
            }


            if(!empty($ty[2])){
                if($ty[2] == 3){
                    $sandSarf=1;
                }elseif($ty[2] == 1){
                    $sales=1;

                }elseif($ty[2] == 2){

                    $sandQabd=1;
                }elseif($ty[2] == 4){

                    $WaslAmana=1;
                }elseif($ty[2] == 5){

                    $Shekat=1;
                }
            }


            if(!empty($ty[3])){
                if($ty[3] == 3){
                    $sandSarf=1;
                }elseif($ty[3] == 1){
                    $sales=1;

                }elseif($ty[3] == 2){

                    $sandQabd=1;
                }elseif($ty[3] == 4){

                    $WaslAmana=1;
                }elseif($ty[3] == 5){

                    $Shekat=1;
                }
            }


            if(!empty($ty[4])){
                if($ty[4] == 3){
                    $sandSarf=1;
                }elseif($ty[4] == 1){
                    $sales=1;

                }elseif($ty[4] == 2){

                    $sandQabd=1;
                }elseif($ty[4] == 4){

                    $WaslAmana=1;
                }elseif($ty[4] == 5){

                    $Shekat=1;
                }
            }

        }







        $debt=GeneralDaily::where('Account',$client)->get()->sum('Debitor');
        $crdt=GeneralDaily::where('Account',$client)->get()->sum('Creditor');
        $Balance=$debt - $crdt ;



        $totalD=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->get()->sum('Debitor_Coin');

        $totalC=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->get()->sum('Creditor_Coin');

        $totalAllD=GeneralDaily::

        when(!empty($account), function ($query) use ($account) {
            return $query->where('Account',$account);

        })


            ->get()->sum('Debitor_Coin');

        $totalAllC=GeneralDaily::

        when(!empty($account), function ($query) use ($account) {
            return $query->where('Account',$account);

        })



            ->get()->sum('Creditor_Coin');

        $totalN=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->get()->count();


        $Credit=$totalD - $totalC;
        $CreditAll=$totalAllD - $totalAllC;

        $Vouchers=GeneralDaily::whereBetween('Date',[$from,$to])
            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })


            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })

            ->when(!empty($client), function ($query) use ($client) {
                return $query->where('Account', $client);
            })


            ->whereIn('Type', ['سند صرف','سند قبض','الشيكات الصادرة','الشيكات الواردة','وصل أمانة'])
            ->get();


        $data=ClientDetailsStatementApiResources::collection($items);
        $dataa=VouchersClientStatementDetailsApiResources::collection($Vouchers);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'from'=>$from,
            'to'=>$to,
            'balances'=>$Balance,
            'count'=>$totalN,
            'credit'=>$Credit,
            'crdit_all'=>$CreditAll,
            'vouchers'=>$dataa,

        ];
        return $data->additional($x) ;



    }

//VendorAccountStatementDetailsFilterApi
    public function VendorAccountStatementDetailsFilterApi(Request $request){

        $from=$request->get('from');
        $to=$request->get('to');
        $cost_Center=$request->get('cost_Center');
        $coin=$request->get('coin');
        $client=$request->get('client');
        $payment_Method=$request->get('payment_Method');
        $types=$request->get('types');

        $items=Purchases::whereBetween('Date',[$from,$to])

            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })


            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })

            ->when(!empty($client), function ($query) use ($client) {
                return $query->where('Vendor', $client);
            })


            ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                return $query->whereIn('Payment_Method', $payment_Method);
            })

            ->paginate(10);


        $sales=0;
        $sandQabd=0;
        $sandSarf=0;
        $account=$client;

        $totalD=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })



            ->get()->sum('Debitor_Coin');

        $totalC=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->get()->sum('Creditor_Coin');


        $totalAllD=GeneralDaily::

        when(!empty($account), function ($query) use ($account) {
            return $query->where('Account',$account);

        })



            ->get()->sum('Debitor_Coin');

        $totalAllC=GeneralDaily::

        when(!empty($account), function ($query) use ($account) {
            return $query->where('Account',$account);

        })


            ->get()->sum('Creditor_Coin');

        $totalN=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })



            ->get()->count();


        if(!empty(request('Type'))){
            $ty=request('Type');

            if(!empty($ty[0])){
                if($ty[0] == 3){
                    $sandSarf=1;
                }elseif($ty[0] == 1){
                    $sales=1;

                }elseif($ty[0] == 2){

                    $sandQabd=1;
                }
            }

            if(!empty($ty[1])){
                if($ty[1] == 3){
                    $sandSarf=1;
                }elseif($ty[1] == 1){
                    $sales=1;

                }elseif($ty[1] == 2){

                    $sandQabd=1;
                }
            }


            if(!empty($ty[2])){
                if($ty[2] == 3){
                    $sandSarf=1;
                }elseif($ty[2] == 1){
                    $sales=1;

                }elseif($ty[2] == 2){

                    $sandQabd=1;
                }
            }

        }


        if($sandQabd == 1 and $sandSarf=1){
            $Vouchers=GeneralDaily::whereBetween('Date',[$from,$to])
                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->where('Account', $client);
                })


                ->whereIn('Type', ['سند صرف','سند قبض'])
                ->get();
        }elseif($sandQabd == 1 and $sandSarf=0){
            $Vouchers=GeneralDaily::whereBetween('Date',[$from,$to])
                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->where('Account', $client);
                })


                ->where('Type','سند قبض')
                ->get();

        }elseif($sandQabd == 0 and $sandSarf=1){

            $Vouchers=GeneralDaily::whereBetween('Date',[$from,$to])
                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->where('Account', $client);
                })


                ->where('Type', 'سند صرف')
                ->get();

        }elseif($sandQabd == 0 and $sandSarf=0){
            $Vouchers='';

        }


        $debt=GeneralDaily::where('Account',$client)->get()->sum('Debitor');
        $crdt=GeneralDaily::where('Account',$client)->get()->sum('Creditor');
        $Balance=$debt - $crdt ;

        $Credit=$totalD - $totalC;
        $CreditAll=$totalAllD - $totalAllC;



        $data=VendorDetailsStatementApiResources::collection($items);
        $dataa=VouchersClientStatementDetailsApiResources::collection($Vouchers);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'from'=>$from,
            'to'=>$to,
            'balances'=>$Balance,
            'count'=>$totalN,
            'credit'=>$Credit,
            'crdit_all'=>$CreditAll,
            'vouchers'=>$dataa,

        ];
        return $data->additional($x) ;



    }



//ClientsStatementApi
    public function ClientsStatementApi(Request $request){

        $from=$request->get('from');
        $to=$request->get('to');
        $account=$request->get('account');


        $items = AcccountingManual::where('Parent',24)
            ->where('Type', 1)

            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('id', $account);
            })
            ->paginate(50);



        $totalD=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('Account',$account);

            })


            ->get()->sum('Debitor_Coin');

        $totalC=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('Account',$account);

            })


            ->get()->sum('Creditor_Coin');

        $totalAllD=GeneralDaily::

        when(!empty($account), function ($query) use ($account) {
            return $query->whereIn('Account',$account);

        })


            ->get()->sum('Debitor_Coin');

        $totalAllC=GeneralDaily::

        when(!empty($account), function ($query) use ($account) {
            return $query->whereIn('Account',$account);

        })



            ->get()->sum('Creditor_Coin');

        $totalN=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('Account',$account);

            })


            ->get()->count();


        $Credit=$totalD - $totalC;
        $CreditAll=$totalAllD - $totalAllC;


        $fname=AcccountingManual::find($account);
        if(!empty($fname)){
            $account_name=$fname->Name;
        }else{
            $account_name='';
        }

        $data=ClientVendorStatementApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'count'=>$totalN,
            'from'=>$from,
            'to'=>$to,
            'account'=>$account_name,
            'credit_period'=>$Credit,
            'credit'=>$CreditAll,
        ];
        return $data->additional($x) ;



    }


    //CustomerBalancesApi
    public function CustomerBalancesApi(Request $request){

        $from=$request->get('from');
        $to=$request->get('to');
        $zero = $request->get('Zero');


        $Accounts = AcccountingManual::where('Parent',24)
            ->where('Type', 1)
            ->orderBy('id', 'asc')
            ->paginate(100);

        $AccountsCount = AcccountingManual::where('Parent',24)
            ->where('Type', 1)
            ->orderBy('id', 'asc')
            ->count();

        $totalD=GeneralDaily::whereBetween('Date', [$from, $to])

            ->whereRelation('Account','Parent',24)

            ->get()->sum('Debitor_Coin');

        $totalC=GeneralDaily::whereBetween('Date', [$from, $to])

            ->whereRelation('Account','Parent',24)

            ->get()->sum('Creditor_Coin');

        $totalAllD=GeneralDaily::

        whereRelation('Account','Parent',24)

            ->get()->sum('Debitor_Coin');

        $totalAllC=GeneralDaily::

        whereRelation('Account','Parent',24)


            ->get()->sum('Creditor_Coin');
        $Credit=$totalD - $totalC;
        $CreditAll=$totalAllD - $totalAllC;



            $account_name='';


        $data=ClientVendorBalancesApiResources::collection($Accounts);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'count'=>$AccountsCount,
            'from'=>$from,
            'to'=>$to,
            'account'=>$account_name,
            'credit_period'=>$Credit,
            'credit'=>$CreditAll,
        ];
        return $data->additional($x) ;



    }


    //CustomerDebtsApi
    public function CustomerDebtsApi(Request $request){

        $from = $request->get('from');
        $to = $request->get('to');
        $Store = $request->get('Store');
        $Client = $request->get('Client');
        $Delegate = $request->get('Delegate');
        $Safe = $request->get('Safe');
        $Branch = $request->get('Branch');
        $code = $request->get('code');



        $items =Sales::where('Status',1)
            ->where('Payment_Method','Later')
            ->where('Later_Collection',0)
            ->whereBetween('Date', [$from, $to])

            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Code',$code);

            })

            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe',$Safe);

            })

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->where('Client',$Client);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate',$Delegate);

            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })


            ->when(!empty($Branch), function ($query) use ($Branch) {
                return $query->where('Branch',$Branch);

            })


            ->where('Edit',0)
            ->where('Delete',0)
            ->paginate(50);


        $data=ClientVendorDebtsApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),

        ];
        return $data->additional($x) ;



    }

    //CustomerDebtsAgeApi
    public function CustomerDebtRestructuringFilterApi(Request $request){

        $account = $request->get('account');
        $Date_Type = $request->get('Date_Type');

        if($Date_Type == 1){
            $type='Date';
        }else{
            $type='Later_Due';
        }


        $items=AcccountingManual::

        when(!empty($account), function ($query) use ($account) {
            return $query->whereIn('id',$account);

        })

            ->paginate(30);





        $data=CustomerDebtRestructuringFilterApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),

        ];
        return $data->additional($x) ;



    }


//VendorsStatementApi
    public function VendorsStatementApi(Request $request){

        $from=$request->get('from');
        $to=$request->get('to');
        $account=$request->get('account');


        $items = AcccountingManual::where('Parent',37)
            ->where('Type', 1)

            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('id', $account);
            })
            ->paginate(50);



        $totalD=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('Account',$account);

            })


            ->get()->sum('Debitor_Coin');

        $totalC=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('Account',$account);

            })


            ->get()->sum('Creditor_Coin');

        $totalAllD=GeneralDaily::

        when(!empty($account), function ($query) use ($account) {
            return $query->whereIn('Account',$account);

        })


            ->get()->sum('Debitor_Coin');

        $totalAllC=GeneralDaily::

        when(!empty($account), function ($query) use ($account) {
            return $query->whereIn('Account',$account);

        })



            ->get()->sum('Creditor_Coin');

        $totalN=GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('Account',$account);

            })


            ->get()->count();


        $Credit=$totalD - $totalC;
        $CreditAll=$totalAllD - $totalAllC;


        $fname=AcccountingManual::find($account);
        if(!empty($fname)){
            $account_name=$fname->Name;
        }else{
            $account_name='';
        }

        $data=ClientVendorStatementApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'count'=>$totalN,
            'from'=>$from,
            'to'=>$to,
            'account'=>$account_name,
            'credit_period'=>$Credit,
            'credit'=>$CreditAll,
        ];
        return $data->additional($x) ;



    }

    //VendorBalancesApi
    public function VendorBalancesApi(Request $request){

        $from=$request->get('from');
        $to=$request->get('to');
        $zero = $request->get('Zero');


        $Accounts = AcccountingManual::where('Parent',37)
            ->where('Type', 1)
            ->orderBy('id', 'asc')
            ->paginate(100);

        $AccountsCount = AcccountingManual::where('Parent',37)
            ->where('Type', 1)
            ->orderBy('id', 'asc')
            ->count();

        $totalD=GeneralDaily::whereBetween('Date', [$from, $to])

            ->whereRelation('Account','Parent',24)

            ->get()->sum('Debitor_Coin');

        $totalC=GeneralDaily::whereBetween('Date', [$from, $to])

            ->whereRelation('Account','Parent',24)

            ->get()->sum('Creditor_Coin');

        $totalAllD=GeneralDaily::

        whereRelation('Account','Parent',24)

            ->get()->sum('Debitor_Coin');

        $totalAllC=GeneralDaily::

        whereRelation('Account','Parent',24)


            ->get()->sum('Creditor_Coin');
        $Credit=$totalD - $totalC;
        $CreditAll=$totalAllD - $totalAllC;



        $account_name='';


        $data=ClientVendorBalancesApiResources::collection($Accounts);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'count'=>$AccountsCount,
            'from'=>$from,
            'to'=>$to,
            'account'=>$account_name,
            'credit_period'=>$Credit,
            'credit'=>$CreditAll,
        ];
        return $data->additional($x) ;



    }


//VendorDebtsApi
    public function VendorDebtsApi(Request $request){

        $from = $request->get('from');
        $to = $request->get('to');
        $Store = $request->get('Store');
        $Vendor = $request->get('Vendor');
        $Delegate = $request->get('Delegate');
        $Safe = $request->get('Safe');
        $Branch = $request->get('Branch');
        $code = $request->get('code');



        $items =Purchases::where('Status',1)
            ->where('Payment_Method','Later')
            ->whereBetween('Date', [$from, $to])

            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Code',$code);

            })

            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe',$Safe);

            })

            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->where('Vendor',$Vendor);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate',$Delegate);

            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })


            ->when(!empty($Branch), function ($query) use ($Branch) {
                return $query->where('Branch',$Branch);

            })


            ->where('Edit',0)
            ->where('Delete',0)
            ->paginate(50);


        $data=VendorDebtsApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),

        ];
        return $data->additional($x) ;



    }



//VendorDebtRestructuringFilterApi
    public function VendorDebtRestructuringFilterApi(Request $request){

        $account = $request->get('account');
        $Date_Type = $request->get('Date_Type');

        if($Date_Type == 1){
            $type='Date';
        }else{
            $type='Later_Due';
        }


        $items=AcccountingManual::

        when(!empty($account), function ($query) use ($account) {
            return $query->whereIn('id',$account);

        })

            ->paginate(30);





        $data=VendorDebtRestructuringFilterApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),

        ];
        return $data->additional($x) ;



    }



    //InstallmentReportApi
    public function InstallmentReportApi(Request $request){

        $Client = $request->get('Client');

        $ProdsCount=InstallmentDates::where('Client',$Client)
            ->where('Date','>', date('Y-m-d'))
            ->count();

        $ProdsTotal=InstallmentDates::where('Client',$Client)
            ->where('Date','>', date('Y-m-d'))
            ->get()->sum('Value');


        $items=InstallmentDates::where('Client',$Client)
            ->where('Date','>', date('Y-m-d'))
            ->paginate(20);



        $data=InstallmentReportApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'count'=>$ProdsCount,
            'total'=>$ProdsTotal,

        ];
        return $data->additional($x) ;



    }

    //SafesBalancesApi
    public function SafesBalancesApi(Request $request){

        $from = $request->get('From');
        $to = $request->get('To');
        $safe = $request->get('Safe');
        $Coin = $request->get('Coin');

        $Safes = AcccountingManual::
        where('Type',1)
            ->where('Parent',28)
            ->orWhere('Parent',29)
            ->paginate(50);



        $data=SafesBalancesApiResources::collection($Safes);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),

        ];
        return $data->additional($x) ;



    }


    //SafesTransferReportFilterApi
    public function SafesTransferReportFilterApi(Request $request){

        $from=$request->get('from');
        $to=$request->get('to');
        $branch=$request->get('branch');
        $coin=$request->get('coin');
        $code=$request->get('code');
        $value=$request->get('value');
        $fromSafe=$request->get('fromSafe');
        $toSafe=$request->get('toSafe');
        $delegate=$request->get('delegate');
        $user=$request->get('user');
        $types=$request->get('types');


        $items=SafeTransfers::whereBetween('Date',[$from,$to])

            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Code', $code);
            })



            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })

            ->when(!empty($types), function ($query) use ($types) {
                return $query->whereIn('Status', $types);
            })



            ->when(!empty($value), function ($query) use ($value) {
                return $query->where('Amount','>=', $value);
            })



            ->when(!empty($fromSafe), function ($query) use ($fromSafe) {
                return $query->whereIn('From_Safe', $fromSafe);
            })

            ->when(!empty($toSafe), function ($query) use ($toSafe) {
                return $query->whereIn('To_Safe', $toSafe);
            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })



            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })

            ->paginate(10);



        $Bills_Nums=SafeTransfers::whereBetween('Date',[$from,$to])

            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Code', $code);
            })



            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })

            ->when(!empty($types), function ($query) use ($types) {
                return $query->whereIn('Status', $types);
            })



            ->when(!empty($value), function ($query) use ($value) {
                return $query->where('Amount','>=', $value);
            })



            ->when(!empty($fromSafe), function ($query) use ($fromSafe) {
                return $query->whereIn('From_Safe', $fromSafe);
            })

            ->when(!empty($toSafe), function ($query) use ($toSafe) {
                return $query->whereIn('To_Safe', $toSafe);
            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })



            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })

            ->count();




        $Total_Price=SafeTransfers::whereBetween('Date',[$from,$to])

            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Code', $code);
            })



            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })

            ->when(!empty($types), function ($query) use ($types) {
                return $query->whereIn('Status', $types);
            })



            ->when(!empty($value), function ($query) use ($value) {
                return $query->where('Amount','>=', $value);
            })



            ->when(!empty($fromSafe), function ($query) use ($fromSafe) {
                return $query->whereIn('From_Safe', $fromSafe);
            })

            ->when(!empty($toSafe), function ($query) use ($toSafe) {
                return $query->whereIn('To_Safe', $toSafe);
            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })



            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })

            ->get()->sum('Amount');


        $data=SafesTransferReportFilterApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'count'=>$Bills_Nums,
            'total'=>$Total_Price,

        ];
        return $data->additional($x) ;



    }


    //TotalExpensesSafesFilterApi
    public function TotalExpensesSafesFilterApi(Request $request){

        $Safes = AcccountingManual::where('Type',1)->whereIn('Parent',[28,29])->paginate(50);

        $data=TotalExpensesSafesFilterApiResources::collection($Safes);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];
        return $data->additional($x) ;

    }

    //ExpensesListFilterApi
    public function ExpensesListFilterApi(Request $request){
        $from=$request->get('from');
        $to=$request->get('to');
        $branch=$request->get('branch');
        $safe=$request->get('safe');
        $account=$request->get('account');
        $subAccount=$request->get('subAccount');




        $items = AcccountingManual::orderBy('Code','asc')


            ->when(!empty($subAccount), function ($query) use ($subAccount) {
                return $query->whereIn('id', $subAccount);
            })
            ->paginate(50);


        $data=ExpensesListFilterApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];
        return $data->additional($x) ;

    }

//ExpensesReportFilterApi
    public function ExpensesReportFilterApi(Request $request){
        $from = $request->get('From');
        $to = $request->get('To');
        $safe = $request->get('Safe');

        $items =PaymentVoucher::whereBetween('Date',[$from,$to])

            ->where('Safe',$safe)
            ->where('Edit',null)
            ->where('Delete',null)
            ->paginate(10);

        $data=ExpensesReportFilterApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];
        return $data->additional($x) ;

    }

//IncomListReportFilterApi
    public function IncomListReportFilterApi(Request $request){
        $from=$request->get('from');
        $to=$request->get('to');
        $branch=$request->get('branch');
        $safe=$request->get('safe');
        $account=$request->get('account');
        $subAccount=$request->get('subAccount');

        $items = AcccountingManual::orderBy('Code','asc')
            ->when(!empty($subAccount), function ($query) use ($subAccount) {
                return $query->whereIn('id', $subAccount);
            })
            ->paginate(10);


        $data=IncomListReportFilterApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];
        return $data->additional($x) ;

    }

//ChecksReportsApi
    public function ChecksReportsApi(Request $request){

        $from = $request->get('from');
        $to = $request->get('to');
        $coin = $request->get('coin');
        $account = $request->get('account');
        $type = $request->get('type');
        $cost = $request->get('cost');
        $user = $request->get('user');
        $CheckStatus = $request->get('CheckStatus');
        $CheckType = $request->get('CheckType');
        $Bank = $request->get('Bank');


        $items =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->paginate(50);

        $totalD =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Debitor_Coin');

        $totalC =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->get()->sum('Creditor_Coin');



        $totalN =GeneralDaily::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->where('Type',$type);

            })


            ->when(!empty($cost), function ($query) use ($cost) {
                return $query->where('Cost_Center',$cost);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('userr',$user);

            })


            ->count();
        $data=ChecksReportsApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_debitor'=>$totalD,
            'total_creditor'=>$totalC,
            'count'=>$totalN,
        ];
        return $data->additional($x) ;

    }

    //InsurancePaperReportFilterApi
    public function InsurancePaperReportFilterApi(Request $request){


        $from = $request->get('from');
        $to = $request->get('to');
        $coin = $request->get('coin');
        $account = $request->get('account');
        $user = $request->get('user');
        $Bank = $request->get('Bank');

        $items =InsurancePaper::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })

            ->when(!empty($Bank), function ($query) use ($Bank) {
                return $query->where('Bank',$Bank);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('User',$user);

            })


            ->paginate(50);



        $total =InsurancePaper::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })

            ->when(!empty($Bank), function ($query) use ($Bank) {
                return $query->where('Bank',$Bank);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('User',$user);

            })

            ->get()->sum('Amount');





        $Counter =InsurancePaper::whereBetween('Date', [$from, $to])

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin',$coin);

            })

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Account',$account);

            })

            ->when(!empty($Bank), function ($query) use ($Bank) {
                return $query->where('Bank',$Bank);

            })

            ->when(!empty($user), function ($query) use ($user) {
                return $query->where('User',$user);

            })

            ->count();
        $data=InsurancePaperReportFilterApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total'=>$total,
            'count'=>$Counter,
        ];
        return $data->additional($x) ;

    }

    //Fixed_Assets_ReportFilterApi
    public function Fixed_Assets_ReportFilterApi(Request $request){

        $from = $request->get('From');
        $to = $request->get('To');
        $account = $request->get('Main_Account');

        $items =Assets::whereBetween('Operation_Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Main_Account',$account);

            })


            ->where('Delete',null)
            ->paginate(50);

        $TotalCost =Assets::whereBetween('Operation_Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Main_Account',$account);

            })

            ->where('Delete',null)

            ->get()->sum('Cost');


        $TotalNet =Assets::whereBetween('Operation_Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Main_Account',$account);

            })


            ->where('Delete',null)
            ->get()->sum('Asset_Net');


        $TotalEhlak =Assets::whereBetween('Operation_Date', [$from, $to])

            ->when(!empty($account), function ($query) use ($account) {
                return $query->where('Main_Account',$account);

            })

            ->where('Delete',null)

            ->get()->sum('Previous_Depreciation');

        $data=Fixed_Assets_ReportFilterApiResources::collection($items);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),

        ];
        return $data->additional($x) ;

    }

    //TrialBalanceFilterApi
    public function TrialBalanceFilterApix(Request $request){

        $from = $request->get('from');
        $to = $request->get('to');
        $type = $request->get('type');
        $zero = $request->get('zero');

        $Accounts=AcccountingManual::orderBy('Code','asc')->where('Type',$type)
            ->paginate(50);


        $data=TrialBalanceFilterApiiResources::collection($Accounts);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),

        ];
        return $data->additional($x) ;

    }

//AccountBalancesFilterApi
        public function AccountBalancesFilterApi(Request $request){

            $from = $request->get('From');
            $to = $request->get('To');
            $type = $request->get('Type');
            $zero = $request->get('Zero');

            $A=AcccountingManual::where('id',$type)->first();

            if($A->Parent == 0){

                $words=$A->Code.'0';

            }else{

                $words=$A->Code;

            }

            $Accounts = AcccountingManual::where('Code', 'like', $words.'%')
                ->where('Type', 1)
                ->paginate(100);

            $FilterAccounts = AcccountingManual::where('Code', 'like', $words.'%')
                ->where('Type', 1)
                ->get('id');



            $totalD=GeneralDaily::whereBetween('Date', [$from, $to])

                ->when(!empty($FilterAccounts), function ($query) use ($FilterAccounts) {
                    return $query->whereIn('Account',$FilterAccounts);

                })


                ->get()->sum('Debitor_Coin');

            $totalC=GeneralDaily::whereBetween('Date', [$from, $to])

                ->when(!empty($FilterAccounts), function ($query) use ($FilterAccounts) {
                    return $query->whereIn('Account',$FilterAccounts);

                })


                ->get()->sum('Creditor_Coin');


            $totalAllD=GeneralDaily::

            when(!empty($FilterAccounts), function ($query) use ($FilterAccounts) {
                return $query->whereIn('Account',$FilterAccounts);

            })


                ->get()->sum('Debitor_Coin');

            $totalAllC=GeneralDaily::

            when(!empty($FilterAccounts), function ($query) use ($FilterAccounts) {
                return $query->whereIn('Account',$FilterAccounts);

            })


                ->get()->sum('Creditor_Coin');



            $Credit=$totalD - $totalC;
            $CreditAll=$totalAllD - $totalAllC;


            $data=AccountBalancesFilterApiResources::collection($Accounts);

        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'from'=>$from,
            'to'=>$to,
            'credit'=>$Credit,
            'credit_all'=>$CreditAll,

        ];
        return $data->additional($x) ;

    }


//SubIncomListFilterApi
    public function SubIncomListFilterApi(Request $request){

        $from=request('From');
        $to=request('To');
        $branch=request('Branch');



        $TotaslSales =Sales::whereBetween('Date',[request('From'),request('To')])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total_Price');



        $TotaslStoresTrans =StorsTransfers::whereBetween('Date',[request('From'),request('To')])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total');


        $CostStoresTrans =StorsTransfers::whereBetween('Date',[request('From'),request('To')])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total_Cost');




        $TotaslReturnStoresTrans =ReturnStorsTransfer::whereBetween('Date',[request('From'),request('To')])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total');


        $CostReturnStoresTrans =ReturnStorsTransfer::whereBetween('Date',[request('From'),request('To')])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total_Cost');





        $TotaslMaintaince =ReciptMaintaince::whereBetween('Date',[request('From'),request('To')])
            ->where('Status',8)
            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total');


        $TotaslMaintainceDisc =ReciptMaintaince::whereBetween('Date',[request('From'),request('To')])
            ->where('Status',8)
            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total_Discount');



        $TotaslMaintainceCost =ReciptMaintaince::whereBetween('Date',[request('From'),request('To')])
            ->where('Status',8)
            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total_Cost');



        $TotaslReturnMaintaince =ReturnMaintainceBill::whereBetween('Date',[request('From'),request('To')])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total');




        $Total_Taxes =Sales::whereBetween('Date',[request('From'),request('To')])


            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total_Taxes');


        $ProfitTax =Sales::whereBetween('Date',[request('From'),request('To')])


            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('ProfitTax');


        $Total_Discount =Sales::whereBetween('Date',[request('From'),request('To')])


            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total_Discount');


        $Total_Cost =Sales::whereBetween('Date',[request('From'),request('To')])


            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total_Cost');



        $Total_Return_Value =ReturnSales::whereBetween('Date',[request('From'),request('To')])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total_Return_Value');


        $PaymentVoucher =PaymentVoucher::whereBetween('Date',[request('From'),request('To')])


            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->whereIn('Branch', $branch);
            })
            ->get()->sum('Total_Debaitor');


        $StoresTransferProfit= $TotaslStoresTrans -  $CostStoresTrans ;

        $total_net=($TotaslSales + $TotaslMaintaince + $Total_Taxes + $ProfitTax + $StoresTransferProfit) - ($Total_Discount + $TotaslMaintainceDisc) ;

        $profit=$total_net - ($Total_Cost + $TotaslMaintainceCost) ;

        $profit_net=$profit - $PaymentVoucher ;


        return response()->json([
            'status'=>200,
            'message'=>trans('admin.Success'),
            'Total_Sales'=>$TotaslSales,
            'Total_Return'=>$Total_Return_Value,
            'StoresTransferProfit'=>$StoresTransferProfit,
            'Total_Sales_Maintance'=>$TotaslMaintaince,
            'Total_Return_Maintance'=>$TotaslReturnMaintaince,
            'Total_Discount'=>$Total_Discount,
            'Total_Net'=>$total_net,
            'Total_Sales_Cost'=>$Total_Cost + $TotaslMaintainceCost + $CostStoresTrans,
            'Total_Profit'=>$profit,
            'Total_Payment_Voucher'=>$PaymentVoucher,
            'Profit_Net'=>$profit_net,

        ]);

    }



    //FilterFinancial_CenterNew====================

    public function FilterFinancial_CenterNew(Request $request){


            $Array=array();

            $to = $request->get('To');
            $type = $request->get('Type');



            $AEryd=AcccountingManual::where('id',15)->first();

            $ASabta=AcccountingManual::where('id',21)->first();
            if($ASabta->Parent == 0){

                $wordsSabta=$ASabta->Code.'0';

            }else{

                $wordsSabta=$ASabta->Code;

            }

            $TotalDebAsoulSabta = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsSabta.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Debitor_Coin');



            $TotalCredAsoulSabta = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsSabta.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Creditor_Coin');



            $EgmalyAsoulSabta=$TotalDebAsoulSabta - $TotalCredAsoulSabta ;


            $Amtdawla=AcccountingManual::where('id',22)->first();

            if($Amtdawla->Parent == 0){

                $wordsMtdawla=$Amtdawla->Code.'0';

            }else{

                $wordsMtdawla=$Amtdawla->Code;

            }

            $TotalDebAsoulMtadawla = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsMtdawla.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Debitor_Coin');



            $TotalCredAsoulMtadawla = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsMtdawla.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Creditor_Coin');



            $EgmalyAsoulMtadawla=$TotalDebAsoulMtadawla - $TotalCredAsoulMtadawla ;


            $AOther=AcccountingManual::where('id',147)->first();

            if($AOther->Parent == 0){

                $wordsOther=$AOther->Code.'0';

            }else{

                $wordsOther=$AOther->Code;

            }


            $TotalDebAsoulOkhraa = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsOther.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Debitor_Coin');



            $TotalCredAsoulOkhraa = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsOther.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Creditor_Coin');



            $EgmalyAsoulOkhraa=$TotalDebAsoulOkhraa - $TotalCredAsoulOkhraa ;
            $EgmalyAsoul=$EgmalyAsoulSabta + $EgmalyAsoulMtadawla + $EgmalyAsoulOkhraa ;


            $ATaklfa=AcccountingManual::where('id',16)->first();
            if($ATaklfa->Parent == 0){

                $wordss=$ATaklfa->Code.'0';

            }else{

                $wordss=$ATaklfa->Code;

            }
            $TotalDebKhsoum = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordss.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Debitor_Coin');



            $TotalCredKhsoum = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordss.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Creditor_Coin');



            $EgmalyKhsoum= $TotalCredKhsoum  - $TotalDebKhsoum ;






            $ATaklfaTweel=AcccountingManual::where('id',148)->first();

            if($ATaklfaTweel->Parent == 0){

                $wordssTweel=$ATaklfaTweel->Code.'0';

            }else{

                $wordssTweel=$ATaklfaTweel->Code;

            }


            $TotalDebKhsoumTweel = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordssTweel.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Debitor_Coin');



            $TotalCredKhsoumTweel = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordssTweel.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Creditor_Coin');



            $EgmalyKhsoumTweel= $TotalCredKhsoumTweel  - $TotalDebKhsoumTweel ;

            $EgmalyKhsoumQaserr= $EgmalyKhsoum -  $EgmalyKhsoumTweel;

            $RasMal3aml=$EgmalyAsoulMtadawla - $EgmalyKhsoumQaserr;
            $Estsmar=$RasMal3aml + $EgmalyAsoulSabta + $EgmalyAsoulOkhraa ;


            $AMsrfoat=AcccountingManual::where('id',17)->first();

            if($AMsrfoat->Parent == 0){

                $wordsss=$AMsrfoat->Code.'0';

            }else{

                $wordsss=$AMsrfoat->Code;

            }



            $AErydaaat=AcccountingManual::where('id',18)->first();

            if($AErydaaat->Parent == 0){

                $wordsX=$AErydaaat->Code.'0';

            }else{

                $wordsX=$AEryd->Code;

            }


            $ATaklfaaat=AcccountingManual::where('id',19)->first();

            if($ATaklfaaat->Parent == 0){

                $wordssX=$ATaklfaaat->Code.'0';

            }else{

                $wordssX=$ATaklfaaat->Code;

            }


            $AMasroffffffffat=AcccountingManual::where('id',20)->first();

            if($AMasroffffffffat->Parent == 0){

                $wordsssX=$AMasroffffffffat->Code.'0';

            }else{

                $wordsssX=$AMasroffffffffat->Code;

            }


            $TotalDebErydat = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Debitor_Coin');



            $TotalCredErydat = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Creditor_Coin');

            $EgmalyErydat=$TotalCredErydat - $TotalDebErydat  ;




            $TotalDebTaklfaat = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Debitor_Coin');



            $TotalCredTaklfaat = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Creditor_Coin');

            $EgmalyTaklfaat=$TotalDebTaklfaat - $TotalCredTaklfaat  ;


            $TotalDebMasrofaat = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Debitor_Coin');



            $TotalCredMasrofaat = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Creditor_Coin');

            $EgmalyMasrofaat=$TotalDebMasrofaat - $TotalCredMasrofaat  ;


            $fg= $EgmalyTaklfaat + $EgmalyMasrofaat;
            if($EgmalyErydat >  $fg){
                if($fg  <  0 ){

                    $SafyRab7 =$EgmalyErydat + ($EgmalyTaklfaat  +   $EgmalyMasrofaat)  ;
                }else{

                    $SafyRab7 = $EgmalyErydat -  ($EgmalyTaklfaat  +   $EgmalyMasrofaat)  ;

                }
            }elseif($EgmalyErydat <  $fg){

                if($fg  <  0 ){

                    $SafyRab7 =$EgmalyErydat + ($EgmalyTaklfaat  +   $EgmalyMasrofaat)  ;
                }else{

                    $SafyRab7 = $EgmalyErydat -  ($EgmalyTaklfaat  +   $EgmalyMasrofaat)  ;

                }


            }elseif($EgmalyErydat ==  $fg){

                $SafyRab7 = $EgmalyErydat -  ($EgmalyTaklfaat  +   $EgmalyMasrofaat)  ;

            }




            $TotalDebHkook = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Debitor_Coin');



            $TotalCredHkook = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->where('general_dailies.Date', '<=', $to);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Creditor_Coin');




            $EgmalyHkook=($TotalCredHkook - $TotalDebHkook) + $SafyRab7 ;

            $xv= $EgmalyKhsoumTweel + $EgmalyHkook;
            $Result = $EgmalyAsoul - ($EgmalyKhsoum + $EgmalyHkook);
            array_push($Array,[
                'assets'=>$AEryd->Name,
                'fixed_assets'=>trans('admin.fixed_assets'),
                'total_fixed_assets'=>number_format((float)($EgmalyAsoulSabta), 2, '.', ''),
                'traded_assets'=>trans('admin.traded_assets'),
                'total_traded_assets'=>number_format((float)($EgmalyAsoulMtadawla), 2, '.', ''),
                'other_assets'=>trans('admin.other_assets'),
                'total_other_assets'=>number_format((float)($EgmalyAsoulOkhraa), 2, '.', ''),
                'total_assets'=>number_format((float)abs($EgmalyAsoul), 2, '.', ''),
                'liabilities'=>$ATaklfa->Name,
                'total_liabilities'=>number_format((float)($EgmalyKhsoum), 2, '.', ''),
                'total_long_liabilities'=>number_format((float)($EgmalyKhsoumTweel), 2, '.', ''),
                'total_short_liabilities'=>number_format((float)($EgmalyKhsoumQaserr), 2, '.', ''),
                'total_working_capital'=>number_format((float)($RasMal3aml), 2, '.', ''),
                'total_investment'=>number_format((float)($Estsmar), 2, '.', ''),
                'property_rights'=>$AMsrfoat->Name,
                'net_profit_loss'=>number_format((float)($SafyRab7), 2, '.', ''),
                'total_property_rights'=>number_format((float)($EgmalyHkook), 2, '.', ''),
                'total_property_rights_and_long_liabilities'=>number_format((float)($xv), 2, '.', ''),
                'differnce'=>number_format((float)($Result), 2, '.', ''),

            ]);



            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);



    }


    //FilterFinancial_CenterAsoul
    public function FilterFinancial_CenterAsoul(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if(!empty($admin)){
            $Array=array();

            $to = $request->get('To');
            $type = $request->get('Type');


            $AEryd=AcccountingManual::where('id',15)->first();

            if($AEryd->Parent == 0){

                $words=$AEryd->Code.'0';

            }else{

                $words=$AEryd->Code;

            }

            $AccountsErydat = AcccountingManual::where('Code', 'like', $words.'%')
                ->where('Type', 1)
                ->get();



            if($type == 1){

                $x=0;
                $y=0;
                $TotalErydatD = 0;
                $TotalErydatC = 0;

                foreach($AccountsErydat as $row)
                {


                    $TotalDeb =GeneralDaily::where('Account',$row->id)
                        ->where('Date','<=' , $to)
                        ->get()->sum('Debitor_Coin');


                    $TotalCred =GeneralDaily::where('Account',$row->id)
                        ->where('Date','<=' , $to)
                        ->get()->sum('Creditor_Coin');


                    $z=$TotalDeb - $TotalCred ;

                    if($z == 0){

                        $x=0;
                        $y=0;
                        $TotalErydatD += 0;
                        $TotalErydatC += 0;
                    }elseif($z < 0){

                        $x=0;
                        $y=abs($z);
                        $TotalErydatD += 0;
                        $TotalErydatC += abs($z);

                    }elseif($z > 0){

                        $x=$z;
                        $y=0;
                        $TotalErydatD += $z;
                        $TotalErydatC += 0;

                    }



                    if($lang == 'ar'){
                        array_push($Array,[
                            'name'=>$row->Name,
                            'debitor'=>number_format((float)abs($x), 2, '.', ''),
                            'creditor'=>number_format((float)abs($y), 2, '.', ''),


                        ]);
                    }else{
                        array_push($Array,[
                            'name'=>$row->NameEn,
                            'debitor'=>number_format((float)abs($x), 2, '.', ''),
                            'creditor'=>number_format((float)abs($y), 2, '.', ''),


                        ]);

                    }


                }


            }else{
                $wx=1010;
                $wxx=1020;
                $wxxx=1030;
                $AccountsX=AcccountingManual::orderBy('Code','asc')->where('Code','like', $wx.'%')->where('Type',$type)->get();
                $AccountsXX=AcccountingManual::orderBy('Code','asc')->where('Code','like', $wxx.'%')->where('Type',$type)->get();
                $AccountsXXX=AcccountingManual::orderBy('Code','asc')->where('Code','like', $wxxx.'%')->where('Type',$type)->get();




                array_push($Array,[
                    'fixed_assets'=>trans('admin.fixed_assets'),

                ]);

                foreach($AccountsX as $row){

                    $SubTotalDeb=0;
                    $SubTotalCred=0;
                    $suby=0;
                    $subz=0;
                    $count=AcccountingManual::where('Parent',$row->id)->where('Type',1)->count();

                    if($count != 0){

                        $ASubs=AcccountingManual::where('Parent',$row->id)->where('Type',1)->get();


                        foreach($ASubs as $a){

                            $SubTotalDeb +=GeneralDaily::where('Account',$a->id)
                                ->where('Date','<=' , $to)
                                ->get()->sum('Debitor_Coin');


                            $SubTotalCred +=GeneralDaily::where('Account',$a->id)
                                ->where('Date','<=' , $to)
                                ->get()->sum('Creditor_Coin');

                        }

                        $x= $SubTotalDeb  -  $SubTotalCred  ;


                        if($x < 0){

                            $suby =0;
                            $subz =abs($x);

                        }else{

                            $suby =$x;
                            $subz =0;


                        }


                        if($lang == 'ar'){

                            array_push($Array,[
                                'name'=>$row->Name,
                                'debitor'=>number_format((float)abs($suby), 2, '.', ''),
                                'creditor'=>number_format((float)abs($subz), 2, '.', ''),

                            ]);
                        }else{
                            array_push($Array,[
                                'name'=>$row->NameEn,
                                'debitor'=>number_format((float)abs($suby), 2, '.', ''),
                                'creditor'=>number_format((float)abs($subz), 2, '.', ''),

                            ]);

                        }


                    }
                }



                array_push($Array,[
                    'traded_assets'=>trans('admin.traded_assets'),

                ]);



                foreach($AccountsXX as $row){

                    $SubTotalDeb=0;
                    $SubTotalCred=0;
                    $suby=0;
                    $subz=0;
                    $count=AcccountingManual::where('Parent',$row->id)->where('Type',1)->count();

                    if($count != 0){

                        $ASubs=AcccountingManual::where('Parent',$row->id)->where('Type',1)->get();


                        foreach($ASubs as $a){

                            $SubTotalDeb +=GeneralDaily::where('Account',$a->id)
                                ->where('Date','<=' , $to)
                                ->get()->sum('Debitor_Coin');


                            $SubTotalCred +=GeneralDaily::where('Account',$a->id)
                                ->where('Date','<=' , $to)
                                ->get()->sum('Creditor_Coin');

                        }

                        $x= $SubTotalDeb  -  $SubTotalCred  ;


                        if($x < 0){

                            $suby =0;
                            $subz =abs($x);

                        }else{

                            $suby =$x;
                            $subz =0;


                        }



                        if($lang == 'ar'){
                            array_push($Array,[
                                'name'=>$row->Name,
                                'debitor'=>number_format((float)abs($suby), 2, '.', ''),
                                'creditor'=>number_format((float)abs($subz), 2, '.', ''),

                            ]);
                        }else{
                            array_push($Array,[
                                'name'=>$row->NameEn,
                                'debitor'=>number_format((float)abs($suby), 2, '.', ''),
                                'creditor'=>number_format((float)abs($subz), 2, '.', ''),

                            ]);

                        }

                    }
                }



                array_push($Array,[
                    'other_assets'=>trans('admin.other_assets'),

                ]);

                foreach($AccountsXXX as $row){

                    $SubTotalDeb=0;
                    $SubTotalCred=0;
                    $suby=0;
                    $subz=0;
                    $count=AcccountingManual::where('Parent',$row->id)->where('Type',1)->count();

                    if($count != 0){

                        $ASubs=AcccountingManual::where('Parent',$row->id)->where('Type',1)->get();


                        foreach($ASubs as $a){

                            $SubTotalDeb +=GeneralDaily::where('Account',$a->id)
                                ->where('Date','<=' , $to)
                                ->get()->sum('Debitor_Coin');


                            $SubTotalCred +=GeneralDaily::where('Account',$a->id)
                                ->where('Date','<=' , $to)
                                ->get()->sum('Creditor_Coin');

                        }

                        $x= $SubTotalDeb  -  $SubTotalCred  ;


                        if($x < 0){

                            $suby =0;
                            $subz =abs($x);

                        }else{

                            $suby =$x;
                            $subz =0;


                        }



                        if($lang == 'ar'){
                            array_push($Array,[
                                'name'=>$row->Name,
                                'debitor'=>number_format((float)abs($suby), 2, '.', ''),
                                'creditor'=>number_format((float)abs($subz), 2, '.', ''),

                            ]);
                        }else{
                            array_push($Array,[
                                'name'=>$row->NameEn,
                                'debitor'=>number_format((float)abs($suby), 2, '.', ''),
                                'creditor'=>number_format((float)abs($subz), 2, '.', ''),

                            ]);

                        }

                    }
                }



            }








            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


    //FilterFinancial_CenterKhsoum
    public function FilterFinancial_CenterKhsoum(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if(!empty($admin)){
            $Array=array();

            $to = $request->get('To');
            $type = $request->get('Type');



            if($type == 1){
                $xT=0;
                $yT=0;
                $TotalTakloftD = 0;
                $TotalTakloftC = 0;
                $ATaklfa=AcccountingManual::where('id',16)->first();

                if($ATaklfa->Parent == 0){

                    $wordss=$ATaklfa->Code.'0';

                }else{

                    $wordss=$ATaklfa->Code;

                }

                $AccountsTakolfat = AcccountingManual::where('Code', 'like', $wordss.'%')
                    ->where('Type', 1)
                    ->get();


                foreach($AccountsTakolfat as $rowT)
                {


                    $TotalDeb =GeneralDaily::where('Account',$rowT->id)
                        ->where('Date','<=' , $to)
                        ->get()->sum('Debitor_Coin');


                    $TotalCred =GeneralDaily::where('Account',$rowT->id)
                        ->where('Date','<=' , $to)
                        ->get()->sum('Creditor_Coin');


                    $zT=$TotalDeb - $TotalCred ;

                    if($zT == 0){

                        $xT=0;
                        $yT=0;
                        $TotalTakloftD += 0;
                        $TotalTakloftC += 0;
                    }elseif($zT < 0){

                        $xT=0;
                        $yT=abs($zT);
                        $TotalTakloftD += 0;
                        $TotalTakloftC += abs($zT);

                    }elseif($zT > 0){

                        $xT=$zT;
                        $yT=0;
                        $TotalTakloftD += $zT;
                        $TotalTakloftC += 0;

                    }



                    if($lang == 'ar'){
                        array_push($Array,[
                            'name'=>$rowT->Name,
                            'debitor'=>number_format((float)abs($xT), 2, '.', ''),
                            'creditor'=>number_format((float)abs($yT), 2, '.', ''),


                        ]);
                    }else{

                        array_push($Array,[
                            'name'=>$rowT->NameEn,
                            'debitor'=>number_format((float)abs($xT), 2, '.', ''),
                            'creditor'=>number_format((float)abs($yT), 2, '.', ''),


                        ]);

                    }



                }


            }else{

                $wff=20;
                $wffx=2070;

                $AccountsT=AcccountingManual::orderBy('Code','asc')->where('Code','like', $wff.'%')->where('Type',$type)->get();
                $AccountsTT=AcccountingManual::orderBy('Code','asc')->where('Code','like', $wffx.'%')->where('Type',$type)->get();



                array_push($Array,[
                    'short_liabilities'=>trans('admin.short_liabilities'),



                ]);

                foreach($AccountsT as $row){

                    $SubTotalDeb=0;
                    $SubTotalCred=0;
                    $suby=0;
                    $subz=0;
                    $count=AcccountingManual::where('Parent',$row->id)->where('Type',1)->count();

                    if($count != 0){

                        $ASubs=AcccountingManual::where('Parent',$row->id)->where('Type',1)->get();


                        foreach($ASubs as $a){

                            $SubTotalDeb +=GeneralDaily::where('Account',$a->id)
                                ->where('Date','<=' , $to)
                                ->get()->sum('Debitor_Coin');


                            $SubTotalCred +=GeneralDaily::where('Account',$a->id)
                                ->where('Date','<=' , $to)
                                ->get()->sum('Creditor_Coin');

                        }

                        $x= $SubTotalDeb  -  $SubTotalCred  ;


                        if($x < 0){

                            $suby =0;
                            $subz =abs($x);

                        }else{

                            $suby =$x;
                            $subz =0;


                        }




                        if($lang == 'ar'){
                            array_push($Array,[
                                'name'=>$row->Name,
                                'debitor'=>number_format((float)abs($suby), 2, '.', ''),
                                'creditor'=>number_format((float)abs($subz), 2, '.', ''),


                            ]);
                        }else{

                            array_push($Array,[
                                'name'=>$row->NameEn,
                                'debitor'=>number_format((float)abs($suby), 2, '.', ''),
                                'creditor'=>number_format((float)abs($subz), 2, '.', ''),


                            ]);
                        }


                    }
                }


                foreach($AccountsTT as $row){

                    $SubTotalDeb=0;
                    $SubTotalCred=0;
                    $suby=0;
                    $subz=0;
                    $count=AcccountingManual::where('Parent',$row->id)->where('Type',1)->count();

                    if($count != 0){

                        $ASubs=AcccountingManual::where('Parent',$row->id)->where('Type',1)->get();


                        foreach($ASubs as $a){

                            $SubTotalDeb +=GeneralDaily::where('Account',$a->id)
                                ->where('Date','<=' , $to)
                                ->get()->sum('Debitor_Coin');


                            $SubTotalCred +=GeneralDaily::where('Account',$a->id)
                                ->where('Date','<=' , $to)
                                ->get()->sum('Creditor_Coin');

                        }

                        $x= $SubTotalDeb  -  $SubTotalCred  ;


                        if($x < 0){

                            $suby =0;
                            $subz =abs($x);

                        }else{

                            $suby =$x;
                            $subz =0;


                        }



                        if($lang == 'ar'){
                            array_push($Array,[
                                'name'=>$row->Name,
                                'debitor'=>number_format((float)abs($suby), 2, '.', ''),
                                'creditor'=>number_format((float)abs($subz), 2, '.', ''),


                            ]);
                        }else{
                            array_push($Array,[
                                'name'=>$row->NameEn,
                                'debitor'=>number_format((float)abs($suby), 2, '.', ''),
                                'creditor'=>number_format((float)abs($subz), 2, '.', ''),


                            ]);

                        }

                    }
                }



            }







            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


    //FilterFinancial_CenterHkook
    public function FilterFinancial_CenterHkook(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if(!empty($admin)){
            $Array=array();

            $to = $request->get('To');
            $type = $request->get('Type');



            if($type == 1){
                $xM=0;
                $yM=0;
                $TotalMsrofatD = 0;
                $TotalMsrofatC = 0;
                $AMsrfoat=AcccountingManual::where('id',17)->first();

                if($AMsrfoat->Parent == 0){

                    $wordsss=$AMsrfoat->Code.'0';

                }else{

                    $wordsss=$AMsrfoat->Code;

                }

                $AccountsMasrofat = AcccountingManual::where('Code', 'like', $wordsss.'%')
                    ->where('Type', 1)
                    ->get();

                foreach($AccountsMasrofat as $rowM)
                {


                    $TotalDeb =GeneralDaily::where('Account',$rowM->id)
                        ->where('Date','<=' , $to)
                        ->get()->sum('Debitor_Coin');


                    $TotalCred =GeneralDaily::where('Account',$rowM->id)
                        ->where('Date','<=' , $to)
                        ->get()->sum('Creditor_Coin');


                    $zM=$TotalDeb - $TotalCred ;

                    if($zM == 0){

                        $xM=0;
                        $yM=0;
                        $TotalMsrofatD += 0;
                        $TotalMsrofatC += 0;
                    }elseif($zM < 0){

                        $xM=0;
                        $yM=abs($zM);
                        $TotalMsrofatD += 0;
                        $TotalMsrofatC += abs($zM);

                    }elseif($zM > 0){

                        $xM=$zM;
                        $yM=0;
                        $TotalMsrofatD += $zM;
                        $TotalMsrofatC += 0;

                    }




                    if($lang == 'ar'){
                        array_push($Array,[
                            'name'=>$rowM->Name,
                            'debitor'=>number_format((float)abs($xM), 2, '.', ''),
                            'creditor'=>number_format((float)abs($yM), 2, '.', ''),


                        ]);

                    }else{
                        array_push($Array,[
                            'name'=>$rowM->NameEn,
                            'debitor'=>number_format((float)abs($xM), 2, '.', ''),
                            'creditor'=>number_format((float)abs($yM), 2, '.', ''),


                        ]);

                    }


                }


            }else{
                $wfff=30;
                $AccountsF=AcccountingManual::orderBy('Code','asc')->where('Code','like', $wfff.'%')->where('Type',$type)->get();


                foreach($AccountsF as $row){

                    $SubTotalDeb=0;
                    $SubTotalCred=0;
                    $suby=0;
                    $subz=0;
                    $count=AcccountingManual::where('Parent',$row->id)->where('Type',1)->count();



                    if($count != 0){

                        $ASubs=AcccountingManual::where('Parent',$row->id)->where('Type',1)->get();

                        foreach($ASubs as $a){


                            $SubTotalDeb +=GeneralDaily::where('Account',$a->id)
                                ->where('Date','<=' , $to)
                                ->get()->sum('Debitor_Coin');


                            $SubTotalCred +=GeneralDaily::where('Account',$a->id)
                                ->where('Date','<=' , $to)
                                ->get()->sum('Creditor_Coin');

                        }



                        $x= $SubTotalDeb  -  $SubTotalCred  ;


                        if($x < 0){

                            $suby =0;
                            $subz =abs($x);

                        }else{

                            $suby =$x;
                            $subz =0;


                        }



                        if($lang == 'ar'){
                            array_push($Array,[
                                'name'=>$row->Name,
                                'debitor'=>number_format((float)abs($suby), 2, '.', ''),
                                'creditor'=>number_format((float)abs($subz), 2, '.', ''),


                            ]);
                        }else{
                            array_push($Array,[
                                'name'=>$row->NameEn,
                                'debitor'=>number_format((float)abs($suby), 2, '.', ''),
                                'creditor'=>number_format((float)abs($subz), 2, '.', ''),


                            ]);

                        }


                    }
                }

            }








            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }



    //=================================================


    //FilterIncom_ListNew =======================

    public function FilterIncom_ListNew(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();

        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $type = $request->get('Type');

            //   =============  Erydaat   ===========
            $AEryd=AcccountingManual::where('id',18)->first();


            if($AEryd->Parent == 0){

                $words=$AEryd->Code.'0';

            }else{

                $words=$AEryd->Code;

            }


            $egmalymby3atDa2n=GeneralDaily::where('Account',48)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Creditor_Coin');
            $egmalymby3atMadeen=GeneralDaily::where('Account',48)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Debitor_Coin');

            $egmalymrdodatDa2n=GeneralDaily::where('Account',49)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Creditor_Coin');

            $egmalymrdodatMadeen=GeneralDaily::where('Account',49)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Debitor_Coin');

            $safy = abs($egmalymby3atDa2n - $egmalymby3atMadeen) -  abs($egmalymrdodatDa2n - $egmalymrdodatMadeen);


            $TotalDebErydat = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $from = request('From');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->whereBetween('general_dailies.Date',[$from,$to]);
                })

                ->where('acccounting_manuals.Code', 'like', $words.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Debitor_Coin');



            $TotalCredErydat = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $from = request('From');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->whereBetween('general_dailies.Date',[$from,$to]);
                })

                ->where('acccounting_manuals.Code', 'like', $words.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Creditor_Coin');



            $EgmalyErydaat=  $TotalCredErydat -  $TotalDebErydat ;


            $ATaklfa=AcccountingManual::where('id',19)->first();

            if($ATaklfa->Parent == 0){

                $wordss=$ATaklfa->Code.'0';

            }else{

                $wordss=$ATaklfa->Code;

            }


            $TotalDebTaklfa = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $from = request('From');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->whereBetween('general_dailies.Date',[$from,$to]);
                })

                ->where('acccounting_manuals.Code', 'like', $wordss.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Debitor_Coin');



            $TotalCredTaklfa = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $from = request('From');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->whereBetween('general_dailies.Date',[$from,$to]);
                })

                ->where('acccounting_manuals.Code', 'like', $wordss.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Creditor_Coin');



            $EgmalyTaklfa=  $TotalDebTaklfa -  $TotalCredTaklfa ;

            $Mogml = $EgmalyErydaat   -  $EgmalyTaklfa   ;


            $AMsrfoat=AcccountingManual::where('id',20)->first();

            if($AMsrfoat->Parent == 0){

                $wordsss=$AMsrfoat->Code.'0';

            }else{

                $wordsss=$AMsrfoat->Code;

            }

            $TotalDebMasrofat = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $from = request('From');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->whereBetween('general_dailies.Date',[$from,$to]);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Debitor_Coin');



            $TotalCredMasrofat = DB::table('acccounting_manuals')
                ->join('general_dailies', function ($join) {

                    $to = request('To');
                    $from = request('From');
                    $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                        ->whereBetween('general_dailies.Date',[$from,$to]);
                })

                ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
                ->where('acccounting_manuals.Type',  '=',1)
                ->get()->sum('Creditor_Coin');



            $EgmalyMasrofat=  $TotalDebMasrofat -  $TotalCredMasrofat ;


            $fg= $EgmalyTaklfa + $EgmalyMasrofat;
            if($EgmalyErydaat >  $fg){
                if($fg  <  0 ){

                    $SafyRab7 =$EgmalyErydaat + ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;
                }else{

                    $SafyRab7 = $EgmalyErydaat -  ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;

                }
            }elseif($EgmalyErydaat <  $fg){

                if($fg  <  0 ){

                    $SafyRab7 =$EgmalyErydaat + ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;
                }else{

                    $SafyRab7 = $EgmalyErydaat -  ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;

                }


            }elseif($EgmalyErydaat ==  $fg){

                $SafyRab7 = $EgmalyErydaat -  ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;

            }

            array_push($Array,[
                'revenues'=>$AEryd->Name,
                'net_sales'=>number_format((float)($safy), 2, '.', ''),
                'total_revenues'=>number_format((float)($EgmalyErydaat), 2, '.', ''),
                'sales_cost'=>$ATaklfa->Name,
                'total_sales_cost'=>number_format((float)($EgmalyTaklfa), 2, '.', ''),
                'gross_profit_loss'=>number_format((float)($Mogml), 2, '.', ''),
                'expenses'=>$AMsrfoat->Name,
                'total_expenses'=>number_format((float)($EgmalyMasrofat), 2, '.', ''),
                'net_profit_loss'=>number_format((float)($SafyRab7), 2, '.', ''),

            ]);



            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


//FilterIncom_ListErydat
    public function FilterIncom_ListErydat(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $type = $request->get('Type');



            if($type == 1){
                $x=0;
                $y=0;
                $TotalErydatD = 0;
                $TotalErydatC = 0;

                $AEryd=AcccountingManual::where('id',18)->first();

                if($AEryd->Parent == 0){

                    $words=$AEryd->Code.'0';

                }else{

                    $words=$AEryd->Code;

                }

                $AccountsErydat = AcccountingManual::where('Code', 'like', $words.'%')
                    ->where('Type', 1)
                    ->get();



                foreach($AccountsErydat as $row)
                {


                    $TotalDeb =GeneralDaily::where('Account',$row->id)
                        ->whereBetween('Date', [$from, $to])
                        ->get()->sum('Debitor_Coin');


                    $TotalCred =GeneralDaily::where('Account',$row->id)
                        ->whereBetween('Date', [$from, $to])
                        ->get()->sum('Creditor_Coin');


                    $z=$TotalDeb - $TotalCred ;

                    if($z == 0){

                        $x=0;
                        $y=0;
                        $TotalErydatD += 0;
                        $TotalErydatC += 0;
                    }elseif($z < 0){

                        $x=0;
                        $y=abs($z);
                        $TotalErydatD += 0;
                        $TotalErydatC += abs($z);

                    }elseif($z > 0){

                        $x=$z;
                        $y=0;
                        $TotalErydatD += $z;
                        $TotalErydatC += 0;

                    }



                    if($lang == 'ar'){
                        array_push($Array,[
                            'name'=>$row->Name,
                            'debitor'=>number_format((float)($x), 2, '.', ''),
                            'creditor'=>number_format((float)($y), 2, '.', ''),


                        ]);
                    }else{

                        array_push($Array,[
                            'name'=>$row->NameEn,
                            'debitor'=>number_format((float)($x), 2, '.', ''),
                            'creditor'=>number_format((float)($y), 2, '.', ''),


                        ]);

                    }


                }




            }else{

                $wf=40;
                $Accounts=AcccountingManual::orderBy('Code','asc')
                    ->where('Code','like', $wf.'%')
                    ->where('Type',$type)->get();

                foreach($Accounts as $row){

                    $SubTotalDeb=0;
                    $SubTotalCred=0;
                    $suby=0;
                    $subz=0;
                    $count=AcccountingManual::where('Parent',$row->id)->where('Type',1)->count();

                    if($count != 0){

                        $ASubs=AcccountingManual::where('Parent',$row->id)->where('Type',1)->get();


                        foreach($ASubs as $a){

                            $SubTotalDeb +=GeneralDaily::where('Account',$a->id)
                                ->whereBetween('Date', [$from, $to])
                                ->get()->sum('Debitor_Coin');


                            $SubTotalCred +=GeneralDaily::where('Account',$a->id)
                                ->whereBetween('Date', [$from, $to])
                                ->get()->sum('Creditor_Coin');

                        }

                        $x= $SubTotalDeb  -  $SubTotalCred  ;


                        if($x < 0){

                            $suby =0;
                            $subz =abs($x);

                        }else{

                            $suby =$x;
                            $subz =0;


                        }



                        if($lang == 'ar'){
                            array_push($Array,[
                                'name'=>$row->Name,
                                'debitor'=>number_format((float)($suby), 2, '.', ''),
                                'creditor'=>number_format((float)($subz), 2, '.', ''),


                            ]);
                        }else{
                            array_push($Array,[
                                'name'=>$row->NameEn,
                                'debitor'=>number_format((float)($suby), 2, '.', ''),
                                'creditor'=>number_format((float)($subz), 2, '.', ''),


                            ]);

                        }


                    }
                }


            }







            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


//FilterIncom_ListTaklfa
    public function FilterIncom_ListTaklfa(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $type = $request->get('Type');


            if($type == 1){

                $xT=0;
                $yT=0;
                $TotalTakloftD = 0;
                $TotalTakloftC = 0;

                $ATaklfa=AcccountingManual::where('id',19)->first();

                if($ATaklfa->Parent == 0){

                    $wordss=$ATaklfa->Code.'0';

                }else{

                    $wordss=$ATaklfa->Code;

                }

                $AccountsTakolfat = AcccountingManual::where('Code', 'like', $wordss.'%')
                    ->where('Type', 1)
                    ->get();


                foreach($AccountsTakolfat as $rowT)
                {


                    $TotalDeb =GeneralDaily::where('Account',$rowT->id)
                        ->whereBetween('Date', [$from, $to])
                        ->get()->sum('Debitor_Coin');


                    $TotalCred =GeneralDaily::where('Account',$rowT->id)
                        ->whereBetween('Date', [$from, $to])
                        ->get()->sum('Creditor_Coin');


                    $zT=$TotalDeb - $TotalCred ;

                    if($zT == 0){

                        $xT=0;
                        $yT=0;
                        $TotalTakloftD += 0;
                        $TotalTakloftC += 0;
                    }elseif($zT < 0){

                        $xT=0;
                        $yT=abs($zT);
                        $TotalTakloftD += 0;
                        $TotalTakloftC += abs($zT);

                    }elseif($zT > 0){

                        $xT=$zT;
                        $yT=0;
                        $TotalTakloftD += $zT;
                        $TotalTakloftC += 0;

                    }




                    if($lang == 'ar'){
                        array_push($Array,[
                            'name'=>$rowT->Name,
                            'debitor'=>number_format((float)($xT), 2, '.', ''),
                            'creditor'=>number_format((float)($yT), 2, '.', ''),


                        ]);
                    }else{

                        array_push($Array,[
                            'name'=>$rowT->NameEn,
                            'debitor'=>number_format((float)($xT), 2, '.', ''),
                            'creditor'=>number_format((float)($yT), 2, '.', ''),


                        ]);
                    }


                }




            }else{


                $wff=50;


                $AccountsT=AcccountingManual::orderBy('Code','asc')
                    ->where('Code','like', $wff.'%')
                    ->where('Type',$type)->get();


                foreach($AccountsT as $row){

                    $SubTotalDeb=0;
                    $SubTotalCred=0;
                    $suby=0;
                    $subz=0;
                    $count=AcccountingManual::where('Parent',$row->id)->where('Type',1)->count();

                    if($count != 0){

                        $ASubs=AcccountingManual::where('Parent',$row->id)->where('Type',1)->get();


                        foreach($ASubs as $a){

                            $SubTotalDeb +=GeneralDaily::where('Account',$a->id)
                                ->whereBetween('Date', [$from, $to])
                                ->get()->sum('Debitor_Coin');


                            $SubTotalCred +=GeneralDaily::where('Account',$a->id)
                                ->whereBetween('Date', [$from, $to])
                                ->get()->sum('Creditor_Coin');

                        }

                        $x= $SubTotalDeb  -  $SubTotalCred  ;


                        if($x < 0){

                            $suby =0;
                            $subz =abs($x);

                        }else{

                            $suby =$x;
                            $subz =0;


                        }




                        if($lang == 'ar'){
                            array_push($Array,[
                                'name'=>$row->Name,
                                'debitor'=>number_format((float)($suby), 2, '.', ''),
                                'creditor'=>number_format((float)($subz), 2, '.', ''),


                            ]);
                        }else{
                            array_push($Array,[
                                'name'=>$row->NameEn,
                                'debitor'=>number_format((float)($suby), 2, '.', ''),
                                'creditor'=>number_format((float)($subz), 2, '.', ''),


                            ]);

                        }



                    }
                }

            }







            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


//FilterIncom_ListMasrofat
    public function FilterIncom_ListMasrofat(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $type = $request->get('Type');

            if($type == 1){

                $xM=0;
                $yM=0;
                $TotalMsrofatD = 0;
                $TotalMsrofatC = 0;

                $AMsrfoat=AcccountingManual::where('id',20)->first();

                if($AMsrfoat->Parent == 0){

                    $wordsss=$AMsrfoat->Code.'0';

                }else{

                    $wordsss=$AMsrfoat->Code;

                }

                $AccountsMasrofat = AcccountingManual::where('Code', 'like', $wordsss.'%')
                    ->where('Type', 1)
                    ->get();



                foreach($AccountsMasrofat as $rowM)
                {


                    $TotalDeb =GeneralDaily::where('Account',$rowM->id)
                        ->whereBetween('Date', [$from, $to])
                        ->get()->sum('Debitor_Coin');


                    $TotalCred =GeneralDaily::where('Account',$rowM->id)
                        ->whereBetween('Date', [$from, $to])
                        ->get()->sum('Creditor_Coin');


                    $zM=$TotalDeb - $TotalCred ;

                    if($zM == 0){

                        $xM=0;
                        $yM=0;
                        $TotalMsrofatD += 0;
                        $TotalMsrofatC += 0;
                    }elseif($zM < 0){

                        $xM=0;
                        $yM=abs($zM);
                        $TotalMsrofatD += 0;
                        $TotalMsrofatC += abs($zM);

                    }elseif($zM > 0){

                        $xM=$zM;
                        $yM=0;
                        $TotalMsrofatD += $zM;
                        $TotalMsrofatC += 0;

                    }


                    if($lang == 'ar'){
                        array_push($Array,[
                            'name'=>$rowM->Name,
                            'debitor'=>number_format((float)($xM), 2, '.', ''),
                            'creditor'=>number_format((float)($yM), 2, '.', ''),


                        ]);
                    }else{
                        array_push($Array,[
                            'name'=>$rowM->NameEn,
                            'debitor'=>number_format((float)($xM), 2, '.', ''),
                            'creditor'=>number_format((float)($yM), 2, '.', ''),


                        ]);

                    }


                }




            }else{

                $wfff=60;

                $AccountsF=AcccountingManual::orderBy('Code','asc')
                    ->where('Code','like', $wfff.'%')
                    ->where('Type',$type)->get();


                foreach($AccountsF as $row){

                    $SubTotalDeb=0;
                    $SubTotalCred=0;
                    $suby=0;
                    $subz=0;
                    $count=AcccountingManual::where('Parent',$row->id)->where('Type',1)->count();

                    if($count != 0){

                        $ASubs=AcccountingManual::where('Parent',$row->id)->where('Type',1)->get();


                        foreach($ASubs as $a){

                            $SubTotalDeb +=GeneralDaily::where('Account',$a->id)
                                ->whereBetween('Date', [$from, $to])
                                ->get()->sum('Debitor_Coin');


                            $SubTotalCred +=GeneralDaily::where('Account',$a->id)
                                ->whereBetween('Date', [$from, $to])
                                ->get()->sum('Creditor_Coin');

                        }

                        $x= $SubTotalDeb  -  $SubTotalCred  ;


                        if($x < 0){

                            $suby =0;
                            $subz =abs($x);

                        }else{

                            $suby =$x;
                            $subz =0;


                        }




                        if($lang == 'ar'){
                            array_push($Array,[
                                'name'=>$row->Name,
                                'debitor'=>number_format((float)($suby), 2, '.', ''),
                                'creditor'=>number_format((float)($subz), 2, '.', ''),


                            ]);
                        }else{

                            array_push($Array,[
                                'name'=>$row->NameEn,
                                'debitor'=>number_format((float)($suby), 2, '.', ''),
                                'creditor'=>number_format((float)($subz), 2, '.', ''),


                            ]);

                        }

                    }
                }



            }








            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


    //===========================================


//===============================  Supply Chain  ====================================================

//StoresCostApi
    public function StoresCostApi(Request $request){

        $search = $request->get('search');
        $store = $request->get('store');
        $group = $request->get('group');
        $Zero = $request->get('zero');

        if($Zero == 0){
            $Prods=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                        ;
                })
                ->where('Store',$store)
                ->paginate(50);
        }else{
            $Prods=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->where('Qty','!=',0)
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                        ;
                })
                ->where('Store',$store)
                ->paginate(50);
        }


        if($Zero == 0){
            $Products_Num=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->count();



            $Total_Qty=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('Qty');

            $Total_Cost=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('TotalCost');
        }else{

            $Products_Num=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->where('Qty','!=',0)
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->count();



            $Total_Qty=ProductsQty::where('Qty','!=',0)->whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('Qty');

            $Total_Cost=ProductsQty::where('Qty','!=',0)->whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('TotalCost');


        }


        $data=StoresCostResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'products_number'=>$Products_Num,
            'total_qty'=>$Total_Qty,
            'total_cost'=>$Total_Cost,
        ];

        return $data->additional($x) ;


    }

//ProductsReportsApi
    public function ProductsReportsApi(Request $request){

        $search = $request->get('search');
        $Brand = $request->get('brand');
        $Group = $request->get('group');
        $store = $request->get('store');

        $Prods=
            ProductsQty::orderBy('id','asc')

                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")

                        ;
                })

                ->when(!empty($store), function ($query) use ($store) {
                    return $query->where('Store',$store);

                })
                ->when(!empty($Group), function ($query) use ($Group) {
                    return $query->whereRelation('Product','Group',$Group);

                })


                ->when(!empty($Brand), function ($query) use ($Brand) {
                    return $query->whereRelation('Product','Brand',$Brand);

                })

                ->paginate(100);

        $data=StoresCostResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),

        ];

        return $data->additional($x) ;


    }

    //AllStoresCostApi
    public function AllStoresCostApi(Request $request){



        $store=$request->get('store');
        $group=$request->get('group');
        $brand=$request->get('brand');
        $branch=$request->get('branch');
        $product_Name=$request->get('product_Name');
        $product_Code=$request->get('product_Code');
        $zeros=$request->get('zeros');



        if($zeros == 0){
            $items=ProductsQty::

            when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })

                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })

                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name', $product_Name);
                })


                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->distinct(['Product'])->paginate(30);

        }else{
            $items=ProductsQty::where('Qty','!=',0)

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })
                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name', $product_Name);
                })


                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->distinct(['Product'])->paginate(30);

        }


        $Products_Num=ProductsQty::where('Qty','!=',0)

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->count();

        $Total_Qty=ProductsQty::where('Qty','!=',0)

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('Qty');


        $Total_Cost=ProductsQty::where('Qty','!=',0)

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('TotalCost');


        $data=StoresCostResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'products_number'=>$Products_Num,
            'total_qty'=>$Total_Qty,
            'total_cost'=>$Total_Cost,
        ];

        return $data->additional($x) ;


    }

    //ItemCostApi
    public function ItemCostApi(Request $request){



        $store=$request->get('store');
        $group=$request->get('group');
        $brand=$request->get('brand');
        $branch=$request->get('branch');
        $product_Name=$request->get('product_Name');
        $product_Code=$request->get('product_Code');
        $zeros=$request->get('zeros');



        if($zeros == 0){
            $items=ProductsQty::

            when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })

                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })

                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name', $product_Name);
                })


                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->distinct(['Product'])->paginate(30);

        }else{
            $items=ProductsQty::where('Qty','!=',0)

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })
                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name', $product_Name);
                })


                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->distinct(['Product'])->paginate(30);

        }


        $Products_Num=ProductsQty::where('Qty','!=',0)

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->count();

        $Total_Qty=ProductsQty::where('Qty','!=',0)

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('Qty');


        $Total_Cost=ProductsQty::where('Qty','!=',0)

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('TotalCost');


        $data=StoresCostResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'products_number'=>$Products_Num,
            'total_qty'=>$Total_Qty,
            'total_cost'=>$Total_Cost,
        ];

        return $data->additional($x) ;


    }


    //StoresQtiesReportApi
    public function StoresQtiesReportApi(Request $request){

        $search = $request->get('search');
        $store = $request->get('store');
        $group = $request->get('group');
        $Zero = $request->get('zero');

        if($Zero == 0){
            $Prods=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                        ;
                })
                ->where('Store',$store)
                ->paginate(50);
        }else{
            $Prods=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->where('Qty','!=',0)
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                        ;
                })
                ->where('Store',$store)
                ->paginate(50);
        }


        if($Zero == 0){
            $Products_Num=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->count();



            $Total_Qty=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('Qty');

            $Total_Cost=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('TotalCost');
        }else{

            $Products_Num=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->where('Qty','!=',0)
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->count();



            $Total_Qty=ProductsQty::where('Qty','!=',0)->whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('Qty');

            $Total_Cost=ProductsQty::where('Qty','!=',0)->whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group', $group);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('TotalCost');


        }


        $data=StoresCostResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'products_number'=>$Products_Num,
            'total_qty'=>$Total_Qty,
            'total_cost'=>$Total_Cost,
        ];

        return $data->additional($x) ;


    }


//====

//StoresInventoryApi
    public function StoresInventoryApi(Request $request){

        $search = $request->get('search');
        $store = $request->get('store');
        $group = $request->get('group');
        $brand = $request->get('brand');
        $Zero = $request->get('zero');

        if($Zero == 0){
            $Prods=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })

                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereRelation('Product','Brand', $brand);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                        ;
                })
                ->where('Store',$store)
                ->paginate(50);
        }else{
            $Prods=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->where('Qty','!=',0)
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })

                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereRelation('Product','Brand', $brand);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                        ;
                })
                ->where('Store',$store)
                ->paginate(50);
        }


        if($Zero == 0){
            $Products_Num=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })

                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereRelation('Product','Brand', $brand);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->count();



            $Total_Qty=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })

                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereRelation('Product','Brand', $brand);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('Qty');

            $Total_Cost=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })

                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereRelation('Product','Brand', $brand);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('TotalCost');
        }else{

            $Products_Num=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->where('Qty','!=',0)
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })

                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereRelation('Product','Brand', $brand);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->count();



            $Total_Qty=ProductsQty::where('Qty','!=',0)->whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })

                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereRelation('Product','Brand', $brand);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('Qty');

            $Total_Cost=ProductsQty::where('Qty','!=',0)->whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })

                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereRelation('Product','Brand', $brand);
                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('TotalCost');


        }


        $data=StoresCostResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'products_number'=>$Products_Num,
            'total_qty'=>$Total_Qty,
            'total_cost'=>$Total_Cost,
        ];

        return $data->additional($x) ;


    }


    //StoresInventoryNewApi
    public function StoresInventoryNewApi(Request $request){

        $store=$request->get('store');
        $group=$request->get('group');
        $brand=$request->get('brand');
        $branch=$request->get('branch');
        $product_Name=$request->get('product_Name');
        $product_Code=$request->get('product_Code');
        $zero=$request->get('zero');

        if($zero == 0){

            $items=ProductsQty::
            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);
            })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })
                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })
                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })
                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
                })
                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->distinct(['Product'])->paginate(100);





            $Products_Num=ProductsQty::
            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);
            })



                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
                })


                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->count();



            $Total_Qty=ProductsQty::
            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);
            })



                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
                })


                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->get()->sum('Qty');


            $Total_Cost=ProductsQty::
            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);
            })



                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
                })


                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->get()->sum('TotalCost');


        }else{

            $items=ProductsQty::where('Qty','!=',0)
                ->when(!empty($store), function ($query) use ($store) {
                    return $query->where('Store',$store);
                })



                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
                })


                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->distinct(['Product'])->paginate(100);





            $Products_Num=ProductsQty::where('Qty','!=',0)
                ->when(!empty($store), function ($query) use ($store) {
                    return $query->where('Store',$store);
                })



                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
                })


                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->count();



            $Total_Qty=ProductsQty::where('Qty','!=',0)
                ->when(!empty($store), function ($query) use ($store) {
                    return $query->where('Store',$store);
                })



                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
                })


                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->get()->sum('Qty');


            $Total_Cost=ProductsQty::where('Qty','!=',0)
                ->when(!empty($store), function ($query) use ($store) {
                    return $query->where('Store',$store);
                })



                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$product_Name}%" );
                })


                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->get()->sum('TotalCost');


        }

        $data=StoresCostResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'products_number'=>$Products_Num,
            'total_qty'=>$Total_Qty,
            'total_cost'=>$Total_Cost,

        ];

        return $data->additional($x) ;


    }


    //CreditStoresNewApi
    public function CreditStoresNewApi(Request $request){

        $search = $request->get('search');
        $store = $request->get('store');
        $group = $request->get('group');
        $Zero = $request->get('zero');

        if($Zero == 0){
            $Prods=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })


                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                        ;
                })
                ->where('Store',$store)
                ->paginate(50);
        }else{
            $Prods=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->where('Qty','!=',0)
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })


                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                        ;
                })
                ->where('Store',$store)
                ->paginate(50);
        }


        if($Zero == 0){
            $Products_Num=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })


                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->count();



            $Total_Qty=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })


                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('Qty');

            $Total_Cost=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })


                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('TotalCost');
        }else{

            $Products_Num=ProductsQty::whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->where('Qty','!=',0)
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })


                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->count();



            $Total_Qty=ProductsQty::where('Qty','!=',0)->whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })


                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('Qty');

            $Total_Cost=ProductsQty::where('Qty','!=',0)->whereRelation('Product', 'Status', 0)
                ->whereRelation('Product',function ($query)  {

                    $query->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group', $group);
                })


                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%" )->orWhere('P_Code','ILIKE', "%{$search}%");
                })
                ->where('Store',$store)
                ->get()->sum('TotalCost');


        }


        $data=StoresCostResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'products_number'=>$Products_Num,
            'total_qty'=>$Total_Qty,
            'total_cost'=>$Total_Cost,
        ];

        return $data->additional($x) ;


    }


//StoresBalancesNewApi
    public function StoresBalancesNewApi(Request $request){



        $store=$request->get('store');
        $group=$request->get('group');
        $brand=$request->get('brand');
        $branch=$request->get('branch');
        $product_Name=$request->get('product_Name');
        $product_Code=$request->get('product_Code');
        $zeros=$request->get('zeros');



        if($zeros == 0){
            $items=ProductsQty::

            when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })

                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })

                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name', $product_Name);
                })


                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->distinct(['Product'])->paginate(30);

        }else{
            $items=ProductsQty::where('Qty','!=',0)

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })
                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($product_Name), function ($query) use ($product_Name) {
                    return $query->where('P_Ar_Name', $product_Name);
                })


                ->when(!empty($product_Code), function ($query) use ($product_Code) {
                    return $query->where('P_Code', $product_Code);
                })
                ->distinct(['Product'])->paginate(30);

        }


        $Products_Num=ProductsQty::where('Qty','!=',0)

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->count();

        $Total_Qty=ProductsQty::where('Qty','!=',0)

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('Qty');


        $Total_Cost=ProductsQty::where('Qty','!=',0)

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('TotalCost');


        $data=StoresCostResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'products_number'=>$Products_Num,
            'total_qty'=>$Total_Qty,
            'total_cost'=>$Total_Cost,
        ];

        return $data->additional($x) ;


    }


    //AssemblyProQtiesFilterApi
    public function AssemblyProQtiesFilterApi(Request $request){

        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $Zero = $request->get('Zero');


        if(!empty($search)){



            if(!empty($group)){
                $data =ProductUnits::
                orWhere('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('Barcode','ILIKE', "%{$search}%")
                    ->where('P_Type','Assembly')
                    ->where('Group',$group)
                    ->paginate(20);
            }else{
                $data =ProductUnits::
                orWhere('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('Barcode','ILIKE', "%{$search}%")
                    ->where('P_Type','Assembly')
                    ->paginate(20);
            }





        }else{





            if(!empty($group)){
                $data =ProductUnits::
                where('P_Type','Assembly')
                    ->where('Group',$group)
                    ->paginate(20);
            }else{
                $data =ProductUnits::
                where('P_Type','Assembly')
                    ->paginate(20);
            }




        }




        $data=AssemblyProQtiesFilterApiResources::collection($data);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),

        ];

        return $data->additional($x) ;


    }

//InventorySerialApi
    public function InventorySerialApi(Request $request){


        $Group=$request->get('group');
        $Brand=$request->get('brand');
        $Product_Name=$request->get('product_Name');
        $Product_Code=$request->get('product_Code');


        $items=ProductUnits::where('P_Type','Serial')

            ->when(!empty($Group), function ($query) use ($Group) {
                return $query->whereIn('Group', $Group);
            })


            ->when(!empty($Brand), function ($query) use ($Brand) {
                return $query->whereIn('Brand', $Brand);
            })
            ->when(!empty($Product_Name), function ($query) use ($Product_Name) {
                return $query->where('P_Ar_Name','ILIKE', "%{$Product_Name}%");
            })

            ->when(!empty($Product_Code), function ($query) use ($Product_Code) {
                return $query->where('Barcode','ILIKE', "%{$Product_Code}%");
            })

            ->paginate(10);


        $data=InventorySerialApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;


    }

//HoldQtiesReportApi
    public function HoldQtiesReportApi(Request $request){

        $search = $request->get('search');
        $store = $request->get('store');
        $group = $request->get('group');

        $Prods=ProductsQty::where('Hold_Qty','!=',0)

            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store', $store);
            })

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })

            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_Code','ILIKE', "%{$search}%")
                    ->orWhere('PP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                    ;
            })

            ->paginate(10);


        $data=HoldQtiesReportApiResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),

        ];

        return $data->additional($x) ;


    }


//=====

//ItemsMovesApi
    public function ItemsMovesApi(Request $request){

        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $From = $request->get('From');
        $To = $request->get('To');
        $User = $request->get('User');
        $Type = $request->get('Type');


        $Prods=ProductMoves::whereBetween('Date', [$From,$To])

            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_Code','ILIKE', "%{$search}%")

                    ;

            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);

            })

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereRelation('Product','Group', $group);

            })


            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->where('Type',$Type);

            })


            ->when(!empty($User), function ($query) use ($User) {
                return $query->where('User',$User);

            })

            ->latest('id')
            ->paginate(50);

        $data=ItemsMovesApiResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),

        ];

        return $data->additional($x) ;


    }

//ProductMoveDetailsFilterNewwApi
    public function ProductMoveDetailsFilterNewwApi(Request $request){

        $from=$request->get('from');
        $to=$request->get('to');
        $store=$request->get('store');
        $type=$request->get('type');
        $safe=$request->get('safe');
        $group=$request->get('group');
        $brand=$request->get('brand');
        $user=$request->get('user');
        $branch=$request->get('branch');
        $product_Name=$request->get('product_Name');
        $product_Code=$request->get('product_Code');
        $payment_method=$request->get('payment_method');

        $items=ProductMoves::orderBy('id','desc')->whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store',$store);
            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->whereIn('Type', $type);
            })

            ->when(!empty($payment_method), function ($query) use ($payment_method) {
                return $query->whereIn('Payment_Method', $payment_method);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->paginate(50);

        $CostIn=ProductMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })
            ->when(!empty($type), function ($query) use ($type) {
                return $query->whereIn('Type', $type);
            })

            ->when(!empty($payment_method), function ($query) use ($payment_method) {
                return $query->whereIn('Payment_Method', $payment_method);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('Incom');


        $CostOut=ProductMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })
            ->when(!empty($type), function ($query) use ($type) {
                return $query->whereIn('Type', $type);
            })
            ->when(!empty($payment_method), function ($query) use ($payment_method) {
                return $query->whereIn('Payment_Method', $payment_method);
            })


            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('Outcom');



        $Credit=$CostIn -  $CostOut ;


        $Bills_Nums=ProductMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })
            ->when(!empty($type), function ($query) use ($type) {
                return $query->whereIn('Type', $type);
            })
            ->when(!empty($payment_method), function ($query) use ($payment_method) {
                return $query->whereIn('Payment_Method', $payment_method);
            })


            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->count();

        $data=ItemsMovesApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'CostIn'=>$CostIn,
            'CostOut'=>$CostOut,
            'Credit'=>$Credit,
            'Bills_Nums'=>$Bills_Nums,

        ];

        return $data->additional($x) ;


    }

//StoresBalancesApi
    public function StoresBalancesApi(Request $request){


        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $From = $request->get('From');
        $To = $request->get('To');


        $Prods=ProductMoves::whereBetween('Date', [$From,$To])

            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);

            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereRelation('Product','Group', $group);
            })

            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_Code','ILIKE', "%{$search}%")

                    ;

            })

            ->paginate(10);


        $data=StoresBalancesApiResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),

        ];

        return $data->additional($x) ;


    }

//StoresMovesReportApi
    public function StoresMovesReportApi(Request $request){
        $from=$request->get('from');
        $to=$request->get('to');
        $branch=$request->get('branch');
        $store=$request->get('store');
        $safe=$request->get('safe');
        $account=$request->get('account');
        $type=$request->get('type');
        $user=$request->get('user');
        $shipping_Company=$request->get('shipping_Company');
        $cost_Center=$request->get('cost_Center');
        $coin=$request->get('coin');
        $sadr=$request->get('sadr');
        $ward=$request->get('ward');




        $items=StoresMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch',$branch);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->whereIn('Type', $type);
            })


            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('Account', $account);
            })


            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })
            ->paginate(10);



        $Bills_Nums=StoresMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch',$branch);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->whereIn('Type', $type);
            })


            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('Account', $account);
            })


            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })
            ->count();


        $Total_Sadr=StoresMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch',$branch);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($sadr), function ($query) use ($sadr) {
                return $query->whereIn('Type', $sadr);
            })


            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('Account', $account);
            })


            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })
            ->get()->sum('Total_Qty');


        $Total_Ward=StoresMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch',$branch);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($ward), function ($query) use ($ward) {
                return $query->whereIn('Type', $ward);
            })


            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('Account', $account);
            })


            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })
            ->get()->sum('Total_Qty');


        $Total_Price_Sadr=StoresMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch',$branch);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($sadr), function ($query) use ($sadr) {
                return $query->whereIn('Type', $sadr);
            })


            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('Account', $account);
            })


            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })
            ->get()->sum('Total_Price');


        $Total_Price_Ward=StoresMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch',$branch);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($ward), function ($query) use ($ward) {
                return $query->whereIn('Type', $ward);
            })


            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($account), function ($query) use ($account) {
                return $query->whereIn('Account', $account);
            })


            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })
            ->get()->sum('Total_Price');

        $CreditQty=$Total_Ward - $Total_Sadr ;
        $CreditPrice=$Total_Price_Ward - $Total_Price_Sadr ;

        $data=StoresMovesReportApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'CreditQty'=>$CreditQty,
            'CreditPrice'=>$CreditPrice,
            'Bills_Nums'=>$Bills_Nums,

        ];

        return $data->additional($x) ;


    }

    //======

    //ProductProfitsNewApi
    public function ProductProfitsNewApi(Request $request){

        $search = $request->get('search');
        $store = $request->get('Store');

        $From = $request->get('From');
        $To = $request->get('To');
        $Client = $request->get('Client');
        $Safe = $request->get('Safe');
        $Payment_Method = $request->get('Payment_Method');
        $Delegate = $request->get('Delegate');
        $Code = $request->get('Code');



        $Prods = ProductSales::whereBetween('Date', [$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales','Payment_Method',$Payment_Method);

            })



            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate',$Delegate);

            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereRelation('Sales','Store',$store);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales','Code',$Code);

            })

            ->whereRelation('Sales', 'Edit', 0)->whereRelation('Sales', 'Delete', 0)->paginate(50);


        $BillDiscount = Sales::whereBetween('Date', [$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->where('Client',$Client);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->where('Payment_Method',$Payment_Method);

            })



            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate',$Delegate);

            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->where('Sales','Code',$Code);

            })

            ->where( 'Edit', 0)->where('Delete', 0)->get()->sum('DiscountBill');


        $total_qty = ProductSales::whereBetween('Date', [$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales','Payment_Method',$Payment_Method);

            })



            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate',$Delegate);

            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereRelation('Sales','Store',$store);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales','Code',$Code);

            })

            ->whereRelation('Sales', 'Edit', 0)->whereRelation('Sales', 'Delete', 0)->get()->sum('Qty');

        $total_price = ProductSales::whereBetween('Date', [$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales','Payment_Method',$Payment_Method);

            })



            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate',$Delegate);

            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereRelation('Sales','Store',$store);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales','Code',$Code);

            })

            ->whereRelation('Sales', 'Edit', 0)->whereRelation('Sales', 'Delete', 0)->get()->sum('Total');

        $total_discount = ProductSales::whereBetween('Date', [$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales','Payment_Method',$Payment_Method);

            })



            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate',$Delegate);

            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereRelation('Sales','Store',$store);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales','Code',$Code);

            })

            ->whereRelation('Sales', 'Edit', 0)->whereRelation('Sales', 'Delete', 0)->get()->sum('TDiscount');

        $total_cost = ProductSales::whereBetween('Date', [$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales','Payment_Method',$Payment_Method);

            })



            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate',$Delegate);

            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereRelation('Sales','Store',$store);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales','Code',$Code);

            })

            ->whereRelation('Sales', 'Edit', 0)->whereRelation('Sales', 'Delete', 0)->get()->sum('TotCostNew');

        $total_net = ProductSales::whereBetween('Date', [$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales','Payment_Method',$Payment_Method);

            })



            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate',$Delegate);

            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereRelation('Sales','Store',$store);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales','Code',$Code);

            })

            ->whereRelation('Sales', 'Edit', 0)->whereRelation('Sales', 'Delete', 0)->get()->sum('Total_Net');




        $data=ProductProfitsNewApiResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'discount_bill'=>$BillDiscount,
            'total_qty'=>$total_qty,
            'total_price'=>$total_price,
            'total_discount'=>$total_discount,
            'total_cost'=>$total_cost,
            'total_net'=>$total_net,

        ];

        return $data->additional($x) ;


    }

    //ExceptProductProfitsFilterApi
    public function ExceptProductProfitsFilterApi(Request $request){

        $search = $request->get('search');
        $store = $request->get('Store');

        $Prods=ProductsQty::

        when(!empty($search), function ($query) use ($search) {
            return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                ->orWhere('V_Name','ILIKE', "%{$search}%")
                ->orWhere('VV_Name','ILIKE', "%{$search}%")
                ->orWhere('P_Code','ILIKE', "%{$search}%")
                ->orWhere('PP_Code','ILIKE', "%{$search}%")
                ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                ->orWhere('PPPP_Code','ILIKE', "%{$search}%")

                ;
        })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);

            })

            ->paginate(30);

        $data=ExceptProductProfitsApiResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),


        ];

        return $data->additional($x) ;


    }

    //ExceptProfitsApi
    public function ExceptProfitsApi(Request $request){

        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $brand = $request->get('brand');

        $Prods=ProductsQty::

        when(!empty($search), function ($query) use ($search) {
            return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                ->orWhere('V_Name','ILIKE', "%{$search}%")
                ->orWhere('VV_Name','ILIKE', "%{$search}%")
                ->orWhere('P_Code','ILIKE', "%{$search}%")
                ->orWhere('PP_Code','ILIKE', "%{$search}%")
                ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                ->orWhere('PPPP_Code','ILIKE', "%{$search}%")

                ;
        })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);

            })
            ->when(!empty($group), function ($query) use ($group) {
                return $query->where('Group',$group);

            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->where('Brand',$brand);

            })


            ->paginate(10);


        $data=ExceptProfitsApiResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),


        ];

        return $data->additional($x) ;


    }

//ProfitSalesProductFilterApi
    public function ProfitSalesProductFilterApi(Request $request){

        $branch=$request->get('branch');
        $store=$request->get('store');
        $group=$request->get('group');
        $brand=$request->get('brand');
        $product_Name=$request->get('product_Name');
        $product_Code=$request->get('product_Code');
        $From=$request->get('From');
        $To=$request->get('To');
        $Client=$request->get('Client');
        $Safe=$request->get('Safe');
        $Payment_Method=$request->get('Payment_Method');
        $Delegate=$request->get('Delegate');
        $Code=$request->get('Code');


        $items=ProductsQty::orderBy('id','asc')

            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store',$store);
            })



            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })



            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->paginate(100);


        $data=ProfitSalesProductFilterApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),


        ];

        return $data->additional($x) ;


    }


    //ProfitGroupsReportFilterApi
    public function ProfitGroupsReportFilterApi(Request $request){

        $From = $request->get('from');
        $To = $request->get('to');
        $group = $request->get('group');


        if($From != '' and $To  != ''and $group != ''){

            $TotalSales=ProductSales::whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)->whereBetween('Date',[$From,$To])->where('Group',$group)->get()->sum('Total_Net');
            $TotalCost=ProductSales::whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)->whereBetween('Date',[$From,$To])->where('Group',$group)->get()->sum('TotCostNew');

            $TotalSalaries=Employess::where('Pro_Group',$group)->get()->sum('Salary');

            $Debt=DB::table('general_dailies')->whereBetween('general_dailies.Date',[$From,$To])

                ->join('acccounting_manuals', function ($join) {

                    $join->on('general_dailies.Account', '=', 'acccounting_manuals.id');
                })
                ->where('acccounting_manuals.Pro_Group',$group)
                ->get()->sum('Debitor_Coin');

            $Credtt=DB::table('general_dailies')->whereBetween('general_dailies.Date',[$From,$To])

                ->join('acccounting_manuals', function ($join) {

                    $join->on('general_dailies.Account', '=', 'acccounting_manuals.id');
                })
                ->where('acccounting_manuals.Pro_Group',$group)
                ->get()->sum('Creditor_Coin');





            $DebtCost=DB::table('general_dailies')->whereBetween('general_dailies.Date',[$From,$To])

                ->join('acccounting_manuals', function ($join) {

                    $join->on('general_dailies.Account', '=', 'acccounting_manuals.id');
                })
                ->where('acccounting_manuals.Pro_Group',$group)
                ->where('acccounting_manuals.id',52)
                ->get()->sum('Debitor_Coin');

            $CredttCost=DB::table('general_dailies')->whereBetween('general_dailies.Date',[$From,$To])

                ->join('acccounting_manuals', function ($join) {

                    $join->on('general_dailies.Account', '=', 'acccounting_manuals.id');
                })
                ->where('acccounting_manuals.Pro_Group',$group)
                ->where('acccounting_manuals.id',52)
                ->get()->sum('Creditor_Coin');



            $DifCost=   $DebtCost - $CredttCost;
            $DifCost=  $TotalCost;
            $Dif=   $Debt - $Credtt;
            $ProfitSales=   $TotalSales - $DifCost;
            $profit=$ProfitSales -  ($TotalSalaries + $Dif) ;


            return response()->json([
                'status' => 200,
                'msg' => trans('admin.Success'),
                'total_sales'=>$TotalSales,
                'total_cost_sales'=>$DifCost,
                'sales_profit'=>$ProfitSales,
                'salaries'=>$TotalSalaries,
                'total_expenses'=>$Dif,
                'profit'=>$profit,
            ]);

        }


    }


    //CompareSalesPriceApi
    public function CompareSalesPriceApi(Request $request){

        $from=$request->get('from');
        $to=$request->get('to');
        $store=$request->get('store');
        $type=$request->get('type');
        $safe=$request->get('safe');
        $group=$request->get('group');
        $brand=$request->get('brand');
        $user=$request->get('user');
        $branch=$request->get('branch');
        $product_Name=$request->get('product_Name');
        $product_Code=$request->get('product_Code');
        $delegate=$request->get('delegate');


        $items=ProductMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store',$store);
            })


            ->when(!empty($type), function ($query) use ($type) {
                return $query->whereIn('Type', $type);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })


            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })


            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->paginate(50);



        $CostIn=ProductMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })
            ->when(!empty($type), function ($query) use ($type) {
                return $query->whereIn('Type', $type);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })

            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })


            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('CostIn');




        $CostOut=ProductMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })
            ->when(!empty($type), function ($query) use ($type) {
                return $query->whereIn('Type', $type);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })

            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })


            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('CostOut');







        $Credit=ProductMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })
            ->when(!empty($type), function ($query) use ($type) {
                return $query->whereIn('Type', $type);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })

            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })



            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('CostCurrent');




        $Bills_Nums=ProductMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })
            ->when(!empty($type), function ($query) use ($type) {
                return $query->whereIn('Type', $type);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })

            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })


            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->count();

        $TotSalePrice=ProductMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })
            ->when(!empty($type), function ($query) use ($type) {
                return $query->whereIn('Type', $type);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })

            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('SalePrice');


        $TotProductPrice=ProductMoves::whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })
            ->when(!empty($type), function ($query) use ($type) {
                return $query->whereIn('Type', $type);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })

            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('ProductPrice');


        $data=CompareSalesPriceApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'CostIn'=>$CostIn,
            'CostOut'=>$CostOut,
            'Credit'=>$Credit,
            'Bills_Nums'=>$Bills_Nums,
            'TotSalePrice'=>$TotSalePrice,
            'TotProductPrice'=>$TotProductPrice,

        ];

        return $data->additional($x) ;


    }

//ProfitsFilterTwoApi
    public function ProfitsFilterTwoApi(Request $request){

        $search = $request->get('search');
        $From = $request->get('From');
        $To = $request->get('To');
        $Vendor = $request->get('Account');
        $Coin = $request->get('Coin');
        $Safe = $request->get('Safe');
        $Payment_Method = $request->get('Payment_Method');
        $Cost_Center = $request->get('Cost_Center');
        $Delegate = $request->get('Delegate');
        $User = $request->get('User');
        $group = $request->get('group');
        $Store = $request->get('Store');
        $Type = $request->get('Type');
        $Code = $request->get('Code');
        $totAvg=0;



        $Purchs=ProductsPurchases::whereBetween('Date', [$From,$To])

            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->whereRelation('Purchase','Vendor',$Vendor);

            })

            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->whereRelation('Purchase','Coin',$Coin);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Purchase','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Purchase','Payment_Method',$Payment_Method);

            })


            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->whereRelation('Purchase','Cost_Center',$Cost_Center);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Purchase','Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->whereRelation('Purchase','User',$User);

            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Purchase','Store',$Store);

            })

            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->whereRelation('Purchase','Type',$Type);

            })

            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Purchase','Code',$Code);

            })



            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")

                    ;

            })


            ->whereRelation('Purchase','Edit',0)
            ->whereRelation('Purchase','Delete',0)

            ->paginate(10);



        $Returns=ReturnPurchProducts::whereBetween('Date', [$From,$To])
            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")


                    ;
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })


            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->where('Vendor',$Vendor);

            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->where('Coin',$Coin);

            })

            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe',$Safe);

            })

            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->where('Cost_Center',$Cost_Center);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->where('Payment_Method',$Payment_Method);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->where('User',$User);

            })



            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->where('Type',$Type);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->where('Code',$Code);

            })

            ->paginate(10);

        $PurchsS=ProductSales::whereBetween('Date', [$From,$To])
            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->whereRelation('Sales','Client',$Vendor);

            })



            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->whereRelation('Sales','Coin',$Coin);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales','Payment_Method',$Payment_Method);

            })


            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->whereRelation('Sales','Cost_Center',$Cost_Center);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->whereRelation('Sales','User',$User);

            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Sales','Store',$Store);

            })

            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->whereRelation('Sales','Type',$Type);

            })

            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales','Code',$Code);

            })



            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")

                    ;

            })


            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->paginate(10);

        $ReturnsS=ReturnSalesProducts::whereBetween('Date', [$From,$To])
            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")


                    ;
            })


            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })


            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->where('Client',$Vendor);

            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->where('Coin',$Coin);

            })

            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe',$Safe);

            })

            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->where('Cost_Center',$Cost_Center);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->where('Payment_Method',$Payment_Method);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->where('User',$User);

            })



            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->where('Type',$Type);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->where('Code',$Code);

            })
            ->paginate(10);




        $data=ProfitFilterPurchasesApiResources::collection($Purchs);
        $dataSales=ProfitFilterSalesApiResources::collection($PurchsS);
        $dataRS=ProfitFilterReturnSalesApiResources::collection($ReturnsS);
        $dataRP=ProfitFilterReturnPurchasesApiResources::collection($Returns);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'Return_Purchs'=>$dataRP,
            'Sales'=>$dataSales,
            'Return_Sales'=>$dataRS,


        ];

        return $data->additional($x) ;


    }



//============

//EmpPrecentsBrandsGroupsReportApi
    public function EmpPrecentsBrandsGroupsReportApi(Request $request){

        $Emp = $request->get('Emp');
        $Group = $request->get('Group');
        $Brand = $request->get('Brand');

        $row=Employess::find($Emp);

        $total_sales=ProductSales::whereRelation('Sales','Delegate',$row->id)->get()->sum('Total_Net');
        $total_sales_group=ProductSales::whereRelation('Sales','Delegate',$row->id)->whereRelation('Product','Group',$Group)->get()->sum('Total_Net');
        $total_sales_brand=ProductSales::whereRelation('Sales','Delegate',$row->id)->whereRelation('Product','Brand',$Brand)->get()->sum('Total_Net');
        $groupp=ItemsGroups::find($Group);
        $brand=Brands::find($Brand);


        $precentGroup=$groupp->Sales_Precet  / 100  ;
        $precentBrand=$brand->Sales_Precet  / 100  ;

        $totPrecGroup= $total_sales_group * $precentGroup ;
        $totPrecBrand= $total_sales_brand * $precentBrand ;

        if (app()->getLocale() == 'ar') {
            $emp_name = $row->Name;


        } else {
            $emp_name = $row->NameEn;


        }

        return response()->json([
                'status' => 200,
                'msg' => trans('admin.Success'),
                'name'=>$emp_name,
                'total_sales'=>$total_sales,
                'total_sales_groups'=>$total_sales_group,
                'total_sales_groups_precent'=>$totPrecGroup,
                'total_sales_brands'=>$total_sales_brand,
                'total_sales_brands_precent'=>$totPrecBrand,

            ]);


    }

//Sales_DelegatesApi
    public function Sales_DelegatesApi(Request $request){

        $from = $request->get('From');
        $to = $request->get('To');
        $Delegate = $request->get('Delegate');

        $BillNum=Sales::orderBy('id','desc')
            ->where('Status',1)
            ->where('Delegate',$Delegate)
            ->whereBetween('Date',[$from,$to])
            ->where('Edit',0)
            ->where('Delete',0)
            ->count();

        $total=Sales::orderBy('id','desc')
            ->where('Status',1)
            ->where('Delegate',$Delegate)
            ->whereBetween('Date',[$from,$to])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $totalCash=Sales::orderBy('id','desc')
            ->where('Status',1)
            ->where('Payment_Method','Cash')
            ->where('Delegate',$Delegate)
            ->whereBetween('Date',[$from,$to])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $totalLater=Sales::orderBy('id','desc')
            ->where('Status',1)
            ->where('Payment_Method','Later')
            ->where('Delegate',$Delegate)
            ->whereBetween('Date',[$from,$to])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $totalLaterCollect=Sales::orderBy('id','desc')
            ->where('Status',1)
            ->where('Payment_Method','Later')
            ->where('Later_Collection',1)
            ->where('Delegate',$Delegate)
            ->whereBetween('Date',[$from,$to])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');
        $row=Employess::find($Delegate);

        if (app()->getLocale() == 'ar') {
            $emp_name = $row->Name;


        } else {
            $emp_name = $row->NameEn;


        }

        return response()->json([
            'status' => 200,
            'msg' => trans('admin.Success'),
            'name'=>$emp_name,
            'BillNum'=>$BillNum,
            'total'=>$total,
            'totalCash'=>$totalCash,
            'totalLater'=>$totalLater,
            'totalLaterCollect'=>$totalLaterCollect,

        ]);


    }


  //Collection_DelegatesApi
      public function Collection_DelegatesApi(Request $request){

          $from = $request->get('From');
          $to = $request->get('To');
          $Delegate = $request->get('Delegate');

          $Custs=Customers::where('Responsible',$Delegate)->paginate(100);

          $data=Collection_DelegatesApiResources::collection($Custs);
          $x=[
              'status'=>200,
              'msg'=>trans('admin.Success'),


          ];

          return $data->additional($x) ;




    }

//DelegateSalesDetailsApi
        public function DelegateSalesDetailsApi(Request $request){
            $lang = $request->header('lang', '');
            $From = $request->get('From');
            $To = $request->get('To');
            $Client = $request->get('Delegate');

            $Sales=ProductSales::

            when(!empty($From), function ($query) use ($From,$To) {
                return $query->whereBetween('Date',[$From,$To]);

            })

                ->when(!empty($Client), function ($query) use ($Client) {
                    return $query->whereRelation('Sales','Delegate',$Client);

                })

                ->whereRelation('Sales','Edit',0)
                ->whereRelation('Sales','Delete',0)
                ->paginate(100);

            $qty=ProductSales::

            when(!empty($From), function ($query) use ($From,$To) {
                return $query->whereBetween('Date',[$From,$To]);

            })

                ->when(!empty($Client), function ($query) use ($Client) {
                    return $query->whereRelation('Sales','Delegate',$Client);

                })

                ->whereRelation('Sales','Edit',0)
                ->whereRelation('Sales','Delete',0)
                ->get()->sum('Qty');
            $tot=ProductSales::

            when(!empty($From), function ($query) use ($From,$To) {
                return $query->whereBetween('Date',[$From,$To]);

            })

                ->when(!empty($Client), function ($query) use ($Client) {
                    return $query->whereRelation('Sales','Delegate',$Client);

                })

                ->whereRelation('Sales','Edit',0)
                ->whereRelation('Sales','Delete',0)
                ->get()->sum('Total_Net');

            $cust=Employess::find($Client);

            if(!empty($cust)){
                if($lang == 'ar' ){
                    $cName=$cust->Name;

                }else{
                    $cName=$cust->NameEn;

                }
            }else{

                $cName='';

            }


            $data=DelegateSalesDetailsApiResources::collection($Sales);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'Delegate'=>$cName,
            'Total_Qty'=>$qty,
            'Total_Price'=>$tot,

        ];

        return $data->additional($x) ;




    }


//DelegateSalesDetailssApi
        public function DelegateSalesDetailssApi(Request $request){

            $from=$request->get('from');
            $to=$request->get('to');
            $delegate=$request->get('delegate');
            $branch=$request->get('branch');
            $store=$request->get('store');
            $group=$request->get('group');
            $brand=$request->get('brand');
            $payment_Method=$request->get('payment_Method');

            $items=ProductSales::whereBetween('Date',[$from,$to])

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })

                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })

                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })

                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })

                ->whereRelation('Sales','Edit',0)
                ->whereRelation('Sales','Delete',0)
                ->paginate(100);


            $Total_Bills=ProductSales::whereBetween('Date',[$from,$to])

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })

                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })

                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })

                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })
                ->whereRelation('Sales','Edit',0)
                ->whereRelation('Sales','Delete',0)
                ->get()->sum('Total');



            $Total_Qty=ProductSales::whereBetween('Date',[$from,$to])

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })

                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })

                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })

                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })
                ->whereRelation('Sales','Edit',0)
                ->whereRelation('Sales','Delete',0)
                ->get()->sum('Qty');

            $Total_Discount=ProductSales::whereBetween('Date',[$from,$to])

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })

                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })

                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })

                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })
                ->whereRelation('Sales','Edit',0)
                ->whereRelation('Sales','Delete',0)
                ->get()->sum('TDiscount');


            $TotalTax=ProductSales::whereBetween('Date',[$from,$to])

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereIn('Group', $group);
                })


                ->when(!empty($brand), function ($query) use ($brand) {
                    return $query->whereIn('Brand', $brand);
                })


                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })

                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })

                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })

                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })
                ->whereRelation('Sales','Edit',0)
                ->whereRelation('Sales','Delete',0)
                ->get()->sum('Total_Tax');


            $Total_Return=ReturnSalesProducts::whereBetween('Date',[$from,$to])

                ->when(!empty($group), function ($query) use ($group) {

                    $query->whereRelation('Product', function ($query) use ($group) {
                        return $query->whereIn('Group', $group);
                    });

                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })
                ->whereRelation('Return','Edit',0)
                ->whereRelation('Return','Delete',0)
                ->get()->sum('Total');


            $Total_Net= ($Total_Bills + $TotalTax) - $Total_Discount;

        $data=NewDelegateSalesDetailssApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'Total_Bills'=>$Total_Bills,
            'Total_Qty'=>$Total_Qty,
            'Total_Discount'=>$Total_Discount,
            'TotalTax'=>$TotalTax,
            'Total_Return'=>$Total_Return,
            'Total_Net'=>$Total_Net,

        ];

        return $data->additional($x) ;




    }

//ProfitDelegateSalesDetailsApi
    public function ProfitDelegateSalesDetailsApi(Request $request){

        $from=$request->get('from');
        $to=$request->get('to');
        $delegate=$request->get('delegate');
        $branch=$request->get('branch');
        $store=$request->get('store');
        $group=$request->get('group');
        $brand=$request->get('brand');
        $payment_Method=$request->get('payment_Method');

        $items=ProductSales::whereBetween('Date',[$from,$to])

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })


            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })

            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                return $query->whereIn('Payment_Method', $payment_Method);
            })

            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })

            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->paginate(20);

        $total=ProductSales::whereBetween('Date',[$from,$to])

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })


            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })

            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                return $query->whereIn('Payment_Method', $payment_Method);
            })

            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })

            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->get()->sum('Total_Net');

        $TotQty=ProductSales::whereBetween('Date',[$from,$to])

            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })


            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })

            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                return $query->whereIn('Payment_Method', $payment_Method);
            })

            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })

            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->get()->sum('Qty');




        $data=ProfitDelegateSalesDetailsApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'Total_Net'=>$total,
            'Total_Qty'=>$TotQty,

        ];

        return $data->additional($x) ;




    }


    //DailyClosing ===================================================
    public function DailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();

        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $PurchCash =Purchases::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Cash')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Total_Price');


            $PurchLater =Purchases::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Later')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Pay');


            $Cash =Sales::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Cash')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Total_Price');


            $Later =Sales::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Later')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Pay');

            $CashVisa =Sales::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Cash_Visa')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Total_Price');


            $Installment =Sales::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Installment')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('presenter');

            $TotSales=  $Cash + $Later +  $CashVisa+ $Installment;
            $TotPurch=  $PurchCash + $PurchLater;





            $ReciptTot =ReciptVoucher::orderBy('id','asc')
                ->where('Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Total_Creditor');




            $PaymentTot =PaymentVoucher::orderBy('id','asc')
                ->where('Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Total_Debaitor');


            $DifRP= $ReciptTot - $PaymentTot ;
            $Amount = $DifRP +   $TotSales  ;

            $Discooo =Sales::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Cash')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Pay');

            $ALLLL =Sales::orderBy('id','asc')
                ->where('Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Total_Discount');



            $TransferTotTo=SafeTransfers::where('To_Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Amount');



            $TransferTotFrom=SafeTransfers::where('From_Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Amount');

            $Disc=$Cash - $Discooo ;
            $DiscAll=$ALLLL ;



            $ImportCheck =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','الشيكات الواردة')
                ->get()->sum('Debitor_Coin');

            $Setllement3agz =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','تسوية بالعجز')
                ->get()->sum('Debitor_Coin');

            $WaslAmana =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','استلام وصل أمانة')
                ->get()->sum('Debitor_Coin');


            $SalesPetrol =SalesPetrol::whereBetween('Date', [$from, $to])
                ->where('Safe',$safe)
                ->get()->sum('Total');


            $shippingTicket =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','البوليصه')
                ->get()->sum('Debitor_Coin');


            $Maintaince =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','الصيانة')
                ->get()->sum('Debitor_Coin');




            $ExportCheck =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','الشيكات الصادرة')
                ->get()->sum('Creditor_Coin');


            $SetllementZyada =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','تسوية بالزيادة')
                ->get()->sum('Creditor_Coin');


            $RMaintaince =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','مرتجع الصيانة')
                ->get()->sum('Creditor_Coin');

            $Salary =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','صرف راتب')
                ->get()->sum('Creditor_Coin');

            $Borrow =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','سلفة موظف')
                ->get()->sum('Creditor_Coin');

            $Loan =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','قرض موظف')
                ->get()->sum('Creditor_Coin');

            $Exchange =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type',trans('admin.ExchangeCommissions'))
                ->get()->sum('Creditor_Coin');


            $RCashh =ReturnSales::whereBetween('Date', [$from, $to])->where('Safe',$safe)
                ->where('Payment_Method', 'Cash')
                ->get()->sum('Total_Return_Value');

            $RLaterr =ReturnSales::whereBetween('Date', [$from, $to])->where('Safe',$safe)
                ->where('Payment_Method', 'Later')
                ->get()->sum('Pay');

            $TotallSaless=$TotSales + $RCashh + $RLaterr ;

            $RTotSales=  $RCashh + $RLaterr ;

            $KhsmMasmou7 =Sales::whereBetween('Date', [$from, $to])
                ->where('Safe',$safe)
                ->get()->sum('Total_Discount');

            $SafySales=$TotallSaless - ($RTotSales + $KhsmMasmou7);
            $Ward= $ReciptTot + $SafySales + $TransferTotTo + $ImportCheck + $Setllement3agz + $WaslAmana + $SalesPetrol + $shippingTicket + $Maintaince ;

            $RPCash =ReturnPurch::whereBetween('Date', [$from, $to])->where('Safe',$safe)
                ->where('Payment_Method', 'Cash')
                ->get()->sum('Total_Return_Value');

            $RPLater =ReturnPurch::whereBetween('Date', [$from, $to])->where('Safe',$safe)
                ->where('Payment_Method', 'Later')
                ->get()->sum('Pay');
            $AllP=$TotPurch + $RPCash + $RPLater;
            $RPTotPurch=  $RPCash + $RPLater ;
            $Safy= $AllP - $RPTotPurch ;

            $Sadr= $Safy + $PaymentTot + $TransferTotFrom + $ExportCheck + $SetllementZyada+ $RMaintaince+ $Salary+ $Borrow+ $Loan+$Exchange;
            $MOshtryat=$AllP - $RPTotPurch ;
            $AM=   $Ward - $Sadr ;
            $debt=GeneralDaily::where('Account',$safe)->get()->sum('Debitor');
            $crdt=GeneralDaily::where('Account',$safe)->get()->sum('Creditor');
            $dif=$debt - $crdt ;

            array_push($Array,[
                'sales'=>trans('admin.Sales'),
                'total_sales'=>$TotallSaless,
                'return_sales'=>trans('admin.ReturnSales'),
                'return_total_sales'=>$RTotSales,
                'allow_discount'=>trans('admin.allow_discount'),
                'total_allow_discount'=>$KhsmMasmou7,
                'net_sales'=>trans('admin.net_sales'),
                'net_total_sales'=>$SafySales,
                'recipt_voucher'=>trans('admin.Recipt_Voucher'),
                'total_recipt_voucher'=>$ReciptTot,
                'safe_tarnsfer_to'=>trans('admin.SafeTransfer'),
                'total_safe_tarnsfer_to'=>$TransferTotTo,
                'import_checks'=>trans('admin.ImportingChecks'),
                'total_import_checks'=>$ImportCheck,
                'minus_settlement'=>trans('admin.minus_settlement'),
                'total_minus_settlement'=>$Setllement3agz,
                'insurance_paper'=>trans('admin.Insurance_Paper'),
                'total_insurance_paper'=>$WaslAmana,
                'sales_petrol'=>trans('admin.Sales_Petrol'),
                'total_sales_petrol'=>$SalesPetrol,
                'shipping_ticket'=>trans('admin.shipping_ticket'),
                'total_shipping_ticket'=>$shippingTicket,
                'maintaince'=>trans('admin.Maintaince'),
                'total_maintaince'=>$Maintaince,
                'received'=>trans('admin.total_received'),
                'total_received'=>$Ward,
                'payment_vouchers'=>trans('admin.Payment_Voucher'),
                'total_payment_vouchers'=>$PaymentTot,
                'payment_vouchers'=>trans('admin.Payment_Voucher'),
                'total_payment_vouchers'=>$PaymentTot,
                'purchases'=>trans('admin.Purchases'),
                'total_purchases'=>$AllP,
                'return_purchases'=>trans('admin.ReturnPurchases'),
                'total_return_purchases'=>$RPTotPurch,
                'net_purchases'=>trans('admin.net_purchases'),
                'total_net_purchases'=>$Safy,
                'net_purchases'=>trans('admin.net_purchases'),
                'total_net_purchases'=>$Safy,
                'safe_tarnsfer_from'=>trans('admin.SafeTransfer'),
                'total_safe_tarnsfer_from'=>$TransferTotFrom,
                'exporting_checks'=>trans('admin.Exporting_Checks'),
                'total_exporting_checks'=>$ExportCheck,
                'plus_settlement'=>trans('admin.plus_settlement'),
                'total_plus_settlement'=>$SetllementZyada,
                'return_maintaince'=>trans('admin.return_maintaince'),
                'total_return_maintaince'=>$RMaintaince,
                'salary'=>trans('admin.Salaries'),
                'total_salary'=>$Salary,
                'borrows'=>trans('admin.Borrows'),
                'total_borrows'=>$Borrow,
                'loans'=>trans('admin.Loans'),
                'total_loans'=>$Loan,
                'exchanges'=>trans('admin.Excnanges'),
                'total_exchanges'=>$Exchange,
                'issued'=>trans('admin.total_issued'),
                'total_issued'=>$Sadr,
                'daily_movements_in_safe'=>trans('admin.total_daily_movements_in_safe'),
                'total_daily_movements_in_safe'=>$AM,
                'actual_balance_in_safe'=>trans('admin.actual_balance_in_safe'),
                'total_actual_balance_in_safe'=>$dif,

            ]);



            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterSalesDetailsDailyClosing
    public function FilterSalesDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');



            $Sales =Sales::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','!=','Check')
                ->whereBetween('Date', [$from, $to])
                ->get();


            foreach($Sales as $sal){

                if($sal->Payment_Method == 'Cash'){

                    $bill=($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount;

                }elseif($sal->Payment_Method == 'Later'){

                    $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;

                }elseif($sal->Payment_Method == 'Cash_Visa'){
                    $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount);

                }elseif($sal->Payment_Method == 'Installment'){
                    $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;
                }elseif($sal->Payment_Method == 'Cash_Collection'){

                    $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;

                }elseif($sal->Payment_Method == 'Delivery'){

                    $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;

                }elseif($sal->Payment_Method == 'InstallmentCompanies'){

                    $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;

                }

                if($sal->Pay !=  null){


                    if($lang == 'ar'){
                        array_push($Array,[
                            'code'=>$sal->Code,
                            'account'=>$sal->Client()->first()->Name,
                            'total'=>$bill,


                        ]);
                    }else{

                        array_push($Array,[
                            'code'=>$sal->Code,
                            'account'=>$sal->Client()->first()->NameEn,
                            'total'=>$bill,


                        ]);
                    }

                }




            }




            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterRSalesDetailsDailyClosing
    public function FilterRSalesDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $ReturnSales =ReturnSales::where('Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get();

            $RCash=0;
            $RLater=0;

            //Reurn Sales Details
            foreach($ReturnSales as $sal){

                if($sal->Sales()->first()->Safe == $safe){
                    if($sal->Payment_Method == 'Cash'){

                        $bill=$sal->Total_Return_Value;
                        $RCash +=$sal->Total_Return_Value;
                    }elseif($sal->Payment_Method == 'Later'){

                        $bill=$sal->Pay;
                        $RLater +=$sal->Pay;
                    }


                    if($sal->Pay !=  null){

                        if($lang == 'ar'){
                            array_push($Array,[
                                'code'=>$sal->Code,
                                'account'=>$sal->Sales()->first()->Client()->first()->Name,
                                'total'=>$bill,


                            ]);
                        }else{
                            array_push($Array,[
                                'code'=>$sal->Code,
                                'account'=>$sal->Sales()->first()->Client()->first()->NameEn,
                                'total'=>$bill,


                            ]);

                        }

                    }
                }
            }



            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterReciptDetailsDailyClosing
    public function FilterReciptDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $ReciptVoucher =ReciptVoucher::orderBy('id','asc')
                ->where('Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get();


            //Recipt Voucher Details
            foreach($ReciptVoucher as $sal){
                $VVVVV=ReciptVoucherDetails::where('RV_ID',$sal->id)->first();

                if(!empty($VVVVV)){

                    if($lang == 'ar'){
                        array_push($Array,[
                            'code'=>$sal->Code,
                            'account'=>$VVVVV->Account()->first()->Name,
                            'total'=>$sal->Total_Creditor,


                        ]);

                    }else{

                        array_push($Array,[
                            'code'=>$sal->Code,
                            'account'=>$VVVVV->Account()->first()->NameEn,
                            'total'=>$sal->Total_Creditor,


                        ]);

                    }

                }

            }




            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterTransferTotDetailsDailyClosing
    public function FilterTransferTotDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $TransfersTo=SafeTransfers::where('To_Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get();

            //Safe Transfer Details
            foreach($TransfersTo as $trans){


                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$trans->Code,
                        'account'=>$trans->To_Safe()->first()->Name,
                        'total'=>$trans->Amount,


                    ]);

                }else{

                    array_push($Array,[
                        'code'=>$trans->Code,
                        'account'=>$trans->To_Safe()->first()->NameEn,
                        'total'=>$trans->Amount,


                    ]);
                }

            }




            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterPaymenttDetailsDailyClosing
    public function FilterPaymenttDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');


            $PaymentVoucher =PaymentVoucher::orderBy('id','asc')
                ->where('Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get();

            //Payment Voucher Details
            foreach($PaymentVoucher as $sal){

                $VVVVV=PaymentVoucherDetails::where('PV_ID',$sal->id)->first();


                if($lang == 'ar'){
                    if(!empty($VVVVV)){
                        array_push($Array,[
                            'code'=>$sal->Code,
                            'account'=>$VVVVV->Account()->first()->Name,
                            'total'=>$sal->Total_Debaitor,


                        ]);
                    }else{

                        array_push($Array,[
                            'code'=>$sal->Code,
                            'account'=>$VVVVV->Account()->first()->NameEn,
                            'total'=>$sal->Total_Debaitor,


                        ]);
                    }

                }

            }




            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterPurchasesDetailsDailyClosing
    public function FilterPurchasesDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $Purchases =Purchases::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','!=','Check')
                ->whereBetween('Date', [$from, $to])
                ->get();


//Purchases Details
            foreach($Purchases as $purch){

                if($purch->Payment_Method == 'Cash'){

                    $bill=($purch->Total_Price + $purch->Total_Taxes) - $purch->Total_Discount;
                }elseif($purch->Payment_Method == 'Later'){

                    $bill=(($purch->Total_Price + $purch->Total_Taxes) - $purch->Total_Discount) - $purch->Pay;
                }
                if($purch->Pay !=  null){

                    if($lang == 'ar'){

                        array_push($Array,[
                            'code'=>$purch->Code,
                            'account'=>$purch->Vendor()->first()->Name,
                            'total'=>$bill,


                        ]);

                    }else{

                        array_push($Array,[
                            'code'=>$purch->Code,
                            'account'=>$purch->Vendor()->first()->NameEn,
                            'total'=>$bill,


                        ]);

                    }


                }
            }



            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterRPurchasesDetailsDailyClosing
    public function FilterRPurchasesDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $ReturnPurch =ReturnPurch::where('Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get();

            $RPCash=0;
            $RPLater=0;


            //Return Purch Details
            foreach($ReturnPurch as $sal){

                if($sal->Purchase()->first()->Safe == $safe){
                    if($sal->Payment_Method == 'Cash'){

                        $bill=$sal->Total_Return_Value;
                        $RPCash +=$sal->Total_Return_Value;
                    }elseif($sal->Payment_Method == 'Later'){

                        $bill=$sal->Pay;
                        $RPLater +=$sal->Pay;
                    }

                    if($sal->Pay !=  null){


                        if($lang == 'ar'){

                            array_push($Array,[
                                'code'=>$sal->Code,
                                'account'=>$sal->Purchase()->first()->Vendor()->first()->Name,
                                'total'=>$bill,


                            ]);

                        }else{

                            array_push($Array,[
                                'code'=>$sal->Code,
                                'account'=>$sal->Purchase()->first()->Vendor()->first()->NameEn,
                                'total'=>$bill,


                            ]);


                        }

                    }
                }
            }









            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterTransferFromDetailsDailyClosing
    public function FilterTransferFromDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');



            $TransfersFrom=SafeTransfers::where('From_Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get();

            //Transfer Form Details
            foreach($TransfersFrom as $trans){

                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$trans->Code,
                        'account'=>$trans->From_Safe()->first()->Name,
                        'total'=>$trans->Amount,


                    ]);
                }else{

                    array_push($Array,[
                        'code'=>$trans->Code,
                        'account'=>$trans->From_Safe()->first()->NameEn,
                        'total'=>$trans->Amount,


                    ]);
                }

            }










            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterImportChecksDetailsDailyClosing
    public function FilterImportChecksDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');


            $ImportCheck =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','الشيكات الواردة')
                ->get();


            foreach($ImportCheck as $sal){

                $det=IncomChecks::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Arrest_Account()->first()->Name,
                        'total'=>$sal->Debitor_Coin,


                    ]);
                }else{

                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Arrest_Account()->first()->NameEn,
                        'total'=>$sal->Debitor_Coin,


                    ]);

                }

            }




            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterSettlement3agzDetailsDailyClosing
    public function FilterSettlement3agzDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $Setllement3agz =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','تسوية بالعجز')
                ->get();


            foreach($Setllement3agz as $sal){

                $det=Settlement::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account_Dificit()->first()->Name,
                        'total'=>$sal->Debitor_Coin,


                    ]);

                }else{

                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account_Dificit()->first()->NameEn,
                        'total'=>$sal->Debitor_Coin,


                    ]);

                }

            }









            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterWaslDetailsDailyClosing
    public function FilterWaslDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');


            $WaslAmana =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','استلام وصل أمانة')
                ->get();


            foreach($WaslAmana as $sal){

                $det=InsurancePaper::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();


                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account()->first()->Name,
                        'total'=>$sal->Debitor_Coin,


                    ]);
                }else{

                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account()->first()->NameEn,
                        'total'=>$sal->Debitor_Coin,


                    ]);
                }

            }








            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterPetrolDetailsDailyClosing
    public function FilterPetrolDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $SalesPetrol =SalesPetrol::whereBetween('Date', [$from, $to])
                ->where('Safe',$safe)
                ->get();


            foreach($SalesPetrol as $sal){


                if($lang == 'ar'){

                    array_push($Array,[
                        'code'=>$sal->Code,
                        'account'=>$sal->Safe()->first()->Name,
                        'total'=>$sal->Total,


                    ]);

                }else{

                    array_push($Array,[
                        'code'=>$sal->Code,
                        'account'=>$sal->Safe()->first()->NameEn,
                        'total'=>$sal->Total,


                    ]);
                }
            }









            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterShippingDetailsDailyClosing
    public function FilterShippingDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $shippingTicket =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','البوليصه')
                ->get();



            foreach($shippingTicket as $sal){
                $det=Ticket::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Sender_Name()->first()->Name,
                        'total'=>$sal->Debitor_Coin,


                    ]);
                }else{

                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Sender_Name()->first()->NameEn,
                        'total'=>$sal->Debitor_Coin,


                    ]);
                }

            }


            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterMaintainceDetailsDailyClosing
    public function FilterMaintainceDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $Maintaince =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','الصيانة')
                ->get();


            foreach($Maintaince as $sal){
                $det=ReciptMaintaince::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                if($lang == 'ar'){

                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account()->first()->Name,
                        'total'=>$sal->Debitor_Coin,


                    ]);

                }else{

                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account()->first()->NameEn,
                        'total'=>$sal->Debitor_Coin,


                    ]);

                }

            }


            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterExportChecksDetailsDailyClosing
    public function FilterExportChecksDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $ExportCheck =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','الشيكات الصادرة')
                ->get();


            foreach($ExportCheck as $sal){
                $det=ExportChecks::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();


                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Pay_Account()->first()->Name,
                        'total'=>$sal->Creditor_Coin,


                    ]);
                }else{

                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Pay_Account()->first()->NameEn,
                        'total'=>$sal->Creditor_Coin,


                    ]);

                }

            }




            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterSettlementZyadaDetailsDailyClosing
    public function FilterSettlementZyadaDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');


            $SetllementZyada =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','تسوية بالزيادة')
                ->get();


            foreach($SetllementZyada as $sal){
                $det=Settlement::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account_Excess()->first()->Name,
                        'total'=>$sal->Creditor_Coin,


                    ]);
                }else{

                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account_Excess()->first()->NameEn,
                        'total'=>$sal->Creditor_Coin,


                    ]);
                }

            }










            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterRMaintainceDetailsDailyClosing
    public function FilterRMaintainceDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $RMaintaince =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','مرتجع الصيانة')
                ->get();


            foreach($RMaintaince as $sal){
                $det=ReturnMaintainceBill::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account()->first()->Name,
                        'total'=>$sal->Creditor_Coin,


                    ]);
                }else{
                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account()->first()->NameEn,
                        'total'=>$sal->Creditor_Coin,


                    ]);

                }

            }


            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterSalaryDetailsDailyClosing
    public function FilterSalaryDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $Salary =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','صرف راتب')
                ->get();


            foreach($Salary as $sal){
                $det=PaySalary::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                if(!empty($det->Emp)){

                    if($lang == 'ar'){
                        array_push($Array,[
                            'code'=>$sal->Code_Type,
                            'account'=>$det->Emp()->first()->Name,
                            'total'=>$sal->Creditor_Coin,


                        ]);
                    }else{

                        array_push($Array,[
                            'code'=>$sal->Code_Type,
                            'account'=>$det->Emp()->first()->NameEn,
                            'total'=>$sal->Creditor_Coin,


                        ]);
                    }

                }

            }









            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterBorrowDetailsDailyClosing
    public function FilterBorrowDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');


            $Borrow =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','سلفة موظف')
                ->get();


            foreach($Borrow as $sal){
                $det=Borrowa::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();
                if(!empty($det->Emp)){

                    if($lang == 'ar'){
                        array_push($Array,[
                            'code'=>$sal->Code_Type,
                            'account'=>$det->Emp()->first()->Name,
                            'total'=>$sal->Creditor_Coin,


                        ]);
                    }else{

                        array_push($Array,[
                            'code'=>$sal->Code_Type,
                            'account'=>$det->Emp()->first()->NameEn,
                            'total'=>$sal->Creditor_Coin,


                        ]);

                    }
                }

            }








            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterLoanDetailsDailyClosing
    public function FilterLoanDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');


            $Loan =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','قرض موظف')
                ->get();


            foreach($Loan as $sal){
                $det=Loan::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                if(!empty($det->Emp)){

                    if($lang == 'ar'){
                        array_push($Array,[
                            'code'=>$sal->Code_Type,
                            'account'=>$det->Emp()->first()->Name,
                            'total'=>$sal->Creditor_Coin,


                        ]);
                    }else{
                        array_push($Array,[
                            'code'=>$sal->Code_Type,
                            'account'=>$det->Emp()->first()->NameEn,
                            'total'=>$sal->Creditor_Coin,


                        ]);

                    }
                }
            }










            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterExchangeDetailsDailyClosing
    public function FilterExchangeDetailsDailyClosing(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $Exchange =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type',trans('admin.ExchangeCommissions'))
                ->get();

            foreach($Exchange as $sal){
                $det=ExchangeCommissions::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();

                if(!empty($det->Emp)){

                    if($lang == 'ar'){
                        array_push($Array,[
                            'code'=>$sal->Code_Type,
                            'account'=>$det->Emp()->first()->Name,
                            'total'=>$sal->Creditor_Coin,


                        ]);
                    }else{

                        array_push($Array,[
                            'code'=>$sal->Code_Type,
                            'account'=>$det->Emp()->first()->NameEn,
                            'total'=>$sal->Creditor_Coin,


                        ]);

                    }

                }

            }


            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //==============================================


    //DailyClosing  Details===================================================
    public function DailyClosingDetails(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();

        if(!empty($admin)){
            $Array=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');

            $PurchCash =Purchases::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Cash')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Total_Net');


            $PurchLater =Purchases::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Later')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Pay');


            $Cash =Sales::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Cash')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Total_Net');


            $Later =Sales::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Later')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Pay');

            $CashVisa =Sales::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Cash_Visa')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Total_Net');


            $Installment =Sales::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Installment')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('presenter');

            $TotSales=  $Cash + $Later +  $CashVisa+ $Installment;
            $TotPurch=  $PurchCash + $PurchLater;





            $ReciptTot =ReciptVoucher::orderBy('id','asc')
                ->where('Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Total_Creditor');




            $PaymentTot =PaymentVoucher::orderBy('id','asc')
                ->where('Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Total_Debaitor');


            $DifRP= $ReciptTot - $PaymentTot ;
            $Amount = $DifRP +   $TotSales  ;

            $Discooo =Sales::orderBy('id','asc')
                ->where('Safe',$safe)
                ->where('Payment_Method','Cash')
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Pay');

            $ALLLL =Sales::orderBy('id','asc')
                ->where('Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Total_Discount');



            $TransferTotTo=SafeTransfers::where('To_Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Amount');



            $TransferTotFrom=SafeTransfers::where('From_Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->get()->sum('Amount');

            $Disc=$Cash - $Discooo ;
            $DiscAll=$ALLLL ;



            $ImportCheck =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','الشيكات الواردة')
                ->get()->sum('Debitor_Coin');

            $Setllement3agz =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','تسوية بالعجز')
                ->get()->sum('Debitor_Coin');

            $WaslAmana =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','استلام وصل أمانة')
                ->get()->sum('Debitor_Coin');


            $SalesPetrol =SalesPetrol::whereBetween('Date', [$from, $to])
                ->where('Safe',$safe)
                ->get()->sum('Total');


            $shippingTicket =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','البوليصه')
                ->get()->sum('Debitor_Coin');


            $Maintaince =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','الصيانة')
                ->get()->sum('Debitor_Coin');




            $ExportCheck =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','الشيكات الصادرة')
                ->get()->sum('Creditor_Coin');


            $SetllementZyada =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','تسوية بالزيادة')
                ->get()->sum('Creditor_Coin');


            $RMaintaince =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','مرتجع الصيانة')
                ->get()->sum('Creditor_Coin');

            $Salary =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','صرف راتب')
                ->get()->sum('Creditor_Coin');

            $Borrow =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','سلفة موظف')
                ->get()->sum('Creditor_Coin');

            $Loan =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','قرض موظف')
                ->get()->sum('Creditor_Coin');

            $Exchange =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type',trans('admin.ExchangeCommissions'))
                ->get()->sum('Creditor_Coin');


            $RCashh =ReturnSales::whereBetween('Date', [$from, $to])->where('Safe',$safe)
                ->where('Payment_Method', 'Cash')
                ->get()->sum('Total_Return_Value');

            $RLaterr =ReturnSales::whereBetween('Date', [$from, $to])->where('Safe',$safe)
                ->where('Payment_Method', 'Later')
                ->get()->sum('Pay');

            $TotallSaless=$TotSales + $RCashh + $RLaterr ;

            $RTotSales=  $RCashh + $RLaterr ;

            $KhsmMasmou7 =Sales::whereBetween('Date', [$from, $to])
                ->where('Safe',$safe)
                ->get()->sum('Total_Discount');

            $SafySales=$TotallSaless - ($RTotSales + $KhsmMasmou7);
            $Ward= $ReciptTot + $SafySales + $TransferTotTo + $ImportCheck + $Setllement3agz + $WaslAmana + $SalesPetrol + $shippingTicket + $Maintaince ;

            $RPCash =ReturnPurch::whereBetween('Date', [$from, $to])->where('Safe',$safe)
                ->where('Payment_Method', 'Cash')
                ->get()->sum('Total_Return_Value');

            $RPLater =ReturnPurch::whereBetween('Date', [$from, $to])->where('Safe',$safe)
                ->where('Payment_Method', 'Later')
                ->get()->sum('Pay');
            $AllP=$TotPurch + $RPCash + $RPLater;
            $RPTotPurch=  $RPCash + $RPLater ;
            $Safy= $AllP - $RPTotPurch ;

            $Sadr= $Safy + $PaymentTot + $TransferTotFrom + $ExportCheck + $SetllementZyada+ $RMaintaince+ $Salary+ $Borrow+ $Loan+$Exchange;
            $MOshtryat=$AllP - $RPTotPurch ;
            $AM=   $Ward - $Sadr ;
            $debt=GeneralDaily::where('Account',$safe)->get()->sum('Debitor');
            $crdt=GeneralDaily::where('Account',$safe)->get()->sum('Creditor');
            $dif=$debt - $crdt ;

            array_push($Array,[
                'sales'=>trans('admin.Sales'),
                'total_sales'=>$TotallSaless + $KhsmMasmou7,
                'return_sales'=>trans('admin.ReturnSales'),
                'return_total_sales'=>$RTotSales,
                'allow_discount'=>trans('admin.allow_discount'),
                'total_allow_discount'=>$KhsmMasmou7,
                'net_sales'=>trans('admin.net_sales'),
                'net_total_sales'=>$SafySales,
                'recipt_voucher'=>trans('admin.Recipt_Voucher'),
                'total_recipt_voucher'=>$ReciptTot,
                'safe_tarnsfer_to'=>trans('admin.SafeTransfer'),
                'total_safe_tarnsfer_to'=>$TransferTotTo,
                'import_checks'=>trans('admin.ImportingChecks'),
                'total_import_checks'=>$ImportCheck,
                'minus_settlement'=>trans('admin.minus_settlement'),
                'total_minus_settlement'=>$Setllement3agz,
                'insurance_paper'=>trans('admin.Insurance_Paper'),
                'total_insurance_paper'=>$WaslAmana,
                'sales_petrol'=>trans('admin.Sales_Petrol'),
                'total_sales_petrol'=>$SalesPetrol,
                'shipping_ticket'=>trans('admin.shipping_ticket'),
                'total_shipping_ticket'=>$shippingTicket,
                'maintaince'=>trans('admin.Maintaince'),
                'total_maintaince'=>$Maintaince,
                'received'=>trans('admin.total_received'),
                'total_received'=>$Ward,
                'payment_vouchers'=>trans('admin.Payment_Voucher'),
                'total_payment_vouchers'=>$PaymentTot,
                'payment_vouchers'=>trans('admin.Payment_Voucher'),
                'total_payment_vouchers'=>$PaymentTot,
                'purchases'=>trans('admin.Purchases'),
                'total_purchases'=>$AllP,
                'return_purchases'=>trans('admin.ReturnPurchases'),
                'total_return_purchases'=>$RPTotPurch,
                'net_purchases'=>trans('admin.net_purchases'),
                'total_net_purchases'=>$Safy,
                'net_purchases'=>trans('admin.net_purchases'),
                'total_net_purchases'=>$Safy,
                'safe_tarnsfer_from'=>trans('admin.SafeTransfer'),
                'total_safe_tarnsfer_from'=>$TransferTotFrom,
                'exporting_checks'=>trans('admin.Exporting_Checks'),
                'total_exporting_checks'=>$ExportCheck,
                'plus_settlement'=>trans('admin.plus_settlement'),
                'total_plus_settlement'=>$SetllementZyada,
                'return_maintaince'=>trans('admin.return_maintaince'),
                'total_return_maintaince'=>$RMaintaince,
                'salary'=>trans('admin.Salaries'),
                'total_salary'=>$Salary,
                'borrows'=>trans('admin.Borrows'),
                'total_borrows'=>$Borrow,
                'loans'=>trans('admin.Loans'),
                'total_loans'=>$Loan,
                'exchanges'=>trans('admin.Excnanges'),
                'total_exchanges'=>$Exchange,
                'issued'=>trans('admin.total_issued'),
                'total_issued'=>$Sadr,
                'daily_movements_in_safe'=>trans('admin.total_daily_movements_in_safe'),
                'total_daily_movements_in_safe'=>$AM,
                'actual_balance_in_safe'=>trans('admin.actual_balance_in_safe'),
                'total_actual_balance_in_safe'=>$dif,

            ]);



            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


    //FilterSalesDailyClosingDetails
    public function FilterSalesDailyClosingDetails(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();
            $ArrayDet=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');



            $Sales =Sales::whereBetween('Date', [$from, $to])
                ->where('Safe',$safe)
                ->when(!empty($payment), function ($query) use ($payment) {
                    return $query->whereIn('Payment_Method', $payment);
                })
                ->where('Payment_Method','!=','Check')
                ->get();

            foreach($Sales as $sal){
                $details=ProductSales::where('Sales',$sal->id)->get();
                if($sal->Payment_Method == 'Cash'){

                    $bill=($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount;

                }elseif($sal->Payment_Method == 'Later'){

                    $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;

                }elseif($sal->Payment_Method == 'Cash_Visa'){
                    $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount);

                }elseif($sal->Payment_Method == 'Installment'){
                    $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;
                }elseif($sal->Payment_Method == 'Cash_Collection'){

                    $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;

                }elseif($sal->Payment_Method == 'Delivery'){

                    $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;

                }elseif($sal->Payment_Method == 'InstallmentCompanies'){

                    $bill=(($sal->Total_Price + $sal->Total_Taxes) - $sal->Total_Discount) - $sal->Pay;

                }




                foreach($details as $detail){


                    if($lang == 'ar'){
                        array_push($ArrayDet,[
                            'product_code'=>$detail->Product_Code,
                            'product_name'=>$detail->Product()->first()->P_Ar_Name,
                            'unit'=>$detail->Unit()->first()->Name,
                            'qty'=>$detail->Qty,
                            'price'=>$detail->Price,
                            'discount'=>$detail->Discount,
                            'tax'=>$detail->Total_Tax,
                            'total'=>$detail->Total,
                            'group'=>$detail->Product()->first()->Group()->first()->Name,


                        ]);

                    }else{

                        array_push($ArrayDet,[
                            'product_code'=>$detail->Product_Code,
                            'product_name'=>$detail->Product()->first()->P_En_Name,
                            'unit'=>$detail->Unit()->first()->NameEn,
                            'qty'=>$detail->Qty,
                            'price'=>$detail->Price,
                            'discount'=>$detail->Discount,
                            'tax'=>$detail->Total_Tax,
                            'total'=>$detail->Total,
                            'group'=>$detail->Product()->first()->Group()->first()->NameEn,


                        ]);


                    }

                }



                array_push($Array,[
                    'code'=>$sal->Code,
                    'account'=>$sal->Client()->first()->Name,
                    'total'=>$bill,
                    'details'=>$ArrayDet,


                ]);



            }






            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterRSalesDailyClosingDetails
    public function FilterRSalesDailyClosingDetails(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();
            $ArrayDet=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');



            $ReturnSales =ReturnSales::where('Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->when(!empty($payment), function ($query) use ($payment) {
                    return $query->whereIn('Payment_Method', $payment);
                })
                ->get();

            $RCash=0;
            $RLater=0;

            foreach($ReturnSales as $sal){
                $details=ReturnSalesProducts::where('Return',$sal->id)->get();
                if($sal->Sales()->first()->Safe == $safe){
                    if($sal->Payment_Method == 'Cash'){

                        $bill=$sal->Total_Return_Value;
                        $RCash +=$sal->Total_Return_Value;
                    }elseif($sal->Payment_Method == 'Later'){

                        $bill=$sal->Pay;
                        $RLater +=$sal->Pay;
                    }


                    if($sal->Pay !=  null){


                        foreach($details as $detail){

                            if($lang == 'ar'){
                                array_push($ArrayDet,[
                                    'product_code'=>$detail->Product_Code,
                                    'product_name'=>$detail->Product()->first()->P_Ar_Name,
                                    'unit'=>$detail->Unit()->first()->Name,
                                    'return_qty'=>$detail->Recived_Qty,
                                    'qty'=>$detail->Qty,
                                    'price'=>$detail->Price,
                                    'discount'=>$detail->Discount,
                                    'total_bf_tax'=>$detail->Total_Bf_Tax,
                                    'tax'=>$detail->Total_Tax,
                                    'total'=>$detail->Total,
                                    'group'=>$detail->Product()->first()->Group()->first()->Name,
                                    'exp_date'=>$detail->Exp_Date,
                                    'store'=>$detail->Store()->first()->Name,


                                ]);
                            }else{

                                array_push($ArrayDet,[
                                    'product_code'=>$detail->Product_Code,
                                    'product_name'=>$detail->Product()->first()->P_En_Name,
                                    'unit'=>$detail->Unit()->first()->NameEn,
                                    'return_qty'=>$detail->Recived_Qty,
                                    'qty'=>$detail->Qty,
                                    'price'=>$detail->Price,
                                    'discount'=>$detail->Discount,
                                    'total_bf_tax'=>$detail->Total_Bf_Tax,
                                    'tax'=>$detail->Total_Tax,
                                    'total'=>$detail->Total,
                                    'group'=>$detail->Product()->first()->Group()->first()->NameEn,
                                    'exp_date'=>$detail->Exp_Date,
                                    'store'=>$detail->Store()->first()->NameEn,


                                ]);


                            }

                        }



                        array_push($Array,[
                            'code'=>$sal->Code,
                            'account'=>$sal->Sales()->first()->Client()->first()->Name,
                            'total'=>$bill,
                            'details'=>$ArrayDet,


                        ]);

                    }
                }
            }








            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }




    //FilterPurchasesDailyClosingDetails
    public function FilterPurchasesDailyClosingDetails(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();
            $ArrayDet=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');


            $Purchases =Purchases::orderBy('id','asc')
                ->where('Safe',$safe)
                ->when(!empty($payment), function ($query) use ($payment) {
                    return $query->whereIn('Payment_Method', $payment);
                })
                ->where('Payment_Method','!=','Check')
                ->whereBetween('Date', [$from, $to])
                ->get();



            foreach($Purchases as $purch){
                $details=ProductsPurchases::where('Purchase',$purch->id)->get();
                if($purch->Payment_Method == 'Cash'){

                    $bill=($purch->Total_Price + $purch->Total_Taxes) - $purch->Total_Discount;
                }elseif($purch->Payment_Method == 'Later'){

                    $bill=(($purch->Total_Price + $purch->Total_Taxes) - $purch->Total_Discount) - $purch->Pay;
                }
                if($purch->Pay !=  null){



                    foreach($details as $detail){

                        if($lang == 'ar'){
                            array_push($ArrayDet,[
                                'product_code'=>$detail->Product_Code,
                                'product_name'=>$detail->Product()->first()->P_Ar_Name,
                                'unit'=>$detail->Unit()->first()->Name,
                                'qty'=>$detail->Qty,
                                'price'=>$detail->Price,
                                'discount'=>$detail->Discount,
                                'tax'=>$detail->Total_Tax,
                                'total'=>$detail->Total,
                                'group'=>$detail->Product()->first()->Group()->first()->Name,


                            ]);


                        }else{

                            array_push($ArrayDet,[
                                'product_code'=>$detail->Product_Code,
                                'product_name'=>$detail->Product()->first()->P_En_Name,
                                'unit'=>$detail->Unit()->first()->NameEn,
                                'qty'=>$detail->Qty,
                                'price'=>$detail->Price,
                                'discount'=>$detail->Discount,
                                'tax'=>$detail->Total_Tax,
                                'total'=>$detail->Total,
                                'group'=>$detail->Product()->first()->Group()->first()->NameEn,


                            ]);

                        }


                    }


                    if($lang == 'ar'){
                        array_push($Array,[
                            'code'=>$purch->Code,
                            'account'=>$purch->Vendor()->first()->Name,
                            'total'=>$bill,
                            'details'=>$ArrayDet,


                        ]);

                    }else{

                        array_push($Array,[
                            'code'=>$purch->Code,
                            'account'=>$purch->Vendor()->first()->NameEn,
                            'total'=>$bill,
                            'details'=>$ArrayDet,


                        ]);

                    }


                }
            }






            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


    //FilterRPurchasesDailyClosingDetails
    public function FilterRPurchasesDailyClosingDetails(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');


        if(!empty($admin)){
            $Array=array();
            $ArrayDet=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');


            $ReturnPurch =ReturnPurch::where('Safe',$safe)
                ->whereBetween('Date', [$from, $to])
                ->when(!empty($payment), function ($query) use ($payment) {
                    return $query->whereIn('Payment_Method', $payment);
                })
                ->get();

            $RPCash=0;
            $RPLater=0;



            foreach($ReturnPurch as $sal){
                $details=ProductsPurchases::where('Purchase',$sal->id)->get();
                if($sal->Purchase()->first()->Safe == $safe){
                    if($sal->Payment_Method == 'Cash'){

                        $bill=$sal->Total_Return_Value;
                        $RPCash +=$sal->Total_Return_Value;
                    }elseif($sal->Payment_Method == 'Later'){

                        $bill=$sal->Pay;
                        $RPLater +=$sal->Pay;
                    }

                    if($sal->Pay !=  null){



                        foreach($details as $detail){


                            if($lang == 'ar'){
                                array_push($ArrayDet,[
                                    'product_code'=>$detail->Product_Code,
                                    'product_name'=>$detail->Product()->first()->P_Ar_Name,
                                    'unit'=>$detail->Unit()->first()->Name,
                                    'return_qty'=>$detail->Return_Qty,
                                    'qty'=>$detail->Qty,
                                    'price'=>$detail->Price,
                                    'discount'=>$detail->Discount,
                                    'total_bf_tax'=>$detail->Total_Bf_Tax,
                                    'tax'=>$detail->Total_Tax,
                                    'total'=>$detail->Total,
                                    'group'=>$detail->Product()->first()->Group()->first()->Name,
                                    'exp_date'=>$detail->Exp_Date,
                                    'store'=>$detail->Store()->first()->Name,


                                ]);

                            }else{

                                array_push($ArrayDet,[
                                    'product_code'=>$detail->Product_Code,
                                    'product_name'=>$detail->Product()->first()->P_En_Name,
                                    'unit'=>$detail->Unit()->first()->NameEn,
                                    'return_qty'=>$detail->Return_Qty,
                                    'qty'=>$detail->Qty,
                                    'price'=>$detail->Price,
                                    'discount'=>$detail->Discount,
                                    'total_bf_tax'=>$detail->Total_Bf_Tax,
                                    'tax'=>$detail->Total_Tax,
                                    'total'=>$detail->Total,
                                    'group'=>$detail->Product()->first()->Group()->first()->NameEn,
                                    'exp_date'=>$detail->Exp_Date,
                                    'store'=>$detail->Store()->first()->NameEn,


                                ]);

                            }

                        }

                        if($lang == 'ar'){

                            array_push($Array,[
                                'code'=>$sal->Code,
                                'account'=>$sal->Purchase()->first()->Client()->first()->Name,
                                'total'=>$bill,
                                'details'=>$ArrayDet,


                            ]);

                        }else{

                            array_push($Array,[
                                'code'=>$sal->Code,
                                'account'=>$sal->Purchase()->first()->Client()->first()->NameEn,
                                'total'=>$bill,
                                'details'=>$ArrayDet,


                            ]);

                        }

                    }
                }
            }









            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }



    //FilterSettlement3agzDailyClosingDetails
    public function FilterSettlement3agzDailyClosingDetails(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if(!empty($admin)){
            $Array=array();
            $ArrayDet=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');


            $Setllement3agz =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','تسوية بالعجز')
                ->get();


            foreach($Setllement3agz as $sal){

                $det=Settlement::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();
                $Pros=ProductSettlement::where('Set_ID',$det->id)->get();


                foreach($Pros as $detail){

                    if($lang == 'ar'){
                        array_push($ArrayDet,[
                            'product_name'=>$detail->Product()->first()->P_Ar_Name,
                            'product_code'=>$detail->P_Code,
                            'qty'=>$detail->Av_Qty,
                            'price'=>$detail->Price,
                            'unit'=>$detail->Unit()->first()->Name,
                            'inventory'=>$detail->Inventory,
                            'dificit'=>$detail->Deficit,
                            'execess'=>$detail->Excess,



                        ]);
                    }else{

                        array_push($ArrayDet,[
                            'product_name'=>$detail->Product()->first()->P_En_Name,
                            'product_code'=>$detail->P_Code,
                            'qty'=>$detail->Av_Qty,
                            'price'=>$detail->Price,
                            'unit'=>$detail->Unit()->first()->NameEn,
                            'inventory'=>$detail->Inventory,
                            'dificit'=>$detail->Deficit,
                            'execess'=>$detail->Excess,



                        ]);
                    }

                }


                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account_Dificit()->first()->Name,
                        'total'=>$sal->Debitor_Coin,
                        'details'=>$ArrayDet,


                    ]);

                }else{

                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account_Dificit()->first()->NameEn,
                        'total'=>$sal->Debitor_Coin,
                        'details'=>$ArrayDet,


                    ]);

                }



            }








            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


    //FilterPetrolDailyClosingDetails
    public function FilterPetrolDailyClosingDetails(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if(!empty($admin)){
            $Array=array();
            $ArrayDet=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');



            $SalesPetrol =SalesPetrol::whereBetween('Date', [$from, $to])
                ->where('Safe',$safe)
                ->get();


            foreach($SalesPetrol as $sal){

                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$sal->Code,
                        'account'=>$sal->Safe()->first()->Name,
                        'total'=>$sal->Total,



                    ]);
                }else{
                    array_push($Array,[
                        'code'=>$sal->Code,
                        'account'=>$sal->Safe()->first()->NameEn,
                        'total'=>$sal->Total,



                    ]);


                }

            }







            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


    //FilterShippingDailyClosingDetails
    public function FilterShippingDailyClosingDetails(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if(!empty($admin)){
            $Array=array();
            $ArrayDet=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');



            $shippingTicket =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','البوليصه')
                ->get();



            foreach($shippingTicket as $sal){
                $det=Ticket::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();
                $Prods=TicketProducts::where('Ticket',$det->id)->get();


                foreach($Prods as $detail){

                    if($lang == 'ar'){
                        array_push($ArrayDet,[
                            'product_code'=>$detail->Product_Code,
                            'product_name'=>$detail->P_Ar_Name,
                            'price'=>$detail->Price,
                            'weight'=>$detail->Weight,
                            'length'=>$detail->Length,
                            'width'=>$detail->Width,
                            'height'=>$detail->Height,
                            'qty'=>$detail->Qty,
                            'unit'=>$detail->Unit()->first()->Name,
                            'total'=>$detail->Total,


                        ]);
                    }else{


                        array_push($ArrayDet,[
                            'product_code'=>$detail->Product_Code,
                            'product_name'=>$detail->P_En_Name,
                            'price'=>$detail->Price,
                            'weight'=>$detail->Weight,
                            'length'=>$detail->Length,
                            'width'=>$detail->Width,
                            'height'=>$detail->Height,
                            'qty'=>$detail->Qty,
                            'unit'=>$detail->Unit()->first()->NameEn,
                            'total'=>$detail->Total,


                        ]);


                    }


                }



                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Sender_Name()->first()->Name,
                        'total'=>$sal->Debitor_Coin,
                        'details'=>$ArrayDet,


                    ]);
                }else{


                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Sender_Name()->first()->NameEn,
                        'total'=>$sal->Debitor_Coin,
                        'details'=>$ArrayDet,


                    ]);
                }

            }








            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterMaintainceDailyClosingDetails
    public function FilterMaintainceDailyClosingDetails(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if(!empty($admin)){
            $Array=array();
            $ArrayDet=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');


            $Maintaince =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','الصيانة')
                ->get();


            foreach($Maintaince as $sal){
                $det=ReciptMaintaince::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();
                $products=ProductMaintaincBill::where('Maintaince',$det->id)->get();


                foreach($products as $detail){


                    if($lang == 'ar'){

                        array_push($ArrayDet,[
                            'product_code'=>$detail->Product_Code,
                            'product_name'=>$detail->P_Ar_Name,
                            'qty'=>$detail->Qty,
                            'price'=>$detail->Price,
                            'total'=>$detail->Total,
                            'store'=>$detail->Store()->first()->Name,



                        ]);


                    }else{


                        array_push($ArrayDet,[
                            'product_code'=>$detail->Product_Code,
                            'product_name'=>$detail->P_En_Name,
                            'qty'=>$detail->Qty,
                            'price'=>$detail->Price,
                            'total'=>$detail->Total,
                            'store'=>$detail->Store()->first()->NameEn,



                        ]);


                    }

                }


                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account()->first()->Name,
                        'total'=>$sal->Debitor_Coin,
                        'details'=>$ArrayDet,


                    ]);
                }else{

                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account()->first()->NameEn,
                        'total'=>$sal->Debitor_Coin,
                        'details'=>$ArrayDet,


                    ]);

                }

            }










            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


    //FilterSettlementZyadaDailyClosingDetails
    public function FilterSettlementZyadaDailyClosingDetails(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if(!empty($admin)){
            $Array=array();
            $ArrayDet=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');


            $SetllementZyada =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','تسوية بالزيادة')
                ->get();


            foreach($SetllementZyada as $sal){
                $det=Settlement::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();
                $Pros=ProductSettlement::where('Set_ID',$det->id)->get();


                foreach($Pros as $detail){



                    if($lang == 'ar'){
                        array_push($ArrayDet,[
                            'product_name'=>$detail->Product()->first()->P_Ar_Name,
                            'product_code'=>$detail->P_Code,
                            'qty'=>$detail->Av_Qty,
                            'price'=>$detail->Price,
                            'unit'=>$detail->Unit()->first()->Name,
                            'inventory'=>$detail->Inventory,
                            'dificit'=>$detail->Deficit,
                            'execess'=>$detail->Excess,



                        ]);
                    }else{

                        array_push($ArrayDet,[
                            'product_name'=>$detail->Product()->first()->P_En_Name,
                            'product_code'=>$detail->P_Code,
                            'qty'=>$detail->Av_Qty,
                            'price'=>$detail->Price,
                            'unit'=>$detail->Unit()->first()->NameEn,
                            'inventory'=>$detail->Inventory,
                            'dificit'=>$detail->Deficit,
                            'execess'=>$detail->Excess,



                        ]);

                    }

                }

                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account_Excess()->first()->Name,
                        'total'=>$sal->Debitor_Coin,
                        'details'=>$ArrayDet,


                    ]);
                }else{

                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account_Excess()->first()->NameEn,
                        'total'=>$sal->Debitor_Coin,
                        'details'=>$ArrayDet,


                    ]);
                }

            }






            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }

    //FilterRMaintainceDailyClosingDetails
    public function FilterRMaintainceDailyClosingDetails(Request $request){

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        $admin=Admin::where('token',$x)->first();
        $lang = $request->header('lang', '');

        if(!empty($admin)){
            $Array=array();
            $ArrayDet=array();

            $from = $request->get('From');
            $to = $request->get('To');
            $safe = $request->get('Safe');
            $payment = $request->get('Payment_Method');



            $RMaintaince =GeneralDaily::whereBetween('Date', [$from, $to])
                ->where('Account',$safe)
                ->where('Type','مرتجع الصيانة')
                ->get();


            foreach($RMaintaince as $sal){
                $det=ReturnMaintainceBill::where('Code',$sal->Code_Type)->orderBy('id','desc')->first();
                $products=ProductsReturnMaintainceBill::where('Return',$det->id)->get();


                foreach($products as $detail){



                    if($lang == 'ar'){
                        array_push($ArrayDet,[
                            'product_code'=>$detail->Product_Code,
                            'product_name'=>$detail->P_Ar_Name,
                            'qty'=>$detail->Recived_Qty,
                            'price'=>$detail->Price,
                            'total'=>$detail->Total,
                            'store'=>$detail->Store()->first()->Name,



                        ]);
                    }else{

                        array_push($ArrayDet,[
                            'product_code'=>$detail->Product_Code,
                            'product_name'=>$detail->P_En_Name,
                            'qty'=>$detail->Recived_Qty,
                            'price'=>$detail->Price,
                            'total'=>$detail->Total,
                            'store'=>$detail->Store()->first()->NameEn,



                        ]);


                    }

                }

                if($lang == 'ar'){
                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account()->first()->Name,
                        'total'=>$sal->Creditor_Coin,
                        'details'=>$ArrayDet,


                    ]);
                }else{

                    array_push($Array,[
                        'code'=>$sal->Code_Type,
                        'account'=>$det->Account()->first()->NameEn,
                        'total'=>$sal->Creditor_Coin,
                        'details'=>$ArrayDet,


                    ]);
                }
            }



            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'data'=>$Array,

            ]);


        }else{

            return response()->json([
                'status'=>403,
                'message'=>trans('admin.Logoutt'),
            ]);

        }
    }


    //=================================================

    //NetPurchasesFilterApi
    public function NetPurchasesFilterApi(Request $request){

        $search = $request->get('search');
        $From = $request->get('From');
        $To = $request->get('To');
        $Vendor = $request->get('Vendor');
        $Coin = $request->get('Coin');
        $Safe = $request->get('Safe');
        $Payment_Method = $request->get('Payment_Method');
        $Cost_Center = $request->get('Cost_Center');
        $Delegate = $request->get('Delegate');
        $User = $request->get('User');
        $group = $request->get('group');
        $Store = $request->get('Store');
        $Type = $request->get('Type');
        $Code = $request->get('Code');


        $Purchs=ProductsPurchases::whereBetween('Date', [$From,$To])

            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->whereRelation('Purchase','Vendor',$Vendor);

            })

            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->whereRelation('Purchase','Coin',$Coin);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Purchase','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Purchase','Payment_Method',$Payment_Method);

            })


            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->whereRelation('Purchase','Cost_Center',$Cost_Center);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Purchase','Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->whereRelation('Purchase','User',$User);

            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Purchase','Store',$Store);

            })

            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->whereRelation('Purchase','Type',$Type);

            })

            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Purchase','Code',$Code);

            })



            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")

                    ;

            })


            ->whereRelation('Purchase','Edit',0)
            ->whereRelation('Purchase','Delete',0)
            ->paginate(50);




        $PCount=ProductsPurchases::whereBetween('Date', [$From,$To])

            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->whereRelation('Purchase','Vendor',$Vendor);

            })

            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->whereRelation('Purchase','Coin',$Coin);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Purchase','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Purchase','Payment_Method',$Payment_Method);

            })


            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->whereRelation('Purchase','Cost_Center',$Cost_Center);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Purchase','Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->whereRelation('Purchase','User',$User);

            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Purchase','Store',$Store);

            })

            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->whereRelation('Purchase','Type',$Type);

            })

            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Purchase','Code',$Code);

            })



            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")

                    ;

            })


            ->whereRelation('Purchase','Edit',0)
            ->whereRelation('Purchase','Delete',0)

            ->count();

        $PRCount=ReturnPurchProducts::whereBetween('Date', [$From,$To])

            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->where('Vendor',$Vendor);

            })

            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->where('Coin',$Coin);

            })

            ->when(!empty($group), function ($query) use ($group) {
                return $query->where('Group',$group);

            })

            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->where('Payment_Method',$Payment_Method);

            })


            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->where('Cost_Center',$Cost_Center);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->where('User',$User);

            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })

            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->where('Type',$Type);

            })

            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->where('Code',$Code);

            })



            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")

                    ;

            })


            ->count();


        $TotalDiscount=0;


        $TotalTax=ProductsPurchases::whereBetween('Date', [$From,$To])

            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->whereRelation('Purchase','Vendor',$Vendor);

            })

            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->whereRelation('Purchase','Coin',$Coin);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Purchase','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Purchase','Payment_Method',$Payment_Method);

            })


            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->whereRelation('Purchase','Cost_Center',$Cost_Center);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Purchase','Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->whereRelation('Purchase','User',$User);

            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Purchase','Store',$Store);

            })

            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->whereRelation('Purchase','Type',$Type);

            })

            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Purchase','Code',$Code);

            })



            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")

                    ;

            })


            ->whereRelation('Purchase','Edit',0)
            ->whereRelation('Purchase','Delete',0)
            ->get()->sum('Total_Tax');


        $DiscountOnBill=Purchases::whereBetween('Date', [$From,$To])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('DiscountBill');

        $data=NetPurchasesFilterApiResources::collection($Purchs);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'Purchases_Count'=>$PCount,
            'Purchases_Return_Count'=>$PRCount,
            'Total_Tax'=>$TotalTax,
            'Discount_On_Bill'=>$DiscountOnBill,


        ];

        return $data->additional($x) ;


    }

    //TotalNetPurchasesApi
    public function TotalNetPurchasesApi(Request $request){

        $search = $request->get('search');
        $From = $request->get('From');
        $To = $request->get('To');
        $group = $request->get('group');
        $Store = $request->get('Store');



        $Purchs=ProductsPurchases::

        when(!empty($search), function ($query) use ($search) {
            return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                ->orWhere('V_Name','ILIKE', "%{$search}%")
                ->orWhere('VV_Name','ILIKE', "%{$search}%")
                ->orWhere('Product_Code','ILIKE', "%{$search}%")
                ;
        })


            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })
            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereRelation('Product','Group',$group);

            })
            ->whereRelation('Purchase','Edit',0)
            ->whereRelation('Purchase','Delete',0)
            ->whereBetween('Date', [$From,$To])

            ->paginate(50);


        $ProdsCount=ProductsPurchases::orderBy('id','asc')
            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")


                    ;
            })
            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })
            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereRelation('Product','Group',$group);

            })
            ->whereRelation('Purchase','Edit',0)
            ->whereRelation('Purchase','Delete',0)
            ->whereBetween('Date', [$From,$To])
            ->count();



        $DiscountOnBill=Purchases::whereBetween('Date', [$From,$To])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('DiscountBill');

        $data=TotalNetPurchasesApiResources::collection($Purchs);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'Purchases_Count'=>$ProdsCount,
            'Discount_On_Bill'=>$DiscountOnBill,


        ];

        return $data->additional($x) ;


    }

    //VendorPurchasesApi
    public function VendorPurchasesApi(Request $request){
        $lang = $request->header('lang', '');
        $From = $request->get('From');
        $To = $request->get('To');
        $Client = $request->get('Vendor');

        $qty=ProductsPurchases::

        when(!empty($From), function ($query) use ($From,$To) {
            return $query->whereBetween('Date',[$From,$To]);

        })

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Purchase','Vendor',$Client);

            })

            ->whereRelation('Purchase','Edit',0)
            ->whereRelation('Purchase','Delete',0)
            ->get()->sum('Qty');
        $tot=ProductsPurchases::

        when(!empty($From), function ($query) use ($From,$To) {
            return $query->whereBetween('Date',[$From,$To]);

        })

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Purchase','Vendor',$Client);

            })

            ->whereRelation('Purchase','Edit',0)
            ->whereRelation('Purchase','Delete',0)
            ->get()->sum('Total_Net');

        $Sales=ProductsPurchases::

        when(!empty($From), function ($query) use ($From,$To) {
            return $query->whereBetween('Date',[$From,$To]);

        })

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Purchase','Vendor',$Client);

            })

            ->whereRelation('Purchase','Edit',0)
            ->whereRelation('Purchase','Delete',0)
            ->paginate(50);



        $cust=AcccountingManual::find($Client);



        if(!empty($cust)){
            if($lang == 'ar' ){
                $cName=$cust->Name;

            }else{
                $cName=$cust->NameEn;

            }
        }else{

            $cName='';

        }

        $data=VendorPurchasesApiResources::collection($Sales);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'Vendor'=>$cName,
            'Total_Qty'=>$qty,
            'Total_Price'=>$tot,

        ];

        return $data->additional($x) ;




    }

    //VendorPricesReportApi
    public function VendorPricesReportApi(Request $request){
        $lang = $request->header('lang', '');
        $search = $request->get('search');
        $Date = $request->get('Date');
        $Vendor = $request->get('Vendor');

        $Prods=ProductsPurchases::

        when(!empty($Date), function ($query) use ($Date) {
            return $query->where('Date', $Date);

        })
            ->when(!empty($Vendor), function ($query) use ($Vendor) {
                return $query->whereIn('Vendor', $Vendor);

            })

            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%");

            })

            ->whereRelation('Purchase','Edit',0)
            ->whereRelation('Purchase','Delete',0)
            ->paginate(100);

        $data=VendorPricesReportApiResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),


        ];

        return $data->additional($x) ;




    }

    //PurchasesBillsApi
    public function PurchasesBillsApi(Request $request){

        $from=$request->get('from');
        $to=$request->get('to');
        $branch=$request->get('branch');
        $clients_Group=$request->get('clients_Group');
        $cost_Center=$request->get('cost_Center');
        $coin=$request->get('coin');
        $code=$request->get('code');
        $refrence_Number=$request->get('refrence_Number');
        $store=$request->get('store');
        $safe=$request->get('safe');
        $client=$request->get('vendor');
        $payment_Method=$request->get('payment_Method');
        $delegate=$request->get('delegate');
        $user=$request->get('user');
        $shipping_Company=$request->get('shipping_Company');
        $types=$request->get('types');


        $items=Purchases::whereBetween('Date',[$from,$to])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                return $query->where('CustomerGroup', $clients_Group);
            })

            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })


            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Code', $code);
            })



            ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                return $query->where('Refernce_Number', $refrence_Number);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })



            ->when(!empty($client), function ($query) use ($client) {
                return $query->whereIn('Vendor', $client);
            })


            ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                return $query->whereIn('Payment_Method', $payment_Method);
            })


            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })




            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })

            ->when(!empty($types), function ($query) use ($types) {
                return $query->whereIn('Status', $types);
            })
            ->where('Edit',0)
            ->where('Delete',0)
            ->paginate(20);



        $Total_Qty=Purchases::whereBetween('Date',[$from,$to])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                return $query->where('CustomerGroup', $clients_Group);
            })

            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })


            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Code', $code);
            })




            ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                return $query->where('Refernce_Number', $refrence_Number);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })



            ->when(!empty($client), function ($query) use ($client) {
                return $query->whereIn('Vendor', $client);
            })


            ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                return $query->whereIn('Payment_Method', $payment_Method);
            })


            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })

            ->when(!empty($types), function ($query) use ($types) {
                return $query->whereIn('Status', $types);
            })
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Qty');



        $Total_Discount=Purchases::whereBetween('Date',[$from,$to])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                return $query->where('CustomerGroup', $clients_Group);
            })

            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })


            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Code', $code);
            })




            ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                return $query->where('Refernce_Number', $refrence_Number);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })



            ->when(!empty($client), function ($query) use ($client) {
                return $query->whereIn('Vendor', $client);
            })


            ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                return $query->whereIn('Payment_Method', $payment_Method);
            })


            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })

            ->when(!empty($types), function ($query) use ($types) {
                return $query->whereIn('Status', $types);
            })
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Discount');


        $Total_Tax=Purchases::whereBetween('Date',[$from,$to])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                return $query->where('CustomerGroup', $clients_Group);
            })

            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })


            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Code', $code);
            })




            ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                return $query->where('Refernce_Number', $refrence_Number);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })



            ->when(!empty($client), function ($query) use ($client) {
                return $query->whereIn('Vendor', $client);
            })


            ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                return $query->whereIn('Payment_Method', $payment_Method);
            })


            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })




            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })

            ->when(!empty($types), function ($query) use ($types) {
                return $query->whereIn('Status', $types);
            })
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Taxes');


        $Total_TaxT=Purchases::whereBetween('Date',[$from,$to])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                return $query->where('CustomerGroup', $clients_Group);
            })

            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })


            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Code', $code);
            })




            ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                return $query->where('Refernce_Number', $refrence_Number);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })

            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })



            ->when(!empty($client), function ($query) use ($client) {
                return $query->whereIn('Vendor', $client);
            })


            ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                return $query->whereIn('Payment_Method', $payment_Method);
            })


            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })




            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })

            ->when(!empty($types), function ($query) use ($types) {
                return $query->whereIn('Status', $types);
            })
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('ProfitTax');



        $Total_Bills=Purchases::whereBetween('Date',[$from,$to])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                return $query->where('CustomerGroup', $clients_Group);
            })

            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })


            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Code', $code);
            })




            ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                return $query->where('Refernce_Number', $refrence_Number);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })


            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })

            ->when(!empty($client), function ($query) use ($client) {
                return $query->whereIn('Vendor', $client);
            })


            ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                return $query->whereIn('Payment_Method', $payment_Method);
            })


            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })



            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })

            ->when(!empty($types), function ($query) use ($types) {
                return $query->whereIn('Status', $types);
            })
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Price');


        $Total_Return=ReturnPurch::whereBetween('Date',[$from,$to])
            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                return $query->where('CustomerGroup', $clients_Group);
            })

            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })


            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Code', $code);
            })




            ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                return $query->where('Refernce_Number', $refrence_Number);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })



            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })

            ->when(!empty($client), function ($query) use ($client) {
                return $query->whereIn('Vendor', $client);
            })


            ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                return $query->whereIn('Payment_Method', $payment_Method);
            })


            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })




            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })

            ->get()->sum('Total_Return_Value');



        $Bills_Nums=Purchases::whereBetween('Date',[$from,$to])

            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                return $query->where('CustomerGroup', $clients_Group);
            })

            ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                return $query->where('Cost_Center', $cost_Center);
            })


            ->when(!empty($coin), function ($query) use ($coin) {
                return $query->where('Coin', $coin);
            })


            ->when(!empty($code), function ($query) use ($code) {
                return $query->where('Code', $code);
            })




            ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                return $query->where('Refernce_Number', $refrence_Number);
            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store', $store);
            })


            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })

            ->when(!empty($client), function ($query) use ($client) {
                return $query->whereIn('Vendor', $client);
            })


            ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                return $query->whereIn('Payment_Method', $payment_Method);
            })


            ->when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })




            ->when(!empty($user), function ($query) use ($user) {
                return $query->whereIn('User', $user);
            })

            ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                return $query->whereIn('Ship', $shipping_Company);
            })

            ->when(!empty($types), function ($query) use ($types) {
                return $query->whereIn('Status', $types);
            })
            ->where('Edit',0)
            ->where('Delete',0)
            ->count();

        $TotalTax= $Total_Tax + $Total_TaxT ;
        $Total_Net= ($TotalTax + $Total_Bills) - $Total_Discount ;


        $data=PurchasesBillsApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'Total_Qty'=>$Total_Qty,
            'Total_Discount'=>$Total_Discount,
            'Total_Bills'=>$Total_Bills,
            'Total_Return'=>$Total_Return,
            'Bills_Nums'=>$Bills_Nums,
            'TotalTax'=>$TotalTax,
            'Total_Net'=>$Total_Net,

        ];

        return $data->additional($x) ;


    }


    //========

//DailyProductsApi
    public function DailyProductsApi(Request $request){
        $lang = $request->header('lang', '');
        $from = $request->get('From');
        $to = $request->get('To');
        $Safe = $request->get('Safe');
        $Dele = $request->get('Dele');
        $array=[];

        $shift=Shifts::whereBetween('Date',[$from,$to])->latest('id')->get('Code');
        foreach($shift as $sh) {

            array_push($array, [
                $sh->Code,
            ]);
        }
            $Sales = Sales::latest('id')
                ->where('Sale_Type', 'POS')
                ->where('Status', 1)
                ->when(!empty($array), function ($query) use ($array) {
                    return $query->whereIn('Shift_Code', $array);

                })
                ->when(!empty($Safe), function ($query) use ($Safe) {
                    return $query->where('Safe', $Safe);

                })
                ->when(!empty($Dele), function ($query) use ($Dele) {
                    return $query->where('Delegate', $Dele);

                })
                ->paginate(50);

        $data=DailyProductsApiResources::collection($Sales);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),


        ];

        return $data->additional($x) ;




    }


//ShiftsReportApi
    public function ShiftsReportApi(Request $request){
        $lang = $request->header('lang', '');
        $Date = $request->get('Date');
        $Shift = $request->get('Shift');
        $Emp = $request->get('Emp');
        $Store = $request->get('Store');
        $Safe = $request->get('Safe');


        $Purchs=Shifts::latest('id')

            ->when(!empty($Date), function ($query) use ($Date) {
                return $query->where('Date',$Date);

            })
            ->when(!empty($Shift), function ($query) use ($Shift) {
                return $query->where('Code',$Shift);

            })
            ->when(!empty($Emp), function ($query) use ($Emp) {
                return $query->where('Emp',$Emp);

            })
            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })
            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe',$Safe);

            })

            ->paginate(20);


        $data=ShiftsReportApiResources::collection($Purchs);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),


        ];

        return $data->additional($x) ;




    }


//ShiftsDetailsReportApi
        public function ShiftsDetailsReportApi(Request $request){
        $lang = $request->header('lang', '');
            $code=request('Code');
            $Store=request('Store');
            $Safe=request('Safe');
            $Delegate=request('Delegate');
            $Emp=request('Emp');


            $items=Sales::orderBy('id','desc')
                ->where('Sale_Type','POS')
                ->where('Status',1)
                ->where('Hold',0)
                ->whereBetween('Date', [request('From'), request('To')])
                ->where('Edit',0)
                ->where('Delete',0)
                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Shift_Code',$code);

                })
                ->when(!empty($Store), function ($query) use ($Store) {
                    return $query->where('Store',$Store);

                })
                ->when(!empty($Safe), function ($query) use ($Safe) {
                    return $query->where('Safe',$Safe);

                })
                ->when(!empty($Delegate), function ($query) use ($Delegate) {
                    return $query->where('Delegate',$Delegate);

                })
                ->when(!empty($Emp), function ($query) use ($Emp) {
                    return $query->where('Executor',$Emp);

                })
                ->get();


            $Recipts=ReciptVoucher::where('Shift','!=',null)
                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Shift',$code);

                })
                ->when(!empty($Safe), function ($query) use ($Safe) {
                    return $query->where('Safe',$Safe);

                })
                ->get();

            $Payments=PaymentVoucher::where('Shift','!=',null)
                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Shift',$code);

                })
                ->when(!empty($Safe), function ($query) use ($Safe) {
                    return $query->where('Safe',$Safe);

                })
                ->get();

        $dataSales=ShiftsDetailsReportSalesApiResources::collection($items);
        $dataRecipts=ShiftsDetailsReportReciptApiResources::collection($Recipts);
        $dataPayment=ShiftsDetailsReportPaymentApiResources::collection($Payments);


            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'sales'=>$dataSales,
                'recipts'=>$dataRecipts,
                'payment'=>$dataPayment,
            ]);

        }


//DailyShiftsApi
        public function DailyShiftsApi(Request $request){
        $lang = $request->header('lang', '');

            $Date = $request->get('Date');
            $Safe = $request->get('Safe');

            if($Date != ''){

                $DateName='where';
                $DateC='Date';
                $DateCC=$Date;

            }else{

                $DateName='orderBy';
                $DateC='id';
                $DateCC='desc';

            }

            if($Safe != ''){

                $SafeName='where';
                $SafeC='Safe';
                $SafeCC=$Safe;

            }else{

                $SafeName='orderBy';
                $SafeC='id';
                $SafeCC='desc';

            }

            $Count=Shifts::orderBy('id','desc')
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->count();

            $Total_Cash=Shifts::where('Close',1)
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get()->sum('Total_Cash');

            $Total_Later=Shifts::where('Close',1)
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get()->sum('Total_Later');

            $Total_LaterNot=Shifts::where('Close',1)
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get()->sum('Total_Later_Not_Paid');

            $Total_LaterPaid=Shifts::where('Close',1)
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get()->sum('Total_Later_Paid');


            $Total_Visa=Shifts::where('Close',1)
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get()->sum('Total_Visa');

            $Total_Recipt=Shifts::where('Close',1)
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get()->sum('Total_Recipt');

            $Total_Payment=Shifts::where('Close',1)
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get()->sum('Total_Payment');

            $Total=Shifts::where('Close',1)
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get()->sum('Total');

            $Amount=Shifts::where('Close',1)
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get()->sum('Amount');

            $Total_Installment=Shifts::where('Close',1)
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get()->sum('Total_Installment');

            $Total_Checks=Shifts::where('Close',1)
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get()->sum('Total_Checks');

            $Total_Delivery=Shifts::where('Close',1)
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get()->sum('Total_Delivery');

            $Total_Installment_Companies=Shifts::where('Close',1)
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get()->sum('Total_Installment_Companies');


            $Shifts=Shifts::orderBy('id','desc')
                ->$DateName($DateC,$DateCC)
                ->$SafeName($SafeC,$SafeCC)
                ->get();

            $dif= $Total - $Amount;

            $dataShift_Details=DailyShiftsDetailsShiftApiResources::collection($Shifts);
            $details=DailyShiftsDetailsApiResources::collection($Shifts);



            return response()->json([
                'status'=>200,
                'message'=>trans('admin.Success'),
                'Date'=>$Date,
                'Count'=>$Count,
                'Total_Cash'=>$Total_Cash,
                'Total_Later'=>$Total_Later,
                'Total_LaterNot'=>$Total_LaterNot,
                'Total_LaterPaid'=>$Total_LaterPaid,
                'Total_Installment'=>$Total_Installment,
                'Total_Checks'=>$Total_Checks,
                'Total_Delivery'=>$Total_Delivery,
                'Total_Installment_Companies'=>$Total_Installment_Companies,
                'Total_Visa'=>$Total_Visa,
                'Total_Recipt'=>$Total_Recipt,
                'Total_Payment'=>$Total_Payment,
                'Total'=>$Total,
                'Amount'=>$Amount,
                'dif'=>$dif,
                'Shift_Details'=>$dataShift_Details,
                'Details'=>$details,
            ]);



        }

//=========

//ReportStartPeriodApi
        public function ReportStartPeriodApi(Request $request){
        $lang = $request->header('lang', '');
            $From = $request->get('From');
            $To = $request->get('To');
            $User = $request->get('User');
            $group = $request->get('group');
            $Store = $request->get('Store');
            $search = $request->get('search');



            $Prods=ProductsStartPeriods::whereBetween('Date', [$From,$To])
                ->when(!empty($Store), function ($query) use ($Store) {
                    return $query->where('Store',$Store);

                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group',$group);

                })
                ->when(!empty($User), function ($query) use ($User) {
                    return $query->where('User',$User);

                })
                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")

                        ;

                })
                ->paginate(100);


            $ProdsTotal=ProductsStartPeriods::whereBetween('Date', [$From,$To])

                ->when(!empty($Store), function ($query) use ($Store) {
                    return $query->where('Store',$Store);

                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group',$group);

                })
                ->when(!empty($User), function ($query) use ($User) {
                    return $query->where('User',$User);

                })


                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")

                        ;

                })


                ->get()->sum('Total');


            $ProdsQty=ProductsStartPeriods::whereBetween('Date', [$From,$To])

                ->when(!empty($Store), function ($query) use ($Store) {
                    return $query->where('Store',$Store);

                })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group',$group);

                })
                ->when(!empty($User), function ($query) use ($User) {
                    return $query->where('User',$User);

                })


                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")

                        ;

                })


                ->get()->sum('Qty');


            $data=ReportStartPeriodApiResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),

            'Total_Price'=>$ProdsTotal,
            'Total_Qty'=>$ProdsQty,

        ];

        return $data->additional($x) ;




    }


//SettlementsReportsApi
        public function SettlementsReportsApi(Request $request){
        $lang = $request->header('lang', '');
            $From = $request->get('From');
            $To = $request->get('To');
            $User = $request->get('User');
            $group = $request->get('group');
            $Store = $request->get('Store');
            $search = $request->get('search');
            $Coin = $request->get('Coin');
            $Type = $request->get('Type');

            $Prods=ProductSettlement::whereBetween('Date', [$From,$To])

                ->when(!empty($Store), function ($query) use ($Store) {
                    return $query->where('Store',$Store);

                })

                ->when(!empty($User), function ($query) use ($User) {
                    return $query->where('User',$User);

                })

                ->when(!empty($Coin), function ($query) use ($Coin) {
                    return $query->where('Coin',$Coin);

                })

                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")

                        ;

                })


                ->when(!empty($group), function ($query) use ($group) {
                    return $query->whereRelation('Product','Group',$group);

                })
                ->paginate(50);


        $data=SettlementsReportsApiResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),


        ];

        return $data->additional($x) ;




    }

//ExpiredProuctsApi
        public function ExpiredProuctsApi(Request $request){
        $lang = $request->header('lang', '');
            $search = $request->get('search');
            $store = $request->get('Store');
            $group = $request->get('group');
            $To = $request->get('To');

            $Prods=ExpireDateQty::

            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);

            })



                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")

                        ;

                })



                ->paginate(10);

            $ProdsCount=ExpireDateQty::

            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store',$store);

            })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group',$group);

                })


                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")

                        ;

                })


                ->count();



            $data=ExpiredProuctsApiResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'count'=>$ProdsCount,


        ];

        return $data->additional($x) ;




    }


//ProductOrderLimitApi
    public function ProductOrderLimitApi(Request $request){
        $lang = $request->header('lang', '');
        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $Search_Type = $request->get('Search_Type');

        if($Search_Type == 1){

            $Prods =ProductUnits::

            when(!empty($search), function ($query) use ($search) {
                return $query->where('Barcode','ILIKE', "%{$search}%")
                    ->orWhere('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ;

            })

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group',$group);

                })
                ->paginate(50);


            $ProdsCount=ProductUnits::

            join('products_qties', 'product_units.Product', '=', 'products_qties.Product')
                ->join('products', 'products_qties.Product', '=', 'products.id')

                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group',$group);

                })

                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('product_units.Barcode','ILIKE', "%{$search}%")
                        ->orWhere('product_units.P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('product_units.P_En_Name','ILIKE', "%{$search}%")
                        ;

                })



                ->where('products_qties.Qty','=','products.Minimum')


                ->count();


        }else{

            $Prods=ProductsQty::

            when(!empty($store), function ($query) use ($store) {
                return $query->where('Store', $store);
            })
                ->when(!empty($group), function ($query) use ($group) {
                    return $query->where('Group',$group);

                })

                ->when(!empty($search), function ($query) use ($search) {
                    return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                        ->orWhere('V_Name','ILIKE', "%{$search}%")
                        ->orWhere('VV_Name','ILIKE', "%{$search}%")
                        ->orWhere('P_Code','ILIKE', "%{$search}%")
                        ->orWhere('PP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                        ->orWhere('PPPP_Code','ILIKE', "%{$search}%")
                        ;
                })

                ->paginate(50);



            $ProdsCount=0;

        }




        $data=ProductOrderLimitApiResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'count'=>$ProdsCount,


        ];

        return $data->additional($x) ;




    }


//StoresTransferReportApi
        public function StoresTransferReportApi(Request $request){
        $lang = $request->header('lang', '');
            $from=$request->get('from');
            $to=$request->get('to');
            $branch=$request->get('branch');
            $coin=$request->get('coin');
            $code=$request->get('code');
            $value=$request->get('value');
            $qty=$request->get('qty');
            $fromStore=$request->get('fromStore');
            $toStore=$request->get('toStore');
            $delegate=$request->get('delegate');
            $user=$request->get('user');
            $shipping_Company=$request->get('shipping_Company');
            $types=$request->get('types');



            $items=StorsTransfers::whereBetween('Date',[$from,$to])

                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })



                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })

                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })



                ->when(!empty($value), function ($query) use ($value) {
                    return $query->where('Total','>=', $value);
                })


                ->when(!empty($qty), function ($query) use ($qty) {
                    return $query->where('TotalQty','>=', $qty);
                })

                ->when(!empty($fromStore), function ($query) use ($fromStore) {
                    return $query->whereIn('From_Store', $fromStore);
                })

                ->when(!empty($toStore), function ($query) use ($toStore) {
                    return $query->whereIn('To_Store', $toStore);
                })

                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whewhereInre('Ship', $shipping_Company);
                })

                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })



                ->paginate(10);


            $Total_Qty=StorsTransfers::whereBetween('Date',[$from,$to])

                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })

                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })



                ->when(!empty($value), function ($query) use ($value) {
                    return $query->where('Total','>=', $value);
                })


                ->when(!empty($qty), function ($query) use ($qty) {
                    return $query->where('TotalQty','>=', $qty);
                })

                ->when(!empty($fromStore), function ($query) use ($fromStore) {
                    return $query->whereIn('From_Store', $fromStore);
                })

                ->when(!empty($toStore), function ($query) use ($toStore) {
                    return $query->whereIn('To_Store', $toStore);
                })

                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whewhereInre('Ship', $shipping_Company);
                })

                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })

                ->get()->sum('TotalQty');



            $Total_Price=StorsTransfers::whereBetween('Date',[$from,$to])

                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })

                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })



                ->when(!empty($value), function ($query) use ($value) {
                    return $query->where('Total','>=', $value);
                })


                ->when(!empty($qty), function ($query) use ($qty) {
                    return $query->where('TotalQty','>=', $qty);
                })

                ->when(!empty($fromStore), function ($query) use ($fromStore) {
                    return $query->whereIn('From_Store', $fromStore);
                })

                ->when(!empty($toStore), function ($query) use ($toStore) {
                    return $query->whereIn('To_Store', $toStore);
                })

                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whewhereInre('Ship', $shipping_Company);
                })

                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })



                ->get()->sum('Total');


            $Bills_Nums=StorsTransfers::whereBetween('Date',[$from,$to])

                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })

                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })



                ->when(!empty($value), function ($query) use ($value) {
                    return $query->where('Total','>=', $value);
                })


                ->when(!empty($qty), function ($query) use ($qty) {
                    return $query->where('TotalQty','>=', $qty);
                })

                ->when(!empty($fromStore), function ($query) use ($fromStore) {
                    return $query->whereIn('From_Store', $fromStore);
                })

                ->when(!empty($toStore), function ($query) use ($toStore) {
                    return $query->whereIn('To_Store', $toStore);
                })

                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whewhereInre('Ship', $shipping_Company);
                })

                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })



                ->count();


            $data=StoresTransferReportApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'Total_Qty'=>$Total_Qty,
            'Total_Price'=>$Total_Price,
            'Bills_Nums'=>$Bills_Nums,


        ];

        return $data->additional($x) ;




    }

//ReturnWithoutBillReportApi
        public function ReturnWithoutBillReportApi(Request $request){
        $lang = $request->header('lang', '');
            $from = $request->get('from');
            $to = $request->get('to');
            $Store = $request->get('Store');
            $Account = $request->get('Account');
            $Delegate = $request->get('Delegate');
            $Safe = $request->get('Safe');
            $Payment = $request->get('Payment_Method');

            $items = ReturnWithoutBill::whereBetween('Date', [$from, $to])

                ->when(!empty($Safe), function ($query) use ($Safe) {
                    return $query->where('Safe', $Safe);

                })
                ->when(!empty($Account), function ($query) use ($Account) {
                    return $query->where('Vendor', $Account);

                })

                ->when(!empty($Delegate), function ($query) use ($Delegate) {
                    return $query->where('Delegate', $Delegate);

                })

                ->when(!empty($Store), function ($query) use ($Store) {
                    return $query->where('Store', $Store);

                })
                ->when(!empty($Payment), function ($query) use ($Payment) {
                    return $query->where('Payment_Method', $Payment);

                })
                ->where('Delete','!=',1)
                ->paginate(50);

            $TotalPrice = ReturnWithoutBill::whereBetween('Date', [$from, $to])

                ->when(!empty($Safe), function ($query) use ($Safe) {
                    return $query->where('Safe', $Safe);

                })
                ->when(!empty($Account), function ($query) use ($Account) {
                    return $query->where('Vendor', $Account);

                })

                ->when(!empty($Delegate), function ($query) use ($Delegate) {
                    return $query->where('Delegate', $Delegate);

                })

                ->when(!empty($Store), function ($query) use ($Store) {
                    return $query->where('Store', $Store);

                })
                ->when(!empty($Payment), function ($query) use ($Payment) {
                    return $query->where('Payment_Method', $Payment);

                })
                ->where('Delete','!=',1)
                ->get()->sum('Total_Price');

            $TotalCost = ReturnWithoutBill::whereBetween('Date', [$from, $to])

                ->when(!empty($Safe), function ($query) use ($Safe) {
                    return $query->where('Safe', $Safe);

                })
                ->when(!empty($Account), function ($query) use ($Account) {
                    return $query->where('Vendor', $Account);

                })

                ->when(!empty($Delegate), function ($query) use ($Delegate) {
                    return $query->where('Delegate', $Delegate);

                })

                ->when(!empty($Store), function ($query) use ($Store) {
                    return $query->where('Store', $Store);

                })
                ->when(!empty($Payment), function ($query) use ($Payment) {
                    return $query->where('Payment_Method', $Payment);

                })
                ->where('Delete','!=',1)
                ->get()->sum('Total_Cost');

        $data=ReturnWithoutBillReportApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'TotalPrice'=>$TotalPrice,
            'TotalCost'=>$TotalCost,


        ];

        return $data->additional($x) ;




    }

//=====


//StagnantItemsTwoFilterApi
    public function StagnantItemsTwoFilterApi(Request $request){
        $lang = $request->header('lang', '');
        $group = $request->get('group');
        $Store = $request->get('Store');
        $From = $request->get('From');
        $To = $request->get('To');
        $Max = $request->get('Max');
        $search = $request->get('search');



        $Prods=ProductsQty::

        when(!empty($Store), function ($query) use ($Store) {
            return $query->whereIn('Store',$Store);

        })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->where('Group', $group);
            })

            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_Code','ILIKE', "%{$search}%")
                    ->orWhere('PP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                    ->orWhere('PPPP_Code','ILIKE', "%{$search}%")

                    ;

            })



            ->distinct(['Product'])->paginate(10);



        $data=StagnantItemsTwoFilterApiResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),


        ];

        return $data->additional($x) ;




    }

//MostSalesProductsApi
    public function MostSalesProductsApi(Request $request){
        $lang = $request->header('lang', '');
        $from=$request->get('from');
        $to=$request->get('to');
        $store=$request->get('store');
        $safe=$request->get('safe');
        $group=$request->get('group');
        $brand=$request->get('brand');
        $branch=$request->get('branch');
        $product_Name=$request->get('product_Name');
        $product_Code=$request->get('product_Code');


        $items=ProductSales::whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store',$store);
            })


            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })



            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->distinct(['Product'])->paginate(10);

        $data=MostSalesProductsApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),


        ];

        return $data->additional($x) ;




    }

//SalesBillsApi
        public function SalesBillsApi(Request $request){

        $from=$request->get('from');
        $to=$request->get('to');
        $branch=$request->get('branch');
        $clients_Group=$request->get('clients_Group');
        $cost_Center=$request->get('cost_Center');
        $coin=$request->get('coin');
        $code=$request->get('code');
        $refrence_Number=$request->get('refrence_Number');
        $shift_Code=$request->get('shift_Code');
        $store=$request->get('store');
        $safe=$request->get('safe');
        $client=$request->get('client');
        $payment_Method=$request->get('payment_Method');
        $delegate=$request->get('delegate');
        $executor=$request->get('executor');
        $user=$request->get('user');
        $shipping_Company=$request->get('shipping_Company');
        $types=$request->get('types');



            $items=Sales::where('Delete',0)->where('Edit',0)->whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })

                ->paginate(40);



            $Total_Qty=Sales::where('Delete',0)->where('Edit',0)->whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })
                ->get()->sum('Total_Qty');



            $Total_Discount=Sales::where('Delete',0)->where('Edit',0)->whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })

                ->get()->sum('Total_Discount');


            $Total_Tax=Sales::where('Delete',0)->where('Edit',0)->whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })
                ->get()->sum('Total_Taxes');


            $Total_TaxT=Sales::where('Delete',0)->where('Edit',0)->whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })

                ->get()->sum('ProfitTax');



            $Total_Bills=Sales::where('Delete',0)->where('Edit',0)->whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })

                ->get()->sum('Total_Price');


            $Total_Paid=Sales::where('Delete',0)->where('Edit',0)->whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })

                ->get()->sum('Pay');


            $Total_Return=ReturnSales::where('Delete',0)->where('Edit',0)->whereBetween('Date',[$from,$to])
                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })



                ->get()->sum('Total_Return_Value');



            $Bills_Nums=Sales::where('Delete',0)->where('Edit',0)->whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })

                ->count();

            $TotalTax= $Total_Tax + $Total_TaxT ;
            $Total_Net= ($TotalTax + $Total_Bills) - $Total_Discount ;

            $Total_Return_Without=ReturnWithoutBill::where('Delete',0)->

            when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })



                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Vendor', $client);
                })



                ->whereBetween('Date',[$from,$to])
                ->get()->sum('Total_Price');


            $Total_Return_Without_Cost=ReturnWithoutBill::where('Delete',0)->
            when(!empty($delegate), function ($query) use ($delegate) {
                return $query->whereIn('Delegate', $delegate);
            })



                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Vendor', $client);
                })



                ->whereBetween('Date',[$from,$to])
                ->get()->sum('Total_Cost');



        $data=SalesBillsApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'Total_Qty'=>$Total_Qty,
            'Total_Discount'=>$Total_Discount,
            'Total_Bills'=>$Total_Bills,
            'Total_Return'=>$Total_Return,
            'Bills_Nums'=>$Bills_Nums,
            'TotalTax'=>$TotalTax,
            'Total_Net'=>$Total_Net,
            'Total_Return_Without'=>$Total_Return_Without,
            'Total_Return_Without_Cost'=>$Total_Return_Without_Cost,

        ];

        return $data->additional($x) ;


    }


//GroupsSalesApi
    public function GroupsSalesApi(Request $request){
        $lang = $request->header('lang', '');
        $From = $request->get('From');
        $To = $request->get('To');
        $Group = $request->get('Group');

        $Group_Name=ItemsGroups::find($Group);
        $Sales=ProductSales::
        whereRelation('Sales', function ($query) use ($From,$To) {
            return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

        })
            ->whereRelation('Product','Group',$Group)
            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->distinct(['Product_Code'])
            ->paginate(100);


        $qty=ProductSales::
        whereRelation('Product','Group',$Group)
            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->whereRelation('Sales', function ($query) use ($From,$To) {
                return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

            })
            ->get()->sum('Qty');

        $tot=ProductSales::
        whereRelation('Product','Group',$Group)
            ->whereRelation('Sales', function ($query) use ($From,$To) {
                return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

            })
            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->get()->sum('Total_Net');


        if($lang == 'ar' ){
            $xName=$Group_Name->Name;

        }else{
            $xName=$Group_Name->Name;

        }


        $data=GroupsSalesApiResources::collection($Sales);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_qty'=>$qty,
            'total_price'=>$tot,
            'name'=>$xName,


        ];

        return $data->additional($x) ;




    }

//BrandsSalesApi
    public function BrandsSalesApi(Request $request){
        $lang = $request->header('lang', '');
        $From = $request->get('From');
        $To = $request->get('To');
        $Brand = $request->get('Brand');

        $Group_Name=Brands::find($Brand);
        $Sales=ProductSales::

        whereRelation('Sales', function ($query) use ($From,$To) {
            return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

        })

            ->whereRelation('Product','Brand',$Brand)
            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->distinct(['Product_Code'])
            ->get();


        $qty=ProductSales::
        whereRelation('Product','Brand',$Brand)

            ->whereRelation('Sales', function ($query) use ($From,$To) {
                return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

            })
            ->get()->sum('Qty');

        $tot=ProductSales::
        whereRelation('Product','Brand',$Brand)
            ->whereRelation('Sales', function ($query) use ($From,$To) {
                return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

            })
            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->get()->sum('Total_Net');


        if($lang == 'ar' ){
            $xName=$Group_Name->Name;

        }else{
            $xName=$Group_Name->Name;

        }

        $data=BrandSalesApiResources::collection($Sales);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_qty'=>$qty,
            'total_price'=>$tot,
            'name'=>$xName,


        ];

        return $data->additional($x) ;




    }

//SalesCustomersGroupsFilterApi
        public function SalesCustomersGroupsFilterApi(Request $request){
        $lang = $request->header('lang', '');
            $From=$request->get('From');
            $To=$request->get('To');
            $group=$request->get('group');
            $Client=$request->get('Client');

            $G=ItemsGroups::find($group);

            $Customers=Customers::
            when(!empty($Client), function ($query) use ($Client) {
                return $query->whereIn('Account',$Client);

            })

                ->paginate(100);

        $data=SalesCustomersGroupsFilterApiResources::collection($Customers);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'group'=>$G->Name,


        ];

        return $data->additional($x) ;




    }


//NetSalesApi

    public function NetSalesApi(Request $request){


        $search = $request->get('search');
        $From = $request->get('From');
        $To = $request->get('To');
        $Client = $request->get('Client');
        $Executor = $request->get('Executor');
        $Coin = $request->get('Coin');
        $Safe = $request->get('Safe');
        $Payment_Method = $request->get('Payment_Method');
        $Cost_Center = $request->get('Cost_Center');
        $Delegate = $request->get('Delegate');
        $User = $request->get('User');
        $group = $request->get('group');
        $Store = $request->get('Store');
        $Type = $request->get('Type');
        $Code = $request->get('Code');


        $Purchs=ProductSales::whereBetween('Date', [$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })

            ->when(!empty($Executor), function ($query) use ($Executor) {
                return $query->whereRelation('Sales','Executor',$Executor);

            })

            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->whereRelation('Sales','Coin',$Coin);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales','Payment_Method',$Payment_Method);

            })


            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->whereRelation('Sales','Cost_Center',$Cost_Center);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->whereRelation('Sales','User',$User);

            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Sales','Store',$Store);

            })

            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->whereRelation('Sales','Type',$Type);

            })

            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales','Code',$Code);

            })



            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")

                    ;

            })


            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->paginate(30);


        $PCount=ProductSales::whereBetween('Date', [$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })

            ->when(!empty($Executor), function ($query) use ($Executor) {
                return $query->whereRelation('Sales','Executor',$Executor);

            })

            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->whereRelation('Sales','Coin',$Coin);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales','Payment_Method',$Payment_Method);

            })


            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->whereRelation('Sales','Cost_Center',$Cost_Center);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->whereRelation('Sales','User',$User);

            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Sales','Store',$Store);

            })

            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->whereRelation('Sales','Type',$Type);

            })

            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales','Code',$Code);

            })



            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")

                    ;

            })


            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->count();
        $PRCount=ReturnSalesProducts::whereBetween('Date', [$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->where('Client',$Client);

            })

            ->when(!empty($Executor), function ($query) use ($Executor) {
                return $query->where('Executor',$Executor);

            })


            ->when(!empty($Coin), function ($query) use ($Coin) {
                return $query->where('Coin',$Coin);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->where('Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->where('Payment_Method',$Payment_Method);

            })


            ->when(!empty($Cost_Center), function ($query) use ($Cost_Center) {
                return $query->where('Cost_Center',$Cost_Center);

            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->where('Delegate',$Delegate);

            })

            ->when(!empty($User), function ($query) use ($User) {
                return $query->where('User',$User);

            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })

            ->when(!empty($Type), function ($query) use ($Type) {
                return $query->where('Type',$Type);

            })

            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->where('Code',$Code);

            })



            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")

                    ;

            })



            ->count();
        $data=NetSalesFilterApiResources::collection($Purchs);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'Sales_Count'=>$PCount,
            'Sales_Return_Count'=>$PRCount,




        ];

        return $data->additional($x) ;


    }

//TotalNetSalesApi
    public function TotalNetSalesApi(Request $request){

        $search = $request->get('search');
        $From = $request->get('From');
        $To = $request->get('To');
        $group = $request->get('group');
        $Store = $request->get('Store');


        $Purchs=ProductSales::

        when(!empty($search), function ($query) use ($search) {
            return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                ->orWhere('V_Name','ILIKE', "%{$search}%")
                ->orWhere('VV_Name','ILIKE', "%{$search}%")
                ->orWhere('Product_Code','ILIKE', "%{$search}%")
                ;
        })


            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })
            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereRelation('Product','Group',$group);

            })
            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->whereBetween('Date', [$From,$To])

            ->paginate(50);


        $ProdsCount=ProductSales::orderBy('id','asc')
            ->when(!empty($search), function ($query) use ($search) {
                return $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                    ->orWhere('P_En_Name','ILIKE', "%{$search}%")
                    ->orWhere('V_Name','ILIKE', "%{$search}%")
                    ->orWhere('VV_Name','ILIKE', "%{$search}%")
                    ->orWhere('Product_Code','ILIKE', "%{$search}%")


                    ;
            })
            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->where('Store',$Store);

            })
            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereRelation('Product','Group',$group);

            })
            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->whereBetween('Date', [$From,$To])
            ->count();



        $DiscountOnBill=Sales::whereBetween('Date', [$From,$To])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('DiscountBill');

        $data=TotalNetSalesApiResources::collection($Purchs);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'Purchases_Count'=>$ProdsCount,
            'Discount_On_Bill'=>$DiscountOnBill,


        ];

        return $data->additional($x) ;


    }

//StoresSalesDetailsApi
    public function StoresSalesDetailsApi(Request $request){
        $lang = $request->header('lang', '');
        $From = $request->get('From');
        $To = $request->get('To');
        $Client = $request->get('Store');

        $qty=ProductSales::

        when(!empty($From), function ($query) use ($From,$To) {
            return $query->whereBetween('Date',[$From,$To]);

        })

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->where('Store',$Client);

            })

            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->get()->sum('Qty');
        $tot=ProductSales::

        when(!empty($From), function ($query) use ($From,$To) {
            return $query->whereBetween('Date',[$From,$To]);

        })

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->where('Store',$Client);

            })

            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->get()->sum('Total_Net');

        $Sales=ProductSales::

        when(!empty($From), function ($query) use ($From,$To) {
            return $query->whereBetween('Date',[$From,$To]);

        })

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->where('Store',$Client);

            })

            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->get();



        $cust=Stores::find($Client);

        if(!empty($cust)){
            if($lang == 'ar' ){
                $cName=$cust->Name;

            }else{
                $cName=$cust->NameEn;

            }
        }else{

            $cName='';

        }



        $data=StoresSalesDetailsApiResources::collection($Sales);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_qty'=>$qty,
            'total_price'=>$tot,
            'name'=>$cName,


        ];

        return $data->additional($x) ;




    }

//InstallmentCompaniesSalesApi
        public function InstallmentCompaniesSalesApi(Request $request){

        $from=$request->get('from');
        $to=$request->get('to');
        $branch=$request->get('branch');
        $clients_Group=$request->get('clients_Group');
        $cost_Center=$request->get('cost_Center');
        $coin=$request->get('coin');
        $code=$request->get('code');
        $refrence_Number=$request->get('refrence_Number');
        $shift_Code=$request->get('shift_Code');
        $store=$request->get('store');
        $safe=$request->get('safe');
        $client=$request->get('client');
        $payment_Method=$request->get('payment_Method');
        $delegate=$request->get('delegate');
        $executor=$request->get('executor');
        $user=$request->get('user');
        $shipping_Company=$request->get('shipping_Company');
        $types=$request->get('types');
        $installCompany=$request->get('installCompany');
        $contractNumber=$request->get('contractNumber');
        $payFees=$request->get('payFees');



            $items=Sales::whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })

                ->when(!empty($installCompany), function ($query) use ($installCompany) {
                    return $query->whereIn('InstallCompany', $installCompany);
                })

                ->when(!empty($contractNumber), function ($query) use ($contractNumber) {
                    return $query->where('ContractNumber', $contractNumber);
                })

                ->when(!empty($payFees), function ($query) use ($payFees) {
                    return $query->where('PayFees', $payFees);
                })
                ->where('Edit',1)->where('Delete',1)
                ->paginate(10);



            $colum=InstallCompaniesSalesBillsColumnsSechdule::orderBy('id','desc')->first();


            $Total_Qty=Sales::whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })


                ->when(!empty($installCompany), function ($query) use ($installCompany) {
                    return $query->whereIn('InstallCompany', $installCompany);
                })

                ->when(!empty($contractNumber), function ($query) use ($contractNumber) {
                    return $query->where('ContractNumber', $contractNumber);
                })

                ->when(!empty($payFees), function ($query) use ($payFees) {
                    return $query->where('PayFees', $payFees);
                })
                ->where('Edit',1)->where('Delete',1)
                ->get()->sum('Total_Qty');



            $Total_Discount=Sales::whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })

                ->when(!empty($installCompany), function ($query) use ($installCompany) {
                    return $query->whereIn('InstallCompany', $installCompany);
                })

                ->when(!empty($contractNumber), function ($query) use ($contractNumber) {
                    return $query->where('ContractNumber', $contractNumber);
                })

                ->when(!empty($payFees), function ($query) use ($payFees) {
                    return $query->where('PayFees', $payFees);
                })
                ->where('Edit',1)->where('Delete',1)
                ->get()->sum('Total_Discount');


            $Total_Tax=Sales::whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })

                ->when(!empty($installCompany), function ($query) use ($installCompany) {
                    return $query->whereIn('InstallCompany', $installCompany);
                })

                ->when(!empty($contractNumber), function ($query) use ($contractNumber) {
                    return $query->where('ContractNumber', $contractNumber);
                })

                ->when(!empty($payFees), function ($query) use ($payFees) {
                    return $query->where('PayFees', $payFees);
                })
                ->where('Edit',1)->where('Delete',1)
                ->get()->sum('Total_Taxes');


            $Total_TaxT=Sales::whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })

                ->when(!empty($installCompany), function ($query) use ($installCompany) {
                    return $query->whereIn('InstallCompany', $installCompany);
                })

                ->when(!empty($contractNumber), function ($query) use ($contractNumber) {
                    return $query->where('ContractNumber', $contractNumber);
                })

                ->when(!empty($payFees), function ($query) use ($payFees) {
                    return $query->where('PayFees', $payFees);
                })
                ->where('Edit',1)->where('Delete',1)
                ->get()->sum('ProfitTax');



            $Total_Bills=Sales::whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })

                ->when(!empty($installCompany), function ($query) use ($installCompany) {
                    return $query->whereIn('InstallCompany', $installCompany);
                })

                ->when(!empty($contractNumber), function ($query) use ($contractNumber) {
                    return $query->where('ContractNumber', $contractNumber);
                })

                ->when(!empty($payFees), function ($query) use ($payFees) {
                    return $query->where('PayFees', $payFees);
                })
                ->where('Edit',1)->where('Delete',1)
                ->get()->sum('Total_Price');





            $Bills_Nums=Sales::whereBetween('Date',[$from,$to])

                ->when(!empty($branch), function ($query) use ($branch) {
                    return $query->where('Branch', $branch);
                })


                ->when(!empty($clients_Group), function ($query) use ($clients_Group) {
                    return $query->where('CustomerGroup', $clients_Group);
                })

                ->when(!empty($cost_Center), function ($query) use ($cost_Center) {
                    return $query->where('Cost_Center', $cost_Center);
                })


                ->when(!empty($coin), function ($query) use ($coin) {
                    return $query->where('Coin', $coin);
                })


                ->when(!empty($code), function ($query) use ($code) {
                    return $query->where('Code', $code);
                })


                ->when(!empty($shift_Code), function ($query) use ($shift_Code) {
                    return $query->where('Shift_Code', $shift_Code);
                })


                ->when(!empty($refrence_Number), function ($query) use ($refrence_Number) {
                    return $query->where('Refernce_Number', $refrence_Number);
                })


                ->when(!empty($store), function ($query) use ($store) {
                    return $query->whereIn('Store', $store);
                })



                ->when(!empty($safe), function ($query) use ($safe) {
                    return $query->whereIn('Safe', $safe);
                })

                ->when(!empty($client), function ($query) use ($client) {
                    return $query->whereIn('Client', $client);
                })


                ->when(!empty($payment_Method), function ($query) use ($payment_Method) {
                    return $query->whereIn('Payment_Method', $payment_Method);
                })


                ->when(!empty($delegate), function ($query) use ($delegate) {
                    return $query->whereIn('Delegate', $delegate);
                })


                ->when(!empty($executor), function ($query) use ($executor) {
                    return $query->whereIn('Executor', $executor);
                })


                ->when(!empty($user), function ($query) use ($user) {
                    return $query->whereIn('User', $user);
                })

                ->when(!empty($shipping_Company), function ($query) use ($shipping_Company) {
                    return $query->whereIn('Ship', $shipping_Company);
                })

                ->when(!empty($types), function ($query) use ($types) {
                    return $query->whereIn('Status', $types);
                })


                ->when(!empty($installCompany), function ($query) use ($installCompany) {
                    return $query->whereIn('InstallCompany', $installCompany);
                })

                ->when(!empty($contractNumber), function ($query) use ($contractNumber) {
                    return $query->where('ContractNumber', $contractNumber);
                })

                ->when(!empty($payFees), function ($query) use ($payFees) {
                    return $query->where('PayFees', $payFees);
                })
                ->count();

            $TotalTax= $Total_Tax + $Total_TaxT ;
            $Total_Net= ($TotalTax + $Total_Bills) - $Total_Discount ;



        $data=SalesBillsApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'Total_Qty'=>$Total_Qty,
            'Total_Discount'=>$Total_Discount,
            'Total_Bills'=>$Total_Bills,
            'Bills_Nums'=>$Bills_Nums,
            'TotalTax'=>$TotalTax,
            'Total_Net'=>$Total_Net,


        ];

        return $data->additional($x) ;


    }


//SalesProsGroupMoreDetailsApi
    public function SalesProsGroupMoreDetailsApi(Request $request){
        $lang = $request->header('lang', '');
        $From = $request->get('From');
        $To = $request->get('To');
        $Client = $request->get('Client');
        $Store = $request->get('Store');
        $Delegate = $request->get('Delegate');
        $Executor = $request->get('Executor');
        $Group = $request->get('Group');

        $Products=Products::

        when(!empty($Group), function ($query) use ($Group) {
            return $query->where('Group', $Group);
        })

            ->paginate(100);



        $data=SalesProsGroupMoreDetailsApiResources::collection($Products);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),


        ];

        return $data->additional($x) ;




    }

//SalesProsBrandsMoreDetailsApi
    public function SalesProsBrandsMoreDetailsApi(Request $request){
        $lang = $request->header('lang', '');
        $From = $request->get('From');
        $To = $request->get('To');
        $Client = $request->get('Client');
        $Store = $request->get('Store');
        $Delegate = $request->get('Delegate');
        $Executor = $request->get('Executor');
        $Brand = $request->get('Brand');

        $Products=Products::

        when(!empty($Brand), function ($query) use ($Brand) {
            return $query->where('Brand', $Brand);
        })

            ->paginate(100);


        $data=SalesProsBrandMoreDetailsApiResources::collection($Products);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),


        ];

        return $data->additional($x) ;




    }

//ClientSalesApi
    public function ClientSalesApi(Request $request){
        $lang = $request->header('lang', '');
        $From = $request->get('From');
        $To = $request->get('To');
        $Client = $request->get('Client');
        $Group = $request->get('Group');

        $qty=ProductSales::

        when(!empty($From), function ($query) use ($From,$To) {
            return $query->whereBetween('Date',[$From,$To]);

        })

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })
            ->when(!empty($Group), function ($query) use ($Group) {
                return $query->whereRelation('Product','Group',$Group);

            })
            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->get()->sum('Qty');
        $tot=ProductSales::

        when(!empty($From), function ($query) use ($From,$To) {
            return $query->whereBetween('Date',[$From,$To]);

        })

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })
            ->when(!empty($Group), function ($query) use ($Group) {
                return $query->whereRelation('Product','Group',$Group);

            })
            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->get()->sum('Total_Net');

        $Sales=ProductSales::

        when(!empty($From), function ($query) use ($From,$To) {
            return $query->whereBetween('Date',[$From,$To]);

        })

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })
            ->when(!empty($Group), function ($query) use ($Group) {
                return $query->whereRelation('Product','Group',$Group);

            })
            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->paginate(100);


        $grb=ItemsGroups::find($Group);
        $cust=AcccountingManual::find($Client);

        if(!empty($grb)){
            if($lang == 'ar' ){
                $xName=$grb->Name;

            }else{
                $xName=$grb->NameEn;

            }
        }else{

            $xName='';

        }

        if(!empty($cust)){
            if($lang == 'ar' ){
                $cName=$cust->Name;

            }else{
                $cName=$cust->NameEn;

            }
        }else{

            $cName='';

        }


        $data=ClientSalesApiResources::collection($Sales);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_qty'=>$qty,
            'total_price'=>$tot,
            'group_name'=>$xName,
            'client_name'=>$cName,


        ];

        return $data->additional($x) ;




    }

//ExecutorSalesApi
        public function ExecutorSalesApi(Request $request){
        $lang = $request->header('lang', '');
        $From = $request->get('From');
        $To = $request->get('To');
            $Emp = $request->get('Emp');
        $Group = $request->get('Group');

            $qty=ProductSales::

            when(!empty($From), function ($query) use ($From,$To) {
                return $query->whereBetween('Date',[$From,$To]);

            })

                ->when(!empty($Emp), function ($query) use ($Emp) {
                    return $query->whereRelation('Sales','Executor',$Emp);

                })
                ->when(!empty($Group), function ($query) use ($Group) {
                    return $query->whereRelation('Product','Group',$Group);

                })
                ->whereRelation('Sales','Edit',0)
                ->whereRelation('Sales','Delete',0)
                ->get()->sum('Qty');
            $tot=ProductSales::

            when(!empty($From), function ($query) use ($From,$To) {
                return $query->whereBetween('Date',[$From,$To]);

            })

                ->when(!empty($Emp), function ($query) use ($Emp) {
                    return $query->whereRelation('Sales','Executor',$Emp);

                })
                ->when(!empty($Group), function ($query) use ($Group) {
                    return $query->whereRelation('Product','Group',$Group);

                })
                ->whereRelation('Sales','Edit',0)
                ->whereRelation('Sales','Delete',0)
                ->get()->sum('Total_Net');

            $Sales=ProductSales::

            when(!empty($From), function ($query) use ($From,$To) {
                return $query->whereBetween('Date',[$From,$To]);

            })

                ->when(!empty($Emp), function ($query) use ($Emp) {
                    return $query->whereRelation('Sales','Executor',$Emp);

                })
                ->when(!empty($Group), function ($query) use ($Group) {
                    return $query->whereRelation('Product','Group',$Group);

                })
                ->whereRelation('Sales','Edit',0)
                ->whereRelation('Sales','Delete',0)
                ->paginate(100);


            $grb=ItemsGroups::find($Group);
            $cust=Employess::find($Emp);

            if(!empty($grb)){
                if($lang == 'ar' ){
                    $xName=$grb->Name;

                }else{
                    $xName=$grb->NameEn;

                }
            }else{

                $xName='';

            }

            if(!empty($cust)){
                if($lang == 'ar' ){
                    $cName=$cust->Name;

                }else{
                    $cName=$cust->NameEn;

                }
            }else{

                $cName='';

            }

        $data=ClientSalesApiResources::collection($Sales);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
            'total_qty'=>$qty,
            'total_price'=>$tot,
            'group_name'=>$xName,
            'emp_name'=>$cName,


        ];

        return $data->additional($x) ;




    }


//ProductSalesGroupsReportApi
        public function ProductSalesGroupsReportApi(Request $request){
        $lang = $request->header('lang', '');
            $From = $request->get('From');
            $To = $request->get('To');
            $Group = $request->get('Group');

            $items=ItemsGroups::whereIn('id',$Group)->get();

        $data=ProductSalesGroupsReportApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),



        ];

        return $data->additional($x) ;




    }

//ProductSalesBrandsReportApi
    public function ProductSalesBrandsReportApi(Request $request){
        $lang = $request->header('lang', '');
        $From = $request->get('From');
        $To = $request->get('To');
        $Brand = $request->get('Brand');

        $items=Brands::whereIn('id',$Brand)->get();

        $data=ProductSalesGroupsReportApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),



        ];

        return $data->additional($x) ;




    }



    //=====


    //EditDeleteBillReportApi
    public function EditDeleteBillReportApi(Request $request){
        $lang = $request->header('lang', '');
        $from = $request->get('from');
        $to = $request->get('to');
        $Store = $request->get('Store');
        $Account = $request->get('Account');
        $Delegate = $request->get('Delegate');
        $Safe = $request->get('Safe');
        $Coin = $request->get('Coin');
        $User = $request->get('User');
        $Type = $request->get('Type');
        $sort = $request->get('sort');

        if($Type == 2) {

            $items = Purchases::where('Status', 1)


                ->whereBetween('Date', [$from, $to])
                ->when(!empty($Safe), function ($query) use ($Safe) {
                    return $query->where('Safe', $Safe);

                })
                ->when(!empty($Account), function ($query) use ($Account) {
                    return $query->where('Vendor', $Account);

                })
                ->when(!empty($Coin), function ($query) use ($Coin) {
                    return $query->where('Coin', $Coin);

                })
                ->when(!empty($User), function ($query) use ($User) {
                    return $query->where('User', $User);

                })
                ->when(!empty($Delegate), function ($query) use ($Delegate) {
                    return $query->where('Delegate', $Delegate);

                })
                ->when(!empty($Store), function ($query) use ($Store) {
                    return $query->where('Store', $Store);

                })
                ->where($sort,'1')


                ->paginate(50);
        }else{


            $items = Sales::where('Status', 1)

                ->where($sort,'1')


                ->whereBetween('Date', [$from, $to])
                ->when(!empty($Safe), function ($query) use ($Safe) {
                    return $query->where('Safe', $Safe);

                })
                ->when(!empty($Account), function ($query) use ($Account) {
                    return $query->where('Client', $Account);

                })
                ->when(!empty($Coin), function ($query) use ($Coin) {
                    return $query->where('Coin', $Coin);

                })
                ->when(!empty($User), function ($query) use ($User) {
                    return $query->where('User', $User);

                })
                ->when(!empty($Delegate), function ($query) use ($Delegate) {
                    return $query->where('Delegate', $Delegate);

                })
                ->when(!empty($Store), function ($query) use ($Store) {
                    return $query->where('Store', $Store);

                })



                ->paginate(50);


        }


        $data=EditDeleteBillReportApiResources::collection($items);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;




    }

//UserLogApi
        public function UserLogApi(Request $request){
        $lang = $request->header('lang', '');
            $from = $request->get('from');
            $to = $request->get('to');
            $sort = $request->get('sort');
            $user = $request->get('user');
            $Screen = $request->get('Screen');

            if($user != ''){

                $u= 'User' ;
                $uR=  $user;
                $uName= "where" ;

            }else{

                $u= 'id' ;
                $uR=  'asc' ;
                $uName=   "orderBy" ;
            }

            if($Screen != ''){

                $SS= 'Screen' ;
                $SSR=  $Screen;
                $SSName= "where" ;

            }else{

                $SS= 'id' ;
                $SSR=  'asc' ;
                $SSName=   "orderBy" ;
            }


            if($sort != ''){

                $t= 'Type' ;
                $tR=  $sort;
                $tName= "where" ;

            }else{

                $t= 'id' ;
                $tR=  'asc' ;
                $tName=   "orderBy" ;
            }

            if($from != '' and $to != ''){

                $d= 'Date' ;
                $dR=  [$from, $to];
                $dName= "whereBetween" ;

            }elseif($from != '' and $to == ''){

                $d= 'Date' ;
                $dR=  [$from, date('Y-m-d')];
                $dName= "whereBetween" ;


            }elseif($from == '' and $to != ''){

                $d= 'Date' ;
                $dR=  [ '1-1-2020' , $to];
                $dName= "whereBetween" ;


            }elseif($from == '' and $to == ''){

                $d= 'id' ;
                $dR=  'asc' ;
                $dName=   "orderBy" ;
            }

            $Prods=UsersMoves::orderBY('id','asc')
                ->$uName($u,$uR)
                ->$tName($t,$tR)
                ->$dName($d,$dR)
                ->$SSName($SS,$SSR)
                ->paginate(100);



            $data=UserLogApiResources::collection($Prods);
        $x=[
            'status'=>200,
            'msg'=>trans('admin.Success'),
        ];

        return $data->additional($x) ;




    }





}
