<?php

namespace App\Console\Commands;

use App\Models\Investors;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use DB ;
use DateTime;

class DueInvestors extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'Investors:Due';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Investors:Due';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        try {

            DB::beginTransaction();
            \App\Events\InvestorsDue::dispatch();
            DB::commit();

        }catch(\Exception $ex){

            $MODEL=Investors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Investors::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }
}
